/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageConverterExtractor<T>
implements ResponseExtractor<T> {
    private final Class<T> responseType;
    private final List<HttpMessageConverter<?>> messageConverters;

    public HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(responseType, (String)"'responseType' must not be null");
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.responseType = responseType;
        this.messageConverters = messageConverters;
    }

    @Override
    public T extractData(ClientHttpResponse response) throws IOException {
        MediaType contentType = response.getHeaders().getContentType();
        if (contentType == null) {
            throw new RestClientException("Cannot extract response: no Content-Type found");
        }
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            if (!messageConverter.canRead(this.responseType, contentType)) continue;
            return (T)messageConverter.read(this.responseType, response);
        }
        throw new RestClientException("Could not extract response: no suitable HttpMessageConverter found for response type [" + this.responseType.getName() + "] and content type [" + contentType + "]");
    }
}

