/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class TypeVariableReferenceType
extends BoundedReferenceType
implements TypeVariableReference {
    private TypeVariable typeVariable;
    private boolean resolvedIfBounds = false;
    boolean fixedUp = false;

    public TypeVariableReferenceType(TypeVariable aTypeVariable, World aWorld) {
        super(aTypeVariable.getGenericSignature(), aTypeVariable.getErasureSignature(), aWorld);
        this.typeVariable = aTypeVariable;
        this.isExtends = false;
        this.isSuper = false;
    }

    public ReferenceTypeDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(new BoundedReferenceType.ReferenceTypeReferenceTypeDelegate((ReferenceType)this.typeVariable.getFirstBound()));
        }
        return this.delegate;
    }

    public UnresolvedType getUpperBound() {
        if (this.typeVariable == null) {
            return super.getUpperBound();
        }
        return this.typeVariable.getUpperBound();
    }

    public UnresolvedType getFirstBound() {
        if (this.typeVariable == null) {
            return super.getUpperBound();
        }
        return this.typeVariable.getFirstBound();
    }

    public UnresolvedType getLowerBound() {
        return this.typeVariable.getLowerBound();
    }

    private void setAdditionalInterfaceBoundsFromTypeVar() {
        if (this.typeVariable.getAdditionalInterfaceBounds() == null) {
            return;
        }
        UnresolvedType[] ifBounds = this.typeVariable.getAdditionalInterfaceBounds();
        this.additionalInterfaceBounds = new ReferenceType[ifBounds.length];
        for (int i = 0; i < ifBounds.length; ++i) {
            this.additionalInterfaceBounds[i] = (ReferenceType)ifBounds[i].resolve(this.getWorld());
        }
    }

    public UnresolvedType parameterize(Map typeBindings) {
        UnresolvedType ut = (UnresolvedType)typeBindings.get(this.getName());
        if (ut != null) {
            return this.world.resolve(ut);
        }
        return this;
    }

    public ReferenceType[] getAdditionalBounds() {
        if (!this.resolvedIfBounds) {
            this.setAdditionalInterfaceBoundsFromTypeVar();
            this.resolvedIfBounds = true;
        }
        return super.getAdditionalBounds();
    }

    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    public boolean isTypeVariableReference() {
        return true;
    }

    public String toString() {
        return this.typeVariable.getName();
    }

    public boolean isGenericWildcard() {
        return false;
    }

    public boolean isAnnotation() {
        World world = ((ReferenceType)this.getUpperBound()).getWorld();
        ResolvedType annotationType = ResolvedType.ANNOTATION.resolve(world);
        if (this.getUpperBound() != null && ((ReferenceType)this.getUpperBound()).isAnnotation()) {
            return true;
        }
        ReferenceType[] ifBounds = this.getAdditionalBounds();
        for (int i = 0; i < ifBounds.length; ++i) {
            if (ifBounds[i].isAnnotation()) {
                return true;
            }
            if (ifBounds[i] != annotationType) continue;
            return true;
        }
        return false;
    }

    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(this.typeVariable.getName());
        sb.append(";");
        return sb.toString();
    }

    public void write(DataOutputStream s) throws IOException {
        super.write(s);
    }
}

