/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.proxy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.interceptor.OpenWebBeansEjbInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBeanProxyHandler
implements MethodHandler,
Serializable,
Externalizable {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(EjbBeanProxyHandler.class);
    private BaseEjbBean<?> ejbBean;
    private Object dependentEJB;
    private boolean isDependent = false;
    private CreationalContext<?> creationalContext;
    private WebBeansContext webBeansContext;

    public EjbBeanProxyHandler() {
    }

    public EjbBeanProxyHandler(BaseEjbBean<?> ejbBean, CreationalContext<?> creationalContext) {
        this.ejbBean = ejbBean;
        if (ejbBean.getWebBeansContext().getWebBeansUtil().isScopeTypeNormal(ejbBean.getScope())) {
            this.initiateBeanBag((OwbBean<Object>)ejbBean, (CreationalContext<Object>)creationalContext);
        } else {
            this.creationalContext = creationalContext;
        }
        if (ejbBean.getScope().equals(Dependent.class)) {
            this.isDependent = true;
            this.dependentEJB = null;
        }
        this.webBeansContext = ejbBean.getWebBeansContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxyInstance, Method method, Method proceed, Object[] arguments) throws Exception {
        Object result = null;
        String methodName = method.getName();
        if (ClassUtil.isObjectMethod((String)methodName) && !methodName.equals("toString")) {
            if (this.logger.wblWillLogTrace()) {
                this.logger.trace("Calling method on proxy is restricted except Object.toString(), but current method is Object. [{0}]", new Object[]{methodName});
            }
            if (!method.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
            }
            return proceed.invoke(proxyInstance, arguments);
        }
        try {
            Object webbeansInstance = null;
            OpenWebBeansEjbInterceptor.setThreadLocal(this.ejbBean, this.getContextualCreationalContext());
            Context webbeansContext = this.webBeansContext.getBeanManagerImpl().getContext(this.ejbBean.getScope());
            if (this.isDependent && this.dependentEJB != null) {
                webbeansInstance = this.dependentEJB;
            } else {
                webbeansInstance = webbeansContext.get(this.ejbBean);
                if (webbeansInstance == null) {
                    webbeansInstance = webbeansContext.get(this.ejbBean, this.getContextualCreationalContext());
                }
                if (this.isDependent && webbeansInstance != null) {
                    this.dependentEJB = webbeansInstance;
                    if (this.ejbBean.getEjbType().equals((Object)SessionBeanType.STATEFUL)) {
                        this.ejbBean.addDependentSFSB(webbeansInstance, proxyInstance);
                    }
                }
            }
            if (this.ejbBean.isDependent() && this.ejbBean.getEjbType().equals((Object)SessionBeanType.STATEFUL) && this.checkEjbRemoveMethod(method)) {
                this.ejbBean.removeDependentSFSB(proxyInstance);
            }
            if (!method.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
            }
            result = method.invoke(webbeansInstance, arguments);
        }
        finally {
            OpenWebBeansEjbInterceptor.unsetThreadLocal();
        }
        return result;
    }

    private boolean checkEjbRemoveMethod(Method method) {
        List<Method> removeMethods = this.ejbBean.getRemoveMethods();
        if (removeMethods.contains(method)) {
            if (this.ejbBean.getScope() != Dependent.class) {
                throw new UnsupportedOperationException("Can not call EJB Statefull Bean Remove Method without scoped @Dependent");
            }
            return true;
        }
        return false;
    }

    protected CreationalContext<Object> getContextualCreationalContext() {
        AbstractContext owbContext;
        if (this.creationalContext != null) {
            return this.creationalContext;
        }
        BaseEjbBean<?> contextual = this.ejbBean;
        Context webbeansContext = this.webBeansContext.getBeanManagerImpl().getContext(this.ejbBean.getScope());
        CreationalContext cc = null;
        if (webbeansContext instanceof AbstractContext && (cc = (owbContext = (AbstractContext)webbeansContext).getCreationalContext(contextual)) == null) {
            cc = this.webBeansContext.getCreationalContextFactory().getCreationalContext(contextual);
            owbContext.initContextualBag(this.ejbBean, cc);
        }
        return cc;
    }

    private void initiateBeanBag(OwbBean<Object> bean, CreationalContext<Object> creationalContext) {
        Context webbeansContext = this.webBeansContext.getBeanManagerImpl().getContext(bean.getScope());
        if (webbeansContext instanceof AbstractContext) {
            AbstractContext owbContext = (AbstractContext)webbeansContext;
            owbContext.initContextualBag(bean, creationalContext);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        String passivationId = this.ejbBean.getId();
        if (passivationId != null) {
            s.writeObject(passivationId);
        } else {
            s.writeObject(null);
            if (this.logger.wblWillLogWarn()) {
                this.logger.warn("WARN_0015", new Object[]{this.ejbBean});
            }
        }
        s.writeBoolean(this.isDependent);
        s.writeObject(this.creationalContext);
        s.writeObject(this.dependentEJB);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String passivationId = (String)s.readObject();
        if (passivationId != null) {
            this.ejbBean = (BaseEjbBean)this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(passivationId);
        }
        this.isDependent = s.readBoolean();
        this.creationalContext = (CreationalContext)s.readObject();
        this.dependentEJB = s.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String passivationId = this.ejbBean.getId();
        if (passivationId != null) {
            out.writeObject(passivationId);
        } else {
            out.writeObject(null);
            if (this.logger.wblWillLogWarn()) {
                this.logger.warn("WARN_0015", new Object[]{this.ejbBean});
            }
        }
        out.writeBoolean(this.isDependent);
        out.writeObject(this.creationalContext);
        out.writeObject(this.dependentEJB);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String passivationId = (String)in.readObject();
        if (passivationId != null) {
            this.ejbBean = (BaseEjbBean)this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(passivationId);
        }
        this.isDependent = in.readBoolean();
        this.creationalContext = (CreationalContext)in.readObject();
        this.dependentEJB = in.readObject();
    }
}

