/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.jsf.support;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.OWBInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirgoJsfInjectionProvider
implements InjectionProvider {
    private final Logger logger;
    private static final String COMP_ENV = "java:comp/env/";
    private Context namingContext;

    public VirgoJsfInjectionProvider() {
        block2: {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.namingContext = null;
            try {
                this.namingContext = new InitialContext();
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Injection of naming resources into JSF managed beans disabled.", (Throwable)e);
            }
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        block7: {
            block6: {
                try {
                    OWBInjector.inject((BeanManager)WebBeansContext.currentInstance().getBeanManagerImpl(), (Object)managedBean, null);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block6;
                    this.logger.error("Failed to invoke OWBInjector for managedBean '" + managedBean.toString() + "', will fallback to manual processing", (Throwable)e);
                }
            }
            if (this.namingContext != null) {
                try {
                    Class<?> currentBeanClass = managedBean.getClass();
                    while (currentBeanClass != null) {
                        this.processFields(managedBean, currentBeanClass);
                        this.processMethods(managedBean, currentBeanClass);
                        currentBeanClass = currentBeanClass.getSuperclass();
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block7;
                    this.logger.error("Failed to inject managed bean in FacesServlet", (Throwable)e);
                }
            }
        }
    }

    private void processMethods(Object managedBean, Class<?> currentBeanClass) throws NamingException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Method[] methodArray = methods = currentBeanClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String lookupName;
            Resource annotation;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Resource.class)) {
                annotation = method.getAnnotation(Resource.class);
                lookupName = COMP_ENV + annotation.name();
                if (annotation.lookup() != null && !annotation.lookup().equals("")) {
                    lookupName = annotation.lookup();
                }
                this.lookupMethodResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), method, lookupName);
            }
            if (method.isAnnotationPresent(EJB.class)) {
                annotation = method.getAnnotation(EJB.class);
                lookupName = COMP_ENV + annotation.name();
                if (annotation.lookup() != null && !annotation.lookup().equals("")) {
                    lookupName = annotation.lookup();
                }
                this.lookupMethodResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), method, lookupName);
            }
            if (method.isAnnotationPresent(PersistenceContext.class)) {
                annotation = method.getAnnotation(PersistenceContext.class);
                this.lookupMethodResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), method, annotation.name());
            }
            if (method.isAnnotationPresent(PersistenceUnit.class)) {
                annotation = method.getAnnotation(PersistenceUnit.class);
                this.lookupMethodResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), method, annotation.name());
            }
            ++n2;
        }
    }

    private void processFields(Object managedBean, Class<?> currentBeanClass) throws NamingException, IllegalAccessException {
        Field[] fields = currentBeanClass.getDeclaredFields();
        if (fields != null) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String lookupName;
                Resource annotation;
                Field field = fieldArray[n2];
                if (field.isAnnotationPresent(Resource.class)) {
                    annotation = field.getAnnotation(Resource.class);
                    lookupName = COMP_ENV + annotation.name();
                    if (annotation.lookup() != null && !annotation.lookup().equals("")) {
                        lookupName = annotation.lookup();
                    }
                    this.lookupFieldResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), field, lookupName);
                }
                if (field.isAnnotationPresent(EJB.class)) {
                    annotation = field.getAnnotation(EJB.class);
                    lookupName = COMP_ENV + annotation.name();
                    if (annotation.lookup() != null && !annotation.lookup().equals("")) {
                        lookupName = annotation.lookup();
                    }
                    this.lookupFieldResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), field, lookupName);
                }
                if (field.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = field.getAnnotation(PersistenceContext.class);
                    this.lookupFieldResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), field, annotation.name());
                }
                if (field.isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = field.getAnnotation(PersistenceUnit.class);
                    this.lookupFieldResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), field, annotation.name());
                }
                if (field.getAnnotations().length == 0) {
                    try {
                        this.lookupFieldResource(this.namingContext, managedBean, currentBeanClass.getCanonicalName(), field, null);
                    }
                    catch (NameNotFoundException nameNotFoundException) {}
                }
                ++n2;
            }
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        Method postConstruct = this.findAnnotatedMethod(managedBean, PostConstruct.class);
        if (postConstruct != null) {
            boolean accessibility = postConstruct.isAccessible();
            postConstruct.setAccessible(true);
            try {
                try {
                    postConstruct.invoke(managedBean, new Object[0]);
                }
                catch (Exception e) {
                    throw new InjectionProviderException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                postConstruct.setAccessible(accessibility);
            }
        }
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        Method preDestroy = this.findAnnotatedMethod(managedBean, PreDestroy.class);
        if (preDestroy != null) {
            boolean accessibility = preDestroy.isAccessible();
            preDestroy.setAccessible(true);
            try {
                try {
                    preDestroy.invoke(managedBean, new Object[0]);
                }
                catch (Exception e) {
                    throw new InjectionProviderException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                preDestroy.setAccessible(accessibility);
            }
        }
    }

    private Method findAnnotatedMethod(Object managedBean, Class<? extends Annotation> annotation) {
        Method result = null;
        Class<?> currentClass = managedBean.getClass();
        while (currentClass != null) {
            Method[] methods;
            Method[] methodArray = methods = currentClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(annotation)) {
                    if (result != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                        throw new IllegalArgumentException("Invalid annotation " + annotation.getName());
                    }
                    result = method;
                    break;
                }
                ++n2;
            }
            if (result != null) break;
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    protected void lookupFieldResource(Context context, Object instance, String beanClassName, Field field, String name) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 && name.length() > COMP_ENV.length() ? context.lookup(name) : context.lookup(this.getFullyQualifiedName(String.valueOf(beanClassName) + "/" + field.getName()));
        if (lookedupResource != null) {
            if (this.logger.isDebugEnabled()) {
                Object oldValue = field.get(instance);
                this.logger.debug("Overriding old value '" + oldValue + "' for field '" + field + "' with new value '" + lookedupResource + "'");
            }
            accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, lookedupResource);
            field.setAccessible(accessibility);
        } else if (this.logger.isDebugEnabled()) {
            Object oldValue = field.get(instance);
            this.logger.debug("No resource found from lookup => did not override old value '" + oldValue + "' for field '" + field + "'");
        }
    }

    protected void lookupMethodResource(Context context, Object instance, String beanClassName, Method method, String name) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = null;
        boolean accessibility = false;
        if (name != null && name.length() > 0 && name.length() > COMP_ENV.length()) {
            lookedupResource = context.lookup(name);
        } else {
            String fieldName = method.getName().substring(3);
            String firstChar = String.valueOf(fieldName.charAt(0));
            fieldName = fieldName.replaceFirst(firstChar, firstChar.toLowerCase());
            lookedupResource = context.lookup(this.getFullyQualifiedName(String.valueOf(beanClassName) + "/" + fieldName));
        }
        if (lookedupResource != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking method '" + method + "' with looked value '" + lookedupResource + "'");
            }
            accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, lookedupResource);
            method.setAccessible(accessibility);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("No resource found from lookup => did not invoke method '" + method + "'");
        }
    }

    private String getFullyQualifiedName(String name) {
        return COMP_ENV + name;
    }
}

