/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class ScrollBarLCAUtil {
    private static final String TYPE = "rwt.widgets.ScrollBar";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL"};
    private static final String PROP_VISIBILITY = "visibility";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    private ScrollBarLCAUtil() {
    }

    public static void preserveValues(Scrollable scrollable) {
        ScrollBarLCAUtil.preserveValues(scrollable.getHorizontalBar());
        ScrollBarLCAUtil.preserveValues(scrollable.getVerticalBar());
    }

    private static void preserveValues(ScrollBar scrollBar) {
        if (scrollBar != null) {
            WidgetLCAUtil.preserveProperty((Widget)scrollBar, PROP_VISIBILITY, scrollBar.getVisible());
            WidgetLCAUtil.preserveListener(scrollBar, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(scrollBar, 13));
        }
    }

    public static void renderInitialization(Scrollable scrollable) {
        ScrollBarLCAUtil.renderCreate(scrollable.getHorizontalBar());
        ScrollBarLCAUtil.renderCreate(scrollable.getVerticalBar());
    }

    private static void renderCreate(ScrollBar scrollBar) {
        if (scrollBar != null) {
            RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(scrollBar, TYPE);
            remoteObject.set("parent", WidgetUtil.getId(scrollBar.getParent()));
            remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(scrollBar, ALLOWED_STYLES)));
        }
    }

    public static void renderChanges(Scrollable scrollable) {
        ScrollBarLCAUtil.renderChanges(scrollable.getHorizontalBar());
        ScrollBarLCAUtil.renderChanges(scrollable.getVerticalBar());
        ScrollBarLCAUtil.markInitialized(scrollable);
    }

    private static void renderChanges(ScrollBar scrollBar) {
        if (scrollBar != null) {
            WidgetLCAUtil.renderProperty((Widget)scrollBar, PROP_VISIBILITY, scrollBar.getVisible(), false);
            WidgetLCAUtil.renderListener(scrollBar, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(scrollBar, 13), false);
        }
    }

    static void markInitialized(Scrollable scrollable) {
        ScrollBar vScroll;
        ScrollBar hScroll = scrollable.getHorizontalBar();
        if (hScroll != null) {
            ScrollBarLCAUtil.getAdapter(hScroll).setInitialized(true);
        }
        if ((vScroll = scrollable.getVerticalBar()) != null) {
            ScrollBarLCAUtil.getAdapter(vScroll).setInitialized(true);
        }
    }

    public static void processSelectionEvent(Scrollable scrollable) {
        ScrollBarLCAUtil.processSelectionEvent(scrollable.getHorizontalBar());
        ScrollBarLCAUtil.processSelectionEvent(scrollable.getVerticalBar());
    }

    private static void processSelectionEvent(ScrollBar scrollBar) {
        if (scrollBar != null && WidgetLCAUtil.wasEventSent(scrollBar, PROP_SELECTION_LISTENER)) {
            scrollBar.notifyListeners(13, new Event());
        }
    }

    private static WidgetAdapterImpl getAdapter(ScrollBar scrollBar) {
        return (WidgetAdapterImpl)WidgetUtil.getAdapter(scrollBar);
    }
}

