/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public final class JAXBContextFactory {
    private static final Logger log = Logger.getLogger(JAXBContextFactory.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)s);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s, ClassLoader classLoader) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)s, (ClassLoader)classLoader);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)s, (ClassLoader)classLoader, properties);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(Class ... classes) throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        Event event = Event.start(sb.toString());
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(Class[] classes, Map<String, ?> properties) throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        Event event = Event.start(sb.toString());
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes, properties);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    private static class Event {
        protected final long start = System.nanoTime();
        private final String description;

        private Event(String description) {
            this.description = description;
        }

        public static Event start(String description) {
            return new Event(description);
        }

        public void stop() {
            log.log(Level.FINE, String.format("JAXBContext.newInstance %s  %s", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start), this.description));
        }
    }
}

