/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.PackageGenerator;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.DatabaseReconnectWizardPage;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizardPage;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class GenerateEntitiesWizard
extends Wizard {
    private PersistenceProject persistenceProject;
    private IStructuredSelection selection;
    private DatabaseReconnectWizardPage dbSettingsPage;
    private GenerateEntitiesWizardPage generateEntitiesPage;
    private PackageGenerator.Config packageGeneratorConfig;
    private EntityGenerator.Config entityGeneratorConfig;
    private Collection selectedTables;

    public GenerateEntitiesWizard(PersistenceProject persistenceProject, IStructuredSelection selection) {
        this.persistenceProject = persistenceProject;
        this.selection = selection;
        this.packageGeneratorConfig = new PackageGenerator.Config();
        this.entityGeneratorConfig = new EntityGenerator.Config();
        this.setWindowTitle(DaliUiMessages.GenerateEntitiesWizard_generateEntities);
    }

    public void addPages() {
        super.addPages();
        if (!this.persistenceProjectIsConnected()) {
            this.dbSettingsPage = new DatabaseReconnectWizardPage(this.persistenceProject);
            this.addPage((IWizardPage)this.dbSettingsPage);
        }
        this.generateEntitiesPage = new GenerateEntitiesWizardPage();
        this.addPage((IWizardPage)this.generateEntitiesPage);
        this.generateEntitiesPage.init(this.selection);
    }

    public boolean performFinish() {
        this.packageGeneratorConfig.setPackageFragment(this.buildPackageFragment());
        this.entityGeneratorConfig.setConvertToCamelCase(this.generateEntitiesPage.convertToCamelCase());
        this.entityGeneratorConfig.setFieldAccessType(this.generateEntitiesPage.fieldAccessType());
        this.entityGeneratorConfig.setCollectionTypeName(this.generateEntitiesPage.getCollectionTypeName());
        this.entityGeneratorConfig.setFieldVisibility(this.generateEntitiesPage.getFieldVisibility());
        this.entityGeneratorConfig.setMethodVisibility(this.generateEntitiesPage.getMethodVisibility());
        this.entityGeneratorConfig.setGenerateGettersAndSetters(this.generateEntitiesPage.generateGettersAndSetters());
        this.entityGeneratorConfig.setGenerateDefaultConstructor(this.generateEntitiesPage.generateDefaultConstructor());
        this.entityGeneratorConfig.setSerializable(this.generateEntitiesPage.serializable());
        this.entityGeneratorConfig.setGenerateSerialVersionUID(this.generateEntitiesPage.generateSerialVersionUID());
        this.entityGeneratorConfig.setGenerateEmbeddedIdForCompoundPK(this.generateEntitiesPage.generateEmbeddedIdForCompoundPK());
        this.entityGeneratorConfig.setOverrideEntityNames(this.generateEntitiesPage.getOverrideEntityNames());
        this.selectedTables = this.generateEntitiesPage.getSelectedTables();
        return true;
    }

    private IPackageFragment buildPackageFragment() {
        IPackageFragmentRoot packageFragmentRoot = this.generateEntitiesPage.getPackageFragmentRoot();
        IPackageFragment packageFragment = this.generateEntitiesPage.getPackageFragment();
        if (packageFragment == null) {
            packageFragment = packageFragmentRoot.getPackageFragment("");
        }
        if (packageFragment.exists()) {
            return packageFragment;
        }
        try {
            return packageFragmentRoot.createPackageFragment(packageFragment.getElementName(), true, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    Collection getPossibleTables() {
        if (this.dbSettingsPage != null) {
            return this.dbSettingsPage.getTables();
        }
        return CollectionTools.collection((Iterator)this.persistenceProject.getSchema().tables());
    }

    public PackageGenerator.Config getPackageGeneratorConfig() {
        return this.packageGeneratorConfig;
    }

    public EntityGenerator.Config getEntityGeneratorConfig() {
        return this.entityGeneratorConfig;
    }

    public Collection getSelectedTables() {
        return this.selectedTables;
    }

    public boolean canFinish() {
        boolean canFinish = true;
        if (!this.generateEntitiesPage.isPageComplete()) {
            canFinish = false;
        }
        return canFinish;
    }

    private boolean persistenceProjectIsConnected() {
        String connectionName = this.persistenceProject.getConnectionName();
        Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(connectionName);
        return connection.isConnected();
    }

    void updatePossibleTables(Collection possibleTables) {
        this.generateEntitiesPage.updateTablesListViewer(possibleTables);
    }
}

