/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.hosts.GitHosts;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.SystemReader;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class RepositoryInitializer {
    private IPreferencesService preferencesService;
    private ServiceRegistration<RepositoryCache> registration;
    private IEclipsePreferences gitCorePreferences;
    private IEclipsePreferences.IPreferenceChangeListener prefsListener;

    @Reference
    void setPreferencesService(IPreferencesService service) {
        this.preferencesService = service;
    }

    @Reference
    void setWorkspace(IWorkspace workspace) {
    }

    @Activate
    void start() {
        try {
            RepositoryInitializer.reconfigureWindowCache(this.preferencesService);
        }
        catch (ExceptionInInitializerError | RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
        this.gitCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        GitHosts.loadFromPreferences(this.gitCorePreferences);
        this.updateTextBufferSize();
        this.prefsListener = event -> {
            if ("core_git_servers".equals(event.getKey())) {
                GitHosts.loadFromPreferences(this.gitCorePreferences);
            }
            if ("core_textbuffersize".equals(event.getKey())) {
                this.updateTextBufferSize();
            }
        };
        this.gitCorePreferences.addPreferenceChangeListener(this.prefsListener);
        this.registration = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(RepositoryCache.class, (Object)RepositoryCache.INSTANCE, null);
    }

    @Deactivate
    void shutDown() {
        this.registration.unregister();
        if (this.gitCorePreferences != null) {
            if (this.prefsListener != null) {
                this.gitCorePreferences.removePreferenceChangeListener(this.prefsListener);
                this.prefsListener = null;
            }
            this.gitCorePreferences = null;
        }
        RepositoryUtil.INSTANCE.clear();
        IndexDiffCache.INSTANCE.dispose();
        RepositoryCache.INSTANCE.clear();
    }

    private void updateTextBufferSize() {
        int bufferSize = this.preferencesService.getInt("org.eclipse.egit.core", "core_textbuffersize", -1, null);
        if (bufferSize >= 0) {
            RawText.setBufferSize((int)Math.min(bufferSize, 131072));
        }
    }

    public static void reconfigureWindowCache() {
        RepositoryInitializer.reconfigureWindowCache(Platform.getPreferencesService());
    }

    private static void reconfigureWindowCache(IPreferencesService prefs) {
        WindowCacheConfig c = new WindowCacheConfig();
        c.setPackedGitLimit((long)prefs.getInt("org.eclipse.egit.core", "core_packedGitLimit", 0, null));
        c.setPackedGitWindowSize(prefs.getInt("org.eclipse.egit.core", "core_packedGitWindowSize", 0, null));
        if (SystemReader.getInstance().isWindows()) {
            c.setPackedGitMMAP(false);
        } else {
            c.setPackedGitMMAP(prefs.getBoolean("org.eclipse.egit.core", "core_packedGitMMAP", false, null));
        }
        c.setDeltaBaseCacheLimit(prefs.getInt("org.eclipse.egit.core", "core_deltaBaseCacheLimit", 0, null));
        c.setStreamFileThreshold(prefs.getInt("org.eclipse.egit.core", "core_streamFileThreshold", 0, null));
        c.setExposeStatsViaJmx(false);
        c.install();
    }
}

