/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class LanguageServiceAccessor {
    private static Set<LanguageServerWrapper> startedServers = new HashSet<LanguageServerWrapper>();
    private static Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> providersToLSDefinitions = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStartedServers() {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            startedServers.forEach(LanguageServerWrapper::stop);
            startedServers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull List<CompletableFuture<LanguageServer>> getInitializedLanguageServers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            Collection<LanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(file, request);
            return wrappers.stream().map(wrapper -> wrapper.getInitializedServer().thenApplyAsync(server -> {
                try {
                    wrapper.connect(file, null);
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
                return server;
            })).collect(Collectors.toList());
        }
    }

    public static void disableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition) {
        IContentType contentType;
        Optional<LanguageServerWrapper> result = startedServers.stream().filter(server -> server.serverDefinition.equals(contentTypeToLSDefinition.getValue())).findFirst();
        if (result.isPresent() && (contentType = (IContentType)contentTypeToLSDefinition.getKey()) != null) {
            result.get().disconnectContentType(contentType);
        }
    }

    public static void enableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition, @NonNull IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                if (editor.getEditorInput() instanceof FileEditorInput) {
                    IFile editorFile = ((FileEditorInput)editor.getEditorInput()).getFile();
                    IContentType contentType = (IContentType)contentTypeToLSDefinition.getKey();
                    LanguageServersRegistry.LanguageServerDefinition lsDefinition = (LanguageServersRegistry.LanguageServerDefinition)contentTypeToLSDefinition.getValue();
                    IContentDescription contentDesc = editorFile.getContentDescription();
                    if (contentTypeToLSDefinition.isEnabled() && contentType != null && contentDesc != null && contentType.equals(contentDesc.getContentType()) && lsDefinition != null) {
                        try {
                            LanguageServiceAccessor.getInitializedLanguageServer(editorFile, lsDefinition, (ServerCapabilities capabilities) -> true);
                        }
                        catch (IOException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
            }
            ++n2;
        }
    }

    @Deprecated
    public static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), lsDefinition, file.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            wrapper.connect(file, null);
            return wrapper.getServer();
        }
        return null;
    }

    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), lsDefinition, file.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            wrapper.connect(file, null);
            return wrapper.getInitializedServer();
        }
        return null;
    }

    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        IPath initialPath = LSPEclipseUtils.toPath(document);
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(document, lsDefinition, initialPath);
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            wrapper.connect(document);
            return wrapper.getInitializedServer();
        }
        return null;
    }

    private static boolean capabilitiesComply(LanguageServerWrapper wrapper, Predicate<ServerCapabilities> capabilitiesPredicate) {
        return capabilitiesPredicate == null || wrapper.getServerCapabilities() == null || capabilitiesPredicate.test(wrapper.getServerCapabilities());
    }

    public static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        LinkedHashSet<LanguageServerWrapper> res = new LinkedHashSet<LanguageServerWrapper>();
        IProject project = file.getProject();
        if (project == null) {
            return res;
        }
        res.addAll(LanguageServiceAccessor.getMatchingStartedWrappers(file, request));
        LinkedList<IContentType> contentTypes = new LinkedList<IContentType>();
        HashSet<IContentType> addedContentTypes = new HashSet<IContentType>();
        contentTypes.addAll(LSPEclipseUtils.getFileContentTypes(file));
        addedContentTypes.addAll(contentTypes);
        while (!contentTypes.isEmpty()) {
            IContentType contentType = (IContentType)contentTypes.poll();
            if (contentType == null) continue;
            for (ContentTypeToLanguageServerDefinition mapping : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                LanguageServerWrapper wrapper;
                if (mapping == null || mapping.getValue() == null || !mapping.isEnabled() || !LanguageServiceAccessor.capabilitiesComply(wrapper = LanguageServiceAccessor.getLSWrapperForConnection(project, (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue(), file.getFullPath()), request)) continue;
                res.add(wrapper);
            }
            if (contentType.getBaseType() == null || addedContentTypes.contains(contentType.getBaseType())) continue;
            addedContentTypes.add(contentType.getBaseType());
            contentTypes.add(contentType.getBaseType());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IDocument document) {
        LinkedHashSet<LanguageServerWrapper> res = new LinkedHashSet<LanguageServerWrapper>();
        IFile file = LSPEclipseUtils.getFile(document);
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return Collections.emptyList();
        }
        Path path = new Path(uri.getPath());
        LinkedList<IContentType> contentTypes = new LinkedList<IContentType>();
        HashSet<IContentType> processedContentTypes = new HashSet<IContentType>();
        contentTypes.addAll(LSPEclipseUtils.getDocumentContentTypes(document));
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            res.addAll(startedServers.stream().filter(wrapper -> {
                try {
                    return wrapper.isConnectedTo(uri) || LanguageServersRegistry.getInstance().matches(document, wrapper.serverDefinition);
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                    return false;
                }
            }).filter(wrapper -> wrapper.canOperate(document)).collect(Collectors.toList()));
            while (!contentTypes.isEmpty()) {
                IContentType contentType = (IContentType)contentTypes.poll();
                if (contentType == null || processedContentTypes.contains(contentType)) continue;
                for (ContentTypeToLanguageServerDefinition mapping : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                    LanguageServersRegistry.LanguageServerDefinition serverDefinition;
                    if (mapping == null || !mapping.isEnabled() || (serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue()) == null || startedServers.stream().anyMatch(wrapper -> wrapper.serverDefinition.equals(serverDefinition) && wrapper.canOperate(document))) continue;
                    IProject fileProject = file != null ? file.getProject() : null;
                    LanguageServerWrapper wrapper2 = fileProject != null ? new LanguageServerWrapper(fileProject, serverDefinition) : new LanguageServerWrapper(serverDefinition, (IPath)path);
                    startedServers.add(wrapper2);
                    res.add(wrapper2);
                }
                if (contentType.getBaseType() != null) {
                    contentTypes.add(contentType.getBaseType());
                }
                processedContentTypes.add(contentType);
            }
            return res;
        }
    }

    @Deprecated
    public static LanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        return LanguageServiceAccessor.getLSWrapperForConnection(project, serverDefinition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static LanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        LanguageServerWrapper wrapper = null;
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            for (LanguageServerWrapper startedWrapper : LanguageServiceAccessor.getStartedLSWrappers(project)) {
                if (!startedWrapper.serverDefinition.equals(serverDefinition)) continue;
                wrapper = startedWrapper;
                break;
            }
            if (wrapper == null) {
                wrapper = project != null ? new LanguageServerWrapper(project, serverDefinition) : new LanguageServerWrapper(serverDefinition, initialPath);
                wrapper.start();
            }
            startedServers.add(wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LanguageServerWrapper getLSWrapperForConnection(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        LanguageServerWrapper wrapper = null;
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            for (LanguageServerWrapper startedWrapper : LanguageServiceAccessor.getStartedLSWrappers(document)) {
                if (!startedWrapper.serverDefinition.equals(serverDefinition)) continue;
                wrapper = startedWrapper;
                break;
            }
            if (wrapper == null) {
                wrapper = new LanguageServerWrapper(serverDefinition, initialPath);
                wrapper.start();
            }
            startedServers.add(wrapper);
        }
        return wrapper;
    }

    private static @NonNull List<LanguageServerWrapper> getStartedLSWrappers(@NonNull IProject project) {
        return LanguageServiceAccessor.getStartedLSWrappers((LanguageServerWrapper wrapper) -> wrapper.canOperate(project));
    }

    private static @NonNull List<LanguageServerWrapper> getStartedLSWrappers(@NonNull IDocument document) {
        return LanguageServiceAccessor.getStartedLSWrappers((LanguageServerWrapper wrapper) -> wrapper.canOperate(document));
    }

    private static @NonNull List<LanguageServerWrapper> getStartedLSWrappers(@NonNull Predicate<LanguageServerWrapper> predicate) {
        return startedServers.stream().filter(predicate).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<LanguageServerWrapper> getMatchingStartedWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            return startedServers.stream().filter(wrapper -> wrapper.isActive() && wrapper.isConnectedTo(file.getLocationURI()) || LanguageServersRegistry.getInstance().matches(file, wrapper.serverDefinition) && wrapper.canOperate(file.getProject())).filter(wrapper -> request == null || wrapper.getServerCapabilities() == null || request.test(wrapper.getServerCapabilities())).collect(Collectors.toList());
        }
    }

    public static @NonNull List<@NonNull LanguageServer> getActiveLanguageServers(Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(null, request, true);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(project, request, false);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@Nullable IProject project, Predicate<ServerCapabilities> request, boolean onlyActiveLS) {
        ArrayList<@NonNull LanguageServer> serverInfos = new ArrayList<LanguageServer>();
        for (LanguageServerWrapper wrapper : startedServers) {
            LanguageServer server;
            if (onlyActiveLS && !wrapper.isActive() || project != null && !wrapper.canOperate(project) || (server = wrapper.getServer()) == null || !LanguageServiceAccessor.capabilitiesComply(wrapper, request)) continue;
            serverInfos.add(server);
        }
        return serverInfos;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getLSDefinition(@NonNull StreamConnectionProvider provider) {
        return providersToLSDefinitions.get(provider);
    }

    public static @NonNull List<@NonNull LSPDocumentInfo> getLSPDocumentInfosFor(@NonNull IDocument document, @NonNull Predicate<ServerCapabilities> capabilityRequest) {
        URI fileUri = LSPEclipseUtils.toUri(document);
        ArrayList<LSPDocumentInfo> res = new ArrayList<LSPDocumentInfo>();
        try {
            LanguageServiceAccessor.getLSWrappers(document).stream().filter(wrapper -> wrapper.getServerCapabilities() == null || capabilityRequest.test(wrapper.getServerCapabilities())).forEach(wrapper -> {
                try {
                    wrapper.connect(document);
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
                res.add(new LSPDocumentInfo(fileUri, document, (LanguageServerWrapper)wrapper));
            });
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }

    public static @NonNull CompletableFuture<List<@NonNull LanguageServer>> getLanguageServers(@NonNull IDocument document, Predicate<ServerCapabilities> filter) {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<@NonNull E> res = Collections.synchronizedList(new ArrayList());
        try {
            return CompletableFuture.allOf((CompletableFuture[])LanguageServiceAccessor.getLSWrappers(document).stream().map(wrapper -> ((CompletableFuture)wrapper.getInitializedServer().thenComposeAsync(server -> {
                if (server != null && (filter == null || filter.test(wrapper.getServerCapabilities()))) {
                    try {
                        return wrapper.connect(document);
                    }
                    catch (IOException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                }
                return CompletableFuture.completedFuture(null);
            })).thenAccept(server -> {
                if (server != null) {
                    res.add(server);
                }
            })).toArray(CompletableFuture[]::new)).thenApply(theVoid -> res);
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    public static boolean checkCapability(LanguageServer languageServer, Predicate<ServerCapabilities> condition) {
        return startedServers.stream().filter(wrapper -> wrapper.isActive() && wrapper.getServer() == languageServer).anyMatch(wrapper -> condition.test(wrapper.getServerCapabilities()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<LanguageServersRegistry.LanguageServerDefinition> resolveServerDefinition(LanguageServer languageServer) {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            return startedServers.stream().filter(wrapper -> languageServer.equals(wrapper.getServer())).findFirst().map(wrapper -> wrapper.serverDefinition);
        }
    }

    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull LanguageServerWrapper wrapper;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        @Deprecated
        public LanguageServer getLanguageClient() {
            try {
                return this.wrapper.getInitializedServer().get();
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
                return this.wrapper.getServer();
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return this.wrapper.getServer();
            }
        }

        public int getVersion() {
            return this.wrapper.getVersion(this.fileUri);
        }

        public CompletableFuture<LanguageServer> getInitializedLanguageClient() {
            return this.wrapper.getInitializedServer();
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }

    @FunctionalInterface
    private static interface ServerSupplier {
        public LanguageServerWrapper get() throws IOException;
    }
}

