/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.telnet.terminal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EOFDetectingInputStreamWrapper
extends FilterInputStream {
    private boolean fEOF = false;

    public EOFDetectingInputStreamWrapper(InputStream origStream) {
        super(origStream);
    }

    public synchronized boolean isEOF() {
        return this.fEOF;
    }

    public synchronized void setEOF(boolean eof) {
        this.fEOF = eof;
    }

    public int read() throws IOException {
        try {
            int result = this.in.read();
            if (result < 0) {
                this.setEOF(true);
            }
            return result;
        }
        catch (IOException e) {
            this.setEOF(true);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.setEOF(true);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result = this.in.read(b, off, len);
            if (result < 0) {
                this.setEOF(true);
            }
            return result;
        }
        catch (IOException e) {
            this.setEOF(true);
            throw e;
        }
    }
}

