/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.shells.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.DummyHost;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.ui.propertypages.ServicesPropertyPage;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public class ShellServicesPropertyPage
extends ServicesPropertyPage {
    private IShellServiceSubSystemConfiguration _currentFactory;

    protected ShellServiceSubSystem getShellServiceSubSystem() {
        return (ShellServiceSubSystem)this.getElement();
    }

    protected ServiceElement[] getServiceElements() {
        ShellServiceSubSystem subSystem = this.getShellServiceSubSystem();
        IShellServiceSubSystemConfiguration[] factories = null;
        IHost host = null;
        if (subSystem == null || this._currentFactory != null) {
            factories = this.getShellServiceSubSystemConfigurations(this.getSystemType());
            host = new DummyHost(this.getHostname(), this.getSystemType());
        } else {
            host = subSystem.getHost();
            this._currentFactory = (IShellServiceSubSystemConfiguration)subSystem.getParentRemoteCmdSubSystemConfiguration();
            factories = this.getShellServiceSubSystemConfigurations(host.getSystemType());
        }
        ServiceElement[] elements = new ServiceElement[factories.length];
        int i = 0;
        while (i < factories.length) {
            IShellServiceSubSystemConfiguration factory = factories[i];
            elements[i] = new FactoryServiceElement(host, (ISubSystemConfiguration)factory);
            if (factory == this._currentFactory) {
                elements[i].setSelected(true);
            }
            ++i;
        }
        return elements;
    }

    protected IShellServiceSubSystemConfiguration[] getShellServiceSubSystemConfigurations(IRSESystemType systemType) {
        ArrayList<ISubSystemConfiguration> results = new ArrayList<ISubSystemConfiguration>();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType, false);
        int i = 0;
        while (i < factories.length) {
            ISubSystemConfiguration factory = factories[i];
            if (factory instanceof IShellServiceSubSystemConfiguration) {
                results.add(factory);
            }
            ++i;
        }
        return results.toArray(new IShellServiceSubSystemConfiguration[results.size()]);
    }

    protected ISubSystemConfiguration getCurrentSubSystemConfiguration() {
        return this._currentFactory;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this._currentFactory = (IShellServiceSubSystemConfiguration)factory;
    }
}

