/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.AbstractLanguageConfigurationRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyLanguageConfigurationRegistryManager
extends AbstractLanguageConfigurationRegistryManager {
    private final ILanguageConfigurationRegistryManager manager;
    private List<ILanguageConfigurationDefinition> added;
    private List<ILanguageConfigurationDefinition> removed;

    public WorkingCopyLanguageConfigurationRegistryManager(ILanguageConfigurationRegistryManager manager) {
        this.manager = manager;
        this.load();
    }

    private void load() {
        ILanguageConfigurationDefinition[] definitions;
        ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = definitions = this.manager.getDefinitions();
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageConfigurationDefinition definition = iLanguageConfigurationDefinitionArray[n2];
            super.registerLanguageConfigurationDefinition(definition);
            ++n2;
        }
    }

    @Override
    public void registerLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.registerLanguageConfigurationDefinition(definition);
        if (this.added == null) {
            this.added = new ArrayList<ILanguageConfigurationDefinition>();
        }
        this.added.add(definition);
    }

    @Override
    public void unregisterLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.unregisterLanguageConfigurationDefinition(definition);
        if (this.removed == null) {
            this.removed = new ArrayList<ILanguageConfigurationDefinition>();
        }
        if (this.added != null) {
            this.added.remove(definition);
        } else {
            this.removed.add(definition);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (this.removed != null) {
            for (ILanguageConfigurationDefinition definition : this.removed) {
                this.manager.unregisterLanguageConfigurationDefinition(definition);
            }
        }
        if (this.added != null) {
            for (ILanguageConfigurationDefinition definition : this.added) {
                this.manager.registerLanguageConfigurationDefinition(definition);
            }
        }
        if (this.added != null || this.removed != null) {
            this.manager.save();
        }
    }
}

