/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemConnectAction
extends SystemBaseAction {
    public SystemConnectAction(Shell shell) {
        super(SystemResources.ACTION_CONNECT_LABEL, SystemResources.ACTION_CONNECT_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.setHelp("org.eclipse.rse.ui.actn0047");
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof ISubSystem && !((ISubSystem)obj).getConnectorService().isConnected();
    }

    public void run() {
        ISubSystem ss = (ISubSystem)this.getFirstSelection();
        ConnectJob job = new ConnectJob(ss);
        job.schedule();
    }

    public class ConnectJob
    extends Job {
        private ISubSystem _subsystem;

        public ConnectJob(ISubSystem subsystem) {
            super(SystemResources.ACTION_CONNECT_LABEL);
            this._subsystem = subsystem;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this._subsystem.getHost().getSystemType().isWindows()) {
                    this._subsystem.connect(monitor, false);
                } else {
                    this._subsystem.connect(monitor, true);
                }
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
            catch (SystemMessageException e) {
                SystemMessageDialog.displayMessage(e);
            }
            catch (Exception e) {
                SystemBasePlugin.logError(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName(), e);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

