/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.util.HashSet;
import java.util.Set;
import org.jsoup.nodes.Element;

class Html {
    private static final Set<String> spanElements = new HashSet<String>();

    Html() {
    }

    public static boolean isSpanElement(Element element) {
        return spanElements.contains(element.tagName().toLowerCase());
    }

    public static boolean isWhitespacePreserve(Element element) {
        if (element.tagName().equalsIgnoreCase("pre") || element.tagName().equalsIgnoreCase("code")) {
            return true;
        }
        if (element.parent() != null) {
            return Html.isWhitespacePreserve(element.parent());
        }
        return false;
    }

    static {
        spanElements.add("a");
        spanElements.add("b");
        spanElements.add("cite");
        spanElements.add("i");
        spanElements.add("em");
        spanElements.add("strong");
        spanElements.add("del");
        spanElements.add("ins");
        spanElements.add("q");
        spanElements.add("u");
        spanElements.add("sup");
        spanElements.add("sub");
        spanElements.add("span");
        spanElements.add("font");
        spanElements.add("code");
        spanElements.add("tt");
        spanElements.add("font");
    }
}

