/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.userstorage.internal.oauth.OAuthCredentialsPersistence;
import org.eclipse.userstorage.internal.oauth.ui.OAuthApplicationData;

public class AccountDetails
extends ContributionItem
implements IWorkbenchContribution {
    private OAuthCredentialsPersistence persister;
    private Collection<OAuthApplicationData> appData;
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
        IExtensionRegistry registry = (IExtensionRegistry)serviceLocator.getService(IExtensionRegistry.class);
        this.persister = OAuthCredentialsPersistence.standard();
        this.appData = OAuthApplicationData.load(registry);
    }

    public void fill(final Menu menu, int index) {
        MenuItem item;
        List<OAuthCredentialsPersistence.LinkedAccount> eclipseAccounts = this.getEclipseAccounts();
        if (!eclipseAccounts.isEmpty()) {
            item = new MenuItem(menu, 8, index++);
            item.setText("Authorized Applications");
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)menu.getShell(), (String)"org.eclipse.userstorage.ui.oauth.credentials", null, null);
                    dialog.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            for (OAuthCredentialsPersistence.LinkedAccount account : eclipseAccounts) {
                MenuItem accountItem = new MenuItem(menu, 8, index++);
                accountItem.setText("  " + this.getApplicationName(account));
                accountItem.setToolTipText(account.email);
                accountItem.setEnabled(false);
            }
        }
        item = new MenuItem(menu, 8, index++);
        item.setText("Sign Out");
        item.setToolTipText("Discard all USS logins");
        if (eclipseAccounts.isEmpty()) {
            item.setEnabled(false);
            return;
        }
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccountDetails.this.signOut();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AccountDetails.this.signOut();
            }
        });
    }

    public boolean isDynamic() {
        return true;
    }

    private void signOut() {
        this.persister.removeLinkedAccounts(this.getEclipseAccounts());
    }

    private List<OAuthCredentialsPersistence.LinkedAccount> getEclipseAccounts() {
        ArrayList<OAuthCredentialsPersistence.LinkedAccount> eclipseAccounts = new ArrayList<OAuthCredentialsPersistence.LinkedAccount>();
        OAuthCredentialsPersistence.LinkedAccount[] linkedAccountArray = this.persister.getLinkedAccounts();
        int n = linkedAccountArray.length;
        int n2 = 0;
        while (n2 < n) {
            OAuthCredentialsPersistence.LinkedAccount account = linkedAccountArray[n2];
            if ("https://accounts.eclipse.org/".equals(account.authURI)) {
                eclipseAccounts.add(account);
            }
            ++n2;
        }
        return eclipseAccounts;
    }

    private OAuthApplicationData lookup(OAuthCredentialsPersistence.LinkedAccount account) {
        for (OAuthApplicationData app : this.appData) {
            if (!account.clientId.equals(app.getClientId()) || !account.authURI.equals(app.getAuthURI())) continue;
            return app;
        }
        return null;
    }

    private String getApplicationName(OAuthCredentialsPersistence.LinkedAccount account) {
        OAuthApplicationData app = this.lookup(account);
        return app != null ? app.getApplicationName() : String.valueOf(account.authURI) + " - " + account.clientId;
    }
}

