/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.preference;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityPlugin;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.internal.dstore.security.preference.CertPropertiesDialog;
import org.eclipse.rse.internal.dstore.security.preference.CertTableContentProvider;
import org.eclipse.rse.internal.dstore.security.preference.CertTableLabelProvider;
import org.eclipse.rse.internal.dstore.security.preference.CertTableSorter;
import org.eclipse.rse.internal.dstore.security.preference.Element;
import org.eclipse.rse.internal.dstore.security.preference.KeyElement;
import org.eclipse.rse.internal.dstore.security.preference.KeyPropertiesDialog;
import org.eclipse.rse.internal.dstore.security.preference.NewCertDialog;
import org.eclipse.rse.internal.dstore.security.preference.RenameCertDialog;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificateElement;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificatePropertiesDialog;
import org.eclipse.rse.internal.dstore.security.util.GridUtil;
import org.eclipse.rse.internal.dstore.security.util.StringModifier;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UniversalSecurityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener,
SelectionListener {
    private TableViewer _viewer;
    ArrayList _tableItems = new ArrayList();
    private Button _addButton;
    private Button _removeButton;
    private Button _renameButton;
    private Button _propertiesButton;
    KeyStore _keyStore;

    public UniversalSecurityPreferencePage() {
        this.setPreferenceStore(UniversalSecurityPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.verticalSpacing = 10;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridUtil.createFill());
        Text label = new Text(composite, 8);
        label.setBackground(composite.getBackground());
        label.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_SEC_DESCRIPTION);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTableViewer(composite);
        Composite buttons = new Composite(composite, 0);
        data = new GridData(768);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.initializeValues();
        SystemWidgetHelpers.setCompositeHelp((Composite)parent, (String)"org.eclipse.rse.ui.ssls0000");
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this._viewer = new TableViewer(parent, 67588);
        Table table = this._viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridUtil.createFill();
        data.heightHint = 50;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        TableColumn aliasColumn = new TableColumn(table, 16384);
        aliasColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_ALIAS_NAME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        TableColumn toColumn = new TableColumn(table, 16384);
        toColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_ISSUED_TO);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        TableColumn frmColumn = new TableColumn(table, 16384);
        frmColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_ISSUED_FROM);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        TableColumn expColumn = new TableColumn(table, 16384);
        expColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_EXPIRES);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        table.setLayout((Layout)tableLayout);
        String[] properties = new String[]{"STRING", "STRING", "STRING", "STRING"};
        this._viewer.setColumnProperties(properties);
        this._viewer.setContentProvider((IContentProvider)new CertTableContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new CertTableLabelProvider());
        this._viewer.getTable().addSelectionListener((SelectionListener)this);
        CertTableSorter.setTableSorter(this._viewer, 0, true);
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = SystemWidgetHelpers.createComposite((Composite)parent, (int)4);
        this._addButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, (String)UniversalSecurityProperties.RESID_SECURITY_ADD_LBL, (Listener)this);
        this._removeButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, (String)UniversalSecurityProperties.RESID_SECURITY_REMOVE_LBL, (Listener)this);
        this._removeButton.setEnabled(false);
        this._renameButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, (String)UniversalSecurityProperties.RESID_SECURITY_RENAME_LBL, (Listener)this);
        this._renameButton.setEnabled(false);
        this._propertiesButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, (String)UniversalSecurityProperties.RESID_SECURITY_PROPERTIES_LBL, (Listener)this);
        this._propertiesButton.setEnabled(false);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        String storePath = UniversalSecurityPlugin.getKeyStoreLocation();
        String passw = UniversalSecurityPlugin.getKeyStorePassword();
        try {
            DStoreKeyStore.persistKeyStore((KeyStore)this._keyStore, (String)storePath, (String)passw);
        }
        catch (IOException e) {
            String text = UniversalSecurityProperties.RESID_SECURITY_IO_SAVE_ERROR_;
            text = StringModifier.change(text, "%1", storePath);
            text = StringModifier.change(text, "%1", storePath);
            String msg = UniversalSecurityProperties.RESID_SECURITY_KEYSTORE_SAVE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_STORE_ERROR_;
            text = StringModifier.change(text, "%1", storePath);
            String msg = UniversalSecurityProperties.RESID_SECURITY_KEYSTORE_SAVE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_UNINIT_KEYSTORE_ERROR_;
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_KEYSTORE_SAVE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            String text = UniversalSecurityProperties.RESID_SECURITY_ALGORITHM_ERROR_;
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_KEYSTORE_SAVE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
            return false;
        }
        return true;
    }

    private void initializeValues() {
        this.noDefaultAndApplyButton();
        String storePath = UniversalSecurityPlugin.getKeyStoreLocation();
        String passw = UniversalSecurityPlugin.getKeyStorePassword();
        try {
            this._keyStore = DStoreKeyStore.getKeyStore((String)storePath, (String)passw);
            Enumeration<String> aliases = this._keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this._keyStore.getCertificate(alias);
                if (cert != null) {
                    if (!(cert instanceof X509Certificate)) continue;
                    X509CertificateElement elem = new X509CertificateElement(alias, UniversalSecurityProperties.RESID_SECURITY_TRUSTED_CERTIFICATE, (X509Certificate)cert);
                    this._tableItems.add(elem);
                    continue;
                }
                try {
                    Key key = this._keyStore.getKey(alias, passw.toCharArray());
                    KeyElement elem = new KeyElement(alias, UniversalSecurityProperties.RESID_SECURITY_KEY_ENTRY, key);
                    this._tableItems.add(elem);
                }
                catch (UnrecoverableKeyException key) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            String text = UniversalSecurityProperties.RESID_SECURITY_LOAD_IO_EXC_;
            text = StringModifier.change(text, "%1", storePath);
            String msg = UniversalSecurityProperties.RESID_SECURITY_LOAD_KEYSTORE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
        }
        catch (CertificateException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_KEY_LOAD_ERROR_;
            text = StringModifier.change(text, "%1", storePath);
            String msg = UniversalSecurityProperties.RESID_SECURITY_LOAD_KEYSTORE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
        }
        catch (KeyStoreException exc) {
            String text = UniversalSecurityProperties.RESID_SECURITY_INITIALIZE_ERROR_;
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_LOAD_KEYSTORE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
        }
        catch (NoSuchProviderException exc2) {
            String text = UniversalSecurityProperties.RESID_SECURITY_SECURITY_PROVIDER_ERROR_;
            String msg = UniversalSecurityProperties.RESID_SECURITY_INITIALIZE_ERROR_;
            msg = StringModifier.change(msg, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
        }
        catch (NoSuchAlgorithmException exc2) {
            String text = UniversalSecurityProperties.RESID_SECURITY_ALGORITHM_ERROR_;
            text = StringModifier.change(text, "%1", UniversalSecurityPlugin.getKeyStoreLocation());
            String msg = UniversalSecurityProperties.RESID_SECURITY_LOAD_KEYSTORE_ERROR_;
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)UniversalSecurityPlugin.getActiveWorkbenchShell(), (String)UniversalSecurityProperties.RESID_SECURITY_SEC_MSG, (String)msg, (IStatus)err);
        }
        this._viewer.setInput((Object)this._tableItems);
    }

    public void handleEvent(Event event) {
        boolean sel;
        IStructuredSelection elem;
        if (event.widget == this._addButton) {
            NewCertDialog dlg = new NewCertDialog(this, this.getShell());
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                this._viewer.refresh();
            }
        } else if (event.widget == this._removeButton) {
            elem = (IStructuredSelection)this._viewer.getSelection();
            if (elem.size() > 0) {
                Iterator i = elem.iterator();
                while (i.hasNext()) {
                    try {
                        Element current = (Element)i.next();
                        this._keyStore.deleteEntry(current.getAlias());
                        this._tableItems.remove(current);
                    }
                    catch (KeyStoreException current) {
                        // empty catch block
                    }
                }
                this._viewer.refresh();
            }
        } else if (event.widget == this._renameButton) {
            elem = (IStructuredSelection)this._viewer.getSelection();
            if (elem.size() == 1) {
                Element sel2 = (Element)elem.getFirstElement();
                RenameCertDialog dlg = new RenameCertDialog(this, this.getShell(), sel2.getAlias());
                dlg.open();
                if (dlg.getReturnCode() == 0) {
                    try {
                        DStoreKeyStore.addCertificateToKeyStore((KeyStore)this._keyStore, (Certificate)((Certificate)sel2.getCert()), (String)dlg.getNewAlias());
                        this._keyStore.deleteEntry(sel2.getAlias());
                        sel2.setAlias(dlg.getNewAlias());
                        this._viewer.refresh();
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
        } else if (event.widget == this._propertiesButton && (elem = (IStructuredSelection)this._viewer.getSelection()).size() == 1) {
            Element sel3 = (Element)elem.getFirstElement();
            CertPropertiesDialog dlg = null;
            dlg = sel3 instanceof X509CertificateElement ? new X509CertificatePropertiesDialog(this.getShell(), (X509CertificateElement)sel3) : new KeyPropertiesDialog(this.getShell(), (KeyElement)sel3);
            dlg.open();
        }
        this._renameButton.setEnabled(!(sel = this._viewer.getSelection().isEmpty()));
        this._removeButton.setEnabled(!sel);
        this._propertiesButton.setEnabled(!sel);
    }

    public void widgetSelected(SelectionEvent e) {
        boolean sel = this._viewer.getSelection().isEmpty();
        this._renameButton.setEnabled(!sel);
        this._removeButton.setEnabled(!sel);
        this._propertiesButton.setEnabled(!sel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

