/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.files.ui.widgets.SystemSelectRemoteFileOrFolderForm;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveAsForm
extends SystemSelectRemoteFileOrFolderForm {
    protected Text fileNameText;
    protected String fileName;
    protected String initialFileName;
    protected ValidatorFileName validator = new ValidatorFileName();

    public SaveAsForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        super(msgLine, caller, fileMode);
    }

    public Control createContents(Shell shell, Composite parent) {
        Control control = super.createContents(shell, parent);
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)2);
        this.fileNameText = SystemWidgetHelpers.createLabeledTextField((Composite)composite, null, (String)FileResources.RESID_NEWFILE_NAME_LABEL, (String)FileResources.RESID_NEWFILE_NAME_TOOLTIP);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveAsForm.this.fileName = SaveAsForm.this.fileNameText.getText();
                SaveAsForm.this.setPageComplete();
            }
        });
        if (this.fileName != null) {
            this.fileNameText.setText(this.fileName);
        }
        return control;
    }

    public boolean verify() {
        boolean ok = super.verify();
        if (ok) {
            IRemoteFile file = (IRemoteFile)this.getSelectedObject();
            IRemoteFile saveasFile = null;
            try {
                saveasFile = file.getParentRemoteFileSubSystem().getRemoteFileObject(file, this.fileName, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (saveasFile != null && saveasFile.exists()) {
                String msgTxt = NLS.bind((String)FileResources.MSG_UPLOAD_FILE_EXISTS, (Object)this.fileName);
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF5012", 2, msgTxt);
                SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
                ok = dlg.openQuestionNoException();
            }
        }
        return ok;
    }

    public boolean isPageComplete() {
        SystemMessage errMsg = this.validator.validate(this.fileName);
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        this.clearErrorMessage();
        return this.fileNameText != null && this.fileNameText.getText().length() > 0 && super.isPageComplete();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPreSelection(IRemoteFile selection) {
        if (selection.isDirectory()) {
            super.setPreSelection(selection);
        } else if (selection.isFile()) {
            IRemoteFile parentFile = selection.getParentRemoteFile();
            if (parentFile.isDirectory()) {
                super.setPreSelection(parentFile);
            }
            this.initialFileName = this.fileName = selection.getName();
        }
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter((Object)o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        super.selectionChanged(e);
        Object selectedObject = this.getFirstSelection(e.getSelection());
        if (selectedObject != null && selectedObject instanceof IRemoteFile) {
            IRemoteFile remoteFile = (IRemoteFile)selectedObject;
            ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(selectedObject);
            if (remoteAdapter != null && this.fileNameText != null) {
                Object parentFile = this.getSelectedParent();
                if (remoteFile.isFile()) {
                    this.fileName = remoteAdapter.getName(selectedObject);
                    this.fileNameText.setText(this.fileName);
                } else {
                    this.fileName = this.initialFileName;
                    if (this.fileName != null) {
                        this.fileNameText.setText(this.fileName);
                    }
                    parentFile = remoteFile;
                }
                remoteAdapter = this.getRemoteAdapter(parentFile);
                if (remoteAdapter != null) {
                    String fullPath = remoteAdapter.getAbsoluteName(parentFile);
                    this.setNameText(fullPath);
                    this.outputObjects = new Object[]{parentFile};
                    this.setPageComplete();
                }
            }
        }
    }
}

