/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.utils.MarkerConfig;
import org.eclipse.tm4e.ui.internal.utils.MarkerUtils;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;
import org.eclipse.tm4e.ui.internal.widgets.TableWithControlsWidget;
import org.osgi.service.prefs.BackingStoreException;

public final class TaskTagsPreferencePage
extends AbstractPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.TaskTagsPreferencePage";
    private final Set<MarkerConfig> markerConfigs = PreferenceHelper.loadMarkerConfigs();
    private TableWidget<MarkerConfig> markerConfigsTable = (TableWidget)((Object)NullSafetyHelper.lazyNonNull());

    public TaskTagsPreferencePage() {
        super(null, TMUIMessages.TaskTagsPreferencePage_description);
    }

    protected Control createContents(@NonNullByDefault(value={}) Composite parent) {
        this.createMarkerConfigsTable(parent);
        this.applyDialogFont(parent);
        this.markerConfigsTable.setInput(this.markerConfigs);
        return this.markerConfigsTable.getControl();
    }

    private void createMarkerConfigsTable(Composite parent) {
        TableWithControlsWidget<MarkerConfig> tableWithControls = new TableWithControlsWidget<MarkerConfig>(parent, null, true){

            @Override
            protected TableWidget<MarkerConfig> createTable(Composite parent) {
                return new TableWidget<MarkerConfig>(parent, false){

                    @Override
                    protected void createColumns() {
                        this.createAutoResizeColumn(TMUIMessages.TaskTagsPreferencePage_column_tag, new int[0]);
                        this.createAutoResizeColumn(TMUIMessages.TaskTagsPreferencePage_column_type, 0);
                        this.createAutoResizeColumn(TMUIMessages.TaskTagsPreferencePage_column_level, 0);
                    }

                    @Override
                    protected @Nullable Object getColumnText(MarkerConfig taskTag, int columnIndex) {
                        return switch (columnIndex) {
                            case 0 -> taskTag.tag;
                            case 1 -> taskTag.type.name().charAt(0) + taskTag.type.name().substring(1).toLowerCase();
                            case 2 -> {
                                switch (taskTag.type) {
                                    case PROBLEM: {
                                        yield taskTag.asProblemMarkerConfig().severity;
                                    }
                                    case TASK: {
                                        yield taskTag.asTaskMarkerConfig().priority;
                                    }
                                }
                                throw new IncompatibleClassChangeError();
                            }
                            default -> null;
                        };
                    }
                };
            }

            @Override
            protected void createButtons() {
                this.createButton(TMUIMessages.Button_new, () -> {
                    MarkerConfigEditDialog dlg = new MarkerConfigEditDialog(this.getShell(), null);
                    if (dlg.open() == 0) {
                        TaskTagsPreferencePage.this.markerConfigs.add((MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig));
                        this.table.refresh();
                        this.table.setSelection(true, (T[])new MarkerConfig[]{(MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig)});
                    }
                });
                Button editBtn = this.createButton(TMUIMessages.Button_edit, () -> {
                    MarkerConfigEditDialog dlg;
                    MarkerConfig selectedTag = (MarkerConfig)this.table.getFirstSelectedElement();
                    if (selectedTag != null && (dlg = new MarkerConfigEditDialog(this.getShell(), selectedTag)).open() == 0 && !selectedTag.equals(dlg.markerConfig)) {
                        TaskTagsPreferencePage.this.markerConfigs.remove(selectedTag);
                        TaskTagsPreferencePage.this.markerConfigs.add((MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig));
                        this.table.refresh();
                        this.table.setSelection(true, (T[])new MarkerConfig[]{(MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig)});
                    }
                });
                this.table.onSelectionChanged(sel -> editBtn.setEnabled(!sel.isEmpty()));
                Button removeBtn = this.createButton(TMUIMessages.Button_remove, () -> {
                    MarkerConfig selectedTag = (MarkerConfig)this.table.getFirstSelectedElement();
                    if (selectedTag != null) {
                        TaskTagsPreferencePage.this.markerConfigs.remove(selectedTag);
                        this.table.refresh();
                    }
                });
                this.table.onSelectionChanged(sel -> removeBtn.setEnabled(!sel.isEmpty()));
            }
        };
        tableWithControls.setLayoutData(GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(360, this.convertHeightInCharsToPixels(10)).create());
        this.markerConfigsTable = tableWithControls.getTable();
    }

    protected void performDefaults() {
        this.markerConfigs.clear();
        this.markerConfigs.addAll(MarkerConfig.getDefaults());
        this.markerConfigsTable.refresh();
    }

    public boolean performOk() {
        try {
            PreferenceHelper.saveMarkerConfigs(this.markerConfigs);
            MarkerUtils.reloadMarkerConfigs();
        }
        catch (BackingStoreException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
            return false;
        }
        return super.performOk();
    }

    private static final class MarkerConfigEditDialog
    extends TitleAreaDialog {
        @Nullable MarkerConfig markerConfig;
        Text txtTag = (Text)NullSafetyHelper.lazyNonNull();
        Combo cmbType = (Combo)NullSafetyHelper.lazyNonNull();
        Label lblLevel = (Label)NullSafetyHelper.lazyNonNull();
        Combo cmbLevel = (Combo)NullSafetyHelper.lazyNonNull();

        MarkerConfigEditDialog(Shell parentShell, @Nullable MarkerConfig markerConfig) {
            super(parentShell);
            this.markerConfig = markerConfig;
        }

        public void create() {
            super.create();
            if (this.markerConfig == null) {
                this.getShell().setText(TMUIMessages.TaskTagsPreferencePage_addTagDialog_windowTitle);
                this.setTitle(TMUIMessages.TaskTagsPreferencePage_addTagDialog_header);
                this.setMessage(TMUIMessages.TaskTagsPreferencePage_addTagDialog_message, 1);
            } else {
                this.getShell().setText(TMUIMessages.TaskTagsPreferencePage_editTagDialog_windowTitle);
                this.setTitle(TMUIMessages.TaskTagsPreferencePage_editTagDialog_header);
                this.setMessage(TMUIMessages.TaskTagsPreferencePage_editTagDialog_message, 1);
            }
            this.validateInput(null);
        }

        protected void okPressed() {
            this.markerConfig = switch (MarkerConfig.Type.valueOf(this.cmbType.getText())) {
                case MarkerConfig.Type.PROBLEM -> new MarkerConfig.ProblemMarkerConfig(this.txtTag.getText(), MarkerConfig.ProblemSeverity.valueOf(this.cmbLevel.getText()));
                case MarkerConfig.Type.TASK -> new MarkerConfig.TaskMarkerConfig(this.txtTag.getText(), MarkerConfig.TaskPriority.valueOf(this.cmbLevel.getText()));
                default -> throw new IncompatibleClassChangeError();
            };
            super.okPressed();
        }

        void validateInput(@Nullable Event e) {
            Button btn = this.getButton(0);
            if (btn == null) {
                return;
            }
            btn.setEnabled(!this.txtTag.getText().isBlank() && this.cmbType.getSelectionIndex() > -1 && this.cmbLevel.getSelectionIndex() > -1);
        }

        protected Control createDialogArea(@Nullable Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            this.createTagText(container);
            this.createTypeCombo(container);
            this.createLevel(container);
            MarkerConfig markerConfig = this.markerConfig;
            if (markerConfig != null) {
                this.txtTag.setText(markerConfig.tag);
                this.cmbType.setText(markerConfig.type.name());
                this.cmbLevel.setText(switch (markerConfig.type) {
                    case MarkerConfig.Type.PROBLEM -> markerConfig.asProblemMarkerConfig().severity.name();
                    case MarkerConfig.Type.TASK -> markerConfig.asTaskMarkerConfig().priority.name();
                    default -> throw new IncompatibleClassChangeError();
                });
            } else {
                this.cmbType.setText(MarkerConfig.Type.TASK.name());
                this.cmbLevel.setText(MarkerConfig.TaskPriority.NORMAL.name());
            }
            return area;
        }

        void createTagText(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(TMUIMessages.TaskTagsPreferencePage_column_tag);
            this.txtTag = new Text(parent, 2048);
            GridData layoutData = new GridData();
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalAlignment = 4;
            this.txtTag.setLayoutData((Object)layoutData);
            this.txtTag.addListener(24, this::validateInput);
        }

        void createTypeCombo(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(TMUIMessages.TaskTagsPreferencePage_column_type);
            this.cmbType = new Combo(parent, 8);
            this.cmbType.setItems((String[])Stream.of(MarkerConfig.Type.values()).map(Enum::name).toArray(String[]::new));
            this.cmbType.addListener(24, e -> {
                if (!this.cmbType.getText().isBlank()) {
                    switch (MarkerConfig.Type.valueOf(this.cmbType.getText())) {
                        case PROBLEM: {
                            this.lblLevel.setText("Severity");
                            this.cmbLevel.setItems((String[])Stream.of(MarkerConfig.ProblemSeverity.values()).map(Enum::name).toArray(String[]::new));
                            break;
                        }
                        case TASK: {
                            this.lblLevel.setText("Priority");
                            this.cmbLevel.setItems((String[])Stream.of(MarkerConfig.TaskPriority.values()).map(Enum::name).toArray(String[]::new));
                        }
                    }
                }
                this.validateInput(null);
            });
        }

        void createLevel(Composite parent) {
            this.lblLevel = new Label(parent, 0);
            GridData layoutData = new GridData();
            layoutData.widthHint = UI.getTextWidth("1234567890");
            layoutData.horizontalAlignment = 4;
            this.lblLevel.setLayoutData((Object)layoutData);
            this.cmbLevel = new Combo(parent, 8);
            this.cmbLevel.addListener(24, this::validateInput);
        }

        public boolean isHelpAvailable() {
            return false;
        }
    }
}

