#include <stdio.h>
#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSArray.h>

@interface GTKCListExample : GTKCList
- (void)   select:sender row:(int) row column:(int) column;
- (void) unselect:sender row:(int) row column:(int) column;
@end

@implementation GTKCListExample

- initWithColumns:(gint) columns
{
    return [self initWithTitles:columns titles:nil];
}

- initWithTitles:(gint) columns titles:(NSArray *) titles
{
    if (titles)
	[super initWithTitles:columns titles:titles];
    else
	[super initWithColumns:columns];

    [self setColumnWidth:0 width:60];	// This is ugly!
    [self setColumnWidth:1 width:60];	// Is there a better way?
    [self setColumnWidth:2 width:60];
    [self setUsize:300 height:180];
    [self setSelectionMode:GTK_SELECTION_MULTIPLE];

    [self connectSignal:@"select_row" withTarget:self
	  sel:@selector(select:row:column:)];
    [self connectSignal:@"unselect_row" withTarget:self
	  sel:@selector(unselect:row:column:)];
    return self;
}

- (void) select:sender row:(int) row column:(int) column
{
    printf("select_row: (%d,%d)\n", row, column);
}

- (void) unselect:sender row:(int) row column:(int) column
{
    printf("unselect_row: (%d,%d)\n", row, column);
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKCListExample *clist;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];

    clist = [GTKCListExample cListWithTitles:4 titles:
	[NSArray arrayWithObjects:@"One", @"Two", @"Three", @"Four", nil]];

    [clist append:
	[NSArray arrayWithObjects:@"Another", @"line", @"of", @"text", nil]];
    [clist insert:0 text:
	[NSArray arrayWithObjects:@"This", @"is a", @"line of", @"text", nil]];
    [clist append:
	[NSArray arrayWithObjects:@"This", @"is the", @"final", @"line", nil]];
    [clist insert:0 text:
	[NSArray arrayWithObjects:@"This", @"is the", @"first", @"line", nil]];

    [window borderWidth:4];
    [window add:clist];
    [window show];

    [window connectSignal:@"destroy" withAction:
	    [GTKAction actionWithTarget:GTKApp selector:@selector(terminate:)]];

    [GTKApp run];
    [pool release];
    return 0;
}
