# Autoconf macro to get GToolKit cflags/libs
# Copyright (c) 2000  Elmar Ludwig
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a configuration
# script generated by Autoconf, you may include it under the same
# distribution terms that you use for the rest of that program.

dnl AC_PATH_GTOOLKIT([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for GToolKit and define GTOOLKIT_CFLAGS and GTOOLKIT_LIBS
dnl
AC_DEFUN(AC_PATH_GTOOLKIT, [dnl
AC_REQUIRE([AM_PATH_GTK])
if test no != "$GTK_CONFIG"; then
  GTK_PREFIX=`"$GTK_CONFIG" $gtk_config_args --prefix`
fi

for gt_dir in /usr /usr/local /opt/gnome "$GTK_PREFIX" "$prefix"; do
  AC_CHECK_FILE("$gt_dir/lib/libGToolKit.la",
		gtoolkit_la=$gt_dir/lib/libGToolKit.la; break)
done

if test "$gtoolkit_la"; then
  GTOOLKIT_CFLAGS="-I$gt_dir/include $GTK_CFLAGS"
  GTOOLKIT_LIBS="-L$gt_dir/lib -lGToolKit"
  GTOOLKIT_LIBS="$GTOOLKIT_LIBS `. "$gtoolkit_la"; echo $dependency_libs`"
  ifelse([$1], , :, [$1])
else
  GTOOLKIT_CFLAGS=
  GTOOLKIT_LIBS=
  ifelse([$2], , :, [$2])
fi
AC_SUBST(GTOOLKIT_CFLAGS)
AC_SUBST(GTOOLKIT_LIBS)
])
