/*
 * FILE : ../_gtkmodule.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 2)
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/* remove swig pointer handling code */
#define SWIG_RegisterMapping(o,n,f)
#define SWIG_MakePtr(b,p,t)
#define SWIG_GetPtr(b,p,t) NULL

#define SWIG_init    init_gtk

#define SWIG_name    "_gtk"

#include <gtk/gtk.h>

typedef struct {
  PyObject_HEAD
  GtkObject *obj;
} PyGtk_Object;
static PyTypeObject *PyGtk_Type;

typedef struct {
  PyObject_HEAD
  GtkAccelGroup *obj;
} PyGtkAccelGroup_Object;
static PyTypeObject *PyGtkAccelGroup_Type;

typedef struct {
  PyObject_HEAD
  GtkStyle *obj;
} PyGtkStyle_Object;
static PyTypeObject *PyGtkStyle_Type;

typedef struct {
  PyObject_HEAD
  GdkFont *obj;
} PyGdkFont_Object;
static PyTypeObject *PyGdkFont_Type;

typedef struct {
  PyObject_HEAD
  GdkColor obj;
} PyGdkColor_Object;
static PyTypeObject *PyGdkColor_Type;

typedef struct {
  PyObject_HEAD
  GdkEvent *obj;
        PyObject *attrs;
} PyGdkEvent_Object;
static PyTypeObject *PyGdkEvent_Type;

typedef struct {
  PyObject_HEAD
  GdkWindow *obj;
} PyGdkWindow_Object;
static PyTypeObject *PyGdkWindow_Type;

typedef struct {
  PyObject_HEAD
  GdkGC *obj;
} PyGdkGC_Object;
static PyTypeObject *PyGdkGC_Type;

typedef struct {
  PyObject_HEAD
  GdkColormap *obj;
} PyGdkColormap_Object;
static PyTypeObject *PyGdkColormap_Type;

#define PyGtk_Check(v) ((v)->ob_type == PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->obj)
#define PyGtkAccelGroup_Check(v) ((v)->ob_type == PyGtkAccelGroup_Type)
#define PyGtkAccelGroup_Get(v) (((PyGtkAccelGroup_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)
#define PyGdkColormap_Check(v) ((v)->ob_type == PyGdkColormap_Type)
#define PyGdkColormap_Get(v) (((PyGdkColormap_Object *)(v))->obj)

static PyObject *(*PyGtk_New)(GtkObject *)=0;
static PyObject *(*PyGtkAccelGroup_New)(GtkAccelGroup *)=0;
static PyObject *(*PyGtkStyle_New)(GtkStyle *)=0;
static PyObject *(*PyGdkFont_New)(GdkFont *)=0;
static PyObject *(*PyGdkColor_New)(GdkColor *)=0;
static PyObject *(*PyGdkEvent_New)(GdkEvent *)=0;
static PyObject *(*PyGdkWindow_New)(GdkWindow *)=0;
static PyObject *(*PyGdkGC_New)(GdkGC *)=0;
static PyObject *(*PyGdkColormap_New)(GdkColormap *)=0;

static void (*PyGtk_CallbackMarshal)(GtkObject *o, gpointer data,
				     int nargs, GtkArg *args)=0;
static void (*PyGtk_DestroyNotify)(gpointer data)=0;

static PyObject *(*GtkArgs_AsTuple)(int nparams, GtkArg *args)=0;
static int (*GtkArgs_FromSequence)(GtkArg *args, int nparams, PyObject *seq)=0;
static int (*GtkArg_FromPyObject)(GtkArg *arg, PyObject *obj)=0;
static PyObject *(*GtkArg_AsPyObject)(GtkArg *arg)=0;
static void (*GtkRet_FromPyObject)(GtkArg *ret, PyObject *py_ret)=0;
static PyObject *(*GtkRet_AsPyObject)(GtkArg *ret)=0;

static int (*PyGtkEnum_get_value)(GtkType type, PyObject *obj, gint *val)=0;
static int (*PyGtkFlag_get_value)(GtkType type, PyObject *obj, gint *val)=0;

static GtkArg *(*PyDict_AsGtkArgs)(PyObject *dict, GtkType type, gint*nargs)=0;

static void pygtk_init() {
  PyObject *gtkbase, *dict, *func, *ret;

  gtkbase = PyImport_ImportModule("_gtkbase");
  dict = PyModule_GetDict(gtkbase);
  Py_DECREF(gtkbase);

  ret = PyObject_CallObject(PyDict_GetItemString(dict, "gtk_init"), NULL);
  Py_DECREF(ret);

  /* extract the types */
  PyGtk_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkObjectType");
  Py_INCREF(PyGtk_Type);
  PyGtkAccelGroup_Type = (PyTypeObject *)PyDict_GetItemString(dict,
						"GtkAccelGroupType");
  Py_INCREF(PyGtkAccelGroup_Type);
  PyGtkStyle_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkStyleType");
  Py_INCREF(PyGtkStyle_Type);
  PyGdkFont_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkFontType");
  Py_INCREF(PyGdkFont_Type);
  PyGdkColor_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkColorType");
  Py_INCREF(PyGdkColor_Type);
  PyGdkEvent_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkEventType");
  Py_INCREF(PyGdkEvent_Type);
  PyGdkWindow_Type = (PyTypeObject*)PyDict_GetItemString(dict,"GdkWindowType");
  Py_INCREF(PyGdkWindow_Type);
  PyGdkGC_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkGCType");
  Py_INCREF(PyGdkGC_Type);
  PyGdkColormap_Type = (PyTypeObject *)PyDict_GetItemString(dict,
							    "GdkColormapType");
  Py_INCREF(PyGdkColormap_Type);

  dict = PyDict_GetItemString(dict, "_private");
  PyGtk_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_New"));
  PyGtkAccelGroup_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkAccelGroup_New"));
  PyGtkStyle_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkStyle_New"));
  PyGdkFont_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkFont_New"));
  PyGdkColor_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColor_New"));
  PyGdkEvent_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkEvent_New"));
  PyGdkWindow_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkWindow_New"));
  PyGdkGC_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkGC_New"));
  PyGdkColormap_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColormap_New"));

  PyGtk_DestroyNotify = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_DestroyNotify"));
  PyGtk_CallbackMarshal = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_CallbackMarshal"));

  GtkArgs_AsTuple = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_AsTuple"));
  GtkArgs_FromSequence = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_FromSequence"));
  GtkRet_FromPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_FromPyObject"));
  GtkRet_AsPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_AsPyObject"));

  PyGtkEnum_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkEnum_get_value"));
  PyGtkFlag_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkFlag_get_value"));

  PyDict_AsGtkArgs = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyDict_AsGtkArgs"));
}

static PyObject *gdk__pixmap_new(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  PyObject *win, *ret;
  int w, h, d;
  if (!PyArg_ParseTuple(args, "O!iii:gdk_pixmap_new", PyGdkWindow_Type, &win,
		       &w, &h, &d))
    return NULL;
  pix = gdk_pixmap_new(PyGdkWindow_Get(win), w, h, d);
  ret = PyGdkWindow_New(pix);
  gdk_pixmap_unref(pix);
  return ret;
}
static PyObject *gdk__pixmap_create_from_xpm(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  GdkBitmap *mask;
  PyObject *parent_win, *colour, *ret;
  GdkColor *col;
  gchar *fname;

  if (!PyArg_ParseTuple(args, "O!Os:gdk_pixmap_create_from_xpm",
			PyGdkWindow_Type, &parent_win, &colour, &fname))
    return NULL;
  if (colour == Py_None)             col = NULL;
  else if (PyGdkColor_Check(colour)) col = PyGdkColor_Get(colour);
  else {
    PyErr_SetString(PyExc_TypeError,
		    "second argument must be a colour or None");
    return NULL;
  }
  pix = gdk_pixmap_create_from_xpm(PyGdkWindow_Get(parent_win), &mask, col,
				   fname);
  if (pix == NULL) {
    PyErr_SetString(PyExc_IOError, "can't load pixmap");
    return NULL;
  }
  ret =  Py_BuildValue("(OO)", PyGdkWindow_New(pix), PyGdkWindow_New(mask));
  gdk_pixmap_unref(pix);
  gdk_bitmap_unref(mask);
  return ret;
}

static PyObject *gdk__draw_polygon(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint filled, npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!iO:gdk_draw_polygon", PyGdkWindow_Type,
			&win, PyGdkGC_Type, &gc, &filled, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_polygon(PyGdkWindow_Get(win),PyGdkGC_Get(gc),filled,points,npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_text(PyObject *self, PyObject *args) {
  PyObject *win, *font, *gc;
  int x, y, len;
  char *str;
  if (!PyArg_ParseTuple(args, "O!O!O!iis#:gdk_draw_text", PyGdkWindow_Type,
			&win, PyGdkFont_Type, &font, PyGdkGC_Type, &gc,
			&x, &y, &str, &len))
    return NULL;
  gdk_draw_text(PyGdkWindow_Get(win), PyGdkFont_Get(font), PyGdkGC_Get(gc),
		x, y, str, len);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_points(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_points", PyGdkWindow_Type,
			&win, PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_points(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_segments(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint nsegs, i;
  GdkSegment *segs;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_segments", PyGdkWindow_Type,
			&win, PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  nsegs = PySequence_Length(seq);
  segs = g_new(GdkSegment, nsegs);
  for (i = 0; i < nsegs; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hhhh", &(segs[i].x1), &(segs[i].y1),
			  &(segs[i].x2), &(segs[i].y2))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 4-tuple");
      g_free(segs);
      return NULL;
    }
  }
  gdk_draw_segments(PyGdkWindow_Get(win), PyGdkGC_Get(gc), segs, nsegs);
  g_free(segs);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_lines(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_lines", PyGdkWindow_Type,
			&win, PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_lines(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}

/* gdk_color_alloc analog */
static PyObject *
gdk__color_alloc(PyObject *self, PyObject *args) {
    GdkColor gdk_color;
    GdkColormap *colormap;
    PyGtkStyle_Object *style;
    PyGtk_Object *obj;
    if (PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", PyGtkStyle_Type,
			 &style, &(gdk_color.red), &(gdk_color.green),
			 &(gdk_color.blue)))
        colormap = PyGtkStyle_Get(style)->colormap;
    else {
        PyErr_Clear();
	if (!PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", PyGtk_Type,
			      &obj, &(gdk_color.red), &(gdk_color.green),
			      &(gdk_color.blue)))
	    return NULL;
	if (GTK_WIDGET_NO_WINDOW(PyGtk_Get(obj))) {
	    PyErr_SetString(PyExc_TypeError, "widget has no window");
	    return NULL;
	}
	colormap = gdk_window_get_colormap(GTK_WIDGET(PyGtk_Get(obj))->window);
    }
    gdk_color_alloc(colormap, &gdk_color);
    return PyGdkColor_New(&gdk_color);
}

#define gtk_adjustment_get_lower(o)          ((o)->lower)
#define gtk_adjustment_get_upper(o)          ((o)->upper)
#define gtk_adjustment_get_value(o)          ((o)->value)
#define gtk_adjustment_get_step_increment(o) ((o)->step_increment)
#define gtk_adjustment_get_page_increment(o) ((o)->page_increment)
#define gtk_adjustment_get_page_size(o)      ((o)->page_size)

static PyObject *
gtk__box_query_child_packing(PyObject *self, PyObject *args) {
  PyObject *box, *child;
  gboolean expand, fill;
  guint padding;
  GtkPackType pack_type;
  if (!PyArg_ParseTuple(args, "O!O!:gtk_box_query_child_packing", PyGtk_Type,
			&box, PyGtk_Type, &child))
    return NULL;
  gtk_box_query_child_packing(GTK_BOX(PyGtk_Get(box)),
			      GTK_WIDGET(PyGtk_Get(child)), &expand, &fill,
			      &padding, &pack_type);
  return Py_BuildValue("(iiii)", (int)expand, (int)fill, padding, pack_type);
}

static PyObject *
gtk__button_box_get_child_size_default(PyObject *self, PyObject *args) {
    int mw, mh;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_size_default"))
        return NULL;
    gtk_button_box_get_child_size_default(&mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args) {
    int ipx, ipy;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_ipadding_default"))
        return NULL;
    gtk_button_box_get_child_ipadding_default(&ipx, &ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
static PyObject *
gtk__button_box_get_child_size(PyObject *self, PyObject *args) {
    int mw, mh;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_size",
            PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_size(GTK_BUTTON_BOX(PyGtk_Get(o)), &mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args) {
    int ipx, ipy;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_ipadding",
            PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_ipadding(GTK_BUTTON_BOX(PyGtk_Get(o)),&ipx,&ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}

#define gtk_check_menu_item_get_active(cb) ((cb)->active)

static PyObject *gtk__clist_get_selection(PyObject *self, PyObject *args) {
  GList *selection;
  guint row;
  PyObject *clist, *ret;
  if (!PyArg_ParseTuple(args, "O!:gtk_clist_get_selection", PyGtk_Type,
			&clist))
    return NULL;
  ret = PyList_New(0);
  for (selection = GTK_CLIST(PyGtk_Get(clist))->selection; selection != NULL;
       selection = selection->next) {
    row = (guint)selection->data;
    PyList_Append(ret, PyInt_FromLong(row));
  }
  return ret;
}
static PyObject *gtk__clist_new_with_titles(PyObject *self, PyObject *args) {
	int c, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "iO:gtk_clist_new_with_titles",
			&c, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError,"3rd argument not a sequence");
		return NULL;
	}
	if (PySequence_Length(l) < c) {
		PyErr_SetString(PyExc_TypeError, "sequence not long enough");
		return NULL;
	}
	list = malloc(sizeof(char *)*c);
	for (i = 0; i < c; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				 "sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	item = (PyObject *) PyGtk_New((GtkObject *)gtk_clist_new_with_titles
		(c, list));
	free(list);
	return item;
}

static PyObject *gtk__clist_get_text(PyObject *self, PyObject *args) {
	PyGtk_Object *w;
	int r, c;
	char *text;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_text", PyGtk_Type,
			&w, &r, &c))
		return NULL;
	gtk_clist_get_text(GTK_CLIST(PyGtk_Get(w)), r, c, &text);
	return PyString_FromString(text);
}
static PyObject *gtk__clist_get_pixmap(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!iiO!:gtk_clist_get_pixmap", PyGtk_Type,
			&o, &r, &c))
		return NULL;
	gtk_clist_get_pixmap(GTK_CLIST(PyGtk_Get(o)), r, c, &p, &m);
	return Py_BuildValue("(OO)", PyGdkWindow_New(p), PyGdkWindow_New(m));
}
static PyObject *gtk__clist_get_pixtext(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	guint8 spacing;
	char *text;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_pixtext",
			PyGtk_Type, &o, &r, &c))
		return NULL;
	gtk_clist_get_pixtext(GTK_CLIST(PyGtk_Get(o)), r, c, &text, &spacing,
		&p, &m);
	return Py_BuildValue("(siOO)", text, (int)spacing,
			     PyGdkWindow_New(p), PyGdkWindow_New(m));
}

static PyObject *gtk__clist_append(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!O:gtk_clist_append", PyGtk_Type, &cl,
			&l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	i = gtk_clist_append(GTK_CLIST(PyGtk_Get(cl)), list);
	free(list);
	return PyInt_FromLong(i);
}

static PyObject *gtk__clist_insert(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, r, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_insert", PyGtk_Type, &cl,
			&r, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	gtk_clist_insert(GTK_CLIST(PyGtk_Get(cl)), r, list);
	free(list);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__clist_set_row_data(PyObject *self, PyObject *args) {
        PyGtk_Object *obj;
	int row;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_set_row_data", PyGtk_Type,
			      &obj, &row, &data))
	    return NULL;
	Py_INCREF(data);
	gtk_clist_set_row_data_full(GTK_CLIST(PyGtk_Get(obj)), row, data,
				    (GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__clist_get_selection_info(PyObject *s, PyObject *args) {
  PyObject *clist;
  gint x, y, row, column;
  if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_selection_info", PyGtk_Type,
			&clist, &x, &y))
    return NULL;
  if (gtk_clist_get_selection_info(GTK_CLIST(PyGtk_Get(clist)), x, y,
				   &row, &column))
    return Py_BuildValue("(ii)", row, column);
  else {
    Py_INCREF(Py_None);
    return Py_None;
  }
}   

#define gtk_color_selection_dialog_get_colorsel(d)      ((d)->colorsel)
#define gtk_color_selection_dialog_get_main_vbox(d)     ((d)->main_vbox)
#define gtk_color_selection_dialog_get_ok_button(d)     ((d)->ok_button)
#define gtk_color_selection_dialog_get_reset_button(d)  ((d)->reset_button)
#define gtk_color_selection_dialog_get_cancel_button(d) ((d)->cancel_button)
#define gtk_color_selection_dialog_get_help_button(d)   ((d)->help_button)

#define gtk_combo_get_entry(c) ((c)->entry)
#define gtk_combo_get_list(c)  ((c)->list)

static PyObject *
gtk__combo_set_popdown_strings(PyObject *self, PyObject *args) {
  PyObject *obj, *list, *item;
  GList *glist = NULL;
  int len, i;
  if (!PyArg_ParseTuple(args, "O!O!:gtk_combo_set_popdown_strings",
			PyGtk_Type, &obj, &PyList_Type, &list))
    return NULL;
  len = PyList_Size(list);
  for (i = 0; i < len; i++) {
    item = PyList_GetItem(list, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "list item not a string");
      g_list_free(glist);
      return NULL;
    }
    glist = g_list_append(glist, PyString_AsString(item));
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(PyGtk_Get(obj)), glist);
  g_list_free(glist);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *gtk__curve_get_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  int size=-1, i;
  gfloat *vector;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "O!|i:gtk_curve_get_vector", PyGtk_Type, &obj,
			&size))
    return NULL;
  if (size < 0) size = GTK_CURVE(PyGtk_Get(obj))->num_points;
  vector = g_new(gfloat, size);
  gtk_curve_get_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  ret = PyTuple_New(size);
  for (i = 0; i < size; i++)
    PyTuple_SetItem(ret, i, PyFloat_FromDouble(vector[i]));
  g_free(vector);
  return ret;
}
static PyObject *gtk__curve_set_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  PyObject *seq, *item;
  int size, i;
  gfloat *vector;

  if (!PyArg_ParseTuple(args, "O!O:gtk_curve_set_vector", PyGtk_Type, &obj,
			&seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "2nd argument is not a sequence");
    return NULL;
  }
  size = PySequence_Length(seq);
  vector = g_new(gfloat, size);
  for (i = 0; i < size; i++) {
    item = PyNumber_Float(PySequence_GetItem(seq, i));
    if (item == NULL) {
      g_free(vector);
      return NULL;
    }
    vector[i] = PyFloat_AsDouble(item);
    Py_DECREF(item);
  }
  gtk_curve_set_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  g_free(vector);
  Py_INCREF(Py_None);
  return Py_None;
}

#define gtk_dialog_get_vbox(d) ((d)->vbox)
#define gtk_dialog_get_action_area(d) ((d)->action_area)

static PyObject *gtk__editable_insert_text(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *text;
	int len, pos;
	if (!PyArg_ParseTuple(args, "O!s#:gtk_editable_insert_text",
			PyGtk_Type, &o, &text, &len))
		return NULL;
	gtk_editable_insert_text(GTK_EDITABLE(PyGtk_Get(o)), text, len, &pos);
	return PyInt_FromLong(pos);
}

#define gtk_file_selection_get_dir_list(f)  ((f)->dir_list)
#define gtk_file_selection_get_file_list(f) ((f)->file_list)
#define gtk_file_selection_get_selection_entry(f) ((f)->selection_entry)
#define gtk_file_selection_get_selection_text(f)  ((f)->selection_text)
#define gtk_file_selection_get_main_vbox(f) ((f)->main_vbox)
#define gtk_file_selection_get_ok_button(f) ((f)->ok_button)
#define gtk_file_selection_get_cancel_button(f) ((f)->cancel_button)
#define gtk_file_selection_get_help_button(f) ((f)->help_button)

#define gtk_font_selection_dialog_get_fontsel(o) ((o)->fontsel)
#define gtk_font_selection_dialog_get_main_vbox(o) ((o)->main_vbox)
#define gtk_font_selection_dialog_get_action_area(o) ((o)->action_area)
#define gtk_font_selection_dialog_get_ok_button(o) ((o)->ok_button)
#define gtk_font_selection_dialog_get_apply_button(o) ((o)->apply_button)
#define gtk_font_selection_dialog_get_cancel_button(o) ((o)->cancel_button)

#define gtk_list_get_selection(l) ((l)->selection)

static void PyGtk_MenuPosition(GtkMenu *menu, int *x, int *y, PyObject *func) {
    PyObject *ret;
    ret = PyObject_CallFunction(func, "(O)", PyGtk_New(GTK_OBJECT(menu)));
    if (ret == NULL || !PyArg_ParseTuple(ret, "ii", x, y)) {
        PyErr_Clear();
        fprintf(stderr, "Ignoring Exception\n");
        *x = 0;
        *y = 0;
    } else
        Py_DECREF(ret);
}
static PyObject *gtk__menu_popup(PyObject *self, PyObject *args) {
    PyGtk_Object *m, *pms, *pmi;
    PyObject *func;
    int button, time;
    if (!PyArg_ParseTuple(args, "O!O!O!Oii:gtk_menu_item", PyGtk_Type, &m,
            PyGtk_Type, &pms, PyGtk_Type, &pmi, &func, &button, &time))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "forth argument not callable");
        return NULL;
    }
    Py_INCREF(func);
    gtk_menu_popup(GTK_MENU(PyGtk_Get(m)), GTK_WIDGET(PyGtk_Get(pms)),
        GTK_WIDGET(PyGtk_Get(pmi)), (GtkMenuPositionFunc)PyGtk_MenuPosition,
        func, button, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *gtk__pixmap_new_from_xpm(PyObject *self, PyObject *args) {
    PyGtk_Object *win;
    PyGdkColor_Object *tc = NULL;
    char *name;
    GdkColor *bg;
    GdkPixmap *pm;
    GdkBitmap *bm;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s|O!:gtk_pixmap_new_from_xpm", PyGtk_Type,
            &win, &name, PyGdkColor_Type, &tc))
        return  NULL;
    if (tc == NULL)
        bg = NULL;
    else
        bg = PyGdkColor_Get(tc);
    pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(PyGtk_Get(win))->window, &bm,
        bg, name);
    if (pm == NULL) {
      PyErr_SetString(PyExc_IOError, "can't load pixmap");
      return NULL;
    }
    ret = PyGtk_New(GTK_OBJECT(gtk_pixmap_new(pm, bm)));
    /* gtk_pixmap_new ref's the pixmap and mask, so we can unref out vars */
    gdk_pixmap_unref(pm);
    gdk_bitmap_unref(bm);
    return ret;
}
static PyObject *gtk__pixmap_get(PyObject *self, PyObject *args) {
  PyObject *pix;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  if (!PyArg_ParseTuple(args, "O!:gtk_pixmap_get", PyGtk_Type, &pix))
    return NULL;
  gtk_pixmap_get(GTK_PIXMAP(PyGtk_Get(pix)), &pixmap, &mask);
  return Py_BuildValue("(OO)", PyGdkWindow_New(pixmap),
		       PyGdkWindow_New(mask));
}

static PyObject *gtk__radio_menu_item_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_menu_item_new",PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new(l)));
}
static PyObject *gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a) {
    PyGtk_Object *g = NULL;
    char *label = "";
    GSList *l = NULL;
    if (!PyArg_ParseTuple(a, "|Os:gtk_radio_menu_item_new_with_label",
            &g, &label))
        return NULL;
    if (g != NULL)
        if (!PyGtk_Check(g) && (PyObject *)g != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "first argument not a GtkObject or None");
            return NULL;
        }
    if ((PyObject *)g == Py_None) g = NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new_with_label(l, label)));
}

#define gtk_spin_button_new_no_adj(c,d) gtk_spin_button_new(NULL,c,d)

#define gtk_text_get_hadjustment(t) ((t)->hadj)
#define gtk_text_get_vadjustment(t) ((t)->vadj)

static PyObject *gtk__text_insert_defaults(PyObject *self, PyObject *args) {
    PyGtk_Object *txt;
    char *chars;
    int l;
    GtkStyle *style;
    if (!PyArg_ParseTuple(args, "O!s#:gtk_text_insert_defaults", PyGtk_Type,
                                     &txt, &chars, &l))
        return NULL;
    style = gtk_widget_get_style(GTK_WIDGET(PyGtk_Get(txt)));
    gtk_text_insert(GTK_TEXT(PyGtk_Get(txt)), NULL,
        &style->fg[GTK_STATE_NORMAL], NULL, chars, l);
    Py_INCREF(Py_None);
    return Py_None;
}

#define gtk_toggle_button_get_active(tb) ((tb)->active)

static PyObject *gtk__toolbar_append_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_append_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
                        PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
        /* if you set sigfunc to NULL, no signal is connected, rather than
           the default signal handler being used */
	gtk_toolbar_append_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None) {
		tmp_list = g_list_last(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))));
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_prepend_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_prepend_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
			PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_prepend_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None)
		gtk_signal_connect(GTK_OBJECT(gtk_container_children(
			GTK_CONTAINER(PyGtk_Get(t)))->data), "clicked", NULL,
			callback);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_insert_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	int pos;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!Oi|gtk_toolbar_insert_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
			PyGtk_Type, &icon, &callback, &pos))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_insert_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL, pos);
	if (callback != Py_None) {
		tmp_list = g_list_nth(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))), pos);
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}

#define gtk_tree_get_selection(t) ((t)->selection)
static PyObject *_wrap_gdk_font_load(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gdk_font_load",&_arg0)) 
        return NULL;
    _result = (GdkFont *)gdk_font_load(_arg0);
{
  _resultobj = PyGdkFont_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gdk_fontset_load(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gdk_fontset_load",&_arg0)) 
        return NULL;
    _result = (GdkFont *)gdk_fontset_load(_arg0);
{
  _resultobj = PyGdkFont_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gdk_draw_point",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_point(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_line(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiii:gdk_draw_line",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_line(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_rectangle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiii:gdk_draw_rectangle",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_rectangle(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_arc(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiiiii:gdk_draw_arc",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_arc(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_pixmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    GdkWindow * _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOiiiiii:gdk_draw_pixmap",&_obj0,&_obj1,&_obj2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj2))
    _arg2 = PyGdkWindow_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
    gdk_draw_pixmap(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_pygtk_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":pygtk_init")) 
        return NULL;
    pygtk_init();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_accel_label_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_accel_label_get_type")) 
        return NULL;
    _result = (int )gtk_accel_label_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_accel_label_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_accel_label_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_accel_label_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_accel_label_accelerator_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkAccelLabel * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_accel_label_accelerator_width",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ACCEL_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_accel_label_accelerator_width(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_accel_label_set_accel_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAccelLabel * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_accel_label_set_accel_widget",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ACCEL_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_accel_label_set_accel_widget(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_accel_label_refetch(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkAccelLabel * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_accel_label_refetch",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ACCEL_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_accel_label_refetch(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_adjustment_get_type")) 
        return NULL;
    _result = (int )gtk_adjustment_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddd:gtk_adjustment_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    _result = (GtkObject *)gtk_adjustment_new(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_lower(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_lower",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_lower(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_upper(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_upper",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_upper(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_value(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_step_increment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_step_increment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_step_increment(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_page_increment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_page_increment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_page_increment(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_page_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_page_size",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_page_size(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_changed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_changed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_changed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_value_changed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_value_changed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_value_changed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_adjustment_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_set_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_clamp_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_adjustment_clamp_page",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_clamp_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_alignment_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_alignment_get_type")) 
        return NULL;
    _result = (int )gtk_alignment_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_alignment_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"dddd:gtk_alignment_new",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (GtkWidget *)gtk_alignment_new(_arg0,_arg1,_arg2,_arg3);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_alignment_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAlignment * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_alignment_set",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ALIGNMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_alignment_set(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_arrow_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_arrow_get_type")) 
        return NULL;
    _result = (int )gtk_arrow_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_arrow_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_arrow_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_arrow_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_arrow_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkArrow * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_arrow_set",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ARROW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_arrow_set(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_aspect_frame_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_aspect_frame_get_type")) 
        return NULL;
    _result = (int )gtk_aspect_frame_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_aspect_frame_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    int  _arg4;

    self = self;
    if(!PyArg_ParseTuple(args,"sdddi:gtk_aspect_frame_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    _result = (GtkWidget *)gtk_aspect_frame_new(_arg0,_arg1,_arg2,_arg3,_arg4);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_aspect_frame_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAspectFrame * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddi:gtk_aspect_frame_set",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ASPECT_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_aspect_frame_set(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_bin_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_bin_get_type")) 
        return NULL;
    _result = (int )gtk_bin_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_box_get_type")) 
        return NULL;
    _result = (int )gtk_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_start(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiii:gtk_box_pack_start",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_start(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_end(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiii:gtk_box_pack_end",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_end(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_start_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_box_pack_start_defaults",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_start_defaults(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_end_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_box_pack_end_defaults",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_end_defaults(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_set_homogeneous(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_box_set_homogeneous",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_set_homogeneous(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_set_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_box_set_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_set_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_reorder_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_box_reorder_child",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_reorder_child(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_set_child_packing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    GtkPackType * _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj5 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiO:gtk_box_set_child_packing",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_obj5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPackType tmp; _arg5 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_PACK_TYPE, _obj5, (gint *)_arg5))
    return NULL;
}
    gtk_box_set_child_packing(_arg0,_arg1,_arg2,_arg3,_arg4,*_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_button_get_type")) 
        return NULL;
    _result = (int )gtk_button_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_button_pressed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_pressed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_pressed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_released(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_released",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_released(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_clicked(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_clicked",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_clicked(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_enter(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_enter",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_enter(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_leave(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_leave",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_leave(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_set_relief(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    GtkReliefStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_button_set_relief",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkReliefStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_RELIEF_STYLE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_button_set_relief(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_get_relief(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkReliefStyle * _result;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_get_relief",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkReliefStyle *) malloc(sizeof(GtkReliefStyle ));
    *(_result) = gtk_button_get_relief(_arg0);
{
  _resultobj = PyInt_FromLong((int)(_result));
}
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_button_box_get_type")) 
        return NULL;
    _result = (int )gtk_button_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_size_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_button_box_set_child_size_default",&_arg0,&_arg1)) 
        return NULL;
    gtk_button_box_set_child_size_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_ipadding_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_button_box_set_child_ipadding_default",&_arg0,&_arg1)) 
        return NULL;
    gtk_button_box_set_child_ipadding_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_get_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkButtonBox * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_box_get_spacing",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_button_box_get_spacing(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_get_layout(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBoxStyle * _result;
    GtkButtonBox * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_box_get_layout",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkButtonBoxStyle *) malloc(sizeof(GtkButtonBoxStyle ));
    *(_result) = gtk_button_box_get_layout(_arg0);
{
  _resultobj = PyInt_FromLong((int)(_result));
}
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_button_box_set_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_layout(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    GtkButtonBoxStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_button_box_set_layout",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkButtonBoxStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_BUTTON_BOX_STYLE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_button_box_set_layout(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_button_box_set_child_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_child_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_ipadding(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_button_box_set_child_ipadding",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_child_ipadding(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_button_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_button_get_type")) 
        return NULL;
    _result = (int )gtk_check_button_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_check_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_check_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_check_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_check_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_menu_item_get_type")) 
        return NULL;
    _result = (int )gtk_check_menu_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_menu_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_check_menu_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_check_menu_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_check_menu_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_set_state(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_check_menu_item_set_state",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_set_state(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_toggled(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_check_menu_item_toggled",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_toggled(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_set_show_toggle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_check_menu_item_set_show_toggle",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_set_show_toggle(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCheckMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_check_menu_item_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_check_menu_item_get_active(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_clist_get_type")) 
        return NULL;
    _result = (int )gtk_clist_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_clist_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_clist_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_row_is_visible(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_row_is_visible",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_clist_row_is_visible(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    GtkShadowType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_clist_set_border",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkShadowType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SHADOW_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_clist_set_border(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    GtkPolicyType * _arg1;
    GtkPolicyType * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_clist_set_policy",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPolicyType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
{
  static GtkPolicyType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj2, (gint *)_arg2))
    return NULL;
}
    gtk_clist_set_policy(_arg0,*_arg1,*_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_show(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_show",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_show(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_hide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_hide",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_hide(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_title_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_column_title_active",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_title_active(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_title_passive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_column_title_passive",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_title_passive(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_active(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_passive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_passive",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_passive(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gtk_clist_set_column_title",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_title(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_column_widget",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_widget(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_justification(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GtkJustification * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_column_justification",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkJustification tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_JUSTIFICATION, _obj2, (gint *)_arg2))
    return NULL;
}
    gtk_clist_set_column_justification(_arg0,_arg1,*_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_set_column_width",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_width(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_row_height(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_set_row_height",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_row_height(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_moveto(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiidd:gtk_clist_moveto",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_moveto(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_get_cell_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCellType * _result;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_get_cell_type",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkCellType *) malloc(sizeof(GtkCellType ));
    *(_result) = gtk_clist_get_cell_type(_arg0,_arg1,_arg2);
{
  _resultobj = PyInt_FromLong((int)(_result));
}
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiis:gtk_clist_set_text",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_text(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_pixmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    GdkPixmap * _arg3;
    GdkBitmap * _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiiOO:gtk_clist_set_pixmap",&_obj0,&_arg1,&_arg2,&_obj3,&_obj4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj3))
    _arg3 = PyGdkWindow_Get(_obj3);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj4))
    _arg4 = PyGdkWindow_Get(_obj4);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_clist_set_pixmap(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_pixtext(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    int  _arg4;
    GdkPixmap * _arg5;
    GdkBitmap * _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj5 = 0;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiisiOO:gtk_clist_set_pixtext",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4,&_obj5,&_obj6)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj5))
    _arg5 = PyGdkWindow_Get(_obj5);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj6))
    _arg6 = PyGdkWindow_Get(_obj6);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_clist_set_pixtext(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_foreground(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_foreground",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gtk_clist_set_foreground(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_background(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_background",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gtk_clist_set_background(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    GtkSelectionMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_clist_set_selection_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSelectionMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SELECTION_MODE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_clist_set_selection_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_shift(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiiii:gtk_clist_set_shift",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_shift(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_remove",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_remove(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_select_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_select_row",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_select_row(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_unselect_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_unselect_row",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_unselect_row(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_undo_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_undo_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_undo_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_get_row_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_get_row_data",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (PyObject *)gtk_clist_get_row_data(_arg0,_arg1);
{
  Py_INCREF(_result);
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_find_row_from_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCList * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_clist_find_row_from_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  _arg1 = _obj1;
}
    _result = (int )gtk_clist_find_row_from_data(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_select_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_select_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_select_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_unselect_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_unselect_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_unselect_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_swap_rows(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_swap_rows",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_swap_rows(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_color_selection_get_type")) 
        return NULL;
    _result = (int )gtk_color_selection_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_color_selection_dialog_get_type")) 
        return NULL;
    _result = (int )gtk_color_selection_dialog_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_color_selection_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_color_selection_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    GtkUpdateType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_color_selection_set_update_policy",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkUpdateType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_UPDATE_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_color_selection_set_update_policy(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_opacity(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_color_selection_set_opacity",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_color_selection_set_opacity(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    gdouble * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_color_selection_set_color",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        _arg1 = malloc(3 * sizeof(gdouble));
	if (!PyArg_ParseTuple(_obj1, "ddd", &(_arg1[0]), &(_arg1[1]), &(_arg1[2]))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_color_selection_set_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_get_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    gdouble * _arg1;
    PyObject * _obj0 = 0;

    self = self;
{
        _arg1 = malloc(3 * sizeof(gdouble));
    }
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_get_color",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_color_selection_get_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        _resultobj = Py_BuildValue("(ddd)", _arg1[0], _arg1[1], _arg1[2]);
    }
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_color_selection_dialog_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_color_selection_dialog_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_colorsel(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_colorsel",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_colorsel(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_main_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_main_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_main_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_ok_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_ok_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_ok_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_reset_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_reset_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_reset_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_cancel_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_cancel_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_cancel_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_help_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_help_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_help_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_combo_get_type")) 
        return NULL;
    _result = (int )gtk_combo_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_combo_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_combo_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_value_in_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_combo_set_value_in_list",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_value_in_list(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_use_arrows(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_use_arrows",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_use_arrows(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_use_arrows_always(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_use_arrows_always",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_use_arrows_always(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_case_sensitive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_case_sensitive",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_case_sensitive(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_item_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    GtkItem * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:gtk_combo_set_item_string",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ITEM(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_item_string(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_get_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_get_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_combo_get_entry(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_get_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_get_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_combo_get_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_disable_activate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_disable_activate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_disable_activate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_curve_get_type")) 
        return NULL;
    _result = (int )gtk_curve_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_curve_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_curve_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_reset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_curve_reset",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_reset(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_gamma(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_curve_set_gamma",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_set_gamma(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_curve_set_range",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_set_range(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_curve_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    GtkCurveType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_curve_set_curve_type",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkCurveType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_CURVE_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_curve_set_curve_type(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_data_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_data_get_type")) 
        return NULL;
    _result = (int )gtk_data_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_dialog_get_type")) 
        return NULL;
    _result = (int )gtk_dialog_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_dialog_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_dialog_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_get_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dialog_get_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_dialog_get_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_get_action_area(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dialog_get_action_area",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_dialog_get_action_area(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_drawing_area_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_drawing_area_get_type")) 
        return NULL;
    _result = (int )gtk_drawing_area_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_drawing_area_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_drawing_area_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_drawing_area_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_drawing_area_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkDrawingArea * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_drawing_area_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DRAWING_AREA(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_drawing_area_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_editable_get_type")) 
        return NULL;
    _result = (int )gtk_editable_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_select_region(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_select_region",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_select_region(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_delete_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_delete_text",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_delete_text(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_get_chars(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_get_chars",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_editable_get_chars(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_cut_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_cut_clipboard",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_cut_clipboard(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_copy_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_copy_clipboard",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_copy_clipboard(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_paste_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_paste_clipboard",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_paste_clipboard(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_claim_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_claim_selection",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_claim_selection(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_delete_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_delete_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_delete_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_changed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_changed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_changed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_editable_set_position",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_set_position(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_get_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_get_position",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_editable_get_position(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_set_editable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_editable_set_editable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_set_editable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_entry_get_type")) 
        return NULL;
    _result = (int )gtk_entry_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_entry_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_entry_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_new_with_max_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_entry_new_with_max_length",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_entry_new_with_max_length(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_set_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_append_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_append_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_append_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_prepend_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_prepend_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_prepend_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_position",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_position(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_get_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_entry_get_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_entry_get_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_select_region(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_entry_select_region",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_select_region(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_visibility(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_visibility",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_visibility(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_editable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_editable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_editable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_adjust_scroll(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_entry_adjust_scroll",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_adjust_scroll(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_max_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_max_length",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_max_length(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_event_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_event_box_get_type")) 
        return NULL;
    _result = (int )gtk_event_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_event_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_event_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_event_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_dir_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_dir_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_dir_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_file_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_file_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_file_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_selection_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_selection_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_selection_entry(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_selection_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_selection_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_selection_text(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_main_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_main_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_main_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_ok_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_ok_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_ok_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_cancel_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_cancel_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_cancel_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_help_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_help_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_help_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_file_selection_get_type")) 
        return NULL;
    _result = (int )gtk_file_selection_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_file_selection_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_file_selection_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_set_filename(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFileSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_file_selection_set_filename",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_file_selection_set_filename(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_filename(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_filename",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_file_selection_get_filename(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_show_fileop_buttons(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_show_fileop_buttons",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_file_selection_show_fileop_buttons(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_hide_fileop_buttons(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_hide_fileop_buttons",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_file_selection_hide_fileop_buttons(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_fixed_get_type")) 
        return NULL;
    _result = (int )gtk_fixed_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_fixed_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_fixed_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_put(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFixed * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_fixed_put",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FIXED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_fixed_put(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_move(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFixed * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_fixed_move",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FIXED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_fixed_move(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_font_selection_get_type")) 
        return NULL;
    _result = (int )gtk_font_selection_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_font_selection_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_font_selection_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_get_font_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFontSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_get_font_name",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_font_selection_get_font_name(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_get_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    GtkFontSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_get_font",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GdkFont *)gtk_font_selection_get_font(_arg0);
{
  _resultobj = PyGdkFont_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_set_font_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkFontSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_font_selection_set_font_name",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_font_selection_set_font_name(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_get_preview_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFontSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_get_preview_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_font_selection_get_preview_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_set_preview_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFontSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_font_selection_set_preview_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_font_selection_set_preview_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_font_selection_dialog_get_type")) 
        return NULL;
    _result = (int )gtk_font_selection_dialog_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_fontsel(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_fontsel",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_fontsel(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_main_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_main_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_main_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_action_area(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_action_area",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_action_area(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_ok_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_ok_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_ok_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_apply_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_apply_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_apply_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_cancel_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_cancel_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_font_selection_dialog_get_cancel_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_font_selection_dialog_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_font_selection_dialog_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_font_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_font_name",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_font_selection_dialog_get_font_name(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_font",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GdkFont *)gtk_font_selection_dialog_get_font(_arg0);
{
  _resultobj = PyGdkFont_New(_result);
}
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_set_font_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkFontSelectionDialog * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_font_selection_dialog_set_font_name",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_font_selection_dialog_set_font_name(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_get_preview_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFontSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_font_selection_dialog_get_preview_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_font_selection_dialog_get_preview_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_font_selection_dialog_set_preview_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFontSelectionDialog * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_font_selection_dialog_set_preview_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FONT_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_font_selection_dialog_set_preview_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_frame_get_type")) 
        return NULL;
    _result = (int )gtk_frame_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_frame_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_frame_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_frame_set_label",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_frame_set_label(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_label_align(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_frame_set_label_align",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_frame_set_label_align(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_shadow_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    GtkShadowType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_frame_set_shadow_type",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkShadowType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SHADOW_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_frame_set_shadow_type(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_gamma_curve_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_gamma_curve_get_type")) 
        return NULL;
    _result = (int )gtk_gamma_curve_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_gamma_curve_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_gamma_curve_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_gamma_curve_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_handle_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_handle_box_get_type")) 
        return NULL;
    _result = (int )gtk_handle_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_handle_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_handle_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_handle_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hbox_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbox_get_type")) 
        return NULL;
    _result = (int )gtk_hbox_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbox_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_hbox_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_hbox_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_get_type")) 
        return NULL;
    _result = (int )gtk_hbutton_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hbutton_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_get_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_get_spacing_default")) 
        return NULL;
    _result = (int )gtk_hbutton_box_get_spacing_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_get_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_get_layout_default")) 
        return NULL;
    _result = (int )gtk_hbutton_box_get_layout_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_set_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_hbutton_box_set_spacing_default",&_arg0)) 
        return NULL;
    gtk_hbutton_box_set_spacing_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_set_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBoxStyle * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_hbutton_box_set_layout_default",&_obj0)) 
        return NULL;
{
  static GtkButtonBoxStyle tmp; _arg0 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_BUTTON_BOX_STYLE, _obj0, (gint *)_arg0))
    return NULL;
}
    gtk_hbutton_box_set_layout_default(*_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_hpaned_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hpaned_get_type")) 
        return NULL;
    _result = (int )gtk_hpaned_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hpaned_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hpaned_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hpaned_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hruler_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hruler_get_type")) 
        return NULL;
    _result = (int )gtk_hruler_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hruler_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hruler_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hruler_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hscale_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hscale_get_type")) 
        return NULL;
    _result = (int )gtk_hscale_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hscale_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_hscale_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_hscale_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hscrollbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hscrollbar_get_type")) 
        return NULL;
    _result = (int )gtk_hscrollbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hscrollbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_hscrollbar_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_hscrollbar_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hseparator_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hseparator_get_type")) 
        return NULL;
    _result = (int )gtk_hseparator_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hseparator_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hseparator_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hseparator_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_image_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_image_get_type")) 
        return NULL;
    _result = (int )gtk_image_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_input_dialog_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_input_dialog_get_type")) 
        return NULL;
    _result = (int )gtk_input_dialog_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_input_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_input_dialog_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_input_dialog_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_item_get_type")) 
        return NULL;
    _result = (int )gtk_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_item_toggle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_toggle",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_toggle(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_label_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_label_get_type")) 
        return NULL;
    _result = (int )gtk_label_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_label_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_label_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_label_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_label_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_label_set",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_label_set(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_label_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    char ** _arg1;
    PyObject * _obj0 = 0;

    self = self;
{
        *_arg1 = NULL;
    }
    if(!PyArg_ParseTuple(args,"O:gtk_label_get",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_label_get(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        _resultobj = PyString_FromString(*_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_label_set_justify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    GtkJustification * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_label_set_justify",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkJustification tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_JUSTIFICATION, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_label_set_justify(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_get_type")) 
        return NULL;
    _result = (int )gtk_list_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_list_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_get_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GList * _result;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_get_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GList *)gtk_list_get_selection(_arg0);
{
	GList *t;
        _resultobj = PyList_New(0);
        for (t = _result; t != NULL; t = t->next)
            PyList_Append(_resultobj, PyGtk_New(GTK_OBJECT(t->data)));
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_insert_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_list_insert_items",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)PyGtk_Get(item));
        }
    }
    gtk_list_insert_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_append_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_append_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)PyGtk_Get(item));
        }
    }
    gtk_list_append_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_prepend_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_prepend_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)PyGtk_Get(item));
        }
    }
    gtk_list_prepend_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_remove_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_remove_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)PyGtk_Get(item));
        }
    }
    gtk_list_remove_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_clear_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_list_clear_items",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_clear_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_select_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_list_select_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_select_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_unselect_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_list_unselect_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_unselect_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_select_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_select_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_select_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_unselect_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_unselect_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_unselect_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_child_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_child_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_list_child_position(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkSelectionMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_set_selection_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSelectionMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SELECTION_MODE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_list_set_selection_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_extend_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkScrollType * _arg1;
    double  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOdi:gtk_list_extend_selection",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkScrollType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SCROLL_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_list_extend_selection(_arg0,*_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_start_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_start_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_start_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_end_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_end_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_end_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_select_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_select_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_select_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_unselect_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_unselect_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_unselect_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_scroll_horizontal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkScrollType * _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOd:gtk_list_scroll_horizontal",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkScrollType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SCROLL_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_list_scroll_horizontal(_arg0,*_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_scroll_vertical(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkScrollType * _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOd:gtk_list_scroll_vertical",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkScrollType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SCROLL_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_list_scroll_vertical(_arg0,*_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_toggle_add_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_toggle_add_mode",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_toggle_add_mode(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_toggle_focus_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_toggle_focus_row",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_toggle_focus_row(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_toggle_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_toggle_row",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_toggle_row(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_undo_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_undo_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_undo_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_end_drag_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_end_drag_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_end_drag_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_item_get_type")) 
        return NULL;
    _result = (int )gtk_list_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_list_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_list_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_list_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkListItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkListItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_get_type")) 
        return NULL;
    _result = (int )gtk_menu_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_reposition(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_reposition",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_reposition(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_popdown(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_popdown",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_popdown(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_menu_get_active(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_set_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_menu_set_active",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_set_active(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_set_accel_group(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkAccelGroup * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_set_accel_group",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGtkAccelGroup_Check(_obj1))
    _arg1 = PyGtkAccelGroup_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkAccelGroup");
    return NULL;
  }
}
    gtk_menu_set_accel_group(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_get_attach_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_get_attach_widget",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_menu_get_attach_widget(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_detach(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_detach",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_detach(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_bar_get_type")) 
        return NULL;
    _result = (int )gtk_menu_bar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_bar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_bar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_bar_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_bar_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_bar_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_item_get_type")) 
        return NULL;
    _result = (int )gtk_menu_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_menu_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_set_submenu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_item_set_submenu",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_set_submenu(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_remove_submenu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_remove_submenu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_remove_submenu(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_set_placement(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    GtkSubmenuPlacement * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_item_set_placement",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSubmenuPlacement tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SUBMENU_PLACEMENT, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_menu_item_set_placement(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_configure(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_menu_item_configure",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_configure(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_activate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_activate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_activate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_right_justify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_right_justify",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_right_justify(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_shell_get_type")) 
        return NULL;
    _result = (int )gtk_menu_shell_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_shell_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_shell_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_shell_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_deactivate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_shell_deactivate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_deactivate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_misc_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_misc_get_type")) 
        return NULL;
    _result = (int )gtk_misc_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_misc_set_alignment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMisc * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_misc_set_alignment",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MISC(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_misc_set_alignment(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_misc_set_padding(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMisc * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_misc_set_padding",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MISC(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_misc_set_padding(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_notebook_get_type")) 
        return NULL;
    _result = (int )gtk_notebook_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_notebook_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_notebook_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_append_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_notebook_append_page",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_append_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_append_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOO:gtk_notebook_append_page_menu",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_append_page_menu(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prepend_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_notebook_prepend_page",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prepend_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prepend_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOO:gtk_notebook_prepend_page_menu",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prepend_page_menu(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_insert_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOi:gtk_notebook_insert_page",&_obj0,&_obj1,&_obj2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_insert_page(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_insert_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOi:gtk_notebook_insert_page_menu",&_obj0,&_obj1,&_obj2,&_obj3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_insert_page_menu(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_remove_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_remove_page",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_remove_page(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_current_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_current_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_notebook_current_page(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_page",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_page(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_next_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_next_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_next_page(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prev_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_prev_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prev_page(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_reorder_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_notebook_reorder_child",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_reorder_child(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_tab_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkPositionType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_notebook_set_tab_pos",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPositionType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POSITION_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_notebook_set_tab_pos(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_show_tabs(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_show_tabs",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_show_tabs(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_show_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_show_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_show_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_scrollable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_scrollable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_scrollable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_tab_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_tab_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_tab_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_popup_enable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_popup_enable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_popup_enable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_popup_disable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_popup_disable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_popup_disable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_option_menu_get_type")) 
        return NULL;
    _result = (int )gtk_option_menu_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_option_menu_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_option_menu_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_get_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkOptionMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_option_menu_get_menu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_option_menu_get_menu(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_set_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_option_menu_set_menu",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_set_menu(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_remove_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_option_menu_remove_menu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_remove_menu(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_set_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_option_menu_set_history",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_set_history(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_packer_get_type")) 
        return NULL;
    _result = (int )gtk_packer_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_packer_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_packer_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_add_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    GtkWidget * _arg1;
    GtkSideType * _arg2;
    GtkAnchorType * _arg3;
    GtkPackerOptions * _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOO:gtk_packer_add_defaults",&_obj0,&_obj1,&_obj2,&_obj3,&_obj4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSideType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SIDE_TYPE, _obj2, (gint *)_arg2))
    return NULL;
}
{
  static GtkAnchorType tmp; _arg3 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_ANCHOR_TYPE, _obj3, (gint *)_arg3))
    return NULL;
}
{
  static GtkPackerOptions tmp; _arg4 = &tmp;
  if (PyGtkFlag_get_value(GTK_TYPE_PACKER_OPTIONS, _obj4, (gint *)_arg4))
    return NULL;
}
    gtk_packer_add_defaults(_arg0,_arg1,*_arg2,*_arg3,*_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_add(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    GtkWidget * _arg1;
    GtkSideType * _arg2;
    GtkAnchorType * _arg3;
    GtkPackerOptions * _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    int  _arg9;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOOiiiii:gtk_packer_add",&_obj0,&_obj1,&_obj2,&_obj3,&_obj4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSideType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SIDE_TYPE, _obj2, (gint *)_arg2))
    return NULL;
}
{
  static GtkAnchorType tmp; _arg3 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_ANCHOR_TYPE, _obj3, (gint *)_arg3))
    return NULL;
}
{
  static GtkPackerOptions tmp; _arg4 = &tmp;
  if (PyGtkFlag_get_value(GTK_TYPE_PACKER_OPTIONS, _obj4, (gint *)_arg4))
    return NULL;
}
    gtk_packer_add(_arg0,_arg1,*_arg2,*_arg3,*_arg4,_arg5,_arg6,_arg7,_arg8,_arg9);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_configure(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    GtkWidget * _arg1;
    GtkSideType * _arg2;
    GtkAnchorType * _arg3;
    GtkPackerOptions * _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    int  _arg9;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOOiiiii:gtk_packer_configure",&_obj0,&_obj1,&_obj2,&_obj3,&_obj4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSideType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SIDE_TYPE, _obj2, (gint *)_arg2))
    return NULL;
}
{
  static GtkAnchorType tmp; _arg3 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_ANCHOR_TYPE, _obj3, (gint *)_arg3))
    return NULL;
}
{
  static GtkPackerOptions tmp; _arg4 = &tmp;
  if (PyGtkFlag_get_value(GTK_TYPE_PACKER_OPTIONS, _obj4, (gint *)_arg4))
    return NULL;
}
    gtk_packer_configure(_arg0,_arg1,*_arg2,*_arg3,*_arg4,_arg5,_arg6,_arg7,_arg8,_arg9);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_reorder_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_packer_reorder_child",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_packer_reorder_child(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_set_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_packer_set_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_packer_set_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_set_default_border_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_packer_set_default_border_width",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_packer_set_default_border_width(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_set_default_pad(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_packer_set_default_pad",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_packer_set_default_pad(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_packer_set_default_ipad(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPacker * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_packer_set_default_ipad",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PACKER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_packer_set_default_ipad(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_paned_get_type")) 
        return NULL;
    _result = (int )gtk_paned_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_add1(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_paned_add1",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_add1(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_add2(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_paned_add2",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_add2(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_handle_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_paned_handle_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_handle_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_gutter_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_paned_gutter_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_gutter_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_pixmap_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_pixmap_get_type")) 
        return NULL;
    _result = (int )gtk_pixmap_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_pixmap_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GdkPixmap * _arg0;
    GdkBitmap * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_pixmap_new",&_obj0,&_obj1)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    _result = (GtkWidget *)gtk_pixmap_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_pixmap_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPixmap * _arg0;
    GdkPixmap * _arg1;
    GdkBitmap * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_pixmap_set",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PIXMAP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj2))
    _arg2 = PyGdkWindow_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_pixmap_set(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_preview_get_type")) 
        return NULL;
    _result = (int )gtk_preview_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_uninit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_preview_uninit")) 
        return NULL;
    gtk_preview_uninit();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_preview_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_preview_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_put(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    GdkWindow * _arg1;
    GdkGC * _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOiiiiii:gtk_preview_put",&_obj0,&_obj1,&_obj2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj2))
    _arg2 = PyGdkGC_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gtk_preview_put(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_draw_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    char * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osiii:gtk_preview_draw_row",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_draw_row(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_expand(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_preview_set_expand",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_set_expand(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_gamma(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"d:gtk_preview_set_gamma",&_arg0)) 
        return NULL;
    gtk_preview_set_gamma(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_color_cube(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    unsigned int  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"iiii:gtk_preview_set_color_cube",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    gtk_preview_set_color_cube(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_install_cmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_set_install_cmap",&_arg0)) 
        return NULL;
    gtk_preview_set_install_cmap(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_reserved(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_set_reserved",&_arg0)) 
        return NULL;
    gtk_preview_set_reserved(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_progress_get_type")) 
        return NULL;
    _result = (int )gtk_progress_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_show_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_progress_set_show_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_show_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_text_alignment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_progress_set_text_alignment",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_text_alignment(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_format_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_progress_set_format_string",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_format_string(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_progress_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_reconfigure(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:gtk_progress_reconfigure",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_reconfigure(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_percentage(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_set_percentage",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_percentage(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkProgress * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_progress_get_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_progress_get_value(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_set_activity_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgress * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_progress_set_activity_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_set_activity_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_current_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkProgress * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_progress_get_current_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_progress_get_current_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_text_from_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkProgress * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_get_text_from_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_progress_get_text_from_value(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_current_percentage(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkProgress * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_progress_get_current_percentage",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_progress_get_current_percentage(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_get_percentage_from_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkProgress * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_get_percentage_from_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_progress_get_percentage_from_value(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_progress_bar_get_type")) 
        return NULL;
    _result = (int )gtk_progress_bar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_progress_bar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_progress_bar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_new_with_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_progress_bar_new_with_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_progress_bar_new_with_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_set_bar_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    GtkProgressBarStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_progress_bar_set_bar_style",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkProgressBarStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_PROGRESS_BAR_STYLE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_progress_bar_set_bar_style(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_set_discrete_blocks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_progress_bar_set_discrete_blocks",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_bar_set_discrete_blocks(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_set_activity_step(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_progress_bar_set_activity_step",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_bar_set_activity_step(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_set_activity_blocks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_progress_bar_set_activity_blocks",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_bar_set_activity_blocks(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_set_orientation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    GtkProgressBarOrientation * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_progress_bar_set_orientation",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkProgressBarOrientation tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_PROGRESS_BAR_ORIENTATION, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_progress_bar_set_orientation(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_update(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_bar_update",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_bar_update(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_button_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_radio_button_get_type")) 
        return NULL;
    _result = (int )gtk_radio_button_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GSList * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_radio_button_new",&_obj0)) 
        return NULL;
    if (_obj0)
{ _arg0 = NULL; }
    _result = (GtkWidget *)gtk_radio_button_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_button_new_from_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkRadioButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_radio_button_new_from_widget",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RADIO_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_radio_button_new_from_widget(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GSList * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_radio_button_new_with_label",&_obj0,&_arg1)) 
        return NULL;
{ _arg0 = NULL; }
    _result = (GtkWidget *)gtk_radio_button_new_with_label(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_button_new_with_label_from_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkRadioButton * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_radio_button_new_with_label_from_widget",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RADIO_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_radio_button_new_with_label_from_widget(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_radio_menu_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_radio_menu_item_get_type")) 
        return NULL;
    _result = (int )gtk_radio_menu_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_range_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_range_get_type")) 
        return NULL;
    _result = (int )gtk_range_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_range_get_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_get_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_range_get_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_range_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    GtkUpdateType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_range_set_update_policy",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkUpdateType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_UPDATE_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_range_set_update_policy(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_range_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_background(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_background",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_background(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_trough(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_trough",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_trough(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_slider(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_slider",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_slider(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_step_forw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_step_forw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_step_forw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_step_back(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_step_back",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_step_back(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_slider_update(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_slider_update",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_slider_update(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_ruler_get_type")) 
        return NULL;
    _result = (int )gtk_ruler_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_set_metric(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    GtkMetricType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_ruler_set_metric",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkMetricType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_METRIC_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_ruler_set_metric(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_set_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_ruler_set_range",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_set_range(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_draw_ticks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_ruler_draw_ticks",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_draw_ticks(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_draw_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_ruler_draw_pos",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_draw_pos(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_scale_get_type")) 
        return NULL;
    _result = (int )gtk_scale_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_digits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_digits",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_digits(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_draw_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_draw_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_draw_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_value_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_value_pos",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_value_pos(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_value_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkScale * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scale_value_width",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_scale_value_width(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_draw_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scale_draw_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_draw_value(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scrollbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_scrollbar_get_type")) 
        return NULL;
    _result = (int )gtk_scrollbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_scrolled_window_get_type")) 
        return NULL;
    _result = (int )gtk_scrolled_window_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_scrolled_window_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_scrolled_window_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkScrolledWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scrolled_window_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_scrolled_window_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkScrolledWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scrolled_window_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_scrolled_window_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScrolledWindow * _arg0;
    GtkPolicyType * _arg1;
    GtkPolicyType * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_scrolled_window_set_policy",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkPolicyType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
{
  static GtkPolicyType tmp; _arg2 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_POLICY_TYPE, _obj2, (gint *)_arg2))
    return NULL;
}
    gtk_scrolled_window_set_policy(_arg0,*_arg1,*_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_separator_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_separator_get_type")) 
        return NULL;
    _result = (int )gtk_separator_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_spin_button_get_type")) 
        return NULL;
    _result = (int )gtk_spin_button_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0;
    double  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odi:gtk_spin_button_new",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_spin_button_new(_arg0,_arg1,_arg2);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_new_no_adj(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    double  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"di:gtk_spin_button_new_no_adj",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_spin_button_new_no_adj(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_spin_button_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_spin_button_get_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_digits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_digits",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_digits(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_value_as_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_value_as_float",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_spin_button_get_value_as_float(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_value_as_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_value_as_int",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_spin_button_get_value_as_int(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_spin_button_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    GtkSpinButtonUpdatePolicy * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_spin_button_set_update_policy",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSpinButtonUpdatePolicy tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_spin_button_set_update_policy(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_numeric(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_numeric",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_numeric(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_spin(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oid:gtk_spin_button_spin",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_spin(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_wrap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_wrap",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_wrap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_shadow_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    GtkShadowType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_spin_button_set_shadow_type",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkShadowType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SHADOW_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_spin_button_set_shadow_type(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_snap_to_ticks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_snap_to_ticks",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_snap_to_ticks(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_statusbar_get_type")) 
        return NULL;
    _result = (int )gtk_statusbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_statusbar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_statusbar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_get_context_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkStatusbar * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_statusbar_get_context_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_statusbar_get_context_id(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_push(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkStatusbar * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gtk_statusbar_push",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_statusbar_push(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_pop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStatusbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_statusbar_pop",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_statusbar_pop(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStatusbar * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_statusbar_remove",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_statusbar_remove(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_table_get_type")) 
        return NULL;
    _result = (int )gtk_table_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_table_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:gtk_table_new",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (GtkWidget *)gtk_table_new(_arg0,_arg1,_arg2);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_table_attach(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    GtkAttachOptions * _arg6;
    GtkAttachOptions * _arg7;
    int  _arg8;
    int  _arg9;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj6 = 0;
    PyObject * _obj7 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiiOOii:gtk_table_attach",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_obj6,&_obj7,&_arg8,&_arg9)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkAttachOptions tmp; _arg6 = &tmp;
  if (PyGtkFlag_get_value(GTK_TYPE_ATTACH_OPTIONS, _obj6, (gint *)_arg6))
    return NULL;
}
{
  static GtkAttachOptions tmp; _arg7 = &tmp;
  if (PyGtkFlag_get_value(GTK_TYPE_ATTACH_OPTIONS, _obj7, (gint *)_arg7))
    return NULL;
}
    gtk_table_attach(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,*_arg6,*_arg7,_arg8,_arg9);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_attach_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiii:gtk_table_attach_defaults",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_attach_defaults(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_row_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_table_set_row_spacing",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_row_spacing(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_col_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_table_set_col_spacing",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_col_spacing(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_row_spacings(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_row_spacings",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_row_spacings(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_col_spacings(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_col_spacings",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_col_spacings(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_homogeneous(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_homogeneous",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_homogeneous(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_text_get_type")) 
        return NULL;
    _result = (int )gtk_text_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_text_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_text_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_editable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_editable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_editable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_word_wrap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_word_wrap",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_word_wrap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_adjustments(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    GtkAdjustment * _arg1;
    GtkAdjustment * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_text_set_adjustments",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_ADJUSTMENT(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_adjustments(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_text_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_text_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_point",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_point(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_point",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (unsigned int )gtk_text_get_point(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_length",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (unsigned int )gtk_text_get_length(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    GdkFont * _arg1;
    GdkColor * _arg2;
    GdkColor * _arg3;
    char * _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOsi:gtk_text_insert",&_obj0,&_obj1,&_obj2,&_obj3,&_arg4,&_arg5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkFont_Check(_obj1))
    _arg1 = PyGdkFont_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkFont");
    return NULL;
  }
}
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
{
  if (PyGdkColor_Check(_obj3))
    _arg3 = PyGdkColor_Get(_obj3);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gtk_text_insert(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_backward_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_backward_delete",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_text_backward_delete(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_forward_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_forward_delete",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_text_forward_delete(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tips_query_get_type")) 
        return NULL;
    _result = (int )gtk_tips_query_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tips_query_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tips_query_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_start_query(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tips_query_start_query",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_start_query(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_stop_query(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tips_query_stop_query",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_stop_query(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_set_caller(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tips_query_set_caller",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_set_caller(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_set_labels(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:gtk_tips_query_set_labels",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_set_labels(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_toggle_button_get_type")) 
        return NULL;
    _result = (int )gtk_toggle_button_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_toggle_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_toggle_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_toggle_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_toggle_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_set_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toggle_button_set_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_set_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_set_state(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toggle_button_set_state",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_set_state(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_toggled(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toggle_button_toggled",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_toggled(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkToggleButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toggle_button_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_toggle_button_get_active(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_toolbar_get_type")) 
        return NULL;
    _result = (int )gtk_toolbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_toolbar_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_toolbar_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_append_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toolbar_append_space",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_append_space(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_prepend_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toolbar_prepend_space",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_prepend_space(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_insert_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_insert_space",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_insert_space(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_append_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_toolbar_append_widget",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_append_widget(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_prepend_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_toolbar_prepend_widget",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_prepend_widget(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_insert_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOssi:gtk_toolbar_insert_widget",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_insert_widget(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_orientation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkOrientation * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_toolbar_set_orientation",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkOrientation tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_ORIENTATION, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_toolbar_set_orientation(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkToolbarStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_toolbar_set_style",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkToolbarStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_TOOLBAR_STYLE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_toolbar_set_style(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_space_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_space_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_space_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_tooltips(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_tooltips",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_tooltips(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_button_relief(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkReliefStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_toolbar_set_button_relief",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkReliefStyle tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_RELIEF_STYLE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_toolbar_set_button_relief(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_get_button_relief(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkReliefStyle * _result;
    GtkToolbar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toolbar_get_button_relief",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkReliefStyle *) malloc(sizeof(GtkReliefStyle ));
    *(_result) = gtk_toolbar_get_button_relief(_arg0);
{
  _resultobj = PyInt_FromLong((int)(_result));
}
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_get_type")) 
        return NULL;
    _result = (int )gtk_tree_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_get_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GList * _result;
    GtkTree * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_get_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GList *)gtk_tree_get_selection(_arg0);
{
	GList *t;
        _resultobj = PyList_New(0);
        for (t = _result; t != NULL; t = t->next)
            PyList_Append(_resultobj, PyGtk_New(GTK_OBJECT(t->data)));
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_tree_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_remove_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_remove_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)PyGtk_Get(item));
        }
    }
    gtk_tree_remove_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_clear_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_tree_clear_items",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_clear_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_select_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_select_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_select_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_unselect_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_unselect_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_unselect_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_select_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_select_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_select_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_unselect_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_unselect_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_unselect_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_child_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_child_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_tree_child_position(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkSelectionMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_set_selection_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkSelectionMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SELECTION_MODE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_tree_set_selection_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_view_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkTreeViewMode * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_set_view_mode",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkTreeViewMode tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_TREE_VIEW_MODE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_tree_set_view_mode(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_view_lines(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_set_view_lines",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_set_view_lines(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_item_get_type")) 
        return NULL;
    _result = (int )gtk_tree_item_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_tree_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_set_subtree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_item_set_subtree",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_set_subtree(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_expand(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_expand",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_expand(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_collapse(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_collapse",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_collapse(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_remove_subtree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_remove_subtree",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_remove_subtree(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_vbox_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbox_get_type")) 
        return NULL;
    _result = (int )gtk_vbox_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbox_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_vbox_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_vbox_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_get_type")) 
        return NULL;
    _result = (int )gtk_vbutton_box_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vbutton_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_get_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_get_spacing_default")) 
        return NULL;
    _result = (int )gtk_vbutton_box_get_spacing_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_set_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_vbutton_box_set_spacing_default",&_arg0)) 
        return NULL;
    gtk_vbutton_box_set_spacing_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_get_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBoxStyle * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_get_layout_default")) 
        return NULL;
    _result = (GtkButtonBoxStyle *) malloc(sizeof(GtkButtonBoxStyle ));
    *(_result) = gtk_vbutton_box_get_layout_default();
{
  _resultobj = PyInt_FromLong((int)(_result));
}
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_set_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBoxStyle * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_vbutton_box_set_layout_default",&_obj0)) 
        return NULL;
{
  static GtkButtonBoxStyle tmp; _arg0 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_BUTTON_BOX_STYLE, _obj0, (gint *)_arg0))
    return NULL;
}
    gtk_vbutton_box_set_layout_default(*_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_viewport_get_type")) 
        return NULL;
    _result = (int )gtk_viewport_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_viewport_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_viewport_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkViewport * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_viewport_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_viewport_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkViewport * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_viewport_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_viewport_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_viewport_set_hadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_viewport_set_hadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_viewport_set_vadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_viewport_set_vadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_shadow_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    GtkShadowType * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_viewport_set_shadow_type",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  static GtkShadowType tmp; _arg1 = &tmp;
  if (PyGtkEnum_get_value(GTK_TYPE_SHADOW_TYPE, _obj1, (gint *)_arg1))
    return NULL;
}
    gtk_viewport_set_shadow_type(_arg0,*_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_vpaned_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vpaned_get_type")) 
        return NULL;
    _result = (int )gtk_vpaned_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vpaned_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vpaned_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vpaned_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vruler_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vruler_get_type")) 
        return NULL;
    _result = (int )gtk_vruler_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vruler_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vruler_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vruler_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vscale_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vscale_get_type")) 
        return NULL;
    _result = (int )gtk_vscale_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vscale_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_vscale_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_vscale_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vscrollbar_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vscrollbar_get_type")) 
        return NULL;
    _result = (int )gtk_vscrollbar_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vscrollbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_vscrollbar_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_vscrollbar_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vseparator_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vseparator_get_type")) 
        return NULL;
    _result = (int )gtk_vseparator_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vseparator_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vseparator_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vseparator_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tooltips_get_type")) 
        return NULL;
    _result = (int )gtk_tooltips_get_type();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tooltips_new")) 
        return NULL;
    _result = (GtkTooltips *)gtk_tooltips_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_enable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tooltips_enable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_enable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_disable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tooltips_disable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_disable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_delay(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tooltips_set_delay",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_set_delay(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_tip(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_tooltips_set_tip",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_set_tip(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_colors(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    GdkColor * _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_tooltips_set_colors",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkColor_Check(_obj1))
    _arg1 = PyGdkColor_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
{
  if (PyGdkColor_Check(_obj2))
    _arg2 = PyGdkColor_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
    gtk_tooltips_set_colors(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef _gtkMethods[] = {
	 { "gtk_tooltips_set_colors", _wrap_gtk_tooltips_set_colors, 1 },
	 { "gtk_tooltips_set_tip", _wrap_gtk_tooltips_set_tip, 1 },
	 { "gtk_tooltips_set_delay", _wrap_gtk_tooltips_set_delay, 1 },
	 { "gtk_tooltips_disable", _wrap_gtk_tooltips_disable, 1 },
	 { "gtk_tooltips_enable", _wrap_gtk_tooltips_enable, 1 },
	 { "gtk_tooltips_new", _wrap_gtk_tooltips_new, 1 },
	 { "gtk_tooltips_get_type", _wrap_gtk_tooltips_get_type, 1 },
	 { "gtk_vseparator_new", _wrap_gtk_vseparator_new, 1 },
	 { "gtk_vseparator_get_type", _wrap_gtk_vseparator_get_type, 1 },
	 { "gtk_vscrollbar_new", _wrap_gtk_vscrollbar_new, 1 },
	 { "gtk_vscrollbar_get_type", _wrap_gtk_vscrollbar_get_type, 1 },
	 { "gtk_vscale_new", _wrap_gtk_vscale_new, 1 },
	 { "gtk_vscale_get_type", _wrap_gtk_vscale_get_type, 1 },
	 { "gtk_vruler_new", _wrap_gtk_vruler_new, 1 },
	 { "gtk_vruler_get_type", _wrap_gtk_vruler_get_type, 1 },
	 { "gtk_vpaned_new", _wrap_gtk_vpaned_new, 1 },
	 { "gtk_vpaned_get_type", _wrap_gtk_vpaned_get_type, 1 },
	 { "gtk_viewport_set_shadow_type", _wrap_gtk_viewport_set_shadow_type, 1 },
	 { "gtk_viewport_set_vadjustment", _wrap_gtk_viewport_set_vadjustment, 1 },
	 { "gtk_viewport_set_hadjustment", _wrap_gtk_viewport_set_hadjustment, 1 },
	 { "gtk_viewport_get_vadjustment", _wrap_gtk_viewport_get_vadjustment, 1 },
	 { "gtk_viewport_get_hadjustment", _wrap_gtk_viewport_get_hadjustment, 1 },
	 { "gtk_viewport_new", _wrap_gtk_viewport_new, 1 },
	 { "gtk_viewport_get_type", _wrap_gtk_viewport_get_type, 1 },
	 { "gtk_vbutton_box_set_layout_default", _wrap_gtk_vbutton_box_set_layout_default, 1 },
	 { "gtk_vbutton_box_get_layout_default", _wrap_gtk_vbutton_box_get_layout_default, 1 },
	 { "gtk_vbutton_box_set_spacing_default", _wrap_gtk_vbutton_box_set_spacing_default, 1 },
	 { "gtk_vbutton_box_get_spacing_default", _wrap_gtk_vbutton_box_get_spacing_default, 1 },
	 { "gtk_vbutton_box_new", _wrap_gtk_vbutton_box_new, 1 },
	 { "gtk_vbutton_box_get_type", _wrap_gtk_vbutton_box_get_type, 1 },
	 { "gtk_vbox_new", _wrap_gtk_vbox_new, 1 },
	 { "gtk_vbox_get_type", _wrap_gtk_vbox_get_type, 1 },
	 { "gtk_tree_item_remove_subtree", _wrap_gtk_tree_item_remove_subtree, 1 },
	 { "gtk_tree_item_collapse", _wrap_gtk_tree_item_collapse, 1 },
	 { "gtk_tree_item_expand", _wrap_gtk_tree_item_expand, 1 },
	 { "gtk_tree_item_deselect", _wrap_gtk_tree_item_deselect, 1 },
	 { "gtk_tree_item_select", _wrap_gtk_tree_item_select, 1 },
	 { "gtk_tree_item_set_subtree", _wrap_gtk_tree_item_set_subtree, 1 },
	 { "gtk_tree_item_new_with_label", _wrap_gtk_tree_item_new_with_label, 1 },
	 { "gtk_tree_item_new", _wrap_gtk_tree_item_new, 1 },
	 { "gtk_tree_item_get_type", _wrap_gtk_tree_item_get_type, 1 },
	 { "gtk_tree_set_view_lines", _wrap_gtk_tree_set_view_lines, 1 },
	 { "gtk_tree_set_view_mode", _wrap_gtk_tree_set_view_mode, 1 },
	 { "gtk_tree_set_selection_mode", _wrap_gtk_tree_set_selection_mode, 1 },
	 { "gtk_tree_child_position", _wrap_gtk_tree_child_position, 1 },
	 { "gtk_tree_unselect_child", _wrap_gtk_tree_unselect_child, 1 },
	 { "gtk_tree_select_child", _wrap_gtk_tree_select_child, 1 },
	 { "gtk_tree_unselect_item", _wrap_gtk_tree_unselect_item, 1 },
	 { "gtk_tree_select_item", _wrap_gtk_tree_select_item, 1 },
	 { "gtk_tree_clear_items", _wrap_gtk_tree_clear_items, 1 },
	 { "gtk_tree_remove_items", _wrap_gtk_tree_remove_items, 1 },
	 { "gtk_tree_insert", _wrap_gtk_tree_insert, 1 },
	 { "gtk_tree_prepend", _wrap_gtk_tree_prepend, 1 },
	 { "gtk_tree_append", _wrap_gtk_tree_append, 1 },
	 { "gtk_tree_get_selection", _wrap_gtk_tree_get_selection, 1 },
	 { "gtk_tree_new", _wrap_gtk_tree_new, 1 },
	 { "gtk_tree_get_type", _wrap_gtk_tree_get_type, 1 },
	 { "gtk_toolbar_get_button_relief", _wrap_gtk_toolbar_get_button_relief, 1 },
	 { "gtk_toolbar_set_button_relief", _wrap_gtk_toolbar_set_button_relief, 1 },
	 { "gtk_toolbar_set_tooltips", _wrap_gtk_toolbar_set_tooltips, 1 },
	 { "gtk_toolbar_set_space_size", _wrap_gtk_toolbar_set_space_size, 1 },
	 { "gtk_toolbar_set_style", _wrap_gtk_toolbar_set_style, 1 },
	 { "gtk_toolbar_set_orientation", _wrap_gtk_toolbar_set_orientation, 1 },
	 { "gtk_toolbar_insert_widget", _wrap_gtk_toolbar_insert_widget, 1 },
	 { "gtk_toolbar_prepend_widget", _wrap_gtk_toolbar_prepend_widget, 1 },
	 { "gtk_toolbar_append_widget", _wrap_gtk_toolbar_append_widget, 1 },
	 { "gtk_toolbar_insert_space", _wrap_gtk_toolbar_insert_space, 1 },
	 { "gtk_toolbar_prepend_space", _wrap_gtk_toolbar_prepend_space, 1 },
	 { "gtk_toolbar_append_space", _wrap_gtk_toolbar_append_space, 1 },
	 { "gtk_toolbar_insert_item", gtk__toolbar_insert_item, 1 },
	 { "gtk_toolbar_prepend_item", gtk__toolbar_prepend_item, 1 },
	 { "gtk_toolbar_append_item", gtk__toolbar_append_item, 1 },
	 { "gtk_toolbar_new", _wrap_gtk_toolbar_new, 1 },
	 { "gtk_toolbar_get_type", _wrap_gtk_toolbar_get_type, 1 },
	 { "gtk_toggle_button_get_active", _wrap_gtk_toggle_button_get_active, 1 },
	 { "gtk_toggle_button_toggled", _wrap_gtk_toggle_button_toggled, 1 },
	 { "gtk_toggle_button_set_state", _wrap_gtk_toggle_button_set_state, 1 },
	 { "gtk_toggle_button_set_mode", _wrap_gtk_toggle_button_set_mode, 1 },
	 { "gtk_toggle_button_new_with_label", _wrap_gtk_toggle_button_new_with_label, 1 },
	 { "gtk_toggle_button_new", _wrap_gtk_toggle_button_new, 1 },
	 { "gtk_toggle_button_get_type", _wrap_gtk_toggle_button_get_type, 1 },
	 { "gtk_tips_query_set_labels", _wrap_gtk_tips_query_set_labels, 1 },
	 { "gtk_tips_query_set_caller", _wrap_gtk_tips_query_set_caller, 1 },
	 { "gtk_tips_query_stop_query", _wrap_gtk_tips_query_stop_query, 1 },
	 { "gtk_tips_query_start_query", _wrap_gtk_tips_query_start_query, 1 },
	 { "gtk_tips_query_new", _wrap_gtk_tips_query_new, 1 },
	 { "gtk_tips_query_get_type", _wrap_gtk_tips_query_get_type, 1 },
	 { "gtk_text_insert_defaults", gtk__text_insert_defaults, 1 },
	 { "gtk_text_forward_delete", _wrap_gtk_text_forward_delete, 1 },
	 { "gtk_text_backward_delete", _wrap_gtk_text_backward_delete, 1 },
	 { "gtk_text_insert", _wrap_gtk_text_insert, 1 },
	 { "gtk_text_thaw", _wrap_gtk_text_thaw, 1 },
	 { "gtk_text_freeze", _wrap_gtk_text_freeze, 1 },
	 { "gtk_text_get_length", _wrap_gtk_text_get_length, 1 },
	 { "gtk_text_get_point", _wrap_gtk_text_get_point, 1 },
	 { "gtk_text_set_point", _wrap_gtk_text_set_point, 1 },
	 { "gtk_text_get_vadjustment", _wrap_gtk_text_get_vadjustment, 1 },
	 { "gtk_text_get_hadjustment", _wrap_gtk_text_get_hadjustment, 1 },
	 { "gtk_text_set_adjustments", _wrap_gtk_text_set_adjustments, 1 },
	 { "gtk_text_set_word_wrap", _wrap_gtk_text_set_word_wrap, 1 },
	 { "gtk_text_set_editable", _wrap_gtk_text_set_editable, 1 },
	 { "gtk_text_new", _wrap_gtk_text_new, 1 },
	 { "gtk_text_get_type", _wrap_gtk_text_get_type, 1 },
	 { "gtk_table_set_homogeneous", _wrap_gtk_table_set_homogeneous, 1 },
	 { "gtk_table_set_col_spacings", _wrap_gtk_table_set_col_spacings, 1 },
	 { "gtk_table_set_row_spacings", _wrap_gtk_table_set_row_spacings, 1 },
	 { "gtk_table_set_col_spacing", _wrap_gtk_table_set_col_spacing, 1 },
	 { "gtk_table_set_row_spacing", _wrap_gtk_table_set_row_spacing, 1 },
	 { "gtk_table_attach_defaults", _wrap_gtk_table_attach_defaults, 1 },
	 { "gtk_table_attach", _wrap_gtk_table_attach, 1 },
	 { "gtk_table_new", _wrap_gtk_table_new, 1 },
	 { "gtk_table_get_type", _wrap_gtk_table_get_type, 1 },
	 { "gtk_statusbar_remove", _wrap_gtk_statusbar_remove, 1 },
	 { "gtk_statusbar_pop", _wrap_gtk_statusbar_pop, 1 },
	 { "gtk_statusbar_push", _wrap_gtk_statusbar_push, 1 },
	 { "gtk_statusbar_get_context_id", _wrap_gtk_statusbar_get_context_id, 1 },
	 { "gtk_statusbar_new", _wrap_gtk_statusbar_new, 1 },
	 { "gtk_statusbar_get_type", _wrap_gtk_statusbar_get_type, 1 },
	 { "gtk_spin_button_set_snap_to_ticks", _wrap_gtk_spin_button_set_snap_to_ticks, 1 },
	 { "gtk_spin_button_set_shadow_type", _wrap_gtk_spin_button_set_shadow_type, 1 },
	 { "gtk_spin_button_set_wrap", _wrap_gtk_spin_button_set_wrap, 1 },
	 { "gtk_spin_button_spin", _wrap_gtk_spin_button_spin, 1 },
	 { "gtk_spin_button_set_numeric", _wrap_gtk_spin_button_set_numeric, 1 },
	 { "gtk_spin_button_set_update_policy", _wrap_gtk_spin_button_set_update_policy, 1 },
	 { "gtk_spin_button_set_value", _wrap_gtk_spin_button_set_value, 1 },
	 { "gtk_spin_button_get_value_as_int", _wrap_gtk_spin_button_get_value_as_int, 1 },
	 { "gtk_spin_button_get_value_as_float", _wrap_gtk_spin_button_get_value_as_float, 1 },
	 { "gtk_spin_button_set_digits", _wrap_gtk_spin_button_set_digits, 1 },
	 { "gtk_spin_button_get_adjustment", _wrap_gtk_spin_button_get_adjustment, 1 },
	 { "gtk_spin_button_set_adjustment", _wrap_gtk_spin_button_set_adjustment, 1 },
	 { "gtk_spin_button_new_no_adj", _wrap_gtk_spin_button_new_no_adj, 1 },
	 { "gtk_spin_button_new", _wrap_gtk_spin_button_new, 1 },
	 { "gtk_spin_button_get_type", _wrap_gtk_spin_button_get_type, 1 },
	 { "gtk_separator_get_type", _wrap_gtk_separator_get_type, 1 },
	 { "gtk_scrolled_window_set_policy", _wrap_gtk_scrolled_window_set_policy, 1 },
	 { "gtk_scrolled_window_get_vadjustment", _wrap_gtk_scrolled_window_get_vadjustment, 1 },
	 { "gtk_scrolled_window_get_hadjustment", _wrap_gtk_scrolled_window_get_hadjustment, 1 },
	 { "gtk_scrolled_window_new", _wrap_gtk_scrolled_window_new, 1 },
	 { "gtk_scrolled_window_get_type", _wrap_gtk_scrolled_window_get_type, 1 },
	 { "gtk_scrollbar_get_type", _wrap_gtk_scrollbar_get_type, 1 },
	 { "gtk_scale_draw_value", _wrap_gtk_scale_draw_value, 1 },
	 { "gtk_scale_value_width", _wrap_gtk_scale_value_width, 1 },
	 { "gtk_scale_set_value_pos", _wrap_gtk_scale_set_value_pos, 1 },
	 { "gtk_scale_set_draw_value", _wrap_gtk_scale_set_draw_value, 1 },
	 { "gtk_scale_set_digits", _wrap_gtk_scale_set_digits, 1 },
	 { "gtk_scale_get_type", _wrap_gtk_scale_get_type, 1 },
	 { "gtk_ruler_draw_pos", _wrap_gtk_ruler_draw_pos, 1 },
	 { "gtk_ruler_draw_ticks", _wrap_gtk_ruler_draw_ticks, 1 },
	 { "gtk_ruler_set_range", _wrap_gtk_ruler_set_range, 1 },
	 { "gtk_ruler_set_metric", _wrap_gtk_ruler_set_metric, 1 },
	 { "gtk_ruler_get_type", _wrap_gtk_ruler_get_type, 1 },
	 { "gtk_range_slider_update", _wrap_gtk_range_slider_update, 1 },
	 { "gtk_range_draw_step_back", _wrap_gtk_range_draw_step_back, 1 },
	 { "gtk_range_draw_step_forw", _wrap_gtk_range_draw_step_forw, 1 },
	 { "gtk_range_draw_slider", _wrap_gtk_range_draw_slider, 1 },
	 { "gtk_range_draw_trough", _wrap_gtk_range_draw_trough, 1 },
	 { "gtk_range_draw_background", _wrap_gtk_range_draw_background, 1 },
	 { "gtk_range_set_adjustment", _wrap_gtk_range_set_adjustment, 1 },
	 { "gtk_range_set_update_policy", _wrap_gtk_range_set_update_policy, 1 },
	 { "gtk_range_get_adjustment", _wrap_gtk_range_get_adjustment, 1 },
	 { "gtk_range_get_type", _wrap_gtk_range_get_type, 1 },
	 { "gtk_radio_menu_item_new_with_label", gtk__radio_menu_item_new_with_label, 1 },
	 { "gtk_radio_menu_item_new", gtk__radio_menu_item_new, 1 },
	 { "gtk_radio_menu_item_get_type", _wrap_gtk_radio_menu_item_get_type, 1 },
	 { "gtk_radio_button_new_with_label_from_widget", _wrap_gtk_radio_button_new_with_label_from_widget, 1 },
	 { "gtk_radio_button_new_with_label", _wrap_gtk_radio_button_new_with_label, 1 },
	 { "gtk_radio_button_new_from_widget", _wrap_gtk_radio_button_new_from_widget, 1 },
	 { "gtk_radio_button_new", _wrap_gtk_radio_button_new, 1 },
	 { "gtk_radio_button_get_type", _wrap_gtk_radio_button_get_type, 1 },
	 { "gtk_progress_bar_update", _wrap_gtk_progress_bar_update, 1 },
	 { "gtk_progress_bar_set_orientation", _wrap_gtk_progress_bar_set_orientation, 1 },
	 { "gtk_progress_bar_set_activity_blocks", _wrap_gtk_progress_bar_set_activity_blocks, 1 },
	 { "gtk_progress_bar_set_activity_step", _wrap_gtk_progress_bar_set_activity_step, 1 },
	 { "gtk_progress_bar_set_discrete_blocks", _wrap_gtk_progress_bar_set_discrete_blocks, 1 },
	 { "gtk_progress_bar_set_bar_style", _wrap_gtk_progress_bar_set_bar_style, 1 },
	 { "gtk_progress_bar_new_with_adjustment", _wrap_gtk_progress_bar_new_with_adjustment, 1 },
	 { "gtk_progress_bar_new", _wrap_gtk_progress_bar_new, 1 },
	 { "gtk_progress_bar_get_type", _wrap_gtk_progress_bar_get_type, 1 },
	 { "gtk_progress_get_percentage_from_value", _wrap_gtk_progress_get_percentage_from_value, 1 },
	 { "gtk_progress_get_current_percentage", _wrap_gtk_progress_get_current_percentage, 1 },
	 { "gtk_progress_get_text_from_value", _wrap_gtk_progress_get_text_from_value, 1 },
	 { "gtk_progress_get_current_text", _wrap_gtk_progress_get_current_text, 1 },
	 { "gtk_progress_set_activity_mode", _wrap_gtk_progress_set_activity_mode, 1 },
	 { "gtk_progress_get_value", _wrap_gtk_progress_get_value, 1 },
	 { "gtk_progress_set_value", _wrap_gtk_progress_set_value, 1 },
	 { "gtk_progress_set_percentage", _wrap_gtk_progress_set_percentage, 1 },
	 { "gtk_progress_reconfigure", _wrap_gtk_progress_reconfigure, 1 },
	 { "gtk_progress_set_adjustment", _wrap_gtk_progress_set_adjustment, 1 },
	 { "gtk_progress_set_format_string", _wrap_gtk_progress_set_format_string, 1 },
	 { "gtk_progress_set_text_alignment", _wrap_gtk_progress_set_text_alignment, 1 },
	 { "gtk_progress_set_show_text", _wrap_gtk_progress_set_show_text, 1 },
	 { "gtk_progress_get_type", _wrap_gtk_progress_get_type, 1 },
	 { "gtk_preview_set_reserved", _wrap_gtk_preview_set_reserved, 1 },
	 { "gtk_preview_set_install_cmap", _wrap_gtk_preview_set_install_cmap, 1 },
	 { "gtk_preview_set_color_cube", _wrap_gtk_preview_set_color_cube, 1 },
	 { "gtk_preview_set_gamma", _wrap_gtk_preview_set_gamma, 1 },
	 { "gtk_preview_set_expand", _wrap_gtk_preview_set_expand, 1 },
	 { "gtk_preview_draw_row", _wrap_gtk_preview_draw_row, 1 },
	 { "gtk_preview_put", _wrap_gtk_preview_put, 1 },
	 { "gtk_preview_size", _wrap_gtk_preview_size, 1 },
	 { "gtk_preview_new", _wrap_gtk_preview_new, 1 },
	 { "gtk_preview_uninit", _wrap_gtk_preview_uninit, 1 },
	 { "gtk_preview_get_type", _wrap_gtk_preview_get_type, 1 },
	 { "gtk_pixmap_get", gtk__pixmap_get, 1 },
	 { "gtk_pixmap_new_from_xpm", gtk__pixmap_new_from_xpm, 1 },
	 { "gtk_pixmap_set", _wrap_gtk_pixmap_set, 1 },
	 { "gtk_pixmap_new", _wrap_gtk_pixmap_new, 1 },
	 { "gtk_pixmap_get_type", _wrap_gtk_pixmap_get_type, 1 },
	 { "gtk_paned_gutter_size", _wrap_gtk_paned_gutter_size, 1 },
	 { "gtk_paned_handle_size", _wrap_gtk_paned_handle_size, 1 },
	 { "gtk_paned_add2", _wrap_gtk_paned_add2, 1 },
	 { "gtk_paned_add1", _wrap_gtk_paned_add1, 1 },
	 { "gtk_paned_get_type", _wrap_gtk_paned_get_type, 1 },
	 { "gtk_packer_set_default_ipad", _wrap_gtk_packer_set_default_ipad, 1 },
	 { "gtk_packer_set_default_pad", _wrap_gtk_packer_set_default_pad, 1 },
	 { "gtk_packer_set_default_border_width", _wrap_gtk_packer_set_default_border_width, 1 },
	 { "gtk_packer_set_spacing", _wrap_gtk_packer_set_spacing, 1 },
	 { "gtk_packer_reorder_child", _wrap_gtk_packer_reorder_child, 1 },
	 { "gtk_packer_configure", _wrap_gtk_packer_configure, 1 },
	 { "gtk_packer_add", _wrap_gtk_packer_add, 1 },
	 { "gtk_packer_add_defaults", _wrap_gtk_packer_add_defaults, 1 },
	 { "gtk_packer_new", _wrap_gtk_packer_new, 1 },
	 { "gtk_packer_get_type", _wrap_gtk_packer_get_type, 1 },
	 { "gtk_option_menu_set_history", _wrap_gtk_option_menu_set_history, 1 },
	 { "gtk_option_menu_remove_menu", _wrap_gtk_option_menu_remove_menu, 1 },
	 { "gtk_option_menu_set_menu", _wrap_gtk_option_menu_set_menu, 1 },
	 { "gtk_option_menu_get_menu", _wrap_gtk_option_menu_get_menu, 1 },
	 { "gtk_option_menu_new", _wrap_gtk_option_menu_new, 1 },
	 { "gtk_option_menu_get_type", _wrap_gtk_option_menu_get_type, 1 },
	 { "gtk_notebook_popup_disable", _wrap_gtk_notebook_popup_disable, 1 },
	 { "gtk_notebook_popup_enable", _wrap_gtk_notebook_popup_enable, 1 },
	 { "gtk_notebook_set_tab_border", _wrap_gtk_notebook_set_tab_border, 1 },
	 { "gtk_notebook_set_scrollable", _wrap_gtk_notebook_set_scrollable, 1 },
	 { "gtk_notebook_set_show_border", _wrap_gtk_notebook_set_show_border, 1 },
	 { "gtk_notebook_set_show_tabs", _wrap_gtk_notebook_set_show_tabs, 1 },
	 { "gtk_notebook_set_tab_pos", _wrap_gtk_notebook_set_tab_pos, 1 },
	 { "gtk_notebook_reorder_child", _wrap_gtk_notebook_reorder_child, 1 },
	 { "gtk_notebook_prev_page", _wrap_gtk_notebook_prev_page, 1 },
	 { "gtk_notebook_next_page", _wrap_gtk_notebook_next_page, 1 },
	 { "gtk_notebook_set_page", _wrap_gtk_notebook_set_page, 1 },
	 { "gtk_notebook_current_page", _wrap_gtk_notebook_current_page, 1 },
	 { "gtk_notebook_remove_page", _wrap_gtk_notebook_remove_page, 1 },
	 { "gtk_notebook_insert_page_menu", _wrap_gtk_notebook_insert_page_menu, 1 },
	 { "gtk_notebook_insert_page", _wrap_gtk_notebook_insert_page, 1 },
	 { "gtk_notebook_prepend_page_menu", _wrap_gtk_notebook_prepend_page_menu, 1 },
	 { "gtk_notebook_prepend_page", _wrap_gtk_notebook_prepend_page, 1 },
	 { "gtk_notebook_append_page_menu", _wrap_gtk_notebook_append_page_menu, 1 },
	 { "gtk_notebook_append_page", _wrap_gtk_notebook_append_page, 1 },
	 { "gtk_notebook_new", _wrap_gtk_notebook_new, 1 },
	 { "gtk_notebook_get_type", _wrap_gtk_notebook_get_type, 1 },
	 { "gtk_misc_set_padding", _wrap_gtk_misc_set_padding, 1 },
	 { "gtk_misc_set_alignment", _wrap_gtk_misc_set_alignment, 1 },
	 { "gtk_misc_get_type", _wrap_gtk_misc_get_type, 1 },
	 { "gtk_menu_shell_deactivate", _wrap_gtk_menu_shell_deactivate, 1 },
	 { "gtk_menu_shell_insert", _wrap_gtk_menu_shell_insert, 1 },
	 { "gtk_menu_shell_prepend", _wrap_gtk_menu_shell_prepend, 1 },
	 { "gtk_menu_shell_append", _wrap_gtk_menu_shell_append, 1 },
	 { "gtk_menu_shell_get_type", _wrap_gtk_menu_shell_get_type, 1 },
	 { "gtk_menu_item_right_justify", _wrap_gtk_menu_item_right_justify, 1 },
	 { "gtk_menu_item_activate", _wrap_gtk_menu_item_activate, 1 },
	 { "gtk_menu_item_deselect", _wrap_gtk_menu_item_deselect, 1 },
	 { "gtk_menu_item_select", _wrap_gtk_menu_item_select, 1 },
	 { "gtk_menu_item_configure", _wrap_gtk_menu_item_configure, 1 },
	 { "gtk_menu_item_set_placement", _wrap_gtk_menu_item_set_placement, 1 },
	 { "gtk_menu_item_remove_submenu", _wrap_gtk_menu_item_remove_submenu, 1 },
	 { "gtk_menu_item_set_submenu", _wrap_gtk_menu_item_set_submenu, 1 },
	 { "gtk_menu_item_new_with_label", _wrap_gtk_menu_item_new_with_label, 1 },
	 { "gtk_menu_item_new", _wrap_gtk_menu_item_new, 1 },
	 { "gtk_menu_item_get_type", _wrap_gtk_menu_item_get_type, 1 },
	 { "gtk_menu_bar_insert", _wrap_gtk_menu_bar_insert, 1 },
	 { "gtk_menu_bar_prepend", _wrap_gtk_menu_bar_prepend, 1 },
	 { "gtk_menu_bar_append", _wrap_gtk_menu_bar_append, 1 },
	 { "gtk_menu_bar_new", _wrap_gtk_menu_bar_new, 1 },
	 { "gtk_menu_bar_get_type", _wrap_gtk_menu_bar_get_type, 1 },
	 { "gtk_menu_detach", _wrap_gtk_menu_detach, 1 },
	 { "gtk_menu_get_attach_widget", _wrap_gtk_menu_get_attach_widget, 1 },
	 { "gtk_menu_set_accel_group", _wrap_gtk_menu_set_accel_group, 1 },
	 { "gtk_menu_set_active", _wrap_gtk_menu_set_active, 1 },
	 { "gtk_menu_get_active", _wrap_gtk_menu_get_active, 1 },
	 { "gtk_menu_popdown", _wrap_gtk_menu_popdown, 1 },
	 { "gtk_menu_reposition", _wrap_gtk_menu_reposition, 1 },
	 { "gtk_menu_popup", gtk__menu_popup, 1 },
	 { "gtk_menu_insert", _wrap_gtk_menu_insert, 1 },
	 { "gtk_menu_prepend", _wrap_gtk_menu_prepend, 1 },
	 { "gtk_menu_append", _wrap_gtk_menu_append, 1 },
	 { "gtk_menu_new", _wrap_gtk_menu_new, 1 },
	 { "gtk_menu_get_type", _wrap_gtk_menu_get_type, 1 },
	 { "gtk_list_item_deselect", _wrap_gtk_list_item_deselect, 1 },
	 { "gtk_list_item_select", _wrap_gtk_list_item_select, 1 },
	 { "gtk_list_item_new_with_label", _wrap_gtk_list_item_new_with_label, 1 },
	 { "gtk_list_item_new", _wrap_gtk_list_item_new, 1 },
	 { "gtk_list_item_get_type", _wrap_gtk_list_item_get_type, 1 },
	 { "gtk_list_end_drag_selection", _wrap_gtk_list_end_drag_selection, 1 },
	 { "gtk_list_undo_selection", _wrap_gtk_list_undo_selection, 1 },
	 { "gtk_list_toggle_row", _wrap_gtk_list_toggle_row, 1 },
	 { "gtk_list_toggle_focus_row", _wrap_gtk_list_toggle_focus_row, 1 },
	 { "gtk_list_toggle_add_mode", _wrap_gtk_list_toggle_add_mode, 1 },
	 { "gtk_list_scroll_vertical", _wrap_gtk_list_scroll_vertical, 1 },
	 { "gtk_list_scroll_horizontal", _wrap_gtk_list_scroll_horizontal, 1 },
	 { "gtk_list_unselect_all", _wrap_gtk_list_unselect_all, 1 },
	 { "gtk_list_select_all", _wrap_gtk_list_select_all, 1 },
	 { "gtk_list_end_selection", _wrap_gtk_list_end_selection, 1 },
	 { "gtk_list_start_selection", _wrap_gtk_list_start_selection, 1 },
	 { "gtk_list_extend_selection", _wrap_gtk_list_extend_selection, 1 },
	 { "gtk_list_set_selection_mode", _wrap_gtk_list_set_selection_mode, 1 },
	 { "gtk_list_child_position", _wrap_gtk_list_child_position, 1 },
	 { "gtk_list_unselect_child", _wrap_gtk_list_unselect_child, 1 },
	 { "gtk_list_select_child", _wrap_gtk_list_select_child, 1 },
	 { "gtk_list_unselect_item", _wrap_gtk_list_unselect_item, 1 },
	 { "gtk_list_select_item", _wrap_gtk_list_select_item, 1 },
	 { "gtk_list_clear_items", _wrap_gtk_list_clear_items, 1 },
	 { "gtk_list_remove_items", _wrap_gtk_list_remove_items, 1 },
	 { "gtk_list_prepend_items", _wrap_gtk_list_prepend_items, 1 },
	 { "gtk_list_append_items", _wrap_gtk_list_append_items, 1 },
	 { "gtk_list_insert_items", _wrap_gtk_list_insert_items, 1 },
	 { "gtk_list_get_selection", _wrap_gtk_list_get_selection, 1 },
	 { "gtk_list_new", _wrap_gtk_list_new, 1 },
	 { "gtk_list_get_type", _wrap_gtk_list_get_type, 1 },
	 { "gtk_label_set_justify", _wrap_gtk_label_set_justify, 1 },
	 { "gtk_label_get", _wrap_gtk_label_get, 1 },
	 { "gtk_label_set", _wrap_gtk_label_set, 1 },
	 { "gtk_label_new", _wrap_gtk_label_new, 1 },
	 { "gtk_label_get_type", _wrap_gtk_label_get_type, 1 },
	 { "gtk_item_toggle", _wrap_gtk_item_toggle, 1 },
	 { "gtk_item_deselect", _wrap_gtk_item_deselect, 1 },
	 { "gtk_item_select", _wrap_gtk_item_select, 1 },
	 { "gtk_item_get_type", _wrap_gtk_item_get_type, 1 },
	 { "gtk_input_dialog_new", _wrap_gtk_input_dialog_new, 1 },
	 { "gtk_input_dialog_get_type", _wrap_gtk_input_dialog_get_type, 1 },
	 { "gtk_image_get_type", _wrap_gtk_image_get_type, 1 },
	 { "gtk_hseparator_new", _wrap_gtk_hseparator_new, 1 },
	 { "gtk_hseparator_get_type", _wrap_gtk_hseparator_get_type, 1 },
	 { "gtk_hscrollbar_new", _wrap_gtk_hscrollbar_new, 1 },
	 { "gtk_hscrollbar_get_type", _wrap_gtk_hscrollbar_get_type, 1 },
	 { "gtk_hscale_new", _wrap_gtk_hscale_new, 1 },
	 { "gtk_hscale_get_type", _wrap_gtk_hscale_get_type, 1 },
	 { "gtk_hruler_new", _wrap_gtk_hruler_new, 1 },
	 { "gtk_hruler_get_type", _wrap_gtk_hruler_get_type, 1 },
	 { "gtk_hpaned_new", _wrap_gtk_hpaned_new, 1 },
	 { "gtk_hpaned_get_type", _wrap_gtk_hpaned_get_type, 1 },
	 { "gtk_hbutton_box_set_layout_default", _wrap_gtk_hbutton_box_set_layout_default, 1 },
	 { "gtk_hbutton_box_set_spacing_default", _wrap_gtk_hbutton_box_set_spacing_default, 1 },
	 { "gtk_hbutton_box_get_layout_default", _wrap_gtk_hbutton_box_get_layout_default, 1 },
	 { "gtk_hbutton_box_get_spacing_default", _wrap_gtk_hbutton_box_get_spacing_default, 1 },
	 { "gtk_hbutton_box_new", _wrap_gtk_hbutton_box_new, 1 },
	 { "gtk_hbutton_box_get_type", _wrap_gtk_hbutton_box_get_type, 1 },
	 { "gtk_hbox_new", _wrap_gtk_hbox_new, 1 },
	 { "gtk_hbox_get_type", _wrap_gtk_hbox_get_type, 1 },
	 { "gtk_handle_box_new", _wrap_gtk_handle_box_new, 1 },
	 { "gtk_handle_box_get_type", _wrap_gtk_handle_box_get_type, 1 },
	 { "gtk_gamma_curve_new", _wrap_gtk_gamma_curve_new, 1 },
	 { "gtk_gamma_curve_get_type", _wrap_gtk_gamma_curve_get_type, 1 },
	 { "gtk_frame_set_shadow_type", _wrap_gtk_frame_set_shadow_type, 1 },
	 { "gtk_frame_set_label_align", _wrap_gtk_frame_set_label_align, 1 },
	 { "gtk_frame_set_label", _wrap_gtk_frame_set_label, 1 },
	 { "gtk_frame_new", _wrap_gtk_frame_new, 1 },
	 { "gtk_frame_get_type", _wrap_gtk_frame_get_type, 1 },
	 { "gtk_font_selection_dialog_set_preview_text", _wrap_gtk_font_selection_dialog_set_preview_text, 1 },
	 { "gtk_font_selection_dialog_get_preview_text", _wrap_gtk_font_selection_dialog_get_preview_text, 1 },
	 { "gtk_font_selection_dialog_set_font_name", _wrap_gtk_font_selection_dialog_set_font_name, 1 },
	 { "gtk_font_selection_dialog_get_font", _wrap_gtk_font_selection_dialog_get_font, 1 },
	 { "gtk_font_selection_dialog_get_font_name", _wrap_gtk_font_selection_dialog_get_font_name, 1 },
	 { "gtk_font_selection_dialog_new", _wrap_gtk_font_selection_dialog_new, 1 },
	 { "gtk_font_selection_dialog_get_cancel_button", _wrap_gtk_font_selection_dialog_get_cancel_button, 1 },
	 { "gtk_font_selection_dialog_get_apply_button", _wrap_gtk_font_selection_dialog_get_apply_button, 1 },
	 { "gtk_font_selection_dialog_get_ok_button", _wrap_gtk_font_selection_dialog_get_ok_button, 1 },
	 { "gtk_font_selection_dialog_get_action_area", _wrap_gtk_font_selection_dialog_get_action_area, 1 },
	 { "gtk_font_selection_dialog_get_main_vbox", _wrap_gtk_font_selection_dialog_get_main_vbox, 1 },
	 { "gtk_font_selection_dialog_get_fontsel", _wrap_gtk_font_selection_dialog_get_fontsel, 1 },
	 { "gtk_font_selection_dialog_get_type", _wrap_gtk_font_selection_dialog_get_type, 1 },
	 { "gtk_font_selection_set_preview_text", _wrap_gtk_font_selection_set_preview_text, 1 },
	 { "gtk_font_selection_get_preview_text", _wrap_gtk_font_selection_get_preview_text, 1 },
	 { "gtk_font_selection_set_font_name", _wrap_gtk_font_selection_set_font_name, 1 },
	 { "gtk_font_selection_get_font", _wrap_gtk_font_selection_get_font, 1 },
	 { "gtk_font_selection_get_font_name", _wrap_gtk_font_selection_get_font_name, 1 },
	 { "gtk_font_selection_new", _wrap_gtk_font_selection_new, 1 },
	 { "gtk_font_selection_get_type", _wrap_gtk_font_selection_get_type, 1 },
	 { "gtk_fixed_move", _wrap_gtk_fixed_move, 1 },
	 { "gtk_fixed_put", _wrap_gtk_fixed_put, 1 },
	 { "gtk_fixed_new", _wrap_gtk_fixed_new, 1 },
	 { "gtk_fixed_get_type", _wrap_gtk_fixed_get_type, 1 },
	 { "gtk_file_selection_hide_fileop_buttons", _wrap_gtk_file_selection_hide_fileop_buttons, 1 },
	 { "gtk_file_selection_show_fileop_buttons", _wrap_gtk_file_selection_show_fileop_buttons, 1 },
	 { "gtk_file_selection_get_filename", _wrap_gtk_file_selection_get_filename, 1 },
	 { "gtk_file_selection_set_filename", _wrap_gtk_file_selection_set_filename, 1 },
	 { "gtk_file_selection_new", _wrap_gtk_file_selection_new, 1 },
	 { "gtk_file_selection_get_type", _wrap_gtk_file_selection_get_type, 1 },
	 { "gtk_file_selection_get_help_button", _wrap_gtk_file_selection_get_help_button, 1 },
	 { "gtk_file_selection_get_cancel_button", _wrap_gtk_file_selection_get_cancel_button, 1 },
	 { "gtk_file_selection_get_ok_button", _wrap_gtk_file_selection_get_ok_button, 1 },
	 { "gtk_file_selection_get_main_vbox", _wrap_gtk_file_selection_get_main_vbox, 1 },
	 { "gtk_file_selection_get_selection_text", _wrap_gtk_file_selection_get_selection_text, 1 },
	 { "gtk_file_selection_get_selection_entry", _wrap_gtk_file_selection_get_selection_entry, 1 },
	 { "gtk_file_selection_get_file_list", _wrap_gtk_file_selection_get_file_list, 1 },
	 { "gtk_file_selection_get_dir_list", _wrap_gtk_file_selection_get_dir_list, 1 },
	 { "gtk_event_box_new", _wrap_gtk_event_box_new, 1 },
	 { "gtk_event_box_get_type", _wrap_gtk_event_box_get_type, 1 },
	 { "gtk_entry_set_max_length", _wrap_gtk_entry_set_max_length, 1 },
	 { "gtk_entry_adjust_scroll", _wrap_gtk_entry_adjust_scroll, 1 },
	 { "gtk_entry_set_editable", _wrap_gtk_entry_set_editable, 1 },
	 { "gtk_entry_set_visibility", _wrap_gtk_entry_set_visibility, 1 },
	 { "gtk_entry_select_region", _wrap_gtk_entry_select_region, 1 },
	 { "gtk_entry_get_text", _wrap_gtk_entry_get_text, 1 },
	 { "gtk_entry_set_position", _wrap_gtk_entry_set_position, 1 },
	 { "gtk_entry_prepend_text", _wrap_gtk_entry_prepend_text, 1 },
	 { "gtk_entry_append_text", _wrap_gtk_entry_append_text, 1 },
	 { "gtk_entry_set_text", _wrap_gtk_entry_set_text, 1 },
	 { "gtk_entry_new_with_max_length", _wrap_gtk_entry_new_with_max_length, 1 },
	 { "gtk_entry_new", _wrap_gtk_entry_new, 1 },
	 { "gtk_entry_get_type", _wrap_gtk_entry_get_type, 1 },
	 { "gtk_editable_set_editable", _wrap_gtk_editable_set_editable, 1 },
	 { "gtk_editable_get_position", _wrap_gtk_editable_get_position, 1 },
	 { "gtk_editable_set_position", _wrap_gtk_editable_set_position, 1 },
	 { "gtk_editable_changed", _wrap_gtk_editable_changed, 1 },
	 { "gtk_editable_delete_selection", _wrap_gtk_editable_delete_selection, 1 },
	 { "gtk_editable_claim_selection", _wrap_gtk_editable_claim_selection, 1 },
	 { "gtk_editable_paste_clipboard", _wrap_gtk_editable_paste_clipboard, 1 },
	 { "gtk_editable_copy_clipboard", _wrap_gtk_editable_copy_clipboard, 1 },
	 { "gtk_editable_cut_clipboard", _wrap_gtk_editable_cut_clipboard, 1 },
	 { "gtk_editable_get_chars", _wrap_gtk_editable_get_chars, 1 },
	 { "gtk_editable_delete_text", _wrap_gtk_editable_delete_text, 1 },
	 { "gtk_editable_insert_text", gtk__editable_insert_text, 1 },
	 { "gtk_editable_select_region", _wrap_gtk_editable_select_region, 1 },
	 { "gtk_editable_get_type", _wrap_gtk_editable_get_type, 1 },
	 { "gtk_drawing_area_size", _wrap_gtk_drawing_area_size, 1 },
	 { "gtk_drawing_area_new", _wrap_gtk_drawing_area_new, 1 },
	 { "gtk_drawing_area_get_type", _wrap_gtk_drawing_area_get_type, 1 },
	 { "gtk_dialog_get_action_area", _wrap_gtk_dialog_get_action_area, 1 },
	 { "gtk_dialog_get_vbox", _wrap_gtk_dialog_get_vbox, 1 },
	 { "gtk_dialog_new", _wrap_gtk_dialog_new, 1 },
	 { "gtk_dialog_get_type", _wrap_gtk_dialog_get_type, 1 },
	 { "gtk_data_get_type", _wrap_gtk_data_get_type, 1 },
	 { "gtk_curve_set_curve_type", _wrap_gtk_curve_set_curve_type, 1 },
	 { "gtk_curve_set_vector", gtk__curve_set_vector, 1 },
	 { "gtk_curve_get_vector", gtk__curve_get_vector, 1 },
	 { "gtk_curve_set_range", _wrap_gtk_curve_set_range, 1 },
	 { "gtk_curve_set_gamma", _wrap_gtk_curve_set_gamma, 1 },
	 { "gtk_curve_reset", _wrap_gtk_curve_reset, 1 },
	 { "gtk_curve_new", _wrap_gtk_curve_new, 1 },
	 { "gtk_curve_get_type", _wrap_gtk_curve_get_type, 1 },
	 { "gtk_combo_disable_activate", _wrap_gtk_combo_disable_activate, 1 },
	 { "gtk_combo_get_list", _wrap_gtk_combo_get_list, 1 },
	 { "gtk_combo_get_entry", _wrap_gtk_combo_get_entry, 1 },
	 { "gtk_combo_set_popdown_strings", gtk__combo_set_popdown_strings, 1 },
	 { "gtk_combo_set_item_string", _wrap_gtk_combo_set_item_string, 1 },
	 { "gtk_combo_set_case_sensitive", _wrap_gtk_combo_set_case_sensitive, 1 },
	 { "gtk_combo_set_use_arrows_always", _wrap_gtk_combo_set_use_arrows_always, 1 },
	 { "gtk_combo_set_use_arrows", _wrap_gtk_combo_set_use_arrows, 1 },
	 { "gtk_combo_set_value_in_list", _wrap_gtk_combo_set_value_in_list, 1 },
	 { "gtk_combo_new", _wrap_gtk_combo_new, 1 },
	 { "gtk_combo_get_type", _wrap_gtk_combo_get_type, 1 },
	 { "gtk_color_selection_dialog_get_help_button", _wrap_gtk_color_selection_dialog_get_help_button, 1 },
	 { "gtk_color_selection_dialog_get_cancel_button", _wrap_gtk_color_selection_dialog_get_cancel_button, 1 },
	 { "gtk_color_selection_dialog_get_reset_button", _wrap_gtk_color_selection_dialog_get_reset_button, 1 },
	 { "gtk_color_selection_dialog_get_ok_button", _wrap_gtk_color_selection_dialog_get_ok_button, 1 },
	 { "gtk_color_selection_dialog_get_main_vbox", _wrap_gtk_color_selection_dialog_get_main_vbox, 1 },
	 { "gtk_color_selection_dialog_get_colorsel", _wrap_gtk_color_selection_dialog_get_colorsel, 1 },
	 { "gtk_color_selection_dialog_new", _wrap_gtk_color_selection_dialog_new, 1 },
	 { "gtk_color_selection_get_color", _wrap_gtk_color_selection_get_color, 1 },
	 { "gtk_color_selection_set_color", _wrap_gtk_color_selection_set_color, 1 },
	 { "gtk_color_selection_set_opacity", _wrap_gtk_color_selection_set_opacity, 1 },
	 { "gtk_color_selection_set_update_policy", _wrap_gtk_color_selection_set_update_policy, 1 },
	 { "gtk_color_selection_new", _wrap_gtk_color_selection_new, 1 },
	 { "gtk_color_selection_dialog_get_type", _wrap_gtk_color_selection_dialog_get_type, 1 },
	 { "gtk_color_selection_get_type", _wrap_gtk_color_selection_get_type, 1 },
	 { "gtk_clist_swap_rows", _wrap_gtk_clist_swap_rows, 1 },
	 { "gtk_clist_unselect_all", _wrap_gtk_clist_unselect_all, 1 },
	 { "gtk_clist_select_all", _wrap_gtk_clist_select_all, 1 },
	 { "gtk_clist_find_row_from_data", _wrap_gtk_clist_find_row_from_data, 1 },
	 { "gtk_clist_get_row_data", _wrap_gtk_clist_get_row_data, 1 },
	 { "gtk_clist_set_row_data", gtk__clist_set_row_data, 1 },
	 { "gtk_clist_get_selection_info", gtk__clist_get_selection_info, 1 },
	 { "gtk_clist_clear", _wrap_gtk_clist_clear, 1 },
	 { "gtk_clist_undo_selection", _wrap_gtk_clist_undo_selection, 1 },
	 { "gtk_clist_unselect_row", _wrap_gtk_clist_unselect_row, 1 },
	 { "gtk_clist_select_row", _wrap_gtk_clist_select_row, 1 },
	 { "gtk_clist_remove", _wrap_gtk_clist_remove, 1 },
	 { "gtk_clist_insert", gtk__clist_insert, 1 },
	 { "gtk_clist_append", gtk__clist_append, 1 },
	 { "gtk_clist_set_shift", _wrap_gtk_clist_set_shift, 1 },
	 { "gtk_clist_set_selection_mode", _wrap_gtk_clist_set_selection_mode, 1 },
	 { "gtk_clist_set_background", _wrap_gtk_clist_set_background, 1 },
	 { "gtk_clist_set_foreground", _wrap_gtk_clist_set_foreground, 1 },
	 { "gtk_clist_get_pixtext", gtk__clist_get_pixtext, 1 },
	 { "gtk_clist_get_pixmap", gtk__clist_get_pixmap, 1 },
	 { "gtk_clist_get_text", gtk__clist_get_text, 1 },
	 { "gtk_clist_set_pixtext", _wrap_gtk_clist_set_pixtext, 1 },
	 { "gtk_clist_set_pixmap", _wrap_gtk_clist_set_pixmap, 1 },
	 { "gtk_clist_set_text", _wrap_gtk_clist_set_text, 1 },
	 { "gtk_clist_get_cell_type", _wrap_gtk_clist_get_cell_type, 1 },
	 { "gtk_clist_moveto", _wrap_gtk_clist_moveto, 1 },
	 { "gtk_clist_set_row_height", _wrap_gtk_clist_set_row_height, 1 },
	 { "gtk_clist_set_column_width", _wrap_gtk_clist_set_column_width, 1 },
	 { "gtk_clist_set_column_justification", _wrap_gtk_clist_set_column_justification, 1 },
	 { "gtk_clist_set_column_widget", _wrap_gtk_clist_set_column_widget, 1 },
	 { "gtk_clist_set_column_title", _wrap_gtk_clist_set_column_title, 1 },
	 { "gtk_clist_column_titles_passive", _wrap_gtk_clist_column_titles_passive, 1 },
	 { "gtk_clist_column_titles_active", _wrap_gtk_clist_column_titles_active, 1 },
	 { "gtk_clist_column_title_passive", _wrap_gtk_clist_column_title_passive, 1 },
	 { "gtk_clist_column_title_active", _wrap_gtk_clist_column_title_active, 1 },
	 { "gtk_clist_column_titles_hide", _wrap_gtk_clist_column_titles_hide, 1 },
	 { "gtk_clist_column_titles_show", _wrap_gtk_clist_column_titles_show, 1 },
	 { "gtk_clist_thaw", _wrap_gtk_clist_thaw, 1 },
	 { "gtk_clist_freeze", _wrap_gtk_clist_freeze, 1 },
	 { "gtk_clist_set_policy", _wrap_gtk_clist_set_policy, 1 },
	 { "gtk_clist_set_border", _wrap_gtk_clist_set_border, 1 },
	 { "gtk_clist_row_is_visible", _wrap_gtk_clist_row_is_visible, 1 },
	 { "gtk_clist_get_selection", gtk__clist_get_selection, 1 },
	 { "gtk_clist_new_with_titles", gtk__clist_new_with_titles, 1 },
	 { "gtk_clist_new", _wrap_gtk_clist_new, 1 },
	 { "gtk_clist_get_type", _wrap_gtk_clist_get_type, 1 },
	 { "gtk_check_menu_item_get_active", _wrap_gtk_check_menu_item_get_active, 1 },
	 { "gtk_check_menu_item_set_show_toggle", _wrap_gtk_check_menu_item_set_show_toggle, 1 },
	 { "gtk_check_menu_item_toggled", _wrap_gtk_check_menu_item_toggled, 1 },
	 { "gtk_check_menu_item_set_state", _wrap_gtk_check_menu_item_set_state, 1 },
	 { "gtk_check_menu_item_new_with_label", _wrap_gtk_check_menu_item_new_with_label, 1 },
	 { "gtk_check_menu_item_new", _wrap_gtk_check_menu_item_new, 1 },
	 { "gtk_check_menu_item_get_type", _wrap_gtk_check_menu_item_get_type, 1 },
	 { "gtk_check_button_new_with_label", _wrap_gtk_check_button_new_with_label, 1 },
	 { "gtk_check_button_new", _wrap_gtk_check_button_new, 1 },
	 { "gtk_check_button_get_type", _wrap_gtk_check_button_get_type, 1 },
	 { "gtk_button_box_set_child_ipadding", _wrap_gtk_button_box_set_child_ipadding, 1 },
	 { "gtk_button_box_set_child_size", _wrap_gtk_button_box_set_child_size, 1 },
	 { "gtk_button_box_set_layout", _wrap_gtk_button_box_set_layout, 1 },
	 { "gtk_button_box_set_spacing", _wrap_gtk_button_box_set_spacing, 1 },
	 { "gtk_button_box_get_child_ipadding", gtk__button_box_get_child_ipadding_, 1 },
	 { "gtk_button_box_get_child_size", gtk__button_box_get_child_size, 1 },
	 { "gtk_button_box_get_layout", _wrap_gtk_button_box_get_layout, 1 },
	 { "gtk_button_box_get_spacing", _wrap_gtk_button_box_get_spacing, 1 },
	 { "gtk_button_box_set_child_ipadding_default", _wrap_gtk_button_box_set_child_ipadding_default, 1 },
	 { "gtk_button_box_set_child_size_default", _wrap_gtk_button_box_set_child_size_default, 1 },
	 { "gtk_button_box_get_ipadding_default", gtk__button_box_get_child_ipadding_default, 1 },
	 { "gtk_button_box_get_child_size_default", gtk__button_box_get_child_size_default, 1 },
	 { "gtk_button_box_get_type", _wrap_gtk_button_box_get_type, 1 },
	 { "gtk_button_get_relief", _wrap_gtk_button_get_relief, 1 },
	 { "gtk_button_set_relief", _wrap_gtk_button_set_relief, 1 },
	 { "gtk_button_leave", _wrap_gtk_button_leave, 1 },
	 { "gtk_button_enter", _wrap_gtk_button_enter, 1 },
	 { "gtk_button_clicked", _wrap_gtk_button_clicked, 1 },
	 { "gtk_button_released", _wrap_gtk_button_released, 1 },
	 { "gtk_button_pressed", _wrap_gtk_button_pressed, 1 },
	 { "gtk_button_new_with_label", _wrap_gtk_button_new_with_label, 1 },
	 { "gtk_button_new", _wrap_gtk_button_new, 1 },
	 { "gtk_button_get_type", _wrap_gtk_button_get_type, 1 },
	 { "gtk_box_set_child_packing", _wrap_gtk_box_set_child_packing, 1 },
	 { "gtk_box_query_child_packing", gtk__box_query_child_packing, 1 },
	 { "gtk_box_reorder_child", _wrap_gtk_box_reorder_child, 1 },
	 { "gtk_box_set_spacing", _wrap_gtk_box_set_spacing, 1 },
	 { "gtk_box_set_homogeneous", _wrap_gtk_box_set_homogeneous, 1 },
	 { "gtk_box_pack_end_defaults", _wrap_gtk_box_pack_end_defaults, 1 },
	 { "gtk_box_pack_start_defaults", _wrap_gtk_box_pack_start_defaults, 1 },
	 { "gtk_box_pack_end", _wrap_gtk_box_pack_end, 1 },
	 { "gtk_box_pack_start", _wrap_gtk_box_pack_start, 1 },
	 { "gtk_box_get_type", _wrap_gtk_box_get_type, 1 },
	 { "gtk_bin_get_type", _wrap_gtk_bin_get_type, 1 },
	 { "gtk_aspect_frame_set", _wrap_gtk_aspect_frame_set, 1 },
	 { "gtk_aspect_frame_new", _wrap_gtk_aspect_frame_new, 1 },
	 { "gtk_aspect_frame_get_type", _wrap_gtk_aspect_frame_get_type, 1 },
	 { "gtk_arrow_set", _wrap_gtk_arrow_set, 1 },
	 { "gtk_arrow_new", _wrap_gtk_arrow_new, 1 },
	 { "gtk_arrow_get_type", _wrap_gtk_arrow_get_type, 1 },
	 { "gtk_alignment_set", _wrap_gtk_alignment_set, 1 },
	 { "gtk_alignment_new", _wrap_gtk_alignment_new, 1 },
	 { "gtk_alignment_get_type", _wrap_gtk_alignment_get_type, 1 },
	 { "gtk_adjustment_clamp_page", _wrap_gtk_adjustment_clamp_page, 1 },
	 { "gtk_adjustment_set_value", _wrap_gtk_adjustment_set_value, 1 },
	 { "gtk_adjustment_value_changed", _wrap_gtk_adjustment_value_changed, 1 },
	 { "gtk_adjustment_changed", _wrap_gtk_adjustment_changed, 1 },
	 { "gtk_adjustment_get_page_size", _wrap_gtk_adjustment_get_page_size, 1 },
	 { "gtk_adjustment_get_page_increment", _wrap_gtk_adjustment_get_page_increment, 1 },
	 { "gtk_adjustment_get_step_increment", _wrap_gtk_adjustment_get_step_increment, 1 },
	 { "gtk_adjustment_get_value", _wrap_gtk_adjustment_get_value, 1 },
	 { "gtk_adjustment_get_upper", _wrap_gtk_adjustment_get_upper, 1 },
	 { "gtk_adjustment_get_lower", _wrap_gtk_adjustment_get_lower, 1 },
	 { "gtk_adjustment_new", _wrap_gtk_adjustment_new, 1 },
	 { "gtk_adjustment_get_type", _wrap_gtk_adjustment_get_type, 1 },
	 { "gtk_accel_label_refetch", _wrap_gtk_accel_label_refetch, 1 },
	 { "gtk_accel_label_set_accel_widget", _wrap_gtk_accel_label_set_accel_widget, 1 },
	 { "gtk_accel_label_accelerator_width", _wrap_gtk_accel_label_accelerator_width, 1 },
	 { "gtk_accel_label_new", _wrap_gtk_accel_label_new, 1 },
	 { "gtk_accel_label_get_type", _wrap_gtk_accel_label_get_type, 1 },
	 { "pygtk_init", _wrap_pygtk_init, 1 },
	 { "gdk_color_alloc", gdk__color_alloc, 1 },
	 { "gdk_draw_lines", gdk__draw_lines, 1 },
	 { "gdk_draw_segments", gdk__draw_segments, 1 },
	 { "gdk_draw_points", gdk__draw_points, 1 },
	 { "gdk_draw_text", gdk__draw_text, 1 },
	 { "gdk_draw_string", gdk__draw_text, 1 },
	 { "gdk_draw_polygon", gdk__draw_polygon, 1 },
	 { "gdk_draw_pixmap", _wrap_gdk_draw_pixmap, 1 },
	 { "gdk_draw_arc", _wrap_gdk_draw_arc, 1 },
	 { "gdk_draw_rectangle", _wrap_gdk_draw_rectangle, 1 },
	 { "gdk_draw_line", _wrap_gdk_draw_line, 1 },
	 { "gdk_draw_point", _wrap_gdk_draw_point, 1 },
	 { "gdk_pixmap_create_from_xpm", gdk__pixmap_create_from_xpm, 1 },
	 { "gdk_pixmap_new", gdk__pixmap_new, 1 },
	 { "gdk_fontset_load", _wrap_gdk_fontset_load, 1 },
	 { "gdk_font_load", _wrap_gdk_font_load, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,init_gtk)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("_gtk", _gtkMethods);
	 d = PyModule_GetDict(m);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
