# typemaps for Gdk types

%typemap(python,ignore) GdkRectangle *out {
  $target = malloc(sizeof(GdkRectangle));
}

%typemap(python,freearg) GdkRectangle *out {
  free($source);
}

%typemap(python,argout) GdkRectangle *out {
  $target = Py_BuildValue("(iiii)", $source->x, $source->y,
			  $source->width, $source->height);
}

%typemap(python,in) GdkRectangle * {
  if (!PyTuple_Check($source)) {
    PyErr_SetString(PyExc_TypeError, "not a tuple");
    return NULL;
  }
  $target = malloc(sizeof(GdkRectangle));
  if (!PyArg_ParseTuple($source, "iiii", &($target->x), &($target->y), &($target->width), &($target->height))) {
    free($target);
    return NULL;
  }
}

%typemap(python,freearg) GdkRectangle * {
  free($source);
}
