/***************************************************************************
    File                 : pixmaps.h
    Project              : QtiPlot
    --------------------------------------------------------------------
    Copyright            : (C) 2006-2009 by Ion Vasilief
    Email (use @ for *)  : ion_vasilief*yahoo.fr
    Description          : Various pixmaps

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/

#ifndef PIXMAPS_H
#define PIXMAPS_H

/* XPM */
static char * preview_xpm[] = {
"16 15 111 2",
"  	c None",
". 	c #BCBEBD",
"+ 	c #898C8D",
"@ 	c #787B7D",
"# 	c #A7AAA9",
"$ 	c #929EA7",
"% 	c #B7CEDF",
"& 	c #C3DBEF",
"* 	c #9CA8B4",
"= 	c #858D97",
"- 	c #87949F",
"; 	c #BCD7ED",
"> 	c #D4E7F6",
", 	c #E7F2FA",
"' 	c #E5EFF8",
") 	c #D2E3EF",
"! 	c #909AA4",
"~ 	c #B8BAB8",
"{ 	c #9AA7B3",
"] 	c #F2F5F7",
"^ 	c #7C7E80",
"/ 	c #A7C0D6",
"( 	c #C8DFF0",
"_ 	c #E0ECF6",
": 	c #E1EDF6",
"< 	c #D9E7F3",
"[ 	c #BBCBD9",
"} 	c #757778",
"| 	c #97A4B0",
"1 	c #E8EEF3",
"2 	c #E2E9EF",
"3 	c #5E6163",
"4 	c #A7C6E1",
"5 	c #CEE1EF",
"6 	c #D4E4F1",
"7 	c #D2E3F0",
"8 	c #BED4E5",
"9 	c #5D6060",
"0 	c #96A1AD",
"a 	c #E9EFF3",
"b 	c #E3EAEF",
"c 	c #65676B",
"d 	c #90B0CB",
"e 	c #BCD5E9",
"f 	c #C4DBEC",
"g 	c #BDD6E9",
"h 	c #A3BACE",
"i 	c #616364",
"j 	c #929EA9",
"k 	c #EAEFF3",
"l 	c #E4EBF0",
"m 	c #919599",
"n 	c #6F7E8C",
"o 	c #B7D2E7",
"p 	c #C8DFEF",
"q 	c #CEE3F2",
"r 	c #BBD4E7",
"s 	c #79858D",
"t 	c #8C8E8D",
"u 	c #8F9BA7",
"v 	c #ECF0F4",
"w 	c #E7ECF1",
"x 	c #D3D9DD",
"y 	c #7A7D7F",
"z 	c #74818C",
"A 	c #B5C9D8",
"B 	c #C6DCEC",
"C 	c #B4C9D7",
"D 	c #79858C",
"E 	c #5C4619",
"F 	c #976A00",
"G 	c #8C97A2",
"H 	c #EEF3F6",
"I 	c #CFD4D7",
"J 	c #8A8C8F",
"K 	c #545558",
"L 	c #404143",
"M 	c #3A3E40",
"N 	c #7F807E",
"O 	c #8B6100",
"P 	c #F3DD9E",
"Q 	c #9C6D00",
"R 	c #88949F",
"S 	c #EFF3F6",
"T 	c #EBF0F4",
"U 	c #D8DCDF",
"V 	c #C4C9CC",
"W 	c #BEC2C4",
"X 	c #727C84",
"Y 	c #8F6200",
"Z 	c #E8C039",
"` 	c #EFD47E",
" .	c #848F9A",
"..	c #F3F6F8",
"+.	c #815500",
"@.	c #E6BA21",
"#.	c #EED072",
"$.	c #818C97",
"%.	c #F6F8FA",
"&.	c #F3F6F9",
"*.	c #734900",
"=.	c #D1A61B",
"-.	c #7E8993",
";.	c #F9FAFB",
">.	c #F7F9FA",
",.	c #876D45",
"'.	c #A69A84",
").	c #7C8691",
"!.	c #FBFBFD",
"~.	c #FAFAFC",
"{.	c #79838D",
"            . + @ + .           ",
"          # $ % & % $ #         ",
"* * * * = - ; > , ' ) ! ~       ",
"{ ] ] ] ^ / ( _ : : < [ }       ",
"| 1 2 2 3 4 5 6 6 6 7 8 9       ",
"0 a b b c d e f f f g h i       ",
"j k l l m n o p q p r s t       ",
"u v w w x y z A B C D E F       ",
"G H a a a I J K L M N O P Q     ",
"R S T T T T U V W X   Y Z ` Y   ",
" ...S S S S S S S  .    +.@.#.+.",
"$.%.&.&.&.&.&.&.&.$.      *.=.*.",
"-.;.>.>.>.>.>.>.>.-.        ,.'.",
").!.~.~.~.~.~.~.~.).            ",
"{.{.{.{.{.{.{.{.{.{.            "};

/* XPM */
static char * decrease_decimals_xpm[] = {
"16 16 102 2",
"  	c None",
". 	c #D7958F",
"+ 	c #B40000",
"@ 	c #D6958F",
"# 	c #AE0000",
"$ 	c #FFCACA",
"% 	c #AD0000",
"& 	c #D5958F",
"* 	c #6D838F",
"= 	c #4E6A7B",
"- 	c #D7DAD1",
"; 	c #A70000",
"> 	c #FF7575",
", 	c #FFB0B0",
"' 	c #A60000",
") 	c #D1958D",
"! 	c #BBC3BE",
"~ 	c #345366",
"{ 	c #4D6776",
"] 	c #7E9096",
"^ 	c #BCBBB1",
"/ 	c #9F0000",
"( 	c #FF3D3D",
"_ 	c #FF9494",
": 	c #BCBCB1",
"< 	c #94A1A3",
"[ 	c #2F4D5E",
"} 	c #617780",
"| 	c #960000",
"1 	c #FF0C0C",
"2 	c #FF8080",
"3 	c #9EA9A8",
"4 	c #2A4557",
"5 	c #506772",
"6 	c #6B7D84",
"7 	c #8C0000",
"8 	c #FF0000",
"9 	c #233C4E",
"0 	c #4B5F6B",
"a 	c #B6BDB8",
"b 	c #820000",
"c 	c #FF7E7E",
"d 	c #8D9697",
"e 	c #D0D2C9",
"f 	c #780000",
"g 	c #FF8484",
"h 	c #FF1616",
"i 	c #A67771",
"j 	c #6F0000",
"k 	c #FF2F2F",
"l 	c #A27771",
"m 	c #DAD9CD",
"n 	c #9F7771",
"o 	c #670000",
"p 	c #DAD8CD",
"q 	c #738187",
"r 	c #496373",
"s 	c #ADB7B7",
"t 	c #669CDF",
"u 	c #4180D2",
"v 	c #3972BB",
"w 	c #C6CED1",
"x 	c #7D8F94",
"y 	c #4D6775",
"z 	c #345365",
"A 	c #BAC1BC",
"B 	c #B7CADC",
"C 	c #2973DE",
"D 	c #4483DE",
"E 	c #77A2DD",
"F 	c #61767F",
"G 	c #2F4C5E",
"H 	c #93A0A1",
"I 	c #8EAFD9",
"J 	c #236DD7",
"K 	c #588ED8",
"L 	c #6A7C83",
"M 	c #506671",
"N 	c #294557",
"O 	c #9DA7A6",
"P 	c #D1D3C9",
"Q 	c #839194",
"R 	c #36505F",
"S 	c #9AB3D2",
"T 	c #2161C4",
"U 	c #4A7CC9",
"V 	c #658FCC",
"W 	c #738186",
"X 	c #D0D2C8",
"Y 	c #4B5F6A",
"Z 	c #586A73",
"` 	c #304857",
" .	c #808D8F",
"..	c #1E53AB",
"+.	c #4771B4",
"@.	c #B4C1CE",
"#.	c #B5B9B3",
"$.	c #CFD0C7",
"%.	c #8C9595",
"&.	c #99A09F",
"*.	c #8A9DBA",
"=.	c #CFD3D2",
"            . + .         @ + . ",
"            # $ % &     & # $ # ",
"  * = = -   ; > , ' ) ) ; , > ; ",
"! ~   { ]   ^ / ( _ / / _ ( / : ",
"< [   } }     ^ | 1 2 2 1 | :   ",
"3 4   5 6       7 8 8 8 8 7     ",
"  9 0 9 a     b c 8 b b 8 c b   ",
"    d e     f g h f i i f h g f ",
"            j k j l m m l j k j ",
"            n o n m     m n o n ",
"    - = = * p q r = s   t u v w ",
"    x y   z A z A x y B C   D E ",
"    F F   G H G   H G I J   K K ",
"    L M   N O N P Q R S T   U V ",
"W W X 9 Y 9   Z ` 9  .  ..+...@.",
"#.#.  $.%.      &.#.      *.=.  "};

/* XPM */
static char * increase_decimals_xpm[] = {
"16 16 60 1",
" 	c None",
".	c #39AA00",
"+	c #37A700",
"@	c #DFF290",
"#	c #33A000",
"$	c #C8DF79",
"%	c #2E9900",
"&	c #DCF088",
"*	c #C4DD6E",
"=	c #669CDF",
"-	c #4588DF",
";	c #289200",
">	c #C1DB65",
",	c #B8CBDF",
"'	c #2A73DF",
")	c #4483DF",
"!	c #77A3DF",
"~	c #BCBCB2",
"{	c #228B00",
"]	c #BFDA5E",
"^	c #8EB0DC",
"/	c #236DD7",
"(	c #588ED9",
"_	c #1E8500",
":	c #9BB4D5",
"<	c #2161C4",
"[	c #4A7DCA",
"}	c #658FCD",
"|	c #1E53AB",
"1	c #4771B6",
"2	c #B5C2D1",
"3	c #8B9EBC",
"4	c #ADB7B7",
"5	c #4E6A7B",
"6	c #8D9DA3",
"7	c #6D838F",
"8	c #4E697B",
"9	c #4D6775",
"0	c #7D8F95",
"a	c #BAC1BD",
"b	c #345365",
"c	c #7D8F94",
"d	c #2F4C5E",
"e	c #93A0A1",
"f	c #61767F",
"g	c #365060",
"h	c #839195",
"i	c #294557",
"j	c #9DA7A7",
"k	c #506671",
"l	c #6A7C83",
"m	c #4B5F6A",
"n	c #9BA4A3",
"o	c #8E999A",
"p	c #233C4E",
"q	c #304857",
"r	c #B6BBB5",
"s	c #99A0A0",
"t	c #B5B9B4",
"u	c #8C9595",
"  ...           ",
"  +@+           ",
"###$###         ",
"%&&*&&%   =--   ",
";;;>;;;  ,' )!  ",
"~~{]{~~  ^/ ((  ",
"  ___    :< [}  ",
"  ~~~     |1|2  ",
"           3    ",
"                ",
"   4556 755 4886",
"   90abab 9c90ab",
"   de ded ffde d",
"   gh iji klgh i",
" mnopqm pmpropqm",
" s  ts   u   ts "};

/* XPM */
static char * configure_xpm[] = {
"15 15 66 1",
" 	c None",
".	c #848681",
"+	c #82847F",
"@	c #81837E",
"#	c #B3B3B3",
"$	c #888A85",
"%	c #DCDCDB",
"&	c #80827E",
"*	c #CFCFCF",
"=	c #7E807C",
"-	c #B1B1B1",
";	c #D1D1D1",
">	c #7C7E79",
",	c #A2A2A2",
"'	c #D6D6D6",
")	c #7D7F7A",
"!	c #BFBFBF",
"~	c #7A7B77",
"{	c #8A8C87",
"]	c #707070",
"^	c #989898",
"/	c #E2E2E2",
"(	c #DEDEDE",
"_	c #ABABAB",
":	c #E1E1E1",
"<	c #AEAEAE",
"[	c #C3C3C3",
"}	c #BCBCBC",
"|	c #B2B2B2",
"1	c #B0B0B0",
"2	c #DFDFDF",
"3	c #DBDBDB",
"4	c #777874",
"5	c #C9C9C9",
"6	c #E0E0E0",
"7	c #DCDCDC",
"8	c #C3C4C2",
"9	c #797B77",
"0	c #ACACAC",
"a	c #AAAAAA",
"b	c #9F9F9F",
"c	c #757575",
"d	c #2B4F82",
"e	c #868686",
"f	c #A7CBEB",
"g	c #77A3CA",
"h	c #A8A8A8",
"i	c #B4B4B4",
"j	c #C5C5C5",
"k	c #A9A9A9",
"l	c #7AA5CC",
"m	c #598EBD",
"n	c #9A9A9A",
"o	c #A5A5A5",
"p	c #969696",
"q	c #6B6B6B",
"r	c #7CA8CE",
"s	c #C1C1C1",
"t	c #A1A1A1",
"u	c #BEBEBE",
"v	c #A3A3A3",
"w	c #686868",
"x	c #7FAAD0",
"y	c #676767",
"z	c #81ACD1",
"A	c #999999",
"   .+@      #$%",
"    &*=    #$ $",
"     -;>   $ $#",
",'   )!~  %${# ",
"]^/ (_:< %$%   ",
"[}|}1234%$%    ",
" >5}673%$8     ",
"  90ab%$%c     ",
"    dd$%*1e    ",
"  fdfgdhijbk   ",
" fdflmd no[pq  ",
"fdfrmdf  stuvw ",
"dfxmdf    ooyn ",
"dzmdf      yA  ",
"zddf           "};

/* XPM */
static char * replace_xpm[] = {
"16 16 143 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #FBF7F9",
"@ 	c #D8DFED",
"# 	c #ACC8E8",
"$ 	c #9FC4EB",
"% 	c #BACCE2",
"& 	c #DBE0EA",
"* 	c #FAF7F8",
"= 	c #FFFFFD",
"- 	c #E7E7ED",
"; 	c #A7C2E4",
"> 	c #A2CBEF",
", 	c #B7DCF6",
"' 	c #BDDFF4",
") 	c #B6DCF4",
"! 	c #A5CDE9",
"~ 	c #BDCCDD",
"{ 	c #F0F0F2",
"] 	c #F2F0F3",
"^ 	c #AEC6E3",
"/ 	c #B3DEFF",
"( 	c #000000",
"_ 	c #ACDAF0",
": 	c #B8C6D6",
"< 	c #F9F7F8",
"[ 	c #C5CDDE",
"} 	c #A7CFF4",
"| 	c #E0FFFF",
"1 	c #E3FFFF",
"2 	c #D1F7FE",
"3 	c #C9F4FE",
"4 	c #A9C8D8",
"5 	c #DFE1E7",
"6 	c #96ADCF",
"7 	c #B4D9F7",
"8 	c #E2FFFF",
"9 	c #E4FFFF",
"0 	c #DDFDFD",
"a 	c #DFFFFF",
"b 	c #D9FFFF",
"c 	c #A3A9BC",
"d 	c #82A6D3",
"e 	c #BBDFF8",
"f 	c #D9FEFF",
"g 	c #CDE6EC",
"h 	c #CCEDF1",
"i 	c #8F94A9",
"j 	c #CFD1DA",
"k 	c #869EC3",
"l 	c #BAE2FB",
"m 	c #D5FBFF",
"n 	c #E9FFFF",
"o 	c #FBFFFF",
"p 	c #F3FFFF",
"q 	c #E4FAFF",
"r 	c #8E93A8",
"s 	c #B5B7C3",
"t 	c #A8B0C3",
"u 	c #AED4F1",
"v 	c #D7FFFF",
"w 	c #F2FFFF",
"x 	c #C2CCDC",
"y 	c #A3A6B9",
"z 	c #BBBEC9",
"A 	c #E4E2E7",
"B 	c #8EA4C1",
"C 	c #CFFFFF",
"D 	c #EBFFFF",
"E 	c #F1FFFF",
"F 	c #7F8198",
"G 	c #A7ACC2",
"H 	c #BAC6DD",
"I 	c #FDFCFC",
"J 	c #BBBECD",
"K 	c #8FA4BE",
"L 	c #DDFFFF",
"M 	c #E1FFFF",
"N 	c #EFFFFF",
"O 	c #CCE1EC",
"P 	c #8487A3",
"Q 	c #ACA1A0",
"R 	c #C89A65",
"S 	c #FDFBF8",
"T 	c #F3F4F7",
"U 	c #F6F1F5",
"V 	c #F7EEF0",
"W 	c #9FA6B9",
"X 	c #8896AC",
"Y 	c #8796AB",
"Z 	c #8892A6",
"` 	c #A6A9BA",
" .	c #C1C5DD",
"..	c #B9AEAB",
"+.	c #CD9446",
"@.	c #FA941E",
"#.	c #E0A056",
"$.	c #F2F3F6",
"%.	c #EEEBF1",
"&.	c #D9B18F",
"*.	c #F2B051",
"=.	c #FFF48D",
"-.	c #F19222",
";.	c #D2944D",
">.	c #FAF9F8",
",.	c #EDECF2",
"'.	c #FDFFFF",
").	c #FAFFFF",
"!.	c #F5FDFF",
"~.	c #D1A77B",
"{.	c #F5C16A",
"].	c #FFF98D",
"^.	c #F19122",
"/.	c #CC9558",
"(.	c #F9F7F7",
"_.	c #ECECF2",
":.	c #F8FEFF",
"<.	c #DBE7FF",
"[.	c #97714C",
"}.	c #F9CD6C",
"|.	c #FFFD8B",
"1.	c #F29124",
"2.	c #B77936",
"3.	c #FEFFFF",
"4.	c #DBE9FF",
"5.	c #B6BBCD",
"6.	c #D8B79A",
"7.	c #F1CB75",
"8.	c #ECB661",
"9.	c #936B4A",
"0.	c #C2C6D2",
"a.	c #A4A8B7",
"b.	c #A7ACBB",
"c.	c #A7ABBA",
"d.	c #A6ABBA",
"e.	c #A6AABA",
"f.	c #A4A8B8",
"g.	c #A4A8BB",
"h.	c #9EA3B9",
"i.	c #C1C5D6",
"j.	c #AB7B4C",
"k.	c #896955",
"l.	c #8085AF",
". . + @ # $ % & * . . . . . . . ",
"= - ; > , ' ) ! ~ { . . . . . . ",
"] ^ / ( ( ( ( ( _ : < . . . . . ",
"[ } | ( . 1 2 3 ( 4 5 . . . . . ",
"6 7 8 ( . 9 0 a ( b c . . . . . ",
"d e f ( ( ( ( ( g h i j . . . . ",
"k l m ( n ( ( o p q r s . . . . ",
"t u v ( n w ( ( . x y z . . . . ",
"A B C ( 8 D E ( ( F G H . . . . ",
"I J K ( L M N O ( P Q R S . . . ",
"T U V W X Y Z `  ...+.@.#.I . . ",
"$.%.. . . . . . . &.*.=.-.;.>.. ",
"$.,.. . . . . '.).!.~.{.].^./.(.",
"$._.. . . . . o :.o <.[.}.|.1.2.",
"$._.. . . . . . '.3.4.5.6.7.8.9.",
"3.0.a.b.b.c.d.e.f.g.h.i.. j.k.l."};

/* XPM */
static char * find_previous_xpm[] = {
"16 16 149 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #FBF7F9",
"@ 	c #D8DFED",
"# 	c #ACC8E8",
"$ 	c #9FC4EB",
"% 	c #BACCE2",
"& 	c #DBE0EA",
"* 	c #FAF7F8",
"= 	c #FFFFFD",
"- 	c #E7E7ED",
"; 	c #A7C2E4",
"> 	c #A2CBEF",
", 	c #B7DCF6",
"' 	c #BDDFF4",
") 	c #B6DCF4",
"! 	c #A5CDE9",
"~ 	c #BDCCDD",
"{ 	c #F0F0F2",
"] 	c #F2F0F3",
"^ 	c #AEC6E3",
"/ 	c #B3DEFF",
"( 	c #D2F7FF",
"_ 	c #D4F9FF",
": 	c #000000",
"< 	c #B8DBF2",
"[ 	c #B6DCF0",
"} 	c #ACDAF0",
"| 	c #B8C6D6",
"1 	c #F9F7F8",
"2 	c #C5CDDE",
"3 	c #A7CFF4",
"4 	c #E0FFFF",
"5 	c #F3FFFF",
"6 	c #D1F7FE",
"7 	c #C9F4FE",
"8 	c #D3FEFF",
"9 	c #A9C8D8",
"0 	c #DFE1E7",
"a 	c #96ADCF",
"b 	c #B4D9F7",
"c 	c #E2FFFF",
"d 	c #DDFDFD",
"e 	c #DFFFFF",
"f 	c #F8FFFF",
"g 	c #D9FFFF",
"h 	c #A3A9BC",
"i 	c #82A6D3",
"j 	c #BBDFF8",
"k 	c #CCEDF1",
"l 	c #8F94A9",
"m 	c #CFD1DA",
"n 	c #869EC3",
"o 	c #BAE2FB",
"p 	c #D5FBFF",
"q 	c #F4FFFF",
"r 	c #FBFFFF",
"s 	c #E4FAFF",
"t 	c #8E93A8",
"u 	c #B5B7C3",
"v 	c #A8B0C3",
"w 	c #AED4F1",
"x 	c #D7FFFF",
"y 	c #D4FDFF",
"z 	c #F7FFFF",
"A 	c #F9FFFF",
"B 	c #C2CCDC",
"C 	c #A3A6B9",
"D 	c #BBBEC9",
"E 	c #E4E2E7",
"F 	c #8EA4C1",
"G 	c #CFFFFF",
"H 	c #E4FFFF",
"I 	c #F1FFFF",
"J 	c #7F8198",
"K 	c #A7ACC2",
"L 	c #BAC6DD",
"M 	c #FDFCFC",
"N 	c #BBBECD",
"O 	c #8FA4BE",
"P 	c #BFEAF4",
"Q 	c #DDFFFF",
"R 	c #E1FFFF",
"S 	c #EFFFFF",
"T 	c #CCE1EC",
"U 	c #7C8098",
"V 	c #8487A3",
"W 	c #ACA1A0",
"X 	c #C89A65",
"Y 	c #FDFBF8",
"Z 	c #F3F4F7",
"` 	c #F6F1F5",
" .	c #F7EEF0",
"..	c #9FA6B9",
"+.	c #8896AC",
"@.	c #8796AB",
"#.	c #8892A6",
"$.	c #A6A9BA",
"%.	c #C1C5DD",
"&.	c #B9AEAB",
"*.	c #CD9446",
"=.	c #FA941E",
"-.	c #E0A056",
";.	c #F2F3F6",
">.	c #EEEBF1",
",.	c #D9B18F",
"'.	c #F2B051",
").	c #FFF48D",
"!.	c #F19222",
"~.	c #D2944D",
"{.	c #FAF9F8",
"].	c #EDECF2",
"^.	c #FDFFFF",
"/.	c #FAFFFF",
"(.	c #F5FDFF",
"_.	c #D1A77B",
":.	c #F5C16A",
"<.	c #FFF98D",
"[.	c #F19122",
"}.	c #CC9558",
"|.	c #F9F7F7",
"1.	c #ECECF2",
"2.	c #F8FEFF",
"3.	c #DBE7FF",
"4.	c #97714C",
"5.	c #F9CD6C",
"6.	c #FFFD8B",
"7.	c #F29124",
"8.	c #B77936",
"9.	c #FEFFFF",
"0.	c #DBE9FF",
"a.	c #B6BBCD",
"b.	c #D8B79A",
"c.	c #F1CB75",
"d.	c #ECB661",
"e.	c #936B4A",
"f.	c #C2C6D2",
"g.	c #A4A8B7",
"h.	c #A7ACBB",
"i.	c #A7ABBA",
"j.	c #A6ABBA",
"k.	c #A6AABA",
"l.	c #A4A8B8",
"m.	c #A4A8BB",
"n.	c #9EA3B9",
"o.	c #C1C5D6",
"p.	c #AB7B4C",
"q.	c #896955",
"r.	c #8085AF",
". . + @ # $ % & * . . . . . . . ",
"= - ; > , ' ) ! ~ { . . . . . . ",
"] ^ / ( _ : < [ } | 1 . . . . . ",
"2 3 4 5 : : 6 7 8 9 0 . . . . . ",
"a b c : : : d e f g h . . . . . ",
"i j : : : : : : : k l m . . . . ",
"n o p : : : q r 5 s t u . . . . ",
"v w x y : : z A . B C D . . . . ",
"E F G H c : I . . J K L . . . . ",
"M N O P Q R S T U V W X Y . . . ",
"Z `  ...+.@.#.$.%.&.*.=.-.M . . ",
";.>.. . . . . . . ,.'.).!.~.{.. ",
";.].. . . . . ^./.(._.:.<.[.}.|.",
";.1.. . . . . r 2.r 3.4.5.6.7.8.",
";.1.. . . . . . ^.9.0.a.b.c.d.e.",
"9.f.g.h.h.i.j.k.l.m.n.o.. p.q.r."};

/* XPM */
static char * find_next_xpm[] = {
"16 16 146 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #FBF7F9",
"@ 	c #D8DFED",
"# 	c #ACC8E8",
"$ 	c #9FC4EB",
"% 	c #BACCE2",
"& 	c #DBE0EA",
"* 	c #FAF7F8",
"= 	c #FFFFFD",
"- 	c #E7E7ED",
"; 	c #A7C2E4",
"> 	c #A2CBEF",
", 	c #B7DCF6",
"' 	c #BDDFF4",
") 	c #B6DCF4",
"! 	c #A5CDE9",
"~ 	c #BDCCDD",
"{ 	c #F0F0F2",
"] 	c #F2F0F3",
"^ 	c #AEC6E3",
"/ 	c #B3DEFF",
"( 	c #D2F7FF",
"_ 	c #D4F9FF",
": 	c #000000",
"< 	c #B8DBF2",
"[ 	c #B6DCF0",
"} 	c #ACDAF0",
"| 	c #B8C6D6",
"1 	c #F9F7F8",
"2 	c #C5CDDE",
"3 	c #A7CFF4",
"4 	c #E0FFFF",
"5 	c #F3FFFF",
"6 	c #C9F4FE",
"7 	c #D3FEFF",
"8 	c #A9C8D8",
"9 	c #DFE1E7",
"0 	c #96ADCF",
"a 	c #B4D9F7",
"b 	c #E2FFFF",
"c 	c #F8FFFF",
"d 	c #D9FFFF",
"e 	c #A3A9BC",
"f 	c #82A6D3",
"g 	c #BBDFF8",
"h 	c #CCEDF1",
"i 	c #8F94A9",
"j 	c #CFD1DA",
"k 	c #869EC3",
"l 	c #BAE2FB",
"m 	c #D5FBFF",
"n 	c #DCFFFF",
"o 	c #E9FFFF",
"p 	c #E4FAFF",
"q 	c #8E93A8",
"r 	c #B5B7C3",
"s 	c #A8B0C3",
"t 	c #AED4F1",
"u 	c #D7FFFF",
"v 	c #D4FDFF",
"w 	c #F9FFFF",
"x 	c #C2CCDC",
"y 	c #A3A6B9",
"z 	c #BBBEC9",
"A 	c #E4E2E7",
"B 	c #8EA4C1",
"C 	c #CFFFFF",
"D 	c #E4FFFF",
"E 	c #F1FFFF",
"F 	c #7F8198",
"G 	c #A7ACC2",
"H 	c #BAC6DD",
"I 	c #FDFCFC",
"J 	c #BBBECD",
"K 	c #8FA4BE",
"L 	c #BFEAF4",
"M 	c #DDFFFF",
"N 	c #E1FFFF",
"O 	c #EFFFFF",
"P 	c #CCE1EC",
"Q 	c #7C8098",
"R 	c #8487A3",
"S 	c #ACA1A0",
"T 	c #C89A65",
"U 	c #FDFBF8",
"V 	c #F3F4F7",
"W 	c #F6F1F5",
"X 	c #F7EEF0",
"Y 	c #9FA6B9",
"Z 	c #8896AC",
"` 	c #8796AB",
" .	c #8892A6",
"..	c #A6A9BA",
"+.	c #C1C5DD",
"@.	c #B9AEAB",
"#.	c #CD9446",
"$.	c #FA941E",
"%.	c #E0A056",
"&.	c #F2F3F6",
"*.	c #EEEBF1",
"=.	c #D9B18F",
"-.	c #F2B051",
";.	c #FFF48D",
">.	c #F19222",
",.	c #D2944D",
"'.	c #FAF9F8",
").	c #EDECF2",
"!.	c #FDFFFF",
"~.	c #FAFFFF",
"{.	c #F5FDFF",
"].	c #D1A77B",
"^.	c #F5C16A",
"/.	c #FFF98D",
"(.	c #F19122",
"_.	c #CC9558",
":.	c #F9F7F7",
"<.	c #ECECF2",
"[.	c #FBFFFF",
"}.	c #F8FEFF",
"|.	c #DBE7FF",
"1.	c #97714C",
"2.	c #F9CD6C",
"3.	c #FFFD8B",
"4.	c #F29124",
"5.	c #B77936",
"6.	c #FEFFFF",
"7.	c #DBE9FF",
"8.	c #B6BBCD",
"9.	c #D8B79A",
"0.	c #F1CB75",
"a.	c #ECB661",
"b.	c #936B4A",
"c.	c #C2C6D2",
"d.	c #A4A8B7",
"e.	c #A7ACBB",
"f.	c #A7ABBA",
"g.	c #A6ABBA",
"h.	c #A6AABA",
"i.	c #A4A8B8",
"j.	c #A4A8BB",
"k.	c #9EA3B9",
"l.	c #C1C5D6",
"m.	c #AB7B4C",
"n.	c #896955",
"o.	c #8085AF",
". . + @ # $ % & * . . . . . . . ",
"= - ; > , ' ) ! ~ { . . . . . . ",
"] ^ / ( _ : < [ } | 1 . . . . . ",
"2 3 4 5 . : : 6 7 8 9 . . . . . ",
"0 a b . . : : : c d e . . . . . ",
"f g : : : : : : : h i j . . . . ",
"k l m n o : : : 5 p q r . . . . ",
"s t u v o : : w . x y z . . . . ",
"A B C D b : E . . F G H . . . . ",
"I J K L M N O P Q R S T U . . . ",
"V W X Y Z `  ...+.@.#.$.%.I . . ",
"&.*.. . . . . . . =.-.;.>.,.'.. ",
"&.).. . . . . !.~.{.].^./.(._.:.",
"&.<.. . . . . [.}.[.|.1.2.3.4.5.",
"&.<.. . . . . . !.6.7.8.9.0.a.b.",
"6.c.d.e.e.f.g.h.i.j.k.l.. m.n.o."};

/* XPM */
static char * increase_indent_xpm[] = {
"16 15 34 1",
" 	c None",
".	c #616B74",
"+	c #56616A",
"@	c #4B555F",
"#	c #CC8E65",
"$	c #B43800",
"%	c #AD2900",
"&	c #FCE1CA",
"*	c #C98B65",
"=	c #128DC9",
"-	c #C28765",
";	c #A32200",
">	c #A12C00",
",	c #C75D29",
"'	c #FAC89E",
")	c #942800",
"!	c #F9B77E",
"~	c #F7A254",
"{	c #F58204",
"]	c #F6B77F",
"^	c #971900",
"/	c #A26851",
"(	c #8A0E00",
"_	c #B84500",
":	c #F58100",
"<	c #7C0000",
"[	c #FFAD61",
"}	c #9A6251",
"|	c #935C50",
"1	c #700000",
"2	c #945C50",
"3	c #2C3844",
"4	c #283441",
"5	c #24313E",
"        .       ",
"        +       ",
"     @@@ @@@@@@@",
"                ",
"   #$#          ",
"   %&%*  =======",
"-;;>,';- =======",
")!!!~{]^        ",
"/(((_:(/ =====  ",
"   <[<}  =====  ",
"   |12          ",
"                ",
"     333 3333333",
"        4       ",
"        5       "};

/* XPM */
static char * decrease_indent_xpm[] = {
"16 15 34 1",
" 	c None",
".	c #616B74",
"+	c #56616A",
"@	c #4B555F",
"#	c #CC8E65",
"$	c #B43800",
"%	c #C98B65",
"&	c #AD2900",
"*	c #FCE1CA",
"=	c #128DC9",
"-	c #C28765",
";	c #A32200",
">	c #FAC89E",
",	c #C75D29",
"'	c #A12C00",
")	c #C28865",
"!	c #971900",
"~	c #F6B77F",
"{	c #F58204",
"]	c #F7A254",
"^	c #F9B77E",
"/	c #942800",
"(	c #A26851",
"_	c #8A0E00",
":	c #F58100",
"<	c #B84500",
"[	c #9A6251",
"}	c #7C0000",
"|	c #FFAD61",
"1	c #945C50",
"2	c #700000",
"3	c #2C3844",
"4	c #283441",
"5	c #24313E",
"        .       ",
"        +       ",
"     @@@ @@@@@@@",
"                ",
"  #$#           ",
" %&*&    =======",
"-;>,';;) =======",
"!~{]^^^/        ",
"(_:<___( =====  ",
" [}|}    =====  ",
"  121           ",
"                ",
"     333 3333333",
"        4       ",
"        5       "};

/* XPM */
static char * play_xpm[] = {
"16 16 25 1",
" 	c None",
".	c #62B548",
"+	c #CEEFA6",
"@	c #CFEFA8",
"#	c #98DC45",
"$	c #A1DF54",
"%	c #86D624",
"&	c #83D31D",
"*	c #FFFFFF",
"=	c #80D116",
"-	c #FDFFFA",
";	c #7DCE10",
">	c #F9FFF2",
",	c #7ACC0B",
"'	c #F5FFE9",
")	c #78CA07",
"!	c #F0FFDF",
"~	c #77C903",
"{	c #ECFFD5",
"]	c #76C801",
"^	c #E8FFCC",
"/	c #76C800",
"(	c #E4FFC4",
"_	c #81CE11",
":	c #95DB30",
"                ",
"   ..........   ",
"  .+@@@@@@@@+.  ",
" .#$%%%%%%%%$#. ",
" .&&&&*&&&&&&&. ",
" .====--======. ",
" .;;;;>>>;;;;;. ",
" .,,,,'''',,,,. ",
" .))))!!!!)))). ",
" .~~~~{{{~~~~~. ",
" .]]]]^^]]]]]]. ",
" .////(///////. ",
" .____________. ",
"  .::::::::::.  ",
"   ..........   ",
"                "};

/* XPM */
static char * arrow_down_xpm[] = {
"11 12 2 1",
" 	c None",
".	c #000000",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"...........",
" ......... ",
"  .......  ",
"   .....   ",
"    ...    "};

/* XPM */
static char * arrow_up_xpm[] = {
"11 12 2 1",
" 	c None",
".	c #000000",
"    ...    ",
"   .....   ",
"  .......  ",
" ......... ",
"...........",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    ",
"    ...    "};

/* XPM */
static char * drag_curves_xpm[] = {
"15 13 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #D2211C",
"     ..........",
"     .++++++++.",
"   ..........+.",
"   .++++++++.+.",
"..........++.@.",
".++++++++.++.+.",
".++++++++.+@.+.",
".++++@+++.@+.+.",
".+++@+@+@.++...",
".++@+++@+.++.  ",
".+@++++++....  ",
".++++++++.     ",
"..........     "};

/* XPM */
static char * append_drag_curves_xpm[] = {
"16 16 70 1",
" 	c None",
".	c #239500",
"+	c #229203",
"@	c #228E05",
"#	c #208707",
"$	c #208209",
"%	c #229201",
"&	c #74E55E",
"*	c #75E55F",
"=	c #70E059",
"-	c #1F7A0A",
";	c #228D05",
">	c #6FE058",
",	c #69DB50",
"'	c #1D740C",
")	c #218807",
"!	c #70E158",
"~	c #63D449",
"{	c #1C6D0E",
"]	c #239201",
"^	c #218707",
"/	c #1F8209",
"(	c #6ADB51",
"_	c #62D449",
":	c #5ACD3F",
"<	c #1B660F",
"[	c #1A5F11",
"}	c #185813",
"|	c #185115",
"1	c #164C17",
"2	c #229101",
"3	c #75E55E",
"4	c #69DB51",
"5	c #62D448",
"6	c #51C435",
"7	c #49BC2A",
"8	c #41B422",
"9	c #39AC19",
"0	c #31A412",
"a	c #154618",
"b	c #000000",
"c	c #6ADA51",
"d	c #62D548",
"e	c #51C434",
"f	c #49BC2B",
"g	c #32A412",
"h	c #2B9E0C",
"i	c #15421A",
"j	c #FFFFFF",
"k	c #208806",
"l	c #63D448",
"m	c #2C9E0C",
"n	c #279907",
"o	c #143E1A",
"p	c #1F7B0A",
"q	c #1C6D0D",
"r	c #174B16",
"s	c #164718",
"t	c #15411A",
"u	c #133E1B",
"v	c #133B1C",
"w	c #154718",
"x	c #D2211C",
"y	c #195813",
"z	c #32A512",
"A	c #185114",
"B	c #32A413",
"C	c #279A06",
"D	c #164C16",
"E	c #143D1B",
"    .+@#$       ",
"    %&*=-       ",
"    ;&>,'       ",
"    )!,~{       ",
".]@^/(_:<[}|1   ",
"2&3=45:67890abbb",
";&!cd:ef89ghijjb",
"k=4l:e789gmnobjb",
"$p'q<f89rstuvbjb",
"    [89gwjjjjbxb",
"    y9zhixjjjbjb",
"    ABhCojxjxbjb",
"    DwiEvjjxjbjb",
"    bjxjjjjjjbbb",
"    bjjjjjjjjb  ",
"    bbbbbbbbbb  "};

/* XPM */
static char * plus_xpm[] = {
"13 13 67 1",
" 	c None",
".	c #239500",
"+	c #229203",
"@	c #228E05",
"#	c #208707",
"$	c #208209",
"%	c #229201",
"&	c #74E55E",
"*	c #75E55F",
"=	c #70E059",
"-	c #1F7A0A",
";	c #228D05",
">	c #6FE058",
",	c #69DB50",
"'	c #1D740C",
")	c #218807",
"!	c #70E158",
"~	c #63D449",
"{	c #1C6D0E",
"]	c #239201",
"^	c #218707",
"/	c #1F8209",
"(	c #6ADB51",
"_	c #62D449",
":	c #5ACD3F",
"<	c #1B660F",
"[	c #1A5F11",
"}	c #185813",
"|	c #185115",
"1	c #164C17",
"2	c #229101",
"3	c #75E55E",
"4	c #69DB51",
"5	c #62D448",
"6	c #51C435",
"7	c #49BC2A",
"8	c #41B422",
"9	c #39AC19",
"0	c #31A412",
"a	c #154618",
"b	c #6ADA51",
"c	c #62D548",
"d	c #51C434",
"e	c #49BC2B",
"f	c #32A412",
"g	c #2B9E0C",
"h	c #15421A",
"i	c #208806",
"j	c #63D448",
"k	c #2C9E0C",
"l	c #279907",
"m	c #143E1A",
"n	c #1F7B0A",
"o	c #1C6D0D",
"p	c #174B16",
"q	c #164718",
"r	c #15411A",
"s	c #133E1B",
"t	c #133B1C",
"u	c #154718",
"v	c #195813",
"w	c #32A512",
"x	c #185114",
"y	c #32A413",
"z	c #279A06",
"A	c #164C16",
"B	c #143D1B",
"    .+@#$    ",
"    %&*=-    ",
"    ;&>,'    ",
"    )!,~{    ",
".]@^/(_:<[}|1",
"2&3=45:67890a",
";&!bc:de89fgh",
"i=4j:d789fklm",
"$n'o<e89pqrst",
"    [89fu    ",
"    v9wgh    ",
"    xygzm    ",
"    AuhBt    "};

static char* folder_open[]={
    "16 16 11 1",
    "# c #000000",
    "g c #c0c0c0",
    "e c #303030",
    "a c #ffa858",
    "b c #808080",
    "d c #a0a0a4",
    "f c #585858",
    "c c #ffdca8",
    "h c #dcdcdc",
    "i c #ffffff",
    ". c None",
    "....###.........",
    "....#ab##.......",
    "....#acab####...",
    "###.#acccccca#..",
    "#ddefaaaccccca#.",
    "#bdddbaaaacccab#",
    ".eddddbbaaaacab#",
    ".#bddggdbbaaaab#",
    "..edgdggggbbaab#",
    "..#bgggghghdaab#",
    "...ebhggghicfab#",
    "....#edhhiiidab#",
    "......#egiiicfb#",
    "........#egiibb#",
    "..........#egib#",
    "............#ee#"};

/* XPM */
static char * adjust_col_width_xpm[] = {
"16 13 12 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #212426",
"#	c #77C0F3",
"$	c #5FAAE7",
"%	c #519FDD",
"&	c #56A7E1",
"*	c #25282B",
"=	c #4C95D2",
"-	c #3A7CB7",
";	c #1F2225",
"     ......     ",
"     .++++.     ",
"     .++++.     ",
"     .@@@@.     ",
"  #  .++++.  #  ",
" $$  .++++.  $$ ",
"%&&%%.....*%%&&%",
" ==  .++++.  == ",
"  -  .++++.  -  ",
"     ;....;     ",
"     .++++.     ",
"     .++++.     ",
"     ......     "};

/* XPM */
static char * move_row_down_xpm[] = {
"16 10 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #D2211C",
"................",
".++++.++++.++++.",
".++++.++++.++++.",
".++++.++++.++++.",
"................",
"        @       ",
"        @       ",
"      @@@@@     ",
"       @@@      ",
"        @       "};

/* XPM */
static char * move_row_up_xpm[] = {
"16 10 4 1",
" 	c None",
".	c #D2211C",
"+	c #000000",
"@	c #FFFFFF",
"        .       ",
"       ...      ",
"      .....     ",
"        .       ",
"        .       ",
"++++++++++++++++",
"+@@@@+@@@@+@@@@+",
"+@@@@+@@@@+@@@@+",
"+@@@@+@@@@+@@@@+",
"++++++++++++++++"};

/* XPM */
static char * stack_column_xpm[] = {
"15 15 5 1",
" 	c None",
".	c #000000",
"+	c #0000FF",
"@	c #00FF00",
"#	c #FF0000",
"     .....     ",
"     .+++.     ",
"     .+++.     ",
"     .+++.     ",
"......@@@......",
".+++..@@@..+++.",
".+++..@@@..+++.",
".@@@..@@@..+++.",
".@@@..@@@..+++.",
".@@@..@@@..@@@.",
".@@@..###..@@@.",
".@@@..###..@@@.",
".###..###..###.",
".###..###..###.",
".###..###..###."};

/* XPM */
static char * stack_bar_xpm[] = {
"15 15 5 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"@	c #00FF00",
"#	c #0000FF",
"...........    ",
"+++@@@@@##.    ",
"+++@@@@@##.    ",
"+++@@@@@##.    ",
"...........    ",
"...............",
"+++++@@@@@@###.",
"+++++@@@@@@###.",
"+++++@@@@@@###.",
"...............",
"...........    ",
"+++@@@####.    ",
"+++@@@####.    ",
"+++@@@####.    ",
"...........    "};

/* XPM */
static char * waterfall_plot_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"@	c #00FF00",
"          ..    ",
"         .  .  .",
"        .    .. ",
"       .        ",
"     ..         ",
"                ",
"       ++       ",
"      +  +  +   ",
"     +    ++    ",
"    +           ",
"  ++            ",
"     @@         ",
"    @  @  @     ",
"   @    @@      ",
"  @             ",
"@@              "};

/* XPM */
static char * delete_xpm[] = {
"11 12 40 1",
" 	c None",
".	c #ECBCBC",
"+	c #BB0000",
"@	c #DD8989",
"#	c #B60000",
"$	c #FFCBCB",
"%	c #DB8989",
"&	c #AF0000",
"*	c #FF7C7C",
"=	c #FFB4B4",
"-	c #D88989",
";	c #BC6D6D",
">	c #A70000",
",	c #FF4949",
"'	c #FF9A9A",
")	c #B86D6D",
"!	c #9E0000",
"~	c #FF1D1D",
"{	c #FF8787",
"]	c #B36D6D",
"^	c #940000",
"/	c #FF0000",
"(	c #C68989",
"_	c #890000",
":	c #FF7E7E",
"<	c #C28989",
"[	c #7E0000",
"}	c #FF7F7F",
"|	c #FF0606",
"1	c #740000",
"2	c #FF8686",
"3	c #FF1C1C",
"4	c #A46D6D",
"5	c #6B0000",
"6	c #FF3434",
"7	c #9F6D6D",
"8	c #B19696",
"9	c #630000",
"0	c #9B6D6D",
"a	c #CBCBCB",
".++@   @++.",
"#$$#% %#$$#",
"&**=&-&=**&",
";>,,'>',,>;",
" )!~~{~~!) ",
"  ]^///^]  ",
" (_:///:_( ",
"<[}||[||}[<",
"12331413321",
"56657 75665",
"8990   0998",
" aa     aa "};

/* XPM */
static char * append_file_xpm[] = {
"16 16 102 2",
"  	c None",
". 	c #3AAB00",
"+ 	c #9DA9B5",
"@ 	c #A6B1BC",
"# 	c #DEE2E6",
"$ 	c #38A700",
"% 	c #E0F291",
"& 	c #F2F5F7",
"* 	c #BDC3CB",
"= 	c #FDFDFE",
"- 	c #BAC2CB",
"; 	c #DEE2E5",
"> 	c #34A100",
", 	c #C8DF7A",
"' 	c #E3EAEF",
") 	c #ACB6BF",
"! 	c #ECF1F6",
"~ 	c #B3BDC7",
"{ 	c #DDE1E5",
"] 	c #2F9A00",
"^ 	c #DDF089",
"/ 	c #C4DD6F",
"( 	c #E3E9EF",
"_ 	c #DDE6EF",
": 	c #97A3AF",
"< 	c #289300",
"[ 	c #C2DB66",
"} 	c #E4EBF0",
"| 	c #9EAAB4",
"1 	c #95A1AC",
"2 	c #CBCBCB",
"3 	c #238B00",
"4 	c #BFDA5F",
"5 	c #C2C7CB",
"6 	c #E5ECF0",
"7 	c #DFE5EA",
"8 	c #D6DADE",
"9 	c #D0D4D7",
"0 	c #85909B",
"a 	c #1F8600",
"b 	c #E7EDF2",
"c 	c #C89685",
"d 	c #AE3500",
"e 	c #E5EBF0",
"f 	c #E1E7EC",
"g 	c #DEE4E8",
"h 	c #8B96A2",
"i 	c #8D2000",
"j 	c #D18D51",
"k 	c #B37155",
"l 	c #AE412A",
"m 	c #E9EFF3",
"n 	c #A52F00",
"o 	c #F8CBA5",
"p 	c #C59586",
"q 	c #8C98A3",
"r 	c #B4785D",
"s 	c #9D1D00",
"t 	c #F7A254",
"u 	c #CF7A52",
"v 	c #F49028",
"w 	c #F7BB88",
"x 	c #9B2700",
"y 	c #C09287",
"z 	c #ECF0F4",
"A 	c #89959F",
"B 	c #E2E2E2",
"C 	c #805148",
"D 	c #8F1F00",
"E 	c #F79C47",
"F 	c #F9B87E",
"G 	c #F58200",
"H 	c #F58306",
"I 	c #901400",
"J 	c #EFF3F6",
"K 	c #86919C",
"L 	c #78828C",
"M 	c #A67B74",
"N 	c #831500",
"O 	c #F78406",
"P 	c #A57A73",
"Q 	c #F3F6F8",
"R 	c #838E99",
"S 	c #808B95",
"T 	c #E3E5E6",
"U 	c #CFD1D2",
"V 	c #780B00",
"W 	c #FF9627",
"X 	c #A17874",
"Y 	c #E1E3E5",
"Z 	c #F6F8FA",
"` 	c #7D8994",
" .	c #FAFBFC",
"..	c #F8FAFB",
"+.	c #9D7675",
"@.	c #6F0000",
"#.	c #7B8691",
"$.	c #FBFBFD",
"%.	c #FAFAFC",
"&.	c #E5E5E6",
"*.	c #D2D3D4",
"=.	c #7A848E",
"    . . . + + + + + + @ + #     ",
"    $ % $ & & & & & & * = - ;   ",
"> > > , > > > ' ' ' ' ) ! ! ~ { ",
"] ^ ^ / ^ ^ ] ( ( ( ( @ _ _ _ : ",
"< < < [ < < < } } } } | 1 1 1 1 ",
"2 2 3 4 3 5 5 6 6 6 6 7 8 9 9 0 ",
"    a a a b b c d c b e f g g h ",
"    i j k l m n o n p m m m m q ",
"    r s t u s s v w x y z z z A ",
"    B C D E F F G H F I J J J K ",
"      L M N N N O O N P Q Q Q R ",
"      S T U U V W V X Y Z Z Z S ",
"      `  .....+.@.+.T ........` ",
"      #.$.%.%.&.*.&.%.%.%.%.%.#.",
"      =.=.=.=.=.=.=.=.=.=.=.=.=.",
"      2 2 2 2 2 2 2 2 2 2 2 2 2 "};

/* XPM */
static char * find_xpm[] = {
"16 16 46 1",
" 	c None",
".	c #2A2A2A",
"+	c #606060",
"@	c #B5B5B5",
"#	c #909090",
"$	c #C4C4C4",
"%	c #878787",
"&	c #6C6C6C",
"*	c #464646",
"=	c #3E3E3E",
"-	c #A1A1A1",
";	c #757575",
">	c #0E0E0E",
",	c #787878",
"'	c #A5A5A5",
")	c #777777",
"!	c #0A0A0A",
"~	c #3D3D3D",
"{	c #626262",
"]	c #989898",
"^	c #545454",
"/	c #222222",
"(	c #151515",
"_	c #131313",
":	c #4E4E4E",
"<	c #C6C6C6",
"[	c #9F9F9F",
"}	c #686868",
"|	c #525252",
"1	c #1F1F1F",
"2	c #ACACAC",
"3	c #858585",
"4	c #5C5C5C",
"5	c #535353",
"6	c #BEBEBE",
"7	c #767676",
"8	c #949494",
"9	c #7B7B7B",
"0	c #191919",
"a	c #6A6A6A",
"b	c #404040",
"c	c #3C3C3C",
"d	c #484848",
"e	c #656565",
"f	c #2D2D2D",
"g	c #D8D8D8",
"   ...    ...   ",
"   +@.    .@+   ",
"  #...#  #...#  ",
"  .$%&.**.&=$.  ",
"  .-;>,'',>)-.  ",
"  .-;!~{{~!)-.  ",
"]^./!(,'',(!!_^]",
":<[}|.(11(.|}[<:",
".23}45.66.54}32.",
".23}{7.  .7{}32.",
".23}{7.  .7{}32.",
".@897%.  .%798@.",
"0a|bcd0  0dcb|a0",
".23}{7.  .7{}32.",
"efffffe  efffffe",
"g66666g  g66666g"};

/* XPM */
static char * magnifier_xpm[] = {
"24 24 240 2",
"  	c None",
". 	c #C5C5BF",
"+ 	c #777674",
"@ 	c #454646",
"# 	c #17181A",
"$ 	c #171719",
"% 	c #444546",
"& 	c #767673",
"* 	c #81817E",
"= 	c #111213",
"- 	c #525E6B",
"; 	c #7A8B9E",
"> 	c #A8BCD1",
", 	c #A2B7CE",
"' 	c #7B8C9E",
") 	c #56616C",
"! 	c #101112",
"~ 	c #7D7E7B",
"{ 	c #424242",
"] 	c #2F353A",
"^ 	c #B2C4D7",
"/ 	c #E9F1F9",
"( 	c #FAFBFD",
"_ 	c #F6F9FC",
": 	c #EFF4FA",
"< 	c #E0EBF6",
"[ 	c #C6DAEF",
"} 	c #A6B9CE",
"| 	c #32373B",
"1 	c #3C3D3D",
"2 	c #80807D",
"3 	c #33373E",
"4 	c #D1E1F1",
"5 	c #FFFFFF",
"6 	c #F9FBFD",
"7 	c #F2F6FB",
"8 	c #EBF2F9",
"9 	c #E4EDF7",
"0 	c #D6E5F3",
"a 	c #C7DBEF",
"b 	c #C3D8EE",
"c 	c #C4D8ED",
"d 	c #363A3F",
"e 	c #727271",
"f 	c #C2C1BB",
"g 	c #141516",
"h 	c #B1C3D8",
"i 	c #FCFCFE",
"j 	c #EEF4FA",
"k 	c #E7EFF8",
"l 	c #DEEAF6",
"m 	c #C8DBEF",
"n 	c #C4D8EE",
"o 	c #C6DAEE",
"p 	c #C9DCF0",
"q 	c #B5C5D6",
"r 	c #141515",
"s 	c #BABAB6",
"t 	c #6A6A67",
"u 	c #586470",
"v 	c #E1EBF6",
"w 	c #DDE8F5",
"x 	c #CADCF0",
"y 	c #CCDDF0",
"z 	c #CEDFF1",
"A 	c #CFE0F1",
"B 	c #646C73",
"C 	c #5D5E5E",
"D 	c #3B3D3D",
"E 	c #8494A4",
"F 	c #ECF3FA",
"G 	c #D9E6F4",
"H 	c #CCDEF1",
"I 	c #CCDEF0",
"J 	c #D0E0F1",
"K 	c #D2E1F2",
"L 	c #D4E3F2",
"M 	c #949DA8",
"N 	c #353636",
"O 	c #111212",
"P 	c #B7C8DA",
"Q 	c #DCE8F5",
"R 	c #D5E4F3",
"S 	c #D2E2F2",
"T 	c #D6E4F3",
"U 	c #D8E5F4",
"V 	c #C3CFDA",
"W 	c #0C0C0D",
"X 	c #0E0F10",
"Y 	c #BECFE0",
"Z 	c #CADDF0",
"` 	c #CBDEF0",
" .	c #D4E3F3",
"..	c #DAE7F4",
"+.	c #C9D3DE",
"@.	c #0B0B0B",
"#.	c #383939",
"$.	c #94A1AF",
"%.	c #CDDFF1",
"&.	c #CBDDF0",
"*.	c #D0E1F2",
"=.	c #D8E6F4",
"-.	c #DEE9F5",
";.	c #9FA6AD",
">.	c #333434",
",.	c #646461",
"'.	c #656E77",
").	c #CFDFF1",
"!.	c #D1E1F2",
"~.	c #D3E2F2",
"{.	c #D5E3F3",
"].	c #DEEAF5",
"^.	c #E2ECF6",
"/.	c #72767A",
"(.	c #5B5B5B",
"_.	c #B7B6B1",
":.	c #131415",
"<.	c #C0CEDC",
"[.	c #D7E5F3",
"}.	c #DBE7F4",
"|.	c #E2ECF7",
"1.	c #E6EFF8",
"2.	c #D3DAE2",
"3.	c #141415",
"4.	c #A3A3A3",
"5.	c #6D6D6B",
"6.	c #45494D",
"7.	c #DDE9F5",
"8.	c #DFEAF6",
"9.	c #E4EEF7",
"0.	c #E8F0F8",
"a.	c #EAF1F9",
"b.	c #4A4C4E",
"c.	c #656565",
"d.	c #A3A3A1",
"e.	c #313131",
"f.	c #434649",
"g.	c #CBD5E0",
"h.	c #E3ECF7",
"i.	c #E5EEF7",
"j.	c #E9F0F8",
"k.	c #EAF2F9",
"l.	c #D7DDE3",
"m.	c #47494B",
"n.	c #383838",
"o.	c #5C5C5C",
"p.	c #8C8C8C",
"q.	c #5A5A59",
"r.	c #C3A168",
"s.	c #636463",
"t.	c #131414",
"u.	c #767A7F",
"v.	c #A8AEB5",
"w.	c #D9DFE6",
"x.	c #DAE1E7",
"y.	c #ADB1B6",
"z.	c #7B7D80",
"A.	c #565656",
"B.	c #464646",
"C.	c #B3B3B3",
"D.	c #D8D8D8",
"E.	c #56564F",
"F.	c #D29C2C",
"G.	c #F4BB61",
"H.	c #AAA9A7",
"I.	c #565757",
"J.	c #2D2E2E",
"K.	c #080808",
"L.	c #2E2E2F",
"M.	c #575757",
"N.	c #A2A2A1",
"O.	c #797977",
"P.	c #666666",
"Q.	c #BCBCBC",
"R.	c #666662",
"S.	c #6C7038",
"T.	c #F9FDA6",
"U.	c #F6C257",
"V.	c #F4BA60",
"W.	c #BACBB6",
"X.	c #CCCCCA",
"Y.	c #ACABA5",
"Z.	c #232322",
"`.	c #33322B",
" +	c #545023",
".+	c #EBE43F",
"++	c #F7F874",
"@+	c #FEFEED",
"#+	c #F2C057",
"$+	c #F4B95D",
"%+	c #46361C",
"&+	c #7A5A14",
"*+	c #F9CE32",
"=+	c #F8D536",
"-+	c #F7DC39",
";+	c #F8EA6E",
">+	c #FEFDEC",
",+	c #EEBC56",
"'+	c #F1B55A",
")+	c #D2D0C6",
"!+	c #6C4E23",
"~+	c #AD7718",
"{+	c #FBBC2A",
"]+	c #FAC32E",
"^+	c #F9CA31",
"/+	c #FADD69",
"(+	c #FEFBEB",
"_+	c #E9B756",
":+	c #ECB057",
"<+	c #D2D1C6",
"[+	c #664B25",
"}+	c #A96B15",
"|+	c #FDAA22",
"1+	c #FCB125",
"2+	c #FBB829",
"3+	c #FBD063",
"4+	c #FEF9EB",
"5+	c #E2A63F",
"6+	c #E8AE59",
"7+	c #CAD0C0",
"8+	c #604824",
"9+	c #A26614",
"0+	c #FEA01E",
"a+	c #FEA621",
"b+	c #FDB942",
"c+	c #F1AB24",
"d+	c #D18C29",
"e+	c #BBCDB2",
"f+	c #5B4526",
"g+	c #9D6414",
"h+	c #BA791B",
"i+	c #CAA772",
"j+	c #564328",
"k+	c #975F14",
"l+	c #E9921B",
"m+	c #996217",
"n+	c #9E7841",
"o+	c #53442C",
"p+	c #4F3614",
"q+	c #9D8B6F",
"        . + @ # $ % & .                         ",
"      * = - ; > , ' ) ! ~                       ",
"    { ] ^ / ( _ : < [ } | 1                     ",
"  2 3 4 5 6 7 8 9 0 a b c d e                   ",
"f g h i _ j k l m n o m p q r s                 ",
"t u v 7 8 9 w p [ m x y z A B C                 ",
"D E F k < G H m x I z J K L M N                 ",
"O P 9 Q R I x I z J S L T U V W                 ",
"X Y G K Z ` z J S  .T U ..Q +.@.                ",
"#.$.%.&.z *.S  .T =...Q -.< ;.>.                ",
",.'.).!.~.{.0 =...Q ].< ^.9 /.(.                ",
"_.:.<.{.[.G }.w ].< |.9 1.2.3.4.                ",
"  5.6.G }.7.8.v |.9.1.0.a.b.c.d.                ",
"    e.f.g.v h.i.k j.k.l.m.n.o.p.q.r.            ",
"      s.t.u.v.w.x.y.z.3.A.B.C.D.E.F.G.          ",
"        H.I.J.K.K.L.M.N.O.P.Q.R.S.T.U.V.        ",
"              W.X.      Y.Z.`. +.+++@+#+$+      ",
"                          %+&+*+=+-+;+>+,+'+    ",
"                          )+!+~+{+]+^+/+(+_+:+  ",
"                            <+[+}+|+1+2+3+4+5+6+",
"                              7+8+9+0+0+a+b+c+d+",
"                                e+f+g+0+0+0+h+i+",
"                                    j+k+l+m+n+  ",
"                                      o+p+q+    "};

/* XPM */
static char * leaf_xpm[] = {
"16 16 5 1",
" 	c None",
".	c #000000",
"+	c #00A500",
"@	c #000900",
"#	c #007000",
"                ",
"          ......",
"        ..+++@#.",
"      ..++++.##.",
"     .+++++.@@@.",
"    .+++++.###. ",
"    .++++.####. ",
"   .++++@@@@@.  ",
"   .+++.#####.  ",
"   .++.@@@##.   ",
"   .+.####..    ",
"   @.###..      ",
"   .@...        ",
"  .@            ",
" .@             ",
"@@              "};

/* XPM */
static char * extract_layers_xpm[] = {
"16 16 5 1",
" 	c None",
".	c #000000",
"+	c #1A1A1A",
"@	c #FF0000",
"#	c #FFFFFF",
"................",
".              .",
". .  +   @     .",
". . +   @      .",
". .+   @       .",
". ...........  .",
".              .",
".              .",
".##############.",
".##############.",
".#.##+###.###@#.",
".#.#+####.##@##.",
".#.+#####.#@###.",
".#.....##.....#.",
".##############.",
"................"};

/* XPM */
static char * extract_graphs_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"................",
".++++++++++++++.",
".++.+++++.+++++.",
".++.+++++.+++++.",
".++....++....++.",
".++++++++++++++.",
"................",
"                ",
"                ",
".......  .......",
".+++++.  .+++++.",
".+.+++.  .+.+++.",
".+.+++.  .+.+++.",
".+...+.  .+...+.",
".+++++.  .+++++.",
".......  ......."};

/* XPM */
static char * add_zoom_plot_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #FDFFCB",
".               ",
".    .......  . ",
". .  .+++++.    ",
".    .+.+.+. .  ",
".  . ..+++..   .",
".    .......    ",
". .          .  ",
".               ",
"................",
".++++++++++++++.",
".++++++++++++++.",
".++++++.++.++++.",
".++++++++++++++.",
".++++.++++++.++.",
".++++++++++++++.",
"................"};

/* XPM */
static char * add_inset_curve_layer_xpm[] = {
"13 13 4 1",
" 	c None",
".	c #ACA899",
"+	c #000000",
"@	c #FF0000",
"..    ++     ",
".      +   @ ",
".     ++  @ @",
"..     +  @  ",
".     ++ @   ",
".      ++++++",
"..      + + +",
".            ",
".            ",
"..           ",
".            ",
". .  .  .  . ",
"............."};


/* XPM */
static char * add_inset_layer_xpm[] = {
"13 13 3 1",
" 	c None",
".	c #ACA899",
"+	c #000000",
"..    ++     ",
".      +     ",
".     ++     ",
"..     +     ",
".     ++     ",
".      ++++++",
"..      + + +",
".            ",
".            ",
"..           ",
".            ",
". .  .  .  . ",
"............."};


/* XPM */
static char * plot_double_y_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"...............+",
".              +",
".   +      +++ +",
". ++ +    + ++ +",
". ++  +  +     +",
".+     ++      +",
".      ++ ..   +",
".         ..   +",
".        .  .  +",
".       .    . +",
".     ..      .+",
".     ..      .+",
".    .         +",
".  ..          +",
".  ..          +",
"...............+"};

/* XPM */
static char * equation_xpm[] = {
"16 11 4 1",
" 	c None",
".	c #A64D4D",
"+	c #A6A6A6",
"@	c #4D4DA6",
"     ...........",
"     .++++++++++",
"     .          ",
"     .   @@@+ +@",
"    +.  @@  @@@+",
" .+ .+ @@    @+ ",
"..+ .  @@    @  ",
" +. .  @@    @  ",
"  .+.   @@  @@++",
"  +.+    @@@  @@",
"   .            "};

/* XPM */
static char * sort_descending_xpm[] = {
"13 16 36 1",
" 	c None",
".	c #C8C5DA",
"+	c #B4B0D4",
"@	c #A09BCE",
"#	c #9B96CD",
"$	c #7971C2",
"%	c #544AB7",
"&	c #FF0000",
"*	c #8D86C8",
"=	c #AAA6D1",
"-	c #D5282B",
";	c #655CBC",
">	c #C8C4D9",
",	c #7971C1",
"'	c #A09ACD",
")	c #B4AFD3",
"!	c #CECDCB",
"~	c #8A8D98",
"{	c #93959E",
"]	c #9B9DA5",
"^	c #6B6F80",
"/	c #DEDDD7",
"(	c #717585",
"_	c #828591",
":	c #B4B5B8",
"<	c #E9C7C0",
"[	c #EAC8C0",
"}	c #C5C5C5",
"|	c #A4A5AB",
"1	c #ACADB1",
"2	c #7A7D8B",
"3	c #ECD9D1",
"4	c #E7B7B1",
"5	c #ACAEB0",
"6	c #CECEC9",
"7	c #A3A6AA",
".+@@@+       ",
"#$%%%$    &  ",
"   *%=    -  ",
"  .%;     -  ",
"  $%+     -  ",
" >%;      -  ",
">,%,')    -  ",
",%%%%,    -  ",
"          -  ",
" !~{      -  ",
" ]^^/   &---&",
" (_^:   <&-&[",
"!^}^~    &-& ",
"|^12^    3&3 ",
"_(~2^}    4  ",
"^5 6^7       "};

/* XPM */
static char * sort_ascending_xpm[] = {
"13 16 35 1",
" 	c None",
".	c #A09BCF",
"+	c #DBDAE1",
"@	c #B4B0D5",
"#	c #544AB7",
"$	c #FF0000",
"%	c #827BC5",
"&	c #5B52B9",
"*	c #D5282B",
"=	c #655CBC",
"-	c #C9C5DB",
";	c #9791CC",
">	c #BEBBD8",
",	c #9790CB",
"'	c #6F67BF",
")	c #8D86C8",
"!	c #A09BCE",
"~	c #DBD9DF",
"{	c #BDBEBE",
"]	c #8A8D98",
"^	c #868995",
"/	c #7F838F",
"(	c #7D808D",
"_	c #D6D6D2",
":	c #ACAEB2",
"<	c #7A7D8B",
"[	c #6B6F80",
"}	c #EAC8C1",
"|	c #EAC8C0",
"1	c #93959E",
"2	c #CECECC",
"3	c #EDDAD1",
"4	c #E8B7B1",
"5	c #CECEC9",
"6	c #ABAEB0",
"  ..+        ",
" @##@     $  ",
" %&#%     *  ",
" &%=#     *  ",
"-#@;#>    *  ",
",#'=#)    *  ",
"'=!!#=    *  ",
"#)  '#~   *  ",
"          *  ",
"{]^/(_    *  ",
" {:<[_  $***$",
"   []   }$*$|",
"  1[2    $*$ ",
" 2[]     3$3 ",
" ][:2     4  ",
"5[[[[6       "};

/* XPM */
static char * formula_xpm[] = {
"9 9 3 1",
" 	c None",
".	c #000000",
"+	c #626677",
".........",
" ..    +.",
"  ..    .",
"   ..    ",
"    ..   ",
"   ..    ",
"  ..    .",
" ..    +.",
"........."};

/* XPM */
static char * rotate_counterclockwise_xpm[] = {
"11 13 15 1",
" 	c None",
".	c #ABBBD2",
"+	c #3F6397",
"@	c #204A87",
"#	c #6F8AB1",
"$	c #3B6096",
"%	c #5A86B9",
"&	c #729FCF",
"*	c #859CBE",
"=	c #315890",
"-	c #6794C7",
";	c #5E8BC0",
">	c #5987BD",
",	c #5071A1",
"'	c #2A528C",
"    .+@@@@@",
"   #$%&&&&@",
"  *=&-;>>&@",
"  ,&-&&&&&@",
"  @&>&'@@@@",
"  @&>&@    ",
"@@@&>&@@@  ",
"@&&&>&&&@  ",
" @&>>>&@   ",
"  @&>&@    ",
"   @&@     ",
"    @      ",
"           "};

/* XPM */
static char * rotate_clockwise_xpm[] = {
"11 13 15 1",
" 	c None",
".	c #204A87",
"+	c #3F6397",
"@	c #ABBBD2",
"#	c #729FCF",
"$	c #5A86B9",
"%	c #3B6096",
"&	c #6F8AB1",
"*	c #5987BD",
"=	c #5E8BC0",
"-	c #6794C7",
";	c #315890",
">	c #859CBE",
",	c #5071A1",
"'	c #2A528C",
".....+@    ",
".####$%&   ",
".#**=-#;>  ",
".#####-#,  ",
"....'#*#.  ",
"    .#*#.  ",
"  ...#*#...",
"  .###*###.",
"   .#***#. ",
"    .#*#.  ",
"     .#.   ",
"      .    ",
"           "};

/* XPM */
static char * flip_vertical_xpm[] = {
"9 14 18 1",
" 	c None",
".	c #C0CCDD",
"+	c #204A87",
"@	c #D3DCE7",
"#	c #B7C5D8",
"$	c #BED2EA",
"%	c #B1C0D5",
"&	c #93B4DD",
"*	c #BCD1EA",
"=	c #BCC8DB",
"-	c #C3CEDF",
";	c #A4C0E2",
">	c #ACC6E4",
",	c #BBD0E9",
"'	c #C4D6EC",
")	c #9DBBDF",
"!	c #B8C6D9",
"~	c #C7D2E1",
"   .+@   ",
"  #+$+@  ",
" %+$&*+@ ",
"=+$&&&*+-",
"+$;>&>;$+",
"+++$&,+++",
"  +$&'+  ",
"  +$&'+  ",
"+++$&,+++",
"+$;)&>;$+",
"=+$&&&$+-",
" %+$&$+@ ",
"  #+$+@  ",
"   !+~   "};

/* XPM */
static char * flip_horizontal_xpm[] = {
"14 9 18 1",
" 	c None",
".	c #C3CEDF",
"+	c #204A87",
"@	c #D3DCE7",
"#	c #BED2EA",
"$	c #BCD1EA",
"%	c #A4C0E2",
"&	c #93B4DD",
"*	c #ACC6E4",
"=	c #BBD0E9",
"-	c #C4D6EC",
";	c #C7D2E1",
">	c #C0CCDD",
",	c #9DBBDF",
"'	c #B8C6D9",
")	c #B7C5D8",
"!	c #B1C0D5",
"~	c #BCC8DB",
"   .++  ++.   ",
"  @+#+  +#+@  ",
" @+$%++++%#+@ ",
"@+$&*=--=*&#+;",
"+#&&&&&&&&&&#+",
">+#&*####,&#+'",
" )+#%++++%#+) ",
"  !+#+  +#+!  ",
"   ~++  ++~   "};

/* XPM */
static char * delete_column_xpm[] = {
"16 13 6 1",
" 	c None",
".	c #878B98",
"+	c #FFFFFF",
"@	c #FF0000",
"#	c #464B5C",
"$	c #B2B5BF",
"................",
".++++.@@@@.++++#",
".++++.@@@@.++++#",
".....$....$.....",
".++++.@@@@.++++#",
".++++.@@@@.++++#",
".....$....$.....",
".++++.@@@@.++++#",
".++++.@@@@.++++#",
".....$....$.....",
".++++.@@@@.++++#",
".++++.@@@@.++++#",
".####.####.#####"};

/* XPM */
static char * insert_column_xpm[] = {
"16 15 8 1",
" 	c None",
".	c #594FBF",
"+	c #655BEF",
"@	c #878B98",
"#	c #FFFFFF",
"$	c #E8D038",
"%	c #464B5C",
"&	c #E89238",
"     .+++++.    ",
"      .+++.     ",
"@@@@@@@.+.@@@@@@",
"@####@$$.$@####%",
"@####@$$$$@####%",
"@@@@@@&&&&@@@@@@",
"@####@$$$$@####%",
"@####@$$$$@####%",
"@@@@@@&&&&@@@@@@",
"@####@$$$$@####%",
"@####@$$$$@####%",
"@@@@@@&&&&@@@@@@",
"@####@$$$$@####%",
"@####@$$$$@####%",
"@%%%%@%%%%@%%%%%"};

/* XPM */
static char * delete_row_xpm[] = {
"16 13 6 1",
" 	c None",
".	c #878B98",
"+	c #FFFFFF",
"@	c #464B5C",
"#	c #B2B5BF",
"$	c #FF0000",
"................",
".++++.++++.++++@",
".++++.++++.++++@",
".....#....#.....",
".$$$$.$$$$.$$$$@",
".$$$$.$$$$.$$$$@",
".....#....#.....",
".++++.++++.++++@",
".++++.++++.++++@",
".....#....#.....",
".++++.++++.++++@",
".++++.++++.++++@",
".@@@@.@@@@.@@@@@"};

/* XPM */
static char * insert_row_xpm[] = {
"16 13 9 1",
" 	c None",
".	c #878B98",
"+	c #FFFFFF",
"@	c #464B5C",
"#	c #594FBF",
"$	c #655BEF",
"%	c #E8D038",
"&	c #E89238",
"*	c #B2B5BF",
"................",
".++++.++++.++++@",
"#++++.++++.++++@",
"$#..............",
"$$#%%&%%%%&%%%%@",
"$$$#%&%%%%&%%%%@",
"$$#.............",
"$#+++.++++.++++@",
"#++++.++++.++++@",
".....*....*.....",
".++++.++++.++++@",
".++++.++++.++++@",
".@@@@.@@@@.@@@@@"};

/* XPM */
static char * set_label_col_xpm[] = {
"14 11 2 1",
" 	c None",
".	c #000000",
"     .        ",
" ..  ...   .. ",
"   . .  . .  .",
" ... .  . .   ",
".  . .  . .  .",
".... ...   .. ",
"              ",
"     ....     ",
"     ....     ",
"     ....     ",
"     ....     "};

/* XPM */
static char *index_xpm[]={
"11 16 3 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"           ",
"           ",
"           ",
"           ",
"           ",
"... ..     ",
" ...       ",
"  ..       ",
"  ...   ++ ",
".. ... +  +",
"          +",
"         + ",
"        +  ",
"       ++++",
"           ",
"           "};

/* XPM */
static char *exp_xpm[]={
"11 16 3 1",
" 	c None",
".	c #FF0000",
"+	c #000000",
"        .. ",
"       .  .",
"          .",
"         . ",
"        .  ",
"+++ ++ ....",
" +++       ",
"  ++       ",
"  +++      ",
"++ +++     ",
"           ",
"           ",
"           ",
"           ",
"           ",
"           "};

/* XPM */
static char * draw_points_xpm[] = {
"10 10 2 1",
" 	c None",
".	c #BC0F0F",
"  ..      ",
"  ..      ",
"        ..",
"        ..",
"..        ",
"..      ..",
"        ..",
"          ",
"    ..    ",
"    ..    "};

/* XPM */
static char * image_plot_xpm[] = {
"14 14 6 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"@	c #FFFFFF",
"#	c #00FF00",
"$	c #0000FF",
"..............",
".++++@@@@@@@@.",
".++++@@@@@@@@.",
".++++@@@@@@@@.",
".++++@####@@@.",
".++++######@@.",
".++++######@@.",
".@@@@######@@.",
".@@@@######$@.",
".@@@@######$@.",
".@@@@@####$$$.",
".@@@@@@@@@$$$.",
".@@@@@@@@$$$$.",
".............."};

/* XPM */
static char * move_col_first_xpm[] = {
"11 14 2 1",
" 	c None",
".	c #000000",
"..         ",
"..      .  ",
"..     ..  ",
"..    ...  ",
"..   ....  ",
"..  .......",
"..  .......",
"..  .......",
"..   ....  ",
"..    ...  ",
"..     ..  ",
"..      .  ",
"..         ",
"..         "};

/* XPM */
static char * move_col_last_xpm[] = {
"11 14 2 1",
" 	c None",
".	c #000000",
"         ..",
"  .      ..",
"  ..     ..",
"  ...    ..",
"  ....   ..",
".......  ..",
".......  ..",
".......  ..",
"  ....   ..",
"  ...    ..",
"  ..     ..",
"  .      ..",
"         ..",
"         .."};

/* XPM */
static char * x_col_xpm[] = {
"10 11 2 1",
" 	c None",
".	c #000000",
".        .",
"..      ..",
" ..    .. ",
"  ..  ..  ",
"   ....   ",
"    ..    ",
"   ....   ",
"  ..  ..  ",
" ..    .. ",
"..      ..",
".        ."};

/* XPM */
static char * y_col_xpm[] = {
"12 11 2 1",
" 	c None",
".	c #000000",
"...      ...",
"  ..    ..  ",
"   ..  ..   ",
"    ....    ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"    ....    "};

/* XPM */
static char * z_col_xpm[] = {
"9 11 2 1",
" 	c None",
".	c #000000",
".........",
".........",
"      .. ",
"     ..  ",
"    ..   ",
"   ..    ",
"  ..     ",
" ..      ",
"..       ",
".........",
"........."};

/* XPM */
static char * disregard_col_xpm[] = {
"15 5 2 1",
" 	c None",
".	c #000000",
". .  .  . . ...",
"... . . ... .  ",
"... . . ... .. ",
". . . . . . .  ",
". .  .  . . ..."};

/* XPM */
static char * move_col_right_xpm[] = {
"7 11 2 1",
" 	c None",
".	c #000000",
"  .    ",
"  ..   ",
"  ...  ",
"  .... ",
".......",
".......",
".......",
"  .... ",
"  ...  ",
"  ..   ",
"  .    "};

/* XPM */
static char * move_col_left_xpm[] = {
"7 11 2 1",
" 	c None",
".	c #000000",
"    .  ",
"   ..  ",
"  ...  ",
" ....  ",
".......",
".......",
".......",
" ....  ",
"  ...  ",
"   ..  ",
"    .  "};


/* XPM */
static char * pdf_xpm[] = {
"16 16 149 2",
"  	c None",
". 	c #A5A38D",
"+ 	c #949285",
"@ 	c #918F82",
"# 	c #908E81",
"$ 	c #929083",
"% 	c #94927E",
"& 	c #C3C3CB",
"* 	c #BEBEC6",
"= 	c #BCBCC2",
"- 	c #BABAC0",
"; 	c #B2B2B8",
"> 	c #A8A8AC",
", 	c #88888D",
"' 	c #DFDFDF",
") 	c #A09F99",
"! 	c #ABA891",
"~ 	c #FE7C7F",
"{ 	c #FF6A6C",
"] 	c #FF5356",
"^ 	c #FF484C",
"/ 	c #FF4144",
"( 	c #FF3D3F",
"_ 	c #FF373A",
": 	c #FF3134",
"< 	c #FB2E32",
"[ 	c #DB191D",
"} 	c #808085",
"| 	c #FBFBFB",
"1 	c #9B9B94",
"2 	c #AAA791",
"3 	c #FF7476",
"4 	c #FF3639",
"5 	c #FF2124",
"6 	c #FF1519",
"7 	c #FF0C11",
"8 	c #FF060A",
"9 	c #FF0004",
"0 	c #F50003",
"a 	c #E90004",
"b 	c #AB0104",
"c 	c #717173",
"d 	c #9A9991",
"e 	c #FF6163",
"f 	c #FF272A",
"g 	c #FF1A1E",
"h 	c #FF1217",
"i 	c #FF0B0F",
"j 	c #FF0408",
"k 	c #FA0003",
"l 	c #EE0003",
"m 	c #DB0003",
"n 	c #8B0002",
"o 	c #8A8A8D",
"p 	c #747477",
"q 	c #727274",
"r 	c #7E7E81",
"s 	c #8C8C8E",
"t 	c #A4A18B",
"u 	c #D7191C",
"v 	c #810406",
"w 	c #E6E6E6",
"x 	c #CBCBCB",
"y 	c #C5C5C5",
"z 	c #BBBBBB",
"A 	c #C8C8C8",
"B 	c #93907D",
"C 	c #969480",
"D 	c #D4D4D4",
"E 	c #CCCCCC",
"F 	c #D0D0D0",
"G 	c #DEDEDE",
"H 	c #D35152",
"I 	c #DCDBDB",
"J 	c #E0E0E0",
"K 	c #D8D8D8",
"L 	c #D2D2D2",
"M 	c #C7C7C7",
"N 	c #D9D9D9",
"O 	c #8E8C79",
"P 	c #D5D5D5",
"Q 	c #DDDDDD",
"R 	c #F4F4F4",
"S 	c #DF4E4D",
"T 	c #E3E2E3",
"U 	c #ECECEC",
"V 	c #E5E5E5",
"W 	c #DBDBDB",
"X 	c #CECECE",
"Y 	c #E1E1E1",
"Z 	c #8A8875",
"` 	c #E4E4E4",
" .	c #DADADA",
"..	c #E8DBDB",
"+.	c #DD3B3A",
"@.	c #E89A9D",
"#.	c #EEEEEE",
"$.	c #E7E7E7",
"%.	c #868472",
"&.	c #F5F5F5",
"*.	c #EA7C7B",
"=.	c #E9EDF1",
"-.	c #E68F90",
";.	c #EAAAAB",
">.	c #F6F6F6",
",.	c #E8E8E8",
"'.	c #E9E9E9",
").	c #EAEAEA",
"!.	c #EBD3D6",
"~.	c #E94B4C",
"{.	c #E9AAAA",
"].	c #E74849",
"^.	c #E74747",
"/.	c #ED5252",
"(.	c #DB8486",
"_.	c #F1F1F1",
":.	c #F2F2F2",
"<.	c #F3F3F3",
"[.	c #E35A5A",
"}.	c #EABCBE",
"|.	c #EFDADC",
"1.	c #EFF0F2",
"2.	c #F0FFFF",
"3.	c #E4EDF0",
"4.	c #D8B6B9",
"5.	c #D36468",
"6.	c #EFE2E5",
"7.	c #E25D5F",
"8.	c #E58D8F",
"9.	c #EBEBEB",
"0.	c #CDCDCD",
"a.	c #E16F70",
"b.	c #E57070",
"c.	c #DCDCDC",
"d.	c #D1D1D1",
"e.	c #C0C0C0",
"f.	c #D3D3D3",
"g.	c #95927E",
"h.	c #FFFFFF",
"i.	c #F7F7F7",
"j.	c #EDEDED",
"k.	c #E2E2E2",
"l.	c #C6C6C6",
"m.	c #858371",
"n.	c #93917D",
"o.	c #302F29",
"p.	c #1C1B17",
"q.	c #161613",
"r.	c #8F8D79",
"      . + @ # @ # # # $         ",
"      % & * = - ; > , ' ) !     ",
"~ { ] ^ / ( _ : < [ } | ' 1 2   ",
"3 4 5 6 7 8 9 0 a b c | | ' d   ",
"e f g h i j k l m n o p q r s t ",
"u n n n n n n n n v w x y z A B ",
"      C D E F G H I J K L M N O ",
"      C J P Q R S T U V W X Y Z ",
"      C `  .U ..+.@.R #.V D $.%.",
"      C $.Y &.*.=.-.;.>.,. .'.%.",
"      C U ).!.~.{.{.].^./.(._.%.",
"      C :.<.[.}.|.1.2.3.4.5.).%.",
"      C 6.7.8.<.9.$.V J  .0.Q %.",
"      C a.b._.` Y c.K d.F e.f.%.",
"      g.h.i.j.).w k.c.K L l.f.m.",
"      n.o.p.p.p.p.p.p.p.p.q.o.r."};

/* XPM */
static char * fit_frame_xpm[] = {
"12 12 2 1",
" 	c None",
".	c #0810B5",
"....    ....",
"...      ...",
"....    ....",
". ........ .",
"   .    .   ",
"   .    .   ",
"   .    .   ",
"   .    .   ",
". ........ .",
"....    ....",
"...      ...",
"....    ...."};

/* XPM */
static char * reset_rotation_xpm[] = {
"15 15 2 1",
" 	c None",
".	c #0810B5",
"     ..        ",
"     ..        ",
"     ..        ",
"     .......   ",
"    .     ..   ",
"   .     . .   ",
"  .......  .   ",
"  .     .  .   ",
"  .     .  .   ",
"  .     .  ....",
"  .     . .....",
"  .     ..     ",
" ........      ",
"...            ",
"..             "};

/* XPM */
static char * perspective_xpm[] = {
"16 16 2 1",
" 	c None",
".	c #0810B5",
"    ........    ",
"   ..      ..   ",
"  . .      . .  ",
" .  .      .  . ",
"................",
".   .      .   .",
".   .      .   .",
".   .      .   .",
".   .      .   .",
".   .      .   .",
".   .      .   .",
".   ........   .",
".  .        .  .",
". .          . .",
"..            ..",
"................"};

/* XPM */
static char * gray_map_xpm[] = {
"16 15 5 1",
" 	c None",
".	c #000000",
"+	c #C2BFA5",
"@	c #FFFFFF",
"#	c #808080",
".++++@@@@++++@@@",
".+##++@@++##++@@",
".####++++####+++",
".#..##++##..##++",
".#..##++##..##++",
".####++++####+++",
".+##++@@++##++@@",
".++++@@@@++++@@@",
".++++@@@@++++@@@",
".+##++@@++##++@@",
".####++++####+++",
".#..##++##..##++",
".#..##++##..##++",
".####++++####+++",
"................"};

/* XPM */
static char * contour_map_xpm[] = {
"16 15 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
".+++++++.+++++++",
".+....++.++....+",
"..++++.+.+.++++.",
"..+..+.+.+.+..+.",
"..+..+.+.+.+..+.",
"..++++.+.+.++++.",
".+....++.++....+",
".++++++.+.++++++",
".......+++......",
".++++++.+.++++++",
".+....++.++....+",
"..++++.+.+.++++.",
"..+..+.+.+.+..+.",
"..+..+.+.+.+..+.",
"................"};

/* XPM */
static char * color_map_xpm[] = {
"16 15 6 1",
" 	c None",
".	c #000000",
"+	c #00FF00",
"@	c #0000FF",
"#	c #FFFF00",
"$	c #FF0000",
".+  +@  @+  +@  ",
".+++++@@++++++@@",
".+##++++++##++++",
".#$$#+  +#$$#+  ",
".#$$#+  +#$$#+  ",
".+##++++++##++++",
".+++++@@++++++@@",
".+  +@  @+  +@  ",
".+  +@  @+  +@  ",
".+++++@@++++++@@",
".+##++++++##++++",
".#$$#+  +#$$#+  ",
".#$$#+  +#$$#+  ",
".+##++++++##++++",
"................"};

/* XPM */
static char * auto_layout_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #010000",
"...          ...",
"..            ..",
". .          . .",
"                ",
"    ........    ",
"    . +  + .    ",
"    .      .    ",
"    .      .    ",
"    .      .    ",
"    .      .    ",
"    . +  + .    ",
"    ........    ",
"                ",
". .          . .",
"..            ..",
"...          ..."};

/* XPM */
static char * movie_xpm[] = {
"32 32 257 2",
"  	c None",
". 	c #000000",
"+ 	c #969600",
"@ 	c #928E00",
"# 	c #8E8600",
"$ 	c #8A7E00",
"% 	c #908A00",
"& 	c #847200",
"* 	c #847000",
"= 	c #836F00",
"- 	c #826E00",
"; 	c #826D00",
"> 	c #7F6600",
", 	c #7C5F00",
"' 	c #966200",
") 	c #836E00",
"! 	c #775300",
"~ 	c #734A00",
"{ 	c #755000",
"] 	c #785600",
"^ 	c #7B5D00",
"/ 	c #D0B545",
"( 	c #B69931",
"_ 	c #AA8C27",
": 	c #744D00",
"< 	c #808080",
"[ 	c #775500",
"} 	c #765100",
"| 	c #765300",
"1 	c #785700",
"2 	c #9D7E1D",
"3 	c #84630A",
"4 	c #795900",
"5 	c #8C8100",
"6 	c #85640B",
"7 	c #857400",
"8 	c #C4A83C",
"9 	c #86650C",
"0 	c #7F6700",
"a 	c #B2952E",
"b 	c #877700",
"c 	c #7A5B00",
"d 	c #A08120",
"e 	c #7F6500",
"f 	c #8F6F13",
"g 	c #795B00",
"h 	c #775400",
"i 	c #8F7013",
"j 	c #7A5C00",
"k 	c #907114",
"l 	c #000080",
"m 	c #FFFCF6",
"n 	c #FFFDF7",
"o 	c #FFFBF4",
"p 	c #FFFBF3",
"q 	c #FFFBF2",
"r 	c #FFFBF5",
"s 	c #FFFFFF",
"t 	c #000000",
"u 	c #000000",
"v 	c #000000",
"w 	c #000000",
"x 	c #000000",
"y 	c #000000",
"z 	c #000000",
"A 	c #000000",
"B 	c #000000",
"C 	c #000000",
"D 	c #000000",
"E 	c #000000",
"F 	c #000000",
"G 	c #000000",
"H 	c #000000",
"I 	c #000000",
"J 	c #000000",
"K 	c #000000",
"L 	c #000000",
"M 	c #000000",
"N 	c #000000",
"O 	c #000000",
"P 	c #000000",
"Q 	c #000000",
"R 	c #000000",
"S 	c #000000",
"T 	c #000000",
"U 	c #000000",
"V 	c #000000",
"W 	c #000000",
"X 	c #000000",
"Y 	c #000000",
"Z 	c #000000",
"` 	c #000000",
" .	c #000000",
"..	c #000000",
"+.	c #000000",
"@.	c #000000",
"#.	c #000000",
"$.	c #000000",
"%.	c #000000",
"&.	c #000000",
"*.	c #000000",
"=.	c #000000",
"-.	c #000000",
";.	c #000000",
">.	c #000000",
",.	c #000000",
"'.	c #000000",
").	c #000000",
"!.	c #000000",
"~.	c #000000",
"{.	c #000000",
"].	c #000000",
"^.	c #000000",
"/.	c #000000",
"(.	c #000000",
"_.	c #000000",
":.	c #000000",
"<.	c #000000",
"[.	c #000000",
"}.	c #000000",
"|.	c #000000",
"1.	c #000000",
"2.	c #000000",
"3.	c #000000",
"4.	c #000000",
"5.	c #000000",
"6.	c #000000",
"7.	c #000000",
"8.	c #000000",
"9.	c #000000",
"0.	c #000000",
"a.	c #000000",
"b.	c #000000",
"c.	c #000000",
"d.	c #000000",
"e.	c #000000",
"f.	c #000000",
"g.	c #000000",
"h.	c #000000",
"i.	c #000000",
"j.	c #000000",
"k.	c #000000",
"l.	c #000000",
"m.	c #000000",
"n.	c #000000",
"o.	c #000000",
"p.	c #000000",
"q.	c #000000",
"r.	c #000000",
"s.	c #000000",
"t.	c #000000",
"u.	c #000000",
"v.	c #000000",
"w.	c #000000",
"x.	c #000000",
"y.	c #000000",
"z.	c #000000",
"A.	c #000000",
"B.	c #000000",
"C.	c #000000",
"D.	c #000000",
"E.	c #000000",
"F.	c #000000",
"G.	c #000000",
"H.	c #000000",
"I.	c #000000",
"J.	c #000000",
"K.	c #000000",
"L.	c #000000",
"M.	c #000000",
"N.	c #000000",
"O.	c #000000",
"P.	c #000000",
"Q.	c #000000",
"R.	c #000000",
"S.	c #000000",
"T.	c #000000",
"U.	c #000000",
"V.	c #000000",
"W.	c #000000",
"X.	c #000000",
"Y.	c #000000",
"Z.	c #000000",
"`.	c #000000",
" +	c #000000",
".+	c #000000",
"++	c #000000",
"@+	c #000000",
"#+	c #000000",
"$+	c #000000",
"%+	c #000000",
"&+	c #000000",
"*+	c #000000",
"=+	c #000000",
"-+	c #000000",
";+	c #000000",
">+	c #000000",
",+	c #000000",
"'+	c #000000",
")+	c #000000",
"!+	c #000000",
"~+	c #000000",
"{+	c #000000",
"]+	c #000000",
"^+	c #000000",
"/+	c #000000",
"(+	c #000000",
"_+	c #000000",
":+	c #000000",
"<+	c #000000",
"[+	c #000000",
"}+	c #000000",
"|+	c #000000",
"1+	c #000000",
"2+	c #000000",
"3+	c #000000",
"4+	c #000000",
"5+	c #000000",
"6+	c #000000",
"7+	c #000000",
"8+	c #000000",
"9+	c #000000",
"0+	c #000000",
"a+	c #000000",
"b+	c #000000",
"c+	c #000000",
"d+	c #000000",
"e+	c #000000",
"f+	c #000000",
"g+	c #000000",
"h+	c #000000",
"i+	c #000000",
"j+	c #000000",
"k+	c #000000",
"l+	c #000000",
"m+	c #000000",
"n+	c #000000",
"o+	c #000000",
"p+	c #000000",
"q+	c #000000",
"r+	c #000000",
"s+	c #000000",
"t+	c #000000",
"u+	c #000000",
"v+	c #000000",
"w+	c #000000",
"x+	c #000000",
"y+	c #000000",
"z+	c #000000",
"A+	c #000000",
"B+	c #000000",
"C+	c #000000",
"D+	c #000000",
"E+	c #000000",
"F+	c #000000",
"G+	c #000000",
"H+	c #000000",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"      . . . . . .                               . . . . . .     ",
"    .   .   .   . . .                       . . .   .   .   .   ",
"  .   . . . . . .   . . .               . .   . . . . . . .   . ",
"  . . . . + @ # $ . .   .           . .   . . . + % $ $ & . . . ",
"  . . % . * = - ; > , . .       . .   . . . ' ) . . . . ! ~ . . ",
"  . . ! . ~ { ] ^ ] { ~ .   . .   . . . / / . . . . . . ! ~ . . ",
"  . . ! . ~ { ] ^ ] { ~ . .   . . . / / ( _ . . . . . . : . < . ",
"  . . [ . } | [ 1 . . . < . . . . / ( ( 2 3 . . < . . . . < . . ",
"  . < . . 4 ] . . . < . . . / / . ( 2 2 3 3 . 5 . < . < . . . . ",
"  . . . . . . . < . . . / / ( ( . 2 3 3 3 6 . 7 8 . . . . / % . ",
"  . . < . < . < . . / / ( ( 2 2 . 3 3 3 6 9 . 0 a / / / / ( b . ",
"  . % . . . . . % . ( ( 2 2 3 3 . 3 6 6 9 [ . c d ( ( ( ( 2 e . ",
"  . b / / / / / b . 2 2 3 3 3 3 . 6 9 9 . . . c f 2 2 2 2 3 ! . ",
"  . e ( / / / ( e . 3 3 3 3 6 6 . 9 . .   . . g f 3 3 3 3 3 h . ",
"  . ! 2 _ _ _ 2 ! . 3 3 6 6 9 9 . .   . . . . g i 3 3 3 3 6 h . ",
"  . h 3 3 3 3 3 ! . 6 6 9 9 . .   . . .     . j k 6 6 6 6 9 [ . ",
"  . h 3 3 3 3 3 h . 9 9 . .   . . .         . . . 9 9 9 9 . . . ",
"  . [ 6 6 6 6 6 h . . .   . . .               .   . . . . .   . ",
"  . . 9 9 9 9 9 [ .   . . .                     . .       . .   ",
"  .   . . . . . . . . .                           . . . . .     ",
"    . .   .   .   .                                             ",
"      . . . . . . .                                             ",
"                                                    p           ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                "};

/* XPM */
static char * python_xpm[] = {
"16 16 36 1",
" 	c None",
".	c #000000",
"+	c #909090",
"@	c #3F3FFF",
"#	c #7F7FFF",
"$	c #0000FF",
"%	c #5050CF",
"&	c #4040BF",
"*	c #00007F",
"=	c #DFDFDF",
"-	c #404040",
";	c #404000",
">	c #202000",
",	c #606000",
"'	c #7F7F7F",
")	c #A0A0A0",
"!	c #7F7F00",
"~	c #3F3F3F",
"{	c #BFBF3F",
"]	c #808000",
"^	c #609F00",
"/	c #00BF00",
"(	c #40BF00",
"_	c #209F00",
":	c #00FF00",
"<	c #20DF00",
"[	c #007F00",
"}	c #003F00",
"|	c #205F00",
"1	c #9F5F00",
"2	c #BF0000",
"3	c #5F5F00",
"4	c #3F3F00",
"5	c #8F8F8F",
"6	c #AFAFAF",
"7	c #707070",
"................",
".+@@#@#$@$$$%&+.",
".**************.",
".=-  .;>,>   ').",
".=-  !~{~;   ').",
".=-  !~{~;.  ').",
".=-.>;,;,]>;.').",
".=-,]]]]^^/,]').",
".=-,],^(_/:;]').",
".=-:<<<[><[<]').",
".=-}|1>><}|<]').",
".=-.23_/}._^]').",
".=-24[}.}(^],').",
".=5''''''''''6).",
".5))))))))))))7.",
" .............. "};

/* XPM */
static char * fit_xpm[] = {
"32 32 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #FF0000",
"................................",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".+++++++++++++++++++++..+++++++.",
".+++++++++++++++++++++..+++++++.",
".+++++++++++++++++++++++@++++++.",
".+++++++++++++++++++++@@@++++++.",
".+++++++++++++++++..+@..+++++++.",
".+++++++++++++++++..+@..+++++++.",
".+++++++++++++++++++@@+++++++++.",
".++++++++++++++++++@@++++++++++.",
".++++++++++++++++..@+..++++++++.",
".++++++++++++++++..@+..++++++++.",
".+++++++++++++..++@++++++++++++.",
".+++++++++++++..+@@++++++++++++.",
".+++++++++++++++@..++++++++++++.",
".+++++++++++++@@@..++++++++++++.",
".+++++++++..+@..+++++++++++++++.",
".+++++++++..+@..+++++++++++++++.",
".+++++++++++@@+++++++++++++++++.",
".++++++++++@@++++++++++++++++++.",
".++++++++..@+..++++++++++++++++.",
".++++++++..@+..++++++++++++++++.",
".+++++++++@++++++++++++++++++++.",
".++++++++@@++++++++++++++++++++.",
".+++++++@..++++++++++++++++++++.",
".+++++++@..++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
"................................"};

/* XPM */
static char * zoomOut_xpm[] = {
"20 20 101 2",
"  	c None",
". 	c #8D8C89",
"+ 	c #50504F",
"@ 	c #202121",
"# 	c #010101",
"$ 	c #1F2020",
"% 	c #4F4F4E",
"& 	c #3B3A3A",
"* 	c #222224",
"= 	c #6E777E",
"- 	c #95A0AA",
"; 	c #ABBAC9",
"> 	c #8998A6",
", 	c #606C77",
"' 	c #1D2022",
") 	c #393939",
"! 	c #111211",
"~ 	c #5F6368",
"{ 	c #D1DBE6",
"] 	c #D8E3ED",
"^ 	c #D5E0EB",
"/ 	c #CDDBE8",
"( 	c #C3D3E3",
"_ 	c #B7CBDE",
": 	c #A6BCD2",
"< 	c #48545E",
"[ 	c #101110",
"} 	c #DDE6EF",
"| 	c #E5ECF3",
"1 	c #E6EDF3",
"2 	c #BED0E1",
"3 	c #B1C6DB",
"4 	c #A3BCD5",
"5 	c #47535E",
"6 	c #F1F5F8",
"7 	c #F4F7FA",
"8 	c #C1D2E2",
"9 	c #B4C8DC",
"0 	c #A6BED6",
"a 	c #98B2CC",
"b 	c #1C1F22",
"c 	c #F9FAFC",
"d 	c #C2D3E3",
"e 	c #B4C9DC",
"f 	c #A6BFD6",
"g 	c #9DB8D2",
"h 	c #566573",
"i 	c #000000",
"j 	c #74899C",
"k 	c #1E2020",
"l 	c #E5C479",
"m 	c #EED9A8",
"n 	c #F2E1BC",
"o 	c #EDD5A0",
"p 	c #E3BF6F",
"q 	c #D9A636",
"r 	c #D1940C",
"s 	c #8CA4BB",
"t 	c #030303",
"u 	c #232425",
"v 	c #A9C1D7",
"w 	c #9FB9D3",
"x 	c #525252",
"y 	c #191D20",
"z 	c #434E5A",
"A 	c #080809",
"B 	c #ADACA8",
"C 	c #040405",
"D 	c #191919",
"E 	c #262625",
"F 	c #8BA3BA",
"G 	c #13161A",
"H 	c #050607",
"I 	c #1C1C1C",
"J 	c #737373",
"K 	c #252525",
"L 	c #72716E",
"M 	c #131312",
"N 	c #050505",
"O 	c #262626",
"P 	c #727272",
"Q 	c #272626",
"R 	c #2F2F2E",
"S 	c #090908",
"T 	c #2F2F2F",
"U 	c #6F6F6F",
"V 	c #2A2A29",
"W 	c #5C5B59",
"X 	c #080808",
"Y 	c #3A3A3A",
"Z 	c #6A6A6A",
"` 	c #323231",
" .	c #8D8B88",
"..	c #444444",
"+.	c #656565",
"@.	c #3D3D3C",
"#.	c #B3B1AD",
"$.	c #4E4E4E",
"%.	c #585858",
"&.	c #30302F",
"*.	c #323232",
"        . + @ # $ % .                   ",
"      & * = - ; > , ' )                 ",
"    ! ~ { ] ^ / ( _ : < [               ",
"  & ~ } | 1 } / 2 2 3 4 5 )             ",
". * { | 6 7 | / 2 8 9 0 a b .           ",
"+ = ] 1 7 c 1 / 2 d e f g h %           ",
"@ - ^ i i i i i i i i i g j k           ",
"# ; / i l m n o p q r i g s t           ",
"$ > ( i i i # i i i i i g j u           ",
"% , _ 2 8 d v w g v w g g h x           ",
". ' : 3 9 e w g g w g g a y .           ",
"  ) < 4 0 f g g g g g g z A B           ",
"    [ 5 a g g g g g a z C D E           ",
"      ) b h j F j h G H i I J K         ",
"        . % k # k % L M N i O P Q       ",
"                        R S i T U V     ",
"                          W X i Y Z `   ",
"                             .X # ..+.@.",
"                              #.M N $.%.",
"                                  &.# *."};

/* XPM */
static char * configTable_xpm[] = {
"32 32 99 2",
"  	c None",
". 	c #B9B8A7",
"+ 	c #B49581",
"@ 	c #AF8875",
"# 	c #B08976",
"$ 	c #B08A77",
"% 	c #B18B77",
"& 	c #B18D78",
"* 	c #B28E79",
"= 	c #B28F79",
"- 	c #B3907A",
"; 	c #B3917A",
"> 	c #B4927B",
", 	c #B4937C",
"' 	c #B5957C",
") 	c #B5967D",
"! 	c #B6977E",
"~ 	c #B6987E",
"{ 	c #B7997F",
"] 	c #B79B80",
"^ 	c #B79C80",
"/ 	c #B89D81",
"( 	c #B99E82",
"_ 	c #B99F82",
": 	c #BAA083",
"< 	c #BAA183",
"[ 	c #BAA384",
"} 	c #BBA485",
"| 	c #BBA585",
"1 	c #BCA686",
"2 	c #BCA787",
"3 	c #BDA887",
"4 	c #2B2B2B",
"5 	c #932E1A",
"6 	c #943E2D",
"7 	c #90302A",
"8 	c #14148F",
"9 	c #77352E",
"0 	c #CAC7B0",
"a 	c #C2BFA5",
"b 	c #B9B7A2",
"c 	c #999682",
"d 	c #888674",
"e 	c #555555",
"f 	c #ECEBE2",
"g 	c #999887",
"h 	c #6A6855",
"i 	c #45443B",
"j 	c #9E9B86",
"k 	c #AFAD99",
"l 	c #8C8A77",
"m 	c #8F8D7E",
"n 	c #553D3D",
"o 	c #735B5B",
"p 	c #735C5B",
"q 	c #96937D",
"r 	c #8B886E",
"s 	c #F0F0E8",
"t 	c #D9D7C7",
"u 	c #BCB9A0",
"v 	c #95927E",
"w 	c #A09D88",
"x 	c #A2A08B",
"y 	c #CCCAB3",
"z 	c #CBC8B1",
"A 	c #CDCBB8",
"B 	c #E0DFD1",
"C 	c #DCDACB",
"D 	c #B6B5A9",
"E 	c #686653",
"F 	c #FFFFFF",
"G 	c #F8F7F4",
"H 	c #E8E7DA",
"I 	c #EBE9DD",
"J 	c #E9E7DB",
"K 	c #EAE9DD",
"L 	c #E9E8DB",
"M 	c #EAE9DC",
"N 	c #E9E8DC",
"O 	c #EAE8DC",
"P 	c #F7F6F2",
"Q 	c #EEEEE6",
"R 	c #E0DFD2",
"S 	c #EAE9E0",
"T 	c #C9C6AF",
"U 	c #E8E7DD",
"V 	c #B6B39A",
"W 	c #C1BEA5",
"X 	c #DFDED3",
"Y 	c #A8A487",
"Z 	c #B9B6A0",
"` 	c #D3D1BA",
" .	c #CFCDB5",
"..	c #D3D1C2",
"+.	c #E6E4D5",
"@.	c #DCDACA",
"#.	c #C0BEAF",
"$.	c #9A9889",
"%.	c #AAA797",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". + @ # $ % & * = - ; > , ' ) ! ~ { ] ^ / ( _ : < [ } | 1 2 3 4 ",
". 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 6 6 6 6 6 6 6 6 6 6 6 6 4 ",
". 7 8 8 8 9 5 5 5 5 5 5 5 5 5 5 5 5 5 0 a a 6 4 4 4 6 b c d 6 4 ",
". 7 e f f 9 5 5 5 5 5 5 5 5 5 5 5 5 5 0 a a 6 g a h 6 0 i j 6 4 ",
". 7 e f f 9 5 5 5 5 5 5 5 5 5 5 5 5 5 k 4 l 6 m a h 6 b 4 4 6 4 ",
". 7 n o p 9 5 5 5 5 5 5 5 5 5 5 5 5 5 h h h 6 h h h 6 q r r 6 4 ",
". 5 5 5 5 5 5 5 5 5 5 5 5 5 5 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 4 ",
". 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 ",
". 4 s s s s t a a a a a h 4 a a a a a a h 4 a a a a a 0 u a h 4 ",
". 4 s s s s t a a a a a h 4 a a a a a a h 4 a a a a a 0 4 4 h 4 ",
". 4 s s s s t a a a a a h 4 a a a a a a h 4 a a a a a 0 v w h 4 ",
". 4 s s s s t a a a a a h 4 a a a a a a h 4 a a a a a x 4 4 h 4 ",
". 4 s s s s t a a a a a h 4 a a a a a a h 4 a a a a a y z z h 4 ",
". 4 s s s s A h h h h h h 4 h h h h h h h 4 a a a a a 0 a a h 4 ",
". 4 B B B C 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 f f f f f D 4 4 E 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s H 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s I 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s J 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s K 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s L 4 ",
". 4 h h h h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s M 4 ",
". 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 F F F F F G s f N 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s O 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F G s s O 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F P Q Q R 4 ",
". 4 a a a h 4 F F F F F F 4 F F F F F F F 4 F F F F F S T T h 4 ",
". 4 h h h h 4 F F F F F F 4 F F F F F F F 4 F F F F F U 4 4 h 4 ",
". 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 F F F F F U c V h 4 ",
". 4 z z z W 4 F F F F F F 4 F F F F F F F 4 F F F F F X Y Y h 4 ",
". Z ` ` `  ...+.+.+.+.+.+.+.+.+.+.+.+.+.+.@.+.+.+.+.+.#.$.$.%.4 ",
"4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 "};

/* XPM */
static char * config_curves_xpm[] = {
"32 32 234 2",
"  	c #000000",
". 	c #808080",
"+ 	c #FFFFFF",
"@ 	c #FEFEFE",
"# 	c #FDFDFD",
"$ 	c #FCFCFC",
"% 	c #FBFBFB",
"& 	c #FF00FF",
"* 	c #D000D0",
"= 	c #A100A1",
"- 	c #FAFAFA",
"; 	c #F9F9F9",
"> 	c #F8F8F8",
", 	c #F900F9",
"' 	c #C900C9",
") 	c #9F009F",
"! 	c #F9F9FA",
"~ 	c #F8F8F9",
"{ 	c #F7F7F8",
"] 	c #F7F7F7",
"^ 	c #F6F6F7",
"/ 	c #F5F5F6",
"( 	c #F4F4F5",
"_ 	c #F400F4",
": 	c #C200C2",
"< 	c #9E009E",
"[ 	c #F6F6F6",
"} 	c #F5F5F5",
"| 	c #F4F4F4",
"1 	c #F3F3F3",
"2 	c #F2F2F2",
"3 	c #F1F1F1",
"4 	c #EF00EF",
"5 	c #BC00BC",
"6 	c #9C009C",
"7 	c #F3F3F4",
"8 	c #F0F0F1",
"9 	c #EFEFF0",
"0 	c #EEEEEF",
"a 	c #EDEDEE",
"b 	c #E900E9",
"c 	c #B500B5",
"d 	c #9B009B",
"e 	c #F1F1F2",
"f 	c #F0F0F0",
"g 	c #EDEDED",
"h 	c #EBEBEC",
"i 	c #EAEAEB",
"j 	c #FAFAFB",
"k 	c #FBFBFC",
"l 	c #E400E4",
"m 	c #AE00AE",
"n 	c #990099",
"o 	c #ECECEC",
"p 	c #E8E8E9",
"q 	c #E7E7E8",
"r 	c #DF00DF",
"s 	c #A800A8",
"t 	c #980098",
"u 	c #EFEFEF",
"v 	c #EBEBEB",
"w 	c #E9E9E9",
"x 	c #E7E7E7",
"y 	c #E5E5E5",
"z 	c #E3E3E4",
"A 	c #0000FF",
"B 	c #0000D0",
"C 	c #0000A1",
"D 	c #D900D9",
"E 	c #970097",
"F 	c #E6E6E7",
"G 	c #E4E4E5",
"H 	c #E2E2E3",
"I 	c #E0E0E1",
"J 	c #0000F7",
"K 	c #0000C7",
"L 	c #00009F",
"M 	c #D400D4",
"N 	c #9A009A",
"O 	c #950095",
"P 	c #E3E3E5",
"Q 	c #E1E1E2",
"R 	c #DEDEE0",
"S 	c #DCDCDE",
"T 	c #0000F0",
"U 	c #0000BE",
"V 	c #00009D",
"W 	c #CF00CF",
"X 	c #940094",
"Y 	c #E1E1E1",
"Z 	c #DEDEDF",
"` 	c #DBDBDC",
" .	c #D9D9DA",
"..	c #0000E9",
"+.	c #0000B5",
"@.	c #00009B",
"#.	c #8D008D",
"$.	c #920092",
"%.	c #D8D8D9",
"&.	c #D5D5D7",
"*.	c #F2F2F3",
"=.	c #0000E2",
"-.	c #0000AC",
";.	c #000099",
">.	c #C400C4",
",.	c #860086",
"'.	c #910091",
").	c #E5E5E6",
"!.	c #DBDBDD",
"~.	c #D8D8DA",
"{.	c #D2D2D4",
"].	c #0000DB",
"^.	c #0000A3",
"/.	c #000097",
"(.	c #BF00BF",
"_.	c #800080",
":.	c #900090",
"<.	c #CFCFD1",
"[.	c #0000D4",
"}.	c #00009A",
"|.	c #000095",
"1.	c #00FF00",
"2.	c #00D000",
"3.	c #00A100",
"4.	c #0000CD",
"5.	c #000091",
"6.	c #000093",
"7.	c #B900B9",
"8.	c #8E008E",
"9.	c #DFDFE0",
"0.	c #D5D5D6",
"a.	c #D1D1D3",
"b.	c #CECED0",
"c.	c #CBCBCD",
"d.	c #00F200",
"e.	c #00C000",
"f.	c #009D00",
"g.	c #0000C6",
"h.	c #000088",
"i.	c #B400B4",
"j.	c #C8C8CA",
"k.	c #00E500",
"l.	c #00B000",
"m.	c #009A00",
"n.	c #0000BF",
"o.	c #000080",
"p.	c #000090",
"q.	c #AF00AF",
"r.	c #8C008C",
"s.	c #D7D7D9",
"t.	c #D4D4D6",
"u.	c #CDCDD0",
"v.	c #CACACD",
"w.	c #C7C7CA",
"x.	c #C4C4C7",
"y.	c #00D800",
"z.	c #00A000",
"A.	c #009600",
"B.	c #0000B8",
"C.	c #00008E",
"D.	c #AA00AA",
"E.	c #8A008A",
"F.	c #C1C1C4",
"G.	c #00CB00",
"H.	c #009000",
"I.	c #009300",
"J.	c #0000B1",
"K.	c #00008C",
"L.	c #E9E9EA",
"M.	c #A400A4",
"N.	c #890089",
"O.	c #D3D3D5",
"P.	c #FF0000",
"Q.	c #D00000",
"R.	c #A10000",
"S.	c #BEBEC0",
"T.	c #ECECED",
"U.	c #00BF00",
"V.	c #008000",
"W.	c #0000AA",
"X.	c #00008A",
"Y.	c #880088",
"Z.	c #E90000",
"`.	c #B50000",
" +	c #9B0000",
".+	c #BABABD",
"++	c #CCCCCE",
"@+	c #D40000",
"#+	c #9A0000",
"$+	c #950000",
"%+	c #B7B7BA",
"&+	c #00B200",
"*+	c #008C00",
"=+	c #00009C",
"-+	c #000087",
";+	c #DCDCDD",
">+	c #850085",
",+	c #BF0000",
"'+	c #800000",
")+	c #900000",
"!+	c #B4B4B7",
"~+	c #00A500",
"{+	c #008900",
"]+	c #000085",
"^+	c #8F008F",
"/+	c #840084",
"(+	c #C4C4C6",
"_+	c #B0B0B4",
":+	c #009900",
"<+	c #008600",
"[+	c #000083",
"}+	c #D4D4D5",
"|+	c #820082",
"1+	c #C0C0C2",
"2+	c #AA0000",
"3+	c #8A0000",
"4+	c #ADADB0",
"5+	c #008300",
"6+	c #000081",
"7+	c #810081",
"8+	c #BCBCBF",
"9+	c #850000",
"0+	c #AAAAAD",
"a+	c #B8B8BB",
"b+	c #A6A6AA",
"c+	c #D6D6D8",
"d+	c #C7C7C9",
"e+	c #B5B5B8",
"f+	c #A3A3A7",
"g+	c #D2D2D3",
"h+	c #C3C3C5",
"i+	c #B1B1B4",
"j+	c #AFAFB2",
"k+	c #A0A0A4",
"                                                              . ",
"  + + + + + + + + + + + + + + + + + + + + + + + + + + + + +   . ",
"  @ @ @ @ @ @ @ @ @ @ @ @ @ @ +           # # $ $ $ % % % %   . ",
"  # # # # # # # @ @ @ @ @ @ @ +   & * =   . % % - - ; ; > >   . ",
"  $ $ $ $ $ # # # # # @ @ @ @ +   , ' )   . ! ~ { ] ^ / ( (   . ",
"  % % % % $ $ $ # # # # @ @ @ +   _ : <   . > ] [ } | 1 2 3   . ",
"  - - - % % % $ $ $ # # # @ @ +   4 5 6   . [ ( 7 2 8 9 0 a   . ",
"  ; ; ; - - % % $ $ $ # # @ @ +   b c d   . ( 1 e f 0 g h i   . ",
"  ~ ~ ; ! - j % k $ $ # # @ @ +   l m n   . 1 3 9 a o i p q   . ",
"  { { ~ ~ ! ! j %           @ +   r s t   . 3 u g v w x y z   . ",
"  ^ ^ { { ~ ; ! j   A B C   . +   D = E   . 9 g v p F G H I   . ",
"  / / ^ ] { ~ ; -   J K L   . +   M N O   . a h p F P Q R S   . ",
"  ( ( / ^ ] { ~ !   T U V   . +   W X X   . o w F z Y Z `  .  . ",
"  7 7 ( / ^ ] > ;   ..+.@.  . +   ' #.$.  . i q G Q Z ` %.&.  . ",
"  *.*.7 ( / ^ { ~   =.-.;.  . +   >.,.'.  . p ).H R !.~.&.{.  . ",
"  *.*.7 ( / ^ { ~   ].^./.  . +   (._.:.  . q z I S  .&.{.<.  . ",
"  *.          { ~   [.}.|.  . +   (._.:.  . q z I S  .&.{.<.  . ",
"  e   1.2.3.  . /   4.5.6.  . -   7._.8.  . H 9.!.%.0.a.b.c.  . ",
"  8   d.e.f.  . 1   g.h.5.  . [   i._.#.  . 9.` %.0.a.b.c.j.  . ",
"  9   k.l.m.  . 8   n.o.p.  . 2   q._.r.  . ` s.t.a.u.v.w.x.  . ",
"  0   y.z.A.  . a   B.o.C.  . a   D._.E.  . s.          x.F.  . ",
"  a   G.H.I.  . h   J.o.K.  . L.  M._.N.  . O.  P.Q.R.  . S.  . ",
"  T.  U.V.H.  . p   W.o.X.  . ).  ) _.Y.  . <.  Z.`. +  . .+  . ",
"  T.  U.V.H.  . F   ^.o.h.  . Q   N _.,.  . ++  @+#+$+  . %+  . ",
"  h   &+V.*+  . z   =+o.-+  . ;+  O _.>+  . j.  ,+'+)+  . !+  . ",
"  i   ~+V.{+  . Q   |.o.]+  . %.  ^+_./+  . (+  ,+'+)+  . _+  . ",
"  L.  :+V.<+  . Z   C.o.[+  . }+  E._.|+  . 1+  2+'+3+  . 4+  . ",
"  p   *+V.5+  . !.  -+o.6+  . <.  >+_.7+  . 8+  $+'+9+  . 0+  . ",
"  q   V.V.V.  .  .  o.o.o.  . c.  _._._.  . a+  '+'+'+  . b+  . ",
"  F           . c+          . d+          . e+          . f+  . ",
"  F z . . . . . t.g+. . . . . h+1+. . . . . i+j+. . . . . k+  . ",
"                                                              . "};

/* XPM */
static char * general_xpm[] = {
"32 32 760 2",
"  	c None",
". 	c #AFB7C3",
"+ 	c #ABB5C2",
"@ 	c #A3B1BF",
"# 	c #A1AFBE",
"$ 	c #A0ADBE",
"% 	c #9FABBD",
"& 	c #9DA9BC",
"* 	c #9BA9BB",
"= 	c #99A7BA",
"- 	c #97A6B9",
"; 	c #95A4B9",
"> 	c #94A2B9",
", 	c #92A0B8",
"' 	c #919FB7",
") 	c #8F9EB7",
"! 	c #8D9BB6",
"~ 	c #8B9AB5",
"{ 	c #8A99B4",
"] 	c #8897B2",
"^ 	c #8695B0",
"/ 	c #8492AC",
"( 	c #818FA9",
"_ 	c #7D8BA5",
": 	c #7A88A2",
"< 	c #76849E",
"[ 	c #727F99",
"} 	c #6E7B94",
"| 	c #69768E",
"1 	c #647187",
"2 	c #5E6A82",
"3 	c #667184",
"4 	c #A0A3A9",
"5 	c #ABB6C2",
"6 	c #B4BEC9",
"7 	c #C2CCD5",
"8 	c #C3CCD6",
"9 	c #BEC8D4",
"0 	c #BEC7D3",
"a 	c #BCC5D2",
"b 	c #BBC4D2",
"c 	c #BAC3D1",
"d 	c #B9C3D1",
"e 	c #B7C2D0",
"f 	c #B6C0D0",
"g 	c #B5BFCF",
"h 	c #B3BDCE",
"i 	c #B0BACD",
"j 	c #B2BCCF",
"k 	c #AFBACD",
"l 	c #AEB8CB",
"m 	c #ADB7CA",
"n 	c #ABB5C7",
"o 	c #A9B3C5",
"p 	c #A7B0C3",
"q 	c #A4AEC0",
"r 	c #A2ACBD",
"s 	c #9FA9BA",
"t 	c #9DA5B7",
"u 	c #99A2B3",
"v 	c #99A2B1",
"w 	c #929BAC",
"x 	c #6F798D",
"y 	c #9599A0",
"z 	c #C8D1D9",
"A 	c #FAFCFE",
"B 	c #EEF1F6",
"C 	c #FCFDFF",
"D 	c #FBFDFE",
"E 	c #FDFEFF",
"F 	c #FBFCFE",
"G 	c #FAFCFD",
"H 	c #F6F8FB",
"I 	c #EDF1F5",
"J 	c #FDFDFF",
"K 	c #F9FAFD",
"L 	c #F8FAFD",
"M 	c #F8FAFC",
"N 	c #F8F9FC",
"O 	c #F7F9FD",
"P 	c #ECEFF6",
"Q 	c #FAFCFF",
"R 	c #838D9F",
"S 	c #7F838C",
"T 	c #A2B0BE",
"U 	c #CBD3DC",
"V 	c #DEE3EB",
"W 	c #99A5BB",
"X 	c #F7F8FA",
"Y 	c #F1F4F7",
"Z 	c #F1F3F6",
"` 	c #EDF0F4",
" .	c #EEF2F5",
"..	c #EFF2F5",
"+.	c #EEF1F4",
"@.	c #E7EBEE",
"#.	c #DADFE4",
"$.	c #F0F3F7",
"%.	c #EBEEF2",
"&.	c #EAEEF2",
"*.	c #E9EDF1",
"=.	c #E8EBF0",
"-.	c #E7EAEF",
";.	c #E7E9EE",
">.	c #E5E8ED",
",.	c #E4E8ED",
"'.	c #E3E7ED",
").	c #E2E6EC",
"!.	c #E3E6EC",
"~.	c #E3E6EB",
"{.	c #EAEDF5",
"].	c #8690A1",
"^.	c #7B7F88",
"/.	c #A0AEBE",
"(.	c #C6CFD9",
"_.	c #F9FBFD",
":.	c #F0F3F6",
"<.	c #EFF3F5",
"[.	c #F3F6F9",
"}.	c #5F6876",
"|.	c #CCD0D5",
"1.	c #F4F6F8",
"2.	c #EDF0F3",
"3.	c #ECF0F3",
"4.	c #ECF0F4",
"5.	c #E5E8EC",
"6.	c #D6DADF",
"7.	c #EFF3F6",
"8.	c #E8ECF0",
"9.	c #D0D4DB",
"0.	c #C8C8D6",
"a.	c #C8C6D7",
"b.	c #C7C6D6",
"c.	c #C7C7D6",
"d.	c #C6C7D5",
"e.	c #C7CBD4",
"f.	c #DEE3E9",
"g.	c #DDE0E7",
"h.	c #D4D9E1",
"i.	c #F6F8FD",
"j.	c #848E9F",
"k.	c #7A7F87",
"l.	c #9FACBE",
"m.	c #C5CDD8",
"n.	c #F3F5F7",
"o.	c #F0F3F5",
"p.	c #F4F7F9",
"q.	c #4D5767",
"r.	c #C7CCD2",
"s.	c #F5F6F9",
"t.	c #E4E8EC",
"u.	c #D5D9DF",
"v.	c #E8EBEF",
"w.	c #D6D3E3",
"x.	c #8ED287",
"y.	c #6CD45A",
"z.	c #69C95B",
"A.	c #53B949",
"B.	c #64B562",
"C.	c #CDCCDA",
"D.	c #DEE3E8",
"E.	c #DDE1E8",
"F.	c #F8FAFE",
"G.	c #848D9F",
"H.	c #7A7E87",
"I.	c #9EAABD",
"J.	c #C4CCD8",
"K.	c #535C6C",
"L.	c #C9CED3",
"M.	c #ECEFF3",
"N.	c #EDEFF4",
"O.	c #EFF3F7",
"P.	c #E9ECF1",
"Q.	c #E1DBEE",
"R.	c #6DCD64",
"S.	c #60E03C",
"T.	c #83EE59",
"U.	c #48CB2D",
"V.	c #39A834",
"W.	c #DAD6E5",
"X.	c #DFE3E9",
"Y.	c #DEE2E8",
"Z.	c #DCE0E7",
"`.	c #838D9E",
" +	c #797E87",
".+	c #9CA9BC",
"++	c #C3CBD7",
"@+	c #F1F3F7",
"#+	c #F7FAFC",
"$+	c #535D6C",
"%+	c #CBD1D5",
"&+	c #F8FBFC",
"*+	c #F1F4F6",
"=+	c #E6E8ED",
"-+	c #D7DBE0",
";+	c #ECE5F6",
">+	c #60BE5E",
",+	c #5BD93D",
"'+	c #95FF6A",
")+	c #50D336",
"!+	c #359E33",
"~+	c #E5E1EE",
"{+	c #E0E3EA",
"]+	c #DEE2E9",
"^+	c #DCE1E8",
"/+	c #F9FBFF",
"(+	c #838C9D",
"_+	c #797E86",
":+	c #9AA8BB",
"<+	c #C2CAD7",
"[+	c #E1E5EA",
"}+	c #E2E6EB",
"|+	c #E5EAEE",
"1+	c #535F6E",
"2+	c #BEC4CC",
"3+	c #E6E9EE",
"4+	c #DFE3E8",
"5+	c #E6E9ED",
"6+	c #D8DCE0",
"7+	c #F0F4F7",
"8+	c #E8ECF1",
"9+	c #F6EFFE",
"0+	c #55B254",
"a+	c #20B711",
"b+	c #44D830",
"c+	c #1CB110",
"d+	c #2D962B",
"e+	c #EFEBF8",
"f+	c #E1E4EB",
"g+	c #DDE2E9",
"h+	c #828B9D",
"i+	c #797D86",
"j+	c #98A7BA",
"k+	c #C1CBD6",
"l+	c #DBE1E7",
"m+	c #B2B9C5",
"n+	c #B4BBC7",
"o+	c #6A7587",
"p+	c #9FA8B6",
"q+	c #B3BAC8",
"r+	c #ACB4C3",
"s+	c #C6CCD6",
"t+	c #E8EBEE",
"u+	c #D8DCE1",
"v+	c #F1F4F8",
"w+	c #E9EDF2",
"x+	c #FCF5FF",
"y+	c #5EB65F",
"z+	c #048D02",
"A+	c #0F8B0F",
"B+	c #058506",
"C+	c #3B9D3C",
"D+	c #F7F2FC",
"E+	c #DEE2EA",
"F+	c #818A9B",
"G+	c #787C85",
"H+	c #96A5B9",
"I+	c #C2CBD7",
"J+	c #C0C8D2",
"K+	c #F3F7F9",
"L+	c #EEF2F7",
"M+	c #EAEFF4",
"N+	c #ECF0F6",
"O+	c #ECF0F7",
"P+	c #F1F4FA",
"Q+	c #CDD3DD",
"R+	c #C2C8D2",
"S+	c #ECEEF2",
"T+	c #D8DDE2",
"U+	c #F2F4F9",
"V+	c #EBEEF3",
"W+	c #EAEEF3",
"X+	c #EBEDF2",
"Y+	c #E7ECEC",
"Z+	c #E8EFEC",
"`+	c #EBF1EE",
" @	c #E9EFED",
".@	c #E7EDEC",
"+@	c #E3E7EE",
"@@	c #E2E6ED",
"#@	c #E0E4EB",
"$@	c #FBFEFF",
"%@	c #80899B",
"&@	c #777C85",
"*@	c #95A3B9",
"=@	c #C2CBD8",
"-@	c #B6BDC9",
";@	c #F9FDFF",
">@	c #EBF0F3",
",@	c #E7ECF1",
"'@	c #D9DDE3",
")@	c #ECEFF4",
"!@	c #EBEFF4",
"~@	c #EEF1F7",
"{@	c #F1F2F9",
"]@	c #F0F1F9",
"^@	c #F0F1F8",
"/@	c #EDEFF6",
"(@	c #E7EAF1",
"_@	c #E4E8EF",
":@	c #E3E8EE",
"<@	c #FCFFFF",
"[@	c #7F889A",
"}@	c #777B84",
"|@	c #93A2B9",
"1@	c #C0C9D7",
"2@	c #F5F7FA",
"3@	c #A8B1C2",
"4@	c #A7B0C0",
"5@	c #A5AFBF",
"6@	c #848E9E",
"7@	c #99A2B2",
"8@	c #9FA7B8",
"9@	c #9AA3B4",
"0@	c #939CAC",
"a@	c #B7BEC7",
"b@	c #D9DEE4",
"c@	c #F2F5F9",
"d@	c #EDF0F5",
"e@	c #DBE0E6",
"f@	c #D5D8DC",
"g@	c #D6D7DB",
"h@	c #D5D6DB",
"i@	c #D7D6DA",
"j@	c #D7D7DB",
"k@	c #D4D9E2",
"l@	c #E6EAF1",
"m@	c #E4E9EF",
"n@	c #E3E7EF",
"o@	c #FDFFFF",
"p@	c #7E8698",
"q@	c #767A83",
"r@	c #92A0B9",
"s@	c #BDC6D6",
"t@	c #FFFFFF",
"u@	c #DCE0E8",
"v@	c #8C98AD",
"w@	c #919CB2",
"x@	c #929DB2",
"y@	c #3F4C60",
"z@	c #788397",
"A@	c #8B95AA",
"B@	c #838EA2",
"C@	c #858FA0",
"D@	c #B5BCC6",
"E@	c #DADFE5",
"F@	c #F4F6FA",
"G@	c #EFF2F7",
"H@	c #D7D9DE",
"I@	c #AEC8E0",
"J@	c #A0C3E6",
"K@	c #9FBDE1",
"L@	c #8FB6DE",
"M@	c #95B9DA",
"N@	c #D0D3DA",
"O@	c #E9EDF3",
"P@	c #E7EBF2",
"Q@	c #E5E9F2",
"R@	c #FEFFFF",
"S@	c #7C8597",
"T@	c #757A82",
"U@	c #919EB8",
"V@	c #BCC5D5",
"W@	c #ECEEF4",
"X@	c #C1C8D6",
"Y@	c #C2C9D7",
"Z@	c #C4CCD9",
"`@	c #434F5F",
" #	c #9DA6B4",
".#	c #BDC4D1",
"+#	c #B5BCC8",
"@#	c #ADB4C1",
"##	c #C5CBD4",
"$#	c #EDF1F6",
"%#	c #F3F5FA",
"&#	c #ECEFF5",
"*#	c #E0DDDF",
"=#	c #87BDF4",
"-#	c #76C2FF",
";#	c #86CCFC",
">#	c #58B0F5",
",#	c #53A0E6",
"'#	c #D9D8DC",
")#	c #E5E9F1",
"!#	c #E4E8F0",
"~#	c #E2E6F0",
"{#	c #7C8596",
"]#	c #757982",
"^#	c #909DB7",
"/#	c #BCC4D4",
"(#	c #F3F5F9",
"_#	c #F7F9FC",
":#	c #FBFDFF",
"<#	c #5B6876",
"[#	c #D0D5DB",
"}#	c #F5F7FB",
"|#	c #D3D8DE",
"1#	c #EEF1F5",
"2#	c #E3E7EC",
"3#	c #E2E5EA",
"4#	c #E2E5EB",
"5#	c #E2E0DF",
"6#	c #6EA4EC",
"7#	c #73C6FC",
"8#	c #AAFDFF",
"9#	c #69C6F6",
"0#	c #458BDB",
"a#	c #DBDBDD",
"b#	c #D9DEE6",
"c#	c #D8DDE6",
"d#	c #D6DCE6",
"e#	c #F8FBFF",
"f#	c #7B8596",
"g#	c #8E9BB6",
"h#	c #BBC3D4",
"i#	c #F2F6FA",
"j#	c #5A6776",
"k#	c #C6CCD3",
"l#	c #E4E6EB",
"m#	c #DCDFE5",
"n#	c #CFD4DA",
"o#	c #DEE2E7",
"p#	c #DDE1E6",
"q#	c #EBE8E5",
"r#	c #5B93DF",
"s#	c #43A8F0",
"t#	c #78E7FF",
"u#	c #43AFEF",
"v#	c #3779CE",
"w#	c #E4E3E5",
"x#	c #D5DBE4",
"y#	c #D3DAE3",
"z#	c #D1D8E2",
"A#	c #F5F9FF",
"B#	c #7B8496",
"C#	c #8C9BB5",
"D#	c #BAC3D3",
"E#	c #EAEDF2",
"F#	c #5A6877",
"G#	c #C2CAD0",
"H#	c #E9EDF0",
"I#	c #E3E7EB",
"J#	c #E3E6EA",
"K#	c #DBDEE4",
"L#	c #CED3D9",
"M#	c #DDE1E7",
"N#	c #DCE0E5",
"O#	c #F6F1ED",
"P#	c #4D87D3",
"Q#	c #0051C5",
"R#	c #065EC6",
"S#	c #0050BC",
"T#	c #296AC1",
"U#	c #F0EEEF",
"V#	c #D5DBE5",
"W#	c #D3DBE6",
"X#	c #D1D9E4",
"Y#	c #F6F9FF",
"Z#	c #B7C0D2",
"`#	c #F7F9FB",
" $	c #E5E9ED",
".$	c #E7EBEF",
"+$	c #5B6978",
"@$	c #C2C9D0",
"#$	c #E9ECEF",
"$$	c #DADEE3",
"%$	c #CED2D9",
"&$	c #DDE0E6",
"*$	c #DBDFE5",
"=$	c #E7E8EA",
"-$	c #BECFE5",
";$	c #A9C1E4",
">$	c #AEC4E5",
",$	c #ABC2E3",
"'$	c #B7CAE4",
")$	c #D4DCE7",
"!$	c #D3DCE7",
"~$	c #D1DAE5",
"{$	c #F6FAFF",
"]$	c #8998B3",
"^$	c #B6BFD0",
"/$	c #F4F6F9",
"($	c #E2E6EA",
"_$	c #E3E8EB",
":$	c #5B6A78",
"<$	c #C2C8CF",
"[$	c #E2E5E9",
"}$	c #E1E4E9",
"|$	c #DADDE3",
"1$	c #CDD2D9",
"2$	c #E7EBF1",
"3$	c #DDE0E5",
"4$	c #DDE2E7",
"5$	c #E9EAEC",
"6$	c #F2F0F0",
"7$	c #F2F2F2",
"8$	c #F1F2F3",
"9$	c #EAEDF0",
"0$	c #D9E0EA",
"a$	c #D4DDE8",
"b$	c #D3DDE9",
"c$	c #D0DAE7",
"d$	c #F6FBFF",
"e$	c #8897B1",
"f$	c #B5BED0",
"g$	c #5D6B79",
"h$	c #C2C7CF",
"i$	c #E0E4E9",
"j$	c #E0E3E8",
"k$	c #CCD1D8",
"l$	c #E7EAF0",
"m$	c #D2D7DF",
"n$	c #CBD4DE",
"o$	c #C8D4DF",
"p$	c #C7D4DF",
"q$	c #C7D5E1",
"r$	c #C7D5E2",
"s$	c #CCD4E1",
"t$	c #D4DEEA",
"u$	c #D3DDEA",
"v$	c #D0DBE9",
"w$	c #F6FCFF",
"x$	c #8694AF",
"y$	c #B4BDCE",
"z$	c #E1E5E9",
"A$	c #5E6C7A",
"B$	c #C1C7CE",
"C$	c #D8DCE2",
"D$	c #CCD1D7",
"E$	c #E6EAEF",
"F$	c #DBDEE5",
"G$	c #C2C9D3",
"H$	c #BDB8C3",
"I$	c #C0B4BF",
"J$	c #BFB2BE",
"K$	c #BDACB8",
"L$	c #BAAEBA",
"M$	c #BBC6D4",
"N$	c #D5DFEC",
"O$	c #D3DDEC",
"P$	c #D0DCEB",
"Q$	c #B2BCCD",
"R$	c #E4E7EB",
"S$	c #5F6D7B",
"T$	c #C0C7CE",
"U$	c #DDE2E8",
"V$	c #D7DBE1",
"W$	c #CBD0D6",
"X$	c #E5E9EF",
"Y$	c #DADEE4",
"Z$	c #DADEE5",
"`$	c #DBDFE7",
" %	c #C2D1DB",
".%	c #EAA0A4",
"+%	c #FF9191",
"@%	c #FA8C8B",
"#%	c #F26565",
"$%	c #DF686C",
"%%	c #BFD1DF",
"&%	c #D3DFEE",
"*%	c #D2DEEE",
"=%	c #CFDCED",
"-%	c #F7FDFF",
";%	c #B0BACA",
">%	c #F3F6F8",
",%	c #DFE2E7",
"'%	c #5F6E7C",
")%	c #C0C6CD",
"!%	c #DEE1E7",
"~%	c #D6DAE0",
"{%	c #CACFD6",
"]%	c #D9DDE4",
"^%	c #D9DDE5",
"/%	c #D9DFE7",
"(%	c #CCDDE5",
"_%	c #E78386",
":%	c #FE8A87",
"<%	c #FFAEAC",
"[%	c #F27171",
"}%	c #D3595C",
"|%	c #CADCE9",
"1%	c #D2DFEF",
"2%	c #D0DEEF",
"3%	c #7E8CA6",
"4%	c #AEB8C9",
"5%	c #E1E6EA",
"6%	c #5F6F7D",
"7%	c #BFC6CD",
"8%	c #DCE0E6",
"9%	c #D6D9DF",
"0%	c #C9CED5",
"a%	c #E4E9EE",
"b%	c #D8DDE3",
"c%	c #D8DDE5",
"d%	c #D7DDE6",
"e%	c #D7E8F0",
"f%	c #D77071",
"g%	c #F06361",
"h%	c #FF9190",
"i%	c #EC5D5D",
"j%	c #C34F51",
"k%	c #D6E7F3",
"l%	c #D2E0F0",
"m%	c #D1E0F1",
"n%	c #CFDFF1",
"o%	c #F7FEFF",
"p%	c #7B88A2",
"q%	c #ACB6C7",
"r%	c #DCE1E6",
"s%	c #DDE2E6",
"t%	c #606E7D",
"u%	c #BFC5CC",
"v%	c #E1E4EA",
"w%	c #DBDFE4",
"x%	c #D4D8DE",
"y%	c #C8CED4",
"z%	c #E3E8EF",
"A%	c #D7DDE3",
"B%	c #D7DDE5",
"C%	c #E2F2F9",
"D%	c #CA6062",
"E%	c #C51F1F",
"F%	c #CE3737",
"G%	c #BE2120",
"H%	c #B64042",
"I%	c #E1F2FC",
"J%	c #D1E1F3",
"K%	c #CFDFF3",
"L%	c #77859E",
"M%	c #AAB3C4",
"N%	c #E0E3E7",
"O%	c #E0E3E9",
"P%	c #586776",
"Q%	c #BCC2CA",
"R%	c #D3D7DE",
"S%	c #C7CDD4",
"T%	c #E3E9EE",
"U%	c #D7DCE3",
"V%	c #D7DDE4",
"W%	c #D6DCE5",
"X%	c #E2EDF4",
"Y%	c #D39EA3",
"Z%	c #C97073",
"`%	c #CA7678",
" &	c #C67374",
".&	c #CB9094",
"+&	c #E2EFF9",
"@&	c #D0E0F3",
"#&	c #D1E1F4",
"$&	c #D2E4F9",
"%&	c #F8FFFF",
"&&	c #74819A",
"*&	c #A9B2C2",
"=&	c #C5CBD5",
"-&	c #7B8793",
";&	c #C2C8D0",
">&	c #D1D5DD",
",&	c #C6CBD3",
"'&	c #E2E7ED",
")&	c #D6DAE2",
"!&	c #D5DBE3",
"~&	c #D4DCE5",
"{&	c #D8DEE7",
"]&	c #DFECF5",
"^&	c #E7F8FF",
"/&	c #ECFBFF",
"(&	c #EAFBFF",
"_&	c #E3F3FE",
":&	c #D7E2F0",
"<&	c #D0E2F6",
"[&	c #BCCEE4",
"}&	c #F4FBFF",
"|&	c #7C8697",
"1&	c #717C96",
"2&	c #AAB2C2",
"3&	c #D9DEE7",
"4&	c #919CB1",
"5&	c #DCDFE6",
"6&	c #D4D8DF",
"7&	c #D8DEE6",
"8&	c #D7DFE8",
"9&	c #D7DEEA",
"0&	c #D6DFEA",
"a&	c #D5DFEE",
"b&	c #D4E0F0",
"c&	c #D3E1F2",
"d&	c #D4E3F4",
"e&	c #D5E4F6",
"f&	c #D5E6F9",
"g&	c #94A0B5",
"h&	c #ECF2F9",
"i&	c #7E8899",
"j&	c #6D7891",
"k&	c #A0A8B9",
"l&	c #EEF0F6",
"m&	c #EFF1F7",
"n&	c #EFF2F8",
"o&	c #EFF3F8",
"p&	c #EDF1F7",
"q&	c #E9EDF4",
"r&	c #F5F8FB",
"s&	c #F0F4F9",
"t&	c #F0F4FA",
"u&	c #F1F5FB",
"v&	c #F1F5FC",
"w&	c #F1F6FC",
"x&	c #F2F7FD",
"y&	c #F2F7FE",
"z&	c #F2F8FE",
"A&	c #F3F9FE",
"B&	c #F3F9FF",
"C&	c #F6FDFF",
"D&	c #788395",
"E&	c #767F94",
"F&	c #7E889D",
"G&	c #929CAE",
"H&	c #9EA8B8",
"I&	c #9CA6B6",
"J&	c #9BA5B5",
"K&	c #9AA4B4",
"L&	c #9AA2B3",
"M&	c #98A0B1",
"N&	c #979FB0",
"O&	c #959EAE",
"P&	c #949CAD",
"Q&	c #929AAA",
"R&	c #929AA9",
"S&	c #8F98A8",
"T&	c #8E96A5",
"U&	c #8D95A4",
"V&	c #8D96A5",
"W&	c #8D97A6",
"X&	c #8E97A6",
"Y&	c #9099A8",
"Z&	c #7F8999",
"`&	c #5D697B",
" *	c #7E8289",
".*	c #A9ABB1",
"+*	c #9FA2A8",
"@*	c #90949A",
"#*	c #91949A",
"$*	c #909399",
"%*	c #8F9399",
"&*	c #8F9398",
"**	c #909298",
"=*	c #8F9297",
"-*	c #8F9197",
";*	c #8E9197",
">*	c #8E9096",
",*	c #8D9096",
"'*	c #8D8F95",
")*	c #8C8F94",
"!*	c #8B8E94",
"~*	c #8B8D93",
"{*	c #8A8D92",
"]*	c #8A8D93",
"^*	c #8B8E93",
"/*	c #85888D",
"(*	c #83878C",
"_*	c #959697",
". + @ # $ % & * = - ; > , ' ) ! ~ { ] ^ / ( _ : < [ } | 1 2 3 4 ",
"5 6 7 8 9 0 a b c d e f g h i j i k l m n o p q r s t u v w x y ",
"@ z A B C D A E D F G G G H I J K L M M L K L L N N N O P Q R S ",
"T U V W X Y Z `  ...+.+.+.@.#.$.%.&.*.=.-.;.>.,.'.).!.~.W {.].^.",
"/.(._.=.:.<.[.}.|.1.2.3.4.5.6.7.8.-.=.9.0.a.b.c.d.e.f.g.h.i.j.k.",
"l.m.E n.:.o.p.q.r.s.2.3.4.t.u.7.8.v.8.w.x.y.z.A.B.C.D.E.g.F.G.H.",
"I.J.C :.:.:.p.K.L.p.2.M.N.>.6.O.P.=.=.Q.R.S.T.U.V.W.X.Y.Z.F.`. +",
".+++C @+[.[.#+$+%+&+*+..` =+-+$.P.=.=.;+>+,+'+)+!+~+{+]+^+/+(+_+",
":+<+E 2.[+}+|+1+2+3+4+3+..5+6+7+*.8+8+9+0+a+b+c+d+e+f+{+g+Q h+i+",
"j+k+D l+. m+n+o+p+q+r+s+%.t+u+v+&.w+8+x+y+z+A+B+C+D+).f+E+Q F+G+",
"H+I+M.J+K+$.L+M+N+O+P+Q+R+S+T+U+V+W+w+X+Y+Z+`+ @.@v.+@@@#@$@%@&@",
"*@=@=.-@;@>@,@W++@]+g+-@n++.'@U+)@V+W+!@~@{@]@^@/@(@_@:@@@<@[@}@",
"|@1@2@s+3@4@5@6@7@8@9@0@a@ .b@c@d@)@d@e@f@g@h@i@j@k@l@m@n@o@p@q@",
"r@s@t@u@v@w@x@y@z@A@B@C@D@O.E@F@~@B G@H@I@J@K@L@M@N@O@P@Q@R@S@T@",
"U@V@t@W@X@Y@Z@`@ #.#+#@###$#b@%#&#V+&#*#=#-#;#>#,#'#)#!#~#o@{#]#",
"^#/#R@(#_#_#:#<#[#:#}#%#$.,.|#1#2#3#4#5#6#7#8#9#0#a#b#c#d#e#f#T@",
"g#h#R@c@c@U+i#j#k#` t.~.l#m#n#*.4+o#p#q#r#s#t#u#v#w#x#y#z#A#B#T@",
"C#D#E ` E#-.E#F#G#H#I#~.J#K#L#P.Y.M#N#O#P#Q#R#S#T#U#V#W#X#Y#B#T@",
"{ Z#`# $ $t..$+$@$#$J#3#3#$$%$8.M#&$*$=$-$;$>$,$'$2#)$!$~${$f#T@",
"]$^$/$($I#_$.$:$<$t+[$}$}$|$1$2$&$3$E@4$5$6$7$8$9$0$a$b$c$d$f#T@",
"e$f$/$($I#~.;.g$h$3+i$j$i$'@k$l$&$m#*$m$n$o$p$q$r$s$t$u$v$w$f#T@",
"x$y$/$z$($3#>.A$B$>.4+4+4+C$D$E$m#F$Z.G$H$I$J$K$L$M$N$O$P$w$f#]#",
"/ Q$[.j$}$}$R$S$T$t.Y.U$o#V$W$X$Y$Z$`$ %.%+%@%#%$%%%&%*%=%-%f#]#",
"( ;%>%,%4+4+I#'%)%2#4$p#!%~%{%X$]%^%/%(%_%:%<%[%}%|%&%1%2%-%f#]#",
"3%4%[.4$Y.o#5%6%7%4#&$N#8%9%0%a%b%c%d%e%f%g%h%i%j%k%l%m%n%o%f#]#",
"p%q%c@r%M#s%}$t%u%v%m#w%*$x%y%z%A%B%d#C%D%E%F%G%H%I%m%J%K%o%f#]#",
"L%M%[.N%N#&$O%P%Q%O%Y$Y$Y$R%S%T%U%V%W%X%Y%Z%`% &.&+&@&#&$&%&f#]#",
"&&*&W+=&m#K#&$-&;&&$C$C$b%>&,&'&)&!&~&{&]&^&/&(&_&:&@&<&[&}&|&]#",
"1&2&3&4&i$5&m#[+p#E@E@Z$E@6&{%_@c%7&8&9&0&N$a&b&c&d&e&f&g&h&i&]#",
"j&k&U+l&m&G@G@n&n&n&n&o&o&p&q&r&s&s&t&u&v&w&x&y&y&z&A&B&z&C&D&T@",
"E&F&G&H&I&J&K&9@L&v M&N&O&P&Q&R&S&T&U&V&V&V&V&V&W&W&X&X&Y&Z&`& *",
".*+*@*#*$*$*%*&***=*-*;*>*,*'*)*!*~*{*{*{*{*{*{*{*]*]*]*^*/*(*_*"};

/* XPM */
static char * swap_columns_xpm[] = {
"10 12 2 1",
" 	c None",
".	c #000000",
"       .  ",
"       .. ",
"..........",
"..........",
"       .. ",
"       .  ",
"  .       ",
" ..       ",
"..........",
"..........",
" ..       ",
"  .       "};

/* XPM */
static char * resize_xpm[] = {
"16 15 28 1",
" 	c None",
".	c #010000",
"+	c #0000FC",
"@	c #B7C5D5",
"#	c #859DB7",
"$	c #8AA0BA",
"%	c #8EA4BD",
"&	c #93A8C0",
"*	c #98ACC2",
"=	c #BBC8D7",
"-	c #8AA1BA",
";	c #8FA5BD",
">	c #94A9C0",
",	c #99ADC3",
"'	c #9EB1C6",
")	c #000000",
"!	c #B2C1D2",
"~	c #90A6BE",
"{	c #95AAC1",
"]	c #9AAEC3",
"^	c #9FB1C6",
"/	c #A5A38C",
"(	c #A19F89",
"_	c #9E9C87",
":	c #AAA790",
"<	c #B0AD95",
"[	c #92907C",
"}	c #878573",
"........        ",
".++++++.        ",
"........        ",
".@#$%&*.        ",
".=-;>,'. ) ) ) )",
".!~{]^..        ",
"......../      )",
"       ()/      ",
"   )    _):    )",
"         _)<    ",
"   )      ()[) )",
"           }))  ",
"   )       ))) )",
"                ",
"   ) ) ) ) ) ) )"};

static char* newfolder_xpm[] = {
    "15 14 4 1",
    " 	c None",
    ".	c #000000",
    "+	c #FFFF00",
    "@	c #FFFFFF",
    "          .    ",
    "               ",
    "          .    ",
    "       .     . ",
    "  ....  . . .  ",
    " .+@+@.  . .   ",
    "..........  . .",
    ".@+@+@+@+@..   ",
    ".+@+@+@+@+. .  ",
    ".@+@+@+@+@.  . ",
    ".+@+@+@+@+.    ",
    ".@+@+@+@+@.    ",
    ".+@+@+@+@+.    ",
    "...........    "};

static char* folder_open_xpm[]={
    "16 16 11 1",
    "# c #000000",
    "g c #c0c0c0",
    "e c #303030",
    "a c #ffa858",
    "b c #808080",
    "d c #a0a0a4",
    "f c #585858",
    "c c #ffdca8",
    "h c #dcdcdc",
    "i c #ffffff",
    ". c None",
    "....###.........",
    "....#ab##.......",
    "....#acab####...",
    "###.#acccccca#..",
    "#ddefaaaccccca#.",
    "#bdddbaaaacccab#",
    ".eddddbbaaaacab#",
    ".#bddggdbbaaaab#",
    "..edgdggggbbaab#",
    "..#bgggghghdaab#",
    "...ebhggghicfab#",
    "....#edhhiiidab#",
    "......#egiiicfb#",
    "........#egiibb#",
    "..........#egib#",
    "............#ee#"};

/* XPM */
static char * note_xpm[] = {
"16 16 28 1",
" 	c None",
".	c #3F3F3F",
"+	c #000000",
"@	c #303030",
"#	c #609F9F",
"$	c #60DFDF",
"%	c #30AFAF",
"&	c #00AFAF",
"*	c #305F5F",
"=	c #202020",
"-	c #308F8F",
";	c #909090",
">	c #404040",
",	c #306F6F",
"'	c #30DFDF",
")	c #C0C0C0",
"!	c #A0A0A0",
"~	c #BFBFBF",
"{	c #707070",
"]	c #DFDFDF",
"^	c #808080",
"/	c #30CFCF",
"(	c #204F4F",
"_	c #606060",
":	c #FFFFFF",
"<	c #505050",
"[	c #6F6F6F",
"}	c #CFCFCF",
"     .+..+..+.+ ",
"    @#$%#$%#$&*=",
"   +%$$$$$$$$-;>",
"   @$$,,,,,$'*)>",
"  +%$#,,,,%$-;)>",
"  @$$$$$$$$'*!~>",
" +%$$$$$$$$-{!~>",
" @$$$$$$$$'*)]]>",
"+%$$$$$$$$-^!~~>",
"+////////-(!!~~>",
" ++++@___;))]:]>",
"     <!!!!!!~~~>",
"     <!!!!!!~~~>",
"     []]]]]:::}>",
"     +^!!!!!!!;=",
"      +++++++++ "};

/* XPM */
static char * new_note_xpm[] = {
"15 16 6 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #C2BFA5",
"#	c #00FFFF",
"$	c #030003",
"..........     ",
".++++++++..    ",
".++++++++.@.   ",
".++++++++.@@.  ",
".++++++++.@@@. ",
".++++++++..... ",
".++++......... ",
".+++.#@#@#@#@#.",
".+++.@#....@#..",
".++.@#@#@#@#.+.",
".++.#@....#@.+.",
".+.@@#@#@#@.++.",
".+.@#@#@#@#.++.",
".++........+++.",
".++++.++++++++.",
"..............$"};

/* XPM */
static char * new_graph_xpm[] = {
"14 16 5 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #A0A7AF",
"#	c #FF0000",
"..........    ",
".++++++++..   ",
".++++++++.@.  ",
".+..+++++.@@. ",
".++.+++++.....",
".++.+++++++++.",
".+..++##+++#+.",
".++.+#++#++#+.",
".++.+#++#++#+.",
".+..#++++##++.",
".++.#++++++++.",
".++.#++++++++.",
".+..........+.",
".++.++.++.+++.",
".++++++++++++.",
".............."};

/* XPM */
static char * vectXYAM_xpm[] = {
"15 15 2 1",
" 	c None",
".	c #882F2A",
"  ...       .. ",
"  ..        .. ",
"  . .      .   ",
"     .    .    ",
"      .        ",
"       .       ",
"        .      ",
"         .     ",
"            .  ",
" ...       ... ",
" ..         .  ",
" . .        .  ",
"    .       .  ",
"            .  ",
"               "};

static char * vectXYXY_xpm[] = {
"15 15 3 1",
" 	c None",
".	c #080000",
"+	c #7B1616",
"     .         ",
"      .        ",
"   +++ .       ",
"    ++      .  ",
"   + +       . ",
". +         + .",
" .         +   ",
"  .       +    ",
"         +     ",
"        +      ",
"     + +       ",
"     ++        ",
"   . +++       ",
"    .          ",
"     .         "};

/* XPM */
static char * open_template_xpm[] = {
"15 16 7 1",
" 	c None",
".	c #000000",
"+	c #E1E0D2",
"@	c #FFFF00",
"#	c #808000",
"$	c #FFFFFF",
"%	c #030003",
"         ...   ",
"        .   . .",
" ...         ..",
".+@+....... ...",
".@+@+@+@+@.    ",
".+@+@+@+@+.    ",
".@+@+..........",
".+@+.#########.",
".@+............",
".+..$$$$$$$$$$.",
"..#.$%$$$$$$$$.",
"....$%$$$$$$$$.",
"   .$%$%$$%$$$.",
"   .$%%%%%%%%$.",
"   .$$$$$$$$$$.",
"   ............"};

/* XPM */
static char * save_template_xpm[] = {
"17 16 83 1",
" 	c None",
".	c #030003",
"+	c #AEC9E4",
"@	c #84808A",
"#	c #ECA898",
"$	c #EEA493",
"%	c #E69D91",
"&	c #E69E94",
"*	c #E29E91",
"=	c #DF9689",
"-	c #DE9488",
";	c #DB9287",
">	c #C28985",
",	c #83909E",
"'	c #728A9D",
")	c #A3BEDA",
"!	c #7E7784",
"~	c #D89187",
"{	c #D88B83",
"]	c #D78B83",
"^	c #D78C83",
"/	c #CD837C",
"(	c #D0827B",
"_	c #D2867C",
":	c #CD796F",
"<	c #B67977",
"[	c #778293",
"}	c #516B7D",
"|	c #9EBDD4",
"1	c #878D93",
"2	c #FFFFFF",
"3	c #E4E4E4",
"4	c #7B8998",
"5	c #4E687B",
"6	c #A0BBD2",
"7	c #82878D",
"8	c #DDDEDD",
"9	c #C0C1C0",
"0	c #7E8B98",
"a	c #4C6374",
"b	c #9AB9D2",
"c	c #80858B",
"d	c #7E8A98",
"e	c #475F70",
"f	c #95B7CF",
"g	c #81888D",
"h	c #C5C5C5",
"i	c #4E606D",
"j	c #99B8CE",
"k	c #838088",
"l	c #D4D3D4",
"m	c #D3D2D3",
"n	c #D0D1D2",
"o	c #D1D1D1",
"p	c #BEBEBF",
"q	c #7A8A99",
"r	c #4B5B65",
"s	c #91B1CB",
"t	c #7E97AB",
"u	c #7E90A2",
"v	c #7C8D9D",
"w	c #000000",
"x	c #90AECA",
"y	c #6D90A9",
"z	c #637380",
"A	c #697075",
"B	c #8DADC7",
"C	c #67859B",
"D	c #797B7D",
"E	c #D5D4D2",
"F	c #8BABC5",
"G	c #6A8399",
"H	c #888889",
"I	c #E6E1E0",
"J	c #7B99AE",
"K	c #647E93",
"L	c #7F8081",
"M	c #D7D6D6",
"N	c #838072",
"O	c #4C5E6B",
"P	c #646A6D",
"Q	c #A8A39D",
"R	c #838071",
"...............  ",
".+@#$%&*=-;>,'.  ",
".)!~{]^/(_:<[}.  ",
".|122222222345.  ",
".678888888890a.  ",
".bc222222223de.  ",
".fg88888888h4i.  ",
".jklmmmnommpqr.  ",
".stuvwwwwwwwwwwww",
".xyzAw2222222222w",
".BCDEw2.22222222w",
".FGHIw2.22222222w",
".JKLMw2.2.22.222w",
"N.OPQw2........2w",
" R....2222222222w",
"     wwwwwwwwwwww"};

/* XPM */
static char * boxPlot_xpm[] = {
"16 16 2 1",
" 	c None",
".	c #1F0E77",
"                ",
"                ",
"    .......     ",
"       .        ",
"       .        ",
" .............. ",
" .            . ",
" .            . ",
" .            . ",
" .............. ",
" .            . ",
" .............. ",
"       .        ",
"       .        ",
"    .......     ",
"                "};

static char * clock_xpm[] = {
"17 17 57 1",
" 	c None",
".	c #808080",
"+	c #FFFFFF",
"@	c #DDDDAC",
"#	c #C8C8A8",
"$	c #000000",
"%	c #000080",
"&	c #B8B8A6",
"*	c #ACACA5",
"=	c #F4F4AF",
"-	c #EFEFAE",
";	c #EAEAAD",
">	c #E0E0AC",
",	c #DBDBAB",
"'	c #D6D6AA",
")	c #E4E4AC",
"!	c #DFDFAB",
"~	c #D2D2A9",
"{	c #CECEA9",
"]	c #CACAA8",
"^	c #E5E5AD",
"/	c #DADAAB",
"(	c #D5D5AA",
"_	c #CDCDA9",
":	c #C7C7A8",
"<	c #C4C4A7",
"[	c #E1E1AC",
"}	c #D0D0A9",
"|	c #C3C3A7",
"1	c #C1C1A7",
"2	c #BDBDA6",
"3	c #BBBBA6",
"4	c #D7D7AB",
"5	c #D1D1AA",
"6	c #CBCBA9",
"7	c #C6C6A8",
"8	c #C0C0A7",
"9	c #B6B6A6",
"0	c #BBBBA7",
"a	c #BABAA6",
"b	c #B9B9A6",
"c	c #B7B7A6",
"d	c #BEBEA7",
"e	c #B4B4A6",
"f	c #B3B3A5",
"g	c #B2B2A5",
"h	c #B1B1A5",
"i	c #B0B0A5",
"j	c #B5B5A6",
"k	c #ADADA5",
"l	c #ABABA5",
"m	c #ADADA4",
"n	c #A9A9A4",
"o	c #A6A6A4",
"p	c #A5A5A4",
"q	c #A3A3A4",
"r	c #A0A0A4",
"      .....      ",
"    ..+++++..    ",
"   .++@#$@#++.   ",
"  .+#%&$$$*%@+$  ",
" .+&*=-;$>,'&*+$ ",
" .+%-;)!$'~{]%+$ ",
".+@#^>/($_]:<@#+$",
".+&[,(}]$|1$23*+$",
".+%45678$$$$$9%+$",
".+@456780ab$c9#+$",
".+&*#|dbefghi&*+$",
" .+%dajhk**ll%+$ ",
" .+@#hmnoppp@#+$ ",
"  .+*%@qrr#%&+$  ",
"  .$++&*%&*++$   ",
"    $$+++++$$    ",
"      $$$$$      "};

static char * matrix_xpm[] = {
"13 12 20 1",
" 	c None",
".	c #000821",
"+	c #000720",
"@	c #000927",
"#	c #000C39",
"$	c #000C37",
"%	c #000929",
"&	c #00041B",
"*	c #000519",
"=	c #597384",
"-	c #5A7387",
";	c #00061E",
">	c #4C7799",
",	c #517595",
"'	c #000212",
")	c #000209",
"!	c #000207",
"~	c #00030C",
"{	c #010101",
"]	c #FFFF80",
".++@#$%++%#$&",
"*=-;>>;==;>,'",
")!))~~~!))~){",
"{]]{]]{]]{]]{",
"{]]{]]{]]{]]{",
"{{{{{{{{{{{{{",
"{]]{]]{]]{]]{",
"{]]{]]{]]{]]{",
"{{{{{{{{{{{{{",
"{]]{]]{]]{]]{",
"{]]{]]{]]{]]{",
"{{{{{{{{{{{{{"};


static char * new_matrix_xpm[] = {
"15 16 6 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #8F888F",
"#	c #2007F0",
"$	c #FFFF80",
"..........     ",
".++++++++..    ",
".++++++++.@.   ",
".++++++++.@@.  ",
".++++++++.@@@. ",
".++++++++..... ",
".++++++++++++. ",
".+.............",
".+.##.##.##.##.",
".+.............",
".+.$$.$$.$$.$$.",
".+.$$.$$.$$.$$.",
".+.............",
".+.$$.$$.$$.$$.",
".+.$$.$$.$$.$$.",
"..............."};

static char * prev_xpm[] = {
"16 17 27 1",
" 	c None",
".	c #000000",
"+	c #BDD3BD",
"@	c #B5CBB5",
"#	c #B5C7B5",
"$	c #B5CFB5",
"%	c #BDCFB5",
"&	c #BDCFBD",
"*	c #7BAA7B",
"=	c #ADC7AD",
"-	c #B5CBAD",
";	c #ADC7A5",
">	c #6B8263",
",	c #292C29",
"'	c #ADCBAD",
")	c #B5C7AD",
"!	c #638E63",
"~	c #9CAE9C",
"{	c #84AE84",
"]	c #84B284",
"^	c #8CAE84",
"/	c #8CB284",
"(	c #527152",
"_	c #395131",
":	c #5A7952",
"<	c #4A6142",
"[	c #425539",
"        .       ",
"       ..       ",
"      .+.       ",
"     .@#.       ",
"    .@@#........",
"   .@@$$%+%&+@*.",
"  .@=@@-=====;>.",
" ,@')=='===)='!.",
".~{{{{{{]^{]/{(.",
" ._:::::::::::<.",
"  ._::::::::::<.",
"   ._::<______[.",
"    ._:<........",
"     ._<.       ",
"      .<.       ",
"       ..       ",
"        .       "};

static char * next_xpm[] = {
"16 17 26 1",
" 	c None",
".	c #000000",
"+	c #8CA684",
"@	c #BAD4B8",
"#	c #73A26B",
"$	c #BAD4BA",
"%	c #ADCBAD",
"&	c #739A63",
"*	c #BDD7BD",
"=	c #BAD3B8",
"-	c #BAD3BA",
";	c #ADC7AD",
">	c #081008",
",	c #ADC7A5",
"'	c #A5C7A5",
")	c #7B9E73",
"!	c #A5BEA5",
"~	c #A5C3A5",
"{	c #6B9263",
"]	c #738E6B",
"^	c #6B8E63",
"/	c #425929",
"(	c #6B8663",
"_	c #5A7952",
":	c #63825A",
"<	c #526942",
"       .        ",
"       ..       ",
"       .+.      ",
"       .@#.     ",
"........$%&.    ",
".*******=-;&>   ",
".;%;;;,,;%;').  ",
".!;,',,;%;;%~{. ",
".]^{{{{{{{{{{^/.",
".(___________/. ",
".(__________/.  ",
".:<<<<<<___/.   ",
"........<_/.    ",
"       .</.     ",
"       ./.      ",
"       ..       ",
"       .        "};

static char *stacked_xpm[] = {
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c #150303",
"aw c None",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avavavavavavavavavavavavavavavav",
"awawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avavavavavavavavavavavavavavavav",
"awawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avawawawawawawawawawawawawawawaw",
"avavavavavavavavavavavavavavavav"
};


static char *panel_v2_xpm[] = {
/* width height num_colors chars_per_pixel */
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c None",
"aw c #000000",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"auavavavavavavavavavavavavavavav",
"au.O.Oavavavavavavavav.O.Oavavav",
"auavav.O.Oavavavav.O.Oavav.Oavav",
"auavavavav.Oavav.Oavavavavav.Oav",
"auavavavavav.O.Oavavavavavavavav",
"auavavavavavavavavavavavavavavav",
"auauauauauauauauauauauauauauauau",
"avavavavavavavavavavavavavavavav",
"auavavavavavavavav.O.O.Oavavavav",
"auavavavavavav.O.Oavavavavavavav",
"auavavavav.O.Oavavavavavavavavav",
"auavavav.Oavavavavavavavavavavav",
"auavav.Oavavavavavavavavavavavav",
"auav.Oavavavavavavavavavavavavav",
"au.Oavavavavavavavavavavavavavav",
"auauauauauauauauauauauauauauauau"
};


static char *panel_4_xpm[] = {
/* width height num_colors chars_per_pixel */
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c None",
"aw c #000000",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"auavavavavavavavauavavavavavavav",
"au.O.Oavavavavavauavavav.Oavavav",
"auavav.O.Oavavavau.Oav.Oav.Oavav",
"auavavavav.Oavavauav.Oavavav.Oav",
"auavavavavav.Oavauavavavavavavav",
"auavavavavavavavauavavavavavavav",
"auauauauauauauavauauauauauauauau",
"avavavavavavavavavavavavavavavav",
"auavavavavavavavauavavav.Oavavav",
"auavavavavavavavauavavav.Oavavav",
"auavavavavavavavauavavav.Oavavav",
"auavavav.O.O.Oavauavav.Oavavavav",
"auavav.Oavavavavauavav.Oavavavav",
"auav.Oavavavavavauav.Oavavavavav",
"au.Oavavavavavavau.Oavavavavavav",
"auauauauauauauavauauauauauauauau"
};

static char *panel_h2_xpm[] = {
/* width height num_colors chars_per_pixel */
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c None",
"aw c #000000",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"avavavavavavavavavavavavavavavav",
"auavavavavavavavauavavavavavavav",
"auavavavavav.Oavauavavavav.Oavav",
"auavavavavav.Oavauavavavav.Oavav",
"auavavavavav.Oavauavavavav.Oavav",
"auavavavavav.Oavauavavavav.Oavav",
"auavavavavav.Oavauavavavav.Oavav",
"auavavavav.Oavavauavavav.Oavavav",
"auavavavav.Oavavauavavav.Oavavav",
"auavavavav.Oavavauavavav.Oavavav",
"auavavav.Oavavavauavav.Oavavavav",
"auavav.Oavavavavauavav.Oavavavav",
"auav.Oavavavavavauav.Oavavavavav",
"au.Oavavavavavavau.Oavavavavavav",
"auauauauauauauavauauauauauauauau",
"avavavavavavavavavavavavavavavav"
};

static char *stacked_hist_xpm[] = {
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c #830a0a",
"aw c None",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"auawawawawawawawawawawawawawawaw",
"auawawawawavavavavawawawawawawaw",
"auawawawawavavawavawawawawawawaw",
"auawawavavavawavavawawawawawawaw",
"auawawavawavavawavavavavawawawaw",
"auawawavawavawavavawawavawawawaw",
"auauauauauauauauauauauauauauauau",
"awawawawawawawawawawawawawawawaw",
"auawawavavavavawawawawawawawawaw",
"auawawavavawavawawavavavavawawaw",
"auawawavawavavavavavawavavawawaw",
"auawawavawawavawawavavawavawawaw",
"auawawavavawavavawavawavavawawaw",
"auawawavawavavawavavawawavawawaw",
"auawawavavawavavawavavawavawawaw",
"auauauauauauauauauauauauauauauau"
};

static char *histogram_xpm[] = {
/* width height num_colors chars_per_pixel */
"    16    16      256            2",
/* colors */
"`` c #ffffff",
"`. c #ffffcc",
"`# c #ffff99",
"`a c #ffff66",
"`b c #ffff33",
"`c c #ffff00",
"`d c #ffccff",
"`e c #ffcccc",
"`f c #ffcc99",
"`g c #ffcc66",
"`h c #ffcc33",
"`i c #ffcc00",
"`j c #ff99ff",
"`k c #ff99cc",
"`l c #ff9999",
"`m c #ff9966",
"`n c #ff9933",
"`o c #ff9900",
"`p c #ff66ff",
"`q c #ff66cc",
"`r c #ff6699",
"`s c #ff6666",
"`t c #ff6633",
"`u c #ff6600",
"`v c #ff33ff",
"`w c #ff33cc",
"`x c #ff3399",
"`y c #ff3366",
"`z c #ff3333",
"`A c #ff3300",
"`B c #ff00ff",
"`C c #ff00cc",
"`D c #ff0099",
"`E c #ff0066",
"`F c #ff0033",
"`G c #ff0000",
"`H c #ccffff",
"`I c #ccffcc",
"`J c #ccff99",
"`K c #ccff66",
"`L c #ccff33",
"`M c #ccff00",
"`N c #ccccff",
"`O c #cccccc",
"`P c #cccc99",
"`Q c #cccc66",
"`R c #cccc33",
"`S c #cccc00",
"`T c #cc99ff",
"`U c #cc99cc",
"`V c #cc9999",
"`W c #cc9966",
"`X c #cc9933",
"`Y c #cc9900",
"`Z c #cc66ff",
"`0 c #cc66cc",
"`1 c #cc6699",
"`2 c #cc6666",
"`3 c #cc6633",
"`4 c #cc6600",
"`5 c #cc33ff",
"`6 c #cc33cc",
"`7 c #cc3399",
"`8 c #cc3366",
".` c #cc3333",
".. c #cc3300",
".# c #cc00ff",
".a c #cc00cc",
".b c #cc0099",
".c c #cc0066",
".d c #cc0033",
".e c #cc0000",
".f c #99ffff",
".g c #99ffcc",
".h c #99ff99",
".i c #99ff66",
".j c #99ff33",
".k c #99ff00",
".l c #99ccff",
".m c #99cccc",
".n c #99cc99",
".o c #99cc66",
".p c #99cc33",
".q c #99cc00",
".r c #9999ff",
".s c #9999cc",
".t c #999999",
".u c #999966",
".v c #999933",
".w c #999900",
".x c #9966ff",
".y c #9966cc",
".z c #996699",
".A c #996666",
".B c #996633",
".C c #996600",
".D c #9933ff",
".E c #9933cc",
".F c #993399",
".G c #993366",
".H c #993333",
".I c #993300",
".J c #9900ff",
".K c #9900cc",
".L c #990099",
".M c #990066",
".N c #990033",
".O c #990000",
".P c #66ffff",
".Q c #66ffcc",
".R c #66ff99",
".S c #66ff66",
".T c #66ff33",
".U c #66ff00",
".V c #66ccff",
".W c #66cccc",
".X c #66cc99",
".Y c #66cc66",
".Z c #66cc33",
".0 c #66cc00",
".1 c #6699ff",
".2 c #6699cc",
".3 c #669999",
".4 c #669966",
".5 c #669933",
".6 c #669900",
".7 c #6666ff",
".8 c #6666cc",
"#` c #666699",
"#. c #666666",
"## c #666633",
"#a c #666600",
"#b c #6633ff",
"#c c #6633cc",
"#d c #663399",
"#e c #663366",
"#f c #663333",
"#g c #663300",
"#h c #6600ff",
"#i c #6600cc",
"#j c #660099",
"#k c #660066",
"#l c #660033",
"#m c #660000",
"#n c #33ffff",
"#o c #33ffcc",
"#p c #33ff99",
"#q c #33ff66",
"#r c #33ff33",
"#s c #33ff00",
"#t c #33ccff",
"#u c #33cccc",
"#v c #33cc99",
"#w c #33cc66",
"#x c #33cc33",
"#y c #33cc00",
"#z c #3399ff",
"#A c #3399cc",
"#B c #339999",
"#C c #339966",
"#D c #339933",
"#E c #339900",
"#F c #3366ff",
"#G c #3366cc",
"#H c #336699",
"#I c #336666",
"#J c #336633",
"#K c #336600",
"#L c #3333ff",
"#M c #3333cc",
"#N c #333399",
"#O c #333366",
"#P c #333333",
"#Q c #333300",
"#R c #3300ff",
"#S c #3300cc",
"#T c #330099",
"#U c #330066",
"#V c #330033",
"#W c #330000",
"#X c #00ffff",
"#Y c #00ffcc",
"#Z c #00ff99",
"#0 c #00ff66",
"#1 c #00ff33",
"#2 c #00ff00",
"#3 c #00ccff",
"#4 c #00cccc",
"#5 c #00cc99",
"#6 c #00cc66",
"#7 c #00cc33",
"#8 c #00cc00",
"a` c #0099ff",
"a. c #0099cc",
"a# c #009999",
"aa c #009966",
"ab c #009933",
"ac c #009900",
"ad c #0066ff",
"ae c #0066cc",
"af c #006699",
"ag c #006666",
"ah c #006633",
"ai c #006600",
"aj c #0033ff",
"ak c #0033cc",
"al c #003399",
"am c #003366",
"an c #003333",
"ao c #003300",
"ap c #0000ff",
"aq c #0000cc",
"ar c #000099",
"as c #000066",
"at c #000033",
"au c #000000",
"av c #830a0a",
"aw c None",
"ax c #000000",
"ay c #000000",
"az c #000000",
"aA c #000000",
"aB c #000000",
"aC c #000000",
"aD c #000000",
"aE c #000000",
"aF c #000000",
"aG c #000000",
"aH c #000000",
"aI c #000000",
"aJ c #000000",
"aK c #000000",
"aL c #000000",
"aM c #000000",
"aN c #000000",
"aO c #000000",
"aP c #000000",
"aQ c #000000",
"aR c #000000",
"aS c #000000",
"aT c #000000",
"aU c #000000",
"aV c #000000",
"aW c #000000",
"aX c #000000",
"aY c #000000",
"aZ c #000000",
"a0 c #000000",
"a1 c #000000",
"a2 c #000000",
"a3 c #000000",
"a4 c #000000",
"a5 c #000000",
"a6 c #000000",
"a7 c #000000",
"a8 c #000000",
/* pixels */
"awawawawawawawawawawawawawawawaw",
"awawawawawawawawawawawawawawawaw",
"awawawawavavavavawawawawawawawaw",
"awawawawavawawavawawawawawawawaw",
"awawawawavawavavavavavawawawawaw",
"awawawawavavawavawawavawawawawaw",
"awavavavavawawavawavavawawawawaw",
"awavawavavawawavavawavawawawawaw",
"awavavawavawavavawawavavavavavaw",
"awavawawavavawavawawavawawawavaw",
"awavawavavawawavawavavawawavavaw",
"awavavawavawawavavawavawavawavaw",
"awavawawavawavavawawavavawawavaw",
"awavawawavavawavawavavawawawavaw",
"awavavavavavavavavavavavavavavaw",
"awawawawawawawawawawawawawawawaw"
};


static char * dropLines_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #CC3737",
"                ",
"  .     +++     ",
"  .     +++     ",
" ..     +++     ",
"  .      .      ",
"  . +++  .      ",
" .. +++  .  +++ ",
"  . +++  .  +++ ",
"  .  .   .  +++ ",
" ..  .   .   .  ",
"  .  .   .   .  ",
"  .  .   .   .  ",
" ..  .   .   .  ",
"  .  .   .   .  ",
"  ..............",
"    .  .  .  .  "};

static char * spline_xpm[] = {
"17 13 2 1",
" 	c None",
".	c #000000",
"                 ",
"           ..    ",
"            ..   ",
"          .   .  ",
"  ..      .   .  ",
"   .     .    .  ",
"  .      ..    . ",
"  .      .    .. ",
"  .     .        ",
"   .    .        ",
"   ..  ..        ",
"     ..          ",
"                 "};

/* XPM */
static char * hor_steps_xpm[] = {
"13 13 2 1",
" 	c None",
".	c #6B0808",
"            .",
"            .",
"            .",
"            .",
"        .....",
"        .    ",
"        .    ",
"        .    ",
"    .....    ",
"    .        ",
"    .        ",
"    .        ",
".....        "};


/* XPM */
static char * vert_steps_xpm[] = {
"13 13 2 1",
" 	c None",
".	c #6B0808",
"        .....",
"        .    ",
"        .    ",
"        .    ",
"    .....    ",
"    .        ",
"    .        ",
"    .        ",
".....        ",
".            ",
".            ",
".            ",
".            "};

static char * cones_xpm[] = {
"19 20 9 1",
" 	c None",
".	c #FFFFFF",
"+	c #EFEBEF",
"@	c #FFF7FF",
"#	c #087249",
"$	c #FFFBFF",
"%	c #EFEFEF",
"&	c #EFE7EF",
"*	c #E7E3E7",
"                   ",
"          ..       ",
"          ...+     ",
"         .@..@.    ",
"        .#####..   ",
"       .$.###%..   ",
"      ..+&.#.*...  ",
"     #####.......  ",
"      ###...#####  ",
"     ..#.....###.  ",
"    ..$......$#..  ",
"    ..+.#####.@..  ",
"  #####..###...... ",
"   ###...+#$.##### ",
"   .#.........###. ",
"   $...........#.. ",
"  #####............",
"  @###.....#####...",
"    #.......###.   ",
"             #     "};

static char * crosses_xpm[] = {
"19 20 11 1",
" 	c None",
".	c #FFFFFF",
"+	c #EFEBEF",
"@	c #FFF7FF",
"#	c #A40A0A",
"$	c #FFFBFF",
"%	c #EFEFEF",
"&	c #EFE7EF",
"*	c #E7E3E7",
"=	c #E7E7E7",
"-	c #F7EFF7",
"                   ",
"          ..       ",
"          ...+     ",
"         .@#.@.    ",
"        ..###+..   ",
"       .$..#.%..   ",
"      .#+&...*...  ",
"      ###=#...#..  ",
"      .#.###.###   ",
"     .....#...#..  ",
"    ..$...#..$...  ",
"    #.+..###..@..  ",
"   ###....#$....#. ",
"   .#..#.+.$#..### ",
"   .-.###..###..#. ",
"   $...#....#..... ",
"  .-#............#.",
"  @###...#...#..###",
"    #...###.###. # ",
"        .#   #.    "};

static char * plot_bars_xpm[] = {
"32 32 99 2",
"  	c None",
". 	c #000000",
"+ 	c #0000FF",
"@ 	c #0000EE",
"# 	c #0000F3",
"$ 	c #0000F9",
"% 	c #0000E9",
"& 	c #0000D4",
"* 	c #0000BF",
"= 	c #0000BD",
"- 	c #0000AE",
"; 	c #00009E",
"> 	c #0000F6",
", 	c #0000DF",
"' 	c #0000FD",
") 	c #0000F7",
"! 	c #0000FB",
"~ 	c #0000F0",
"{ 	c #0000E5",
"] 	c #0000D6",
"^ 	c #00009F",
"/ 	c #000080",
"( 	c #0000E2",
"_ 	c #00FF00",
": 	c #0000F5",
"< 	c #0000DB",
"[ 	c #00EE00",
"} 	c #00F300",
"| 	c #00F900",
"1 	c #00E900",
"2 	c #00D400",
"3 	c #00BF00",
"4 	c #00BD00",
"5 	c #00AE00",
"6 	c #009E00",
"7 	c #0000F1",
"8 	c #0000CD",
"9 	c #0000EF",
"0 	c #0000C6",
"a 	c #00FC00",
"b 	c #00F400",
"c 	c #0000EC",
"d 	c #0000B8",
"e 	c #008000",
"f 	c #00F600",
"g 	c #00DF00",
"h 	c #0000EA",
"i 	c #0000ED",
"j 	c #0000B1",
"k 	c #FF0000",
"l 	c #0000E8",
"m 	c #0000E4",
"n 	c #0000AA",
"o 	c #EE0000",
"p 	c #F30000",
"q 	c #F90000",
"r 	c #E90000",
"s 	c #D40000",
"t 	c #BF0000",
"u 	c #00F000",
"v 	c #00C900",
"w 	c #0000E6",
"x 	c #0000A3",
"y 	c #BD0000",
"z 	c #AE0000",
"A 	c #9E0000",
"B 	c #0000D2",
"C 	c #00009C",
"D 	c #00EB00",
"E 	c #00F100",
"F 	c #00B400",
"G 	c #0000C9",
"H 	c #000095",
"I 	c #00E800",
"J 	c #00E400",
"K 	c #00AA00",
"L 	c #0000E0",
"M 	c #0000C0",
"N 	c #00008E",
"O 	c #00E500",
"P 	c #00D600",
"Q 	c #009F00",
"R 	c #0000DE",
"S 	c #0000B7",
"T 	c #000087",
"U 	c #00E200",
"V 	c #009500",
"W 	c #0000DD",
"X 	c #E80000",
"Y 	c #E40000",
"Z 	c #AA0000",
"` 	c #00BB00",
" .	c #008A00",
"..	c #E20000",
"+.	c #C90000",

"@.	c #950000",
"#.	c #00DD00",
"$.	c #800000",
"%.	c #DD0000",
"                                                                ",
"                                                                ",
"                                                                ",
"                                    . . .                       ",
"                                . . + + + . .                   ",
"                              . @ # $ + % & * .                 ",
"                              . . . = - ; . . .                 ",
"                              . + + . . . + + .                 ",
"                              . > + , . ' + ) .                 ",
"                              . @ + * . ! + ~ .                 ",
"                              . { ] ^ . $ + % .                 ",
"                            . . . - / . ) + ( .                 ",
"                        . . _ _ _ . . . : + < .                 ",
"                      . [ } | _ 1 2 3 . # + & .                 ",
"                      . . . 4 5 6 . . . 7 + 8 .                 ",
"                      . _ _ . . . _ _ . 9 + 0 .                 ",
"                      . [ _ 3 . a _ b . @ + * .                 ",
"                      . [ _ 3 . | _ 1 . c > d .                 ",
"                    . . . 5 e . f _ g . h i j .                 ",
"                . . k k k . . . } _ 2 . l m n .                 ",
"              . o p q k r s t . u _ v . w < x .                 ",
"              . . . y z A . . . [ _ 3 . m B C .                 ",
"              . k k . . . k k . D E F . ( G H .                 ",
"              . q k r . q k r . I J K . L M N .                 ",
"              . p k s . p k s . O P Q . R S T .                 ",
"              . o k t . o k t . U v V . W . .                   ",
"              . X Y Z . o k t . g `  .. .                       ",
"              . ..+.@.. X Y Z . #.. .                           ",
"              . . z $.. ..+.@.. .                               ",
"                  . . . %.. .                                   ",
"                      . .                                       ",
"                                                                "};

static char * bars_xpm[] = {
"16 16 6 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #E51212",
"#	c #0000FF",
"$	c #9E0606",
"                ",
"      ..........",
"     .+.+...+++.",
"    .++.+.@@+++.",
"   .++....@@+++.",
"  .+++.@@.@...+.",
" .++###@@.@.@@+.",
" .++#$$@@.@.@@+.",
" .++#$###.@.@@+.",
" .++#$#$###.@@+.",
" .++#$#$#$$.@@. ",
" .++#$#$#$$.@.  ",
" .++#$#$#$$..   ",
" .+.+$#$#$$.    ",
" ..+++++#$.     ",
" .........      "};

static char * trajectory_xpm[] = {
"15 16 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #BC0303",
"               ",
"     ..........",
"    .+.+++++++.",
"   .+@@++++@@+.",
"  .++@@@@@@@@+.",
" .++++.+++++@+.",
".+@@++.++++@++.",
".+@@++.++@@+++.",
".++@++.++@@+++.",
".++@++.........",
".+@@+.+++++++. ",
".+@@.+++++++.  ",
".++.@@@@@++.   ",
".+.++++@@+.    ",
"..+++++++.     ",
".........      "};

static char * scatter_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #BC0303",
"                ",
"      ..........",
"     .+.+++++++.",
"    .+@@++++@@+.",
"   .++@@++++@@+.",
"  .++++.+++++++.",
" .+@@++.+@@++++.",
" .+@@++.+@@++++.",
" .+++++.+++++++.",
" .+@@++.........",
" .+@@+.+++++++. ",
" .+++.++@@+++.  ",
" .++.+++@@++.   ",
" .+.+++++++.    ",
" ..+++++++.     ",
" .........      "};

static char * ribbon_xpm[] = {
"16 16 6 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #AF032E",
"#	c #0000FF",
"$	c #100493",
"                ",
"      ..........",
"     .+.+++++++.",
"    .++.+++++++.",
"   .+++.++++.++.",
"  .++++.+++.@.+.",
" .+#++..++.@@@..",
" .#$#.@.+.@@@.+.",
" #$$$#@@.@@@.++.",
" .#$$$#@@@@.....",
" .+#$$$#@##+++. ",
" .++#$$$#$$#+.  ",
" .++.#$$$$#+.   ",
" .+.++#$$#+.    ",
" ..++++##+.     ",
" .........      "};

static char * pointer_xpm[] = {
"16 17 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"                ",
"   ..           ",
"   .+.          ",
"   .++.         ",
"   .+++.        ",
"   .++++.       ",
"   .+++++.      ",
"   .++++++.     ",
"   .+++++++.    ",
"   .++++.....   ",
"   .++.+.       ",
"   .+. .+.      ",
"   ..  .+.      ",
"   .    .+.     ",
"         .+.    ",
"         ...    ",
"                "};

static char * arrangeLayers_xpm[] = {
"15 15 2 1",
" 	c None",
".	c #000000",
"..     ..      ",
" .      .      ",
"..     ..      ",
" .      .      ",
"..     ..      ",
" .      .      ",
" .....  .......",
"   . .    .  . ",
"..     ..      ",
" .      .      ",
"..     ..      ",
" .      .      ",
"..     ..      ",
" .....  .......",
"   . .    .  . "};

/* XPM */
static char * newLayer_xpm[] = {
"16 12 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #FF0000",
"    ............",
"    .++++++++++.",
"    .+.++++++++.",
" @  .+..+++++++.",
" @  .+.++++++++.",
"@@@ .+..+++++++.",
" @  .+.++++++++.",
" @  .+..+++++++.",
"    .+.++.+.+++.",
"    .+........+.",
"    .++++++++++.",
"    ............"};

static char * pixelProfile_xpm[] = {
"20 20 56 1",
" 	c None",
".	c #6B696B",
"+	c #6B6D6B",
"@	c #D6D3D6",
"#	c #737173",
"$	c #A5A29C",
"%	c #BDBABD",
"&	c #212021",
"*	c #E7E3E7",
"=	c #B5B2B5",
"-	c #FFFFFF",
";	c #7B797B",
">	c #D6D7D6",
",	c #949694",
"'	c #FFFBFF",
")	c #8C8E8C",
"!	c #848284",
"~	c #A5A2A5",
"{	c #313031",
"]	c #8C8A8C",
"^	c #737573",
"/	c #EFEBEF",
"(	c #ADAEAD",
"_	c #636563",
":	c #9C9A9C",
"<	c #F7F3F7",
"[	c #A5A6A5",
"}	c #BDBEBD",
"|	c #424542",
"1	c #ADAAAD",
"2	c #393839",
"3	c #5A595A",
"4	c #424142",
"5	c #EFEFEF",
"6	c #F7F7F7",
"7	c #525552",
"8	c #181818",
"9	c #636163",
"0	c #B5B6B5",
"a	c #4A4D4A",
"b	c #7B7D7B",
"c	c #DEDFDE",
"d	c #DEDBDE",
"e	c #5A5D5A",
"f	c #949294",
"g	c #E7E7E7",
"h	c #9C9E9C",
"i	c #525152",
"j	c #313431",
"k	c #181C18",
"l	c #101010",
"m	c #212421",
"n	c #292C29",
"o	c #848684",
"p	c #101410",
"q	c #292829",
" . +@# $@#@#@#@#@#@.",
".%&*=-=-=-;>,'=-=-=@",
" &)!-=-='.~{=]-=-=-^",
"+ {/=-=-(,_/+(:<['(@",
"@;~,-=-=}|<1<2 :'(-^",
"3]{/=-~ 4*15:/{ 16=@",
" 7~,'=-3()5:/)/85:<^",
"#>{/[6](9/,*) ;0a0b ",
"@;~]'1@{cb>]d_ #(41e",
"3f{g=g{ ,g. . _ _>_ ",
" |~,<]hb>. 9 e 3}3hi",
"#>{*#h!d; _(&fj!&,a ",
"@;~e1b/] _ &bk~j}a _",
"ehl[^/)>4:m(4}{}n%_ ",
" j:o']fp1i=n {!812 _",
"#@qhpf_ 9 3:j1k%& _ ",
" i]ed!5]@. _[4 e[_ _",
"e,{g(6:5:c_ a~3 _ _ ",
" ; ~-:<:/b _ a _ ^c+",
". +@^ ^ # _ _ _ _ # "};

static char * monalisa_xpm[] = {
"19 19 219 2",
"  	c None",
". 	c #B5AEA5",
"+ 	c #8C8A84",
"@ 	c #636163",
"# 	c #525552",
"$ 	c #424542",
"% 	c #424139",
"& 	c #847973",
"* 	c #7B9AB5",
"= 	c #6B96C6",
"- 	c #6B92C6",
"; 	c #84AEE7",
"> 	c #6B86A5",
", 	c #523831",
"' 	c #CEA673",
") 	c #F7F3CE",
"! 	c #FFF7D6",
"~ 	c #FFF7CE",
"{ 	c #FFFBCE",
"] 	c #F7EBAD",
"^ 	c #E7BE84",
"/ 	c #A56552",
"( 	c #5A4542",
"_ 	c #393439",
": 	c #080408",
"< 	c #292821",
"[ 	c #7BA6D6",
"} 	c #427DBD",
"| 	c #528AC6",
"1 	c #73A2D6",
"2 	c #313439",
"3 	c #311000",
"4 	c #C6965A",
"5 	c #EFDFA5",
"6 	c #EFE3A5",
"7 	c #EFE7AD",
"8 	c #E7E39C",
"9 	c #DECF84",
"0 	c #CE9652",
"a 	c #AD5939",
"b 	c #6B2C21",
"c 	c #311410",
"d 	c #080808",
"e 	c #000000",
"f 	c #4A86C6",
"g 	c #6BA2DE",
"h 	c #6B758C",
"i 	c #100400",
"j 	c #5A2C18",
"k 	c #D6AE6B",
"l 	c #EFDB94",
"m 	c #EFE39C",
"n 	c #EFEBAD",
"o 	c #EFD78C",
"p 	c #DEBA6B",
"q 	c #D6A263",
"r 	c #BD754A",
"s 	c #6B3029",
"t 	c #100808",
"u 	c #8CB2E7",
"v 	c #7BAADE",
"w 	c #84B2DE",
"x 	c #524D52",
"y 	c #734121",
"z 	c #E7BA7B",
"A 	c #E7CB8C",
"B 	c #F7EBA5",
"C 	c #E7C78C",
"D 	c #CE9E63",
"E 	c #DEAE73",
"F 	c #B5714A",
"G 	c #5A2C21",
"H 	c #84AEDE",
"I 	c #73A2DE",
"J 	c #392C29",
"K 	c #080000",
"L 	c #4A2818",
"M 	c #9C5D42",
"N 	c #8C4931",
"O 	c #C69E52",
"P 	c #DEB26B",
"Q 	c #632418",
"R 	c #7B3421",
"S 	c #844531",
"T 	c #4A1C18",
"U 	c #391010",
"V 	c #6396CE",
"W 	c #4271A5",
"X 	c #212021",
"Y 	c #7B4129",
"Z 	c #AD6939",
"` 	c #BD8E5A",
" .	c #631C10",
"..	c #C6925A",
"+.	c #734129",
"@.	c #632818",
"#.	c #A5794A",
"$.	c #8C5139",
"%.	c #180808",
"&.	c #52718C",
"*.	c #183042",
"=.	c #395984",
"-.	c #211C21",
";.	c #946542",
">.	c #DEAA6B",
",.	c #BD824A",
"'.	c #D6B263",
").	c #C69663",
"!.	c #A55931",
"~.	c #CEA263",
"{.	c #D6B673",
"].	c #EFC784",
"^.	c #945139",
"/.	c #100408",
"(.	c #394952",
"_.	c #081821",
":.	c #212429",
"<.	c #211410",
"[.	c #946139",
"}.	c #F7DB8C",
"|.	c #F7E7A5",
"1.	c #EFDF94",
"2.	c #D6AA73",
"3.	c #CE9252",
"4.	c #EFE79C",
"5.	c #F7F3C6",
"6.	c #EFDF9C",
"7.	c #CE8A52",
"8.	c #6B2821",
"9.	c #393C42",
"0.	c #081018",
"a.	c #100C08",
"b.	c #180C08",
"c.	c #6B3821",
"d.	c #EFCF84",
"e.	c #E7D394",
"f.	c #EFDB9C",
"g.	c #DEB684",
"h.	c #C68A5A",
"i.	c #E7CF8C",
"j.	c #A55139",
"k.	c #421C18",
"l.	c #080C10",
"m.	c #080400",
"n.	c #390C08",
"o.	c #C68E5A",
"p.	c #DEB66B",
"q.	c #946952",
"r.	c #7B4529",
"s.	c #DEC384",
"t.	c #B57552",
"u.	c #733029",
"v.	c #39414A",
"w.	c #180400",
"x.	c #943C31",
"y.	c #DE9E63",
"z.	c #D6B27B",
"A.	c #521810",
"B.	c #7B4131",
"C.	c #C68E63",
"D.	c #C68A52",
"E.	c #AD5D42",
"F.	c #394142",
"G.	c #080C08",
"H.	c #8C4131",
"I.	c #CE9663",
"J.	c #732C29",
"K.	c #AD654A",
"L.	c #081418",
"M.	c #101010",
"N.	c #391410",
"O.	c #C68652",
"P.	c #DEB673",
"Q.	c #AD6542",
"R.	c #9C4D39",
"S.	c #B56D4A",
"T.	c #BD7552",
"U.	c #843C31",
"V.	c #211010",
"W.	c #100810",
"X.	c #39454A",
"Y.	c #102029",
"Z.	c #181C29",
"`.	c #4A2010",
" +	c #DEBA7B",
".+	c #F7E79C",
"++	c #D69A6B",
"@+	c #AD5542",
"#+	c #733429",
"$+	c #421818",
"%+	c #311818",
"&+	c #180C10",
"*+	c #394552",
"=+	c #102839",
"-+	c #182839",
";+	c #5A3821",
">+	c #A57552",
",+	c #844D39",
"'+	c #311010",
")+	c #291010",
"!+	c #181010",
"~+	c #425163",
"{+	c #214163",
"]+	c #213C5A",
"^+	c #100C10",
"/+	c #000400",
"(+	c #180000",
"_+	c #291410",
":+	c #211008",
"<+	c #182C42",
"[+	c #101418",
"}+	c #291810",
"|+	c #523021",
"1+	c #210C08",
"2+	c #422018",
"3+	c #4A2418",
"4+	c #181008",
"5+	c #212018",
"6+	c #635D52",
". + @ # # # # # # # # # # # # # $ % & ",
"+ * = - ; > , ' ) ! ~ { ] ^ / ( _ : < ",
"@ [ } | 1 2 3 4 5 6 7 8 9 0 a b c d e ",
"# 1 f g h i j k l m m n o p q r s t e ",
"# u v w x e y z A m B C D E q F G : e ",
"# H I = J K L M N O P Q R S T U T t e ",
"# H V W X i c Y b Z `  ...+.@.#.$.%.e ",
"# &.*.=.-.e ;.>.,.'.).!.p ~.{.].^./.e ",
"# (._.:.<.e [.}.|.1.2.3.4.5.6.7.8.d e ",
"# 9.0.a.b.e c.d.e.f.g.h.i.5 z j.k.d e ",
"# 9.l.m.i K n.o.p.2.q.r.e.s.t.u.c t e ",
"# v.l.d m.m.w.x.y.z.A.B.C.D.E.u.c t e ",
"# F.l.G.: /.K H.F I.E.J.^.I.K.b c t e ",
"# v.L.M.t /.e N.O.P.Q.R.S.T.U.T V.W.e ",
"# X.Y.Z.t m./.e `. +.+++@+#+$+%+&+t e ",
"# *+=+-+t i i m.e ;+>+,+T '+)+V.!+t e ",
"$ ~+{+]+^+i : m./+e K (+t b.b._+%+:+e ",
"% <+*.<+[+K i m.e e }+|+_+1+_+2+3+4+5+",
"& < e e e e e e e e e e e e e e e 5+6+"};

static char * lineMesh_xpm[] = {
"20 18 130 2",
"  	c None",
". 	c #4245E7",
"+ 	c #29286B",
"@ 	c #212021",
"# 	c #181C29",
"$ 	c #4241E7",
"% 	c #4A499C",
"& 	c #181418",
"* 	c #181818",
"= 	c #5A595A",
"- 	c #B5AEB5",
"; 	c #4241C6",
"> 	c #8482FF",
", 	c #9C9E9C",
"' 	c #6B696B",
") 	c #FFFBFF",
"! 	c #9C969C",
"~ 	c #5251AD",
"{ 	c #6B69FF",
"] 	c #EFEFFF",
"^ 	c #393C39",
"/ 	c #211C21",
"( 	c #101410",
"_ 	c #D6CFD6",
": 	c #F7F7F7",
"< 	c #4A454A",
"[ 	c #7375B5",
"} 	c #5A59FF",
"| 	c #E7E7FF",
"1 	c #A59EA5",
"2 	c #080C08",
"3 	c #42417B",
"4 	c #4A4994",
"5 	c #6B6973",
"6 	c #ADA6CE",
"7 	c #5251FF",
"8 	c #C6BEE7",
"9 	c #312C31",
"0 	c #181C18",
"a 	c #181821",
"b 	c #6B69EF",
"c 	c #6B65DE",
"d 	c #313031",
"e 	c #212429",
"f 	c #393CAD",
"g 	c #31306B",
"h 	c #292C29",
"i 	c #212421",
"j 	c #6B697B",
"k 	c #635DFF",
"l 	c #BDBAFF",
"m 	c #5A5D5A",
"n 	c #52515A",
"o 	c #292C63",
"p 	c #A5A2EF",
"q 	c #EFE7EF",
"r 	c #A5A2A5",
"s 	c #101010",
"t 	c #ADAAE7",
"u 	c #5255FF",
"v 	c #D6D3EF",
"w 	c #636163",
"x 	c #393863",
"y 	c #9C9AFF",
"z 	c #FFFFFF",
"A 	c #D6D7D6",
"B 	c #525152",
"C 	c #8C8AFF",
"D 	c #B5B2B5",
"E 	c #636563",
"F 	c #5A598C",
"G 	c #847DFF",
"H 	c #292429",
"I 	c #525163",
"J 	c #524DF7",
"K 	c #8482D6",
"L 	c #737173",
"M 	c #313431",
"N 	c #EFEFEF",
"O 	c #7B79A5",
"P 	c #5A5DFF",
"Q 	c #F7EFFF",
"R 	c #EFEBEF",
"S 	c #393839",
"T 	c #393439",
"U 	c #C6BEEF",
"V 	c #424142",
"W 	c #423C42",
"X 	c #4A4D63",
"Y 	c #5A55F7",
"Z 	c #5A5D73",
"` 	c #949294",
" .	c #7B79FF",
"..	c #ADAAB5",
"+.	c #737573",
"@.	c #4A494A",
"#.	c #5A59F7",
"$.	c #9C96CE",
"%.	c #847D84",
"&.	c #DEDFEF",
"*.	c #C6BEFF",
"=.	c #6B656B",
"-.	c #FFF7FF",
";.	c #F7F3F7",
">.	c #BDBEBD",
",.	c #8C86FF",
"'.	c #DEDBDE",
").	c #848684",
"!.	c #C6C3FF",
"~.	c #7375FF",
"{.	c #E7DFEF",
"].	c #8C8E8C",
"^.	c #E7E3E7",
"/.	c #D6D3D6",
"(.	c #B5B6FF",
"_.	c #4A4552",
":.	c #5A59EF",
"<.	c #A5A6EF",
"[.	c #E7E3FF",
"}.	c #E7DFFF",
"|.	c #949694",
"1.	c #5A5D9C",
"2.	c #292C31",
"3.	c #9C9A9C",
"4.	c #292829",
"5.	c #73717B",
"6.	c #5251E7",
"7.	c #5A59AD",
"8.	c #312C52",
"9.	c #292C4A",
"                      . +               ",
"                  @ # $ % & *           ",
"                * = - ; > , &           ",
"              & ' ) ! ~ { ] ^ /         ",
"              ( _ : < [ } | 1 2         ",
"            ( 3 4 5 * 6 7 8 - 9 0       ",
"            a b c d & e f g h i i       ",
"          & j k l = m n o p q r s       ",
"          ( t u v i 1 w x y z A (       ",
"        ( B C > D * _ E F G z : H       ",
"        s I J K L M N w O P Q R S @     ",
"      * T U 7 x 0 @ V W X Y Z d @ &     ",
"      2 ` l  ...s +.1 @.5 #.$., %.2     ",
"      H &. .*.=.^ -.;.W >.,.y z '.*     ",
"    s ).!.~.{.i ].z ^.i /.(.~.) : d @   ",
"  s @ _.:.<.r * _ z _ @ '.[.P }.z |.2   ",
"& ( ` ..1.2.@ i ' 3.L 4.! 5.6.7.@.4.@ d ",
"^           w S h 9 4.H @ @ 8.9.@     s "};

static char * rightGrid_xpm[] = {
"20 19 25 1",
" 	c None",
".	c #C60000",
"+	c #21109C",
"@	c #0810B5",
"#	c #0814B5",
"$	c #B50010",
"%	c #C60818",
"&	c #1018BD",
"*	c #0010B5",
"=	c #A50018",
"-	c #BD0C18",
";	c #BD0000",
">	c #A50829",
",	c #940839",
"'	c #BD0410",
")	c #9C0429",
"!	c #9C0021",
"~	c #BD0008",
"{	c #AD0421",
"]	c #BD0C21",
"^	c #A5245A",
"/	c #636DFF",
"(	c #BD1021",
"_	c #B50008",
":	c #8C0439",
"    ..+ @ @ @ @ @ # ",
"    $%             &",
"   ...           *  ",
"  =. -             @",
" .. $;         *    ",
".>.,.' @ @ @ @     @",
")!.; .        @     ",
".'.  -             @",
"~;. ..        @     ",
".{...%             @",
"$ .. .        @     ",
".'.  ]             @",
"~;.  .        @     ",
".{. .^ / / / / / / @",
"$ ...         @     ",
". .(             @  ",
"$_.           @     ",
".(             @    ",
": @ @ @ @ @ @ @     "};

static char * leftGrid_xpm[] = {
"20 19 25 1",
" 	c None",
".	c #0810B5",
"+	c #840842",
"@	c #C60000",
"#	c #0010B5",
"$	c #636DFF",
"%	c #BD0410",
"&	c #B50008",
"*	c #9C0C31",
"=	c #B50410",
"-	c #A50018",
";	c #940C39",
">	c #BD0000",
",	c #BD0010",
"'	c #101CBD",
")	c #29109C",
"!	c #8C104A",
"~	c #B50010",
"{	c #AD0421",
"]	c #BD0008",
"^	c #7B55CE",
"/	c #8C45A5",
"(	c #BD0C21",
"_	c #8C0839",
":	c #8C0439",
"      . . . . . . +@",
"    #$           @@%",
"                @&*@",
"  #  $         @@@ =",
"              @-;>,@",
" ' . . . . . )@! @>%",
".             ~ @@{@",
"     $        @=@@ =",
".             ]> @,@",
"     $        @  @>%",
".             ~ @@{@",
"     $        @=@@ =",
".             ]> @ @",
"     $ $ $ $ ^@/ (@_",
".             ~  @@ ",
"   $          @ @=  ",
".             ~@@   ",
" $            @=    ",
". . . . . . . :     "};

static char * backGrid_xpm[] = {
"20 19 31 1",
" 	c None",
".	c #C60000",
"+	c #9C0421",
"@	c #A50421",
"#	c #B50010",
"$	c #290C94",
"%	c #BD0C21",
"&	c #B50410",
"*	c #0010B5",
"=	c #BD0C18",
"-	c #BD0000",
";	c #BD0008",
">	c #B50008",
",	c #BD0410",
"'	c #101CBD",
")	c #0810B5",
"!	c #1010AD",
"~	c #390C84",
"{	c #C60408",
"]	c #C60008",
"^	c #4A0C73",
"/	c #C60810",
"(	c #BD0408",
"_	c #310C8C",
":	c #A5245A",
"<	c #AD1842",
"[	c #B51839",
"}	c #B51842",
"|	c #B51029",
"1	c #8C0842",
"2	c #636DFF",
"     .+.@.#.@.@.@.@.",
"    $%    .    .   &",
"     .    .    . * .",
"  *  =    .    .   &",
"     -;>;-.;;>.-,-;.",
" ' ) , ! ~.~ ! {   &",
")    .    .   $-   .",
"     %    .    ]   &",
")    .    .   ^-   .",
"     /.......,....;(",
")    .    .   _-   .",
"     %    .    ]   &",
")    .    .   ^-   .",
"     :.<.[.[.}.|.}.1",
")             !     ",
"   2             )  ",
")             )     ",
" 2             )    ",
") ) ) ) ) ) ) )     "};

static char * ceilGrid_xpm[] = {
"20 19 24 1",
" 	c None",
".	c #C60000",
"+	c #9C0429",
"@	c #B50010",
"#	c #A50421",
"$	c #B50410",
"%	c #AD0010",
"&	c #8C419C",
"*	c #BD0008",
"=	c #BD0408",
"-	c #BD0410",
";	c #421084",
">	c #B50008",
",	c #A50018",
"'	c #B51839",
")	c #0810B5",
"!	c #BD0010",
"~	c #BD0000",
"{	c #AD0421",
"]	c #B50418",
"^	c #A50429",
"/	c #0810AD",
"(	c #1010AD",
"_	c #636DFF",
"    ..+.@.#.@.#.#.$.",
"   .%&..*  =.-   ..;",
"  ...............>  ",
" .,  '.   ..   ..  )",
"..  !~   >*   .,    ",
".{.#.{.#.].#.^.    )",
"/             (     ",
"     _             )",
")             )     ",
"     _             )",
")             )     ",
"     _             )",
")             )     ",
"     _ _ _ _ _ _ _ )",
")             )     ",
"   _             )  ",
")             )     ",
" _             )    ",
") ) ) ) ) ) ) )     "};

static char * floorGrid_xpm[] = {
"20 19 30 1",
" 	c None",
".	c #0810B5",
"+	c #0814B5",
"@	c #0010B5",
"#	c #636DFF",
"$	c #1018BD",
"%	c #101CBD",
"&	c #310C8C",
"*	c #C60000",
"=	c #AD1C4A",
"-	c #B51839",
";	c #BD0C21",
">	c #AD1842",
",	c #940431",
"'	c #BD0000",
")	c #6B085A",
"!	c #BD0818",
"~	c #C60008",
"{	c #BD0410",
"]	c #1010AD",
"^	c #AD0010",
"/	c #1810A5",
"(	c #BD1021",
"_	c #9C0429",
":	c #B50010",
"<	c #B50008",
"[	c #BD0408",
"}	c #B50418",
"|	c #A50421",
"1	c #B50410",
"      . . . . . . + ",
"    @#             $",
"                 @  ",
"  @  #             .",
"               @    ",
" % . . . . . .     .",
".             .     ",
"     #             .",
".             .     ",
"     #             .",
".             .     ",
"     #             .",
".             &     ",
"    *=*-*;*>*;*-*-*,",
".  **  **   *')  ** ",
"  *!*********~***{  ",
"]^*  **    ** /**   ",
"*(_ :~_   <[  *}    ",
",*|*1*|*|*1*|*,     "};


static char * pointsMesh_xpm[] = {
"19 20 14 1",
" 	c None",
".	c #1800FF",
"+	c #1804FF",
"@	c #FFFFFF",
"#	c #EFEBEF",
"$	c #FFF7FF",
"%	c #F7F3F7",
"&	c #2104FF",
"*	c #FFFBFF",
"=	c #EFEFEF",
"-	c #EFE7EF",
";	c #E7E3E7",
">	c #E7E7E7",
",	c #F7EFF7",
"            .+     ",
"          @@..     ",
"          @@@#     ",
"         @$..$@    ",
"        @@%&.#@@   ",
"       @*@@@@=@@   ",
"      .+#-@@@;@@@  ",
"      ..@>..@@..@  ",
"      @@@@.&@@.&   ",
"     @@@@@@@@@@@@  ",
"    @@*@@&.@@*@@@  ",
"     @#@@..@@@$@@  ",
"   &.$@,@@@*@@@@.+ ",
"   ..@@..#@*..@@.. ",
"   @,@@+.@@@.&@@@@ ",
"   *@@@@@@@@@@@@@@ ",
"  @,@@@@@@@@@@@@@+.",
"..$@..@@@=@@@@@@@..",
".&  .&@@.&@@ &.@   ",
"        ..   ..    "};


static char * frontGrid_xpm[] = {
"20 19 22 1",
" 	c None",
".	c #0810B5",
"+	c #0814B5",
"@	c #0010B5",
"#	c #636DFF",
"$	c #1018BD",
"%	c #C60000",
"&	c #A50829",
"*	c #A50421",
"=	c #B50010",
"-	c #7359D6",
";	c #BD0408",
">	c #B51431",
",	c #8449B5",
"'	c #8449AD",
")	c #BD0008",
"!	c #7B55CE",
"~	c #BD0000",
"{	c #7B084A",
"]	c #310C8C",
"^	c #8C0439",
"/	c #AD0418",
"      . . . . . . + ",
"    @#             $",
"                 @  ",
"  @  #             .",
"               @    ",
"%&%*%*%*%*%*%*%    .",
"=   %     %   =     ",
"%   %-    %   %    .",
"=   %     %   =     ",
"%;%%%>%%%%%%%;%    .",
"=   %     %   =     ",
"%   %-    %   %    .",
"=   %     %   =     ",
"%   %, - ,%' ,%- # .",
"))%%%%%%%%%%%))     ",
"%  !%     %   %  .  ",
"=   %     %   =     ",
"%,  ~     %  {%]    ",
"^%*%/%*%*%/%*%^     "};


static char * no_floor_xpm[] = {
"20 10 2 1",
" 	c None",
".	c #000000",
"    ................",
"    .              .",
"   .               .",
"   .              . ",
"  .               . ",
"  .              .  ",
" .               .  ",
" .              .   ",
".               .   ",
"................    "};

static char * isolines_xpm[] = {
"20 10 9 1",
" 	c None",
".	c #000000",
"+	c #DE0810",
"@	c #DE0808",
"#	c #DE0C10",
"$	c #E70C10",
"%	c #0010DE",
"&	c #0010E7",
"*	c #0014E7",
"    ................",
"    .    +    @    .",
"   .  #+$     #    .",
"   .@+    %&   +@ . ",
"  .     *%  *    +. ",
"  .    &    %    .  ",
" . +$  %  *% +#+$.  ",
" .   +  %&  @   .   ",
".    +     +    .   ",
"................    "};

static char * floor_xpm[] = {
"20 10 22 1",
" 	c None",
".	c #000000",
"+	c #314D63",
"@	c #314D5A",
"#	c #395963",
"$	c #39555A",
"%	c #39595A",
"&	c #31555A",
"*	c #395D52",
"=	c #396152",
"-	c #42694A",
";	c #426952",
">	c #4A714A",
",	c #427142",
"'	c #42714A",
")	c #4A7D42",
"!	c #4A7942",
"~	c #4A8231",
"{	c #528639",
"]	c #4A8239",
"^	c #528E31",
"/	c #5A8E31",
"    ................",
"    .+++@+++@+++@++.",
"   .#$%&#$%&#$%&#$%.",
"   .*=*=*=*=*=*=*=. ",
"  .-;-;-;-;-;-;-;-. ",
"  .>,',>,',>,',>,.  ",
" .)!)!)!)!)!)!)!).  ",
" .~{]{~{]{~{]{~{.   ",
".^/^/^/^/^/^/^/^.   ",
"................    "};

static char * grid_poly_xpm[] = {
"20 18 86 1",
" 	c None",
".	c #101010",
"+	c #312021",
"@	c #181818",
"#	c #312829",
"$	c #181418",
"%	c #311418",
"&	c #FFCF21",
"*	c #211410",
"=	c #211418",
"-	c #FFBE29",
";	c #FFC329",
">	c #393031",
",	c #211C21",
"'	c #181410",
")	c #FFAE31",
"!	c #636163",
"~	c #291C21",
"{	c #100C08",
"]	c #101410",
"^	c #423839",
"/	c #4A3C39",
"(	c #FF9E39",
"_	c #BD7173",
":	c #BD7573",
"<	c #312C31",
"[	c #181C18",
"}	c #211818",
"|	c #FF8A39",
"1	c #FF8E42",
"2	c #732021",
"3	c #292829",
"4	c #392829",
"5	c #292421",
"6	c #212421",
"7	c #7B595A",
"8	c #FF7D42",
"9	c #FF7939",
"0	c #8C3C39",
"a	c #FF6931",
"b	c #FF6531",
"c	c #524D52",
"d	c #525152",
"e	c #FF5529",
"f	c #291418",
"g	c #5A494A",
"h	c #6B1C18",
"i	c #5A4D4A",
"j	c #FF4121",
"k	c #737173",
"l	c #313031",
"m	c #FF4521",
"n	c #292429",
"o	c #732C29",
"p	c #212021",
"q	c #4A3031",
"r	c #FF3018",
"s	c #393439",
"t	c #5A3439",
"u	c #AD2829",
"v	c #843031",
"w	c #5A4D52",
"x	c #180C08",
"y	c #FF1C10",
"z	c #FF1808",
"A	c #181010",
"B	c #312421",
"C	c #080C08",
"D	c #FF0400",
"E	c #FF0808",
"F	c #6B656B",
"G	c #635D63",
"H	c #211010",
"I	c #F70000",
"J	c #523C42",
"K	c #E70000",
"L	c #291818",
"M	c #949294",
"N	c #ADAEAD",
"O	c #5A595A",
"P	c #D60000",
"Q	c #CE0000",
"R	c #393C39",
"S	c #4A494A",
"T	c #393839",
"U	c #292C29",
"           ..       ",
"         +@.#$@     ",
"        %&&*&&$     ",
"       =-;->-;-,    ",
"       ')))!~)){    ",
"      ]^/(@(@_:<[   ",
"      }|12*3.,456   ",
"     $7890983898.   ",
"     'aba+abcbab'   ",
"    ]deeefeeegeeh   ",
"    .idjklmjmnmjop  ",
"   @qrrs[~tuv,wlp$  ",
"   xyzyzAzyzyByzyC  ",
"   BDEDF^EDEDGDED@  ",
"  HIIII6IIIIIIJII2p ",
" .pKKKKLKKKKKK5KKK{ ",
"$]MNO3p6PQQQPQpRS3pl",
"R     !TU<UUpp6pp  ."};

static char * grid_only_xpm[] = {
"20 18 69 1",
" 	c None",
".	c #101010",
"+	c #212021",
"@	c #181818",
"#	c #292C29",
"$	c #181418",
"%	c #5A595A",
"&	c #B5AEB5",
"*	c #9C9E9C",
"=	c #6B696B",
"-	c #FFFBFF",
";	c #9C969C",
">	c #313031",
",	c #393839",
"'	c #EFEBEF",
")	c #393C39",
"!	c #211C21",
"~	c #101410",
"{	c #D6CFD6",
"]	c #F7F7F7",
"^	c #4A454A",
"/	c #636163",
"(	c #DEDFDE",
"_	c #A59EA5",
":	c #080C08",
"<	c #424142",
"[	c #736D73",
"}	c #9C9A9C",
"|	c #B5B2B5",
"1	c #312C31",
"2	c #181C18",
"3	c #BDBEBD",
"4	c #949294",
"5	c #292829",
"6	c #212421",
"7	c #FFFFFF",
"8	c #5A5D5A",
"9	c #8C8A8C",
"0	c #EFE7EF",
"a	c #A5A2A5",
"b	c #DED7DE",
"c	c #524D52",
"d	c #7B797B",
"e	c #D6D7D6",
"f	c #525152",
"g	c #FFF7FF",
"h	c #6B6D6B",
"i	c #292429",
"j	c #ADAAAD",
"k	c #737173",
"l	c #313431",
"m	c #EFEFEF",
"n	c #393439",
"o	c #DEDBDE",
"p	c #948E94",
"q	c #6B656B",
"r	c #4A4D4A",
"s	c #525552",
"t	c #ADAEAD",
"u	c #737573",
"v	c #949694",
"w	c #847D84",
"x	c #E7E7E7",
"y	c #635D63",
"z	c #848684",
"A	c #8C8E8C",
"B	c #424542",
"C	c #D6D3D6",
"D	c #4A494A",
"           ..       ",
"         +@.#$@     ",
"        @%&@%*$     ",
"       $=-;>,')!    ",
"       ~{]^/+(_:    ",
"      ~)<[@}@|&12   ",
"      @34>$5.!#66   ",
"     $[77%8 590a.   ",
"     ~b7'6_-cd7e~   ",
"    ~fg7|@{7hf7]i   ",
"    .ffjklm7_5'',+  ",
"   @nopn2+<qr!s>+$  ",
"   :477t.ua*v69*w:  ",
"   ix77q)g777yd7o@  ",
"  .z77'6A7777*B]]>+ ",
" .+^9Ca@{7777b6C7v: ",
"$~4t%5+6=}a*_h+)D5+>",
")     /,#1##++6++  ."};

static char * no_grid_xpm[] = {
"20 18 54 1",
" 	c None",
".	c #181818",
"+	c #212021",
"@	c #181C18",
"#	c #4A494A",
"$	c #525152",
"%	c #181418",
"&	c #5A595A",
"*	c #FFCF21",
"=	c #6B696B",
"-	c #FFC329",
";	c #FFBE29",
">	c #FFC331",
",	c #393C39",
"'	c #211C21",
")	c #FFAE31",
"!	c #080C08",
"~	c #101410",
"{	c #737173",
"]	c #FF9E39",
"^	c #FF8A39",
"/	c #FF8E42",
"(	c #636163",
"_	c #736D73",
":	c #FF7D42",
"<	c #FF7939",
"[	c #101010",
"}	c #FF6931",
"|	c #FF6531",
"1	c #FF5529",
"2	c #FF5531",
"3	c #292429",
"4	c #FF4121",
"5	c #FF4521",
"6	c #393839",
"7	c #292829",
"8	c #393439",
"9	c #FF3018",
"0	c #FF1C10",
"a	c #FF1808",
"b	c #FF0400",
"c	c #FF0808",
"d	c #F70000",
"e	c #313031",
"f	c #E70000",
"g	c #949294",
"h	c #ADAEAD",
"i	c #CE0000",
"j	c #D60000",
"k	c #737573",
"l	c #5A5D5A",
"m	c #8C8A8C",
"n	c #292C29",
"o	c #312C31",
"           ..       ",
"         +@#$%.     ",
"        .&****%     ",
"       %=-;>;-,'    ",
"       %)))))))!    ",
"      ~{]]]]]]]+    ",
"      .^/^/^/^/(%   ",
"     %_:<:<:<:<:[   ",
"     ~}|}|}|}|}|~   ",
"    ~&11121112113   ",
"    [4545454545467  ",
"   .899999999999=+  ",
"   !0a0a0a0a0a0a0!  ",
"   3bcbcbcbcbcbcb.  ",
"  [dddddddddddddde+ ",
" [+fffffffffffffff! ",
"%~gh&7#(_iiijk(l#7+e",
",     m#nonn+++++  ["};

static char * no_axes_xpm[] = {
"20 19 6 1",
" 	c None",
".	c #0810B5",
"+	c #0814B5",
"@	c #0010B5",
"#	c #1018BD",
"$	c #101CBD",
"      . . . . . . + ",
"    @              #",
"                 @  ",
"  @                .",
"               @    ",
" $ . . . . . .     .",
".             .     ",
"                   .",
".             .     ",
"                   .",
".             .     ",
"                   .",
".             .     ",
"                   .",
".             .     ",
"                 .  ",
".             .     ",
"               .    ",
". . . . . . . .     "};

static char * box_xpm[] = {
"20 19 7 1",
" 	c None",
".	c #101CB5",
"+	c #0810B5",
"@	c #0010B5",
"#	c #0814B5",
"$	c #1018BD",
"%	c #101CBD",
"     .+@+@+@+@+@+@#.",
"    @             @$",
"   @             @ @",
"  @             @  +",
" @             @   @",
"@%@+@+@+@+@+@+@    +",
"+             +    @",
"@             @    +",
"+             +    @",

"@             @    +",
"+             +    @",
"@             @    +",
"+             +    @",
"@             @    +",
"+             +   + ",
"@             @  +  ",
"+             + +   ",
"@             @+    ",
"+@+@+@+@+@+@+@+     "};

static char * free_axes_xpm[] = {
"17 18 3 1",
" 	c None",
".	c #0810B5",
"+	c #0010B5",
".                ",
"+                ",
".                ",
"+                ",
".                ",
"+                ",
".                ",
"+                ",
".                ",
"+                ",
".                ",
"+               +",
".              + ",
" .+           +  ",
"   +.        +   ",
"     .+     +    ",
"       +.  +     ",
"         .+      "};

static char * newFxy_xpm[] = {
"14 16 75 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #A0A7AF",
"#	c #FB0000",
"$	c #F90000",
"%	c #E60000",
"&	c #EE0000",
"*	c #ED0000",
"=	c #E00000",
"-	c #D80000",
";	c #DE0000",
">	c #D60000",
",	c #C90000",
"'	c #CD0000",
")	c #C70000",
"!	c #AD0000",
"~	c #B80000",
"{	c #BC0000",
"]	c #BB0000",
"^	c #B60000",
"/	c #A80000",
"(	c #9D0000",
"_	c #A70000",
":	c #AA0000",
"<	c #A90000",
"[	c #A50000",
"}	c #9A0000",
"|	c #8D0000",
"1	c #940000",
"2	c #980000",
"3	c #970000",
"4	c #930000",
"5	c #890000",
"6	c #6C0000",
"7	c #7C0000",
"8	c #830000",
"9	c #850000",
"0	c #820000",
"a	c #790000",
"b	c #640000",
"c	c #5D0000",
"d	c #6A0000",
"e	c #700000",
"f	c #730000",
"g	c #6F0000",
"h	c #670000",
"i	c #570000",
"j	c #010000",
"k	c #4C0000",
"l	c #590000",
"m	c #600000",
"n	c #5C0000",
"o	c #550000",
"p	c #470000",
"q	c #0C0000",
"r	c #3A0000",
"s	c #460000",
"t	c #4B0000",
"u	c #4D0000",
"v	c #490000",
"w	c #430000",
"x	c #370000",
"y	c #140000",
"z	c #290000",
"A	c #330000",
"B	c #380000",
"C	c #3B0000",
"D	c #300000",
"E	c #250000",
"F	c #0A0000",
"G	c #060000",
"H	c #0D0000",
"I	c #110000",
"J	c #030000",
"..........    ",
".++++++++..   ",
".++++++++.@.  ",
".++++#$++.@@. ",
".+++%&*=+.....",
".+++-;;>+++++.",
".+++,'')+++++.",
".++!~{]^/++++.",
".++(_:<[}++++.",
".++|12345++++.",
".+678990ab+++.",
".+cdeffghi+++.",
"j+klcmmnop+++.",
"jqrstuuvwxj++.",
"jyzABrCxDEFjj.",
".jGHIyyIqyJj.."};

/* XPM */
static char * newF_xpm[] = {
"14 16 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #A0A7AF",
"..........    ",
".++++++++..   ",
".++++++++.@.  ",
".+++...++.@@. ",
".++..+..+.....",
".++..++++++++.",
".++..++++++++.",
".+.....++++++.",
".++..++..+..+.",
".++..++..+..+.",
".++..+++...++.",
".++..++..+..+.",
".+....+..+..+.",
".++++++++++++.",
".++++++++++++.",
".............."};

/* XPM */
static char * newFolder_xpm[] = {
"15 16 5 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #A0A7AF",
"#	c #FFFF00",
"..........     ",
".++++++++..    ",
".++++++++.@.   ",
".++++++++.@@.  ",
".++++++++..... ",
".++....++++++. ",
".+.#+#+.+++++. ",
".+.............",
".+.#+#+#+#+#+#.",
".+.+#+#+#+#+#+.",
".+.#+#+#+#+#+#.",
".+.+#+#+#+#+#+.",
".+.#+#+#+#+#+#.",
".+.+#+#+#+#+#+.",
".+.#+#+#+#+#+#.",
"..............."};

static char * stat_rows_xpm[] = {
"16 15 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"    .......     ",
"    .    ..     ",
"     .    .     ",
"      ..        ",
"      ..        ",
"      ..        ",
"     .          ",
"    .     .     ",
"    .    ..     ",
"    .......     ",
"                ",
"................",
".  .++.++.++.++.",
".  .++.++.++.++.",
"................"};

/* XPM */
static char * fx_xpm[] = {
"14 16 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #FF0000",
"..............",
".++++++++++++.",
".+++++++++@++.",
".+++...++@@@+.",
".++..+..++@++.",
".++..++++++++.",
".++..++++++++.",
".+.....++++++.",
".++..++..+..+.",
".++..++..+..+.",
".++..+++...++.",
".++..++..+..+.",
".+....+..+..+.",
".++++++++++++.",
".++++++++++++.",
".............."};

static char * redo_xpm[] = {
"14 18 36 1",
" 	c None",
".	c #000000",
"+	c #949A8C",
"@	c #BDD39C",
"#	c #848E73",
"$	c #ADBEA5",
"%	c #C6D7AD",
"&	c #D6DFBD",
"*	c #BDD3A5",
"=	c #9CA28C",
"-	c #D6E3C6",
";	c #CEDFBD",
">	c #D6E3BD",
",	c #8C9A7B",
"'	c #9CAA84",
")	c #B5C3AD",
"!	c #94AE63",
"~	c #7B9A42",
"{	c #5A7129",
"]	c #7B8E6B",
"^	c #CEDBB5",
"/	c #84A24A",
"(	c #526929",
"_	c #A5B694",
":	c #9CB673",
"<	c #6B8A39",
"[	c #94A67B",
"}	c #8CAA5A",
"|	c #637152",
"1	c #9CAE73",
"2	c #ADC394",
"3	c #6B795A",
"4	c #9CAE84",
"5	c #738263",
"6	c #849673",
"7	c #5A554A",
"       .      ",
"       ..     ",
"       .+.    ",
"    ....@+.   ",
"   .#$%&*@=.  ",
"  .$-;>%@@@+. ",
" .,--&*@@@@@'.",
" .)-!~~~~~~{. ",
".]^/~~~~~~(.  ",
"._:~{...~(.   ",
".@~<.  .{.    ",
".@~.   ..     ",
".[}.   .      ",
".|1.          ",
" .2.          ",
" .34.         ",
"  .56.        ",
"   ..7        "};

static char * undo_xpm[] = {
"16 18 34 1",
" 	c None",
".	c #000000",
"+	c #EFE7BD",
"@	c #EFE7C6",
"#	c #EFD784",
"$	c #5A5952",
"%	c #EFE7B5",
"&	c #D6B65A",
"*	c #B59642",
"=	c #D6B252",
"-	c #C6AE73",
";	c #C6A24A",
">	c #9C6900",
",	c #D69608",
"'	c #E7B64A",
")	c #DEC373",
"!	c #8C6500",
"~	c #D69E18",
"{	c #B59239",
"]	c #DEB64A",
"^	c #CEB66B",
"/	c #BD8208",
"(	c #DEA629",
"_	c #D6A629",
":	c #C6B26B",
"<	c #A59252",
"[	c #52514A",
"}	c #8C867B",
"|	c #E7CB7B",
"1	c #948E84",
"2	c #8C7D4A",
"3	c #AD9E5A",
"4	c #94864A",
"5	c #8C8A7B",
"       .        ",
"      ..        ",
"     .+.        ",
"    .@#...$     ",
"   .%####&*.    ",
"  .+#######=.   ",
" .-#########;.  ",
"  .>,,,,,,'#).  ",
"   .!,,,,,,~#{. ",
"    .!,...>,]^. ",
"     .>.  ./(#. ",
"      ..   .,#. ",
"       .   ._:. ",
"           .=<[ ",
"          }.|.1 ",
"          .^2.  ",
"         .34.   ",
"         5..    "};



static char * col_stat_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"                ",
"          ......",
"          .    .",
" .......  .    .",
" .    ..  ......",
"  .    .  .++++.",
"   ..     ......",
"   ..     .++++.",
"   ..     ......",
"  .       .++++.",
" .     .  ......",
" .    ..  .++++.",
" .......  ......",
"          .++++.",
"          ......",
"                "};

static char * wizard_xpm[] = {
"32 32 91 1",
" 	c None",
".	c #FF6500",
"+	c #FF8E00",
"@	c #FFFF00",
"#	c #FFA600",
"$	c #FFC300",
"%	c #FF9A00",
"&	c #FFB200",
"*	c #FFB600",
"=	c #FFA200",
"-	c #FF9E00",
";	c #FFBA00",
">	c #FFE700",
",	c #FFE310",
"'	c #FFFF31",
")	c #FFD739",
"!	c #FFFFE7",
"~	c #FF8600",
"{	c #FFCB00",
"]	c #FFD700",
"^	c #FFE752",
"/	c #FFF7B5",
"(	c #FFFFDE",
"_	c #FFEF00",
":	c #FFF7A5",
"<	c #FFFFD6",
"[	c #FFDB00",
"}	c #FFE300",
"|	c #FFF700",
"1	c #FFF77B",
"2	c #FFFBB5",
"3	c #FFF784",
"4	c #FF8200",
"5	c #FFDF00",
"6	c #FFCF00",
"7	c #FFE773",
"8	c #B52800",
"9	c #BD3C00",
"0	c #FFAA00",
"a	c #FFE718",
"b	c #FFE363",
"c	c #B52400",
"d	c #D65900",
"e	c #FFD300",
"f	c #FFDF18",
"g	c #FFFF73",
"h	c #A51800",
"i	c #D65100",
"j	c #FF9600",
"k	c #FFAE00",
"l	c #840000",
"m	c #E74D00",
"n	c #FF1800",
"o	c #FF3400",
"p	c #940000",
"q	c #B50000",
"r	c #F71400",
"s	c #FF5100",
"t	c #FF7100",
"u	c #E70800",
"v	c #E73000",
"w	c #FF8A00",
"x	c #9C0000",
"y	c #E70000",
"z	c #FF0000",
"A	c #FF1C00",
"B	c #FF2400",
"C	c #C62400",
"D	c #F70000",
"E	c #312CB5",
"F	c #6B3063",
"G	c #0020FF",
"H	c #0855FF",
"I	c #5269C6",
"J	c #0000FF",
"K	c #0061FF",
"L	c #3196FF",
"M	c #847DC6",
"N	c #3192FF",
"O	c #4AA2FF",
"P	c #63A2F7",
"Q	c #C62031",
"R	c #002CFF",
"S	c #4AA6FF",
"T	c #5AAAFF",
"U	c #52A6FF",
"V	c #5224A5",
"W	c #73005A",
"X	c #2996FF",
"Y	c #0041FF",
"Z	c #108AFF",
"                                ",
"                                ",
"                 ..  .+@+.  ..  ",
"                .#$. .+@+. .$#. ",
"                 %&*=-;@;-=*&%  ",
"                  +>$$,',$$>+   ",
"                   %>>)!)>>%    ",
"                ..~{]^/(/^]{~.. ",
"               .#*$_^:<!<:^_$*#.",
"               .$[}|12<(<23|}[$.",
"                ..4567(!(7654.. ",
"                 890}ab(ba}0    ",
"                 cd66efgfe66+   ",
"                hi=[+j6@6kk[=4  ",
"               lm*[.no+@+. .[*. ",
"              pqrstnuv+@+.  w4  ",
"             xqyzAByqC+@+       ",
"            pqyzzzyqp           ",
"           lqyzzzyql            ",
"          pqyDzzyqp             ",
"         EFyzzzyqx              ",
"        GHIzzzyqp               ",
"       JKLMzzyql                ",
"      GKNOPMQqp                 ",
"     RHLSTULVW                  ",
"    GHXTTONKG                   ",
"   JKLTTTLKJ                    ",
" JGKNOTTXHG                     ",
" YHLSTULHR                      ",
" ZXTTONKG                       ",
" TTTTLKJ                        ",
" TTTXHG                         "};


static char * pie_xpm[] = {
"16 16 7 1",
" 	c None",
".	c #000000",
"+	c #00FFFF",
"@	c #0000FF",
"#	c #FFFF00",
"$	c #00FF00",
"%	c #FF0000",
"     ......     ",
"   . ++++++ .   ",
"  .++++++++++.  ",
" .@.++++++++.#. ",
" .@@.++++++.##. ",
".@@@@.++++.####.",
".@@@@@.++.#####.",
".@@@@@@..######.",
".@@@@@@@........",
".@@@@@@.........",
".@@@@@.$.%......",
" .@@@.$$.%%.... ",
" .@@.$$$.%%%... ",
"  ..$$$$.%%%%.  ",
"   ..$$$.%%..   ",
"     ......     "};

static char * randomNumbers_xpm[] = {
"15 14 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"      ...      ",
"      .+....   ",
"      .+..+.   ",
"...   .+..+.   ",
".+.   .+..+.   ",
".+.   .+..+.   ",
".+.....+..+.   ",
".+..+..+..+.   ",
".+..+..+..+.   ",
".+..+..+..+....",
".+..+..+..+..+.",
".+..+..+..+..+.",
".+..+..+..+..+.",
"..............."};

static char * rowNumbers_xpm[] = {
"15 15 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"            ...",
"            .+.",
"            .+.",
"         ....+.",
"         .+..+.",
"         .+..+.",
"      ....+..+.",
"      .+..+..+.",
"      .+..+..+.",
"   ....+..+..+.",
"   .+..+..+..+.",
"   .+..+..+..+.",
"....+..+..+..+.",
".+..+..+..+..+.",
"..............."};

static char * hBars_xpm[] = {
"16 16 16 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #030003",
"#	c #830000",
"$	c #E83703",
"%	c #0000FC",
"&	c #FEFEFE",
"*	c #FDFDFD",
"=	c #28DA18",
"-	c #F7F7F7",
";	c #F8F8F8",
">	c #F5F5F6",
",	c #F9F9FA",
"'	c #FBFBFB",
")	c #FCFCFC",
"................",
".++++++++++++++.",
".@@@@@+++++++++.",
".####.+++++++++.",
".............@+.",
".$$$$$$$$$$$$@+.",
".$$$$$$$$$$$$@+.",
"..............+.",
".%%%%%%%%%%.&&+.",
".%%%%%%%%%%.*&+.",
".@@@@@@@@@@.**+.",
".======@+++++++.",
".======.-;+++*+.",
".@@@@@@@>++,')+.",
".++++++++++++++.",
"................"};


static char * vertBars_xpm[] = {
"16 17 16 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #FCFCFC",
"#	c #FDFDFD",
"$	c #FEFEFE",
"%	c #030003",
"&	c #FBFBFB",
"*	c #E83703",
"=	c #F9F9FA",
"-	c #0000FC",
";	c #F8F8F8",
">	c #F5F5F6",
",	c #F7F7F7",
"'	c #28DA18",
")	c #830000",
"................",
".++++++++++++++.",
".+@#+#$$.%%%+++.",
".+&++##$.**.+++.",
".+=++....**.+++.",
".++++%--.**.+++.",
".++;+%--.**.+++.",
".+>,+%--.**.+++.",
".+%.%%--.**.+++.",
".+%''%--.**.+++.",
".+%''%--.**..%+.",
".+%''%--.**.)%+.",
".+%''%--.**.)%+.",
".+%''%--.**.)%+.",
".+%''%--.**.)%+.",
".+%''%--.**.)%+.",
"................"};

static char * area_xpm[] = {
"16 16 4 1",
" 	c #000000",
".	c #FFFFFF",
"+	c #00FF00",
"@	c #FF0000",
"                ",
" .............. ",
" .............. ",
" .............. ",
" ...++....+++.. ",
" ..+++++.+++++. ",
" .+++++@@@@++++ ",
" @@+++@@@@@@++@ ",
" @@@@@@@@  @@@@ ",
" @@  @@@    @@@ ",
" @    @      @@ ",
"                ",
"                ",
"                ",
"                ",
"                "};

static char * cursors_xpm[] = {
"16 16 8 1",
" 	c None",
".	c #D51309",
"+	c #010000",
"@	c #030003",
"#	c #28DAC6",
"$	c #F90C02",
"%	c #000002",
"&	c #00000E",
"         ..     ",
"         ..     ",
"         ..     ",
"    ++   ..     ",
"    @@   ..     ",
"  .......##.....",
"  .......##..$..",
"    +@   ..     ",
"    @@   ..     ",
"+++++%+++..@    ",
"+++&+@+++..@    ",
"    ++   ..     ",
"    ++   ..     ",
"    ++   ..     ",
"    ++          ",
"    ++          "};

static char *close_xpm[] = {
"13 15 26 1",
" 	c None",
".	c #8A9BA7",
"+	c #718D96",
"@	c #667987",
"#	c #576876",
"$	c #A6A6A4",
"%	c #535A62",
"&	c #42454A",
"*	c #878787",
"=	c #F4F3F5",
"-	c #E6EFF8",
";	c #DBE6F2",
">	c #D7DEEC",
",	c #C2D4E6",
"'	c #B8CCE9",
")	c #B0BBE3",
"!	c #97A5DA",
"~	c #333333",
"{	c #D8D8DA",
"]	c #B7C0CC",
"^	c #C4C8C1",
"/	c #CADAE8",
"(	c #98B6DF",
"_	c #A0A8BF",
":	c #96A6AF",
"<	c #CCD2D6",
"    .+@#     ",
"$#@+.+@#%%&* ",
"%=-;>,'))!!~{",
"%#@+.+@#%%&~]",
"^#=->/')(!&.]",
" #=+>_:)@!&] ",
" #=@>::)@!&] ",
" #=@>::)@!&] ",
" #=@>::)@!&] ",
" #=@>::)@!&] ",
" #=@>::)@!&] ",
" #=+>_:)@!&] ",
" #=->/')(!&] ",
" .@+.+@#%%@] ",
"  <]]]]]]]]< "};

static char *logo_xpm[]={
"32 32 144 2",
"Qt c None",
".# c #000000",
".B c #000080",
"#3 c #000087",
"#U c #00008e",
"#L c #000095",
"#D c #00009c",
".j c #00009e",
".y c #00009f",
"#u c #0000a3",
"#h c #0000aa",
".i c #0000ae",
"#b c #0000b1",
"#2 c #0000b7",
".6 c #0000b8",
".h c #0000bd",
".g c #0000bf",
"#T c #0000c0",
".W c #0000c6",
"#K c #0000c9",
".T c #0000cd",
"#C c #0000d2",
".f c #0000d4",
".x c #0000d6",
".G c #0000db",
"#9 c #0000dd",
"#1 c #0000de",
".m c #0000df",
"#S c #0000e0",
".C c #0000e2",
"#g c #0000e4",
".w c #0000e5",
"#t c #0000e6",
"#f c #0000e8",
".e c #0000e9",
"## c #0000ea",
".5 c #0000ec",
"#a c #0000ed",
".b c #0000ee",
".V c #0000ef",
".s c #0000f0",
".S c #0000f1",
".c c #0000f3",
".F c #0000f5",
".l c #0000f6",
".o c #0000f7",
".d c #0000f9",
".r c #0000fb",
".n c #0000fd",
".a c #0000ff",
".8 c #008000",
"ae c #008a00",
"#8 c #009500",
".R c #009e00",
"#0 c #009f00",
"#R c #00aa00",
".Q c #00ae00",
"#J c #00b400",
"ad c #00bb00",
".P c #00bd00",
".N c #00bf00",
"#s c #00c900",
".M c #00d400",
"#Z c #00d600",
"aj c #00dd00",
"#. c #00df00",
"#7 c #00e200",
"#Q c #00e400",
"#Y c #00e500",
"#P c #00e800",
".L c #00e900",
"#H c #00eb00",
".I c #00ee00",
"#r c #00f000",
"#I c #00f100",
".J c #00f300",
".2 c #00f400",
".9 c #00f600",
".K c #00f900",
".1 c #00fc00",
".E c #00ff00",
"ak c #800000",
"a# c #808080",
"#6 c #848484",
"#X c #898989",
"a. c #8b8b8b",
"#O c #8d8d8d",
"#5 c #909090",
"#E c #929292",
"ai c #950000",
"#W c #959595",
"#w c #969696",
"#N c #9a9a9a",
"#j c #9b9b9b",
"#4 c #9c9c9c",
"af c #9d9d9d",
"#B c #9e0000",
"an c #9f9f9f",
".7 c #a0a0a0",
"am c #a1a1a1",
"#V c #a2a2a2",
".3 c #a4a4a4",
"#v c #a5a5a5",
"#G c #a6a6a6",
"#M c #a8a8a8",
".Y c #a9a9a9",
"ac c #aa0000",
"#i c #aaaaaa",
"#F c #ababab",
"#y c #acacac",
".U c #adadad",
"#A c #ae0000",
"#x c #aeaeae",
"#k c #afafaf",
".4 c #b0b0b0",
"#d c #b1b1b1",
".O c #b2b2b2",
"#c c #b3b3b3",
".X c #b4b4b4",
".0 c #b5b5b5",
".A c #b6b6b6",
".Z c #b7b7b7",
".v c #b8b8b8",
".u c #b9b9b9",
".t c #bababa",
".H c #bbbbbb",
".q c #bcbcbc",
"#z c #bd0000",
".p c #bdbdbd",
".z c #bebebe",
"#q c #bf0000",
".D c #bfbfbf",
".k c #c0c0c0",
"ah c #c90000",
"#p c #d40000",
"al c #dd0000",
"ag c #e20000",
"ab c #e40000",
"aa c #e80000",
"#o c #e90000",
"#l c #ee0000",
"#m c #f30000",
"#n c #f90000",
"#e c #ff0000",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.#.#QtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.#.a.a.a.#.#QtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.b.c.d.a.e.f.g.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.#.#.h.i.j.#.#.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQt.#.#.a.a.#.#.#.a.a.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.#.#.k.#.l.a.m.#.n.a.o.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQt.#.#.p.q.q.#.b.a.g.#.r.a.s.#.#QtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.#.p.q.t.u.v.#.w.x.y.#.d.a.e.#.k.#.#QtQtQtQtQtQt",
"QtQtQtQtQt.#.#.k.z.q.t.v.A.#.#.#.i.B.#.o.a.C.#.z.D.k.#.#QtQtQtQt",
"QtQtQt.#.#.z.D.k.p.t.v.#.#.E.E.E.#.#.#.F.a.G.#.p.z.k.k.H.#.#QtQt",
"Qt.#.#.q.p.z.D.k.q.u.#.I.J.K.E.L.M.N.#.c.a.f.#.q.z.k.k.u.O.#QtQt",
".#.u.t.H.q.p.z.k.q.v.#.#.#.P.Q.R.#.#.#.S.a.T.#.t.p.k.k.A.U.#QtQt",
".#.v.u.t.q.p.z.k.H.A.#.E.E.#.#.#.E.E.#.V.a.W.#.u.q.k.k.X.Y.#QtQt",
".#.Z.v.t.H.p.z.k.t.0.#.I.E.N.#.1.E.2.#.b.a.g.#.v.q.k.k.O.3.#QtQt",
".#.A.A.Z.v.v.u.t.0.4.#.I.E.N.#.K.E.L.#.5.l.6.#.Z.H.k.k.4.7.#QtQt",
".#.0.0.0.0.0.0.0.4.#.#.#.Q.8.#.9.E#..####a#b.#.Z.H.k.k.4.7.#QtQt",
".#.X#c.O.O#d.4.#.##e#e#e.#.#.#.J.E.M.##f#g#h.#.0.Z.t.t#i#j.#QtQt",
".##c#d.4#k.U.##l#m#n#e#o#p#q.##r.E#s.##t.G#u.#.X.X.X.X#v#w.#QtQt",
".#.O.4#x#y#i.#.#.##z#A#B.#.#.#.I.E.N.##g#C#D.##c.4#x#x.7#E.#QtQt",
".##d#x#F.Y#G.##e#e.#.#.##e#e.##H#I#J.#.C#K#L.#.O.U#M#M#N#O.#QtQt",
".#.4#y.Y#G.#.##n#e#o.##n#e#o.##P#Q#R.##S#T#U.##d.Y#V#V#W#X.#QtQt",
".##k#F.#.#.k.##m#e#p.##m#e#p.##Y#Z#0.##1#2#3.#.#.##4#4#5#6.#QtQt",
".#.#.#.k.v.4.##l#e#q.##l#e#q.##7#s#8.##9.#.#.k.k.k.#.#a.a#.#QtQt",
".#.Z.H.k.4.7.#aaabac.##l#e#q.##.adae.#.#.D.z.p.q.H.t.u.#.#.#QtQt",
".#.##k#Faf#5.#agahai.#aaabac.#aj.#.#.D.k.z.q.t.v.Z.0#c#d.4.#QtQt",
"QtQt.#.#a.a#.#.##Aak.#agahai.#.#.p.z.D.k.p.t.v.0.O.4.U.#.#QtQtQt",
"QtQtQtQt.#.#.p.v.#.#.#al.#.#.H.q.p.z.D.k.q.v.0#d#x.#.#QtQtQtQtQt",
"QtQtQtQtQtQt.#.#.p.v.#.#.0.0.0.0.0.0.0.0#d#x#F.#.#QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.#.##c.O#d.4#k#x.U#y#F#F#M.#.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.#.#.U#F.Y#M#G.3#V.#.#QtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQt.#.#.3aman.#.#QtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.#.#QtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};


/* XPM */
static char * hand_xpm[] = {
"16 20 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"     ..         ",
"    .++.        ",
"    .++.        ",
"    .++.        ",
"    .++.        ",
"    .++.        ",
"    .++...      ",
"    .++.++...   ",
"    .++.++.++.. ",
" .. .++.++.++.+.",
".++..++.++.++.+.",
".+++.++++++++++.",
" .+++++++++++++.",
"  .++++++++++++.",
"  .++++++++++++.",
"   .++++++++++. ",
"   .++++++++++. ",
"    .++++++++.  ",
"    .++++++++.  ",
"    ..........  "};

/* XPM */
static char * drag_curve_xpm[] = {
"13 16 4 1",
" 	c None",
".	c #FF0000",
"+	c #000000",
"@	c #FFFFFF",
"      ..   . ",
"     .  .  . ",
"     .  .  . ",
"    .    ..  ",
"    .        ",
"  ++.++ ++   ",
" +@@+@@+@@++ ",
" +@@@@@@@@+@+",
"  +@@@@@@@@@+",
" ++@@@@@@@@@+",
"+@@@@@@@@@@@+",
"+@@@@@@@@@@+ ",
" +@@@@@@@@@+ ",
"  +@@@@@@@+  ",
"   +@@@@@@+  ",
"   +@@@@@@+  "};

/* XPM */
static char *errors_xpm[]={
"3 11 2 1",
" 	c None",
".	c #000000",
"...",
" . ",
" . ",
" . ",
"...",
"...",
"...",
" . ",
" . ",
" . ",
"..."};

static char *curves_xpm[]={
"14 16 5 1",
" 	c None",
".	c #000000",
"+	c #100000",
"@	c #FFFFFF",
"#	c #FF0000",
".......+++++++",
".@@@@@@@@@@@@+",
".@@@@@@@@@#@@+",
".@..@@@@@###@+",
".@@.@@@@@@#@@+",
".@@.@@@@@@@@@.",
".@..@@##@@@#@.",
".@@.@#@@#@@#@.",
".@@.@#@@#@@#@.",
".@..#@@@@##@@.",
".@@.#@@@@@@@@.",
".@@.#@@@@@@@@.",
".@..........@.",
".@@.@@.@@.@@@.",
".@@@@@@@@@@@@.",
".............."};

static char *arrow_xpm[]={
"11 12 2 1",
" 	c None",
".	c #000000",
"     ......",
"      .....",
"       ....",
"       ....",
"      .. ..",
"     ..   .",
"    ..     ",
"   ..      ",
"  ..       ",
" ..        ",
"..         ",
".          "};

static char *legend_xpm[]={
"14 15 4 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #0000FF",
"..............",
".++++++++++++.",
".+++++++...++.",
".+++++++.++.+.",
".+.....+...++.",
".+++++++.++.+.",
".+++++++....+.",
".++++++++++++.",
".++++++++...+.",
".++@@+++.++++.",
".+@@@@@+.++++.",
".++@@+++.++++.",
".++++++++...+.",
".++++++++++++.",
".............."};


static char *select_xpm[]={
"16 16 4 1",
" 	c None",
".	c #D51309",
"+	c #010000",
"@	c #28DAC6",
"        .       ",
"        .       ",
"        .       ",
"        .       ",
"     +++.+++    ",
"     +  .  +    ",
"     +  .  +    ",
"........@.......",
"     +  .  +    ",
"     +  .  +    ",
"     +++.+++    ",
"        .       ",
"        .       ",
"        .       ",
"        .       ",
"        .       "};

static char *cursor_16[]={
"16 16 2 1",
". c None",
"# c #000000",
"................",
"................",
"................",
"........#.......",
"........#.......",
".....#######....",
".....#.....#....",
"...###.....###..",
".....#.....#....",
".....#######....",
"........#.......",
"........#.......",
"................",
"................",
"................",
"................"};

static char *unzoom_xpm[]={
"15 15 2 1",
". c None",
"# c #000000",
"..#............",
".###........##.",
"#.#.#...##..##.",
"..#..##.##.....",
"..#..##....##..",
"..#........##..",
"..#...##.......",
"..#...##.##.##.",
"#.#.#....##.##.",
".###...........",
"..#...#.....#..",
"..#..#.......#.",
"..#############",
".....#.......#.",
"......#.....#.."};

static char *paste_xpm[]={
"16 15 7 1",
". c None",
"# c #000000",
"d c #00007f",
"c c #7f7f00",
"b c #7f7f7f",
"a c #ffff00",
"e c #ffffff",
"................",
"......####......",
"..#####aa#####..",
".#bcb#a##a#cbc#.",
".#cb#......#cb#.",
".#bc########bc#.",
".#cbcbcbcbcbcb#.",
".#bcbcbddddddd#.",
".#cbcbcdeeeeedd.",
".#bcbcbdeeeeeded",
".#cbcbcdedddeddd",
".#bcbcbdeeeeeeed",
".#cbcbcdeddddded",
"..#####deeeeeeed",
".......ddddddddd"};

static char *cut_xpm[]={
"18 18 3 1",
". c None",
"# c #000000",
"a c #00007f",
"..................",
"..................",
"..................",
".......#...#......",
".......#...#......",
".......#...#......",
".......##.##......",
"........#.#.......",
"........###.......",
".........#........",
"........a#a.......",
"........a.aaa.....",
"......aaa.a..a....",
".....a..a.a..a....",
".....a..a.a..a....",
".....a..a..aa.....",
"......aa..........",
".................."};

static char *copy_xpm[]={
"15 13 4 1",
"# c None",
". c #000000",
"b c #00007f",
"a c #ffffff",
"......#########",
".aaaa..########",
".aaaa.a.#######",
".a..a.bbbbbb###",
".aaaaabaaaabb##",
".a....baaaabab#",
".aaaaaba..abbbb",
".a....baaaaaaab",
".aaaaaba.....ab",
"......baaaaaaab",
"######ba.....ab",
"######baaaaaaab",
"######bbbbbbbbb"};

/* XPM */
static char * text_xpm[] = {
"12 11 2 1",
" 	c None",
".	c #1F0E77",
"............",
"..   ..   ..",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"     ..     ",
"    ....    "};


static char * duplicate_xpm[] = {
"14 14 4 1",
" 	c None",
".	c #000000",
"+	c #0000FF",
"@	c #C6C4C4",
"..............",
".++++++++++++.",
".@@@@@@@@@@@@.",
".@@@@@@@@@@@@.",
".@@@@@@@@@@@@.",
"..............",
"              ",
"              ",
"..............",
".++++++++++++.",
".@@@@@@@@@@@@.",
".@@@@@@@@@@@@.",
".@@@@@@@@@@@@.",
".............."};

static char *new_xpm[]={
"14 16 4 1",
"# c None",
". c #000000",
"b c #a0a7af",
"a c #ffffff",
"..........####",
".aaaaaaaa..###",
".aaaaaaaa.b.##",
".aaaaaaaa.bb.#",
".aaaaaaaa.bbb.",
".aaaaaaaa.....",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".aaaaaaaaaaaa.",
".............."};

static char *addCol_xpm[]={
"15 16 5 1",
". c None",
"# c #000000",
"a c #0018f0",
"b c #ff0000",
"c c #ffffff",
"...............",
".......######..",
".......#aaaa#..",
".......#aaaa#..",
".......######..",
"..b....#cccc#..",
"..b....######..",
".bbb...#cccc#..",
"..b....######..",
"..b....#cccc#..",
".......######..",
".......#cccc#..",
".......######..",
".......#cccc#..",
".......######..",
"..............."};

static char *pPlot_xpm[]={
"13 13 2 1",
". c None",
"# c #000000",
"..........###",
"..........###",
"..........###",
".............",
".............",
".....###.....",
".....###.....",
".....###.....",
".............",
".............",
"###..........",
"###..........",
"###.........."};


static char *lpPlot_xpm[]={
"13 13 2 1",
". c None",
"# c #000000",
"..........###",
"..........###",
"..........###",
".........#...",
"........#....",
".....###.....",
".....###.....",
".....###.....",
"....#........",
"...#.........",
"###..........",
"###..........",
"###.........."};

static char *lPlot_xpm[]={
"14 14 2 1",
". c None",
"# c #000000",
".............#",
"............#.",
"...........#..",
"..........#...",
".........#....",
"........#.....",
".......#......",
"......#.......",
".....#........",
"....#.........",
"...#..........",
"..#...........",
".#............",
"#............."};


static char *table_xpm[]={
"15 16 5 1",
"# c None",
". c #000000",
"c c #2007f0",
"b c #8f888f",
"a c #ffffff",
"..........#####",
".aaaaaaaa..####",
".aaaaaaaa.b.###",
".aaaaaaaa.bb.##",
".aaaaaaaa.bbb.#",
".aaaaaaaa.....#",
".aaaaaaaaaaaa.#",
".a.............",
".a.cc.cc.cc.cc.",
".a.............",
".a.aa.aa.aa.aa.",
".a.aa.aa.aa.aa.",
".a.............",
".a.aa.aa.aa.aa.",
".a.aa.aa.aa.aa.",
"..............."};

static char *multiload_xpm[]={
"16 15 5 1",
". c None",
"# c #000000",
"b c #2007f0",
"a c #ff0000",
"c c #ffffff",
".#..##.##.......",
"##...#..#.......",
".#..#..##.aaaa..",
".#..#...#....a..",
"###.##.##..aaaaa",
"............aaa.",
"############.a..",
"#b#bb#bb#bb#....",
"################",
"#c#.#b#bb#bb#bb#",
"################",
"#c#.#c#..#..#..#",
"################",
"....#c#..#..#..#",
"....############"};

static char *import_xpm[]={
"16 15 5 1",
" 	c None",
".	c #000000",
"+	c #FF0000",
"@	c #2F2FF0",
"#	c #FFFFFF",
" .  .. ..       ",
"..   .  .       ",
" .  .  .. ++++  ",
" .  .   .    +  ",
"... .. ..  +++++",
"            +++ ",
"             +  ",
"                ",
"    ............",
"    .@.@@.@@.@@.",
"    ............",
"    .#.##.##.##.",
"    ............",
"    .#.##.##.##.",
"    ............"};

static char * graph_xpm[] = {
"14 14 6 1",
" 	c None",
".	c #030003",
"+	c #FFFFFF",
"@	c #FC0D00",
"#	c #2F28EF",
"$	c #0000FC",
"..............",
".++++@@++++++.",
".++++@@++++++.",
".+++@++@+++++.",
".++@++++@@+++.",
".+@+++++@@++#.",
".++++##+++@+#.",
".++++##++++$+.",
".+++#++#++$+@.",
".++#++++##+++.",
".+#+++++##+++.",
".++++++++++++.",
".++++++++++++.",
".............."};

static char *worksheet_xpm[]={
"13 12 32 1",
"  c black",
". c #000100",
"X c #010101",
"o c #000002",
"O c #000201",
"+ c #000005",
"@ c #000207",
"# c #000209",
"$ c #000309",
"% c #00020B",
"& c #00030C",
"* c #00030E",
"= c #000212",
"- c #000519",
"; c #00041B",
": c #00061E",
"> c #00071E",
", c #000720",
"< c #000821",
"1 c #000927",
"2 c #000929",
"3 c #000A33",
"4 c #000C37",
"5 c #000C39",
"6 c #4C7799",
"7 c #597384",
"8 c #5A7387",
"9 c #5A7485",
"0 c #517595",
"q c #FFFFFD",
"w c #FEFFFF",
"e c gray100",
/* pixels */
"<,,1542,,254;",
"-78:66:77:60=",
"#@##&&&@##&#X",
"XeeXeeXeeXeeX",
"XeeXeeXeeXeeX",
"XXXXXXXXXXXXX",
"XeeXeeXeeXeeX",
"XeeXeeXeeXeeX",
"XXXXXXXXXXXXX",
"XeeXeeXeeXeeX",
"XeeXeeXeeXeeX",
"XXXXXXXXXXXXX"
};

static char *folder_xpm[]={
"32 32 161 2",
"Qt c None",
".b c #000000",
"aE c #503200",
"aD c #583700",
"aC c #5b3900",
"aA c #5e3c00",
"aB c #633f00",
"az c #664100",
"ax c #6a4400",
"ay c #6b4400",
"av c #6e4700",
"au c #734a00",
"aw c #774c00",
"as c #7a4f00",
"at c #7b4f00",
"ar c #7e5100",
".# c #808080",
"ap c #815400",
"aq c #865700",
"an c #895900",
"am c #8d5c00",
"ao c #966200",
".R c #a6caf0",
"aj c #c0c0c0",
".2 c #c5c5c5",
"#W c #c9c9c9",
".9 c #cbcbcb",
".8 c #cfcfcf",
"#h c #d2d2d2",
"al c #d4d47c",
"ak c #d5d57e",
"#X c #d5d5d5",
"af c #d6d680",
"ae c #d7d782",
"ad c #d8d884",
"#5 c #d8d885",
"#4 c #d9d987",
"#p c #d9d9d9",
"ac c #dada89",
"#3 c #dada8a",
"#U c #dbdb8a",
"#2 c #dbdb8c",
"#T c #dcdc8c",
"ab c #dcdc8e",
"#1 c #dcdc8f",
"#M c #dddd8f",
"#L c #dede91",
"#I c #dfdf94",
"#J c #dfdfdf",
"#H c #e0e096",
"#Y c #e0e0e0",
"#S c #e1e196",
"#G c #e1e199",
"#x c #e2e299",
"#w c #e3e39b",
"#F c #e3e39c",
"#K c #e3e3e3",
"#n c #e4e49e",
"#E c #e4e49f",
"#m c #e5e5a0",
"#D c #e5e5a1",
"#v c #e6e6a1",
"#f c #e6e6a3",
"#P c #e6e6e6",
"#u c #e7e7a4",
"#e c #e7e7a6",
"#l c #e8e8a6",
"#t c #e8e8a7",
".Z c #e9e9a8",
"#d c #e9e9a9",
"ag c #e9e9aa",
".Y c #eaeaab",
"#c c #eaeaac",
".V c #ebebac",
"#8 c #ebebae",
".U c #ececae",
"#b c #ececaf",
"#7 c #ececb0",
".P c #ededb1",
"#a c #ededb2",
"#O c #ededed",
".O c #eeeeb3",
"#6 c #eeeeb4",
".T c #efefb4",
"## c #efefb5",
".N c #efefb6",
".K c #f0f0b6",
".S c #f0f0b7",
".M c #f0f0b8",
".J c #f1f1b8",
"#N c #f1f1b9",
"#V c #f1f1ba",
".I c #f2f2ba",
".F c #f2f2bb",
".E c #f2f2bc",
".H c #f3f3bc",
".L c #f3f3bd",
".D c #f3f3be",
".G c #f4f4be",
"#y c #f4f4bf",
".C c #f4f4c0",
".x c #f5f5c0",
".w c #f5f5c1",
".B c #f5f5c2",
".v c #f6f6c2",
".A c #f6f6c3",
".u c #f7f7c4",
".r c #f7f7c5",
".q c #f7f7c6",
".7 c #f8f8c6",
".p c #f8f8c7",
".o c #f8f8c8",
".t c #f9f9c8",
".n c #f9f9c9",
".m c #f9f9ca",
".s c #fafaca",
".l c #fafacb",
".Q c #fafacc",
".k c #fbfbcc",
".j c #fbfbcd",
".y c #fbfbce",
".i c #fcfcce",
".h c #fcfccf",
".z c #fcfcd0",
".g c #fdfdd0",
".e c #fdfdd1",
".f c #fdfdd2",
".c c #fefed2",
".d c #fefed3",
".a c #ffffd4",
".0 c #ffffda",
".W c #ffffdb",
".X c #ffffdc",
".1 c #ffffdd",
".3 c #ffffde",
"#g c #ffffdf",
".4 c #ffffe0",
".5 c #ffffe1",
"#o c #ffffe2",
".6 c #ffffe3",
"#. c #ffffe4",
"#z c #ffffe5",
"#i c #ffffe6",
"#j c #ffffe7",
"#9 c #ffffe8",
"#q c #ffffe9",
"#r c #ffffea",
"#k c #ffffeb",
"#A c #ffffec",
"#B c #ffffed",
"#s c #ffffee",
"#Q c #ffffef",
"a. c #fffff0",
"#C c #fffff1",
"#Z c #fffff2",
"#R c #fffff3",
"#0 c #fffff4",
"a# c #fffff5",
"ah c #fffff6",
"aa c #fffff7",
"ai c #fffff8",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.#.#.#.#.#.#.#QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.a.a.a.a.a.a.bQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
".#.c.c.c.c.c.c.c.d.d.bQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
".#.e.e.e.e.e.f.f.c.c.c.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#Qt",
".#.g.g.g.g.e.e.e.c.c.c.c.d.d.d.a.a.c.e.g.h.i.j.k.l.m.n.o.p.q.r.b",
".#.i.i.i.h.h.g.g.e.e.e.c.c.d.d.a.a.c.e.h.i.k.l.s.t.p.r.u.v.w.x.b",
".#.j.j.y.y.h.h.z.g.e.e.f.c.d.d.a.a.c.g.i.k.l.n.p.r.A.B.C.D.E.F.b",
".#.k.k.j.j.i.i.h.g.g.e.e.c.c.d.a.a.e.h.j.l.n.p.r.v.x.G.H.I.J.K.b",
".#.s.s.l.k.k.j.i.h.h.g.e.e.c.#.#.#.#.#.b.m.p.r.v.C.L.F.M.N.O.P.b",
".#.n.n.m.l.Q.k.j.i.h.z.g.#.#.R.R.R.R.R.R.b.b.v.x.L.I.S.T.P.U.V.b",
".#.t.t.n.s.l.k.j.i.i.h.#.R.R.R.R.R.W.W.X.R.R.b.G.I.S.T.P.U.Y.Z.b",
".#.t.t.n.s.l.k.j.i.i.#.R.R.R.R.0.W.1.2.3.4.5.6.b.I.S.T.P.U.Y.Z.b",
".#.7.7.p.p.o.t.n.n.m.#.R.R.0.8.1.3.8.9.5.6#..2.b###a#b#c#d#e#f.b",
".#.r.r.r.r.r.r.r.q.#.R.R.R.X.8#g.5.6#h#.#i#j.8#k.b.V#d#l#f#m#n.b",
".#.u.A.A.A.A.v.v.v.#.R.R.3#g.2#o#.#i#p#j#q#r#p#s.b#t#u#v#n#w#x.b",
".#.A.B.w.w.C.C#y#y.#.R.R.5#o#p#z#j#q#p#r#A#B#p#C.b#D#E#F#G#H#I.b",
".#.w.C#y.D.L.E.F.I.#.R.R.5#o#p#z#j#q#J#r#A#B#K#C.b#F#x#H#I#L#M.b",
".#.x.G.L.H.I#N.J.S.#.R.R.6#.#O#j#q#k#P#A#s#Q#O#R.b#S#I#L#M#T#U.b",
".##y.L.F#V.M.K##.O.P.#.R.8.8#q#r#A#W#X#Y#C#Z#0.8.b#L#1#2#3#4#5.b",
".#.D.E#V.M.N#6#a#7#8.#.R#9#q#k#A#sa.a.#C#Ra#aa.bab#2ac#4adaeaf.b",
".#.L#V.M##.O.P.U.Vag#t.##k#A#s#Q#C#R#R#0ahai.baj.b#4#5aeafakal.b",
"Qt.b.b.b.b.b.b.b.b.b.b.b.b.b#C#Z#0ahahaa.b.bajajaj.b.b.b.b.b.bQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.b.b.b.b.b.b.b.#.#aj.#am.bQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.b.#.#anaoap.bQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.baqaoaraoas.bQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.bataoauaoav.bQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.bawaoauaoax.bQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.bayaoazaoaA.b",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.baBaoaCao.b",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.baDaoaE.b",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.b.b.bQt"};


static char *fileopen_xpm[] = {
"    16    13        5            1",
". c #040404",
"# c #808304",
"a c None",
"b c #f3f704",
"c c #f3f7f3",
"aaaaaaaaa...aaaa",
"aaaaaaaa.aaa.a.a",
"aaaaaaaaaaaaa..a",
"a...aaaaaaaa...a",
".bcb.......aaaaa",
".cbcbcbcbc.aaaaa",
".bcbcbcbcb.aaaaa",
".cbcb...........",
".bcb.#########.a",
".cb.#########.aa",
".b.#########.aaa",
"..#########.aaaa",
"...........aaaaa"
};

static char *fileprint_xpm[] = {
"    16    14        6            1",
". c #000000",
"# c #848284",
"a c #c6c3c6",
"b c #ffff00",
"c c #ffffff",
"d c None",
"ddddd.........dd",
"dddd.cccccccc.dd",
"dddd.c.....c.ddd",
"ddd.cccccccc.ddd",
"ddd.c.....c....d",
"dd.cccccccc.a.a.",
"d..........a.a..",
".aaaaaaaaaa.a.a.",
".............aa.",
".aaaaaa###aa.a.d",
".aaaaaabbbaa...d",
".............a.d",
"d.aaaaaaaaa.a.dd",
"dd...........ddd"
};

/* XPM */
static char *filesave_xpm[] = {
"14 15 54 1",
" 	c None",
".	c #7393A7",
"+	c #12486B",
"@	c #104769",
"#	c #BACDDA",
"$	c #AAB9C4",
"%	c #FFFFFF",
"&	c #104668",
"*	c #90B1C5",
"=	c #768FA1",
"-	c #0D4365",
";	c #82A7BD",
">	c #648195",
",	c #0B4163",
"'	c #79A0B8",
")	c #55778D",
"!	c #083F60",
"~	c #709BB5",
"{	c #4B6E87",
"]	c #063C5D",
"^	c #6C98B3",
"/	c #4B728C",
"(	c #DEE4E8",
"_	c #003959",
":	c #5D86A0",
"<	c #436982",
"[	c #003656",
"}	c #6B97B2",
"|	c #003453",
"1	c #557C97",
"2	c #003151",
"3	c #709CB7",
"4	c #6F9BB6",
"5	c #486D86",
"6	c #CECED0",
"7	c #687782",
"8	c #E8E9EA",
"9	c #002F4E",
"0	c #7BA6C1",
"a	c #7BA5C0",
"b	c #557991",
"c	c #D8D8DA",
"d	c #74828D",
"e	c #F2F3F3",
"f	c #002C4B",
"g	c #8CB6D0",
"h	c #8BB5CF",
"i	c #688AA1",
"j	c #E6E6E8",
"k	c #85939E",
"l	c #CBCBCB",
"m	c #002B49",
"n	c #536D80",
"o	c #E0E0E0",
".++++++++++++.",
"@#$%%%%%%%%$#@",
"&*=%%%%%%%%=*&",
"-;>%%%%%%%%>;-",
",')%%%%%%%%)',",
"!~{%%%%%%%%{~!",
"]^/(%%%%%%(/^]",
"_^:/<<<<<</:^_",
"[^^^}}}}}}^^^[",
"|^^1<<<<<<1^^|",
"23456667885432",
"90abcccdeeba09",
"fghijjjk%%ihgf",
"lmmmmmmmmmmmmn",
" llllllllllllo"};

/* XPM */
static char * filesaveas_xpm[] = {
"14 15 59 1",
" 	c None",
".	c #7393A7",
"+	c #12486B",
"@	c #104769",
"#	c #BACDDA",
"$	c #AAB9C4",
"%	c #FFFFFF",
"&	c #104668",
"*	c #90B1C5",
"=	c #768FA1",
"-	c #F16161",
";	c #0D4365",
">	c #82A7BD",
",	c #648195",
"'	c #FACCCC",
")	c #0B4163",
"!	c #79A0B8",
"~	c #55778D",
"{	c #EF3A3A",
"]	c #FCE1E1",
"^	c #083F60",
"/	c #709BB5",
"(	c #4B6E87",
"_	c #F9C4C4",
":	c #063C5D",
"<	c #6C98B3",
"[	c #4B728C",
"}	c #DEE4E8",
"|	c #003959",
"1	c #5D86A0",
"2	c #436982",
"3	c #003656",
"4	c #6B97B2",
"5	c #003453",
"6	c #557C97",
"7	c #003151",
"8	c #709CB7",
"9	c #6F9BB6",
"0	c #486D86",
"a	c #CECED0",
"b	c #687782",
"c	c #E8E9EA",
"d	c #002F4E",
"e	c #7BA6C1",
"f	c #7BA5C0",
"g	c #557991",
"h	c #D8D8DA",
"i	c #74828D",
"j	c #F2F3F3",
"k	c #002C4B",
"l	c #8CB6D0",
"m	c #8BB5CF",
"n	c #688AA1",
"o	c #E6E6E8",
"p	c #85939E",
"q	c #CBCBCB",
"r	c #002B49",
"s	c #536D80",
"t	c #E0E0E0",
".++++++++++++.",
"@#$%%%%%%%%$#@",
"&*=%------%=*&",
";>,%''''''%,>;",
")!~%{{{{{]%~!)",
"^/(%_____%%(/^",
":<[}%%%%%%}[<:",
"|<1[222222[1<|",
"3<<<444444<<<3",
"5<<62222226<<5",
"7890aaabcc0987",
"defghhhijjgfed",
"klmnooop%%nmlk",
"qrrrrrrrrrrrrs",
" qqqqqqqqqqqqt"};

static char *erase_xpm[]={
"29 28 256 2",
"Qt c None",
"aC c #000000",
".x c #000009",
"an c #000200",
"bt c #000300",
"#d c #000309",
"#W c #000400",
"b. c #00070d",
"#X c #00070f",
".0 c #000717",
"aV c #000803",
".l c #000a00",
"ao c #000e00",
".c c #00120f",
"#b c #00121e",
".h c #001308",
".X c #001b06",
".J c #001c00",
".e c #010007",
"bD c #010101",
"#I c #011412",
"bQ c #020202",
"aA c #030000",
"bZ c #040404",
".w c #040c0f",
"bk c #050505",
"bh c #060000",
"#e c #060002",
"ab c #070614",
"bL c #070707",
"aa c #070e06",
"#s c #0b0000",
"bW c #0b0b0b",
"aB c #0c130b",
".M c #0e0000",
".g c #0e0007",
"#a c #0f0000",
"bl c #0f0004",
"a9 c #0f0f0f",
"a3 c #10030a",
"aP c #10050d",
".L c #110015",
"b8 c #111111",
"bN c #131313",
"#c c #160e01",
"#t c #170700",
".y c #181d07",
".k c #190000",
".b c #190002",
".1 c #190c13",
".i c #1b0000",
".f c #1b0a12",
".j c #24081e",
".# c #25000e",
"aF c #260000",
".a c #290019",
".d c #38000b",
"bM c #6a6a6a",
"aE c #797979",
"bX c #7a7a7a",
"bj c #7b7b7b",
"bA c #7e7e7e",
"b9 c #7f7f7f",
"bH c #828282",
"az c #83767d",
"aD c #838383",
"bG c #898989",
"bz c #8d8d8d",
"bY c #969696",
"bU c #a7a7a7",
"#Q c #aa2b34",
"bS c #ababab",
"b3 c #b3b3b3",
"b7 c #b5b5b5",
"b4 c #bcbcbc",
"b1 c #c0c0c0",
"b0 c #c3c3c3",
"bR c #c8c8c8",
"bV c #c9c9c9",
"b6 c #cacaca",
"b5 c #cccccc",
"b2 c #cecece",
".S c #d51c17",
"bT c #d5d5d5",
"#L c #d5fff4",
"a2 c #d6f7ee",
"#w c #dc0419",
".G c #ddfff1",
"ax c #def7f3",
".s c #dffff3",
"aI c #e1f4d6",
".I c #e3f1f4",
"#P c #e3ffec",
"bO c #e4e4e4",
".N c #e4ffff",
"aH c #e5000d",
"#H c #e5dbdc",
"#r c #e5ffff",
".O c #e70000",
"#n c #e7ffea",
".r c #e7fffa",
"#Y c #e7fffd",
"bm c #e7ffff",
"#y c #e80014",
"bJ c #e8e8e8",
"aw c #e8fdf6",
"ar c #e8feff",
".A c #e9f8fd",
"bc c #e9fce0",
"ae c #e9ffec",
"#A c #ea001d",
"#3 c #eafdfb",
"#l c #eaffe8",
"a0 c #eafff8",
"a1 c #eaffff",
"b# c #ebf1ff",
"#m c #ebfff5",
"ai c #ebfffd",
"bd c #ebffff",
"a5 c #eceaeb",
".5 c #edfce7",
".V c #edfffd",
"aj c #edffff",
".2 c #eeeff4",
"ba c #eefdea",
".t c #eeffdf",
"#1 c #eefff8",
"#F c #eefffc",
"as c #ef0b0c",
"a8 c #efefef",
".B c #f01a00",
".R c #f0ffff",
".H c #f10018",
"aR c #f1f3f0",
"#f c #f1fffa",
"#8 c #f1ffff",
"#T c #f2f3f7",
"bv c #f2f9f1",
".3 c #f2fff6",
"a4 c #f3eaef",
"aN c #f4f5f9",
".E c #f4fff4",
"#Z c #f4ffff",
"#E c #f5f6f1",
"a7 c #f5fbf7",
"bb c #f5fbff",
".n c #f5fffd",
"ag c #f5ffff",
"bF c #f6f6f6",
".4 c #f6fafb",
"aS c #f6fff9",
"bK c #f7f7f7",
"aM c #f7fff3",
"#q c #f7fff5",
"av c #f7fffc",
"#C c #f80243",
"a# c #f8f2f2",
"bI c #f8f8f8",
"#9 c #f8fcff",
".8 c #f8fdf9",
"bw c #f8fefa",
"aG c #f8ffea",
".K c #f8fff6",
"bp c #f8fffb",
"#S c #f8fffd",
".u c #f8ffff",
".U c #f9002d",
"#J c #f9f4f8",
"bP c #f9f9f9",
"ak c #f9faff",
"ah c #f9fdff",
"#7 c #f9fff8",
"aX c #f9fffd",
".z c #fa000c",
"aU c #fafafa",
"#v c #fafee3",
"#u c #fb002c",
"aJ c #fb0e2a",
"#k c #fbeded",
"ay c #fbf6fd",
"bB c #fbfbfb",
"#4 c #fbffff",
"#O c #fc0013",
"aq c #fc0f00",
"bC c #fcfcfc",
".P c #fcfdff",
"bu c #fcfffa",
"aO c #fcffff",
".7 c #fdfdf3",
"#p c #fdfeff",
".D c #fe0100",
"#0 c #fef1de",
"#g c #fef8f8",
"aW c #fef9f5",
"bE c #fefefe",
"a6 c #fefffd",
"ap c #ff011c",
".F c #ff0227",
".W c #ff0233",
"#M c #ff0800",
".Q c #ff1106",
"#K c #ff1117",
"#5 c #ffdbda",
"aZ c #ffdff1",
"## c #ffe0f8",
"ad c #ffe1f4",
".9 c #ffe7e5",
"#R c #ffe7e6",
".T c #ffe7ed",
"#D c #ffe9f4",
"aK c #ffeae7",
".o c #ffebe3",
".C c #ffeeff",
"at c #ffefff",
"#N c #fff0f7",
"af c #fff1ec",
"#G c #fff1ff",
"#6 c #fff2eb",
".Y c #fff2ff",
".q c #fff3ea",
"ac c #fff4f7",
"a. c #fff4fb",
"by c #fff4ff",
"#. c #fff5d1",
"aY c #fff5f3",
"br c #fff5fa",
"bx c #fff6fa",
"#o c #fff6ff",
".v c #fff7e8",
"#h c #fff7f1",
"bs c #fff7f3",
".p c #fff7f7",
".6 c #fff8fc",
"bq c #fff9f2",
"bg c #fff9f9",
"bn c #fff9ff",
"aL c #fffae3",
"bo c #fffafa",
"al c #fffaff",
"#B c #fffbf0",
"be c #fffbf8",
"bf c #fffbfa",
"#U c #fffbff",
"#2 c #fffcef",
"#j c #fffcf3",
"am c #fffcfd",
"aQ c #fffcff",
"#x c #fffde3",
"#i c #fffdfa",
"#V c #fffefd",
"bi c #fffeff",
"#z c #ffffe3",
"au c #ffffec",
".Z c #ffffed",
".m c #fffff6",
"aT c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.a.b.c.d.e.f.g.h.i.j.kQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.l.m.n.o.p.q.r.s.t.u.v.w.xQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.y.z.A.B.C.D.E.F.G.H.I.J.K.LQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.0QtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.1.2.3.4.5.6.7.8.9#.##.M#a#b#c#dQtQtQtQtQtQtQtQtQt",
"QtQtQtQt#e#f#g#h#i#j#k.r#l#m#n#o#p#q#r#sQtQtQtQtQtQtQtQtQt",
"QtQtQtQt#t#u#v#w#x#y#z#A#B#C#D#E#F#G#H#IQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.M#J#K#L#M#N#O#P#Q#R#j#S#T#U#V#WQtQtQtQtQtQtQtQtQt",
"QtQtQtQt#X#Y#Z#0#1#2#3#4#5#6#7#8#9a.a#aaQtQtQtQtQtQtQtQtQt",
"QtQtQtQtabacadae#Zafagah#j#7aiajakalamanQtQtQtQtQtQtQtQtQt",
"QtQtQtQtaoap.uaqarasatauavawaxagayazaAaBaCaCaDaEQtQtQtQtQt",
"QtQtQtQtaFaGaHaIaJaKaLaMaNaO#palaPaQaRaSaTaTaUaCQtQtQtQtQt",
"QtQtQtQtaVaWaXaYaZa0a1a2#Ualala3a4a5a6a7aTa8a9aCQtQtQtQtQt",
"QtQtQtQtb.b#babbbcbdbe.Rbfbgbh#Va6a6bi.6aUaCbjbkQtQtQtQtQt",
"QtQtQtQtblbmbnbobpbqbrbsaSbtbubvbpbwbxbyaCbzbAaCQtQtQtQtQt",
"QtQtQtQtaCaTaTaTbBaTaTbCbDbEbFaTbFaTaTaCbGbHaCQtQtQtQtQtQt",
"QtQtQtQtaCbIaTbJbEaTbKbLbKaTaTaTbFbEaCbAbMaCQtQtQtQtQtQtQt",
"QtQtQtQtbNaTbOaTbPaTbCbQbRbSbTbUbVbWbXbYbNQtQtQtQtQtQtQtQt",
"QtQtQtQtaCaCbLaCbZaCaCb0b1b2b3bRb4aCbXaCQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtaCb5b3b6bVb7b6aCbLQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtaCb8aCaCbLbWb9QtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static char *zoom_xpm[]={
"20 20 106 2",
"  	c None",
". 	c #8D8C89",
"+ 	c #50504F",
"@ 	c #202121",
"# 	c #010101",
"$ 	c #1F2020",
"% 	c #4F4F4E",
"& 	c #3B3A3A",
"* 	c #222224",
"= 	c #6E777E",
"- 	c #95A0AA",
"; 	c #ABBAC9",
"> 	c #8998A6",
", 	c #606C77",
"' 	c #1D2022",
") 	c #393939",
"! 	c #111211",
"~ 	c #5F6368",
"{ 	c #D1DBE6",
"] 	c #D8E3ED",
"^ 	c #D5E0EB",
"/ 	c #CDDBE8",
"( 	c #C3D3E3",
"_ 	c #B7CBDE",
": 	c #A6BCD2",
"< 	c #48545E",
"[ 	c #101110",
"} 	c #DDE6EF",
"| 	c #E5ECF3",
"1 	c #E6EDF3",
"2 	c #000000",
"3 	c #BED0E1",
"4 	c #B1C6DB",
"5 	c #A3BCD5",
"6 	c #47535E",
"7 	c #F1F5F8",
"8 	c #F4F7FA",
"9 	c #070606",
"0 	c #E3C278",
"a 	c #C1D2E2",
"b 	c #B4C8DC",
"c 	c #A6BED6",
"d 	c #98B2CC",
"e 	c #1C1F22",
"f 	c #F9FAFC",
"g 	c #0C0B0B",
"h 	c #E6D2A2",
"i 	c #C2D3E3",
"j 	c #B4C9DC",
"k 	c #A6BFD6",
"l 	c #9DB8D2",
"m 	c #566573",
"n 	c #E5D5B2",
"o 	c #74899C",
"p 	c #1E2020",
"q 	c #E5C479",
"r 	c #EED9A8",
"s 	c #F2E1BC",
"t 	c #EDD5A0",
"u 	c #E3BF6F",
"v 	c #D9A636",
"w 	c #D1940C",
"x 	c #8CA4BB",
"y 	c #030303",
"z 	c #232425",
"A 	c #A9C1D7",
"B 	c #9FB9D3",
"C 	c #525252",
"D 	c #191D20",
"E 	c #434E5A",
"F 	c #080809",
"G 	c #ADACA8",
"H 	c #040405",
"I 	c #191919",
"J 	c #262625",
"K 	c #8BA3BA",
"L 	c #13161A",
"M 	c #050607",
"N 	c #1C1C1C",
"O 	c #737373",
"P 	c #252525",
"Q 	c #72716E",
"R 	c #131312",
"S 	c #050505",
"T 	c #262626",
"U 	c #727272",
"V 	c #272626",
"W 	c #2F2F2E",
"X 	c #090908",
"Y 	c #2F2F2F",
"Z 	c #6F6F6F",
"` 	c #2A2A29",
" .	c #5C5B59",
"..	c #080808",
"+.	c #3A3A3A",
"@.	c #6A6A6A",
"#.	c #323231",
"$.	c #8D8B88",
"%.	c #444444",
"&.	c #656565",
"*.	c #3D3D3C",
"=.	c #B3B1AD",
"-.	c #4E4E4E",
";.	c #585858",
">.	c #30302F",
",.	c #323232",
"        . + @ # $ % .                   ",
"      & * = - ; > , ' )                 ",
"    ! ~ { ] ^ / ( _ : < [               ",
"  & ~ } | 1 # 2 2 3 4 5 6 )             ",
". * { | 7 8 9 0 2 a b c d e .           ",
"+ = ] 1 8 f g h 2 i j k l m %           ",
"@ - ^ 2 2 2 2 n 2 2 2 2 l o p           ",
"# ; / 2 q r s t u v w 2 l x y           ",
"$ > ( 2 2 2 2 u 2 2 2 2 l o z           ",
"% , _ 3 a i 2 v 2 A B l l m C           ",
". ' : 4 b j 2 w 2 B l l d D .           ",
"  ) < 5 c k 2 2 2 l l l E F G           ",
"    [ 6 d l l l l l d E H I J           ",
"      ) e m o K o m L M 2 N O P         ",
"        . % p # p % Q R S 2 T U V       ",
"                        W X 2 Y Z `     ",
"                           ...2 +.@.#.  ",
"                            $...# %.&.*.",
"                              =.R S -.;.",
"                                  >.# ,."};

/* XPM */
static char * log_xpm[] = {
"16 14 4 1",
" 	c None",
".	c #000000",
"+	c #882F2A",
"@	c #FFFFFF",
"................",
".++++++++++++++.",
"................",
".@@@@@@@@@@@@@@.",
".@...@@...@@..@.",
".@@@@@@@@@@@@@@.",
".@............@.",
".@@@@@@@@@@@@@@.",
".@...@@...@@..@.",
".@@@@@@@@@@@@@@.",
".@...@@...@@..@.",
".@@@@@@@@@@@@@@.",
".@@@@@@@@@@@@@@.",
"................"};

static char *quit_xpm[]={
"32 32 170 2",
"Qt c None",
".c c #000000",
"#3 c #573700",
"a# c #5c3a00",
"#n c #5e3c00",
"ar c #623e00",
"#x c #633f00",
"#d c #664100",
".W c #694300",
"#m c #6b4400",
"an c #6c4500",
".P c #6d4600",
"#w c #704800",
"aG c #714800",
".G c #734a00",
"aK c #744a00",
".Y c #744b00",
".F c #774c00",
"#l c #774d00",
"am c #794e00",
".7 c #7a4f00",
".x c #7c5000",
"#c c #7f5200",
".d c #808080",
".X c #815400",
"#W c #845500",
".6 c #865700",
"af c #8f5d00",
"aN c #925f00",
"aL c #946000",
"aJ c #966200",
"aI c #996300",
"aM c #996400",
"aH c #9b6500",
"aF c #9d6700",
"aE c #a06800",
".b c #a0a0a4",
"aD c #a26a00",
"az c #a46c00",
"ay c #a76d00",
"aq c #a96f00",
"al c #ab7100",
"ae c #ae7200",
"#9 c #b07400",
"ax c #b1aeac",
"ak c #b27600",
"#1 c #b37600",
".q c #b47700",
"ap c #b4b0ad",
"aw c #b4b1ad",
"#V c #b57700",
".w c #b77900",
"ao c #b7b3ae",
"aj c #b7b3af",
"av c #b7b4af",
"#K c #ba7a00",
".p c #ba7b00",
"ai c #bab6b0",
"ad c #bbb6b1",
"au c #bbb7b1",
".E c #bc7b00",
"#I c #bc7c00",
"ah c #bdb9b2",
".v c #be7d00",
"#Q c #be7e00",
"ac c #beb9b2",
"#8 c #beb9b3",
"at c #bebab3",
"#v c #bf7e00",
".K c #c07f00",
".a c #c0c0c0",
"#k c #c17f00",
"#0 c #c1bcb4",
"as c #c2bdb5",
".D c #c38000",
"#H c #c38100",
".O c #c48100",
"#Z c #c4beb5",
"#7 c #c4bfb6",
"#U c #c5bfb6",
".J c #c68300",
"#Y c #c7c1b7",
".V c #c88400",
"#T c #c8c1b7",
"#6 c #c8c2b7",
"#P c #c8c2b8",
".N c #cb8600",
"#O c #cbc4b9",
"#5 c #cbc5b9",
"#J c #cbc5ba",
"ab c #ccc5ba",
".5 c #cd8800",
".U c #cf8900",
"#u c #cfc8bc",
"#j c #d2cabd",
"#i c #d5ccbe",
"#b c #d5cdbf",
"#a c #d8cfc0",
".4 c #d9d0c1",
".u c #dad2c1",
".C c #dbd2c1",
".o c #dbd2c2",
"aA c #dc9200",
".3 c #dcd2c2",
".T c #dcd3c2",
".n c #ded5c3",
".S c #dfd5c3",
".I c #dfd5c4",
".t c #e1d8c5",
".m c #e2d8c5",
".2 c #e3d8c5",
".H c #e3d8c6",
".l c #e5dbc7",
".B c #e6dbc7",
".A c #e9dec8",
".k c #e9dec9",
".s c #ece1ca",
".z c #ede1ca",
".j c #ede1cb",
".i c #f0e4cc",
".M c #f1e4cc",
".r c #f3e7ce",
".h c #f4e7ce",
".g c #f7ead0",
".y c #f8ead0",
".f c #fbedd2",
"ag c #ff2700",
"aa c #ff2d00",
"#4 c #ff3400",
"#X c #ff3b00",
"#S c #ff4200",
"#N c #ff4800",
"#R c #ff4900",
"#M c #ff4f00",
"#G c #ff5000",
"#F c #ff5600",
"#L c #ff5c00",
"#E c #ff5d00",
"#t c #ff6300",
"#D c #ff6400",
"#s c #ff6a00",
"#r c #ff7100",
"#h c #ff7700",
"#C c #ff7800",
"#g c #ff7e00",
"#B c #ff7f00",
"#f c #ff8400",
"#q c #ff8500",
"#e c #ff8b00",
"## c #ff8c00",
"#. c #ff9200",
"#A c #ff9300",
".9 c #ff9900",
".1 c #ff9f00",
".8 c #ffa000",
".0 c #ffa600",
"#z c #ffa700",
".Z c #ffad00",
"#y c #ffae00",
".R c #ffb300",
"#p c #ffb400",
"aB c #ffb848",
".Q c #ffba00",
"#o c #ffbb00",
".L c #ffc800",
"aC c #ffe2b1",
".e c #fff0d4",
".# c #fffbf0",
"a. c #ffff8e",
"#2 c #ffffb1",
"QtQtQtQtQtQtQtQtQtQtQt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.aQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.c.e.f.g.h.i.j.k.l.m.n.o.c.p.q.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.c.f.g.r.i.s.k.l.t.n.u.c.v.w.x.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.c.y.h.i.z.A.B.m.n.C.c.D.E.F.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.c.#.c.h.i.z.k.B.H.I.o.c.J.K.G.G.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.L.c.c.M.z.A.B.m.I.o.c.N.O.P.G.x.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.Q.R.c.j.k.B.m.S.T.c.U.V.W.G.X.Y.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.Z.0.1.c.B.2.I.3.4.c.5.J.G.6.7.P.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.8.9#.##.c.S.o#a#b.c.N.O.G#c.G#d.G.c.a.dQtQt",
"QtQt.c.c.c.c.c.c.c.c#.#e#f#g#h.c#a#i#j.c.V#k.G#l#m#n.G.c.a.dQtQt",
"Qt.c#o#p.Z.0.8.9#.###q#g#h#r#s#t.c#j#u.c.J#v.G#w#x.G.x.c.a.dQtQt",
"Qt.c#y#z.8.9#A###q#B#C#r#s#D#E#F#G.c#u.c#H#I.G.W.G.X.Y.c.a.dQtQt",
"Qt.c#y#z.8.9#A###q#B#C#r#s#D#E#F#G.c#J.c#k#K.G.G.7.7.P.c.a.dQtQt",
"Qt.c.8.9#.#e#q#g#h#r#s#t#L#F#M#N.c#O#P.c#Q.w.G#c.G.G#d.c.a.dQtQt",
"QtQt.c.c.c.c.c.c.c.c#E#F#M#R#S.c#O#T#U.c#I#V#W.c.c#m#n.c.a.dQtQt",
"QtQtQt.b.b.b.b.b.b.c#M#N#S#X.c#O#Y#Z#0.c.p#1.c#2.c#x#3.c.a.dQtQt",
"QtQtQtQt.b.b.b.b.b.c#S#X#4.c#5#6#7#0#8.c.w#9.ca..ca#.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c#4aa.cab#P#U#0acad.c#Vaeaf.c.c.G.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.cag.c.c#P#7#0ahaiaj.cakalaman.G.x.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQt.c.c.a.c#U#0acaiaoap.c#9aqar.G.X.Y.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.a.casatauavawax.caeay.G.6.7.P.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.c.c.c.c.c.c.c.calaz.G#c.G#d.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.caAaAaBaBaCaC.caqaD.G#l#m#n.G.c.a.dQtQt",
"QtQtQtQtQtQtQtQtQtQt.b.#.caBaBaCaCaCaB.cayaE.G#w#x.G.x.c.a.dQtQt",
".c.c.c.c.c.c.c.c.c.c.c.c.caCaCaCaBaBaC.cazaF.G.W.G.FaG.c.c.c.c.c",
"aBaCaCaCaBaBaCaCaCaBaBaCaCaCaBaBaCaCaC.caDaH.G.G.Gan.caAaAaBaBaC",
"aCaCaBaBaCaCaCaBaBaCaCaCaBaBaCaCaCaBaB.caEaI.Gam.G.caAaBaBaCaCaC",
"aBaBaCaCaCaBaBaCaCaCaBaBaCaCaCaBaBaCaC.caFaJaK.P.caBaBaCaCaCaBaB",
"aCaCaCaBaBaCaCaCaBaBaCaCaCaBaBaCaCaCaB.caHaL.W.caBaCaCaCaBaBaCaC",
"aCaCaBaCaCaCaBaBaCaCaCaBaBaCaCaCaBaBaC.caMaN.caCaCaCaBaBaCaCQtQt",
"QtQtQtaCaBaBaCaCaCaBaBaCaCaCaBaBaCaCaC.c.c.caCaCaBaBaCaCQtQtQtQt"};

/* XPM */
static char * qtiplot_logo_xpm[] = {
"64 64 1304 2",
"  	c None",
". 	c #4A81AE",
"+ 	c #457798",
"@ 	c #487690",
"# 	c #5E89AC",
"$ 	c #7096BC",
"% 	c #88A5C4",
"& 	c #82A0C2",
"* 	c #608CB1",
"= 	c #447EAE",
"- 	c #4A80AA",
"; 	c #628CB0",
"> 	c #84A2C3",
", 	c #94AECA",
"' 	c #9EB6CD",
") 	c #A8BED0",
"! 	c #A4BACF",
"~ 	c #98B1CB",
"{ 	c #88A4C4",
"] 	c #6791B9",
"^ 	c #5589B1",
"/ 	c #5C89AB",
"( 	c #789DBF",
"_ 	c #95AEC9",
": 	c #A2B9CE",
"< 	c #AEC2D2",
"[ 	c #B8CAD6",
"} 	c #BFD0D9",
"| 	c #C6D4DC",
"1 	c #C3D2DB",
"2 	c #BACCD7",
"3 	c #ABC0D2",
"4 	c #9CB4CD",
"5 	c #8AA6C6",
"6 	c #6C94BA",
"7 	c #5386B2",
"8 	c #125E96",
"9 	c #538AB1",
"0 	c #588CB4",
"a 	c #B1C8D6",
"b 	c #C8D6DE",
"c 	c #D0DCE2",
"d 	c #D7E2E6",
"e 	c #DCE5E9",
"f 	c #E1E8EC",
"g 	c #DEE6EA",
"h 	c #D4DFE4",
"i 	c #C4D3DC",
"j 	c #B4C7D5",
"k 	c #9AB3CC",
"l 	c #5385B1",
"m 	c #4883B0",
"n 	c #20689E",
"o 	c #19639C",
"p 	c #D8E2E6",
"q 	c #B4CBD8",
"r 	c #5990B6",
"s 	c #6C9FC0",
"t 	c #D7E4EB",
"u 	c #F0F3F4",
"v 	c #F1F3F5",
"w 	c #F4F6F7",
"x 	c #EEF2F3",
"y 	c #E4EAED",
"z 	c #6F9CBC",
"A 	c #548CB4",
"B 	c #A8C5D6",
"C 	c #4178A1",
"D 	c #186299",
"E 	c #C5D4DC",
"F 	c #AEC6D4",
"G 	c #5E92B8",
"H 	c #76A5C5",
"I 	c #E2ECF2",
"J 	c #FCFCFC",
"K 	c #D9E4EB",
"L 	c #719FC0",
"M 	c #5C92B7",
"N 	c #A5C1D2",
"O 	c #C8D7DE",
"P 	c #40749D",
"Q 	c #6C8097",
"R 	c #166099",
"S 	c #B5C8D5",
"T 	c #A7BFD2",
"U 	c #6092B8",
"V 	c #518AB4",
"W 	c #5F92B8",
"X 	c #A8BFD2",
"Y 	c #B9CAD6",
"Z 	c #45769D",
"` 	c #748498",
" .	c #146098",
"..	c #A7BCCF",
"+.	c #1E689F",
"@.	c #AABFD1",
"#.	c #48789E",
"$.	c #7A8A99",
"%.	c #125E97",
"&.	c #9AB2CC",
"*.	c #1C669E",
"=.	c #9EB4CC",
"-.	c #48779C",
";.	c #7B8A99",
">.	c #105D96",
",.	c #8FAAC8",
"'.	c #1A649C",
").	c #91ACC9",
"!.	c #47769C",
"~.	c #105C96",
"{.	c #84A2C4",
"].	c #18639A",
"^.	c #86A2C4",
"/.	c #46759B",
"(.	c #7A9ABE",
"_.	c #16619A",
":.	c #7D9CBF",
"<.	c #45749A",
"[.	c #0F5A94",
"}.	c #6E93B8",
"|.	c #146099",
"1.	c #7294BA",
"2.	c #44739A",
"3.	c #648EB6",
"4.	c #125E98",
"5.	c #678FB6",
"6.	c #437299",
"7.	c #0E5892",
"8.	c #5B88B1",
"9.	c #5C88B2",
"0.	c #105E97",
"a.	c #5E89B2",
"b.	c #427298",
"c.	c #87A772",
"d.	c #98BF90",
"e.	c #8FB07D",
"f.	c #267A7C",
"g.	c #5080A4",
"h.	c #5281AA",
"i.	c #5483AE",
"j.	c #5484AF",
"k.	c #5484B0",
"l.	c #5685B0",
"m.	c #407198",
"n.	c #7A985E",
"o.	c #99BF94",
"p.	c #B6D6B5",
"q.	c #D2E3CD",
"r.	c #D0E1CA",
"s.	c #C6DCBF",
"t.	c #AACFA8",
"u.	c #6AAB86",
"v.	c #408683",
"w.	c #487C9C",
"x.	c #4B7DA6",
"y.	c #4C7EAA",
"z.	c #4D7FAE",
"A.	c #4E7FAE",
"B.	c #0F5C96",
"C.	c #5080AE",
"D.	c #407098",
"E.	c #7BB17B",
"F.	c #AAC7A2",
"G.	c #DAE8D8",
"H.	c #E6EEE1",
"I.	c #E6EDE1",
"J.	c #E4ECDE",
"K.	c #E0EADA",
"L.	c #D6E4D0",
"M.	c #CADEC3",
"N.	c #BBD7B3",
"O.	c #A4CB9F",
"P.	c #67AC81",
"Q.	c #3E887E",
"R.	c #407896",
"S.	c #4479A3",
"T.	c #467AA8",
"U.	c #0D5B94",
"V.	c #487CAD",
"W.	c #487CAE",
"X.	c #326FA4",
"Y.	c #155C95",
"Z.	c #3D76A8",
"`.	c #3F7097",
" +	c #489349",
".+	c #7EBC88",
"++	c #DFEAD9",
"@+	c #E5EDDF",
"#+	c #EAF0E7",
"$+	c #EEF2EA",
"%+	c #F0F4ED",
"&+	c #F0F4EC",
"*+	c #EDF2EA",
"=+	c #DCE8D6",
"-+	c #D0E1CB",
";+	c #C3DABB",
">+	c #B2D3AA",
",+	c #9FC99A",
"'+	c #56A770",
")+	c #2F7D74",
"!+	c #3C7398",
"~+	c #085A91",
"{+	c #447AAB",
"]+	c #4479AB",
"^+	c #4278AA",
"/+	c #0D5690",
"(+	c #0B538D",
"_+	c #125992",
":+	c #3E6E96",
"<+	c #7C8A9A",
"[+	c #33A056",
"}+	c #93C9A0",
"|+	c #58B071",
"1+	c #9ECDA6",
"2+	c #E2ECDD",
"3+	c #EEF3EB",
"4+	c #F6F8F3",
"5+	c #F7F8F6",
"6+	c #F6F8F4",
"7+	c #F0F4EE",
"8+	c #EAF0E6",
"9+	c #CEE0C8",
"0+	c #A2CDA1",
"a+	c #5CAF70",
"b+	c #8AC59A",
"c+	c #328361",
"d+	c #30687E",
"e+	c #035687",
"f+	c #3D75A6",
"g+	c #3F76A8",
"h+	c #4076A8",
"i+	c #2B6BA1",
"j+	c #3B6B92",
"k+	c #7C8C9B",
"l+	c #35A058",
"m+	c #DAE7D4",
"n+	c #D8E6D2",
"o+	c #92C89D",
"p+	c #5FB276",
"q+	c #A4D0AD",
"r+	c #FAFCF9",
"s+	c #FDFDFB",
"t+	c #F8F9F6",
"u+	c #F2F4EE",
"v+	c #BEDBC1",
"w+	c #71B982",
"x+	c #8EC69A",
"y+	c #DAE8D5",
"z+	c #307E5B",
"A+	c #255B6A",
"B+	c #04527B",
"C+	c #3771A2",
"D+	c #3C72A7",
"E+	c #1C5F97",
"F+	c #0C538D",
"G+	c #3C6B92",
"H+	c #7F8E9C",
"I+	c #CCE0C7",
"J+	c #CCDFC7",
"K+	c #95C89D",
"L+	c #64B479",
"M+	c #A5D2AF",
"N+	c #F4F7F2",
"O+	c #C0DFC7",
"P+	c #76BC88",
"Q+	c #8EC698",
"R+	c #2C7B59",
"S+	c #1E5565",
"T+	c #045076",
"U+	c #336E9E",
"V+	c #3870A5",
"W+	c #3870A6",
"X+	c #3D6C92",
"Y+	c #81909D",
"Z+	c #448F57",
"`+	c #C0D8B8",
" @	c #98C89A",
".@	c #32A053",
"+@	c #91C497",
"@@	c #C2DABA",
"#@	c #C2DABB",
"$@	c #2A795A",
"%@	c #1E5468",
"&@	c #2F6C9C",
"*@	c #356EA4",
"=@	c #2A69A0",
"-@	c #0C548E",
";@	c #3E6D93",
">@	c #82919E",
",@	c #747066",
"'@	c #838785",
")@	c #619F75",
"!@	c #B4D4AC",
"~@	c #33A053",
"{@	c #B7D4AD",
"]@	c #28795A",
"^@	c #165168",
"/@	c #034E76",
"(@	c #2B6A9B",
"_@	c #326CA2",
":@	c #1A6098",
"<@	c #0A558F",
"[@	c #3C6C92",
"}@	c #808E9C",
"|@	c #877861",
"1@	c #717069",
"2@	c #8B8E8D",
"3@	c #B1B5B5",
"4@	c #B8BEBC",
"5@	c #6AAA7F",
"6@	c #A8CEA0",
"7@	c #309F50",
"8@	c #AACFA2",
"9@	c #26785A",
"0@	c #084863",
"a@	c #024D75",
"b@	c #146094",
"c@	c #2D6AA0",
"d@	c #0B5891",
"e@	c #0A568F",
"f@	c #38688D",
"g@	c #788693",
"h@	c #7C7262",
"i@	c #7C786E",
"j@	c #949898",
"k@	c #B6BABA",
"l@	c #BABEBE",
"m@	c #B8BEBD",
"n@	c #B5BAB9",
"o@	c #69A87C",
"p@	c #9AC796",
"q@	c #2E9E4E",
"r@	c #9EC998",
"s@	c #1A7255",
"t@	c #02435F",
"u@	c #024E75",
"v@	c #03568C",
"w@	c #0C5A94",
"x@	c #0A5792",
"y@	c #245478",
"z@	c #525E67",
"A@	c #726E64",
"B@	c #7C7B75",
"C@	c #9C9F9F",
"D@	c #B8BDBC",
"E@	c #B6BCBB",
"F@	c #B4BAB9",
"G@	c #B1B7B6",
"H@	c #65A67A",
"I@	c #90C28E",
"J@	c #2E9E4D",
"K@	c #93C390",
"L@	c #187154",
"M@	c #024460",
"N@	c #024F76",
"O@	c #02578D",
"P@	c #085893",
"Q@	c #085894",
"R@	c #306286",
"S@	c #56626D",
"T@	c #4B5861",
"U@	c #80807C",
"V@	c #A3A7A6",
"W@	c #BCBFBF",
"X@	c #B7BCBB",
"Y@	c #B5BBB9",
"Z@	c #B2B8B7",
"`@	c #B1B6B6",
" #	c #ACB2B2",
".#	c #63A477",
"+#	c #86BD86",
"@#	c #2B9D4C",
"##	c #8ABE88",
"$#	c #177254",
"%#	c #024661",
"&#	c #025076",
"*#	c #02588E",
"=#	c #085A94",
"-#	c #095A94",
";#	c #316288",
">#	c #667380",
",#	c #7D8B98",
"'#	c #848B90",
")#	c #6F7271",
"!#	c #767165",
"~#	c #838684",
"{#	c #AAADAE",
"]#	c #BDC0C0",
"^#	c #BBBFBF",
"/#	c #B9BEBE",
"(#	c #B7BDBC",
"_#	c #B3B9B8",
":#	c #AFB4B4",
"<#	c #ABB0B1",
"[#	c #A8ADAD",
"}#	c #60A074",
"|#	c #7BB87C",
"1#	c #51A962",
"2#	c #6CB273",
"3#	c #7EB87E",
"4#	c #2A9C4B",
"5#	c #80BA80",
"6#	c #7BB87D",
"7#	c #68B272",
"8#	c #167254",
"9#	c #024762",
"0#	c #035278",
"a#	c #025A90",
"b#	c #075C96",
"c#	c #306288",
"d#	c #657280",
"e#	c #7E8C98",
"f#	c #A7B0B3",
"g#	c #B5BABA",
"h#	c #909393",
"i#	c #71726B",
"j#	c #737068",
"k#	c #888C8B",
"l#	c #B0B4B4",
"m#	c #B0B5B5",
"n#	c #A9AFAF",
"o#	c #A6AAAB",
"p#	c #A2A7A6",
"q#	c #5D9D70",
"r#	c #3DA256",
"s#	c #1D9540",
"t#	c #299A48",
"u#	c #76B677",
"v#	c #289C4A",
"w#	c #78B77A",
"x#	c #389F52",
"y#	c #4EA860",
"z#	c #167253",
"A#	c #034863",
"B#	c #025378",
"C#	c #025C92",
"D#	c #085D96",
"E#	c #085E96",
"F#	c #2E6288",
"G#	c #63717E",
"H#	c #7D8A96",
"I#	c #A6AEB2",
"J#	c #B6B8B9",
"K#	c #8B8F8E",
"L#	c #686C6B",
"M#	c #807562",
"N#	c #7D7669",
"O#	c #8E9392",
"P#	c #B6B9B8",
"Q#	c #BCC0C0",
"R#	c #B6BBBA",
"S#	c #B4B9B8",
"T#	c #AEB4B4",
"U#	c #AAAFB0",
"V#	c #A8ACAD",
"W#	c #A4A9A9",
"X#	c #A1A5A5",
"Y#	c #9DA1A0",
"Z#	c #57986B",
"`#	c #1E9641",
" $	c #1D9641",
".$	c #56AA64",
"+$	c #6EB273",
"@$	c #279B48",
"#$	c #70B374",
"$$	c #62AE6C",
"%$	c #1E9642",
"&$	c #127151",
"*$	c #044966",
"=$	c #04547A",
"-$	c #065E94",
";$	c #0D6098",
">$	c #0E6098",
",$	c #2E6286",
"'$	c #616E7B",
")$	c #7A8895",
"!$	c #A3ACB0",
"~$	c #B6BCBC",
"{$	c #BEC2C0",
"]$	c #B4B8B7",
"^$	c #8A8E8E",
"/$	c #767064",
"($	c #7C7A72",
"_$	c #999D9C",
":$	c #BABFBE",
"<$	c #A9AEAE",
"[$	c #A6AAAA",
"}$	c #A2A7A7",
"|$	c #9FA3A4",
"1$	c #9DA0A0",
"2$	c #989C9C",
"3$	c #549668",
"4$	c #1F9641",
"5$	c #1F9642",
"6$	c #3CA154",
"7$	c #68B06E",
"8$	c #259B48",
"9$	c #6AB06F",
"0$	c #44A459",
"a$	c #127152",
"b$	c #0A4C6B",
"c$	c #095781",
"d$	c #116096",
"e$	c #1A629C",
"f$	c #2F6286",
"g$	c #5E6C78",
"h$	c #778491",
"i$	c #A0A8AC",
"j$	c #B4BABA",
"k$	c #BEC1C0",
"l$	c #9CA0A0",
"m$	c #8A8D8E",
"n$	c #7C7C76",
"o$	c #A2A6A4",
"p$	c #AEB3B4",
"q$	c #ABB0B0",
"r$	c #A1A6A5",
"s$	c #9EA2A2",
"t$	c #9C9D9C",
"u$	c #A9817E",
"v$	c #9C8480",
"w$	c #529062",
"x$	c #1F9440",
"y$	c #209541",
"z$	c #209641",
"A$	c #279A46",
"B$	c #64AE6A",
"C$	c #259A46",
"D$	c #2E9C4A",
"E$	c #209642",
"F$	c #177256",
"G$	c #135075",
"H$	c #0E598A",
"I$	c #1D629A",
"J$	c #22649C",
"K$	c #326186",
"L$	c #5C6A75",
"M$	c #74818E",
"N$	c #9DA5A9",
"O$	c #B1B7B7",
"P$	c #808484",
"Q$	c #A3A8A8",
"R$	c #8C7C62",
"S$	c #9A9F9E",
"T$	c #BFC3C0",
"U$	c #B6BCBA",
"V$	c #AEB2B4",
"W$	c #AAB0B0",
"X$	c #A7ACAC",
"Y$	c #A4A8A8",
"Z$	c #A0A4A4",
"`$	c #A2928F",
" %	c #BB8A82",
".%	c #DB9C8C",
"+%	c #ECBEA8",
"@%	c #E4A690",
"#%	c #A67A5B",
"$%	c #4B7437",
"%%	c #258C3E",
"&%	c #239340",
"*%	c #229642",
"=%	c #56A860",
"-%	c #5DAB66",
";%	c #249A46",
">%	c #5EAC67",
",%	c #5CAB65",
"'%	c #239843",
")%	c #229842",
"!%	c #1B7458",
"~%	c #1C547E",
"{%	c #185C90",
"]%	c #29669D",
"^%	c #2C689F",
"/%	c #336285",
"(%	c #5B6873",
"_%	c #727F8B",
":%	c #99A2A6",
"<%	c #B3B8B8",
"[%	c #787C7C",
"}%	c #9DA1A2",
"|%	c #B5BBBA",
"1%	c #B0B5B6",
"2%	c #ADB2B2",
"3%	c #AAAFAF",
"4%	c #A4A6A6",
"5%	c #B08B88",
"6%	c #CE9D94",
"7%	c #EAC1B1",
"8%	c #EFD7C6",
"9%	c #EED4C2",
"0%	c #EED1BD",
"a%	c #EDC6B1",
"b%	c #EAB79F",
"c%	c #DF9E84",
"d%	c #AC7452",
"e%	c #5D6E38",
"f%	c #2C8A3D",
"g%	c #439C50",
"h%	c #59A75F",
"i%	c #59A962",
"j%	c #289A47",
"k%	c #5BAA63",
"l%	c #49A458",
"m%	c #249844",
"n%	c #20765A",
"o%	c #255782",
"p%	c #205F94",
"q%	c #316AA0",
"r%	c #356286",
"s%	c #5A6772",
"t%	c #6F7C88",
"u%	c #969EA2",
"v%	c #AAB0B1",
"w%	c #B0B6B6",
"x%	c #767A7A",
"y%	c #9A9E9E",
"z%	c #8B7C62",
"A%	c #B0B4B5",
"B%	c #AAA09F",
"C%	c #BF928D",
"D%	c #DFACA1",
"E%	c #F0DCCF",
"F%	c #F3E4D8",
"G%	c #F4E6DA",
"H%	c #F4E7DE",
"I%	c #F2E4D9",
"J%	c #F2E0D3",
"K%	c #EED5C2",
"L%	c #EECAB6",
"M%	c #EBBEA7",
"N%	c #E6AC93",
"O%	c #DF967B",
"P%	c #BB7152",
"Q%	c #756D3E",
"R%	c #599250",
"S%	c #489C51",
"T%	c #269744",
"U%	c #50A55C",
"V%	c #57A860",
"W%	c #3A9F4F",
"X%	c #289A45",
"Y%	c #25785B",
"Z%	c #2E5B83",
"`%	c #286397",
" &	c #3870A4",
".&	c #3A72A6",
"+&	c #386488",
"@&	c #586672",
"#&	c #6E7C88",
"$&	c #959CA1",
"%&	c #B9BEBD",
"&&	c #9CA09F",
"*&	c #BA6461",
"=&	c #D85E57",
"-&	c #E4A696",
";&	c #EFD8C8",
">&	c #F3E5DA",
",&	c #F4EBE4",
"'&	c #F7F0EA",
")&	c #F7EFE9",
"!&	c #F6EDE6",
"~&	c #EFDBCB",
"{&	c #EECFBC",
"]&	c #ECC2AC",
"^&	c #E9B098",
"/&	c #DE8872",
"(&	c #D45146",
"_&	c #8C4E32",
":&	c #397F3C",
"<&	c #2D9041",
"[&	c #369C4A",
"}&	c #4AA357",
"|&	c #2F9C47",
"1&	c #2E9C46",
"2&	c #29795C",
"3&	c #365F86",
"4&	c #2E6798",
"5&	c #4074A7",
"6&	c #4177A9",
"7&	c #396688",
"8&	c #586670",
"9&	c #949BA0",
"0&	c #A8ACAE",
"a&	c #AEB2B3",
"b&	c #9B9F9E",
"c&	c #B2B6B6",
"d&	c #A7ACAD",
"e&	c #A5A9A9",
"f&	c #BC6E68",
"g&	c #EECEBA",
"h&	c #E08578",
"i&	c #D66057",
"j&	c #E6A99D",
"k&	c #F4E8DE",
"l&	c #F8F2EE",
"m&	c #FAF7F3",
"n&	c #FAF6F3",
"o&	c #F4E9DF",
"p&	c #EFD9C8",
"q&	c #E7AE9C",
"r&	c #DA655A",
"s&	c #DF8478",
"t&	c #EED1C0",
"u&	c #874933",
"v&	c #3A6732",
"w&	c #36823D",
"x&	c #359746",
"y&	c #349D49",
"z&	c #349E49",
"A&	c #2D7C5E",
"B&	c #3D6487",
"C&	c #356C9A",
"D&	c #497AA9",
"E&	c #4A7DAE",
"F&	c #3C688A",
"G&	c #6E7B87",
"H&	c #ACB0B1",
"I&	c #A8AEAE",
"J&	c #A6AAAC",
"K&	c #A4A7A8",
"L&	c #BA6A64",
"M&	c #ECC0AA",
"N&	c #ECBEA7",
"O&	c #DF8374",
"P&	c #D8665E",
"Q&	c #E8ADA8",
"R&	c #FAF6F2",
"S&	c #FEFCFA",
"T&	c #FAF5F2",
"U&	c #ECC5BE",
"V&	c #DC766C",
"W&	c #DF8375",
"X&	c #ECC0AB",
"Y&	c #ECC4B0",
"Z&	c #854430",
"`&	c #3B5C2E",
" *	c #3A793A",
".*	c #3C9647",
"+*	c #3B9E4C",
"@*	c #3A9E4D",
"#*	c #317F5F",
"$*	c #446889",
"%*	c #3B709C",
"&*	c #5280AC",
"**	c #5483B0",
"=*	c #426C8F",
"-*	c #5D6A76",
";*	c #6E7B88",
">*	c #939A9E",
",*	c #A6ABAC",
"'*	c #B7BCBC",
")*	c #75797A",
"!*	c #999E9E",
"~*	c #ABB1B1",
"{*	c #A8ADAE",
"]*	c #A3A7A7",
"^*	c #BA6761",
"/*	c #E7AC92",
"(*	c #E2917C",
"_*	c #E6A78E",
":*	c #E7AB92",
"<*	c #DE8370",
"[*	c #D8665B",
"}*	c #E59B97",
"|*	c #DC756D",
"1*	c #DE7E6D",
"2*	c #E8B097",
"3*	c #E9B298",
"4*	c #E9B198",
"5*	c #864630",
"6*	c #3C5E30",
"7*	c #3E773B",
"8*	c #42964A",
"9*	c #43A050",
"0*	c #42A051",
"a*	c #368262",
"b*	c #4C6D8D",
"c*	c #42759E",
"d*	c #5C88B0",
"e*	c #5F8AB3",
"f*	c #386283",
"g*	c #56626E",
"h*	c #798693",
"i*	c #98A0A5",
"j*	c #A6ACAC",
"k*	c #A6A9AA",
"l*	c #A2A6A6",
"m*	c #B9645E",
"n*	c #D86857",
"o*	c #C92623",
"p*	c #D1483F",
"q*	c #E1987E",
"r*	c #CE3430",
"s*	c #E29C83",
"t*	c #D65E52",
"u*	c #CB2B28",
"v*	c #DC806C",
"w*	c #874830",
"x*	c #406234",
"y*	c #43783D",
"z*	c #48964E",
"A*	c #49A155",
"B*	c #4AA256",
"C*	c #3B8564",
"D*	c #547390",
"E*	c #4C7BA1",
"F*	c #6A8FB4",
"G*	c #6C93B8",
"H*	c #658FB6",
"I*	c #45769C",
"J*	c #4C6373",
"K*	c #4D5963",
"L*	c #556069",
"M*	c #939B9E",
"N*	c #B2B7B7",
"O*	c #B2B7B6",
"P*	c #757979",
"Q*	c #999D9D",
"R*	c #A7ABAD",
"S*	c #A3A6A6",
"T*	c #B9615C",
"U*	c #CA2825",
"V*	c #DD7962",
"W*	c #E0886D",
"X*	c #CE322E",
"Y*	c #E08C70",
"Z*	c #DE836A",
"`*	c #CA2724",
" =	c #CC312C",
".=	c #88472F",
"+=	c #446437",
"@=	c #497A40",
"#=	c #509A52",
"$=	c #52A65B",
"%=	c #52A65C",
"&=	c #418867",
"*=	c #5F7A96",
"==	c #5582A4",
"-=	c #7A98BB",
";=	c #7C9BBE",
">=	c #7999BE",
",=	c #517EA5",
"'=	c #4A687C",
")=	c #5E676B",
"!=	c #5B676E",
"~=	c #616E79",
"{=	c #76818B",
"]=	c #7A7F82",
"^=	c #7E8283",
"/=	c #ABB0AF",
"(=	c #B4BAB8",
"_=	c #747979",
":=	c #ACB1B1",
"<=	c #949797",
"[=	c #A44B47",
"}=	c #CA2623",
"|=	c #D45141",
"1=	c #DE7C5E",
"2=	c #CE312B",
"3=	c #E07E62",
"4=	c #D65847",
"5=	c #CA2624",
"6=	c #88462E",
"7=	c #4A693B",
"8=	c #4E7D43",
"9=	c #599D59",
"0=	c #5AAA62",
"a=	c #5CAA64",
"b=	c #488C6B",
"c=	c #6A829B",
"d=	c #6088AA",
"e=	c #86A2C2",
"f=	c #88A4C5",
"g=	c #5D88AE",
"h=	c #4A6B82",
"i=	c #5E686C",
"j=	c #5E686E",
"k=	c #5F6C73",
"l=	c #66727C",
"m=	c #747E89",
"n=	c #8A9297",
"o=	c #9CA1A2",
"p=	c #9CA2A1",
"q=	c #7F8383",
"r=	c #878B8B",
"s=	c #B4B7B7",
"t=	c #AFB3B4",
"u=	c #ACB1B2",
"v=	c #969B9B",
"w=	c #7B7E7E",
"x=	c #939696",
"y=	c #BA605C",
"z=	c #CA2824",
"A=	c #CE382F",
"B=	c #DA7256",
"C=	c #CD2F29",
"D=	c #DC7458",
"E=	c #CF3C32",
"F=	c #CA2723",
"G=	c #8B4730",
"H=	c #506C40",
"I=	c #548048",
"J=	c #63A060",
"K=	c #66AE6A",
"L=	c #67B06C",
"M=	c #367959",
"N=	c #456681",
"O=	c #658BAC",
"P=	c #6B93B4",
"Q=	c #4C6F86",
"R=	c #5E686D",
"S=	c #5E696E",
"T=	c #606B73",
"U=	c #65727B",
"V=	c #717C86",
"W=	c #808991",
"X=	c #90969B",
"Y=	c #A1A7A6",
"Z=	c #A2A8A7",
"`=	c #A4A9A8",
" -	c #7C8180",
".-	c #8F9392",
"+-	c #969A9A",
"@-	c #76797A",
"#-	c #999C9D",
"$-	c #7C8080",
"%-	c #B0B3B2",
"&-	c #BC625C",
"*-	c #CC2B24",
"=-	c #CC2C24",
"--	c #D8664C",
";-	c #D8694E",
">-	c #CC2C28",
",-	c #D86A50",
"'-	c #D8694F",
")-	c #CC2C26",
"!-	c #CC2A24",
"~-	c #8E4933",
"{-	c #587046",
"]-	c #5B844D",
"^-	c #6DA468",
"/-	c #71B273",
"(-	c #71B474",
"_-	c #48805B",
":-	c #4D5860",
"<-	c #405E74",
"[-	c #556670",
"}-	c #5E696F",
"|-	c #65717A",
"1-	c #6F7A84",
"2-	c #7E8890",
"3-	c #8E969A",
"4-	c #9AA0A1",
"5-	c #A1A4A6",
"6-	c #959A9A",
"7-	c #666A69",
"8-	c #777B7B",
"9-	c #9EA2A3",
"0-	c #B1B4B4",
"a-	c #BE645D",
"b-	c #CC3026",
"c-	c #D4513D",
"d-	c #D76048",
"e-	c #CC2F28",
"f-	c #D76249",
"g-	c #D45540",
"h-	c #CC2E26",
"i-	c #924C36",
"j-	c #5F724A",
"k-	c #628652",
"l-	c #7AA970",
"m-	c #7EB87D",
"n-	c #7FBA7F",
"o-	c #68AF71",
"p-	c #527B61",
"q-	c #5F6A6E",
"r-	c #647078",
"s-	c #67747C",
"t-	c #6A7680",
"u-	c #707C86",
"v-	c #7D878F",
"w-	c #8D9499",
"x-	c #9A9FA2",
"y-	c #A0A6A6",
"z-	c #A4A9AA",
"A-	c #85898A",
"B-	c #696E6E",
"C-	c #737778",
"D-	c #7D8181",
"E-	c #9B9F9F",
"F-	c #BABDBD",
"G-	c #B1B5B4",
"H-	c #BF665E",
"I-	c #CD382A",
"J-	c #D14432",
"K-	c #D65942",
"L-	c #D6563F",
"M-	c #CC3328",
"N-	c #D65741",
"O-	c #D65A43",
"P-	c #D14634",
"Q-	c #CD3628",
"R-	c #974E3A",
"S-	c #687651",
"T-	c #6B8958",
"U-	c #86AE7A",
"V-	c #8BBE88",
"W-	c #8CBE8A",
"X-	c #7AB87E",
"Y-	c #599267",
"Z-	c #5E7266",
"`-	c #66706C",
" ;	c #6D7A76",
".;	c #7C8787",
"+;	c #848E92",
"@;	c #899196",
"#;	c #90979B",
"$;	c #999FA2",
"%;	c #A1A6A6",
"&;	c #A8ACAC",
"*;	c #898D8D",
"=;	c #6A6F6F",
"-;	c #707575",
";;	c #808485",
">;	c #949798",
",;	c #ABAEAC",
"';	c #9EA2A1",
");	c #B3B8B6",
"!;	c #C06760",
"~;	c #D04230",
"{;	c #D04331",
"];	c #D4503B",
"^;	c #D24835",
"/;	c #CE3A2C",
"(;	c #D24936",
"_;	c #D5543E",
":;	c #D0402E",
"<;	c #9B513E",
"[;	c #727958",
"};	c #748C5F",
"|;	c #95B685",
"1;	c #9BC695",
"2;	c #8EC28E",
"3;	c #629D70",
"4;	c #5A7665",
"5;	c #666F6B",
"6;	c #66746C",
"7;	c #6C7B72",
"8;	c #7A8A80",
"9;	c #909A95",
"0;	c #9CA2A2",
"a;	c #A0A4A6",
"b;	c #A3A7A8",
"c;	c #A5A9AA",
"d;	c #AAAEAF",
"e;	c #8D9191",
"f;	c #6C7070",
"g;	c #707475",
"h;	c #808585",
"i;	c #A9ADAC",
"j;	c #B2B4B2",
"k;	c #6B6B65",
"l;	c #828583",
"m;	c #AFB3B2",
"n;	c #B6BAB8",
"o;	c #C16C64",
"p;	c #D34C38",
"q;	c #D14332",
"r;	c #D24A36",
"s;	c #D34A36",
"t;	c #8E4A36",
"u;	c #6A7654",
"v;	c #7F9266",
"w;	c #9EBB8D",
"x;	c #70A878",
"y;	c #587A65",
"z;	c #66726C",
"A;	c #6A7970",
"B;	c #74847A",
"C;	c #829187",
"D;	c #929C96",
"E;	c #9FA6A4",
"F;	c #A5AAAA",
"G;	c #909595",
"H;	c #6C7171",
"I;	c #707474",
"J;	c #808586",
"K;	c #A9ACAA",
"L;	c #B4B5B0",
"M;	c #A7A7A2",
"N;	c #868A8A",
"O;	c #B2B6B4",
"P;	c #B8BCBA",
"Q;	c #C47167",
"R;	c #D44D3A",
"S;	c #D65640",
"T;	c #924539",
"U;	c #4D503F",
"V;	c #58724D",
"W;	c #58785A",
"X;	c #65706A",
"Y;	c #65726C",
"Z;	c #68786F",
"`;	c #728378",
" >	c #808F86",
".>	c #909C95",
"+>	c #9CA4A1",
"@>	c #949999",
"#>	c #6F7373",
"$>	c #6F7474",
"%>	c #808686",
"&>	c #959899",
"*>	c #AAADAC",
"=>	c #B4B6B1",
"->	c #B4B3AE",
";>	c #888C8C",
">>	c #B5B8B8",
",>	c #B8BDBB",
"'>	c #BA938C",
")>	c #CB5949",
"!>	c #D8664D",
"~>	c #D65944",
"{>	c #D8644B",
"]>	c #D25743",
"^>	c #855248",
"/>	c #61594C",
"(>	c #666253",
"_>	c #6A7366",
":>	c #6D7C72",
"<>	c #7E8E82",
"[>	c #8E9B92",
"}>	c #9CA4A0",
"|>	c #A4AAAA",
"1>	c #818586",
"2>	c #949899",
"3>	c #AAACAA",
"4>	c #B5B7B3",
"5>	c #7A7F7E",
"6>	c #8E9292",
"7>	c #B8BCBB",
"8>	c #BBBEBE",
"9>	c #B5B2AE",
"0>	c #A59287",
"a>	c #A96358",
"b>	c #CE604D",
"c>	c #DD785B",
"d>	c #DE785C",
"e>	c #D9664F",
"f>	c #D86850",
"g>	c #AB584E",
"h>	c #766662",
"i>	c #706962",
"j>	c #786A5E",
"k>	c #827A6D",
"l>	c #878C80",
"m>	c #88968B",
"n>	c #909C94",
"o>	c #9BA5A0",
"p>	c #ABB1B0",
"q>	c #ABB2B1",
"r>	c #ADB3B3",
"s>	c #989D9C",
"t>	c #737777",
"u>	c #818686",
"v>	c #B4B5B1",
"w>	c #B2B5B2",
"x>	c #797D7D",
"y>	c #BABEBD",
"z>	c #B9BAB8",
"A>	c #B0A7A0",
"B>	c #A18F84",
"C>	c #927E73",
"D>	c #AC6258",
"E>	c #D7725C",
"F>	c #E08A6F",
"G>	c #DC755C",
"H>	c #E0866A",
"I>	c #DE7C62",
"J>	c #B96053",
"K>	c #7F6562",
"L>	c #716E6A",
"M>	c #786E69",
"N>	c #82746C",
"O>	c #8E8076",
"P>	c #9C958E",
"Q>	c #A2A4A0",
"R>	c #A3AAA8",
"S>	c #A6ACAB",
"T>	c #AAB0AF",
"U>	c #ADB2B3",
"V>	c #9BA09F",
"W>	c #727676",
"X>	c #AAADAB",
"Y>	c #B4B6B2",
"Z>	c #B2B4B4",
"`>	c #999C9C",
" ,	c #787D7C",
".,	c #B8B9B6",
"+,	c #B2ADA7",
"@,	c #A99D95",
"#,	c #9B8B82",
"$,	c #93766E",
"%,	c #B2675B",
"&,	c #DC8671",
"*,	c #DE8670",
"=,	c #E0977E",
"-,	c #C46D5D",
";,	c #8A625E",
">,	c #74726E",
",,	c #79726C",
"',	c #83756D",
"),	c #8E7F75",
"!,	c #988D85",
"~,	c #A29C97",
"{,	c #AAA9A7",
"],	c #ACB0B0",
"^,	c #AFB4B5",
"/,	c #9EA3A2",
"(,	c #747878",
"_,	c #828686",
":,	c #959898",
"<,	c #A7ABA8",
"[,	c #B2B7B5",
"},	c #949796",
"|,	c #7A7D7D",
"1,	c #9FA2A0",
"2,	c #B8B7B4",
"3,	c #B1AAA4",
"4,	c #A69990",
"5,	c #9A887D",
"6,	c #947369",
"7,	c #B86258",
"8,	c #996159",
"9,	c #776E68",
"0,	c #7B726C",
"a,	c #84786F",
"b,	c #908076",
"c,	c #9B8D84",
"d,	c #A49C97",
"e,	c #AAA8A6",
"f,	c #ACAFAE",
"g,	c #AEB2B2",
"h,	c #B4B8B5",
"i,	c #A5A7A6",
"j,	c #B6B5B1",
"k,	c #B0A8A2",
"l,	c #A6978D",
"m,	c #97867C",
"n,	c #8C7A70",
"o,	c #8A796F",
"p,	c #908077",
"q,	c #9C8E85",
"r,	c #A69E97",
"s,	c #AEAAA7",
"t,	c #B0B2B0",
"u,	c #B1B6B5",
"v,	c #A2A6A7",
"w,	c #777C7B",
"x,	c #828687",
"y,	c #969999",
"z,	c #B2B3AE",
"A,	c #8A908E",
"B,	c #7E8182",
"C,	c #A4A6A5",
"D,	c #B6B4B0",
"E,	c #AFA7A1",
"F,	c #A89A92",
"G,	c #A6988F",
"H,	c #AAA199",
"I,	c #B0ACA8",
"J,	c #B4B4B2",
"K,	c #787C7D",
"L,	c #95999A",
"M,	c #A7AAA6",
"N,	c #898D8B",
"O,	c #7C7F80",
"P,	c #B6B6B2",
"Q,	c #B7B9B6",
"R,	c #6E7373",
"S,	c #838787",
"T,	c #AAACA9",
"U,	c #A7A8A4",
"V,	c #858886",
"W,	c #7F8282",
"X,	c #ABAEAE",
"Y,	c #6E7273",
"Z,	c #838687",
"`,	c #B3B4B0",
" '	c #A0A29F",
".'	c #828482",
"+'	c #818585",
"@'	c #AEB1B1",
"#'	c #787D7D",
"$'	c #969899",
"%'	c #AAAEAC",
"&'	c #979894",
"*'	c #7C7F7E",
"='	c #838888",
"-'	c #727677",
";'	c #838788",
">'	c #959999",
",'	c #B4B7B6",
"''	c #90908E",
")'	c #969A9C",
"                                                                                  . +                                           ",
"                                                                            @ # $ % & * =                                       ",
"                                                                        - ; > , ' ) ! ~ { ] ^                                   ",
"                                                                    / ( _ : < [ } | 1 2 3 4 5 6 7                               ",
"                                                                  8 9 0 a b c d e f g h i j k l m n                             ",
"                                                                  o p q r s t u v w x y i z A B g C                             ",
"                                                                  D E E E F G H I J K L M N O O O P Q                           ",
"                                                                  R S S S S S T U V W X Y Y Y Y Y Z `                           ",
"                                                                   ...............+.@.@.@.@.@.@.@.#.$.                          ",
"                                                                  %.&.&.&.&.&.&.&.*.=.=.=.=.=.=.=.-.;.                          ",
"                                                                  >.,.,.,.,.,.,.,.'.).).).).).).).!.;.                          ",
"                                                                  ~.{.{.{.{.{.{.{.].^.^.^.^.^.^.^./.;.                          ",
"                                                                  ~.(.(.(.(.(.(.(._.:.:.:.:.:.:.:.<.;.                          ",
"                                                                  [.}.}.}.}.}.}.}.|.1.1.1.1.1.1.1.2.;.                          ",
"                                                                  [.3.3.3.3.3.3.3.4.5.5.5.5.5.5.5.6.;.                          ",
"                                                                  7.8.9.9.9.9.9.9.0.a.a.a.a.a.a.a.b.;.                          ",
"                                                            c.d.e.f.g.h.i.j.k.k.k.>.l.l.l.l.l.l.l.m.;.                          ",
"                                                      n.o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.C.C.C.C.C.C.D.;.                          ",
"                                                  E.F.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.W.W.X.Y.Z.`.;.                          ",
"                                               +.+++@+#+$+%+&+*+H.=+-+;+>+,+'+)+!+~+{+]+]+^+/+(+_+:+<+                          ",
"                                              [+}+|+1+2+3+4+5+6+7+8+++9+0+a+b+c+d+e+f+g+h+i+(+(+(+j+k+                          ",
"                                              l+m+n+o+p+q+%+r+s+t+u+v+w+x+y+K.z+A+B+C+D+D+E+F+F+F+G+H+                          ",
"                                              [+I+I+I+J+K+L+M+N+O+P+Q+9+r.r.r.R+S+T+U+V+W+/+F+F+F+X+Y+                          ",
"                                              Z+`+`+`+`+`+`+ @.@+@@@#@#@#@#@#@$@%@T+&@*@=@-@-@-@-@;@>@                          ",
"                                          ,@'@)@!@!@!@!@!@!@!@~@{@{@{@{@{@{@{@]@^@/@(@_@:@<@<@<@<@[@}@                          ",
"                                    |@1@2@3@4@5@6@6@6@6@6@6@6@7@8@8@8@8@8@8@8@9@0@a@b@c@d@e@e@e@e@f@g@                          ",
"                                h@i@j@k@l@m@n@o@p@p@p@p@p@p@p@q@r@r@r@r@r@r@r@s@t@u@v@w@x@x@x@x@x@y@z@                          ",
"                            A@B@C@l@l@D@E@F@G@H@I@I@I@I@I@I@I@J@K@K@K@K@K@K@K@L@M@N@O@P@Q@Q@Q@Q@Q@R@S@T@                        ",
"                        h@U@V@W@l@D@X@Y@Z@`@ #.#+#+#+#+#+#+#+#@###############$#%#&#*#=#-#-#-#-#-#;#>#,#'#)#                    ",
"                    !#~#{#]#^#/#(#E@_#`@:#<#[#}#|#1#2#3#3#3#3#4#5#5#5#5#6#7#5#8#9#0#a#b#b#b#b#b#b#c#d#e#f#g#h#i#                ",
"                j#k#l#]#W@l@D@E@F@Z@m# #n#o#p#q#r#s#t#u#u#u#u#v#w#w#w#w#x#s#y#z#A#B#C#D#E#E#E#E#E#F#G#H#I#/#]#J#K#L#            ",
"          M#N#O#P#]#Q#^#m@(#R#S#`@T#U#V#W#X#Y#Z#`# $ $.$+$+$+$@$#$#$#$$$ $ $%$&$*$=$-$;$>$>$>$>$>$,$'$)$!$~$^#]#{$]$^$          ",
"      /$($_$:${$]#W@l@D@(#Y@Z@m# #<$[$}$|$1$2$3$4$5$5$6$7$7$7$8$9$9$9$0$%$%$%$a$b$c$d$e$e$e$e$e$e$f$g$h$i$j$D@^#]#k$l$m$        ",
"    n$o${${$]#]#W@l@D@E@S#`@p$q$V#W#r$s$t$u$v$w$x$y$z$A$B$B$B$C$B$B$B$D$E$E$E$F$G$H$I$J$J$J$J$J$J$K$L$M$N$O$E@m@W@]#l$P$Q$      ",
"  R$S$T${$]#]#W@l@(#U$_#`@V$W$X$Y$Z$`$ %.%+%@%#%$%%%&%*%=%-%-%;%>%>%,%'%)%)%)%!%~%{%]%^%^%^%^%^%^%/%(%_%:%p$<%E@l@Q#l$[%}%      ",
"  R$S${${$]#^#l@(#|%Z@1%2%3%X$4%5%6%7%8%9%0%a%b%c%d%e%f%g%h%i%j%k%k%l%m%m%m%m%n%o%p%q%_@_@_@_@_@_@r%s%t%u%v%w%F@(#^#l$x%y%      ",
"  z%y%{$]#W@l@(#Y@Z@A%2%n#B%C%D%E%F%G%H%I%J%K%L%M%N%O%P%Q%R%S%T%U%V%W%X%X%X%X%Y%Z%`% &.&.&.&.&.&.&+&@&#&$&<$p$Z@U$%&&&x%y%      ",
"  z%y%{$]#l@D@U$<%w%2%n#X$*&=&-&;&>&,&'&)&!&>&~&{&]&^&/&(&_&:&<&[&}&|&1&1&1&1&2&3&4&5&6&6&6&6&6&6&7&8&#&9&0&a&`@n@D@b&x%y%      ",
"  z%y%k$W@D@E@_#c&p$W$d&e&f&g&h&i&j&k&l&m&n&'&o&p&q&r&s&t&u&v&w&x&y&z&z&z&z&z&A&B&C&D&E&E&E&E&E&E&F&8&G&9&X$H&1%_#(#y%x%y%      ",
"  z%y%]#l@(#Y@Z@m#2%I&J&K&L&M&M&N&O&P&Q&R&S&T&U&V&W&X&Y&Y&Z&`& *.*+*@*@*@*@*@*#*$*%*&*************=*-*;*>*,*q$A%<%'*y%)*!*      ",
"  z%y%Q#m@E@S#c&p$~*{*o#]*^*/*(*_*/*:*<*[*}*|*1*2*3*3*4*3*5*6*7*8*9*0*0*0*0*0*a*b*c*d*e*e*e*e*e*e*f*g*h*i*j*W$p$Z@E@y%)*!*      ",
"  z%y%Q#m@U$<%`@a&W$d&k*l*m*n*o*p*q*q*q*q*r*s*s*s*s*t*u*v*w*x*y*z*A*B*B*B*B*B*C*D*E*F*G*G*G*G*H*I*J*K*L*M*N*:#:#O*U$y%P*Q*      ",
"  z%y%^#D@|%Z@m#2%n#R*e&S*T*U*o*o*V*W*W*W*X*Y*Y*Y*Z*`*o* =.=+=@=#=$=%=%=%=%=%=&=*===-=;=;=>=,='=)=!=~={=]=^=/=R#(=E@y%_=Q*      ",
"  z%y%l@(#(=Z@A%:=I&V#W$<=[=}=}=}=|=1=1=1=2=3=3=3=4=5=5=5=6=7=8=9=0=a=a=a=a=a=b=c=d=e=f=g=h=i=j=k=l=m=n=o=p=q=r=s=l@b&P*Q*      ",
"  z%y%l@'*(=O*t=u=a&v=w=x=y=z=z=z=A=B=B=B=C=D=D=D=E=F=F=F=G=H=I=J=K=L=L=L=L=L=M=N=O=P=Q=R=S=T=U=V=W=X=o=Y=Z=`=l$ -.-+-@-y%      ",
"  z%y%l@'*(=N*O*#-$-+-G@%-&-*-*-*-=---;-;->-,-,-'-)-!-!-!-~-{-]-^-/-(-(-(-(-(-_-:-<-[-}-T=|-1-2-3-4-5-Q$`=k*k*o#{*6-7-8-9-      ",
"  z%y%l@(#|%y%$-2$|%(=Z@0-a-b-b-b-b-c-d-d-e-f-f-g-h-h-h-h-i-j-k-l-m-n-n-n-n-o-p-q-r-s-t-u-v-w-x-y-`=k*o#J&,*0&z-A-B-C-^$[#      ",
"  z%y%l@2$D-E-F-m@(#U$S#G-H-I-I-I-I-J-K-L-M-N-O-P-Q-Q-Q-Q-R-S-T-U-V-W-W-X-Y-Z-`- ;.;+;@;#;$;%;e&o#J&,*0&I&&;*;=;-;;;>;,;        ",
"    P$D-';Q#]#W@l@D@(#U$);!;~;~;~;~;{;];^;/;(;_;~;:;:;:;:;<;[;};|;1;2;3;4;5;6;7;8;9;0;a;b;c;J&R*0&I&d;U#e;f;g;h;j@i;j;          ",
"    k;l;m;{$]#]#W@l@m@(#n;o;p;p;p;p;p;p;p;q;r;s;r;r;r;r;r;t;u;v;w;x;y;5;z;A;B;C;D;E;F;,*d&0&I&<$q$2%G;H;I;J;j@K;L;              ",
"      M;q=N;O;]#]#W@^#/#P;Q;O-O-O-O-O-O-O-R;S;S;S;S;S;S;S;T;U;V;W;X;Y;Z;`; >.>+>`=d&{*I&<$3% #m#@>#>$>%>&>*>=>                  ",
"        ->Z$$-;>>>]#Q#^#,>'>)>!>'-'-'-'-'-~>{>{>{>{>{>{>]>^>/>(>_>:>`;<>[>}>|>[#I&<$W$:=:#N*2$g;$>1>2>3>4>                      ",
"            c&Z$5>6>7>]#8>9>0>a>b>c>d>d>d>e>D=D=D=D=f>g>h>i>j>k>l>m>n>o>|><$W$p>q>r>w%_#s>t>$>u>2>3>v>                          ",
"                w>l$x>j@y>z>A>B>C>D>E>F>F>G>H>H>I>J>K>L>M>N>O>P>Q>R>S>T>:=u=U>:#N*g#V>W>$>;;j@X>Y>                              ",
"                    Z>`> ,_$.,+,@,#,$,%,&,*,=,-,;,>,,,',),!,~,{,],:=2%a&^,`@<%U$/,(,I;_,:,<,j;                                  ",
"                        [,},|,1,2,3,4,5,6,7,8,9,0,a,b,c,d,e,f,g,p$^,w%O*(=D@Z$x%$>_,&>K;h,                                      ",
"                            %-.-$-i,j,k,l,m,n,o,p,q,r,s,t,u,3@`@`@<%g#m@v,w,I;x,y,3>z,                                          ",
"                                f,A,B,C,D,E,F,G,H,I,J,]$S#<%Z@F@U$%&Y$K,#>x,L,X>Y>                                              ",
"                                    M,N,O,i,2,P,Q,P;D@(#E@U$E@l@k*|,R,S,+-T,Y>                                                  ",
"                                        U,V,W,X,]#Q#l@m@D@l@Y$8-Y,Z,+-X>`,                                                      ",
"                                             '.'+'@'k$Q#[$#'R,x,$'%'Y>                                                          ",
"                                                &'*'='$--';'>'W#,'                                                              ",
"                                                    '')'E-v,                                                                    ",
"                                                                                                                                "};


#endif
