.\" t
.\" @(#)ascmap.3		06/18/2008
.TH ascmap 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBascmap\fP\ - defines main structures and function for image quantization
libAfterImage/ascmap.h
.SH NAMEascmap
- Defines main structures and function for image quantization.

.SH DESCRIPTION
.nf
Image quantization is needed primarily in order to be able to export
images into file, with colormap format, such as GIF and XPM.
libAfterImage attempts to allocate colorcells to the most used colors,
and then approximate remaining colors with the closest colorcell.

Since quality of quantization is in reverse proportion to the number
of colors in original image, libAfterImage allows to set arbitrary
level of downsampling of the color spectrum in the range of 8 bit per
channel to 1 bit per channel. Downsampling is performed by simple
dropping of less significant bits off of color values.

In order to be able to determine closeness of colors, 3-channel RGB
values are converted into flat 24bit (or less if downsampling is used)
index. That is done by intermixing bits from different channels, like
so : R8G8B8R7G7B7...R1G1B1. That flat index is used to arrange colors
in ascending order, and later on to be able to find closest mapped
color. Simple hashing technique is used to speed up the
sorting/searching, as it allows to limit linked lists traversals.
.fi 
.SH SEE ALSO
.nf
Structures :
         ASColormapEntry
         ASColormap

Functions :
         colormap_asimage(), destroy_colormap()

Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/ASColormapEntry
.SH NAMEASColormapEntry
- ASColormapEntry represents single colorcell in the colormap.

.SH SOURCE
Source : 
.nf
typedef struct ASColormapEntry
{
    CARD8 red, green, blue;
}ASColormapEntry;
.fi libAfterImage/ASColormap
.SH NAMEASColormap
- ASColormap represents entire colormap generated for the image.

.SH SOURCE
Source : 
.nf
typedef struct ASColormap
{
    ASColormapEntry *entries ;  /* array of colorcells */
    unsigned int count ;        /* number of used colorcells */
    ASSortedColorHash *hash ;   /* internal data */
    Bool has_opaque ;           /* If True then Image has opaque pixels */
}ASColormap;
.fi libAfterImage/colormap_asimage()
.SH NAMEcolormap_asimage()


.SH SYNOPSIS
.nf
int *colormap_asimage( ASImage *im, ASColormap *cmap,
                       unsigned int max_colors, unsigned int dither,
                       int opaque_threshold );
.fi 
.SH INPUTS
.IP "im"
- pointer to valid ASImage structure.
.IP "cmap"
- preallocated structure to store colormap in.
.IP "max_colors"
- maximum size of the colormap.
.IP "dither"
- number of bits to strip off the color data ( 0...7 )
.IP "opaque_threshold"
- alpha channel threshold at which pixel should be treated as opaque

.SH RETURN VALUE
.nf
pointer to the array of indexes representing pixel's colorcells. This
array has size of WIDTHxHEIGHT where WIDTH and HEIGHT are size of the
source image.
.fi 
.SH DESCRIPTION
.nf
This function is all that is needed to quantize the ASImage. In order
to obtain colorcell of the pixel at (x,y) from result, the following
code could be used :
cmap->entries[res[y*width+x]]
where res is returned pointer.
Recommended value for dither parameter is 4 while quantizing photos to
256 colors, and it could be less , if original has limited number of
colors.
.fi libAfterImage/destroy_colormap()
.SH NAMEdestroy_colormap()


.SH SYNOPSIS
.nf
void destroy_colormap( ASColormap *cmap, Bool reusable );
.fi 
.SH INPUTS
.IP "cmap"
- pointer to valid ASColormap structure.
.IP "reusable"
- if True, then the memory pointed to by cmap will not be deallocated, as if it was allocated on stack

.SH DESCRIPTION
.nf
Destroys ASColormap object created using colormap_asimage.
.fi 
