.\" t
.\" @(#)asimagexml.3		06/18/2008
.TH asimagexml 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBasimagexml\fP\ - XML schema to be used for scripting image manipulation by AfterStep and ascompose
libAfterImage/asimagexml
.SH NAMEascompose
is a tool to compose image(s) and display/save it based on supplied XML input file.

.SH DESCRIPTION
.nf
ascompose reads supplied XML data, and manipulates image accordingly.
It could transform images from files of any supported file format,
draw gradients, render antialiased texturized text, perform
superimposition of arbitrary number of images, and save images into
files of any of supported output file formats.

At any point, the result of any operation could be assigned a name,
and later on referenced under this name.

At any point during the script processing, result of any operation
could be saved into a file of any supported file types.

Internal image format is 32bit ARGB with 8bit per channel.

Last image referenced, will be displayed in X window, unless -n option
is specified. If -r option is specified, then this image will be
displayed in root window of X display, effectively setting a background
for a desktop. If -o option is specified, this image will also be
saved into the file or requested type.
.fi 
.SH TAGS
.nf
Here is the list and description of possible XML tags to use in the
script :
    img       - load image from the file.
    recall    - recall previously loaded/generated image by its name.
    text      - render text string into new image.
    save      - save an image into the file.
    bevel     - draw solid bevel frame around the image.
    gradient  - render multipoint gradient.
    mirror    - create mirror copy of an image.
    blur      - perform gaussian blur on an image.
    rotate    - rotate/flip image in 90 degree increments.
    scale     - scale an image to arbitrary size.
    slice     - enlarge image to arbitrary size leaving corners unchanged.
    crop      - crop an image to arbitrary size.
    tile      - tile an image to arbitrary size.
    hsv       - adjust Hue, Saturation and Value of an image.
    pad       - pad image with solid color from either or all sides.
    solid     - generate new image of requested size, filled with solid
             color.
    composite - superimpose arbitrary number of images using one of 15
             available methods.
 if        - conditional processing based on value of the variables
 set       - sets value of the variable
 printf    - formated printing of the value of the variable

Each tag generates new image as the result of the transformation -
existing images are never modified and could be reused as many times
as needed. See below for description of each tag.

Whenever numerical values are involved, the basic math ops (add,
subtract, multiply, divide), unary minus, and parentheses are
supported.

Operator precedence is NOT supported.  Percentages are allowed, and
apply to either width or height of the appropriate image (usually
the refid image).

Also, variables of the form $image.width and $image.height are
supported.  $image.width is the width of the image with refid "image",
and $image.height is the height of the same image.  The special
$xroot.width and $xroot.height values are defined by the the X root
window, if there is one.  This allows images to be scaled to the
desktop size: <scale width="$xroot.width" height="$xroot.height">.

Each tag is only allowed to return ONE image.
.fi libAfterImage/asimagexml/text
.SH NAMEtext
- render text string into new image, using specific font, size and texture.

.SH SYNOPSIS
.nf
<text id="new_id" font="font" point="size" fgcolor="color"
      bgcolor="color" fgimage="image_id" bgimage="image_id"
      spacing="points">My Text Here</text>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "font"
Optional. Default is "fixed". Font to use for text.
.IP "point"
Optional. Default is 12. Size of text in points.
.IP "fgcolor"
Optional. No default. The text will be drawn in this color.
.IP "bgcolor"
Optional. No default. The area behind the text will be drawn in this color.
.IP "fgimage"
Optional. No default. The text will be textured by this image.
.IP "bgimage"
Optional. No default. The area behind the text will be filled with this image.
.IP "spacing"
Optional. Default 0. Extra pixels to place between each glyph.
.IP "type"
Optional. Default 0. Valid values are from 0 to 7 and each represeend different 3d type.

.SH NOTES
.nf
<text> without bgcolor, fgcolor, fgimage, or bgimage will NOT
produce visible output by itself.  See EXAMPLES below.
.fi libAfterImage/asimagexml/composite
.SH NAMEcomposite
- superimpose arbitrary number of images on top of each other.

.SH SYNOPSIS
.nf
<composite id="new_id" op="op_desc"
           keep-transparency="0|1" merge="0|1">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "op"
Optional. Default is "alphablend". The compositing operation. Valid values are the standard AS blending ops: add, alphablend, allanon, colorize, darken, diff, dissipate, hue, lighten, overlay, saturate, screen, sub, tint, value.
.IP "merge"
Optional. Default is "expand". Valid values are "clip" and "expand". Determines whether final image will be expanded to the maximum size of the layers, or clipped to the bottom layer.
.IP "keep-transparency"
Optional. Default is "0". Valid values are "0" and "1". If set to "1", the transparency of the bottom layer will be kept for the final image.

.SH NOTES
.nf
All images surrounded by this tag will be composited with the given op.
.fi 
.SH ATTRIBUTES
.nf
 All tags surrounded by this tag may have some of the common attributes
 in addition to their normal ones.  Under no circumstances is there a 
 conflict with the normal child attributes:
.fi 
.IP "crefid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "x" and "y" will be derived from the width and height of the crefid image.
.IP "x"
Optional. Default is 0. Pixel coordinate of left edge.
.IP "y"
Optional. Default is 0. Pixel coordinate of top edge.
.IP "align"
Optional. Alternative to x - allowed values are right, center and left.
.IP "valign"
Optional. Alternative to y - allowed values are top, middle and bottom.
.IP "clip_x"
Optional. Default is 0. X Offset on infinite surface tiled with this image, from which to cut portion of an image to be used in composition.
.IP "clip_y"
Optional. Default is 0. Y Offset on infinite surface tiled with this image, from which to cut portion of an image to be used in composition.
.IP "clip_width"
Optional. Default is image width. Tile image to this width prior to superimposition.
.IP "clip_height"
Optional. Default is image height. Tile image to this height prior to superimposition.
.IP "tile"
Optional. Default is 0. If set will cause image to be tiled across entire composition, unless overridden by clip_width or clip_height.
.IP "tint"
Optional. Additionally tint an image to specified color. Tinting can both lighten and darken an image. Tinting color 0 or #7f7f7f7f yields no tinting. Tinting can be performed on any channel, including alpha channel.

.SH SEE ALSO
.nf
libAfterImage
.fi libAfterImage/asimagexml/img
.SH NAMEimg
- load image from the file.

.SH SYNOPSIS
.nf
<img id="new_img_id" src="filename"/>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "src"
Required. The filename (NOT URL) of the image file to load.

.SH NOTES
.nf
The special image src "xroot:" will import the background image
of the root X window, if any.  No attempt will be made to offset this
image to fit the location of the resulting window, if one is displayed.
.fi libAfterImage/asimagexml/recall
.SH NAMErecall
- recall previously generated and named image by its id.

.SH SYNOPSIS
.nf
<recall id="new_id" srcid="image_id" default_src="filename"/>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "srcid"
Required. An image ID defined with the "id" parameter for any previously created image.
libAfterImage/asimagexml/release
.SH NAMErelease
- release (destroy if possible) previously generated and named image by its id.

.SH SYNOPSIS
.nf
<release srcid="image_id"/>
.fi 
.SH ATTRIBUTES
.IP "srcid"
Required. An image ID defined with the "id" parameter for any previously created image.
libAfterImage/asimagexml/color
.SH NAMEcolor
- defines symbolic name for a color and set of variables.

.SH SYNOPSIS
.nf
<color name="sym_name" domain="var_domain" argb="colorvalue"/>
.fi 
.SH ATTRIBUTES
.IP "name"
Symbolic name for the color value, to be used to refer to that color.
.IP "argb"
8 characters hex definition of the color or other symbolic color name.
.IP "domain"
string to be used to prepend names of defined variables.

.SH NOTES
.nf
In addition to defining symbolic name for the color this tag will define
7 other variables :     domain.sym_name.red, domain.sym_name.green, 
                        domain.sym_name.blue, domain.sym_name.alpha, 
                        domain.sym_name.hue, domain.sym_name.saturation,
                        domain.sym_name.value
.fi libAfterImage/asimagexml/color2alpha
.SH NAMEcolor2alpha
- set alpha channel based on color closeness to specified color

.SH SYNOPSIS
.nf
<color2alpha id="new_id" ref_id="other_imag" width="pixels" height="pixels"
       clip_x="clip_x" clip_y="clip_y"
       color="color">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Required. The image will be scaled to this width.
.IP "height"
Required. The image will be scaled to this height.
.IP "clip_x"
Optional. Offset into original image.
.IP "clip_y"
Optional. Offset into original image.
.IP "color"
Required. Color to match against.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
If you want to keep image proportions while resizing-use "proportional"
instead of specific size for particular dimention.
.fi libAfterImage/asimagexml/printf
.SH NAMEprintf
- prints variable value to standard output.

.SH SYNOPSIS
.nf
<printf format="format_string" var="variable_name" val="expression"/>
.fi 
.SH ATTRIBUTES
.IP "format_string"
Standard C format string with exactly 1 placeholder.
.IP "var"
Name of the variable, which value will be printed.
.IP "val"
math expression to be printed.

.SH NOTESlibAfterImage/asimagexml/set
.SH NAMEset
- declares variable, assigning it a numeric value of expression.

.SH SYNOPSIS
.nf
<set var="variable_name" domain="var_domain" val="expression"/>
.fi 
.SH ATTRIBUTES
.IP "var"
Name of the variable, which value will be set.
.IP "val"
math expression to be evaluated.
.IP "domain"
(optional) variable's domain to be prepended to its name using format var_domain.variable_name
libAfterImage/asimagexml/if
.SH NAMEif
- evaluates logical expression and if result evaluates to not true(or false if <unless> tag is used ), handles tags within.

.SH SYNOPSIS
.nf
<if val1="expression" [op="gt|lt|ge|le|eq|ne" val2="expression"]/>
    [<then>...</then><else>...</else>]
</if>
<unless val1="expression" [op="gt|lt|ge|le|eq|ne" val2="expression"]/>
.fi 
.SH ATTRIBUTES
.IP "val1"
math expression to be evaluated.
.IP "val2"
math expression to be evaluated.
.IP "op"
(optional) comparison op to be applied to values

.SH EXAMPLE
.nf
<if val1="$ascs.Base.value" val2="50" op="gt"><then>...</then><else>...</else></if>
.fi libAfterImage/asimagexml/gradient
.SH NAMEgradient
- render multipoint gradient.

.SH SYNOPSIS
.nf
<gradient id="new_id" angle="degrees" 
          refid="refid" width="pixels" height="pixels"
          colors ="color1 color2 color3 [...]"
          offsets="fraction1 fraction2 fraction3 [...]"/>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Optional. The result will have this width.
.IP "height"
Optional. The result will have this height.
.IP "colors"
Required. Whitespace-separated list of colors. At least two colors are required. Each color in this list will be visited in turn, at the intervals given by the offsets attribute.
.IP "offsets"
Optional. Whitespace-separated list of floating point values ranging from 0.0 to 1.0. The colors from the colors attribute are given these offsets, and the final gradient is rendered from the combination of the two. If both colors and offsets are given but the number of colors and offsets do not match, the minimum of the two will be used, and the other will be truncated to match. If offsets are not given, a smooth stepping from 0.0 to 1.0 will be used.
.IP "angle"
Optional. Given in degrees. Default is 0. This is the direction of the gradient. Currently the only supported values are 0, 45, 90, 135, 180, 225, 270, 315. 0 means left to right, 90 means top to bottom, etc.
libAfterImage/asimagexml/solid
.SH NAMEsolid
- generate image of specified size and fill it with solid color.

.SH SYNOPSIS
.nf
<solid id="new_id" color="color" opacity="opacity" 
    width="pixels" height="pixels"
    refid="refid" width="pixels" height="pixels"/>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "width"
Optional. The result will have this width.
.IP "height"
Optional. The result will have this height.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "color"
Optional. Default is "#ffffffff". An image will be created and filled with this color.
.IP "width"
Required. The image will have this width.
.IP "height"
Required. The image will have this height.
.IP "opacity"
Optional. Default is 100. Values from 0 to 100 represent the opacity of resulting image with 100 being completely opaque. Effectively overrides alpha component of the color setting.
libAfterImage/asimagexml/save
.SH NAMEsave
- write generated/loaded image into the file of one of the supported types

.SH SYNOPSIS
.nf
<save id="new_id" dst="filename" format="format" compress="value"
      opacity="value" replace="0|1" delay="mlsecs">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "dst"
Optional. Name of file image will be saved to. If omitted image will be dumped into stdout - usefull for CGI apps.
.IP "format"
Optional. Ouput format of saved image. Defaults to the extension of the "dst" parameter. Valid values are the standard AS image file formats: xpm, jpg, png, gif, tiff.
.IP "compress"
Optional. Compression level if supported by output file format. Valid values are in range of 0 - 100 and any of "deflate", "jpeg", "ojpeg", "packbits" for TIFF files. Note that JPEG and GIF will produce images with deteriorated quality when compress is greater then 0. For JPEG default is 25, for PNG default is 6 and for GIF it is 0.
.IP "opacity"
Optional. Level below which pixel is considered to be transparent, while saving image as XPM or GIF. Valid values are in range 0-255. Default is 127.
.IP "replace"
Optional. Causes ascompose to delete file if the file with the same name already exists. Valid values are 0 and 1. Default is 1 - files are deleted before being saved. Disable this to get multimage animated gifs.
.IP "delay"
Optional. Delay to be stored in GIF image. This could be used to create animated gifs. Note that you have to set replace="0" and then write several images into the GIF file with the same name.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/background
.SH NAMEbackground
- set image's background color.

.SH SYNOPSIS
.nf
 <background id="new_id" color="color">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "color"
Required. Color to be used for background - fills all the spaces in image with missing pixels.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/blur
.SH NAMEblur
- perform a gaussian blurr on an image.

.SH SYNOPSIS
.nf
<blur id="new_id" horz="radius" vert="radius" channels="argb">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "horz"
Optional. Horizontal radius of the blur in pixels.
.IP "vert"
Optional. Vertical radius of the blur in pixels.
.IP "channels"
Optional. Applys blur only on listed color channels: a - alpha, r - red, g - green, b - blue

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/bevel
.SH NAMEbevel
- draws solid bevel frame around the image.

.SH SYNOPSIS
.nf
<bevel id="new_id" colors="color1 color2" 
          width="pixels" height="pixels" refid="refid"
       border="left top right bottom" solid=0|1 outline=0|1>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "colors"
Optional. Whitespace-separated list of colors. Exactly two colors are required. Default is "#ffdddddd #ff555555". The first color is the color of the upper and left edges, and the second is the color of the lower and right edges.
.IP "borders"
Optional. Whitespace-separated list of integer values. Default is "10 10 10 10". The values represent the offsets toward the center of the image of each border: left, top, right, bottom.
.IP "solid"
Optional - default is 1. If set to 0 will draw bevel gradually fading into the image.
.IP "outline"
Optional - default is 0. If set to 1 will draw bevel around the image vs. inside the image.
.IP "width"
Optional. The result will have this width.
.IP "height"
Optional. The result will have this height.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/mirror
.SH NAMEmirror
- create new image as mirror copy of an old one.

.SH SYNOPSIS
.nf
 <mirror id="new_id" dir="direction" 
            width="pixels" height="pixels" refid="refid">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "dir"
Required. Possible values are "vertical" and "horizontal". The image will be flipped over the x-axis if dir is vertical, and flipped over the y-axis if dir is horizontal.
.IP "width"
Optional. The result will have this width.
.IP "height"
Optional. The result will have this height.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/rotate
.SH NAMErotate
- rotate an image in 90 degree increments (flip).

.SH SYNOPSIS
.nf
 <rotate id="new_id" angle="degrees"
            width="pixels" height="pixels" refid="refid">
* ATTRIBUTES
id       Optional. Image will be given this name for future reference.
angle    Required.  Given in degrees.  Possible values are currently
         "90", "180", and "270".  Rotates the image through the given
         angle.
width    Optional.  The result will have this width.
height   Optional.  The result will have this height.
refid    Optional.  An image ID defined with the "id" parameter for
         any previously created image.  If set, percentages in "width"
         and "height" will be derived from the width and height of the
         refid image.
.fi 
.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/scale
.SH NAMEscale
- scale image to arbitrary size

.SH SYNOPSIS
.nf
<scale id="new_id" refid="other_imag" src_x="pixels"  src_y="pixels" 
       src_width="pixels" src_height="pixels" 
       width="pixels" height="pixels">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Required. The image will be scaled to this width.
.IP "height"
Required. The image will be scaled to this height.
.IP "src_x"
Optional. Default is 0. X Offset on infinite surface tiled with this image, from which to cut portion of an image to be used in scaling.
.IP "src_y"
Optional. Default is 0. Y Offset on infinite surface tiled with this image, from which to cut portion of an image to be used in scaling.
.IP "src_width"
Optional. Default is image width. Tile image to this width prior to scaling.
.IP "src_height"
Optional. Default is image height. Tile image to this height prior to scaling.
.IP "*"
NOTES
.IP "This"
tag applies to the first image contained within the tag. Any
.IP "further"
images will be discarded.
.IP "If"
you want to keep image proportions while scaling - use "proportional"
.IP "instead"
of specific size for particular dimention.
libAfterImage/asimagexml/slice
.SH NAMEslice
- slice image to arbitrary size leaving corners unchanged

.SH SYNOPSIS
.nf
<slice id="new_id" ref_id="other_imag" width="pixels" height="pixels"
       x_start="slice_x_start" x_end="slice_x_end"
          y_start="slice_y_start" y_end="slice_y_end"
          scale="0|1">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Required. The image will be scaled to this width.
.IP "height"
Required. The image will be scaled to this height.
.IP "x_start"
Optional. Position at which vertical image slicing begins. Corresponds to the right side of the left corners.
.IP "x_end"
Optional. Position at which vertical image slicing end. Corresponds to the left side of the right corners.
.IP "y_start"
Optional. Position at which horisontal image slicing begins. Corresponds to the bottom side of the top corners.
.IP "y_end"
Optional. Position at which horisontal image slicing end. Corresponds to the top side of the bottom corners.
.IP "scale"
Optional. If set to 1 will cause middle portion of the image to be scaled instead of tiled.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
Contents of the image between x_start and x_end will be tiled 
horizontally. Contents of the image between y_start and y_end will be 
tiled vertically. This is usefull to get background images to fit the 
size of the text or a widget, while preserving its borders undistorted, 
which is the usuall result of simple scaling.
If you want to keep image proportions while resizing-use "proportional"
instead of specific size for particular dimention.
.fi libAfterImage/asimagexml/pixelize
.SH NAMEpixelize
- pixelize image using arbitrary pixel size

.SH SYNOPSIS
.nf
<pixelize id="new_id" ref_id="other_imag" width="pixels" height="pixels"
       clip_x="clip_x" clip_y="clip_y"
       pixel_width="pixel_width" pixel_height="pixel_height">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Required. The image will be scaled to this width.
.IP "height"
Required. The image will be scaled to this height.
.IP "clip_x"
Optional. Offset into original image.
.IP "clip_y"
Optional. Offset into original image.
.IP "pixel_width"
Required. Horizontal pixelization step;
.IP "pixel_height"
Required. Vertical pixelization step;

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
If you want to keep image proportions while resizing-use "proportional"
instead of specific size for particular dimention.
.fi libAfterImage/asimagexml/crop
.SH NAMEcrop
- crop image to arbitrary area within it.

.SH SYNOPSIS
.nf
 <crop id="new_id" refid="other_image" srcx="pixels" srcy="pixels"
       width="pixels" height="pixels" tint="color">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "srcx"
Optional. Default is "0". Skip this many pixels from the left.
.IP "srcy"
Optional. Default is "0". Skip this many pixels from the top.
.IP "width"
Optional. Default is "100%". Keep this many pixels wide.
.IP "height"
Optional. Default is "100%". Keep this many pixels tall.
.IP "tint"
Optional. Additionally tint an image to specified color. Tinting can both lighten and darken an image. Tinting color 0 or #7f7f7f7f yeilds no tinting. Tinting can be performed on any channel, including alpha channel.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/tile
.SH NAMEtile
- tile an image to specified area.

.SH SYNOPSIS
.nf
 <tile id="new_id" refid="other_image" width="pixels" height="pixels"
       x_origin="pixels" y_origin="pixels" tint="color" complement=0|1>
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Optional. Default is "100%". The image will be tiled to this width.
.IP "height"
Optional. Default is "100%". The image will be tiled to this height.
.IP "x_origin"
Optional. Horizontal position on infinite surface, covered with tiles of the image, from which to cut out resulting image.
.IP "y_origin"
Optional. Vertical position on infinite surface, covered with tiles of the image, from which to cut out resulting image.
.IP "tint"
Optional. Additionally tint an image to specified color. Tinting can both lighten and darken an image. Tinting color 0 or #7f7f7f7f yields no tinting. Tinting can be performed on any channel, including alpha channel.
.IP "complement"
Optional. Will use color that is the complement to tint color for the tinting, if set to 1. Default is 0.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/hsv
.SH NAMEhsv
- adjust Hue, Saturation and/or Value of an image and optionally tile an image to arbitrary area.

.SH SYNOPSIS
.nf
<hsv id="new_id" refid="other_image"
     x_origin="pixels" y_origin="pixels" width="pixels" height="pixels"
     affected_hue="degrees|color" affected_radius="degrees"
     hue_offset="degrees" saturation_offset="value"
     value_offset="value">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "width"
Optional. Default is "100%". The image will be tiled to this width.
.IP "height"
Optional. Default is "100%". The image will be tiled to this height.
.IP "x_origin"
Optional. Horizontal position on infinite surface, covered with tiles of the image, from which to cut out resulting image.
.IP "y_origin"
Optional. Vertical position on infinite surface, covered with tiles of the image, from which to cut out resulting image.
.IP "affected_hue"
Optional. Limits effects to the renage of hues around this hue. If numeric value is specified - it is treated as degrees on 360 degree circle, with : red = 0, yellow = 60, green = 120, cyan = 180, blue = 240, magenta = 300. If colorname or value preceded with # is specified here - it will be treated as RGB color and converted into hue automagically.
.IP "affected_radius"
Optional. Value in degrees to be used in order to calculate the range of affected hues. Range is determined by substracting and adding this value from/to affected_hue.
.IP "hue_offset"
Optional. Value by which to adjust the hue.
.IP "saturation_offset"
Optional. Value by which to adjust the saturation.
.IP "value_offset"
Optional. Value by which to adjust the value.

.SH NOTES
.nf
One of the Offsets must be not 0, in order for operation to be
performed.

This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi libAfterImage/asimagexml/pad
.SH NAMEpad
- pad an image with solid color rectangles.

.SH SYNOPSIS
.nf
<pad id="new_id" left="pixels" top="pixels"
     right="pixels" bottom="pixels" color="color"
        refid="refid" width="pixels" height="pixels">
.fi 
.SH ATTRIBUTES
.IP "id"
Optional. Image will be given this name for future reference.
.IP "width"
Optional. The result will have this width.
.IP "height"
Optional. The result will have this height.
.IP "refid"
Optional. An image ID defined with the "id" parameter for any previously created image. If set, percentages in "width" and "height" will be derived from the width and height of the refid image.
.IP "left"
Optional. Size to add to the left of the image.
.IP "top"
Optional. Size to add to the top of the image.
.IP "right"
Optional. Size to add to the right of the image.
.IP "bottom"
Optional. Size to add to the bottom of the image.
.IP "color"
Optional. Color value to fill added areas with. It could be transparent of course. Default is #FF000000 - totally black.

.SH NOTES
.nf
This tag applies to the first image contained within the tag.  Any
further images will be discarded.
.fi 
