.\" t
.\" @(#)blender.3		06/18/2008
.TH blender 1 "libAfterImage v.1.18" "Jun 18 2008" "libAfterImage image manipulation library"
.UC
.SH NAME
\fBblender\fP\ - functionality for blending of image data using diofferent algorithms
libAfterImage/blender.h
.SH NAMEblender


.SH DESCRIPTION
.nf
Defines implemented methods for ASScanline combining, that could
be passed to merge_layers() via ASImageLayer structure.
Also includes functions for colorspace conversion RGB<->HSV and
RGB<->HLS.
.fi 
.SH SEE ALSO
.nf
Functions :
   Colorspace conversion :
         rgb2value(), rgb2saturation(), rgb2hue(), rgb2luminance(),
         rgb2hsv(), rgb2hls(), hsv2rgb(), hls2rgb().

   merge_scanline methods :
         alphablend_scanlines(), allanon_scanlines(),
         tint_scanlines(), add_scanlines(), sub_scanlines(),
         diff_scanlines(), darken_scanlines(), lighten_scanlines(),
         screen_scanlines(), overlay_scanlines(), hue_scanlines(),
         saturate_scanlines(), value_scanlines(),
         colorize_scanlines(), dissipate_scanlines().

   usefull merging function name to function translator :
         blend_scanlines_name2func()

Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/colorspace
.SH NAMEcolorspace


.SH DESCRIPTION
.nf
RGB colorspace: each color is represented as a combination of
red, green and blue values. Each value can be in 2 formats :
8 bit and 24.8 bit. 24.8 bit makes for 32bit value with lower 8 bits
used as a fraction for better calculation precision.

HSV colorspace: each color is represented as a combination of
hue, saturation and value. Hue is generally colorizing component where
value represents brightness.

HLS colorspace: each color is represented as a combination of
hue, luminance and saturation. It is analogous to HSV with value
substituted by luminance, except that luminance could be both
negative and positive.

alpha channel could be added to any of the above colorspaces. alpha
channel is generally used to define transparentness of the color.
libAfterImage is using ARGB colorspace as a base colorspace, and
represents most colors as ARGB32 values or ASScanline scanlines of
pixels.
.fi libAfterImage/rgb2value()
.SH NAMErgb2value()

rgb2saturation()

rgb2hue()

rgb2luminance()


.SH SYNOPSIS
.nf
CARD32 rgb2value( CARD32 red, CARD32 green, CARD32 blue );
CARD32 rgb2saturation( CARD32 red, CARD32 green, CARD32 blue );
CARD32 rgb2hue( CARD32 red, CARD32 green, CARD32 blue );
CARD32 rgb2luminance (CARD32 red, CARD32 green, CARD32 blue );
.fi 
.SH INPUTS
.IP "red"
- 32 bit value, 16 lower bits of which represent red channel
.IP "green"
- 32 bit value, 16 lower bits of which represent green channel
.IP "blue"
- 32 bit value, 16 lower bits of which represent blue channel

.SH RETURN VALUE
.nf
32 bit value, 16 lower bits of which represent value, saturation, hue,
or luminance respectively.
.fi 
.SH DESCRIPTION
.nf
This functions translate RGB color into respective coordinates of
HSV and HLS colorspaces.
Returned hue values are in 16bit format. To translate it to and from
conventional 0-360 degree range, please use :
degrees2hue16() - converts conventional hue in 0-360 range into hue16
hue162degree()  - converts 16bit hue value into conventional degrees.
.fi libAfterImage/rgb2hsv()
.SH NAMErgb2hsv()

rgb2hls()


.SH SYNOPSIS
.nf
CARD32 rgb2hsv( CARD32 red, CARD32 green, CARD32 blue,
                CARD32 *saturation, CARD32 *value );
CARD32 rgb2hls( CARD32 red, CARD32 green, CARD32 blue,
                CARD32 *luminance, CARD32 *saturation );
.fi 
.SH INPUTS
.IP "red"
- 32 bit value, 16 lower bits of which represent red channel
.IP "green"
- 32 bit value, 16 lower bits of which represent green channel
.IP "blue"
- 32 bit value, 16 lower bits of which represent blue channel

.SH RETURN VALUE
.nf
32 bit value, 16 lower bits of which represent hue.
32bit value pointed to by luminance, value and saturation will be set
respectively to color luminance, value and saturation.
.fi 
.SH DESCRIPTION
.nf
This functions translate RGB color into full set of HSV and HLS
coordinates at once. These functions work faster then separate
translation into each channel.
.fi libAfterImage/hsv2rgb()
.SH NAMEhsv2rgb()

hls2rgb()


.SH SYNOPSIS
.nf
void hsv2rgb( CARD32 hue, CARD32 saturation, CARD32 value,
              CARD32 *red, CARD32 *green, CARD32 *blue);
void hls2rgb( CARD32 hue, CARD32 luminance, CARD32 saturation,
              CARD32 *red, CARD32 *green, CARD32 *blue);
.fi 
.SH INPUTS
.IP "hue"
- 32 bit value, 16 lower bits of which represent hue.
.IP "saturation"
- 32 bit value, 16 lower bits of which represent saturation.
.IP "value"
- 32 bit value, 16 lower bits of which represent value.
.IP "luminance"
- 32 bit value, 16 lower bits of which represent luminance.

.SH RETURN VALUE
.nf
32bit value pointed to by red, green and blue will be set
respectively to RGB color channels.
.fi 
.SH DESCRIPTION
.nf
This functions performs reverse translation from HSV and HSL to
RGB color
.fi libAfterImage/merge_scanline
.SH NAMEalphablend_scanlines()
- combines top and bottom RGB components based on alpha channel value: bottom = bottom*(255-top_alpha)+top*top_alpha;
allanon_scanlines()
- averages each pixel between two scanlines. This method has been first implemented by Ethan Fisher aka allanon as mode 130: bottom = (bottom+top)/2;
tint_scanlines()
- tints bottom scanline with top scanline( with saturation to prevent overflow) : bottom = (bottom*(top/2))/32768;
add_scanlines()
- adds top scanline to bottom scanline with saturation to prevent overflow: bottom = bottom+top;
sub_scanlines()
- substrates top scanline from bottom scanline with saturation to prevent overflow: bottom = bottom-top;
diff_scanlines()
- for each pixel calculates absolute difference between bottom and top color value : bottom = (bottom>top)?bottom-top:top-bottom;
darken_scanlines()
- substitutes each pixel with minimum color value of top and bottom : bottom = (bottom>top)?top:bottom;
lighten_scanlines()
- substitutes each pixel with maximum color value of top and bottom : bottom = (bottom>top)?bottom:top;
screen_scanlines()
- some wierd merging algorithm taken from GIMP;
overlay_scanlines()
- some wierd merging algorithm taken from GIMP;
hue_scanlines()
- substitute hue of bottom scanline with hue of top scanline;
saturate_scanlines()
- substitute saturation of bottom scanline with the saturation of top scanline;
value_scanlines()
- substitute value of bottom scanline with the value of top scanline;
colorize_scanlines()
- combine luminance of bottom scanline with hue and saturation of top scanline;
dissipate_scanlines()-
randomly alpha-blend bottom and top scanlines, using alpha value of top scanline as a threshold for random values.

.SH SYNOPSIS
.nf
void alphablend_scanlines( ASScanline *bottom, ASScanline *top, int );
void allanon_scanlines   ( ASScanline *bottom, ASScanline *top, int );
void tint_scanlines      ( ASScanline *bottom, ASScanline *top, int );
void add_scanlines       ( ASScanline *bottom, ASScanline *top, int );
void sub_scanlines       ( ASScanline *bottom, ASScanline *top, int );
void diff_scanlines      ( ASScanline *bottom, ASScanline *top, int );
void darken_scanlines    ( ASScanline *bottom, ASScanline *top, int );
void lighten_scanlines   ( ASScanline *bottom, ASScanline *top, int );
void screen_scanlines    ( ASScanline *bottom, ASScanline *top, int );
void overlay_scanlines   ( ASScanline *bottom, ASScanline *top, int );
void hue_scanlines       ( ASScanline *bottom, ASScanline *top, int );
void saturate_scanlines  ( ASScanline *bottom, ASScanline *top, int );
void value_scanlines     ( ASScanline *bottom, ASScanline *top, int );
void colorize_scanlines  ( ASScanline *bottom, ASScanline *top, int );
void dissipate_scanlines ( ASScanline *bottom, ASScanline *top, int );
.fi 
.SH INPUTS
.IP "bottom"
- pointer to the ASScanline that will be overalayed
.IP "top"
- pointer to ASScanline that will overlay bottom.

.SH DESCRIPTION
.nf
This functions accept 2 scanlines as an arguments stored in
ASScanline structures with data in 24.8 format. Merging operation is
performed on these scanlines and result is stored in bottom
ASScanline.
The following are merging methods used in each function :
.fi libAfterImage/blend_scanlines_name2func()
.SH NAMEblend_scanlines_name2func()

list_scanline_merging()


.SH SYNOPSIS
.nf
merge_scanlines_func blend_scanlines_name2func( const char *name );
void list_scanline_merging(FILE* stream, const char *format);
.fi 
.SH INPUTS
.IP "name"
- string, identifying scanline merging function.

.SH RETURN VALUE
.nf
returns pointer to the scanline merging function on succes.
NULL on failure.
.fi 
.SH DESCRIPTION
.nf
blend_scanlines_name2func() will strip leading whitespaces off of
the supplied name, and then will attempt to match it against the list
of names of merging functions. It will then return pointer to the
function with matching name.
list_scanline_merging() simply prints out description of implemented
blending/merging methods onto the supplied stream, in supplied format.
Format must include 2 string specs, like so : "%s - %s" where first
one will be substituted to short method name, and second - description
.fi 
