/*
 * Copyright (C) 2004-2012 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <ZLInputStream.h>

#include "../../library/Book.h"

#include "DocMetaInfoReader.h"

DocMetaInfoReader::DocMetaInfoReader(Book &book) : myBook(book) {
	myBook.removeAllAuthors();
	myBook.setTitle(std::string());
	myBook.setLanguage(std::string());
	myBook.removeAllTags();
}

/*
void DocMetaInfoReader::characterDataHandler(const char *text, size_t len) {
}

void DocMetaInfoReader::startElementHandler(int tag, const char **) {
}

void DocMetaInfoReader::endElementHandler(int tag) {
}
*/

bool DocMetaInfoReader::readMetaInfo() {
	myBook.removeAllAuthors();
	myBook.setTitle(myBook.file().name(true));
	myBook.setEncoding("windows-1251"); //TODO implement encoding retrieving
	myBook.removeAllTags();
	return true;
}
