/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_20 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 4213, "epsg", 4213,
        "Beduaram");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106,-87,");
    add_proj4text (p, 1,
        "188,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Beduaram\",DATUM[\"Beduaram\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7011\"]],TOWGS84[-106,-87,188,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6213\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4213\"]]");
    p = add_epsg_def (filter, first, last, 4214, "epsg", 4214,
        "Beijing 1954");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=15.8,-154.4,-82.3,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]]");
    p = add_epsg_def (filter, first, last, 4215, "epsg", 4215,
        "Belge 1950");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1950\",DATUM[\"Reseau_National_Belge_1950");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6215\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"4215\"]]");
    p = add_epsg_def (filter, first, last, 4216, "epsg", 4216,
        "Bermuda 1957");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-73,213,296,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bermuda 1957\",DATUM[\"Bermuda_1957\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7008\"]],TOWGS84[-73,213,296,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6216\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4216\"]]");
    p = add_epsg_def (filter, first, last, 4217, "epsg", 4217,
        "NAD83 / BLM 59N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 59N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"4217\"]]");
    p = add_epsg_def (filter, first, last, 4218, "epsg", 4218,
        "Bogota 1975");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]]");
    p = add_epsg_def (filter, first, last, 4219, "epsg", 4219,
        "Bukit Rimpah");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-384,664,-48,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bukit Rimpah\",DATUM[\"Bukit_Rimpah\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7004\"]],TOWGS84[-384,664,-48,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6219\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4219\"]]");
    p = add_epsg_def (filter, first, last, 4220, "epsg", 4220,
        "Camacupa");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Camacupa\",DATUM[\"Camacupa\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],TOWGS84[-50.9,-347.6,-231,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4220\"]]");
    p = add_epsg_def (filter, first, last, 4221, "epsg", 4221,
        "Campo Inchauspe");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-148,136,90,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Campo Inchauspe\",DATUM[\"Campo_Inchauspe\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4221\"]]");
    p = add_epsg_def (filter, first, last, 4222, "epsg", 4222,
        "Cape");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs");
    add_proj4text (p, 1,
        "84=-136,-108,-292,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cape\",DATUM[\"Cape\",SPHEROID[\"Clarke 1880 (A");
    add_srs_wkt (p, 1,
        "rc)\",6378249.145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-136,-108,-292,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]]");
    p = add_epsg_def (filter, first, last, 4223, "epsg", 4223,
        "Carthage");
    add_proj4text (p, 0,
        "+proj=longlat +datum=carthage +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Carthage\",DATUM[\"Carthage\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7011\"]],TOWGS84[-263,6,431,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6223\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4223\"]]");
    p = add_epsg_def (filter, first, last, 4224, "epsg", 4224,
        "Chua");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-134,229,-29,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chua\",DATUM[\"Chua\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 2,
        "[-134,229,-29,0,0,0,0],AUTHORITY[\"EPSG\",\"6224\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4224\"]]");
    p = add_epsg_def (filter, first, last, 4225, "epsg", 4225,
        "Corrego Alegre 1970-72");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre");
    add_srs_wkt (p, 1,
        "_1970_72\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4225\"]]");
    p = add_epsg_def (filter, first, last, 4226, "epsg", 4226,
        "Cote d'Ivoire");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cote d'Ivoire\",DATUM[\"Cote_d_Ivoire\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936265,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6226\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"910");
    add_srs_wkt (p, 5,
        "8\"]],AUTHORITY[\"EPSG\",\"4226\"]]");
    p = add_epsg_def (filter, first, last, 4227, "epsg", 4227,
        "Deir ez Zor");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-190.421,");
    add_proj4text (p, 1,
        "8.532,238.69,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Deir ez Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7011\"]],TOWGS84[-190.421,8.532,238.69,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4227\"]]");
    p = add_epsg_def (filter, first, last, 4228, "epsg", 4228,
        "Douala");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Douala\",DATUM[\"Douala\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7011\"]],AUTHORITY[\"EPSG\",\"6228\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4228\"]]");
    p = add_epsg_def (filter, first, last, 4229, "epsg", 4229,
        "Egypt 1907");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +towgs84=-130,110,-13,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt 1907\",DATUM[\"Egypt_1907\",SPHEROID[\"He");
    add_srs_wkt (p, 1,
        "lmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-130,110,-13,0,0,0,0],AUTHORITY[\"EPSG\",\"6229");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4229\"]]");
    p = add_epsg_def (filter, first, last, 4230, "epsg", 4230,
        "ED50");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-87,-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]]");
    p = add_epsg_def (filter, first, last, 4231, "epsg", 4231,
        "ED87");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-83.11,-97.38,-117.22");
    add_proj4text (p, 1,
        ",0.00569291,-0.0446976,0.0442851,0.1218 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED87\",DATUM[\"European_Datum_1987\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-83.11,-97.38,-117.22,0.00569291,-0.04469");
    add_srs_wkt (p, 3,
        "76,0.0442851,0.1218],AUTHORITY[\"EPSG\",\"6231\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4231\"]]");
    p = add_epsg_def (filter, first, last, 4232, "epsg", 4232,
        "Fahud");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-346,-1,224,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fahud\",DATUM[\"Fahud\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 1,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[-346,-1,224,0,0,0,0],AUTHORITY[\"EPSG\",\"6232");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4232\"]]");
    p = add_epsg_def (filter, first, last, 4233, "epsg", 4233,
        "Gandajika 1970");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gandajika 1970\",DATUM[\"Gandajika_1970\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],TOWGS84[-133,-321,50,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6233\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4233\"]]");
    p = add_epsg_def (filter, first, last, 4234, "epsg", 4234,
        "Garoua");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Garoua\",DATUM[\"Garoua\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7011\"]],AUTHORITY[\"EPSG\",\"6234\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4234\"]]");
    p = add_epsg_def (filter, first, last, 4235, "epsg", 4235,
        "Guyane Francaise");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guyane Francaise\",DATUM[\"Guyane_Francaise\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6235\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"4235\"]]");
    p = add_epsg_def (filter, first, last, 4236, "epsg", 4236,
        "Hu Tzu Shan 1950");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-637,-549,-203,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hu Tzu Shan 1950\",DATUM[\"Hu_Tzu_Shan_1950\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],TOWGS84[-637,-549,-203,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6236\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4236\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4237, "epsg", 4237,
        "HD72");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +towgs84=52.17,-71.82,-14.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"HD72\",DATUM[\"Hungarian_Datum_1972\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"GRS 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7036\"]],TOWGS84[52.17,-71.82,-14.9,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6237\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4237\"]]");
    p = add_epsg_def (filter, first, last, 4238, "epsg", 4238,
        "ID74");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378160 +b=6356774.50408554 +towgs84=-2");
    add_proj4text (p, 1,
        "4,-15,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ID74\",DATUM[\"Indonesian_Datum_1974\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"Indonesian National Spheroid\",6378160,298.247,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4238");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4239, "epsg", 4239,
        "Indian 1954");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=217,823,299,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Indian 1954\",DATUM[\"Indian_1954\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],TOWGS84[217,823,299,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6239\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4239\"]]");
    p = add_epsg_def (filter, first, last, 4240, "epsg", 4240,
        "Indian 1975");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=210,814,289,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Indian 1975\",DATUM[\"Indian_1975\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],TOWGS84[210,814,289,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6240\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4240\"]]");
    p = add_epsg_def (filter, first, last, 4241, "epsg", 4241,
        "Jamaica 1875");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Jamaica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880\",6378249.144808011,293.4663076556349,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4241\"]]");
    p = add_epsg_def (filter, first, last, 4242, "epsg", 4242,
        "JAD69");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=70,207,389.5,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JAD69\",DATUM[\"Jamaica_1969\",SPHEROID[\"Clark");
    add_srs_wkt (p, 1,
        "e 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7008\"]],TOWGS84[70,207,389.5,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6242\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4242\"]]");
    p = add_epsg_def (filter, first, last, 4243, "epsg", 4243,
        "Kalianpur 1880");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kalianpur 1880\",DATUM[\"Kalianpur_1880\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Everest (1830 Definition)\",6377299.36559538,300.8");
    add_srs_wkt (p, 2,
        "017255433552,AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6243\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4243\"]]");
    p = add_epsg_def (filter, first, last, 4244, "epsg", 4244,
        "Kandawala");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=-97,787,86,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kandawala\",DATUM[\"Kandawala\",SPHEROID[\"Ever");
    add_srs_wkt (p, 1,
        "est 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7015\"]],TOWGS84[-97,787,86,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6244\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"424");
    add_srs_wkt (p, 6,
        "4\"]]");
    p = add_epsg_def (filter, first, last, 4245, "epsg", 4245,
        "Kertau 1968");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs");
    add_proj4text (p, 1,
        "84=-11,851,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]]");
    p = add_epsg_def (filter, first, last, 4246, "epsg", 4246,
        "KOC");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil_Company\",SPHEROID[\"C");
    add_srs_wkt (p, 1,
        "larke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],TOWGS84[-294.7,-200.1,525.5,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6246\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4246\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4247, "epsg", 4247,
        "La Canoa");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"La Canoa\",DATUM[\"La_Canoa\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-273.5,110.6,-357.9,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6247\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4247\"]]");
    p = add_epsg_def (filter, first, last, 4248, "epsg", 4248,
        "PSAD56");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-288,175,-376,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PSAD56\",DATUM[\"Provisional_South_American_Dat");
    add_srs_wkt (p, 1,
        "um_1956\",SPHEROID[\"International 1924\",6378388,297,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7022\"]],TOWGS84[-288,175,-376,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4248\"]]");
    p = add_epsg_def (filter, first, last, 4249, "epsg", 4249,
        "Lake");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lake\",DATUM[\"Lake\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6249\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4249\"");
    add_srs_wkt (p, 5,
        "]]");
    p = add_epsg_def (filter, first, last, 4250, "epsg", 4250,
        "Leigon");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Leigon\",DATUM[\"Leigon\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-130,29,364,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 3,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4250\"]]");
    p = add_epsg_def (filter, first, last, 4251, "epsg", 4251,
        "Liberia 1964");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-90,40,88,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Liberia 1964\",DATUM[\"Liberia_1964\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-90,40,88,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6251\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4251\"]]");
    p = add_epsg_def (filter, first, last, 4252, "epsg", 4252,
        "Lome");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lome\",DATUM[\"Lome\",SPHEROID[\"Clarke 1880 (I");
    add_srs_wkt (p, 1,
        "GN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "011\"]],AUTHORITY[\"EPSG\",\"6252\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4252\"]]");
    p = add_epsg_def (filter, first, last, 4253, "epsg", 4253,
        "Luzon 1911");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Luzon 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7008\"]],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]]");
    p = add_epsg_def (filter, first, last, 4254, "epsg", 4254,
        "Hito XVIII 1963");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=16,196,93,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hito XVIII 1963\",DATUM[\"Hito_XVIII_1963\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[16,196,93,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6254\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4254\"]]");
    p = add_epsg_def (filter, first, last, 4255, "epsg", 4255,
        "Herat North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-333,-222,114,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Herat North\",DATUM[\"Herat_North\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-333,-222,114,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6255\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4255\"]]");
    p = add_epsg_def (filter, first, last, 4256, "epsg", 4256,
        "Mahe 1971");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=41,-220,-134,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mahe 1971\",DATUM[\"Mahe_1971\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7012\"]],TOWGS84[41,-220,-134,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6256\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4256\"]]");
    p = add_epsg_def (filter, first, last, 4257, "epsg", 4257,
        "Makassar");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 1,
        "6,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Makassar\",DATUM[\"Makassar\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "4\"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6257\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4257\"]]");
    p = add_epsg_def (filter, first, last, 4258, "epsg", 4258,
        "ETRS89");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRS89\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_System_1989\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4258\"]]");
    p = add_epsg_def (filter, first, last, 4259, "epsg", 4259,
        "Malongo 1987");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-254.1,-5.36,-100.29,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Malongo 1987\",DATUM[\"Malongo_1987\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-254.1,-5.36,-100.29,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6259\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4259\"]]");
    p = add_epsg_def (filter, first, last, 4260, "epsg", 4260,
        "Manoca");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-70.9,-151.8,-41.4,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Manoca\",DATUM[\"Manoca\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6260\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"4260\"]]");
    p = add_epsg_def (filter, first, last, 4261, "epsg", 4261,
        "Merchich");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31,146,47");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Merchich\",DATUM[\"Merchich\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7011\"]],TOWGS84[31,146,47,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"]]");
    p = add_epsg_def (filter, first, last, 4262, "epsg", 4262,
        "Massawa");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=639,405,60,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Massawa\",DATUM[\"Massawa\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[639,405,60,0,0,0,0],AUTHORITY[\"EPSG\",\"6262");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4262\"]]");
    p = add_epsg_def (filter, first, last, 4263, "epsg", 4263,
        "Minna");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Minna\",DATUM[\"Minna\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 1,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[-92,-93,122,0,0,0,0],AUTHORITY[\"EPSG\",\"6263");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]]");
    p = add_epsg_def (filter, first, last, 4264, "epsg", 4264,
        "Mhast");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast\",DATUM[\"Mhast\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 2,
        "84[-252.95,-4.11,-96.38,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "64\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4264\"]]");
    p = add_epsg_def (filter, first, last, 4265, "epsg", 4265,
        "Monte Mario");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.9");
    add_proj4text (p, 1,
        "71,-2.917,0.714,-11.68 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Monte Mario\",DATUM[\"Monte_Mario\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.");
    add_srs_wkt (p, 3,
        "68],AUTHORITY[\"EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4265\"]]");
    p = add_epsg_def (filter, first, last, 4266, "epsg", 4266,
        "M'poraloko");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-74,-130,");
    add_proj4text (p, 1,
        "42,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"M'poraloko\",DATUM[\"M_poraloko\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[");
    add_srs_wkt (p, 2,
        "\"EPSG\",\"7011\"]],TOWGS84[-74,-130,42,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6266\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4266\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4267, "epsg", 4267,
        "NAD27");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD27 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4267\"]]");
    p = add_epsg_def (filter, first, last, 4268, "epsg", 4268,
        "NAD27 Michigan");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1866 Michigan\",6378450.047548896,294.97869");
    add_srs_wkt (p, 2,
        "71646739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]]");
    p = add_epsg_def (filter, first, last, 4269, "epsg", 4269,
        "NAD83");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD83 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    p = add_epsg_def (filter, first, last, 4270, "epsg", 4270,
        "Nahrwan 1967");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-242.2,-144.9,370.3");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nahrwan 1967\",DATUM[\"Nahrwan_1967\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-242.2,-144.9,370.3,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "70\"]]");
    p = add_epsg_def (filter, first, last, 4271, "epsg", 4271,
        "Naparima 1972");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-10,375,165,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Naparima 1972\",DATUM[\"Naparima_1972\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[-10,375,165,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6271\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4271\"]]");
    p = add_epsg_def (filter, first, last, 4272, "epsg", 4272,
        "NZGD49");
    add_proj4text (p, 0,
        "+proj=longlat +datum=nzgd49 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_194");
    add_srs_wkt (p, 1,
        "9\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0");
    add_srs_wkt (p, 3,
        ".1,1.024,-4.5993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4272\"]]");
    p = add_epsg_def (filter, first, last, 4273, "epsg", 4273,
        "NGO 1948");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs");
    add_proj4text (p, 1,
        "84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGO 1948\",DATUM[\"NGO_1948\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6273\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4273\"]]");
    p = add_epsg_def (filter, first, last, 4274, "epsg", 4274,
        "Datum 73");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-223.237,110.193,36.6");
    add_proj4text (p, 1,
        "49,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-223.237,110.193,36.649,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    p = add_epsg_def (filter, first, last, 4275, "epsg", 4275,
        "NTF");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NTF\",DATUM[\"Nouvelle_Triangulation_Francaise\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 2,
        "265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6275\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4275\"]]");
    p = add_epsg_def (filter, first, last, 4276, "epsg", 4276,
        "NSWC 9Z-2");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NSWC 9Z-2\",DATUM[\"NSWC_9Z_2\",SPHEROID[\"NWL ");
    add_srs_wkt (p, 1,
        "9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7025\"]],AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"6276\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4276\"");
    add_srs_wkt (p, 5,
        "]]");
    p = add_epsg_def (filter, first, last, 4277, "epsg", 4277,
        "OSGB 1936");
    add_proj4text (p, 0,
        "+proj=longlat +datum=OSGB36 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OSGB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],TOWGS84[446.448,-125.157,542.06,0.15,0.247,0.842,-");
    add_srs_wkt (p, 3,
        "20.489],AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4277\"]]");
    p = add_epsg_def (filter, first, last, 4278, "epsg", 4278,
        "OSGB70");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OSGB70\",DATUM[\"OSGB_1970_SN\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],AUTHORITY[\"EPSG\",\"6278\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"4278\"]]");
    p = add_epsg_def (filter, first, last, 4279, "epsg", 4279,
        "OS(SN)80");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OS(SN)80\",DATUM[\"OS_SN_1980\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],AUTHORITY[\"EPSG\",\"6279\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"4279\"]]");
    p = add_epsg_def (filter, first, last, 4280, "epsg", 4280,
        "Padang");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Padang\",DATUM[\"Padang_1884\",SPHEROID[\"Besse");
    add_srs_wkt (p, 1,
        "l 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "04\"]],AUTHORITY[\"EPSG\",\"6280\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"4280\"]]");
    p = add_epsg_def (filter, first, last, 4281, "epsg", 4281,
        "Palestine 1923");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-27");
    add_proj4text (p, 1,
        "5.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Palestine 1923\",DATUM[\"Palestine_1923\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (Benoit)\",6378300.789,293.46631553898");
    add_srs_wkt (p, 2,
        "02,AUTHORITY[\"EPSG\",\"7010\"]],TOWGS84[-275.722,94.782");
    add_srs_wkt (p, 3,
        "4,340.894,-8.001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "281\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4281\"]]");
    p = add_epsg_def (filter, first, last, 4282, "epsg", 4282,
        "Pointe Noire");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-148,51,-");
    add_proj4text (p, 1,
        "291,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pointe Noire\",DATUM[\"Congo_1960_Pointe_Noire\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 2,
        "265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-148,51,-291,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6282\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4282\"]]");
    p = add_epsg_def (filter, first, last, 4283, "epsg", 4283,
        "GDA94");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDA94\",DATUM[\"Geocentric_Datum_of_Australia_1");
    add_srs_wkt (p, 1,
        "994\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4283\"]]");
    p = add_epsg_def (filter, first, last, 4284, "epsg", 4284,
        "Pulkovo 1942");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=23.92,-141.27,-80.9,");
    add_proj4text (p, 1,
        "-0,0.35,0.82,-0.12 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]]");
    p = add_epsg_def (filter, first, last, 4285, "epsg", 4285,
        "Qatar 1974");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-128.16,-282.42,21.93");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qatar 1974\",DATUM[\"Qatar_1974\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[-128.16,-282.42,21.93,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6285\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4285\"]]");
    p = add_epsg_def (filter, first, last, 4286, "epsg", 4286,
        "Qatar 1948");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qatar 1948\",DATUM[\"Qatar_1948\",SPHEROID[\"He");
    add_srs_wkt (p, 1,
        "lmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6286\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"4286\"]]");
    p = add_epsg_def (filter, first, last, 4287, "epsg", 4287,
        "Qornoq");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qornoq\",DATUM[\"Qornoq\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 1,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[164,138,-189,0,0,0,0],AUTHORITY[\"EPSG\",\"6287\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "08\"]],AUTHORITY[\"EPSG\",\"4287\"]]");
    p = add_epsg_def (filter, first, last, 4288, "epsg", 4288,
        "Loma Quintana");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Loma Quintana\",DATUM[\"Loma_Quintana\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6288\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"4288\"]]");
    p = add_epsg_def (filter, first, last, 4289, "epsg", 4289,
        "Amersfoort");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=565.417,50.3319,465");
    add_proj4text (p, 1,
        ".552,-0.398957,0.343988,-1.8774,4.0725 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Amersfoort\",DATUM[\"Amersfoort\",SPHEROID[\"Be");
    add_srs_wkt (p, 1,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],TOWGS84[565.417,50.3319,465.552,-0.398957,0.343");
    add_srs_wkt (p, 3,
        "988,-1.8774,4.0725],AUTHORITY[\"EPSG\",\"6289\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4289\"]]");
    p = add_epsg_def (filter, first, last, 4291, "epsg", 4291,
        "SAD69");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69\",DATUM[\"South_American_Datum_1969\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1967\",6378160,298.247167427,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7036\"]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6291\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"4291\"]]");
    p = add_epsg_def (filter, first, last, 4292, "epsg", 4292,
        "Sapper Hill 1943");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-355,21,72,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sapper Hill 1943\",DATUM[\"Sapper_Hill_1943\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],TOWGS84[-355,21,72,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6292\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4292\"]]");
    p = add_epsg_def (filter, first, last, 4293, "epsg", 4293,
        "Schwarzeck");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bess_nam +towgs84=616,97,-251,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Schwarzeck\",DATUM[\"Schwarzeck\",SPHEROID[\"Be");
    add_srs_wkt (p, 1,
        "ssel Namibia (GLM)\",6377483.865280419,299.1528128,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7046\"]],TOWGS84[616,97,-251,0,0,0,0],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6293\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "293\"]]");
    p = add_epsg_def (filter, first, last, 4294, "epsg", 4294,
        "Segora");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segora\",DATUM[\"Segora\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 1,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY[\"EPSG\",\"6294");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9108\"]],AUTHORITY[\"EPSG\",\"4294\"]]");
    p = add_epsg_def (filter, first, last, 4295, "epsg", 4295,
        "Serindung");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Serindung\",DATUM[\"Serindung\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6295\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4295\"]]");
    p = add_epsg_def (filter, first, last, 4296, "epsg", 4296,
        "Sudan");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sudan\",DATUM[\"Sudan\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 1,
        "(IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7011\"]],AUTHORITY[\"EPSG\",\"6296\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4296\"]]");
    p = add_epsg_def (filter, first, last, 4297, "epsg", 4297,
        "Tananarive");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tananarive\",DATUM[\"Tananarive_1925\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-189,-242,-91,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6297\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4297\"]]");
    p = add_epsg_def (filter, first, last, 4298, "epsg", 4298,
        "Timbalai 1948");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=evrstSS +towgs84=-679,669,-48,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Timbalai 1948\",DATUM[\"Timbalai_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Everest 1830 (1967 Definition)\",6377298.556,300.801");
    add_srs_wkt (p, 2,
        "7,AUTHORITY[\"EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4298\"]]");
    p = add_epsg_def (filter, first, last, 4299, "epsg", 4299,
        "TM65");
    add_proj4text (p, 0,
        "+proj=longlat +datum=ire65 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TM65\",DATUM[\"TM65\",SPHEROID[\"Airy Modified ");
    add_srs_wkt (p, 1,
        "1849\",6377340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.1");
    add_srs_wkt (p, 3,
        "5],AUTHORITY[\"EPSG\",\"6299\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4299\"]]");
    p = add_epsg_def (filter, first, last, 4300, "epsg", 4300,
        "TM75");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 1,
        "6,-1.042,-0.214,-0.631,8.15 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TM75\",DATUM[\"Geodetic_Datum_of_1965\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Airy Modified 1849\",6377340.189,299.3249646,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7002\"]],TOWGS84[482.5,-130.6,564.6,-1.042");
    add_srs_wkt (p, 3,
        ",-0.214,-0.631,8.15],AUTHORITY[\"EPSG\",\"6300\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4300\"]]");
    p = add_epsg_def (filter, first, last, 4301, "epsg", 4301,
        "Tokyo");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 1,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 2,
        "OWGS84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]]");
    p = add_epsg_def (filter, first, last, 4302, "epsg", 4302,
        "Trinidad 1903");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+towgs84=-61.702,284.488,472.052,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Trinidad 1903\",DATUM[\"Trinidad_1903\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1858\",6378293.645208759,294.2606763692569,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7007\"]],TOWGS84[-61.702,284.488,472.");
    add_srs_wkt (p, 3,
        "052,0,0,0,0],AUTHORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4302\"]]");
    p = add_epsg_def (filter, first, last, 4303, "epsg", 4303,
        "TC(1948)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TC(1948)\",DATUM[\"Trucial_Coast_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Helmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "20\"]],AUTHORITY[\"EPSG\",\"6303\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"4303\"]]");
    p = add_epsg_def (filter, first, last, 4304, "epsg", 4304,
        "Voirol 1875");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.4660212936265,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"430");
    add_srs_wkt (p, 6,
        "4\"]]");
    p = add_epsg_def (filter, first, last, 4306, "epsg", 4306,
        "Bern 1938");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1938\",DATUM[\"Bern_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6306\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4306\"]]");
    p = add_epsg_def (filter, first, last, 4307, "epsg", 4307,
        "Nord Sahara 1959");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-209.362,-87.8162,4");
    add_proj4text (p, 1,
        "04.62,0.0046,3.4784,0.5805,-1.4547 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959\",DATUM[\"Nord_Sahara_1959\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],TOWGS84[-209.362,-87.8162,404.62");
    add_srs_wkt (p, 3,
        ",0.0046,3.4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4307\"]]");
    p = add_epsg_def (filter, first, last, 4308, "epsg", 4308,
        "RT38");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38\",DATUM[\"Stockholm_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6308\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4308\"]]");
    p = add_epsg_def (filter, first, last, 4309, "epsg", 4309,
        "Yacare");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yacare\",DATUM[\"Yacare\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 1,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[-155,171,37,0,0,0,0],AUTHORITY[\"EPSG\",\"6309\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4309\"]]");
    p = add_epsg_def (filter, first, last, 4310, "epsg", 4310,
        "Yoff");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yoff\",DATUM[\"Yoff\",SPHEROID[\"Clarke 1880 (I");
    add_srs_wkt (p, 1,
        "GN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "011\"]],AUTHORITY[\"EPSG\",\"6310\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"4310\"]]");
    p = add_epsg_def (filter, first, last, 4311, "epsg", 4311,
        "Zanderij");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Zanderij\",DATUM[\"Zanderij\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-265,120,-358,0,0,0,0],AUTHORITY[\"EPSG\",\"631");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4311\"]]");
    p = add_epsg_def (filter, first, last, 4312, "epsg", 4312,
        "MGI");
    add_proj4text (p, 0,
        "+proj=longlat +datum=hermannskogel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI\",DATUM[\"Militar_Geographische_Institute\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5");
    add_srs_wkt (p, 3,
        ".137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6312\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4312\"]]");
    p = add_epsg_def (filter, first, last, 4313, "epsg", 4313,
        "Belge 1972");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-106.869,52.2978,-103");
    add_proj4text (p, 1,
        ".724,0.3366,-0.457,1.8422,-1.2747 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1972\",DATUM[\"Reseau_National_Belge_1972");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[-106.869,52.2978,-103.724,0");
    add_srs_wkt (p, 3,
        ".3366,-0.457,1.8422,-1.2747],AUTHORITY[\"EPSG\",\"6313\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4313\"]]");
    p = add_epsg_def (filter, first, last, 4314, "epsg", 4314,
        "DHDN");
    add_proj4text (p, 0,
        "+proj=longlat +datum=potsdam +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.04");
    add_srs_wkt (p, 3,
        "5,-2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4314\"]]");
    p = add_epsg_def (filter, first, last, 4315, "epsg", 4315,
        "Conakry 1905");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (IGN)\",6378249.2,293.4660212936265,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7011\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"431");
    add_srs_wkt (p, 6,
        "5\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

