/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_35 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 24312, "epsg", 24312,
        "Kalianpur 1962 / UTM zone 42N");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",69],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24312");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24313, "epsg", 24313,
        "Kalianpur 1962 / UTM zone 43N");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24313");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24342, "epsg", 24342,
        "Kalianpur 1975 / UTM zone 42N");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",69],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24342");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24343, "epsg", 24343,
        "Kalianpur 1975 / UTM zone 43N");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24343");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24344, "epsg", 24344,
        "Kalianpur 1975 / UTM zone 44N");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 44N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",81],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24344");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24345, "epsg", 24345,
        "Kalianpur 1975 / UTM zone 45N");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",87],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24345");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24346, "epsg", 24346,
        "Kalianpur 1975 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",93],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24346");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24347, "epsg", 24347,
        "Kalianpur 1975 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 47N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",99],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24347");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24370, "epsg", 24370,
        "Kalianpur 1880 / India zone 0");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846");
    add_proj4text (p, 1,
        "154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377");
    add_proj4text (p, 2,
        "299.36559538 +b=6356098.359005156 +to_meter=0.9143985307");
    add_proj4text (p, 3,
        "444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone 0\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433552,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",39.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99846154],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "355500],PARAMETER[\"false_northing\",2590000],UNIT[\"Ind");
    add_srs_wkt (p, 11,
        "ian yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24370\"]]");
    p = add_epsg_def (filter, first, last, 24371, "epsg", 24371,
        "Kalianpur 1880 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=637");
    add_proj4text (p, 2,
        "7299.36559538 +b=6356098.359005156 +to_meter=0.914398530");
    add_proj4text (p, 3,
        "7444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433552,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",32.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99878641],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"Ind");
    add_srs_wkt (p, 11,
        "ian yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24371\"]]");
    p = add_epsg_def (filter, first, last, 24372, "epsg", 24372,
        "Kalianpur 1880 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433552,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",74],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24372\"]]");
    p = add_epsg_def (filter, first, last, 24373, "epsg", 24373,
        "Kalianpur 1880 / India zone IIIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t (1830 Definition)\",6377299.36559538,300.8017255433552");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",19],PARAMETER[\"central_meridian\",80],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99878641],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"Ind");
    add_srs_wkt (p, 11,
        "ian yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24373\"]]");
    p = add_epsg_def (filter, first, last, 24374, "epsg", 24374,
        "Kalianpur 1880 / India zone IVa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433552,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",12],PARAMETER[\"central_meridian\",80],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24374\"]]");
    p = add_epsg_def (filter, first, last, 24375, "epsg", 24375,
        "Kalianpur 1937 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075");
    add_proj4text (p, 2,
        ".41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",26],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",90],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",2743185.69],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",914395.23],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"24375\"]]");
    p = add_epsg_def (filter, first, last, 24376, "epsg", 24376,
        "Kalianpur 1962 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=63561");
    add_proj4text (p, 2,
        "00.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",32.5],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",68],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743196.4],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24376\"]]");
    p = add_epsg_def (filter, first, last, 24377, "epsg", 24377,
        "Kalianpur 1962 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.2");
    add_proj4text (p, 2,
        "30165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1962 Definition)\",6377301.243,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "45\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",74],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743196.4],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24377\"]]");
    p = add_epsg_def (filter, first, last, 24378, "epsg", 24378,
        "Kalianpur 1975 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=63560");
    add_proj4text (p, 2,
        "98.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",32.5],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",68],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24378\"]]");
    p = add_epsg_def (filter, first, last, 24379, "epsg", 24379,
        "Kalianpur 1975 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",74],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24379\"]]");
    p = add_epsg_def (filter, first, last, 24380, "epsg", 24380,
        "Kalianpur 1975 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",90],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24380\"]]");
    p = add_epsg_def (filter, first, last, 24381, "epsg", 24381,
        "Kalianpur 1975 / India zone IIIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "146\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",19],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",80],PARAMETER[\"scale_factor\",0.99878641],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",2743195.5],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"24381\"]]");
    p = add_epsg_def (filter, first, last, 24382, "epsg", 24382,
        "Kalianpur 1880 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433552,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",90],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24382\"]]");
    p = add_epsg_def (filter, first, last, 24383, "epsg", 24383,
        "Kalianpur 1975 / India zone IVa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",12],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",80],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24383\"]]");
    p = add_epsg_def (filter, first, last, 24500, "epsg", 24500,
        "Kertau 1968 / Singapore Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=1.287646666666667 +lon_0=103.853002222");
    add_proj4text (p, 1,
        "2222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038");
    add_proj4text (p, 2,
        "993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Singapore Grid\",GEOGCS[\"Kertau ");
    add_srs_wkt (p, 1,
        "1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mod");
    add_srs_wkt (p, 2,
        "ified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cass");
    add_srs_wkt (p, 7,
        "ini_Soldner\"],PARAMETER[\"latitude_of_origin\",1.287646");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"central_meridian\",103.8530022222");
    add_srs_wkt (p, 9,
        "222],PARAMETER[\"false_easting\",30000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"24500\"]]");
    p = add_epsg_def (filter, first, last, 24547, "epsg", 24547,
        "Kertau 1968 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 47N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",99],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"24547\"]]");
    p = add_epsg_def (filter, first, last, 24548, "epsg", 24548,
        "Kertau 1968 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 48N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"24548\"]]");
    p = add_epsg_def (filter, first, last, 24571, "epsg", 24571,
        "Kertau / R.S.O. Malaya (ch) (deprecated)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804671.2997750348 +y_0=0 +no_uoff +gamma=32");
    add_proj4text (p, 2,
        "3.1301023611111 +a=6377304.063 +b=6356103.038993155 +tow");
    add_proj4text (p, 3,
        "gs84=-11,851,5,0,0,0,0 +to_meter=20.11678249437587 +no_d");
    add_proj4text (p, 4,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau / R.S.O. Malaya (ch) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Ever");
    add_srs_wkt (p, 2,
        "est 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_center\",4],PARAMETER[\"longitude_of_center\",102.25]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"azimuth\",323.0257905],PARAMETER[\"rectifie");
    add_srs_wkt (p, 10,
        "d_grid_angle\",323.1301023611111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 11,
        "or\",0.99984],PARAMETER[\"false_easting\",40000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"British chain (Benoit 18");
    add_srs_wkt (p, 13,
        "95 B)\",20.11678249437587,AUTHORITY[\"EPSG\",\"9062\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"24571\"]]");
    p = add_epsg_def (filter, first, last, 24600, "epsg", 24600,
        "KOC Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KOC Lambert\",GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil");
    add_srs_wkt (p, 1,
        "_Company\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-294.7,-200.");
    add_srs_wkt (p, 3,
        "1,525.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6246\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4246\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",45],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9987864078],PARAMETER[\"false_easting\",1500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",1166200],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24600\"]]");
    p = add_epsg_def (filter, first, last, 24718, "epsg", 24718,
        "La Canoa / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 18N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24718\"]]");
    p = add_epsg_def (filter, first, last, 24719, "epsg", 24719,
        "La Canoa / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 19N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24719\"]]");
    p = add_epsg_def (filter, first, last, 24720, "epsg", 24720,
        "La Canoa / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 20N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24720\"]]");
    p = add_epsg_def (filter, first, last, 24817, "epsg", 24817,
        "PSAD56 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24817\"]]");
    p = add_epsg_def (filter, first, last, 24818, "epsg", 24818,
        "PSAD56 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24818\"]]");
    p = add_epsg_def (filter, first, last, 24819, "epsg", 24819,
        "PSAD56 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24819\"]]");
    p = add_epsg_def (filter, first, last, 24820, "epsg", 24820,
        "PSAD56 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24820\"]]");
    p = add_epsg_def (filter, first, last, 24821, "epsg", 24821,
        "PSAD56 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24821\"]]");
    p = add_epsg_def (filter, first, last, 24877, "epsg", 24877,
        "PSAD56 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24877\"]]");
    p = add_epsg_def (filter, first, last, 24878, "epsg", 24878,
        "PSAD56 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24878\"]]");
    p = add_epsg_def (filter, first, last, 24879, "epsg", 24879,
        "PSAD56 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24879\"]]");
    p = add_epsg_def (filter, first, last, 24880, "epsg", 24880,
        "PSAD56 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24880\"]]");
    p = add_epsg_def (filter, first, last, 24881, "epsg", 24881,
        "PSAD56 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24881\"]]");
    p = add_epsg_def (filter, first, last, 24882, "epsg", 24882,
        "PSAD56 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 22S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24882\"]]");
    p = add_epsg_def (filter, first, last, 24891, "epsg", 24891,
        "PSAD56 / Peru west zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=22");
    add_proj4text (p, 1,
        "2000 +y_0=1426834.743 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru west zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",-6],PARAMETER[\"central_meridian\",-80.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.99983008],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",222000],PARAMETER[\"false_northing\",1426834.743],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24891\"]]");
    p = add_epsg_def (filter, first, last, 24892, "epsg", 24892,
        "PSAD56 / Peru central zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=72");
    add_proj4text (p, 1,
        "0000 +y_0=1039979.159 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru central zone\",GEOGCS[\"PSAD56\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Provisional_South_American_Datum_1956\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",-9.5],PARAMETER[\"central_meridian\",-76],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99932994],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",720000],PARAMETER[\"false_northing\",1039979.159],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24892\"]]");
    p = add_epsg_def (filter, first, last, 24893, "epsg", 24893,
        "PSAD56 / Peru east zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=");
    add_proj4text (p, 1,
        "1324000 +y_0=1040084.558 +ellps=intl +towgs84=-288,175,-");
    add_proj4text (p, 2,
        "376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru east zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",-9.5],PARAMETER[\"central_meridian\",-70.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99952992],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",1324000],PARAMETER[\"false_northing\",1040084.558],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24893\"]]");
    p = add_epsg_def (filter, first, last, 25000, "epsg", 25000,
        "Leigon / Ghana Metre Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
        "5 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,3");
    add_proj4text (p, 2,
        "64,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Leigon / Ghana Metre Grid\",GEOGCS[\"Leigon\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Leigon\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.1");
    add_srs_wkt (p, 2,
        "45,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-130,29");
    add_srs_wkt (p, 3,
        ",364,0,0,0,0],AUTHORITY[\"EPSG\",\"6250\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4250\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",4.666666666666667],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-1],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.99975],PARAMETER[\"false_easting\",274319.51],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"25000\"]]");
    p = add_epsg_def (filter, first, last, 25231, "epsg", 25231,
        "Lome / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lome / UTM zone 31N\",GEOGCS[\"Lome\",DATUM[\"L");
    add_srs_wkt (p, 1,
        "ome\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "12936265,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6252\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4252\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"25231\"]]");
    p = add_epsg_def (filter, first, last, 25391, "epsg", 25391,
        "Luzon 1911 / Philippines zone I");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone I\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"6253");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",117],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99995],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25391\"]]");
    p = add_epsg_def (filter, first, last, 25392, "epsg", 25392,
        "Luzon 1911 / Philippines zone II");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone II\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",119],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25392\"]]");
    p = add_epsg_def (filter, first, last, 25393, "epsg", 25393,
        "Luzon 1911 / Philippines zone III");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone III\",GEOGCS[\"Lu");
    add_srs_wkt (p, 1,
        "zon 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "53\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",121],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25393\"]]");
    p = add_epsg_def (filter, first, last, 25394, "epsg", 25394,
        "Luzon 1911 / Philippines zone IV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone IV\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",123],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99995],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"25394\"]]");
    p = add_epsg_def (filter, first, last, 25395, "epsg", 25395,
        "Luzon 1911 / Philippines zone V");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone V\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-133,-77,-51,0,0,0,0],AUTHORITY[\"EPSG\",\"6253");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4253\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",125],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99995],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25395\"]]");
    p = add_epsg_def (filter, first, last, 25700, "epsg", 25700,
        "Makassar (Jakarta) / NEIEZ (deprecated)");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=");
    add_proj4text (p, 2,
        "jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Makassar (Jakarta) / NEIEZ (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Makassar (Jakarta)\",DATUM[\"Makassar_Jakarta\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",106.807");
    add_srs_wkt (p, 5,
        "7194444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4804\"]],PROJECTION[\"Mercator_1SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",110],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.997],PARAMETER[\"false_easting\",3900000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",900000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"25700\"]]");
    p = add_epsg_def (filter, first, last, 25828, "epsg", 25828,
        "ETRS89 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 28N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-15],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"25828\"]]");
    p = add_epsg_def (filter, first, last, 25829, "epsg", 25829,
        "ETRS89 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 29N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25829\"]]");
    p = add_epsg_def (filter, first, last, 25830, "epsg", 25830,
        "ETRS89 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 30N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25830\"]]");
    p = add_epsg_def (filter, first, last, 25831, "epsg", 25831,
        "ETRS89 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",3],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25831\"]]");
    p = add_epsg_def (filter, first, last, 25832, "epsg", 25832,
        "ETRS89 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25832\"]]");
    p = add_epsg_def (filter, first, last, 25833, "epsg", 25833,
        "ETRS89 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25833\"]]");
    p = add_epsg_def (filter, first, last, 25834, "epsg", 25834,
        "ETRS89 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25834\"]]");
    p = add_epsg_def (filter, first, last, 25835, "epsg", 25835,
        "ETRS89 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25835\"]]");
    p = add_epsg_def (filter, first, last, 25836, "epsg", 25836,
        "ETRS89 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",33],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25836\"]]");
    p = add_epsg_def (filter, first, last, 25837, "epsg", 25837,
        "ETRS89 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 37N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"25837\"]]");
    p = add_epsg_def (filter, first, last, 25838, "epsg", 25838,
        "ETRS89 / UTM zone 38N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 38N (deprecated)\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "TRS89\",DATUM[\"European_Terrestrial_Reference_System_19");
    add_srs_wkt (p, 2,
        "89\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"25838\"]]");
    p = add_epsg_def (filter, first, last, 25884, "epsg", 25884,
        "ETRS89 / TM Baltic93");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM Baltic93\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",24],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"25884\"]]");
    p = add_epsg_def (filter, first, last, 25932, "epsg", 25932,
        "Malongo 1987 / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-254.1,-5");
    add_proj4text (p, 1,
        ".36,-100.29,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Malongo 1987 / UTM zone 32S\",GEOGCS[\"Malongo ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Malongo_1987\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-254.1,-5.36,-100.29,0,0,0,0],AUTHORITY[\"EPSG\",\"6259\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4259\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"25932\"]]");
    p = add_epsg_def (filter, first, last, 26191, "epsg", 26191,
        "Merchich / Nord Maroc");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +");
    add_proj4text (p, 2,
        "towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Nord Maroc\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999625769],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26191\"]]");
    p = add_epsg_def (filter, first, last, 26192, "epsg", 26192,
        "Merchich / Sud Maroc");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.7 +lat_0=29.7 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6155960000001 +x_0=500000 +y_0=300000 +a=6378249.2 +b=63");
    add_proj4text (p, 2,
        "56515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sud Maroc\",GEOGCS[\"Merchich\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,");
    add_srs_wkt (p, 2,
        "293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",29.7],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999615596],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26192\"]]");
    p = add_epsg_def (filter, first, last, 26193, "epsg", 26193,
        "Merchich / Sahara (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara (deprecated)\",GEOGCS[\"Merch");
    add_srs_wkt (p, 1,
        "ich\",DATUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26.1],PARAMETER[\"central_meridian\",-5.4],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",12");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",400000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26193\"]]");
    p = add_epsg_def (filter, first, last, 26194, "epsg", 26194,
        "Merchich / Sahara Nord");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616304 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Nord\",GEOGCS[\"Merchich\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26.1");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999616304],PARAMETER[\"false_easting\",12000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26194\"]]");
    p = add_epsg_def (filter, first, last, 26195, "epsg", 26195,
        "Merchich / Sahara Sud");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.5 +lat_0=22.5 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616437 +x_0=1500000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Sud\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[31,146,47,0,0,0,0],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4261\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",22.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-5.4],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999616437],PARAMETER[\"false_easting\",150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26195\"]]");
    p = add_epsg_def (filter, first, last, 26237, "epsg", 26237,
        "Massawa / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=bessel +towgs84=639,405,60,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Massawa / UTM zone 37N\",GEOGCS[\"Massawa\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Massawa\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[639,405,60");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6262\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4262\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"26237\"]]");
    p = add_epsg_def (filter, first, last, 26331, "epsg", 26331,
        "Minna / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 31N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,122,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26331\"]]");
    p = add_epsg_def (filter, first, last, 26332, "epsg", 26332,
        "Minna / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 32N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,122,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26332\"]]");
    p = add_epsg_def (filter, first, last, 26391, "epsg", 26391,
        "Minna / Nigeria West Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=4.5 +k=0.99975 +x_0=230738.2");
    add_proj4text (p, 1,
        "6 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria West Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,1");
    add_srs_wkt (p, 3,
        "22,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",4.5],PARAMETER[\"scale_factor\",0.99975],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",230738.26],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26391\"]]");
    p = add_epsg_def (filter, first, last, 26392, "epsg", 26392,
        "Minna / Nigeria Mid Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=8.5 +k=0.99975 +x_0=670553.9");
    add_proj4text (p, 1,
        "8 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria Mid Belt\",GEOGCS[\"Minna\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,12");
    add_srs_wkt (p, 3,
        "2,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",8.5],PARAMETER[\"scale_factor\",0.99975],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",670553.98],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26392\"]]");
    p = add_epsg_def (filter, first, last, 26393, "epsg", 26393,
        "Minna / Nigeria East Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=12.5 +k=0.99975 +x_0=1110369");
    add_proj4text (p, 1,
        ".7 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria East Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-92,-93,1");
    add_srs_wkt (p, 3,
        "22,0,0,0,0],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4263\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",4],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",12.5],PARAMETER[\"scale_factor\",0.99975],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1110369.7],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"26393\"]]");
    p = add_epsg_def (filter, first, last, 26432, "epsg", 26432,
        "Mhast / UTM zone 32S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-252.95,-");
    add_proj4text (p, 1,
        "4.11,-96.38,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast / UTM zone 32S (deprecated)\",GEOGCS[\"Mh");
    add_srs_wkt (p, 1,
        "ast\",DATUM[\"Mhast\",SPHEROID[\"International 1924\",63");
    add_srs_wkt (p, 2,
        "78388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-252.95,");
    add_srs_wkt (p, 3,
        "-4.11,-96.38,0,0,0,0],AUTHORITY[\"EPSG\",\"6264\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4264\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26432\"]]");
    p = add_epsg_def (filter, first, last, 26591, "epsg", 26591,
        "Monte Mario (Rome) / Italy zone 1 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-3.45233333333333 +k=0.9996 ");
    add_proj4text (p, 1,
        "+x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9");
    add_proj4text (p, 2,
        ".9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario (Rome) / Italy zone 1 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917");
    add_srs_wkt (p, 4,
        ",0.714,-11.68],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"Ro");
    add_srs_wkt (p, 5,
        "me\",12.45233333333333,AUTHORITY[\"EPSG\",\"8906\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4806\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-3.45233333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",150");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26591\"]]");
    p = add_epsg_def (filter, first, last, 26592, "epsg", 26592,
        "Monte Mario (Rome) / Italy zone 2 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=2.54766666666666 +k=0.9996 +");
    add_proj4text (p, 1,
        "x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.");
    add_proj4text (p, 2,
        "9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario (Rome) / Italy zone 2 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[-104.1,-49.1,-9.9,0.971,-2.917");
    add_srs_wkt (p, 4,
        ",0.714,-11.68],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"Ro");
    add_srs_wkt (p, 5,
        "me\",12.45233333333333,AUTHORITY[\"EPSG\",\"8906\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4806\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",2.54766666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",25200");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"26592\"]]");
    p = add_epsg_def (filter, first, last, 26632, "epsg", 26632,
        "M'poraloko / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-74,");
    add_proj4text (p, 1,
        "-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32N\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-74,-130,42,0,0,0,0],AUTHORITY[\"EPSG\",\"6266\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4266\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26632\"]]");
    p = add_epsg_def (filter, first, last, 26692, "epsg", 26692,
        "M'poraloko / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-74,-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32S\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-74,-130,42,0,0,0,0],AUTHORITY[\"EPSG\",\"6266\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4266\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26692\"]]");
    p = add_epsg_def (filter, first, last, 26701, "epsg", 26701,
        "NAD27 / UTM zone 1N");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 1N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26701\"]]");
    p = add_epsg_def (filter, first, last, 26702, "epsg", 26702,
        "NAD27 / UTM zone 2N");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 2N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26702\"]]");
    p = add_epsg_def (filter, first, last, 26703, "epsg", 26703,
        "NAD27 / UTM zone 3N");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 3N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26703\"]]");
    p = add_epsg_def (filter, first, last, 26704, "epsg", 26704,
        "NAD27 / UTM zone 4N");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 4N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26704\"]]");
    p = add_epsg_def (filter, first, last, 26705, "epsg", 26705,
        "NAD27 / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 5N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26705\"]]");
    p = add_epsg_def (filter, first, last, 26706, "epsg", 26706,
        "NAD27 / UTM zone 6N");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 6N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26706\"]]");
    p = add_epsg_def (filter, first, last, 26707, "epsg", 26707,
        "NAD27 / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 7N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26707\"]]");
    p = add_epsg_def (filter, first, last, 26708, "epsg", 26708,
        "NAD27 / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 8N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26708\"]]");
    p = add_epsg_def (filter, first, last, 26709, "epsg", 26709,
        "NAD27 / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 9N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26709\"]]");
    p = add_epsg_def (filter, first, last, 26710, "epsg", 26710,
        "NAD27 / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 10N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26710\"]]");
    p = add_epsg_def (filter, first, last, 26711, "epsg", 26711,
        "NAD27 / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 11N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26711\"]]");
    p = add_epsg_def (filter, first, last, 26712, "epsg", 26712,
        "NAD27 / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 12N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26712\"]]");
    p = add_epsg_def (filter, first, last, 26713, "epsg", 26713,
        "NAD27 / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 13N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26713\"]]");
    p = add_epsg_def (filter, first, last, 26714, "epsg", 26714,
        "NAD27 / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 14N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6714\"]]");
    p = add_epsg_def (filter, first, last, 26715, "epsg", 26715,
        "NAD27 / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 15N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6715\"]]");
    p = add_epsg_def (filter, first, last, 26716, "epsg", 26716,
        "NAD27 / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 16N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6716\"]]");
    p = add_epsg_def (filter, first, last, 26717, "epsg", 26717,
        "NAD27 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 17N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6717\"]]");
    p = add_epsg_def (filter, first, last, 26718, "epsg", 26718,
        "NAD27 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 18N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6718\"]]");
    p = add_epsg_def (filter, first, last, 26719, "epsg", 26719,
        "NAD27 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 19N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6719\"]]");
    p = add_epsg_def (filter, first, last, 26720, "epsg", 26720,
        "NAD27 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 20N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6720\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

