/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef ADDLISTDIALOG_H
#define ADDLISTDIALOG_H

//(*Headers(AddListDialog)
#include <wx/sizer.h>
#include <wx/radiobox.h>
#include <wx/checkbox.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class AddListDialog: public wxDialog
{
	public:

		AddListDialog(wxWindow* parent,wxWindowID id=wxID_ANY);
		virtual ~AddListDialog();

		//(*Declarations(AddListDialog)
		wxButton* Button1;
		wxCheckBox* CheckBox3;
		wxCheckBox* CheckBox2;
		wxPanel* Panel1;
		wxButton* Button2;
		wxCheckBox* CheckBox1;
		wxRadioBox* RadioBox1;
		//*)

		int GetSel() const { return ex_sel; }

		void SetOptions(bool l1, bool l2, bool l3)
		{
		    CheckBox1->SetValue(l1);
		    CheckBox2->SetValue(l2);
		    CheckBox3->SetValue(l3);
		}

		bool GetL1() const { return ex_l1; }
		bool GetL2() const { return ex_l2; }
		bool GetL3() const { return ex_l3; }

	protected:

		//(*Identifiers(AddListDialog)
		static const long ID_RADIOBOX1;
		static const long ID_CHECKBOX1;
		static const long ID_CHECKBOX2;
		static const long ID_CHECKBOX3;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_PANEL1;
		//*)

		int ex_sel;
		bool ex_l1, ex_l2, ex_l3;

	private:

		//(*Handlers(AddListDialog)
		void OnOK(wxCommandEvent& event);
		void OnCANCEL(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
