/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef DWPRINTOUT_H
#define DWPRINTOUT_H

#include <wx/printdlg.h>
#include <wx/msgdlg.h>
#include <wx/dc.h>
#include <wx/print.h>
#include <wx/image.h>
#include <wx/file.h>
#include <wx/dcmemory.h>

#if wxUSE_LIBGNOMEPRINT
#include <wx/html/forcelnk.h>
FORCE_LINK(gnome_print)
#endif


class DWPrintout : public wxPrintout
{
    wxPageSetupDialogData page_setup;
    int orient;
    int max_x, max_y;
    int pageAmount;

    wxBitmap PDMIB;
    wxPoint discpos;
    int CurrentCase;

    static const int brush_size = 3;


    public:

        DWPrintout(int pageAmount, wxString title);
        ~DWPrintout();

        void SetDC(wxBitmap bitmap, int currentcase);
        void SetDiscPosition(wxPoint point);
        bool OnPrintPage(int pageNum);
        void preparePrint(const bool showPageSetupDialog=false);
        void OnBeginPrinting();
        bool OnBeginDocument(int startPage, int endPage);
        void GetPageInfo(int *minPage, int *maxPage, int *pageSelFrom, int *pageSelTo);
        bool HasPage(int pageNum);
        void OnEndPrinting();

    protected:
    private:
};

#endif // DWPRINTOUT_H
