/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#ifndef NEWDIALOG_H
#define NEWDIALOG_H

#include "CommonFunctions.h"

//(*Headers(NewDialog)
#include <wx/listctrl.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class NewDialog: public wxDialog
{
	public:

		NewDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~NewDialog();

		//(*Declarations(NewDialog)
		wxListCtrl* ListCtrl1;
		wxButton* Button1;
		wxPanel* Panel1;
		wxStaticText* StaticText1;
		wxButton* Button2;
		wxListCtrl* ListCtrl2;
		wxStaticLine* StaticLine2;
		wxButton* Button3;
		//*)

		wxString GetPath() const { return ChosenP; }
		int GetCase() const {
		    long i;
		    ChosenC.ToLong(&i);
		    return(int(i));
		    }

	protected:

		//(*Identifiers(NewDialog)
		static const long ID_LISTCTRL1;
		static const long ID_STATICLINE2;
		static const long ID_LISTCTRL2;
		static const long ID_BUTTON3;
		static const long ID_STATICTEXT1;
		static const long ID_BUTTON2;
		static const long ID_BUTTON1;
		static const long ID_PANEL1;
		//*)

        wxString ChosenP, ChosenC;

	private:

		//(*Handlers(NewDialog)
		void OnCancelClick(wxCommandEvent& event);
		void OnListCtrl1ItemSelect(wxListEvent& event);
		void OnListCtrl2ItemSelect(wxListEvent& event);
		void OnOKClick(wxCommandEvent& event);
		void OnClose(wxCloseEvent& event);
		void OnListCtrl2ItemActivated(wxListEvent& event);
		void OnAboutDesign(wxCommandEvent& event);
		//*)
        void LoadPreTemplate(wxString filename);
		void On_OK();

		wxArrayString Cpath, Cauth, Ccont, Clic, Cdate, CCase;

        wxImageList *imageList;

        CommonFunctions CFs_6;

		DECLARE_EVENT_TABLE()
};

#endif
