/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#include "DiscWrapperMain.h"
#include "PreferencesDialog.h"

//(*InternalHeaders(PreferencesDialog)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
//*)

#include <wx/dirdlg.h>
#include <wx/dir.h>
#include <wx/fontdlg.h>
#include <wx/font.h>
#include <wx/colordlg.h>
#include <wx/colour.h>
#include <wx/file.h>
#include <wx/dir.h>

//(*IdInit(PreferencesDialog)
const long PreferencesDialog::ID_STATICTEXT1 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT2 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT3 = wxNewId();
const long PreferencesDialog::ID_CHOICE1 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT5 = wxNewId();
const long PreferencesDialog::ID_CHECKBOX1 = wxNewId();
const long PreferencesDialog::ID_CHECKBOX2 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT4 = wxNewId();
const long PreferencesDialog::ID_BUTTON1 = wxNewId();
const long PreferencesDialog::ID_BUTTON2 = wxNewId();
const long PreferencesDialog::ID_PANEL2 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT11 = wxNewId();
const long PreferencesDialog::ID_TEXTCTRL1 = wxNewId();
const long PreferencesDialog::ID_BUTTON5 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT12 = wxNewId();
const long PreferencesDialog::ID_TEXTCTRL2 = wxNewId();
const long PreferencesDialog::ID_BUTTON6 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT13 = wxNewId();
const long PreferencesDialog::ID_TEXTCTRL3 = wxNewId();
const long PreferencesDialog::ID_BUTTON7 = wxNewId();
const long PreferencesDialog::ID_PANEL5 = wxNewId();
const long PreferencesDialog::ID_STATICTEXT10 = wxNewId();
const long PreferencesDialog::ID_CHOICE2 = wxNewId();
const long PreferencesDialog::ID_PANEL4 = wxNewId();
const long PreferencesDialog::ID_NOTEBOOK1 = wxNewId();
const long PreferencesDialog::ID_BUTTON3 = wxNewId();
const long PreferencesDialog::ID_BUTTON4 = wxNewId();
const long PreferencesDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(PreferencesDialog,wxDialog)
	//(*EventTable(PreferencesDialog)
	//*)
END_EVENT_TABLE()

PreferencesDialog::PreferencesDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    CFs.DWLog(_T(">>>> Creating Preferences dialog\n"));
	//(*Initialize(PreferencesDialog)
	wxBoxSizer* BoxSizer3;
	wxBoxSizer* BoxSizer10;
	wxBoxSizer* BoxSizer7;
	wxBoxSizer* BoxSizer11;
	wxBoxSizer* BoxSizer13;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer9;
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer12;
	wxBoxSizer* BoxSizer6;
	wxBoxSizer* BoxSizer5;

	Create(parent, id, _("Preferences"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	Notebook1 = new wxNotebook(Panel1, ID_NOTEBOOK1, wxDefaultPosition, wxDefaultSize, 0, _T("ID_NOTEBOOK1"));
	Panel2 = new wxPanel(Notebook1, ID_PANEL2, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL2"));
	BoxSizer3 = new wxBoxSizer(wxVERTICAL);
	StaticText1 = new wxStaticText(Panel2, ID_STATICTEXT1, _("Select default properties for new projects and items."), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	BoxSizer3->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(Panel2, ID_STATICTEXT2, _("Labels"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	wxFont StaticText2Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText2->SetFont(StaticText2Font);
	BoxSizer3->Add(StaticText2, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
	StaticText3 = new wxStaticText(Panel2, ID_STATICTEXT3, _("Default class:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	BoxSizer4->Add(StaticText3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice1 = new wxChoice(Panel2, ID_CHOICE1, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Choice1->SetSelection( Choice1->Append(_("None")) );
	Choice1->Append(_("1"));
	Choice1->Append(_("2"));
	Choice1->Append(_("3"));
	Choice1->Append(_("4"));
	Choice1->Append(_("5"));
	BoxSizer4->Add(Choice1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(BoxSizer4, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(Panel2, ID_STATICTEXT5, _("Lists"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	wxFont StaticText5Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText5->SetFont(StaticText5Font);
	BoxSizer3->Add(StaticText5, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer5 = new wxBoxSizer(wxVERTICAL);
	CheckBox1 = new wxCheckBox(Panel2, ID_CHECKBOX1, _("Include folders"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	CheckBox1->SetValue(false);
	BoxSizer5->Add(CheckBox1, 1, wxALL|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	CheckBox2 = new wxCheckBox(Panel2, ID_CHECKBOX2, _("List hidden files and folders"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX2"));
	CheckBox2->SetValue(false);
	BoxSizer5->Add(CheckBox2, 1, wxALL|wxEXPAND|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(BoxSizer5, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(-1,-1,0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(Panel2, ID_STATICTEXT4, _("Global"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	wxFont StaticText4Font(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText4->SetFont(StaticText4Font);
	BoxSizer3->Add(StaticText4, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel2, ID_BUTTON1, _("Font"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer6->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel2, ID_BUTTON2, _("Colour"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer6->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(BoxSizer6, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel2->SetSizer(BoxSizer3);
	BoxSizer3->Fit(Panel2);
	BoxSizer3->SetSizeHints(Panel2);
	Panel5 = new wxPanel(Notebook1, ID_PANEL5, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL5"));
	BoxSizer10 = new wxBoxSizer(wxVERTICAL);
	BoxSizer11 = new wxBoxSizer(wxHORIZONTAL);
	StaticText11 = new wxStaticText(Panel5, ID_STATICTEXT11, _("Import"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT11"));
	BoxSizer11->Add(StaticText11, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TextCtrl1 = new wxTextCtrl(Panel5, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	BoxSizer11->Add(TextCtrl1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(Panel5, ID_BUTTON5, _("Browse"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	BoxSizer11->Add(Button5, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer10->Add(BoxSizer11, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer12 = new wxBoxSizer(wxHORIZONTAL);
	StaticText12 = new wxStaticText(Panel5, ID_STATICTEXT12, _("Export"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT12"));
	BoxSizer12->Add(StaticText12, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TextCtrl2 = new wxTextCtrl(Panel5, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	BoxSizer12->Add(TextCtrl2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button6 = new wxButton(Panel5, ID_BUTTON6, _("Browse"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
	BoxSizer12->Add(Button6, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer10->Add(BoxSizer12, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer13 = new wxBoxSizer(wxHORIZONTAL);
	StaticText13 = new wxStaticText(Panel5, ID_STATICTEXT13, _("Project"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT13"));
	BoxSizer13->Add(StaticText13, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TextCtrl3 = new wxTextCtrl(Panel5, ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	BoxSizer13->Add(TextCtrl3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button7 = new wxButton(Panel5, ID_BUTTON7, _("Browse"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON7"));
	BoxSizer13->Add(Button7, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer10->Add(BoxSizer13, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel5->SetSizer(BoxSizer10);
	BoxSizer10->Fit(Panel5);
	BoxSizer10->SetSizeHints(Panel5);
	Panel4 = new wxPanel(Notebook1, ID_PANEL4, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL4"));
	BoxSizer9 = new wxBoxSizer(wxVERTICAL);
	StaticText10 = new wxStaticText(Panel4, ID_STATICTEXT10, _("You have to restart the application to\napply the selected language."), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE, _T("ID_STATICTEXT10"));
	BoxSizer9->Add(StaticText10, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice2 = new wxChoice(Panel4, ID_CHOICE2, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE2"));
	Choice2->Append(_("Dansk"));
	Choice2->Append(_("Deutsch"));
	Choice2->SetSelection( Choice2->Append(_("English")) );
	Choice2->Append(_("Magyar"));
	Choice2->Append(_("Svensk"));
	Choice2->Append(_("Español"));
	Choice2->Append(_("Polski"));
	BoxSizer9->Add(Choice2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel4->SetSizer(BoxSizer9);
	BoxSizer9->Fit(Panel4);
	BoxSizer9->SetSizeHints(Panel4);
	Notebook1->AddPage(Panel2, _("Defaults"), false);
	Notebook1->AddPage(Panel5, _("Paths"), false);
	Notebook1->AddPage(Panel4, _("Language"), false);
	BoxSizer2->Add(Notebook1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer7 = new wxBoxSizer(wxHORIZONTAL);
	Button3 = new wxButton(Panel1, ID_BUTTON3, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	BoxSizer7->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button4 = new wxButton(Panel1, ID_BUTTON4, _("OK"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	BoxSizer7->Add(Button4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer7, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);
	Center();

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnFont);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnColour);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnBrowse1Click);
	Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnBrowse2Click);
	Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnBrowse3Click);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnClose);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PreferencesDialog::OnOK);
	//*)

    wxString path, temp, stemp;;
    int j, g;
    char *c;
    wxFile file;

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("defaults0");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        file.Read(&PClass, sizeof(int));

        file.Read(&j, sizeof(int));
        PFont.SetPointSize(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                PFont.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                PFont.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                PFont.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                PFont.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                PFont.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                PFont.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                PFont.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
        }
        file.Read(&j, sizeof(int));
        PFont.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                PFont.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                PFont.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                PFont.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new char[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(char));
        temp = wxString::From8BitData(c);
        for ( g = 0 ; g < temp.Len()-(temp.Len()-j) ; g++ )
            stemp += temp[g];
        delete[] c;
        PFont.SetFaceName(stemp);

        bool ean;
        file.Read(&ean, sizeof(bool));
        CheckBox1->SetValue(ean);
        file.Read(&ean, sizeof(bool));
        CheckBox2->SetValue(ean);

        unsigned char R, G, B, A;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        PColour.Set(R, G, B, A);

        file.Close();
    }
    else
    {
        PClass = 0;
        PFont = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        PColour.Set(0, 0, 0, wxALPHA_OPAQUE);
        CheckBox1->SetValue(true);
        CheckBox2->SetValue(true);
    }

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("language");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        file.Read(&j, sizeof(int));
        switch(j){
            case wxLANGUAGE_DANISH:
                Choice2->SetSelection(0);
                break;
            case wxLANGUAGE_GERMAN:
                Choice2->SetSelection(1);
                break;
            case wxLANGUAGE_ENGLISH:
                Choice2->SetSelection(2);
                break;
            case wxLANGUAGE_HUNGARIAN:
                Choice2->SetSelection(3);
                break;
            case wxLANGUAGE_SWEDISH:
                Choice2->SetSelection(4);
                break;
            case wxLANGUAGE_SPANISH:
                Choice2->SetSelection(5);
                break;
            case wxLANGUAGE_POLISH:
                Choice2->SetSelection(6);
                break;
        }

        file.Close();
    }

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("paths");
    if ( wxFile::Exists(path) == true )
    {
        wxChar *x;
        file.Open(path, wxFile::read);

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        TextCtrl1->SetValue(wxString(x, j));
        delete[] x;

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        TextCtrl2->SetValue(wxString(x, j));
        delete[] x;

        file.Read(&j, sizeof(int));
        x = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&x[g], sizeof(wxChar));
        TextCtrl3->SetValue(wxString(x, j));
        delete[] x;

        file.Close();
    }

    Choice1->SetSelection(PClass);

}

PreferencesDialog::~PreferencesDialog()
{
	//(*Destroy(PreferencesDialog)
	//*)
}


void PreferencesDialog::OnClose(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void PreferencesDialog::OnFont(wxCommandEvent& event)
{
    wxFontData Font2, Font = wxFontData();
    Font.SetChosenFont(PFont);
    Font.SetInitialFont(Font.GetChosenFont());

    wxFontDialog dialog(this, Font);

    if (dialog.ShowModal() == wxID_OK) {
        Font2 = dialog.GetFontData();
        PFont = Font2.GetChosenFont();
    }
}

void PreferencesDialog::OnColour(wxCommandEvent& event)
{
    wxColourData Col;
    Col.SetColour(PColour);

    wxColourDialog dialog(this, &Col);

    if (dialog.ShowModal() == wxID_OK) {
        PColour = dialog.GetColourData().GetColour();
    }
}

void PreferencesDialog::OnOK(wxCommandEvent& event)
{
    CFs.DWLog(_T(">>>> Saving values..."));

    wxFile file;
    wxString path;
    int i;
    bool ean;
    unsigned char unchar;
    std::string command;

#if defined(__UNIX__)
    if ( wxDir::Exists(CFs.std2wx(CFs.oFolder_userM)+_T("/.discwrapper")) == false )
        wxMkdir(CFs.std2wx(CFs.oFolder_userM)+_T("/.discwrapper"));
#endif

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("defaults0");

    file.Create(path, true, wxS_DEFAULT);
    i = Choice1->GetCurrentSelection();
    file.Write(&i, sizeof(int));
    i = PFont.GetPointSize();
    file.Write(&i, sizeof(int));
    i = PFont.GetFamily();
    file.Write(&i, sizeof(int));
    i = PFont.GetStyle();
    file.Write(&i, sizeof(int));
    i = PFont.GetWeight();
    file.Write(&i, sizeof(int));
    i = PFont.GetFaceName().Len();
    file.Write(&i, sizeof(int));
    for ( i = 0 ; i < PFont.GetFaceName().Len() ; i++ )
        file.Write(&(PFont.GetFaceName())[i], sizeof(char));

    ean = CheckBox1->IsChecked();
    file.Write(&ean, sizeof(bool));
    ean = CheckBox2->IsChecked();
    file.Write(&ean, sizeof(bool));

    unchar = PColour.Red();
    file.Write(&unchar, sizeof(unsigned char));
    unchar = PColour.Green();
    file.Write(&unchar, sizeof(unsigned char));
    unchar = PColour.Blue();
    file.Write(&unchar, sizeof(unsigned char));
    unchar = PColour.Alpha();
    file.Write(&unchar, sizeof(unsigned char));
    file.Close();


    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("language");
    file.Create(path, true, wxS_DEFAULT);
    switch(Choice2->GetCurrentSelection()){
        case 0:
            i = wxLANGUAGE_DANISH;
            file.Write(&i, sizeof(int));
            break;
        case 1:
            i = wxLANGUAGE_GERMAN;
            file.Write(&i, sizeof(int));
            break;
        case 2:
            i = wxLANGUAGE_ENGLISH;
            file.Write(&i, sizeof(int));
            break;
        case 3:
            i = wxLANGUAGE_HUNGARIAN;
            file.Write(&i, sizeof(int));
            break;
        case 4:
            i = wxLANGUAGE_SWEDISH;
            file.Write(&i, sizeof(int));
            break;
        case 5:
            i = wxLANGUAGE_SPANISH;
            file.Write(&i, sizeof(int));
            break;
        case 6:
            i = wxLANGUAGE_POLISH;
            file.Write(&i, sizeof(int));
            break;
    }
    file.Close();


    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("paths");

    wxChar *x;
    file.Create(path, true, wxS_DEFAULT);

    i = TextCtrl1->GetValue().Len();
    file.Write(&i, sizeof(int));
    for ( i = 0 ; i < TextCtrl1->GetValue().Len() ; i++ )
    {
        wxChar ch = TextCtrl1->GetValue().GetChar(i);
        file.Write(&ch, sizeof(wxChar));
    }

    i = TextCtrl2->GetValue().Len();
    file.Write(&i, sizeof(int));
    for ( i = 0 ; i < TextCtrl2->GetValue().Len() ; i++ )
    {
        wxChar ch = TextCtrl2->GetValue().GetChar(i);
        file.Write(&ch, sizeof(wxChar));
    }

    i = TextCtrl3->GetValue().Len();
    file.Write(&i, sizeof(int));
    for ( i = 0 ; i < TextCtrl3->GetValue().Len() ; i++ )
    {
        wxChar ch = TextCtrl3->GetValue().GetChar(i);
        file.Write(&ch, sizeof(wxChar));
    }
    file.Close();


    CFs.DWLog(_T("Ok\n"));

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void PreferencesDialog::OnBrowse1Click(wxCommandEvent& event)
{
    wxDirDialog dialog(this, _("Choose a directory"), TextCtrl1->GetValue(), wxDD_DIR_MUST_EXIST, wxDefaultPosition, wxDefaultSize, _T("wxDirCtrl"));
    if ( dialog.ShowModal() == wxID_OK )
    {
        TextCtrl1->SetValue(dialog.GetPath());
    }
}

void PreferencesDialog::OnBrowse2Click(wxCommandEvent& event)
{
    wxDirDialog dialog(this, _("Choose a directory"), TextCtrl2->GetValue(), wxDD_DIR_MUST_EXIST, wxDefaultPosition, wxDefaultSize, _T("wxDirCtrl"));
    if ( dialog.ShowModal() == wxID_OK )
    {
        TextCtrl2->SetValue(dialog.GetPath());
    }
}

void PreferencesDialog::OnBrowse3Click(wxCommandEvent& event)
{
    wxDirDialog dialog(this, _("Choose a directory"), TextCtrl3->GetValue(), wxDD_DIR_MUST_EXIST, wxDefaultPosition, wxDefaultSize, _T("wxDirCtrl"));
    if ( dialog.ShowModal() == wxID_OK )
    {
        TextCtrl3->SetValue(dialog.GetPath());
    }
}
