/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY || FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperMain.h"
#include "NewDialog.h"

#include <wx/font.h>
#include <wx/file.h>
#include <wx/textfile.h>
#include <wx/filedlg.h>

void DiscWrapperFrame::OnTool_New_Clicked(wxCommandEvent& event)    // New project
{
    if ( (STATUS == _("Unsaved")) || (STATUS == _("Modified")) )
        if ( ConfirmClose() == false )
            return;
    if ( SPATH != wxEmptyString )
        UpdateRecents();

    NewDialog dialog(this, wxID_ANY);    //Create NewDialog
    if ( dialog.ShowModal() == wxID_OK )  //Open template
    {
        CFs.DWLog(_T("> Loading selected template\n"));

        wxString p = dialog.GetPath();
        int i = dialog.GetCase();

        OpenTemplate(p, i);

        STATUS = _("Unsaved");
        ToolBar1->EnableTool(ID_SAVE, false);
        MenuItem5->Enable(false);
        USB();    //Update Status Bar
    }
    else
        return; // return if NewDialog was canceled

}

void DiscWrapperFrame::On_Close_Selected(wxCommandEvent& event)     // Close current project
{
    if ( (STATUS == _("Unsaved")) || (STATUS == _("Modified")) )
        if ( ConfirmClose() == false )
            return;

    if ( SPATH != wxEmptyString )
        UpdateRecents();

    UnloadProject();
}

void DiscWrapperFrame::UnloadProject()     // Close current project
{
    CFs.DWLog(_T("> Unloading project\n\n"));

    if ( Notebook1->GetSelection() != Database->PDP )
    {
        switch(Notebook1->GetSelection()){
            case 0:
                TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
                delete TextCtrl;

                PanelF->Disconnect(ID_PANELF,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
                PanelF->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
                PanelF->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
                PanelF->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
                PanelF->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
                PanelF->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
                PanelF->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
                PanelF->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
                break;
            case 1:
                TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
                delete TextCtrl;

                PanelI->Disconnect(ID_PANELI,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
                PanelI->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
                PanelI->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
                PanelI->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
                PanelI->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
                PanelI->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
                PanelI->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
                PanelI->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
                break;
            case 2:
                TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
                delete TextCtrl;

                PanelB->Disconnect(ID_PANELB,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
                PanelB->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
                PanelB->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
                PanelB->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
                PanelB->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
                PanelB->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
                PanelB->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
                PanelB->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
                break;
        }
    }
    else
    {
        TextCtrl->Disconnect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
        delete TextCtrl;

        PanelD->Disconnect(ID_PANELD,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
        PanelD->Disconnect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
        PanelD->Disconnect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
        PanelD->Disconnect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
        PanelD->Disconnect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
        PanelD->Disconnect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
        PanelD->Disconnect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
        PanelD->Disconnect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);
    }

    Disconnect(ID_NOTEBOOK1,wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED,(wxObjectEventFunction)&DiscWrapperFrame::OnNotebook1PageChanged);

    Clear_Tool_history();

    delete Database;

    Pview = wxNullBitmap;

    IsDatabasePresent = false;

    DontLog = true;

    if (Notebook1->DeleteAllPages() == false)
        wxMessageBox(_("Error"), _("Error"));

    DontLog = false;

    DeleteTool();

    ToolBar1->EnableTool(ID_SAVE, false);
    ToolBar1->EnableTool(ID_PRINT, false);
    ToolBar1->EnableTool(ID_TOOL_ZIN, false);
    ToolBar1->EnableTool(ID_TOOL_ZOUT, false);
    ToolBar1->EnableTool(ID_TOOL_FIT, false);
    MenuItem5->Enable(false);
    MenuItem13->Enable(false);
    MenuItem14->Enable(false);
    MenuItem15->Enable(false);
    MenuItem16->Enable(false);
    MenuItem8->Enable(false);
    MenuItem6->Enable(false);
    MenuItem9->Enable(false);
    MenuItem17->Enable(false);
    MenuItem10->Enable(false);
    MenuItem18->Enable(false);
    STATUS = _("Idle");
    USB();    //Update Status Bar

}

void DiscWrapperFrame::On_SAVE_AS(wxCommandEvent& event)        // Save project as
{
    wxString path, name, temp;
    int i;

    wxFileDialog FileDialog1(this, _("Choose a file"), ProjectPath, _(""), _("DiscWrapper project files (*.dwp)|*.dwp"), wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize);

    if (FileDialog1.ShowModal() == wxID_OK)
    {
        LastDir = path = FileDialog1.GetDirectory();
        name = FileDialog1.GetFilename();
    }
    else
        return;
    i = name.Len();
    if ( (name[i-4] != '.') || (name[i-3] != 'd') || (name[i-2] != 'w') || (name[i-1] != 'p') )
        path = path + _T("/") + name + _T(".dwp");
    else
        path = path + _T("/") + name;

    Saving(path);

    ToolBar1->EnableTool(ID_SAVE, false);
    MenuItem5->Enable(false);
    STATUS = _("Saved");
    USB();    //Update Status Bar
}

void DiscWrapperFrame::On_SAVE(wxCommandEvent& event)           // Save project
{
    wxString path, name, temp;
    int i;

    if ( STATUS == _("Unsaved") )
    {
        wxFileDialog FileDialog1(this, _("Choose a file"), ProjectPath, _(""), _("DiscWrapper project files (*.dwp)|*.dwp"), wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize);

        if (FileDialog1.ShowModal() == wxID_OK)
        {
            LastDir = path = FileDialog1.GetDirectory();
            name = FileDialog1.GetFilename();
        }
        else
            return;
        i = name.Len();
        if ( (name[i-4] != '.') || (name[i-3] != 'd') || (name[i-2] != 'w') || (name[i-1] != 'p') )
            path = path + _T("/") + name + _T(".dwp");
        else
            path = path + _T("/") + name;
    }
    else if ( STATUS == _("Modified") )
    {
        path = SPATH;
    }
    else if ( STATUS == _("Saved") )
    {
        return;
    }

    Saving(path);

    STATUS = _("Saved");
    ToolBar1->EnableTool(ID_SAVE, false);
    MenuItem5->Enable(false);
    USB();    //Update Status Bar
}

void DiscWrapperFrame::On_OPEN(wxCommandEvent& event)   // Open project
{
    wxString path;

    if ( (STATUS == _("Unsaved")) || (STATUS == _("Modified")) )
    {
        if ( (STATUS == _("Unsaved")) || (STATUS == _("Modified")) )
            if ( ConfirmClose() == false )
                return;

        wxFileDialog FileDialog1(this, _("Choose a file"), ProjectPath, _(""), _("DiscWrapper project files (*.dwp)|*.dwp"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);

        if (FileDialog1.ShowModal() == wxID_OK)
        {
            path = FileDialog1.GetPath();
            LastDir = FileDialog1.GetDirectory();
        }
        else
            return;

    }
    else
    {
        wxFileDialog FileDialog1(this, _("Choose a file"), ProjectPath, _(""), _("DiscWrapper project files (*.dwp)|*.dwp"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize);

        if (FileDialog1.ShowModal() == wxID_OK)
        {
            path = FileDialog1.GetPath();
            LastDir = FileDialog1.GetDirectory();
        }
        else
            return;
    }
    if ( SPATH != wxEmptyString )
        UpdateRecents();
    OpenProject(path);
}

void DiscWrapperFrame::Saving(wxString path)            // Save script
{
    CFs.DWLog(_T("> Saving project"));

    wxFile file;
    int i, j;

    CFs.DWLog(_T("."));

    file.Create(path, true, wxS_DEFAULT);
    wxString oyi = _T("MNándor...DW");
    for ( i = 0 ; i < oyi.Len() ; i++ )
    {
        wxChar ch = oyi.GetChar(i);
        file.Write(&ch, sizeof(wxChar));
    }
    i = 7;      // Project version
    file.Write(&i, sizeof(i));

    file.Write(&Database->PDP, sizeof(int));
    file.Write(&Database->PDC, sizeof(int));

    int page;
    for ( page = 0 ; page < 4 ; page++ )
    {
        i = Database->Page[page].PageBackPath.Len();
        file.Write(&i, sizeof(int));
        for ( i = 0 ; i < Database->Page[page].PageBackPath.Len() ; i++ )
        {
            wxChar ch = Database->Page[page].PageBackPath.GetChar(i);
            file.Write(&ch, sizeof(wxChar));
        }

        CFs.DWLog(_T("."));

        i = Database->Page[page].labels.GetCount();
        file.Write(&i, sizeof(int));
        for ( i = 0 ; i < Database->Page[page].labels.GetCount() ; i++ )
        {
            unsigned char unchar;
            char Bend;

            j = Database->Page[page].labels[i].L.Len();
            file.Write(&j, sizeof(int));
            for ( j = 0 ; j < Database->Page[page].labels[i].L.Len() ; j++ )
            {
                wxChar ch = Database->Page[page].labels[i].L.GetChar(j);
                file.Write(&ch, sizeof(wxChar));
            }
            file.Write(&Database->Page[page].labels[i].X, sizeof(int));
            file.Write(&Database->Page[page].labels[i].Y, sizeof(int));
            j = Database->Page[page].labels[i].Font.GetChosenFont().GetPointSize();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].labels[i].Font.GetChosenFont().GetFamily();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].labels[i].Font.GetChosenFont().GetStyle();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].labels[i].Font.GetChosenFont().GetWeight();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].labels[i].Font.GetChosenFont().GetFaceName().Len();
            file.Write(&j, sizeof(int));
            for ( j = 0 ; j < Database->Page[page].labels[i].Font.GetChosenFont().GetFaceName().Len() ; j++ )
            {
                wxChar ch = Database->Page[page].labels[i].Font.GetChosenFont().GetFaceName().GetChar(j);
                file.Write(&ch, sizeof(wxChar));
            }
            unchar = Database->Page[page].labels[i].Colour.GetColour().Red();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].labels[i].Colour.GetColour().Green();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].labels[i].Colour.GetColour().Blue();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].labels[i].Colour.GetColour().Alpha();
            file.Write(&unchar, sizeof(unsigned char));
            file.Write(&Database->Page[page].labels[i].Angle, sizeof(double));
            file.Write(&Database->Page[page].labels[i].Class, sizeof(int));
            file.Write(&Database->Page[page].labels[i].Align, sizeof(int));
            if ( Database->Page[page].labels[i].Bend == true )
            {
                Bend = 1;
                file.Write(&Bend, sizeof(char));
            }
            else
            {
                Bend = 0;
                file.Write(&Bend, sizeof(char));
            }
        }

        CFs.DWLog(_T("."));

        i = Database->Page[page].lists.GetCount();
        file.Write(&i, sizeof(int));
        for ( i = 0 ; i < Database->Page[page].lists.GetCount() ; i++ )
        {
            unsigned char unchar;
            wxString spectemp = wxEmptyString;

            for ( j = 0 ; j < Database->Page[page].lists[i].L.Count() ; j++ )
            {
                spectemp += Database->Page[page].lists[i].L.Item(j);
                if ( j + 1 != Database->Page[page].lists[i].L.Count() )
                    spectemp += _T("\n");
            }

            j = spectemp.Len();
            file.Write(&j, sizeof(int));
            for ( j = 0 ; j < spectemp.Len() ; j++ )
            {
                wxChar ch = spectemp.GetChar(j);
                file.Write(&ch, sizeof(wxChar));
            }
            file.Write(&Database->Page[page].lists[i].X, sizeof(int));
            file.Write(&Database->Page[page].lists[i].Y, sizeof(int));
            j = Database->Page[page].lists[i].Font.GetChosenFont().GetPointSize();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].lists[i].Font.GetChosenFont().GetFamily();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].lists[i].Font.GetChosenFont().GetStyle();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].lists[i].Font.GetChosenFont().GetWeight();
            file.Write(&j, sizeof(int));
            j = Database->Page[page].lists[i].Font.GetChosenFont().GetFaceName().Len();
            file.Write(&j, sizeof(int));
            for ( j = 0 ; j < Database->Page[page].lists[i].Font.GetChosenFont().GetFaceName().Len() ; j++ )
            {
                wxChar ch = Database->Page[page].lists[i].Font.GetChosenFont().GetFaceName().GetChar(j);
                file.Write(&ch, sizeof(wxChar));
            }
            unchar = Database->Page[page].lists[i].Colour.GetColour().Red();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].lists[i].Colour.GetColour().Green();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].lists[i].Colour.GetColour().Blue();
            file.Write(&unchar, sizeof(unsigned char));
            unchar = Database->Page[page].lists[i].Colour.GetColour().Alpha();
            file.Write(&unchar, sizeof(unsigned char));
        }

        CFs.DWLog(_T("."));

        i = Database->Page[page].images.GetCount();
        file.Write(&i, sizeof(int));
        for ( j = 0 ; j < Database->Page[page].images.GetCount() ; j++ )
        {
            file.Write(&Database->Page[page].images[j].X, sizeof(int));
            file.Write(&Database->Page[page].images[j].Y, sizeof(int));
            file.Write(&Database->Page[page].images[j].Scale, sizeof(int));
            file.Write(&Database->Page[page].images[j].Rotate, sizeof(int));
            file.Write(&Database->Page[page].ImageOrder[j], sizeof(int));
            i = Database->Page[page].images[j].Path.Len();
            file.Write(&i, sizeof(int));
            for ( i = 0 ; i < Database->Page[page].images[j].Path.Len() ; i++ )
            {
                wxChar ch = Database->Page[page].images[j].Path.GetChar(i);
                file.Write(&ch, sizeof(wxChar));
            }
        }

    }

    file.Close();

    file.Open(path, wxFile::read);
    file.Seek(0, wxFromStart);
    i = 0;

    CFs.DWLog(_T("."));

    while ( !file.Eof() )
    {
        unsigned char buf;
        file.Read(&buf, 1);
        i += buf;
    }
    file.Close();
    file.Open(path, wxFile::write_append);
    file.Write(&i, 4);

    CFs.DWLog(_T("."));

    SPATH = path;
    for ( i = 0 ; i < SPATH.Len() ; i++ )
        if ( SPATH[i] == '\\' )
            SPATH[i] = '/';

    file.Close();

    Clear_Tool_history();

    CFs.DWLog(_T("OK\n"));
}

void DiscWrapperFrame::OpenTemplate(wxString path, int Casetype)       // Pre-open script
{
    CFs.DWLog(_T("> Creating project"));

    if ( IsDatabasePresent )
        UnloadProject();


    wxString TemplateFilePath = path+_T("/");
    TemplateFilePath += path.AfterLast(*wxString(_T("/")).c_str());
    TemplateFilePath += _T(".dwt");

    wxTextFile file(TemplateFilePath);

    if ( file.Open() )
    {
        IsDatabasePresent = true;
        Database = new DiscWrapperDatabase();

        Database->PDC = Casetype;

        wxString line = file.GetFirstLine();
        while ( !file.Eof() )
        {
            line.Trim();
            if ( (line.Len() != 0) && (line[0] != '#') )
            {
                wxString temp;



                if ( (temp = CFs.MyAfterFirst(line, _T("LABEL="), -1, 0, 0)) != wxEmptyString )
                {
                    wxString label = wxEmptyString;
                    long lx = -1, ly = -1, page = -1, lsize = -1, align = -1, bend = -1, lclass = -1, langle = -1;
                    bool CaseMatch = false;
                    wxString temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                    temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                    if ( (temp2 == _T("CDST")) && (Casetype == 0) )
                        CaseMatch = true;
                    else if ( (temp2 == _T("CDSL")) && (Casetype == 1) )
                        CaseMatch = true;
                    else if ( (temp2 == _T("DVDST")) && (Casetype == 2) )
                        CaseMatch = true;
                    else if ( (temp2 == _T("DVDSL")) && (Casetype == 3) )
                        CaseMatch = true;

                    if ( CaseMatch )
                    {
                        temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                        temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                        if ( temp2 == _T("MAIN") )
                            page = 0;
                        else if ( temp2 == _T("INSIDE") )
                            page = 1;
                        else if ( temp2 == _T("BACK") )
                            page = 2;
                        else if ( temp2 == _T("DISC") )
                            page = 3;

                        if ( page == -1 )
                            wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                        else if ( GetBackWidth(page) == 0 )
                            wxMessageDialog(this, _("LABEL error... No such page in current case:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                        else
                        {
                            temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                            temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                            if ( temp2.ToLong(&lx) )
                            {
                                temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                                if ( temp2.ToLong(&ly) )
                                {
                                    temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                    temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                                    if ( temp2 == _T("LEFT") )
                                        align = 0;
                                    else if ( temp2 == _T("CENTRE") )
                                        align = 1;
                                    else if ( temp2 == _T("RIGHT") )
                                        align = 2;


                                    if ( align != -1 )
                                    {
                                        temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                        temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);


                                        if ( temp2.ToLong(&lsize) )
                                        {
                                            temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                            temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                                            if ( temp2 == _T("TRUE") )
                                                bend = 0;
                                            else if ( temp2 == _T("FALSE") )
                                                bend = 1;


                                            if ( bend != -1 )
                                            {
                                                temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                                temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                                                if ( !temp2.ToLong(&lclass) )
                                                    wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                                                else if ( (lclass > 5) || (lclass < 0) )
                                                    wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                                                else
                                                {
                                                    temp2 = CFs.MyBeforeFirst(temp, _T(";"), -1, 0, 0);
                                                    temp = CFs.MyAfterFirst(temp, _T(";"), -1, 0, 0);

                                                    if ( !temp2.ToLong(&langle) )
                                                        wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                                                    else if ( (langle > 360) || (lclass < 0) )
                                                        wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                                                    else
                                                    {
                                                        if ( temp == _T("TITLE") )
                                                            label = _("<Title>");
                                                        else if ( temp == _T("DATE") )
                                                            label = _("<Date>");
                                                        else
                                                            label = temp;
                                                        CaseMatch = false;
                                                    }
                                                }

                                            }
                                            else
                                                wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                                        }
                                        else
                                            wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                                    }
                                    else
                                        wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                                }
                                else
                                    wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                            }
                            else
                                wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                        }

                        if ( !CaseMatch )
                        {
                            LabelStructure NewItem;

                            NewItem.L = label;

                            if ( lx < 0 )
                                NewItem.X = 0;
                            else if ( lx > GetBackWidth(page) )
                                NewItem.X = GetBackWidth(page);
                            else
                                NewItem.X = lx;

                            if ( ly < 0 )
                                NewItem.Y = 0;
                            else if ( ly > GetBackHeight(page) )
                                NewItem.Y = GetBackHeight(page);
                            else
                                NewItem.Y = ly;

                            wxFont TempFont = Dfont;
                            TempFont.SetPointSize(lsize);
                            NewItem.Font = wxFontData();
                            NewItem.Font.SetChosenFont(TempFont);
                            NewItem.Font.SetInitialFont(NewItem.Font.GetChosenFont());
                            NewItem.Colour.SetColour(DColour);
                            NewItem.Angle = langle;
                            NewItem.Class = lclass;
                            NewItem.Align = align;

                            if ( (page == 3) && (bend == 0) )
                                NewItem.Bend = true;
                            else
                                NewItem.Bend = false;

                            Database->Page[page].labels.Add(NewItem);
                        }
                    }
                    else if ( (temp2 != _T("CDST")) && (temp2 != _T("CDSL")) && (temp2 != _T("DVDST")) && (temp2 != _T("DVDSL")) )
                        wxMessageDialog(this, _("Invalid value for LABEL:\n\"")+temp2+_T("\""), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                }

            }

            line = file.GetNextLine();
        }
        file.Close();



    }
    else
    {
        wxMessageDialog(this, _("Could not open:\n")+path, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        return;
    }

    switch(Casetype){
        case 0:
            Database->PDP = 3;
            break;
        case 1:
            Database->PDP = 2;
            break;
        case 2:
        case 3:
            Database->PDP = 1;
            break;
    }

    switch(Casetype){
        case 0:
            if ( wxFile::Exists(path+_T("/cdmain.jpg")) )
                Database->Page[0].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/cdmain.jpg");
            else
                Database->Page[0].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/cdinside.jpg")) )
                Database->Page[1].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/cdinside.jpg");
            else
                Database->Page[1].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/cdback.jpg")) )
                Database->Page[2].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/cdback.jpg");
            else
                Database->Page[2].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/disc.jpg")) )
                Database->Page[3].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/disc.jpg");
            else
                Database->Page[3].PageBackPath = wxEmptyString;
            break;
        case 1:
            if ( wxFile::Exists(path+_T("/cdmain.jpg")) )
                Database->Page[0].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/cdmain.jpg");
            else
                Database->Page[0].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/cdinside.jpg")) )
                Database->Page[1].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/cdinside.jpg");
            else
                Database->Page[1].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/disc.jpg")) )
                Database->Page[3].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/disc.jpg");
            else
                Database->Page[3].PageBackPath = wxEmptyString;
            break;
        case 2:
            if ( wxFile::Exists(path+_T("/dvdst.jpg")) )
                Database->Page[0].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/dvdst.jpg");
            else
                Database->Page[0].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/disc.jpg")) )
                Database->Page[3].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/disc.jpg");
            else
                Database->Page[3].PageBackPath = wxEmptyString;
            break;
        case 3:
            if ( wxFile::Exists(path+_T("/dvdsl.jpg")) )
                Database->Page[0].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/dvdsl.jpg");
            else
                Database->Page[0].PageBackPath = wxEmptyString;

            if ( wxFile::Exists(path+_T("/disc.jpg")) )
                Database->Page[3].PageBackPath = path.AfterLast(*wxString(_T("/")).c_str())+_T("/disc.jpg");
            else
                Database->Page[3].PageBackPath = wxEmptyString;
            break;
    }

    CFs.DWLog(_T("."));

    ToolBar1->EnableTool(ID_SAVE, true);
    ToolBar1->EnableTool(ID_PRINT, true);
    ToolBar1->EnableTool(ID_TOOL_ZIN, true);
    ToolBar1->EnableTool(ID_TOOL_ZOUT, true);
    ToolBar1->EnableTool(ID_TOOL_FIT, true);
    MenuItem5->Enable(true);
    MenuItem13->Enable(true);
    MenuItem14->Enable(true);
    MenuItem15->Enable(true);
    MenuItem16->Enable(true);
    MenuItem8->Enable(true);

    MenuItem6->Enable(true);
    MenuItem9->Enable(true);
    MenuItem17->Enable(true);
    MenuItem10->Enable(true);
    MenuItem18->Enable(true);

    int i;
    for ( i = 0 ; i < 4 ; i++ )
    {
        if ( Database->Page[i].PageBackPath != wxEmptyString )
        {
            if ( wxFile::Exists(CFs.DataPath()+_T("templates/")+Database->Page[i].PageBackPath) )
                Database->Page[i].PageBack.LoadFile(CFs.DataPath()+_T("templates/")+Database->Page[i].PageBackPath, wxBITMAP_TYPE_ANY);
            else if ( wxFile::Exists(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("templates/")+Database->Page[i].PageBackPath) )
                Database->Page[i].PageBack.LoadFile(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("templates/")+Database->Page[i].PageBackPath, wxBITMAP_TYPE_ANY);
            else
                wxMessageDialog(this, _("Could not find:\n")+Database->Page[i].PageBackPath, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        }
    }

    UpdPview = true;

    CFs.DWLog(_T("."));

    Connect(ID_NOTEBOOK1,wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED,(wxObjectEventFunction)&DiscWrapperFrame::OnNotebook1PageChanged);

    DontLog = true;

    PanelF = new wxPanel(Notebook1, ID_PANELF, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELF"));
    PanelF->SetBackgroundColour(wxColour(255,255,255));
    Notebook1->AddPage(PanelF, _("Front"), true);
    TextCtrl = new wxTextCtrl(PanelF, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
    TextCtrl->Hide();
    TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
    PanelF->Connect(ID_PANELF,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
    PanelF->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
    PanelF->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
    PanelF->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
    PanelF->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
    PanelF->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
    PanelF->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
    PanelF->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);

    if ( (Database->PDC == 0) || (Database->PDC == 1) )
    {
        PanelI = new wxPanel(Notebook1, ID_PANELI, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELI"));
        PanelI->SetBackgroundColour(wxColour(255,255,255));
        Notebook1->AddPage(PanelI, _("Inside"), false);
    }
    if ( Database->PDC == 0 )
    {
        PanelB = new wxPanel(Notebook1, ID_PANELB, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELB"));
        PanelB->SetBackgroundColour(wxColour(255,255,255));
        Notebook1->AddPage(PanelB, _("Back"), false);
    }

    PanelD = new wxPanel(Notebook1, ID_PANELD, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELD"));
    PanelD->SetBackgroundColour(wxColour(255,255,255));
    Notebook1->AddPage(PanelD, _("Disc"), false);

    DontLog = false;

    CFs.DWLog(_T("."));

    SetTextTool();
    ShowTool(1);

    CFs.DWLog(_T("."));

    SPATH = path;
    for ( i = 0 ; i < SPATH.Len() ; i++ )
        if ( SPATH[i] == '\\' )
            SPATH[i] = '/';

    DrawDC();
    STATUS = _("Saved");
    ToolBar1->EnableTool(ID_SAVE, false);
    MenuItem5->Enable(false);
    USB();    //Update Status Bar

    CFs.DWLog(_T("OK\n"));

}

void DiscWrapperFrame::OpenProject(wxString path)       // Pre-open script
{
    CFs.DWLog(_T("> Analizing file"));

    if ( IsDatabasePresent )
        UnloadProject();

    wxFile file;
    wxString temp;
    int i, j, g;
    wxChar* c;

    CFs.DWLog(_T("."));

    file.Open(path, wxFile::read);

    temp = wxEmptyString;

    c = new wxChar[12];
    for ( g = 0 ; g < 12 ; g++ )
        file.Read(&c[g], sizeof(wxChar));
        temp = wxString(c, 12);
    delete[] c;

    if ( temp != _T("MNándor...DW") )
    {
        wxMessageDialog(this, _("This isn't a DiscWrapper project file, || it is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        file.Close();
        return;
    }

    CFs.DWLog(_T("."));

    file.Seek(0, wxFromStart);
    i = 0;
    while ( !file.Eof() )
    {
        unsigned char buf;
        file.Read(&buf, 1);
        i += buf;
    }
    file.Seek(-4, wxFromEnd);
    while ( !file.Eof() )
    {
        unsigned char buf;
        file.Read(&buf, 1);
        i -= buf;
    }
    file.Seek(-4, wxFromEnd);
    file.Read(&j, 4);
    if ( i != j )
    {
        wxMessageDialog(this, _("This isn't a DiscWrapper project file, || it is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        file.Close();
        return;
    }

    CFs.DWLog(_T("."));

    file.Seek(48, wxFromStart);

    file.Read(&i, sizeof(int));

    file.Close();

    if ( i < 5 )// FIXME (nandor#1#): prj
    {
        CFs.DWLog(_T(" obsolote file - Opening terminated\n"));
        wxMessageDialog(this, _("This project was saved by an older version of DiscWrapper. This version can not open it."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        return;
    }
    else if ( i > 7 )
    {
        CFs.DWLog(_T(" too new file - Opening terminated\n"));
        wxMessageDialog(this, _("This project was saved by a newer version of DiscWrapper. This version can not open it."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        return;
    }
    else if ( i == 5 )
    {
        CFs.DWLog(_T(" file version: 5\n> Opening project"));
        Database = new DiscWrapperDatabase();
        IsDatabasePresent = true;
        OpenProjectV5(path);
        UpdatePrj5To6();
        UpdatePrj6To7();
    }
    else if ( i == 6 )
    {
        CFs.DWLog(_T(" file version: 6\n> Opening project"));
        Database = new DiscWrapperDatabase();
        IsDatabasePresent = true;
        OpenProjectV6(path);
        UpdatePrj6To7();
    }
    else if ( i == 7 )
    {
        CFs.DWLog(_T(" file version: 7\n> Opening project"));
        Database = new DiscWrapperDatabase();
        IsDatabasePresent = true;
        OpenProjectV6(path);
    }

    CFs.DWLog(_T("."));

    ToolBar1->EnableTool(ID_SAVE, true);
    ToolBar1->EnableTool(ID_PRINT, true);
    ToolBar1->EnableTool(ID_TOOL_ZIN, true);
    ToolBar1->EnableTool(ID_TOOL_ZOUT, true);
    ToolBar1->EnableTool(ID_TOOL_FIT, true);
    MenuItem5->Enable(true);
    MenuItem13->Enable(true);
    MenuItem14->Enable(true);
    MenuItem15->Enable(true);
    MenuItem16->Enable(true);
    MenuItem8->Enable(true);

    MenuItem6->Enable(true);
    MenuItem9->Enable(true);
    MenuItem17->Enable(true);
    MenuItem10->Enable(true);
    MenuItem18->Enable(true);

    for ( i = 0 ; i < 4 ; i++ )
    {
        if ( Database->Page[i].PageBackPath != wxEmptyString )
        {
            if ( wxFile::Exists(CFs.DataPath()+_T("templates/")+Database->Page[i].PageBackPath) )
                Database->Page[i].PageBack.LoadFile(CFs.DataPath()+_T("templates/")+Database->Page[i].PageBackPath, wxBITMAP_TYPE_ANY);
            else if ( wxFile::Exists(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("templates/")+Database->Page[i].PageBackPath) )
                Database->Page[i].PageBack.LoadFile(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("templates/")+Database->Page[i].PageBackPath, wxBITMAP_TYPE_ANY);
            else
                wxMessageDialog(this, _("Could not find:\n")+Database->Page[i].PageBackPath, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        }
    }

    UpdPview = true;

    CFs.DWLog(_T("."));

    Connect(ID_NOTEBOOK1,wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED,(wxObjectEventFunction)&DiscWrapperFrame::OnNotebook1PageChanged);

    DontLog = true;

    PanelF = new wxPanel(Notebook1, ID_PANELF, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELF"));
    PanelF->SetBackgroundColour(wxColour(255,255,255));
    Notebook1->AddPage(PanelF, _("Front"), true);
    TextCtrl = new wxTextCtrl(PanelF, ID_TEXTCTRL, wxEmptyString, wxDefaultPosition, wxSize(200,120), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL"));
    TextCtrl->Hide();
    TextCtrl->Connect(ID_TEXTCTRL, wxEVT_KILL_FOCUS, wxFocusEventHandler(DiscWrapperFrame::OnTextCtrlKillFocus), NULL, this);
    PanelF->Connect(ID_PANELF,wxEVT_PAINT,(wxObjectEventFunction)&DiscWrapperFrame::OnPaint,0,this);
    PanelF->Connect(wxEVT_LEFT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDown,0,this);
    PanelF->Connect(wxEVT_RIGHT_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnRightDown,0,this);
    PanelF->Connect(wxEVT_MIDDLE_DOWN,(wxObjectEventFunction)&DiscWrapperFrame::OnMiddleDown,0,this);
    PanelF->Connect(wxEVT_MOTION,(wxObjectEventFunction)&DiscWrapperFrame::OnDragging,0,this);
    PanelF->Connect(wxEVT_MOUSEWHEEL,(wxObjectEventFunction)&DiscWrapperFrame::On_MouseWheel,0,this);
    PanelF->Connect(wxEVT_LEFT_UP,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftUp,0,this);
    PanelF->Connect(wxEVT_LEFT_DCLICK,(wxObjectEventFunction)&DiscWrapperFrame::OnLeftDouble,0,this);

    if ( (Database->PDC == 0) || (Database->PDC == 1) )
    {
        PanelI = new wxPanel(Notebook1, ID_PANELI, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELI"));
        PanelI->SetBackgroundColour(wxColour(255,255,255));
        Notebook1->AddPage(PanelI, _("Inside"), false);
    }
    if ( Database->PDC == 0 )
    {
        PanelB = new wxPanel(Notebook1, ID_PANELB, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELB"));
        PanelB->SetBackgroundColour(wxColour(255,255,255));
        Notebook1->AddPage(PanelB, _("Back"), false);
    }

    PanelD = new wxPanel(Notebook1, ID_PANELD, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL|wxFULL_REPAINT_ON_RESIZE, _T("ID_PANELD"));
    PanelD->SetBackgroundColour(wxColour(255,255,255));
    Notebook1->AddPage(PanelD, _("Disc"), false);

    DontLog = false;

    CFs.DWLog(_T("."));

    SetTextTool();
    ShowTool(1);

    CFs.DWLog(_T("."));

    SPATH = path;
    for ( i = 0 ; i < SPATH.Len() ; i++ )
        if ( SPATH[i] == '\\' )
            SPATH[i] = '/';

    DrawDC();
    STATUS = _("Saved");
    ToolBar1->EnableTool(ID_SAVE, false);
    MenuItem5->Enable(false);
    USB();    //Update Status Bar

    CFs.DWLog(_T("OK\n"));

}

void DiscWrapperFrame::OpenProjectV5(wxString path)       // Open script for version 5
{
    wxFile file;
    wxString temp;
    int i, j, g, page, it;
    wxChar* c;

    file.Open(path, wxFile::read);

    file.Seek(52, wxFromStart);

    file.Read(&Database->PDP, sizeof(int));
    file.Read(&Database->PDC, sizeof(int));

    for ( page = 0 ; page < 4 ; page++ )
    {
        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[page].PageBackPath = wxString(c, j);
        delete[] c;
    }

    CFs.DWLog(_T("."));

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[0].labels.Add(LabelStructure(), it);

    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[0].labels[i].L = wxString(c, j);
        delete[] c;
        file.Read(&Database->Page[0].labels[i].X, sizeof(int));
        file.Read(&Database->Page[0].labels[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[0].labels[i].Font.SetChosenFont(font);
        Database->Page[0].labels[i].Font.SetInitialFont(Database->Page[0].labels[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[0].labels[i].Colour.SetColour(colour);

        file.Read(&Database->Page[0].labels[i].Angle, sizeof(double));
        file.Read(&Database->Page[0].labels[i].Class, sizeof(int));
        file.Read(&Database->Page[0].labels[i].Align, sizeof(int));
        Database->Page[0].labels[i].Bend = false;
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[1].labels.Add(LabelStructure(), it);

    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[1].labels[i].L = wxString(c, j);
        delete[] c;
        file.Read(&Database->Page[1].labels[i].X, sizeof(int));
        file.Read(&Database->Page[1].labels[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[1].labels[i].Font.SetChosenFont(font);
        Database->Page[1].labels[i].Font.SetInitialFont(Database->Page[1].labels[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[1].labels[i].Colour.SetColour(colour);

        file.Read(&Database->Page[1].labels[i].Angle, sizeof(double));
        file.Read(&Database->Page[1].labels[i].Class, sizeof(int));
        file.Read(&Database->Page[1].labels[i].Align, sizeof(int));
        Database->Page[1].labels[i].Bend = false;
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[2].labels.Add(LabelStructure(), it);

    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[2].labels[i].L = wxString(c, j);
        delete[] c;
        file.Read(&Database->Page[2].labels[i].X, sizeof(int));
        file.Read(&Database->Page[2].labels[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[2].labels[i].Font.SetChosenFont(font);
        Database->Page[2].labels[i].Font.SetInitialFont(Database->Page[2].labels[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[2].labels[i].Colour.SetColour(colour);

        file.Read(&Database->Page[2].labels[i].Angle, sizeof(double));
        file.Read(&Database->Page[2].labels[i].Class, sizeof(int));
        file.Read(&Database->Page[2].labels[i].Align, sizeof(int));
        Database->Page[2].labels[i].Bend = false;
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[3].labels.Add(LabelStructure(), it);

    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[3].labels[i].L = wxString(c, j);
        delete[] c;
        file.Read(&Database->Page[3].labels[i].X, sizeof(int));
        file.Read(&Database->Page[3].labels[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[3].labels[i].Font.SetChosenFont(font);
        Database->Page[3].labels[i].Font.SetInitialFont(Database->Page[3].labels[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[3].labels[i].Colour.SetColour(colour);

        file.Read(&Database->Page[3].labels[i].Angle, sizeof(double));
        file.Read(&Database->Page[3].labels[i].Class, sizeof(int));
        file.Read(&Database->Page[3].labels[i].Align, sizeof(int));

        char Bend;
        file.Read(&Bend, sizeof(char));


        if ( Bend == 1 )
            Database->Page[3].labels[i].Bend = true;
        else
            Database->Page[3].labels[i].Bend = false;
    }


    CFs.DWLog(_T("."));

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[0].lists.Add(ListStructure(), it);
    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;

        g = 0;
        wxString xstr = wxEmptyString;
        while ( g < stemp.Len() )
        {
            if ( stemp[g] != '\n' )
            {
                xstr += stemp[g];
                g++;
            }
            else
            {
                Database->Page[0].lists[i].L.Add(xstr);
                xstr = wxEmptyString;
                g++;
            }
        }
        Database->Page[0].lists[i].L.Add(xstr);

        file.Read(&Database->Page[0].lists[i].X, sizeof(int));
        file.Read(&Database->Page[0].lists[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[0].lists[i].Font.SetChosenFont(font);
        Database->Page[0].lists[i].Font.SetInitialFont(Database->Page[0].lists[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[0].lists[i].Colour.SetColour(colour);
    }

    CFs.DWLog(_T("."));

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[1].lists.Add(ListStructure(), it);
    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;

        g = 0;
        wxString xstr = wxEmptyString;
        while ( g < stemp.Len() )
        {
            if ( stemp[g] != '\n' )
            {
                xstr += stemp[g];
                g++;
            }
            else
            {
                Database->Page[1].lists[i].L.Add(xstr);
                xstr = wxEmptyString;
                g++;
            }
        }
        Database->Page[1].lists[i].L.Add(xstr);

        file.Read(&Database->Page[1].lists[i].X, sizeof(int));
        file.Read(&Database->Page[1].lists[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[1].lists[i].Font.SetChosenFont(font);
        Database->Page[1].lists[i].Font.SetInitialFont(Database->Page[1].lists[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[1].lists[i].Colour.SetColour(colour);
    }

    CFs.DWLog(_T("."));

    file.Read(&it, sizeof(int));
    if ( it != 0 )
        Database->Page[2].lists.Add(ListStructure(), it);
    for ( i = 0 ; i < it ; i++ )
    {
        wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
        wxString stemp = wxEmptyString;
        bool SetFace = false;
        int Point = 22;

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;

        g = 0;
        wxString xstr = wxEmptyString;
        while ( g < stemp.Len() )
        {
            if ( stemp[g] != '\n' )
            {
                xstr += stemp[g];
                g++;
            }
            else
            {
                Database->Page[2].lists[i].L.Add(xstr);
                xstr = wxEmptyString;
                g++;
            }
        }
        Database->Page[2].lists[i].L.Add(xstr);

        file.Read(&Database->Page[2].lists[i].X, sizeof(int));
        file.Read(&Database->Page[2].lists[i].Y, sizeof(int));

        file.Read(&j, sizeof(int));
        font.SetPointSize(j);
        Point = j;
        file.Read(&j, sizeof(int));
        switch(j){
            case 70:
                font.SetFamily(wxFONTFAMILY_DEFAULT);
                break;
            case 71:
                font.SetFamily(wxFONTFAMILY_DECORATIVE);
                break;
            case 72:
                font.SetFamily(wxFONTFAMILY_ROMAN);
                break;
            case 73:
                font.SetFamily(wxFONTFAMILY_SCRIPT);
                break;
            case 74:
                font.SetFamily(wxFONTFAMILY_SWISS);
                break;
            case 75:
                font.SetFamily(wxFONTFAMILY_MODERN);
                break;
            case 76:
                font.SetFamily(wxFONTFAMILY_TELETYPE);
                break;
            default:
                SetFace = true;
                break;
        }
        file.Read(&j, sizeof(int));
        font.SetStyle(j);
        file.Read(&j, sizeof(int));
        switch(j){
            case 90:
                font.SetWeight(wxFONTWEIGHT_NORMAL);
                break;
            case 91:
                font.SetWeight(wxFONTWEIGHT_LIGHT);
                break;
            case 92:
                font.SetWeight(wxFONTWEIGHT_BOLD);
                break;
        }

        file.Read(&j, sizeof(int));
        c = new wxChar[j];
        for ( g = 0 ; g < j ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            stemp = wxString(c, j);
        delete[] c;
        if ( SetFace == true )
        {
            if (font.SetFaceName(stemp) == false)
            {
                font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
            }
        }

        Database->Page[2].lists[i].Font.SetChosenFont(font);
        Database->Page[2].lists[i].Font.SetInitialFont(Database->Page[2].lists[i].Font.GetChosenFont());

        unsigned char R, G, B, A;
        wxColour colour;

        file.Read(&R, sizeof(unsigned char));
        file.Read(&G, sizeof(unsigned char));
        file.Read(&B, sizeof(unsigned char));
        file.Read(&A, sizeof(unsigned char));

        colour.Set(R, G, B, A);

        Database->Page[2].lists[i].Colour.SetColour(colour);
    }

    CFs.DWLog(_T("."));

    file.Read(&it, sizeof(int));
    if ( it != 0 )
    {
        Database->Page[0].images.Add(ImageStructure(), it);

        int compense = 0, till = it;
        for ( i = 0 ; i < till ; i++ )
        {
            file.Read(&Database->Page[0].images[i-compense].X, sizeof(int));
            file.Read(&Database->Page[0].images[i-compense].Y, sizeof(int));
            file.Read(&Database->Page[0].images[i-compense].Scale, sizeof(int));
            file.Read(&Database->Page[0].images[i-compense].Rotate, sizeof(int));
            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
            Database->Page[0].images[i-compense].Path = wxString(c, j);
            delete[] c;

            if ( wxFile::Exists(Database->Page[0].images[i-compense].Path) != true )
            {
                wxMessageDialog(this, _("Perviously added image no longer exists. It will be removed from the project.\n\n")+Database->Page[0].images[i-compense].Path, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

                compense++;

                Database->Page[0].images.RemoveAt(Database->Page[0].images.GetCount()-1);
            }
        }
        Database->Page[0].ImageOrder.Empty();
        if ( Database->Page[0].images.GetCount() != 0 )
        {
            for ( i = 0 ; i < Database->Page[0].images.GetCount() ; i++ )
            {
                Database->Page[0].images[i].Img = Database->Page[0].images[i].Path;
                Database->Page[0].ImageOrder.Add(i);
            }
        }
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
    {
        Database->Page[1].images.Add(ImageStructure(), it);

        int compense = 0, till = it;
        for ( i = 0 ; i < till ; i++ )
        {
            file.Read(&Database->Page[1].images[i-compense].X, sizeof(int));
            file.Read(&Database->Page[1].images[i-compense].Y, sizeof(int));
            file.Read(&Database->Page[1].images[i-compense].Scale, sizeof(int));
            file.Read(&Database->Page[1].images[i-compense].Rotate, sizeof(int));
            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
            Database->Page[1].images[i-compense].Path = wxString(c, j);
            delete[] c;

            if ( wxFile::Exists(Database->Page[1].images[i-compense].Path) != true )
            {
                wxMessageDialog(this, _("Perviously added image no longer exists. It will be removed from the project.\n\n")+Database->Page[1].images[i-compense].Path, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

                compense++;

                Database->Page[1].images.RemoveAt(Database->Page[1].images.GetCount()-1);
            }
        }

        Database->Page[1].ImageOrder.Empty();
        if ( Database->Page[1].images.GetCount() != 0 )
        {
            for ( i = 0 ; i < Database->Page[1].images.GetCount() ; i++ )
            {
                Database->Page[1].images[i].Img = Database->Page[1].images[i].Path;
                Database->Page[1].ImageOrder.Add(i);
            }
        }
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
    {
        Database->Page[2].images.Add(ImageStructure(), it);

        int compense = 0, till = it;
        for ( i = 0 ; i < till ; i++ )
        {
            file.Read(&Database->Page[2].images[i-compense].X, sizeof(int));
            file.Read(&Database->Page[2].images[i-compense].Y, sizeof(int));
            file.Read(&Database->Page[2].images[i-compense].Scale, sizeof(int));
            file.Read(&Database->Page[2].images[i-compense].Rotate, sizeof(int));
            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
            Database->Page[2].images[i-compense].Path = wxString(c, j);
            delete[] c;

            if ( wxFile::Exists(Database->Page[2].images[i-compense].Path) != true )
            {
                wxMessageDialog(this, _("Perviously added image no longer exists. It will be removed from the project.\n\n")+Database->Page[2].images[i-compense].Path, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

                compense++;

                Database->Page[2].images.RemoveAt(Database->Page[2].images.GetCount()-1);
            }
        }

        Database->Page[2].ImageOrder.Empty();
        if ( Database->Page[2].images.GetCount() != 0 )
        {
            for ( i = 0 ; i < Database->Page[2].images.GetCount() ; i++ )
            {
                Database->Page[2].images[i].Img = Database->Page[2].images[i].Path;
                Database->Page[2].ImageOrder.Add(i);
            }
        }
    }

    file.Read(&it, sizeof(int));
    if ( it != 0 )
    {
        Database->Page[3].images.Add(ImageStructure(), it);

        int compense = 0, till = it;
        for ( i = 0 ; i < till ; i++ )
        {
            file.Read(&Database->Page[3].images[i-compense].X, sizeof(int));
            file.Read(&Database->Page[3].images[i-compense].Y, sizeof(int));
            file.Read(&Database->Page[3].images[i-compense].Scale, sizeof(int));
            file.Read(&Database->Page[3].images[i-compense].Rotate, sizeof(int));
            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
            Database->Page[3].images[i-compense].Path = wxString(c, j);
            delete[] c;

            if ( wxFile::Exists(Database->Page[3].images[i-compense].Path) != true )
            {
                wxMessageDialog(this, _("Perviously added image no longer exists. It will be removed from the project.\n\n")+Database->Page[3].images[i-compense].Path, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

                compense++;

                Database->Page[3].images.RemoveAt(Database->Page[3].images.GetCount()-1);
            }
        }

        Database->Page[3].ImageOrder.Empty();
        if ( Database->Page[3].images.GetCount() != 0 )
        {
            for ( i = 0 ; i < Database->Page[3].images.GetCount() ; i++ )
            {
                Database->Page[3].images[i].Img = Database->Page[3].images[i].Path;
                Database->Page[3].ImageOrder.Add(i);
            }
        }
    }

    file.Close();
}

void DiscWrapperFrame::OpenProjectV6(wxString path)       // Open script for version 6 (current)
{
    wxFile file;
    wxString temp;
    int i, j, g, page, it;
    wxChar* c;

    file.Open(path, wxFile::read);

    file.Seek(52, wxFromStart);

    CFs.DWLog(_T("."));

    file.Read(&Database->PDP, sizeof(int));
    file.Read(&Database->PDC, sizeof(int));

    for ( page = 0 ; page < 4 ; page++ )
    {
        file.Read(&i, sizeof(int));
        c = new wxChar[i];
        for ( g = 0 ; g < i ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            Database->Page[page].PageBackPath = wxString(c, i);
        delete[] c;

        CFs.DWLog(_T("."));

        int it;
        file.Read(&it, sizeof(int));
        if ( it != 0 )
            Database->Page[page].labels.Add(LabelStructure(), it);

        for ( i = 0 ; i < it ; i++ )
        {
            wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
            wxString stemp = wxEmptyString;
            bool SetFace = false;
            int Point = 22;

            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
                Database->Page[page].labels[i].L = wxString(c, j);
            delete[] c;
            file.Read(&Database->Page[page].labels[i].X, sizeof(int));
            file.Read(&Database->Page[page].labels[i].Y, sizeof(int));

            file.Read(&j, sizeof(int));
            font.SetPointSize(j);
            Point = j;
            file.Read(&j, sizeof(int));
            switch(j){
                case 70:
                    font.SetFamily(wxFONTFAMILY_DEFAULT);
                    break;
                case 71:
                    font.SetFamily(wxFONTFAMILY_DECORATIVE);
                    break;
                case 72:
                    font.SetFamily(wxFONTFAMILY_ROMAN);
                    break;
                case 73:
                    font.SetFamily(wxFONTFAMILY_SCRIPT);
                    break;
                case 74:
                    font.SetFamily(wxFONTFAMILY_SWISS);
                    break;
                case 75:
                    font.SetFamily(wxFONTFAMILY_MODERN);
                    break;
                case 76:
                    font.SetFamily(wxFONTFAMILY_TELETYPE);
                    break;
                default:
                    SetFace = true;
                    break;
            }
            file.Read(&j, sizeof(int));
            font.SetStyle(j);
            file.Read(&j, sizeof(int));
            switch(j){
                case 90:
                    font.SetWeight(wxFONTWEIGHT_NORMAL);
                    break;
                case 91:
                    font.SetWeight(wxFONTWEIGHT_LIGHT);
                    break;
                case 92:
                    font.SetWeight(wxFONTWEIGHT_BOLD);
                    break;
            }

            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
                stemp = wxString(c, j);
            delete[] c;
            if ( SetFace == true )
            {
                if (font.SetFaceName(stemp) == false)
                {
                    font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
                }
            }

            Database->Page[page].labels[i].Font.SetChosenFont(font);
            Database->Page[page].labels[i].Font.SetInitialFont(Database->Page[page].labels[i].Font.GetChosenFont());

            unsigned char R, G, B, A;
            wxColour colour;

            file.Read(&R, sizeof(unsigned char));
            file.Read(&G, sizeof(unsigned char));
            file.Read(&B, sizeof(unsigned char));
            file.Read(&A, sizeof(unsigned char));

            colour.Set(R, G, B, A);

            Database->Page[page].labels[i].Colour.SetColour(colour);

            file.Read(&Database->Page[page].labels[i].Angle, sizeof(double));
            file.Read(&Database->Page[page].labels[i].Class, sizeof(int));
            file.Read(&Database->Page[page].labels[i].Align, sizeof(int));

            char Bend;
            file.Read(&Bend, sizeof(char));


            if ( Bend == 1 )
                Database->Page[page].labels[i].Bend = true;
            else
                Database->Page[page].labels[i].Bend = false;
        }

        CFs.DWLog(_T("."));

        file.Read(&it, sizeof(int));
        if ( it != 0 )
            Database->Page[page].lists.Add(ListStructure(), it);
        for ( i = 0 ; i < it ; i++ )
        {
            wxFont font = wxFont(22, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
            wxString stemp = wxEmptyString;
            bool SetFace = false;
            int Point = 22;

            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
                stemp = wxString(c, j);
            delete[] c;

            g = 0;
            wxString xstr = wxEmptyString;
            while ( g < stemp.Len() )
            {
                if ( stemp[g] != '\n' )
                {
                    xstr += stemp[g];
                    g++;
                }
                else
                {
                    Database->Page[page].lists[i].L.Add(xstr);
                    xstr = wxEmptyString;
                    g++;
                }
            }
            Database->Page[page].lists[i].L.Add(xstr);

            file.Read(&Database->Page[page].lists[i].X, sizeof(int));
            file.Read(&Database->Page[page].lists[i].Y, sizeof(int));

            file.Read(&j, sizeof(int));
            font.SetPointSize(j);
            Point = j;
            file.Read(&j, sizeof(int));
            switch(j){
                case 70:
                    font.SetFamily(wxFONTFAMILY_DEFAULT);
                    break;
                case 71:
                    font.SetFamily(wxFONTFAMILY_DECORATIVE);
                    break;
                case 72:
                    font.SetFamily(wxFONTFAMILY_ROMAN);
                    break;
                case 73:
                    font.SetFamily(wxFONTFAMILY_SCRIPT);
                    break;
                case 74:
                    font.SetFamily(wxFONTFAMILY_SWISS);
                    break;
                case 75:
                    font.SetFamily(wxFONTFAMILY_MODERN);
                    break;
                case 76:
                    font.SetFamily(wxFONTFAMILY_TELETYPE);
                    break;
                default:
                    SetFace = true;
                    break;
            }
            file.Read(&j, sizeof(int));
            font.SetStyle(j);
            file.Read(&j, sizeof(int));
            switch(j){
                case 90:
                    font.SetWeight(wxFONTWEIGHT_NORMAL);
                    break;
                case 91:
                    font.SetWeight(wxFONTWEIGHT_LIGHT);
                    break;
                case 92:
                    font.SetWeight(wxFONTWEIGHT_BOLD);
                    break;
            }

            file.Read(&j, sizeof(int));
            c = new wxChar[j];
            for ( g = 0 ; g < j ; g++ )
                file.Read(&c[g], sizeof(wxChar));
                stemp = wxString(c, j);
            delete[] c;
            if ( SetFace == true )
            {
                if (font.SetFaceName(stemp) == false)
                {
                    font = wxFont(Point, wxFONTFAMILY_DECORATIVE, wxNORMAL, wxNORMAL);
                }
            }

            Database->Page[page].lists[i].Font.SetChosenFont(font);
            Database->Page[page].lists[i].Font.SetInitialFont(Database->Page[page].lists[i].Font.GetChosenFont());

            unsigned char R, G, B, A;
            wxColour colour;

            file.Read(&R, sizeof(unsigned char));
            file.Read(&G, sizeof(unsigned char));
            file.Read(&B, sizeof(unsigned char));
            file.Read(&A, sizeof(unsigned char));

            colour.Set(R, G, B, A);

            Database->Page[page].lists[i].Colour.SetColour(colour);
        }

        CFs.DWLog(_T("."));

        file.Read(&it, sizeof(int));
        if ( it != 0 )
        {
            Database->Page[page].images.Add(ImageStructure(), it);
            Database->Page[page].ImageOrder.Add(0, it);

            int compense = 0, till = it;
            for ( i = 0 ; i < till ; i++ )
            {
                file.Read(&Database->Page[page].images[i-compense].X, sizeof(int));
                file.Read(&Database->Page[page].images[i-compense].Y, sizeof(int));
                file.Read(&Database->Page[page].images[i-compense].Scale, sizeof(int));
                file.Read(&Database->Page[page].images[i-compense].Rotate, sizeof(int));
                file.Read(&Database->Page[page].ImageOrder[i-compense], sizeof(int));
                file.Read(&j, sizeof(int));
                c = new wxChar[j];
                for ( g = 0 ; g < j ; g++ )
                    file.Read(&c[g], sizeof(wxChar));
                Database->Page[page].images[i-compense].Path = wxString(c, j);
                delete[] c;

                if ( wxFile::Exists(Database->Page[page].images[i-compense].Path) != true )
                {
                    wxMessageDialog(this, _("Perviously added image no longer exists. It will be removed from the project.\n\n")+Database->Page[0].images[i-compense].Path, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

                    compense++;

                    Database->Page[page].images.RemoveAt(Database->Page[page].images.GetCount()-1);
                    Database->Page[page].ImageOrder.RemoveAt(Database->Page[page].ImageOrder.GetCount()-1);
                }
            }
            if ( Database->Page[page].images.GetCount() != 0 )
            {
                for ( i = 0 ; i < Database->Page[page].images.GetCount() ; i++ )
                {
                    Database->Page[page].images[i].Img = Database->Page[page].images[i].Path;
                }
            }
        }


    }

    file.Close();

    CFs.DWLog(_T("."));

    Clear_Tool_history();// FIXME (nandor#1#): Needed?

    CFs.DWLog(_T("."));
}

void DiscWrapperFrame::USB()    // Update Status Bar
{
    StatusBar1->SetStatusText(STATUS, 1);
}

void DiscWrapperFrame::UpdatePrj5To6()
{
    int i, j, g;

    for ( i = 0 ; i < 4 ; i++ )
    {
        for ( j = 0 ; j < Database->Page[i].lists.GetCount() ; j++ )
        {
            for ( g = 0 ; g < Database->Page[i].lists[j].L.GetCount() ; g++ )
            {
                Database->Page[i].lists[j].L.Item(g) = _T("l") + wxString::Format(_T("%i"), Database->Page[i].lists[j].L.Item(g).Len()) + _T(";") + Database->Page[i].lists[j].L.Item(g);
            }

            Database->Page[i].lists[j].L.Insert(_T("1;200;"), 0);
        }

    }
}

void DiscWrapperFrame::UpdatePrj6To7()
{
    int i;
    for ( i = 0 ; i < 4 ; i++ )
    {
        if ( Database->Page[i].PageBackPath != wxEmptyString )
        {
            if ( Database->Page[i].PageBackPath == _T("CD-Default.jpg") )
                Database->Page[i].PageBackPath = _T("simple-design/cdmain.jpg");
            else if ( Database->Page[i].PageBackPath == _T("DVD_slim-Default.jpg") )
                Database->Page[i].PageBackPath = _T("simple-design/dvdsl.jpg");
            else if ( Database->Page[i].PageBackPath == _T("DVD_standard-Default.jpg") )
                Database->Page[i].PageBackPath = _T("simple-design/dvdst.jpg");
            else
                Database->Page[i].PageBackPath = wxEmptyString;
        }
    }
}
