'''OpenGL extension EXT.packed_float

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.packed_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a new 3-component floating-point texture format
	that fits within a single 32-bit word.  This format stores 5 bits
	of biased exponent per component in the same manner as 16-bit
	floating-point formats, but rather than 10 mantissa bits, the red,
	green, and blue components have 6, 6, and 5 bits respectively.
	Each mantissa is assumed to have an implied leading one except in the
	denorm exponent case.  There is no sign bit so only non-negative
	values can be represented.  Positive infinity, positive denorms,
	and positive NaN values are representable.  The value of the fourth
	component returned by a texture fetch is always 1.0.
	
	This extension also provides support for rendering into an unsigned
	floating-point rendering format with the assumption that the texture
	format described above could also be advertised as an unsigned
	floating-point format for rendering.
	
	The extension also provides a pixel external format for specifying
	packed float values directly.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/packed_float.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.EXT.packed_float import *
### END AUTOGENERATED SECTION