# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
"""
This namespace contains endpoints and data types for basic file operations.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        async,
        common,
        properties,
        users,
    )
except (SystemError, ValueError):
    import async
    import common
    import properties
    import users

class PropertiesError(properties.PropertyTemplateError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: PropertiesError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'PropertiesError(%r, %r)' % (self._tag, self._value)

PropertiesError_validator = bv.Union(PropertiesError)

class InvalidPropertyGroupError(PropertiesError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_field_too_large: A field value in this property group is too
        large.
    :ivar does_not_fit_template: The property group specified does not conform
        to the property template.
    """

    # Attribute is overwritten below the class definition
    property_field_too_large = None
    # Attribute is overwritten below the class definition
    does_not_fit_template = None

    def is_property_field_too_large(self):
        """
        Check if the union tag is ``property_field_too_large``.

        :rtype: bool
        """
        return self._tag == 'property_field_too_large'

    def is_does_not_fit_template(self):
        """
        Check if the union tag is ``does_not_fit_template``.

        :rtype: bool
        """
        return self._tag == 'does_not_fit_template'

    def __repr__(self):
        return 'InvalidPropertyGroupError(%r, %r)' % (self._tag, self._value)

InvalidPropertyGroupError_validator = bv.Union(InvalidPropertyGroupError)

class AddPropertiesError(InvalidPropertyGroupError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_group_already_exists: This property group already exists for
        this file.
    """

    # Attribute is overwritten below the class definition
    property_group_already_exists = None

    def is_property_group_already_exists(self):
        """
        Check if the union tag is ``property_group_already_exists``.

        :rtype: bool
        """
        return self._tag == 'property_group_already_exists'

    def __repr__(self):
        return 'AddPropertiesError(%r, %r)' % (self._tag, self._value)

AddPropertiesError_validator = bv.Union(AddPropertiesError)

class GetMetadataArg(object):
    """
    :ivar path: The path of a file or folder on Dropbox.
    :ivar include_media_info: If true, ``FileMetadata.media_info`` is set for
        photo and video.
    :ivar include_deleted: If true, :class:`DeletedMetadata` will be returned
        for deleted file or folder, otherwise ``LookupError.not_found`` will be
        returned.
    :ivar include_has_explicit_shared_members: If true, the results will include
        a flag for each file indicating whether or not  that file has any
        explicit members.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_include_media_info_value',
        '_include_media_info_present',
        '_include_deleted_value',
        '_include_deleted_present',
        '_include_has_explicit_shared_members_value',
        '_include_has_explicit_shared_members_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None):
        self._path_value = None
        self._path_present = False
        self._include_media_info_value = None
        self._include_media_info_present = False
        self._include_deleted_value = None
        self._include_deleted_present = False
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False
        if path is not None:
            self.path = path
        if include_media_info is not None:
            self.include_media_info = include_media_info
        if include_deleted is not None:
            self.include_deleted = include_deleted
        if include_has_explicit_shared_members is not None:
            self.include_has_explicit_shared_members = include_has_explicit_shared_members

    @property
    def path(self):
        """
        The path of a file or folder on Dropbox.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def include_media_info(self):
        """
        If true, ``FileMetadata.media_info`` is set for photo and video.

        :rtype: bool
        """
        if self._include_media_info_present:
            return self._include_media_info_value
        else:
            return False

    @include_media_info.setter
    def include_media_info(self, val):
        val = self._include_media_info_validator.validate(val)
        self._include_media_info_value = val
        self._include_media_info_present = True

    @include_media_info.deleter
    def include_media_info(self):
        self._include_media_info_value = None
        self._include_media_info_present = False

    @property
    def include_deleted(self):
        """
        If true, :class:`DeletedMetadata` will be returned for deleted file or
        folder, otherwise ``LookupError.not_found`` will be returned.

        :rtype: bool
        """
        if self._include_deleted_present:
            return self._include_deleted_value
        else:
            return False

    @include_deleted.setter
    def include_deleted(self, val):
        val = self._include_deleted_validator.validate(val)
        self._include_deleted_value = val
        self._include_deleted_present = True

    @include_deleted.deleter
    def include_deleted(self):
        self._include_deleted_value = None
        self._include_deleted_present = False

    @property
    def include_has_explicit_shared_members(self):
        """
        If true, the results will include a flag for each file indicating
        whether or not  that file has any explicit members.

        :rtype: bool
        """
        if self._include_has_explicit_shared_members_present:
            return self._include_has_explicit_shared_members_value
        else:
            return False

    @include_has_explicit_shared_members.setter
    def include_has_explicit_shared_members(self, val):
        val = self._include_has_explicit_shared_members_validator.validate(val)
        self._include_has_explicit_shared_members_value = val
        self._include_has_explicit_shared_members_present = True

    @include_has_explicit_shared_members.deleter
    def include_has_explicit_shared_members(self):
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False

    def __repr__(self):
        return 'GetMetadataArg(path={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r})'.format(
            self._path_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
        )

GetMetadataArg_validator = bv.Struct(GetMetadataArg)

class AlphaGetMetadataArg(GetMetadataArg):
    """
    :ivar include_property_templates: If true, ``FileMetadata.property_groups``
        is set for files with custom properties.
    """

    __slots__ = [
        '_include_property_templates_value',
        '_include_property_templates_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None,
                 include_property_templates=None):
        super(AlphaGetMetadataArg, self).__init__(path,
                                                  include_media_info,
                                                  include_deleted,
                                                  include_has_explicit_shared_members)
        self._include_property_templates_value = None
        self._include_property_templates_present = False
        if include_property_templates is not None:
            self.include_property_templates = include_property_templates

    @property
    def include_property_templates(self):
        """
        If true, ``FileMetadata.property_groups`` is set for files with custom
        properties.

        :rtype: list of [str]
        """
        if self._include_property_templates_present:
            return self._include_property_templates_value
        else:
            return None

    @include_property_templates.setter
    def include_property_templates(self, val):
        if val is None:
            del self.include_property_templates
            return
        val = self._include_property_templates_validator.validate(val)
        self._include_property_templates_value = val
        self._include_property_templates_present = True

    @include_property_templates.deleter
    def include_property_templates(self):
        self._include_property_templates_value = None
        self._include_property_templates_present = False

    def __repr__(self):
        return 'AlphaGetMetadataArg(path={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r}, include_property_templates={!r})'.format(
            self._path_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
            self._include_property_templates_value,
        )

AlphaGetMetadataArg_validator = bv.Struct(AlphaGetMetadataArg)

class GetMetadataError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetMetadataError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetMetadataError(%r, %r)' % (self._tag, self._value)

GetMetadataError_validator = bv.Union(GetMetadataError)

class AlphaGetMetadataError(GetMetadataError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def properties_error(cls, val):
        """
        Create an instance of this class set to the ``properties_error`` tag
        with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: AlphaGetMetadataError
        """
        return cls('properties_error', val)

    def is_properties_error(self):
        """
        Check if the union tag is ``properties_error``.

        :rtype: bool
        """
        return self._tag == 'properties_error'

    def get_properties_error(self):
        """
        Only call this if :meth:`is_properties_error` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_properties_error():
            raise AttributeError("tag 'properties_error' not set")
        return self._value

    def __repr__(self):
        return 'AlphaGetMetadataError(%r, %r)' % (self._tag, self._value)

AlphaGetMetadataError_validator = bv.Union(AlphaGetMetadataError)

class CommitInfo(object):
    """
    :ivar path: Path in the user's Dropbox to save the file.
    :ivar mode: Selects what to do if the file already exists.
    :ivar autorename: If there's a conflict, as determined by ``mode``, have the
        Dropbox server try to autorename the file to avoid conflict.
    :ivar client_modified: The value to store as the ``client_modified``
        timestamp. Dropbox automatically records the time at which the file was
        written to the Dropbox servers. It can also record an additional
        timestamp, provided by Dropbox desktop clients, mobile clients, and API
        apps of when the file was actually created or modified.
    :ivar mute: Normally, users are made aware of any file modifications in
        their Dropbox account via notifications in the client software. If
        ``True``, this tells the clients that this modification shouldn't result
        in a user notification.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_mode_value',
        '_mode_present',
        '_autorename_value',
        '_autorename_present',
        '_client_modified_value',
        '_client_modified_present',
        '_mute_value',
        '_mute_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 mode=None,
                 autorename=None,
                 client_modified=None,
                 mute=None):
        self._path_value = None
        self._path_present = False
        self._mode_value = None
        self._mode_present = False
        self._autorename_value = None
        self._autorename_present = False
        self._client_modified_value = None
        self._client_modified_present = False
        self._mute_value = None
        self._mute_present = False
        if path is not None:
            self.path = path
        if mode is not None:
            self.mode = mode
        if autorename is not None:
            self.autorename = autorename
        if client_modified is not None:
            self.client_modified = client_modified
        if mute is not None:
            self.mute = mute

    @property
    def path(self):
        """
        Path in the user's Dropbox to save the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def mode(self):
        """
        Selects what to do if the file already exists.

        :rtype: WriteMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return WriteMode.add

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    @property
    def autorename(self):
        """
        If there's a conflict, as determined by ``mode``, have the Dropbox
        server try to autorename the file to avoid conflict.

        :rtype: bool
        """
        if self._autorename_present:
            return self._autorename_value
        else:
            return False

    @autorename.setter
    def autorename(self, val):
        val = self._autorename_validator.validate(val)
        self._autorename_value = val
        self._autorename_present = True

    @autorename.deleter
    def autorename(self):
        self._autorename_value = None
        self._autorename_present = False

    @property
    def client_modified(self):
        """
        The value to store as the ``client_modified`` timestamp. Dropbox
        automatically records the time at which the file was written to the
        Dropbox servers. It can also record an additional timestamp, provided by
        Dropbox desktop clients, mobile clients, and API apps of when the file
        was actually created or modified.

        :rtype: datetime.datetime
        """
        if self._client_modified_present:
            return self._client_modified_value
        else:
            return None

    @client_modified.setter
    def client_modified(self, val):
        if val is None:
            del self.client_modified
            return
        val = self._client_modified_validator.validate(val)
        self._client_modified_value = val
        self._client_modified_present = True

    @client_modified.deleter
    def client_modified(self):
        self._client_modified_value = None
        self._client_modified_present = False

    @property
    def mute(self):
        """
        Normally, users are made aware of any file modifications in their
        Dropbox account via notifications in the client software. If ``True``,
        this tells the clients that this modification shouldn't result in a user
        notification.

        :rtype: bool
        """
        if self._mute_present:
            return self._mute_value
        else:
            return False

    @mute.setter
    def mute(self, val):
        val = self._mute_validator.validate(val)
        self._mute_value = val
        self._mute_present = True

    @mute.deleter
    def mute(self):
        self._mute_value = None
        self._mute_present = False

    def __repr__(self):
        return 'CommitInfo(path={!r}, mode={!r}, autorename={!r}, client_modified={!r}, mute={!r})'.format(
            self._path_value,
            self._mode_value,
            self._autorename_value,
            self._client_modified_value,
            self._mute_value,
        )

CommitInfo_validator = bv.Struct(CommitInfo)

class CommitInfoWithProperties(CommitInfo):
    """
    :ivar property_groups: List of custom properties to add to file.
    """

    __slots__ = [
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 mode=None,
                 autorename=None,
                 client_modified=None,
                 mute=None,
                 property_groups=None):
        super(CommitInfoWithProperties, self).__init__(path,
                                                       mode,
                                                       autorename,
                                                       client_modified,
                                                       mute)
        self._property_groups_value = None
        self._property_groups_present = False
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def property_groups(self):
        """
        List of custom properties to add to file.

        :rtype: list of [properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'CommitInfoWithProperties(path={!r}, mode={!r}, autorename={!r}, client_modified={!r}, mute={!r}, property_groups={!r})'.format(
            self._path_value,
            self._mode_value,
            self._autorename_value,
            self._client_modified_value,
            self._mute_value,
            self._property_groups_value,
        )

CommitInfoWithProperties_validator = bv.Struct(CommitInfoWithProperties)

class CreateFolderArg(object):
    """
    :ivar path: Path in the user's Dropbox to create.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        Path in the user's Dropbox to create.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'CreateFolderArg(path={!r})'.format(
            self._path_value,
        )

CreateFolderArg_validator = bv.Struct(CreateFolderArg)

class CreateFolderError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: CreateFolderError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'CreateFolderError(%r, %r)' % (self._tag, self._value)

CreateFolderError_validator = bv.Union(CreateFolderError)

class DeleteArg(object):
    """
    :ivar path: Path in the user's Dropbox to delete.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        Path in the user's Dropbox to delete.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'DeleteArg(path={!r})'.format(
            self._path_value,
        )

DeleteArg_validator = bv.Struct(DeleteArg)

class DeleteError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path_lookup(cls, val):
        """
        Create an instance of this class set to the ``path_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: DeleteError
        """
        return cls('path_lookup', val)

    @classmethod
    def path_write(cls, val):
        """
        Create an instance of this class set to the ``path_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: DeleteError
        """
        return cls('path_write', val)

    def is_path_lookup(self):
        """
        Check if the union tag is ``path_lookup``.

        :rtype: bool
        """
        return self._tag == 'path_lookup'

    def is_path_write(self):
        """
        Check if the union tag is ``path_write``.

        :rtype: bool
        """
        return self._tag == 'path_write'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path_lookup(self):
        """
        Only call this if :meth:`is_path_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_path_lookup():
            raise AttributeError("tag 'path_lookup' not set")
        return self._value

    def get_path_write(self):
        """
        Only call this if :meth:`is_path_write` is true.

        :rtype: WriteError
        """
        if not self.is_path_write():
            raise AttributeError("tag 'path_write' not set")
        return self._value

    def __repr__(self):
        return 'DeleteError(%r, %r)' % (self._tag, self._value)

DeleteError_validator = bv.Union(DeleteError)

class Metadata(object):
    """
    Metadata for a file or folder.

    :ivar name: The last component of the path (including extension). This never
        contains a slash.
    :ivar path_lower: The lowercased full path in the user's Dropbox. This
        always starts with a slash. This field will be null if the file or
        folder is not mounted.
    :ivar path_display: The cased path to be used for display purposes only. In
        rare instances the casing will not correctly match the user's
        filesystem, but this behavior will match the path provided in the Core
        API v1. Changes to the casing of paths won't be returned by
        list_folder/continue. This field will be null if the file or folder is
        not mounted.
    :ivar parent_shared_folder_id: Deprecated. Please use
        ``FileSharingInfo.parent_shared_folder_id`` or
        ``FolderSharingInfo.parent_shared_folder_id`` instead.
    """

    __slots__ = [
        '_name_value',
        '_name_present',
        '_path_lower_value',
        '_path_lower_present',
        '_path_display_value',
        '_path_display_present',
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None):
        self._name_value = None
        self._name_present = False
        self._path_lower_value = None
        self._path_lower_present = False
        self._path_display_value = None
        self._path_display_present = False
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        if name is not None:
            self.name = name
        if path_lower is not None:
            self.path_lower = path_lower
        if path_display is not None:
            self.path_display = path_display
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id

    @property
    def name(self):
        """
        The last component of the path (including extension). This never
        contains a slash.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def path_lower(self):
        """
        The lowercased full path in the user's Dropbox. This always starts with
        a slash. This field will be null if the file or folder is not mounted.

        :rtype: str
        """
        if self._path_lower_present:
            return self._path_lower_value
        else:
            return None

    @path_lower.setter
    def path_lower(self, val):
        if val is None:
            del self.path_lower
            return
        val = self._path_lower_validator.validate(val)
        self._path_lower_value = val
        self._path_lower_present = True

    @path_lower.deleter
    def path_lower(self):
        self._path_lower_value = None
        self._path_lower_present = False

    @property
    def path_display(self):
        """
        The cased path to be used for display purposes only. In rare instances
        the casing will not correctly match the user's filesystem, but this
        behavior will match the path provided in the Core API v1. Changes to the
        casing of paths won't be returned by list_folder/continue. This field
        will be null if the file or folder is not mounted.

        :rtype: str
        """
        if self._path_display_present:
            return self._path_display_value
        else:
            return None

    @path_display.setter
    def path_display(self, val):
        if val is None:
            del self.path_display
            return
        val = self._path_display_validator.validate(val)
        self._path_display_value = val
        self._path_display_present = True

    @path_display.deleter
    def path_display(self):
        self._path_display_value = None
        self._path_display_present = False

    @property
    def parent_shared_folder_id(self):
        """
        Deprecated. Please use ``FileSharingInfo.parent_shared_folder_id`` or
        ``FolderSharingInfo.parent_shared_folder_id`` instead.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            return None

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        if val is None:
            del self.parent_shared_folder_id
            return
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    def __repr__(self):
        return 'Metadata(name={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r})'.format(
            self._name_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
        )

Metadata_validator = bv.StructTree(Metadata)

class DeletedMetadata(Metadata):
    """
    Indicates that there used to be a file or folder at this path, but it no
    longer exists.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None):
        super(DeletedMetadata, self).__init__(name,
                                              path_lower,
                                              path_display,
                                              parent_shared_folder_id)

    def __repr__(self):
        return 'DeletedMetadata(name={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r})'.format(
            self._name_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
        )

DeletedMetadata_validator = bv.Struct(DeletedMetadata)

class Dimensions(object):
    """
    Dimensions for a photo or video.

    :ivar height: Height of the photo/video.
    :ivar width: Width of the photo/video.
    """

    __slots__ = [
        '_height_value',
        '_height_present',
        '_width_value',
        '_width_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 height=None,
                 width=None):
        self._height_value = None
        self._height_present = False
        self._width_value = None
        self._width_present = False
        if height is not None:
            self.height = height
        if width is not None:
            self.width = width

    @property
    def height(self):
        """
        Height of the photo/video.

        :rtype: long
        """
        if self._height_present:
            return self._height_value
        else:
            raise AttributeError("missing required field 'height'")

    @height.setter
    def height(self, val):
        val = self._height_validator.validate(val)
        self._height_value = val
        self._height_present = True

    @height.deleter
    def height(self):
        self._height_value = None
        self._height_present = False

    @property
    def width(self):
        """
        Width of the photo/video.

        :rtype: long
        """
        if self._width_present:
            return self._width_value
        else:
            raise AttributeError("missing required field 'width'")

    @width.setter
    def width(self, val):
        val = self._width_validator.validate(val)
        self._width_value = val
        self._width_present = True

    @width.deleter
    def width(self):
        self._width_value = None
        self._width_present = False

    def __repr__(self):
        return 'Dimensions(height={!r}, width={!r})'.format(
            self._height_value,
            self._width_value,
        )

Dimensions_validator = bv.Struct(Dimensions)

class DownloadArg(object):
    """
    :ivar path: The path of the file to download.
    :ivar rev: Deprecated. Please specify revision in ``path`` instead
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path of the file to download.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        Deprecated. Please specify revision in ``path`` instead

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            return None

    @rev.setter
    def rev(self, val):
        if val is None:
            del self.rev
            return
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'DownloadArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

DownloadArg_validator = bv.Struct(DownloadArg)

class DownloadError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: DownloadError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'DownloadError(%r, %r)' % (self._tag, self._value)

DownloadError_validator = bv.Union(DownloadError)

class FileMetadata(Metadata):
    """
    :ivar id: A unique identifier for the file.
    :ivar client_modified: For files, this is the modification time set by the
        desktop client when the file was added to Dropbox. Since this time is
        not verified (the Dropbox server stores whatever the desktop client
        sends up), this should only be used for display purposes (such as
        sorting) and not, for example, to determine if a file has changed or
        not.
    :ivar server_modified: The last time the file was modified on Dropbox.
    :ivar rev: A unique identifier for the current revision of a file. This
        field is the same rev as elsewhere in the API and can be used to detect
        changes and avoid conflicts.
    :ivar size: The file size in bytes.
    :ivar media_info: Additional information if the file is a photo or video.
    :ivar sharing_info: Set if this file is contained in a shared folder.
    :ivar property_groups: Additional information if the file has custom
        properties with the property template specified.
    :ivar has_explicit_shared_members: This flag will only be present if
        include_has_explicit_shared_members  is true in list_folder or
        get_metadata. If this  flag is present, it will be true if this file has
        any explicit shared  members. This is different from sharing_info in
        that this could be true  in the case where a file has explicit members
        but is not contained within  a shared folder.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_client_modified_value',
        '_client_modified_present',
        '_server_modified_value',
        '_server_modified_present',
        '_rev_value',
        '_rev_present',
        '_size_value',
        '_size_present',
        '_media_info_value',
        '_media_info_present',
        '_sharing_info_value',
        '_sharing_info_present',
        '_property_groups_value',
        '_property_groups_present',
        '_has_explicit_shared_members_value',
        '_has_explicit_shared_members_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 id=None,
                 client_modified=None,
                 server_modified=None,
                 rev=None,
                 size=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None,
                 media_info=None,
                 sharing_info=None,
                 property_groups=None,
                 has_explicit_shared_members=None):
        super(FileMetadata, self).__init__(name,
                                           path_lower,
                                           path_display,
                                           parent_shared_folder_id)
        self._id_value = None
        self._id_present = False
        self._client_modified_value = None
        self._client_modified_present = False
        self._server_modified_value = None
        self._server_modified_present = False
        self._rev_value = None
        self._rev_present = False
        self._size_value = None
        self._size_present = False
        self._media_info_value = None
        self._media_info_present = False
        self._sharing_info_value = None
        self._sharing_info_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        self._has_explicit_shared_members_value = None
        self._has_explicit_shared_members_present = False
        if id is not None:
            self.id = id
        if client_modified is not None:
            self.client_modified = client_modified
        if server_modified is not None:
            self.server_modified = server_modified
        if rev is not None:
            self.rev = rev
        if size is not None:
            self.size = size
        if media_info is not None:
            self.media_info = media_info
        if sharing_info is not None:
            self.sharing_info = sharing_info
        if property_groups is not None:
            self.property_groups = property_groups
        if has_explicit_shared_members is not None:
            self.has_explicit_shared_members = has_explicit_shared_members

    @property
    def id(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def client_modified(self):
        """
        For files, this is the modification time set by the desktop client when
        the file was added to Dropbox. Since this time is not verified (the
        Dropbox server stores whatever the desktop client sends up), this should
        only be used for display purposes (such as sorting) and not, for
        example, to determine if a file has changed or not.

        :rtype: datetime.datetime
        """
        if self._client_modified_present:
            return self._client_modified_value
        else:
            raise AttributeError("missing required field 'client_modified'")

    @client_modified.setter
    def client_modified(self, val):
        val = self._client_modified_validator.validate(val)
        self._client_modified_value = val
        self._client_modified_present = True

    @client_modified.deleter
    def client_modified(self):
        self._client_modified_value = None
        self._client_modified_present = False

    @property
    def server_modified(self):
        """
        The last time the file was modified on Dropbox.

        :rtype: datetime.datetime
        """
        if self._server_modified_present:
            return self._server_modified_value
        else:
            raise AttributeError("missing required field 'server_modified'")

    @server_modified.setter
    def server_modified(self, val):
        val = self._server_modified_validator.validate(val)
        self._server_modified_value = val
        self._server_modified_present = True

    @server_modified.deleter
    def server_modified(self):
        self._server_modified_value = None
        self._server_modified_present = False

    @property
    def rev(self):
        """
        A unique identifier for the current revision of a file. This field is
        the same rev as elsewhere in the API and can be used to detect changes
        and avoid conflicts.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            raise AttributeError("missing required field 'rev'")

    @rev.setter
    def rev(self, val):
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    @property
    def size(self):
        """
        The file size in bytes.

        :rtype: long
        """
        if self._size_present:
            return self._size_value
        else:
            raise AttributeError("missing required field 'size'")

    @size.setter
    def size(self, val):
        val = self._size_validator.validate(val)
        self._size_value = val
        self._size_present = True

    @size.deleter
    def size(self):
        self._size_value = None
        self._size_present = False

    @property
    def media_info(self):
        """
        Additional information if the file is a photo or video.

        :rtype: MediaInfo
        """
        if self._media_info_present:
            return self._media_info_value
        else:
            return None

    @media_info.setter
    def media_info(self, val):
        if val is None:
            del self.media_info
            return
        self._media_info_validator.validate_type_only(val)
        self._media_info_value = val
        self._media_info_present = True

    @media_info.deleter
    def media_info(self):
        self._media_info_value = None
        self._media_info_present = False

    @property
    def sharing_info(self):
        """
        Set if this file is contained in a shared folder.

        :rtype: FileSharingInfo
        """
        if self._sharing_info_present:
            return self._sharing_info_value
        else:
            return None

    @sharing_info.setter
    def sharing_info(self, val):
        if val is None:
            del self.sharing_info
            return
        self._sharing_info_validator.validate_type_only(val)
        self._sharing_info_value = val
        self._sharing_info_present = True

    @sharing_info.deleter
    def sharing_info(self):
        self._sharing_info_value = None
        self._sharing_info_present = False

    @property
    def property_groups(self):
        """
        Additional information if the file has custom properties with the
        property template specified.

        :rtype: list of [properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    @property
    def has_explicit_shared_members(self):
        """
        This flag will only be present if include_has_explicit_shared_members
        is true in list_folder or get_metadata. If this  flag is present, it
        will be true if this file has any explicit shared  members. This is
        different from sharing_info in that this could be true  in the case
        where a file has explicit members but is not contained within  a shared
        folder.

        :rtype: bool
        """
        if self._has_explicit_shared_members_present:
            return self._has_explicit_shared_members_value
        else:
            return None

    @has_explicit_shared_members.setter
    def has_explicit_shared_members(self, val):
        if val is None:
            del self.has_explicit_shared_members
            return
        val = self._has_explicit_shared_members_validator.validate(val)
        self._has_explicit_shared_members_value = val
        self._has_explicit_shared_members_present = True

    @has_explicit_shared_members.deleter
    def has_explicit_shared_members(self):
        self._has_explicit_shared_members_value = None
        self._has_explicit_shared_members_present = False

    def __repr__(self):
        return 'FileMetadata(name={!r}, id={!r}, client_modified={!r}, server_modified={!r}, rev={!r}, size={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r}, media_info={!r}, sharing_info={!r}, property_groups={!r}, has_explicit_shared_members={!r})'.format(
            self._name_value,
            self._id_value,
            self._client_modified_value,
            self._server_modified_value,
            self._rev_value,
            self._size_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
            self._media_info_value,
            self._sharing_info_value,
            self._property_groups_value,
            self._has_explicit_shared_members_value,
        )

FileMetadata_validator = bv.Struct(FileMetadata)

class SharingInfo(object):
    """
    Sharing info for a file or folder.

    :ivar read_only: True if the file or folder is inside a read-only shared
        folder.
    """

    __slots__ = [
        '_read_only_value',
        '_read_only_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None):
        self._read_only_value = None
        self._read_only_present = False
        if read_only is not None:
            self.read_only = read_only

    @property
    def read_only(self):
        """
        True if the file or folder is inside a read-only shared folder.

        :rtype: bool
        """
        if self._read_only_present:
            return self._read_only_value
        else:
            raise AttributeError("missing required field 'read_only'")

    @read_only.setter
    def read_only(self, val):
        val = self._read_only_validator.validate(val)
        self._read_only_value = val
        self._read_only_present = True

    @read_only.deleter
    def read_only(self):
        self._read_only_value = None
        self._read_only_present = False

    def __repr__(self):
        return 'SharingInfo(read_only={!r})'.format(
            self._read_only_value,
        )

SharingInfo_validator = bv.Struct(SharingInfo)

class FileSharingInfo(SharingInfo):
    """
    Sharing info for a file which is contained by a shared folder.

    :ivar parent_shared_folder_id: ID of shared folder that holds this file.
    :ivar modified_by: The last user who modified the file. This field will be
        null if the user's account has been deleted.
    """

    __slots__ = [
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
        '_modified_by_value',
        '_modified_by_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None,
                 parent_shared_folder_id=None,
                 modified_by=None):
        super(FileSharingInfo, self).__init__(read_only)
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        self._modified_by_value = None
        self._modified_by_present = False
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id
        if modified_by is not None:
            self.modified_by = modified_by

    @property
    def parent_shared_folder_id(self):
        """
        ID of shared folder that holds this file.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            raise AttributeError("missing required field 'parent_shared_folder_id'")

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    @property
    def modified_by(self):
        """
        The last user who modified the file. This field will be null if the
        user's account has been deleted.

        :rtype: str
        """
        if self._modified_by_present:
            return self._modified_by_value
        else:
            return None

    @modified_by.setter
    def modified_by(self, val):
        if val is None:
            del self.modified_by
            return
        val = self._modified_by_validator.validate(val)
        self._modified_by_value = val
        self._modified_by_present = True

    @modified_by.deleter
    def modified_by(self):
        self._modified_by_value = None
        self._modified_by_present = False

    def __repr__(self):
        return 'FileSharingInfo(read_only={!r}, parent_shared_folder_id={!r}, modified_by={!r})'.format(
            self._read_only_value,
            self._parent_shared_folder_id_value,
            self._modified_by_value,
        )

FileSharingInfo_validator = bv.Struct(FileSharingInfo)

class FolderMetadata(Metadata):
    """
    :ivar id: A unique identifier for the folder.
    :ivar shared_folder_id: Deprecated. Please use ``sharing_info`` instead.
    :ivar sharing_info: Set if the folder is contained in a shared folder or is
        a shared folder mount point.
    :ivar property_groups: Additional information if the file has custom
        properties with the property template specified.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
        '_sharing_info_value',
        '_sharing_info_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 name=None,
                 id=None,
                 path_lower=None,
                 path_display=None,
                 parent_shared_folder_id=None,
                 shared_folder_id=None,
                 sharing_info=None,
                 property_groups=None):
        super(FolderMetadata, self).__init__(name,
                                             path_lower,
                                             path_display,
                                             parent_shared_folder_id)
        self._id_value = None
        self._id_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        self._sharing_info_value = None
        self._sharing_info_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if id is not None:
            self.id = id
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id
        if sharing_info is not None:
            self.sharing_info = sharing_info
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def id(self):
        """
        A unique identifier for the folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def shared_folder_id(self):
        """
        Deprecated. Please use ``sharing_info`` instead.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            return None

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        if val is None:
            del self.shared_folder_id
            return
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    @property
    def sharing_info(self):
        """
        Set if the folder is contained in a shared folder or is a shared folder
        mount point.

        :rtype: FolderSharingInfo
        """
        if self._sharing_info_present:
            return self._sharing_info_value
        else:
            return None

    @sharing_info.setter
    def sharing_info(self, val):
        if val is None:
            del self.sharing_info
            return
        self._sharing_info_validator.validate_type_only(val)
        self._sharing_info_value = val
        self._sharing_info_present = True

    @sharing_info.deleter
    def sharing_info(self):
        self._sharing_info_value = None
        self._sharing_info_present = False

    @property
    def property_groups(self):
        """
        Additional information if the file has custom properties with the
        property template specified.

        :rtype: list of [properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            return None

    @property_groups.setter
    def property_groups(self, val):
        if val is None:
            del self.property_groups
            return
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'FolderMetadata(name={!r}, id={!r}, path_lower={!r}, path_display={!r}, parent_shared_folder_id={!r}, shared_folder_id={!r}, sharing_info={!r}, property_groups={!r})'.format(
            self._name_value,
            self._id_value,
            self._path_lower_value,
            self._path_display_value,
            self._parent_shared_folder_id_value,
            self._shared_folder_id_value,
            self._sharing_info_value,
            self._property_groups_value,
        )

FolderMetadata_validator = bv.Struct(FolderMetadata)

class FolderSharingInfo(SharingInfo):
    """
    Sharing info for a folder which is contained in a shared folder or is a
    shared folder mount point.

    :ivar parent_shared_folder_id: Set if the folder is contained by a shared
        folder.
    :ivar shared_folder_id: If this folder is a shared folder mount point, the
        ID of the shared folder mounted at this location.
    """

    __slots__ = [
        '_parent_shared_folder_id_value',
        '_parent_shared_folder_id_present',
        '_shared_folder_id_value',
        '_shared_folder_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 read_only=None,
                 parent_shared_folder_id=None,
                 shared_folder_id=None):
        super(FolderSharingInfo, self).__init__(read_only)
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False
        if parent_shared_folder_id is not None:
            self.parent_shared_folder_id = parent_shared_folder_id
        if shared_folder_id is not None:
            self.shared_folder_id = shared_folder_id

    @property
    def parent_shared_folder_id(self):
        """
        Set if the folder is contained by a shared folder.

        :rtype: str
        """
        if self._parent_shared_folder_id_present:
            return self._parent_shared_folder_id_value
        else:
            return None

    @parent_shared_folder_id.setter
    def parent_shared_folder_id(self, val):
        if val is None:
            del self.parent_shared_folder_id
            return
        val = self._parent_shared_folder_id_validator.validate(val)
        self._parent_shared_folder_id_value = val
        self._parent_shared_folder_id_present = True

    @parent_shared_folder_id.deleter
    def parent_shared_folder_id(self):
        self._parent_shared_folder_id_value = None
        self._parent_shared_folder_id_present = False

    @property
    def shared_folder_id(self):
        """
        If this folder is a shared folder mount point, the ID of the shared
        folder mounted at this location.

        :rtype: str
        """
        if self._shared_folder_id_present:
            return self._shared_folder_id_value
        else:
            return None

    @shared_folder_id.setter
    def shared_folder_id(self, val):
        if val is None:
            del self.shared_folder_id
            return
        val = self._shared_folder_id_validator.validate(val)
        self._shared_folder_id_value = val
        self._shared_folder_id_present = True

    @shared_folder_id.deleter
    def shared_folder_id(self):
        self._shared_folder_id_value = None
        self._shared_folder_id_present = False

    def __repr__(self):
        return 'FolderSharingInfo(read_only={!r}, parent_shared_folder_id={!r}, shared_folder_id={!r})'.format(
            self._read_only_value,
            self._parent_shared_folder_id_value,
            self._shared_folder_id_value,
        )

FolderSharingInfo_validator = bv.Struct(FolderSharingInfo)

class GetCopyReferenceArg(object):
    """
    :ivar path: The path to the file or folder you want to get a copy reference
        to.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        The path to the file or folder you want to get a copy reference to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetCopyReferenceArg(path={!r})'.format(
            self._path_value,
        )

GetCopyReferenceArg_validator = bv.Struct(GetCopyReferenceArg)

class GetCopyReferenceError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetCopyReferenceError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetCopyReferenceError(%r, %r)' % (self._tag, self._value)

GetCopyReferenceError_validator = bv.Union(GetCopyReferenceError)

class GetCopyReferenceResult(object):
    """
    :ivar metadata: Metadata of the file or folder.
    :ivar copy_reference: A copy reference to the file or folder.
    :ivar expires: The expiration date of the copy reference. This value is
        currently set to be far enough in the future so that expiration is
        effectively not an issue.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
        '_copy_reference_value',
        '_copy_reference_present',
        '_expires_value',
        '_expires_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None,
                 copy_reference=None,
                 expires=None):
        self._metadata_value = None
        self._metadata_present = False
        self._copy_reference_value = None
        self._copy_reference_present = False
        self._expires_value = None
        self._expires_present = False
        if metadata is not None:
            self.metadata = metadata
        if copy_reference is not None:
            self.copy_reference = copy_reference
        if expires is not None:
            self.expires = expires

    @property
    def metadata(self):
        """
        Metadata of the file or folder.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    @property
    def copy_reference(self):
        """
        A copy reference to the file or folder.

        :rtype: str
        """
        if self._copy_reference_present:
            return self._copy_reference_value
        else:
            raise AttributeError("missing required field 'copy_reference'")

    @copy_reference.setter
    def copy_reference(self, val):
        val = self._copy_reference_validator.validate(val)
        self._copy_reference_value = val
        self._copy_reference_present = True

    @copy_reference.deleter
    def copy_reference(self):
        self._copy_reference_value = None
        self._copy_reference_present = False

    @property
    def expires(self):
        """
        The expiration date of the copy reference. This value is currently set
        to be far enough in the future so that expiration is effectively not an
        issue.

        :rtype: datetime.datetime
        """
        if self._expires_present:
            return self._expires_value
        else:
            raise AttributeError("missing required field 'expires'")

    @expires.setter
    def expires(self, val):
        val = self._expires_validator.validate(val)
        self._expires_value = val
        self._expires_present = True

    @expires.deleter
    def expires(self):
        self._expires_value = None
        self._expires_present = False

    def __repr__(self):
        return 'GetCopyReferenceResult(metadata={!r}, copy_reference={!r}, expires={!r})'.format(
            self._metadata_value,
            self._copy_reference_value,
            self._expires_value,
        )

GetCopyReferenceResult_validator = bv.Struct(GetCopyReferenceResult)

class GetTemporaryLinkArg(object):
    """
    :ivar path: The path to the file you want a temporary link to.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None):
        self._path_value = None
        self._path_present = False
        if path is not None:
            self.path = path

    @property
    def path(self):
        """
        The path to the file you want a temporary link to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'GetTemporaryLinkArg(path={!r})'.format(
            self._path_value,
        )

GetTemporaryLinkArg_validator = bv.Struct(GetTemporaryLinkArg)

class GetTemporaryLinkError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: GetTemporaryLinkError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'GetTemporaryLinkError(%r, %r)' % (self._tag, self._value)

GetTemporaryLinkError_validator = bv.Union(GetTemporaryLinkError)

class GetTemporaryLinkResult(object):
    """
    :ivar metadata: Metadata of the file.
    :ivar link: The temporary link which can be used to stream content the file.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
        '_link_value',
        '_link_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None,
                 link=None):
        self._metadata_value = None
        self._metadata_present = False
        self._link_value = None
        self._link_present = False
        if metadata is not None:
            self.metadata = metadata
        if link is not None:
            self.link = link

    @property
    def metadata(self):
        """
        Metadata of the file.

        :rtype: FileMetadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    @property
    def link(self):
        """
        The temporary link which can be used to stream content the file.

        :rtype: str
        """
        if self._link_present:
            return self._link_value
        else:
            raise AttributeError("missing required field 'link'")

    @link.setter
    def link(self, val):
        val = self._link_validator.validate(val)
        self._link_value = val
        self._link_present = True

    @link.deleter
    def link(self):
        self._link_value = None
        self._link_present = False

    def __repr__(self):
        return 'GetTemporaryLinkResult(metadata={!r}, link={!r})'.format(
            self._metadata_value,
            self._link_value,
        )

GetTemporaryLinkResult_validator = bv.Struct(GetTemporaryLinkResult)

class GpsCoordinates(object):
    """
    GPS coordinates for a photo or video.

    :ivar latitude: Latitude of the GPS coordinates.
    :ivar longitude: Longitude of the GPS coordinates.
    """

    __slots__ = [
        '_latitude_value',
        '_latitude_present',
        '_longitude_value',
        '_longitude_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 latitude=None,
                 longitude=None):
        self._latitude_value = None
        self._latitude_present = False
        self._longitude_value = None
        self._longitude_present = False
        if latitude is not None:
            self.latitude = latitude
        if longitude is not None:
            self.longitude = longitude

    @property
    def latitude(self):
        """
        Latitude of the GPS coordinates.

        :rtype: float
        """
        if self._latitude_present:
            return self._latitude_value
        else:
            raise AttributeError("missing required field 'latitude'")

    @latitude.setter
    def latitude(self, val):
        val = self._latitude_validator.validate(val)
        self._latitude_value = val
        self._latitude_present = True

    @latitude.deleter
    def latitude(self):
        self._latitude_value = None
        self._latitude_present = False

    @property
    def longitude(self):
        """
        Longitude of the GPS coordinates.

        :rtype: float
        """
        if self._longitude_present:
            return self._longitude_value
        else:
            raise AttributeError("missing required field 'longitude'")

    @longitude.setter
    def longitude(self, val):
        val = self._longitude_validator.validate(val)
        self._longitude_value = val
        self._longitude_present = True

    @longitude.deleter
    def longitude(self):
        self._longitude_value = None
        self._longitude_present = False

    def __repr__(self):
        return 'GpsCoordinates(latitude={!r}, longitude={!r})'.format(
            self._latitude_value,
            self._longitude_value,
        )

GpsCoordinates_validator = bv.Struct(GpsCoordinates)

class ListFolderArg(object):
    """
    :ivar path: The path to the folder you want to see the contents of.
    :ivar recursive: If true, the list folder operation will be applied
        recursively to all subfolders and the response will contain contents of
        all subfolders.
    :ivar include_media_info: If true, ``FileMetadata.media_info`` is set for
        photo and video.
    :ivar include_deleted: If true, the results will include entries for files
        and folders that used to exist but were deleted.
    :ivar include_has_explicit_shared_members: If true, the results will include
        a flag for each file indicating whether or not  that file has any
        explicit members.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_recursive_value',
        '_recursive_present',
        '_include_media_info_value',
        '_include_media_info_present',
        '_include_deleted_value',
        '_include_deleted_present',
        '_include_has_explicit_shared_members_value',
        '_include_has_explicit_shared_members_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 recursive=None,
                 include_media_info=None,
                 include_deleted=None,
                 include_has_explicit_shared_members=None):
        self._path_value = None
        self._path_present = False
        self._recursive_value = None
        self._recursive_present = False
        self._include_media_info_value = None
        self._include_media_info_present = False
        self._include_deleted_value = None
        self._include_deleted_present = False
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False
        if path is not None:
            self.path = path
        if recursive is not None:
            self.recursive = recursive
        if include_media_info is not None:
            self.include_media_info = include_media_info
        if include_deleted is not None:
            self.include_deleted = include_deleted
        if include_has_explicit_shared_members is not None:
            self.include_has_explicit_shared_members = include_has_explicit_shared_members

    @property
    def path(self):
        """
        The path to the folder you want to see the contents of.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def recursive(self):
        """
        If true, the list folder operation will be applied recursively to all
        subfolders and the response will contain contents of all subfolders.

        :rtype: bool
        """
        if self._recursive_present:
            return self._recursive_value
        else:
            return False

    @recursive.setter
    def recursive(self, val):
        val = self._recursive_validator.validate(val)
        self._recursive_value = val
        self._recursive_present = True

    @recursive.deleter
    def recursive(self):
        self._recursive_value = None
        self._recursive_present = False

    @property
    def include_media_info(self):
        """
        If true, ``FileMetadata.media_info`` is set for photo and video.

        :rtype: bool
        """
        if self._include_media_info_present:
            return self._include_media_info_value
        else:
            return False

    @include_media_info.setter
    def include_media_info(self, val):
        val = self._include_media_info_validator.validate(val)
        self._include_media_info_value = val
        self._include_media_info_present = True

    @include_media_info.deleter
    def include_media_info(self):
        self._include_media_info_value = None
        self._include_media_info_present = False

    @property
    def include_deleted(self):
        """
        If true, the results will include entries for files and folders that
        used to exist but were deleted.

        :rtype: bool
        """
        if self._include_deleted_present:
            return self._include_deleted_value
        else:
            return False

    @include_deleted.setter
    def include_deleted(self, val):
        val = self._include_deleted_validator.validate(val)
        self._include_deleted_value = val
        self._include_deleted_present = True

    @include_deleted.deleter
    def include_deleted(self):
        self._include_deleted_value = None
        self._include_deleted_present = False

    @property
    def include_has_explicit_shared_members(self):
        """
        If true, the results will include a flag for each file indicating
        whether or not  that file has any explicit members.

        :rtype: bool
        """
        if self._include_has_explicit_shared_members_present:
            return self._include_has_explicit_shared_members_value
        else:
            return False

    @include_has_explicit_shared_members.setter
    def include_has_explicit_shared_members(self, val):
        val = self._include_has_explicit_shared_members_validator.validate(val)
        self._include_has_explicit_shared_members_value = val
        self._include_has_explicit_shared_members_present = True

    @include_has_explicit_shared_members.deleter
    def include_has_explicit_shared_members(self):
        self._include_has_explicit_shared_members_value = None
        self._include_has_explicit_shared_members_present = False

    def __repr__(self):
        return 'ListFolderArg(path={!r}, recursive={!r}, include_media_info={!r}, include_deleted={!r}, include_has_explicit_shared_members={!r})'.format(
            self._path_value,
            self._recursive_value,
            self._include_media_info_value,
            self._include_deleted_value,
            self._include_has_explicit_shared_members_value,
        )

ListFolderArg_validator = bv.Struct(ListFolderArg)

class ListFolderContinueArg(object):
    """
    :ivar cursor: The cursor returned by your last call to list_folder or
        list_folder/continue.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor returned by your last call to list_folder or
        list_folder/continue.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

ListFolderContinueArg_validator = bv.Struct(ListFolderContinueArg)

class ListFolderContinueError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        list_folder to obtain a new cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListFolderContinueError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderContinueError(%r, %r)' % (self._tag, self._value)

ListFolderContinueError_validator = bv.Union(ListFolderContinueError)

class ListFolderError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListFolderError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListFolderError(%r, %r)' % (self._tag, self._value)

ListFolderError_validator = bv.Union(ListFolderError)

class ListFolderGetLatestCursorResult(object):
    """
    :ivar cursor: Pass the cursor into list_folder/continue to see what's
        changed in the folder since your previous query.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        Pass the cursor into list_folder/continue to see what's changed in the
        folder since your previous query.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'ListFolderGetLatestCursorResult(cursor={!r})'.format(
            self._cursor_value,
        )

ListFolderGetLatestCursorResult_validator = bv.Struct(ListFolderGetLatestCursorResult)

class ListFolderLongpollArg(object):
    """
    :ivar cursor: A cursor as returned by list_folder or list_folder/continue.
        Cursors retrieved by setting ``ListFolderArg.include_media_info`` to
        ``True`` are not supported.
    :ivar timeout: A timeout in seconds. The request will block for at most this
        length of time, plus up to 90 seconds of random jitter added to avoid
        the thundering herd problem. Care should be taken when using this
        parameter, as some network infrastructure does not support long
        timeouts.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_timeout_value',
        '_timeout_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 timeout=None):
        self._cursor_value = None
        self._cursor_present = False
        self._timeout_value = None
        self._timeout_present = False
        if cursor is not None:
            self.cursor = cursor
        if timeout is not None:
            self.timeout = timeout

    @property
    def cursor(self):
        """
        A cursor as returned by list_folder or list_folder/continue. Cursors
        retrieved by setting ``ListFolderArg.include_media_info`` to ``True``
        are not supported.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def timeout(self):
        """
        A timeout in seconds. The request will block for at most this length of
        time, plus up to 90 seconds of random jitter added to avoid the
        thundering herd problem. Care should be taken when using this parameter,
        as some network infrastructure does not support long timeouts.

        :rtype: long
        """
        if self._timeout_present:
            return self._timeout_value
        else:
            return 30

    @timeout.setter
    def timeout(self, val):
        val = self._timeout_validator.validate(val)
        self._timeout_value = val
        self._timeout_present = True

    @timeout.deleter
    def timeout(self):
        self._timeout_value = None
        self._timeout_present = False

    def __repr__(self):
        return 'ListFolderLongpollArg(cursor={!r}, timeout={!r})'.format(
            self._cursor_value,
            self._timeout_value,
        )

ListFolderLongpollArg_validator = bv.Struct(ListFolderLongpollArg)

class ListFolderLongpollError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar reset: Indicates that the cursor has been invalidated. Call
        list_folder to obtain a new cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ListFolderLongpollError(%r, %r)' % (self._tag, self._value)

ListFolderLongpollError_validator = bv.Union(ListFolderLongpollError)

class ListFolderLongpollResult(object):
    """
    :ivar changes: Indicates whether new changes are available. If true, call
        list_folder/continue to retrieve the changes.
    :ivar backoff: If present, backoff for at least this many seconds before
        calling list_folder/longpoll again.
    """

    __slots__ = [
        '_changes_value',
        '_changes_present',
        '_backoff_value',
        '_backoff_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 changes=None,
                 backoff=None):
        self._changes_value = None
        self._changes_present = False
        self._backoff_value = None
        self._backoff_present = False
        if changes is not None:
            self.changes = changes
        if backoff is not None:
            self.backoff = backoff

    @property
    def changes(self):
        """
        Indicates whether new changes are available. If true, call
        list_folder/continue to retrieve the changes.

        :rtype: bool
        """
        if self._changes_present:
            return self._changes_value
        else:
            raise AttributeError("missing required field 'changes'")

    @changes.setter
    def changes(self, val):
        val = self._changes_validator.validate(val)
        self._changes_value = val
        self._changes_present = True

    @changes.deleter
    def changes(self):
        self._changes_value = None
        self._changes_present = False

    @property
    def backoff(self):
        """
        If present, backoff for at least this many seconds before calling
        list_folder/longpoll again.

        :rtype: long
        """
        if self._backoff_present:
            return self._backoff_value
        else:
            return None

    @backoff.setter
    def backoff(self, val):
        if val is None:
            del self.backoff
            return
        val = self._backoff_validator.validate(val)
        self._backoff_value = val
        self._backoff_present = True

    @backoff.deleter
    def backoff(self):
        self._backoff_value = None
        self._backoff_present = False

    def __repr__(self):
        return 'ListFolderLongpollResult(changes={!r}, backoff={!r})'.format(
            self._changes_value,
            self._backoff_value,
        )

ListFolderLongpollResult_validator = bv.Struct(ListFolderLongpollResult)

class ListFolderResult(object):
    """
    :ivar entries: The files and (direct) subfolders in the folder.
    :ivar cursor: Pass the cursor into list_folder/continue to see what's
        changed in the folder since your previous query.
    :ivar has_more: If true, then there are more entries available. Pass the
        cursor to list_folder/continue to retrieve the rest.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None,
                 cursor=None,
                 has_more=None):
        self._entries_value = None
        self._entries_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if entries is not None:
            self.entries = entries
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def entries(self):
        """
        The files and (direct) subfolders in the folder.

        :rtype: list of [Metadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into list_folder/continue to see what's changed in the
        folder since your previous query.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        If true, then there are more entries available. Pass the cursor to
        list_folder/continue to retrieve the rest.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def __repr__(self):
        return 'ListFolderResult(entries={!r}, cursor={!r}, has_more={!r})'.format(
            self._entries_value,
            self._cursor_value,
            self._has_more_value,
        )

ListFolderResult_validator = bv.Struct(ListFolderResult)

class ListRevisionsArg(object):
    """
    :ivar path: The path to the file you want to see the revisions of.
    :ivar limit: The maximum number of revision entries returned.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_limit_value',
        '_limit_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 limit=None):
        self._path_value = None
        self._path_present = False
        self._limit_value = None
        self._limit_present = False
        if path is not None:
            self.path = path
        if limit is not None:
            self.limit = limit

    @property
    def path(self):
        """
        The path to the file you want to see the revisions of.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def limit(self):
        """
        The maximum number of revision entries returned.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 10

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    def __repr__(self):
        return 'ListRevisionsArg(path={!r}, limit={!r})'.format(
            self._path_value,
            self._limit_value,
        )

ListRevisionsArg_validator = bv.Struct(ListRevisionsArg)

class ListRevisionsError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ListRevisionsError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ListRevisionsError(%r, %r)' % (self._tag, self._value)

ListRevisionsError_validator = bv.Union(ListRevisionsError)

class ListRevisionsResult(object):
    """
    :ivar is_deleted: If the file is deleted.
    :ivar entries: The revisions for the file. Only non-delete revisions will
        show up here.
    """

    __slots__ = [
        '_is_deleted_value',
        '_is_deleted_present',
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_deleted=None,
                 entries=None):
        self._is_deleted_value = None
        self._is_deleted_present = False
        self._entries_value = None
        self._entries_present = False
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if entries is not None:
            self.entries = entries

    @property
    def is_deleted(self):
        """
        If the file is deleted.

        :rtype: bool
        """
        if self._is_deleted_present:
            return self._is_deleted_value
        else:
            raise AttributeError("missing required field 'is_deleted'")

    @is_deleted.setter
    def is_deleted(self, val):
        val = self._is_deleted_validator.validate(val)
        self._is_deleted_value = val
        self._is_deleted_present = True

    @is_deleted.deleter
    def is_deleted(self):
        self._is_deleted_value = None
        self._is_deleted_present = False

    @property
    def entries(self):
        """
        The revisions for the file. Only non-delete revisions will show up here.

        :rtype: list of [FileMetadata]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'ListRevisionsResult(is_deleted={!r}, entries={!r})'.format(
            self._is_deleted_value,
            self._entries_value,
        )

ListRevisionsResult_validator = bv.Struct(ListRevisionsResult)

class LookUpPropertiesError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar property_group_not_found: This property group does not exist for this
        file.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    property_group_not_found = None

    def is_property_group_not_found(self):
        """
        Check if the union tag is ``property_group_not_found``.

        :rtype: bool
        """
        return self._tag == 'property_group_not_found'

    def __repr__(self):
        return 'LookUpPropertiesError(%r, %r)' % (self._tag, self._value)

LookUpPropertiesError_validator = bv.Union(LookUpPropertiesError)

class LookupError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: There is nothing at the given path.
    :ivar not_file: We were expecting a file, but the given path refers to
        something that isn't a file.
    :ivar not_folder: We were expecting a folder, but the given path refers to
        something that isn't a folder.
    :ivar restricted_content: The file cannot be transferred because the content
        is restricted.  For example, sometimes there are legal restrictions due
        to copyright claims.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    not_file = None
    # Attribute is overwritten below the class definition
    not_folder = None
    # Attribute is overwritten below the class definition
    restricted_content = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def malformed_path(cls, val):
        """
        Create an instance of this class set to the ``malformed_path`` tag with
        value ``val``.

        :param Optional[str] val:
        :rtype: LookupError
        """
        return cls('malformed_path', val)

    def is_malformed_path(self):
        """
        Check if the union tag is ``malformed_path``.

        :rtype: bool
        """
        return self._tag == 'malformed_path'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_not_file(self):
        """
        Check if the union tag is ``not_file``.

        :rtype: bool
        """
        return self._tag == 'not_file'

    def is_not_folder(self):
        """
        Check if the union tag is ``not_folder``.

        :rtype: bool
        """
        return self._tag == 'not_folder'

    def is_restricted_content(self):
        """
        Check if the union tag is ``restricted_content``.

        :rtype: bool
        """
        return self._tag == 'restricted_content'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_malformed_path(self):
        """
        Only call this if :meth:`is_malformed_path` is true.

        :rtype: Optional[str]
        """
        if not self.is_malformed_path():
            raise AttributeError("tag 'malformed_path' not set")
        return self._value

    def __repr__(self):
        return 'LookupError(%r, %r)' % (self._tag, self._value)

LookupError_validator = bv.Union(LookupError)

class MediaInfo(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar pending: Indicate the photo/video is still under processing and
        metadata is not available yet.
    :ivar MediaMetadata metadata: The metadata for the photo/video.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    pending = None

    @classmethod
    def metadata(cls, val):
        """
        Create an instance of this class set to the ``metadata`` tag with value
        ``val``.

        :param MediaMetadata val:
        :rtype: MediaInfo
        """
        return cls('metadata', val)

    def is_pending(self):
        """
        Check if the union tag is ``pending``.

        :rtype: bool
        """
        return self._tag == 'pending'

    def is_metadata(self):
        """
        Check if the union tag is ``metadata``.

        :rtype: bool
        """
        return self._tag == 'metadata'

    def get_metadata(self):
        """
        The metadata for the photo/video.

        Only call this if :meth:`is_metadata` is true.

        :rtype: MediaMetadata
        """
        if not self.is_metadata():
            raise AttributeError("tag 'metadata' not set")
        return self._value

    def __repr__(self):
        return 'MediaInfo(%r, %r)' % (self._tag, self._value)

MediaInfo_validator = bv.Union(MediaInfo)

class MediaMetadata(object):
    """
    Metadata for a photo or video.

    :ivar dimensions: Dimension of the photo/video.
    :ivar location: The GPS coordinate of the photo/video.
    :ivar time_taken: The timestamp when the photo/video is taken.
    """

    __slots__ = [
        '_dimensions_value',
        '_dimensions_present',
        '_location_value',
        '_location_present',
        '_time_taken_value',
        '_time_taken_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None):
        self._dimensions_value = None
        self._dimensions_present = False
        self._location_value = None
        self._location_present = False
        self._time_taken_value = None
        self._time_taken_present = False
        if dimensions is not None:
            self.dimensions = dimensions
        if location is not None:
            self.location = location
        if time_taken is not None:
            self.time_taken = time_taken

    @property
    def dimensions(self):
        """
        Dimension of the photo/video.

        :rtype: Dimensions
        """
        if self._dimensions_present:
            return self._dimensions_value
        else:
            return None

    @dimensions.setter
    def dimensions(self, val):
        if val is None:
            del self.dimensions
            return
        self._dimensions_validator.validate_type_only(val)
        self._dimensions_value = val
        self._dimensions_present = True

    @dimensions.deleter
    def dimensions(self):
        self._dimensions_value = None
        self._dimensions_present = False

    @property
    def location(self):
        """
        The GPS coordinate of the photo/video.

        :rtype: GpsCoordinates
        """
        if self._location_present:
            return self._location_value
        else:
            return None

    @location.setter
    def location(self, val):
        if val is None:
            del self.location
            return
        self._location_validator.validate_type_only(val)
        self._location_value = val
        self._location_present = True

    @location.deleter
    def location(self):
        self._location_value = None
        self._location_present = False

    @property
    def time_taken(self):
        """
        The timestamp when the photo/video is taken.

        :rtype: datetime.datetime
        """
        if self._time_taken_present:
            return self._time_taken_value
        else:
            return None

    @time_taken.setter
    def time_taken(self, val):
        if val is None:
            del self.time_taken
            return
        val = self._time_taken_validator.validate(val)
        self._time_taken_value = val
        self._time_taken_present = True

    @time_taken.deleter
    def time_taken(self):
        self._time_taken_value = None
        self._time_taken_present = False

    def __repr__(self):
        return 'MediaMetadata(dimensions={!r}, location={!r}, time_taken={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
        )

MediaMetadata_validator = bv.StructTree(MediaMetadata)

class PhotoMetadata(MediaMetadata):
    """
    Metadata for a photo.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None):
        super(PhotoMetadata, self).__init__(dimensions,
                                            location,
                                            time_taken)

    def __repr__(self):
        return 'PhotoMetadata(dimensions={!r}, location={!r}, time_taken={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
        )

PhotoMetadata_validator = bv.Struct(PhotoMetadata)

class PreviewArg(object):
    """
    :ivar path: The path of the file to preview.
    :ivar rev: Deprecated. Please specify revision in ``path`` instead
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path of the file to preview.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        Deprecated. Please specify revision in ``path`` instead

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            return None

    @rev.setter
    def rev(self, val):
        if val is None:
            del self.rev
            return
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'PreviewArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

PreviewArg_validator = bv.Struct(PreviewArg)

class PreviewError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path: An error occurs when downloading metadata for the
        file.
    :ivar in_progress: This preview generation is still in progress and the file
        is not ready  for preview yet.
    :ivar unsupported_extension: The file extension is not supported preview
        generation.
    :ivar unsupported_content: The file content is not supported for preview
        generation.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    in_progress = None
    # Attribute is overwritten below the class definition
    unsupported_extension = None
    # Attribute is overwritten below the class definition
    unsupported_content = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: PreviewError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_in_progress(self):
        """
        Check if the union tag is ``in_progress``.

        :rtype: bool
        """
        return self._tag == 'in_progress'

    def is_unsupported_extension(self):
        """
        Check if the union tag is ``unsupported_extension``.

        :rtype: bool
        """
        return self._tag == 'unsupported_extension'

    def is_unsupported_content(self):
        """
        Check if the union tag is ``unsupported_content``.

        :rtype: bool
        """
        return self._tag == 'unsupported_content'

    def get_path(self):
        """
        An error occurs when downloading metadata for the file.

        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'PreviewError(%r, %r)' % (self._tag, self._value)

PreviewError_validator = bv.Union(PreviewError)

class PropertyGroupUpdate(object):
    """
    :ivar template_id: A unique identifier for a property template.
    :ivar add_or_update_fields: List of property fields to update if the field
        already exists. If the field doesn't exist, add the field to the
        property group.
    :ivar remove_fields: List of property field names to remove from property
        group if the field exists.
    """

    __slots__ = [
        '_template_id_value',
        '_template_id_present',
        '_add_or_update_fields_value',
        '_add_or_update_fields_present',
        '_remove_fields_value',
        '_remove_fields_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 template_id=None,
                 add_or_update_fields=None,
                 remove_fields=None):
        self._template_id_value = None
        self._template_id_present = False
        self._add_or_update_fields_value = None
        self._add_or_update_fields_present = False
        self._remove_fields_value = None
        self._remove_fields_present = False
        if template_id is not None:
            self.template_id = template_id
        if add_or_update_fields is not None:
            self.add_or_update_fields = add_or_update_fields
        if remove_fields is not None:
            self.remove_fields = remove_fields

    @property
    def template_id(self):
        """
        A unique identifier for a property template.

        :rtype: str
        """
        if self._template_id_present:
            return self._template_id_value
        else:
            raise AttributeError("missing required field 'template_id'")

    @template_id.setter
    def template_id(self, val):
        val = self._template_id_validator.validate(val)
        self._template_id_value = val
        self._template_id_present = True

    @template_id.deleter
    def template_id(self):
        self._template_id_value = None
        self._template_id_present = False

    @property
    def add_or_update_fields(self):
        """
        List of property fields to update if the field already exists. If the
        field doesn't exist, add the field to the property group.

        :rtype: list of [properties.PropertyField_validator]
        """
        if self._add_or_update_fields_present:
            return self._add_or_update_fields_value
        else:
            return None

    @add_or_update_fields.setter
    def add_or_update_fields(self, val):
        if val is None:
            del self.add_or_update_fields
            return
        val = self._add_or_update_fields_validator.validate(val)
        self._add_or_update_fields_value = val
        self._add_or_update_fields_present = True

    @add_or_update_fields.deleter
    def add_or_update_fields(self):
        self._add_or_update_fields_value = None
        self._add_or_update_fields_present = False

    @property
    def remove_fields(self):
        """
        List of property field names to remove from property group if the field
        exists.

        :rtype: list of [str]
        """
        if self._remove_fields_present:
            return self._remove_fields_value
        else:
            return None

    @remove_fields.setter
    def remove_fields(self, val):
        if val is None:
            del self.remove_fields
            return
        val = self._remove_fields_validator.validate(val)
        self._remove_fields_value = val
        self._remove_fields_present = True

    @remove_fields.deleter
    def remove_fields(self):
        self._remove_fields_value = None
        self._remove_fields_present = False

    def __repr__(self):
        return 'PropertyGroupUpdate(template_id={!r}, add_or_update_fields={!r}, remove_fields={!r})'.format(
            self._template_id_value,
            self._add_or_update_fields_value,
            self._remove_fields_value,
        )

PropertyGroupUpdate_validator = bv.Struct(PropertyGroupUpdate)

class PropertyGroupWithPath(object):
    """
    :ivar path: A unique identifier for the file.
    :ivar property_groups: Filled custom property templates associated with a
        file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_property_groups_value',
        '_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 property_groups=None):
        self._path_value = None
        self._path_present = False
        self._property_groups_value = None
        self._property_groups_present = False
        if path is not None:
            self.path = path
        if property_groups is not None:
            self.property_groups = property_groups

    @property
    def path(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def property_groups(self):
        """
        Filled custom property templates associated with a file.

        :rtype: list of [properties.PropertyGroup_validator]
        """
        if self._property_groups_present:
            return self._property_groups_value
        else:
            raise AttributeError("missing required field 'property_groups'")

    @property_groups.setter
    def property_groups(self, val):
        val = self._property_groups_validator.validate(val)
        self._property_groups_value = val
        self._property_groups_present = True

    @property_groups.deleter
    def property_groups(self):
        self._property_groups_value = None
        self._property_groups_present = False

    def __repr__(self):
        return 'PropertyGroupWithPath(path={!r}, property_groups={!r})'.format(
            self._path_value,
            self._property_groups_value,
        )

PropertyGroupWithPath_validator = bv.Struct(PropertyGroupWithPath)

class RelocationArg(object):
    """
    :ivar from_path: Path in the user's Dropbox to be copied or moved.
    :ivar to_path: Path in the user's Dropbox that is the destination.
    """

    __slots__ = [
        '_from_path_value',
        '_from_path_present',
        '_to_path_value',
        '_to_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 from_path=None,
                 to_path=None):
        self._from_path_value = None
        self._from_path_present = False
        self._to_path_value = None
        self._to_path_present = False
        if from_path is not None:
            self.from_path = from_path
        if to_path is not None:
            self.to_path = to_path

    @property
    def from_path(self):
        """
        Path in the user's Dropbox to be copied or moved.

        :rtype: str
        """
        if self._from_path_present:
            return self._from_path_value
        else:
            raise AttributeError("missing required field 'from_path'")

    @from_path.setter
    def from_path(self, val):
        val = self._from_path_validator.validate(val)
        self._from_path_value = val
        self._from_path_present = True

    @from_path.deleter
    def from_path(self):
        self._from_path_value = None
        self._from_path_present = False

    @property
    def to_path(self):
        """
        Path in the user's Dropbox that is the destination.

        :rtype: str
        """
        if self._to_path_present:
            return self._to_path_value
        else:
            raise AttributeError("missing required field 'to_path'")

    @to_path.setter
    def to_path(self, val):
        val = self._to_path_validator.validate(val)
        self._to_path_value = val
        self._to_path_present = True

    @to_path.deleter
    def to_path(self):
        self._to_path_value = None
        self._to_path_present = False

    def __repr__(self):
        return 'RelocationArg(from_path={!r}, to_path={!r})'.format(
            self._from_path_value,
            self._to_path_value,
        )

RelocationArg_validator = bv.Struct(RelocationArg)

class RelocationError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cant_copy_shared_folder: Shared folders can't be copied.
    :ivar cant_nest_shared_folder: Your move operation would result in nested
        shared folders.  This is not allowed.
    :ivar cant_move_folder_into_itself: You cannot move a folder into itself.
    :ivar too_many_files: The operation would involve more than 10,000 files and
        folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    cant_copy_shared_folder = None
    # Attribute is overwritten below the class definition
    cant_nest_shared_folder = None
    # Attribute is overwritten below the class definition
    cant_move_folder_into_itself = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def from_lookup(cls, val):
        """
        Create an instance of this class set to the ``from_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: RelocationError
        """
        return cls('from_lookup', val)

    @classmethod
    def from_write(cls, val):
        """
        Create an instance of this class set to the ``from_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: RelocationError
        """
        return cls('from_write', val)

    @classmethod
    def to(cls, val):
        """
        Create an instance of this class set to the ``to`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: RelocationError
        """
        return cls('to', val)

    def is_from_lookup(self):
        """
        Check if the union tag is ``from_lookup``.

        :rtype: bool
        """
        return self._tag == 'from_lookup'

    def is_from_write(self):
        """
        Check if the union tag is ``from_write``.

        :rtype: bool
        """
        return self._tag == 'from_write'

    def is_to(self):
        """
        Check if the union tag is ``to``.

        :rtype: bool
        """
        return self._tag == 'to'

    def is_cant_copy_shared_folder(self):
        """
        Check if the union tag is ``cant_copy_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'cant_copy_shared_folder'

    def is_cant_nest_shared_folder(self):
        """
        Check if the union tag is ``cant_nest_shared_folder``.

        :rtype: bool
        """
        return self._tag == 'cant_nest_shared_folder'

    def is_cant_move_folder_into_itself(self):
        """
        Check if the union tag is ``cant_move_folder_into_itself``.

        :rtype: bool
        """
        return self._tag == 'cant_move_folder_into_itself'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_from_lookup(self):
        """
        Only call this if :meth:`is_from_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_from_lookup():
            raise AttributeError("tag 'from_lookup' not set")
        return self._value

    def get_from_write(self):
        """
        Only call this if :meth:`is_from_write` is true.

        :rtype: WriteError
        """
        if not self.is_from_write():
            raise AttributeError("tag 'from_write' not set")
        return self._value

    def get_to(self):
        """
        Only call this if :meth:`is_to` is true.

        :rtype: WriteError
        """
        if not self.is_to():
            raise AttributeError("tag 'to' not set")
        return self._value

    def __repr__(self):
        return 'RelocationError(%r, %r)' % (self._tag, self._value)

RelocationError_validator = bv.Union(RelocationError)

class RemovePropertiesArg(object):
    """
    :ivar path: A unique identifier for the file.
    :ivar property_template_ids: A list of identifiers for a property template
        created by route properties/template/add.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_property_template_ids_value',
        '_property_template_ids_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 property_template_ids=None):
        self._path_value = None
        self._path_present = False
        self._property_template_ids_value = None
        self._property_template_ids_present = False
        if path is not None:
            self.path = path
        if property_template_ids is not None:
            self.property_template_ids = property_template_ids

    @property
    def path(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def property_template_ids(self):
        """
        A list of identifiers for a property template created by route
        properties/template/add.

        :rtype: list of [str]
        """
        if self._property_template_ids_present:
            return self._property_template_ids_value
        else:
            raise AttributeError("missing required field 'property_template_ids'")

    @property_template_ids.setter
    def property_template_ids(self, val):
        val = self._property_template_ids_validator.validate(val)
        self._property_template_ids_value = val
        self._property_template_ids_present = True

    @property_template_ids.deleter
    def property_template_ids(self):
        self._property_template_ids_value = None
        self._property_template_ids_present = False

    def __repr__(self):
        return 'RemovePropertiesArg(path={!r}, property_template_ids={!r})'.format(
            self._path_value,
            self._property_template_ids_value,
        )

RemovePropertiesArg_validator = bv.Struct(RemovePropertiesArg)

class RemovePropertiesError(PropertiesError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def property_group_lookup(cls, val):
        """
        Create an instance of this class set to the ``property_group_lookup``
        tag with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: RemovePropertiesError
        """
        return cls('property_group_lookup', val)

    def is_property_group_lookup(self):
        """
        Check if the union tag is ``property_group_lookup``.

        :rtype: bool
        """
        return self._tag == 'property_group_lookup'

    def get_property_group_lookup(self):
        """
        Only call this if :meth:`is_property_group_lookup` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_property_group_lookup():
            raise AttributeError("tag 'property_group_lookup' not set")
        return self._value

    def __repr__(self):
        return 'RemovePropertiesError(%r, %r)' % (self._tag, self._value)

RemovePropertiesError_validator = bv.Union(RemovePropertiesError)

class RestoreArg(object):
    """
    :ivar path: The path to the file you want to restore.
    :ivar rev: The revision to restore for the file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_rev_value',
        '_rev_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 rev=None):
        self._path_value = None
        self._path_present = False
        self._rev_value = None
        self._rev_present = False
        if path is not None:
            self.path = path
        if rev is not None:
            self.rev = rev

    @property
    def path(self):
        """
        The path to the file you want to restore.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def rev(self):
        """
        The revision to restore for the file.

        :rtype: str
        """
        if self._rev_present:
            return self._rev_value
        else:
            raise AttributeError("missing required field 'rev'")

    @rev.setter
    def rev(self, val):
        val = self._rev_validator.validate(val)
        self._rev_value = val
        self._rev_present = True

    @rev.deleter
    def rev(self):
        self._rev_value = None
        self._rev_present = False

    def __repr__(self):
        return 'RestoreArg(path={!r}, rev={!r})'.format(
            self._path_value,
            self._rev_value,
        )

RestoreArg_validator = bv.Struct(RestoreArg)

class RestoreError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path_lookup: An error occurs when downloading metadata for
        the file.
    :ivar WriteError path_write: An error occurs when trying to restore the file
        to that path.
    :ivar invalid_revision: The revision is invalid. It may point to a different
        file.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_revision = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path_lookup(cls, val):
        """
        Create an instance of this class set to the ``path_lookup`` tag with
        value ``val``.

        :param LookupError val:
        :rtype: RestoreError
        """
        return cls('path_lookup', val)

    @classmethod
    def path_write(cls, val):
        """
        Create an instance of this class set to the ``path_write`` tag with
        value ``val``.

        :param WriteError val:
        :rtype: RestoreError
        """
        return cls('path_write', val)

    def is_path_lookup(self):
        """
        Check if the union tag is ``path_lookup``.

        :rtype: bool
        """
        return self._tag == 'path_lookup'

    def is_path_write(self):
        """
        Check if the union tag is ``path_write``.

        :rtype: bool
        """
        return self._tag == 'path_write'

    def is_invalid_revision(self):
        """
        Check if the union tag is ``invalid_revision``.

        :rtype: bool
        """
        return self._tag == 'invalid_revision'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path_lookup(self):
        """
        An error occurs when downloading metadata for the file.

        Only call this if :meth:`is_path_lookup` is true.

        :rtype: LookupError
        """
        if not self.is_path_lookup():
            raise AttributeError("tag 'path_lookup' not set")
        return self._value

    def get_path_write(self):
        """
        An error occurs when trying to restore the file to that path.

        Only call this if :meth:`is_path_write` is true.

        :rtype: WriteError
        """
        if not self.is_path_write():
            raise AttributeError("tag 'path_write' not set")
        return self._value

    def __repr__(self):
        return 'RestoreError(%r, %r)' % (self._tag, self._value)

RestoreError_validator = bv.Union(RestoreError)

class SaveCopyReferenceArg(object):
    """
    :ivar copy_reference: A copy reference returned by copy_reference/get.
    :ivar path: Path in the user's Dropbox that is the destination.
    """

    __slots__ = [
        '_copy_reference_value',
        '_copy_reference_present',
        '_path_value',
        '_path_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 copy_reference=None,
                 path=None):
        self._copy_reference_value = None
        self._copy_reference_present = False
        self._path_value = None
        self._path_present = False
        if copy_reference is not None:
            self.copy_reference = copy_reference
        if path is not None:
            self.path = path

    @property
    def copy_reference(self):
        """
        A copy reference returned by copy_reference/get.

        :rtype: str
        """
        if self._copy_reference_present:
            return self._copy_reference_value
        else:
            raise AttributeError("missing required field 'copy_reference'")

    @copy_reference.setter
    def copy_reference(self, val):
        val = self._copy_reference_validator.validate(val)
        self._copy_reference_value = val
        self._copy_reference_present = True

    @copy_reference.deleter
    def copy_reference(self):
        self._copy_reference_value = None
        self._copy_reference_present = False

    @property
    def path(self):
        """
        Path in the user's Dropbox that is the destination.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    def __repr__(self):
        return 'SaveCopyReferenceArg(copy_reference={!r}, path={!r})'.format(
            self._copy_reference_value,
            self._path_value,
        )

SaveCopyReferenceArg_validator = bv.Struct(SaveCopyReferenceArg)

class SaveCopyReferenceError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_copy_reference: The copy reference is invalid.
    :ivar no_permission: You don't have permission to save the given copy
        reference. Please make sure this app is same app which created the copy
        reference and the source user is still linked to the app.
    :ivar not_found: The file referenced by the copy reference cannot be found.
    :ivar too_many_files: The operation would involve more than 10,000 files and
        folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_copy_reference = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    too_many_files = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: SaveCopyReferenceError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_invalid_copy_reference(self):
        """
        Check if the union tag is ``invalid_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'invalid_copy_reference'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_too_many_files(self):
        """
        Check if the union tag is ``too_many_files``.

        :rtype: bool
        """
        return self._tag == 'too_many_files'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SaveCopyReferenceError(%r, %r)' % (self._tag, self._value)

SaveCopyReferenceError_validator = bv.Union(SaveCopyReferenceError)

class SaveCopyReferenceResult(object):
    """
    :ivar metadata: The metadata of the saved file or folder in the user's
        Dropbox.
    """

    __slots__ = [
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 metadata=None):
        self._metadata_value = None
        self._metadata_present = False
        if metadata is not None:
            self.metadata = metadata

    @property
    def metadata(self):
        """
        The metadata of the saved file or folder in the user's Dropbox.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'SaveCopyReferenceResult(metadata={!r})'.format(
            self._metadata_value,
        )

SaveCopyReferenceResult_validator = bv.Struct(SaveCopyReferenceResult)

class SaveUrlArg(object):
    """
    :ivar path: The path in Dropbox where the URL will be saved to.
    :ivar url: The URL to be saved.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_url_value',
        '_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 url=None):
        self._path_value = None
        self._path_present = False
        self._url_value = None
        self._url_present = False
        if path is not None:
            self.path = path
        if url is not None:
            self.url = url

    @property
    def path(self):
        """
        The path in Dropbox where the URL will be saved to.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def url(self):
        """
        The URL to be saved.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    def __repr__(self):
        return 'SaveUrlArg(path={!r}, url={!r})'.format(
            self._path_value,
            self._url_value,
        )

SaveUrlArg_validator = bv.Struct(SaveUrlArg)

class SaveUrlError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar download_failed: Failed downloading the given URL.
    :ivar invalid_url: The given URL is invalid.
    :ivar not_found: The file where the URL is saved to no longer exists.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    download_failed = None
    # Attribute is overwritten below the class definition
    invalid_url = None
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: SaveUrlError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_download_failed(self):
        """
        Check if the union tag is ``download_failed``.

        :rtype: bool
        """
        return self._tag == 'download_failed'

    def is_invalid_url(self):
        """
        Check if the union tag is ``invalid_url``.

        :rtype: bool
        """
        return self._tag == 'invalid_url'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlError(%r, %r)' % (self._tag, self._value)

SaveUrlError_validator = bv.Union(SaveUrlError)

class SaveUrlJobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileMetadata complete: Metadata of the file where the URL is saved to.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: SaveUrlJobStatus
        """
        return cls('complete', val)

    @classmethod
    def failed(cls, val):
        """
        Create an instance of this class set to the ``failed`` tag with value
        ``val``.

        :param SaveUrlError val:
        :rtype: SaveUrlJobStatus
        """
        return cls('failed', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def is_failed(self):
        """
        Check if the union tag is ``failed``.

        :rtype: bool
        """
        return self._tag == 'failed'

    def get_complete(self):
        """
        Metadata of the file where the URL is saved to.

        Only call this if :meth:`is_complete` is true.

        :rtype: FileMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def get_failed(self):
        """
        Only call this if :meth:`is_failed` is true.

        :rtype: SaveUrlError
        """
        if not self.is_failed():
            raise AttributeError("tag 'failed' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlJobStatus(%r, %r)' % (self._tag, self._value)

SaveUrlJobStatus_validator = bv.Union(SaveUrlJobStatus)

class SaveUrlResult(async.LaunchResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileMetadata complete: Metadata of the file where the URL is saved to.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: SaveUrlResult
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        Metadata of the file where the URL is saved to.

        Only call this if :meth:`is_complete` is true.

        :rtype: FileMetadata
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'SaveUrlResult(%r, %r)' % (self._tag, self._value)

SaveUrlResult_validator = bv.Union(SaveUrlResult)

class SearchArg(object):
    """
    :ivar path: The path in the user's Dropbox to search. Should probably be a
        folder.
    :ivar query: The string to search for. The search string is split on spaces
        into multiple tokens. For file name searching, the last token is used
        for prefix matching (i.e. "bat c" matches "bat cave" but not "batman
        car").
    :ivar start: The starting index within the search results (used for paging).
    :ivar max_results: The maximum number of search results to return.
    :ivar mode: The search mode (filename, filename_and_content, or
        deleted_filename). Note that searching file content is only available
        for Dropbox Business accounts.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_query_value',
        '_query_present',
        '_start_value',
        '_start_present',
        '_max_results_value',
        '_max_results_present',
        '_mode_value',
        '_mode_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 query=None,
                 start=None,
                 max_results=None,
                 mode=None):
        self._path_value = None
        self._path_present = False
        self._query_value = None
        self._query_present = False
        self._start_value = None
        self._start_present = False
        self._max_results_value = None
        self._max_results_present = False
        self._mode_value = None
        self._mode_present = False
        if path is not None:
            self.path = path
        if query is not None:
            self.query = query
        if start is not None:
            self.start = start
        if max_results is not None:
            self.max_results = max_results
        if mode is not None:
            self.mode = mode

    @property
    def path(self):
        """
        The path in the user's Dropbox to search. Should probably be a folder.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def query(self):
        """
        The string to search for. The search string is split on spaces into
        multiple tokens. For file name searching, the last token is used for
        prefix matching (i.e. "bat c" matches "bat cave" but not "batman car").

        :rtype: str
        """
        if self._query_present:
            return self._query_value
        else:
            raise AttributeError("missing required field 'query'")

    @query.setter
    def query(self, val):
        val = self._query_validator.validate(val)
        self._query_value = val
        self._query_present = True

    @query.deleter
    def query(self):
        self._query_value = None
        self._query_present = False

    @property
    def start(self):
        """
        The starting index within the search results (used for paging).

        :rtype: long
        """
        if self._start_present:
            return self._start_value
        else:
            return 0

    @start.setter
    def start(self, val):
        val = self._start_validator.validate(val)
        self._start_value = val
        self._start_present = True

    @start.deleter
    def start(self):
        self._start_value = None
        self._start_present = False

    @property
    def max_results(self):
        """
        The maximum number of search results to return.

        :rtype: long
        """
        if self._max_results_present:
            return self._max_results_value
        else:
            return 100

    @max_results.setter
    def max_results(self, val):
        val = self._max_results_validator.validate(val)
        self._max_results_value = val
        self._max_results_present = True

    @max_results.deleter
    def max_results(self):
        self._max_results_value = None
        self._max_results_present = False

    @property
    def mode(self):
        """
        The search mode (filename, filename_and_content, or deleted_filename).
        Note that searching file content is only available for Dropbox Business
        accounts.

        :rtype: SearchMode
        """
        if self._mode_present:
            return self._mode_value
        else:
            return SearchMode.filename

    @mode.setter
    def mode(self, val):
        self._mode_validator.validate_type_only(val)
        self._mode_value = val
        self._mode_present = True

    @mode.deleter
    def mode(self):
        self._mode_value = None
        self._mode_present = False

    def __repr__(self):
        return 'SearchArg(path={!r}, query={!r}, start={!r}, max_results={!r}, mode={!r})'.format(
            self._path_value,
            self._query_value,
            self._start_value,
            self._max_results_value,
            self._mode_value,
        )

SearchArg_validator = bv.Struct(SearchArg)

class SearchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: SearchError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'SearchError(%r, %r)' % (self._tag, self._value)

SearchError_validator = bv.Union(SearchError)

class SearchMatch(object):
    """
    :ivar match_type: The type of the match.
    :ivar metadata: The metadata for the matched file or folder.
    """

    __slots__ = [
        '_match_type_value',
        '_match_type_present',
        '_metadata_value',
        '_metadata_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 match_type=None,
                 metadata=None):
        self._match_type_value = None
        self._match_type_present = False
        self._metadata_value = None
        self._metadata_present = False
        if match_type is not None:
            self.match_type = match_type
        if metadata is not None:
            self.metadata = metadata

    @property
    def match_type(self):
        """
        The type of the match.

        :rtype: SearchMatchType
        """
        if self._match_type_present:
            return self._match_type_value
        else:
            raise AttributeError("missing required field 'match_type'")

    @match_type.setter
    def match_type(self, val):
        self._match_type_validator.validate_type_only(val)
        self._match_type_value = val
        self._match_type_present = True

    @match_type.deleter
    def match_type(self):
        self._match_type_value = None
        self._match_type_present = False

    @property
    def metadata(self):
        """
        The metadata for the matched file or folder.

        :rtype: Metadata
        """
        if self._metadata_present:
            return self._metadata_value
        else:
            raise AttributeError("missing required field 'metadata'")

    @metadata.setter
    def metadata(self, val):
        self._metadata_validator.validate_type_only(val)
        self._metadata_value = val
        self._metadata_present = True

    @metadata.deleter
    def metadata(self):
        self._metadata_value = None
        self._metadata_present = False

    def __repr__(self):
        return 'SearchMatch(match_type={!r}, metadata={!r})'.format(
            self._match_type_value,
            self._metadata_value,
        )

SearchMatch_validator = bv.Struct(SearchMatch)

class SearchMatchType(bb.Union):
    """
    Indicates what type of match was found for a given item.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar filename: This item was matched on its file or folder name.
    :ivar content: This item was matched based on its file contents.
    :ivar both: This item was matched based on both its contents and its file
        name.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    filename = None
    # Attribute is overwritten below the class definition
    content = None
    # Attribute is overwritten below the class definition
    both = None

    def is_filename(self):
        """
        Check if the union tag is ``filename``.

        :rtype: bool
        """
        return self._tag == 'filename'

    def is_content(self):
        """
        Check if the union tag is ``content``.

        :rtype: bool
        """
        return self._tag == 'content'

    def is_both(self):
        """
        Check if the union tag is ``both``.

        :rtype: bool
        """
        return self._tag == 'both'

    def __repr__(self):
        return 'SearchMatchType(%r, %r)' % (self._tag, self._value)

SearchMatchType_validator = bv.Union(SearchMatchType)

class SearchMode(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar filename: Search file and folder names.
    :ivar filename_and_content: Search file and folder names as well as file
        contents.
    :ivar deleted_filename: Search for deleted file and folder names.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    filename = None
    # Attribute is overwritten below the class definition
    filename_and_content = None
    # Attribute is overwritten below the class definition
    deleted_filename = None

    def is_filename(self):
        """
        Check if the union tag is ``filename``.

        :rtype: bool
        """
        return self._tag == 'filename'

    def is_filename_and_content(self):
        """
        Check if the union tag is ``filename_and_content``.

        :rtype: bool
        """
        return self._tag == 'filename_and_content'

    def is_deleted_filename(self):
        """
        Check if the union tag is ``deleted_filename``.

        :rtype: bool
        """
        return self._tag == 'deleted_filename'

    def __repr__(self):
        return 'SearchMode(%r, %r)' % (self._tag, self._value)

SearchMode_validator = bv.Union(SearchMode)

class SearchResult(object):
    """
    :ivar matches: A list (possibly empty) of matches for the query.
    :ivar more: Used for paging. If true, indicates there is another page of
        results available that can be fetched by calling search again.
    :ivar start: Used for paging. Value to set the start argument to when
        calling search to fetch the next page of results.
    """

    __slots__ = [
        '_matches_value',
        '_matches_present',
        '_more_value',
        '_more_present',
        '_start_value',
        '_start_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 matches=None,
                 more=None,
                 start=None):
        self._matches_value = None
        self._matches_present = False
        self._more_value = None
        self._more_present = False
        self._start_value = None
        self._start_present = False
        if matches is not None:
            self.matches = matches
        if more is not None:
            self.more = more
        if start is not None:
            self.start = start

    @property
    def matches(self):
        """
        A list (possibly empty) of matches for the query.

        :rtype: list of [SearchMatch]
        """
        if self._matches_present:
            return self._matches_value
        else:
            raise AttributeError("missing required field 'matches'")

    @matches.setter
    def matches(self, val):
        val = self._matches_validator.validate(val)
        self._matches_value = val
        self._matches_present = True

    @matches.deleter
    def matches(self):
        self._matches_value = None
        self._matches_present = False

    @property
    def more(self):
        """
        Used for paging. If true, indicates there is another page of results
        available that can be fetched by calling search again.

        :rtype: bool
        """
        if self._more_present:
            return self._more_value
        else:
            raise AttributeError("missing required field 'more'")

    @more.setter
    def more(self, val):
        val = self._more_validator.validate(val)
        self._more_value = val
        self._more_present = True

    @more.deleter
    def more(self):
        self._more_value = None
        self._more_present = False

    @property
    def start(self):
        """
        Used for paging. Value to set the start argument to when calling search
        to fetch the next page of results.

        :rtype: long
        """
        if self._start_present:
            return self._start_value
        else:
            raise AttributeError("missing required field 'start'")

    @start.setter
    def start(self, val):
        val = self._start_validator.validate(val)
        self._start_value = val
        self._start_present = True

    @start.deleter
    def start(self):
        self._start_value = None
        self._start_present = False

    def __repr__(self):
        return 'SearchResult(matches={!r}, more={!r}, start={!r})'.format(
            self._matches_value,
            self._more_value,
            self._start_value,
        )

SearchResult_validator = bv.Struct(SearchResult)

class ThumbnailArg(object):
    """
    :ivar path: The path to the image file you want to thumbnail.
    :ivar format: The format for the thumbnail image, jpeg (default) or png. For
        images that are photos, jpeg should be preferred, while png is  better
        for screenshots and digital arts.
    :ivar size: The size for the thumbnail image.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_format_value',
        '_format_present',
        '_size_value',
        '_size_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 format=None,
                 size=None):
        self._path_value = None
        self._path_present = False
        self._format_value = None
        self._format_present = False
        self._size_value = None
        self._size_present = False
        if path is not None:
            self.path = path
        if format is not None:
            self.format = format
        if size is not None:
            self.size = size

    @property
    def path(self):
        """
        The path to the image file you want to thumbnail.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def format(self):
        """
        The format for the thumbnail image, jpeg (default) or png. For  images
        that are photos, jpeg should be preferred, while png is  better for
        screenshots and digital arts.

        :rtype: ThumbnailFormat
        """
        if self._format_present:
            return self._format_value
        else:
            return ThumbnailFormat.jpeg

    @format.setter
    def format(self, val):
        self._format_validator.validate_type_only(val)
        self._format_value = val
        self._format_present = True

    @format.deleter
    def format(self):
        self._format_value = None
        self._format_present = False

    @property
    def size(self):
        """
        The size for the thumbnail image.

        :rtype: ThumbnailSize
        """
        if self._size_present:
            return self._size_value
        else:
            return ThumbnailSize.w64h64

    @size.setter
    def size(self, val):
        self._size_validator.validate_type_only(val)
        self._size_value = val
        self._size_present = True

    @size.deleter
    def size(self):
        self._size_value = None
        self._size_present = False

    def __repr__(self):
        return 'ThumbnailArg(path={!r}, format={!r}, size={!r})'.format(
            self._path_value,
            self._format_value,
            self._size_value,
        )

ThumbnailArg_validator = bv.Struct(ThumbnailArg)

class ThumbnailError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar LookupError path: An error occurs when downloading metadata for the
        image.
    :ivar unsupported_extension: The file extension doesn't allow conversion to
        a thumbnail.
    :ivar unsupported_image: The image cannot be converted to a thumbnail.
    :ivar conversion_error: An error occurs during thumbnail conversion.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    unsupported_extension = None
    # Attribute is overwritten below the class definition
    unsupported_image = None
    # Attribute is overwritten below the class definition
    conversion_error = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param LookupError val:
        :rtype: ThumbnailError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_unsupported_extension(self):
        """
        Check if the union tag is ``unsupported_extension``.

        :rtype: bool
        """
        return self._tag == 'unsupported_extension'

    def is_unsupported_image(self):
        """
        Check if the union tag is ``unsupported_image``.

        :rtype: bool
        """
        return self._tag == 'unsupported_image'

    def is_conversion_error(self):
        """
        Check if the union tag is ``conversion_error``.

        :rtype: bool
        """
        return self._tag == 'conversion_error'

    def get_path(self):
        """
        An error occurs when downloading metadata for the image.

        Only call this if :meth:`is_path` is true.

        :rtype: LookupError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'ThumbnailError(%r, %r)' % (self._tag, self._value)

ThumbnailError_validator = bv.Union(ThumbnailError)

class ThumbnailFormat(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    jpeg = None
    # Attribute is overwritten below the class definition
    png = None

    def is_jpeg(self):
        """
        Check if the union tag is ``jpeg``.

        :rtype: bool
        """
        return self._tag == 'jpeg'

    def is_png(self):
        """
        Check if the union tag is ``png``.

        :rtype: bool
        """
        return self._tag == 'png'

    def __repr__(self):
        return 'ThumbnailFormat(%r, %r)' % (self._tag, self._value)

ThumbnailFormat_validator = bv.Union(ThumbnailFormat)

class ThumbnailSize(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar w32h32: 32 by 32 px.
    :ivar w64h64: 64 by 64 px.
    :ivar w128h128: 128 by 128 px.
    :ivar w640h480: 640 by 480 px.
    :ivar w1024h768: 1024 by 768
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    w32h32 = None
    # Attribute is overwritten below the class definition
    w64h64 = None
    # Attribute is overwritten below the class definition
    w128h128 = None
    # Attribute is overwritten below the class definition
    w640h480 = None
    # Attribute is overwritten below the class definition
    w1024h768 = None

    def is_w32h32(self):
        """
        Check if the union tag is ``w32h32``.

        :rtype: bool
        """
        return self._tag == 'w32h32'

    def is_w64h64(self):
        """
        Check if the union tag is ``w64h64``.

        :rtype: bool
        """
        return self._tag == 'w64h64'

    def is_w128h128(self):
        """
        Check if the union tag is ``w128h128``.

        :rtype: bool
        """
        return self._tag == 'w128h128'

    def is_w640h480(self):
        """
        Check if the union tag is ``w640h480``.

        :rtype: bool
        """
        return self._tag == 'w640h480'

    def is_w1024h768(self):
        """
        Check if the union tag is ``w1024h768``.

        :rtype: bool
        """
        return self._tag == 'w1024h768'

    def __repr__(self):
        return 'ThumbnailSize(%r, %r)' % (self._tag, self._value)

ThumbnailSize_validator = bv.Union(ThumbnailSize)

class UpdatePropertiesError(InvalidPropertyGroupError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def property_group_lookup(cls, val):
        """
        Create an instance of this class set to the ``property_group_lookup``
        tag with value ``val``.

        :param LookUpPropertiesError val:
        :rtype: UpdatePropertiesError
        """
        return cls('property_group_lookup', val)

    def is_property_group_lookup(self):
        """
        Check if the union tag is ``property_group_lookup``.

        :rtype: bool
        """
        return self._tag == 'property_group_lookup'

    def get_property_group_lookup(self):
        """
        Only call this if :meth:`is_property_group_lookup` is true.

        :rtype: LookUpPropertiesError
        """
        if not self.is_property_group_lookup():
            raise AttributeError("tag 'property_group_lookup' not set")
        return self._value

    def __repr__(self):
        return 'UpdatePropertiesError(%r, %r)' % (self._tag, self._value)

UpdatePropertiesError_validator = bv.Union(UpdatePropertiesError)

class UpdatePropertyGroupArg(object):
    """
    :ivar path: A unique identifier for the file.
    :ivar update_property_groups: Filled custom property templates associated
        with a file.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_update_property_groups_value',
        '_update_property_groups_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 update_property_groups=None):
        self._path_value = None
        self._path_present = False
        self._update_property_groups_value = None
        self._update_property_groups_present = False
        if path is not None:
            self.path = path
        if update_property_groups is not None:
            self.update_property_groups = update_property_groups

    @property
    def path(self):
        """
        A unique identifier for the file.

        :rtype: str
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        val = self._path_validator.validate(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def update_property_groups(self):
        """
        Filled custom property templates associated with a file.

        :rtype: list of [PropertyGroupUpdate]
        """
        if self._update_property_groups_present:
            return self._update_property_groups_value
        else:
            raise AttributeError("missing required field 'update_property_groups'")

    @update_property_groups.setter
    def update_property_groups(self, val):
        val = self._update_property_groups_validator.validate(val)
        self._update_property_groups_value = val
        self._update_property_groups_present = True

    @update_property_groups.deleter
    def update_property_groups(self):
        self._update_property_groups_value = None
        self._update_property_groups_present = False

    def __repr__(self):
        return 'UpdatePropertyGroupArg(path={!r}, update_property_groups={!r})'.format(
            self._path_value,
            self._update_property_groups_value,
        )

UpdatePropertyGroupArg_validator = bv.Struct(UpdatePropertyGroupArg)

class UploadError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadWriteFailed path: Unable to save the uploaded contents to a
        file.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param UploadWriteFailed val:
        :rtype: UploadError
        """
        return cls('path', val)

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_path(self):
        """
        Unable to save the uploaded contents to a file.

        Only call this if :meth:`is_path` is true.

        :rtype: UploadWriteFailed
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'UploadError(%r, %r)' % (self._tag, self._value)

UploadError_validator = bv.Union(UploadError)

class UploadErrorWithProperties(UploadError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    @classmethod
    def properties_error(cls, val):
        """
        Create an instance of this class set to the ``properties_error`` tag
        with value ``val``.

        :param InvalidPropertyGroupError val:
        :rtype: UploadErrorWithProperties
        """
        return cls('properties_error', val)

    def is_properties_error(self):
        """
        Check if the union tag is ``properties_error``.

        :rtype: bool
        """
        return self._tag == 'properties_error'

    def get_properties_error(self):
        """
        Only call this if :meth:`is_properties_error` is true.

        :rtype: InvalidPropertyGroupError
        """
        if not self.is_properties_error():
            raise AttributeError("tag 'properties_error' not set")
        return self._value

    def __repr__(self):
        return 'UploadErrorWithProperties(%r, %r)' % (self._tag, self._value)

UploadErrorWithProperties_validator = bv.Union(UploadErrorWithProperties)

class UploadSessionAppendArg(object):
    """
    :ivar cursor: Contains the upload session ID and the offset.
    :ivar close: If true, the current session will be closed, at which point you
        won't be able to call upload_session/append_v2 anymore with the current
        session.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_close_value',
        '_close_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 close=None):
        self._cursor_value = None
        self._cursor_present = False
        self._close_value = None
        self._close_present = False
        if cursor is not None:
            self.cursor = cursor
        if close is not None:
            self.close = close

    @property
    def cursor(self):
        """
        Contains the upload session ID and the offset.

        :rtype: UploadSessionCursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def close(self):
        """
        If true, the current session will be closed, at which point you won't be
        able to call upload_session/append_v2 anymore with the current session.

        :rtype: bool
        """
        if self._close_present:
            return self._close_value
        else:
            return False

    @close.setter
    def close(self, val):
        val = self._close_validator.validate(val)
        self._close_value = val
        self._close_present = True

    @close.deleter
    def close(self):
        self._close_value = None
        self._close_present = False

    def __repr__(self):
        return 'UploadSessionAppendArg(cursor={!r}, close={!r})'.format(
            self._cursor_value,
            self._close_value,
        )

UploadSessionAppendArg_validator = bv.Struct(UploadSessionAppendArg)

class UploadSessionCursor(object):
    """
    :ivar session_id: The upload session ID (returned by upload_session/start).
    :ivar offset: The amount of data that has been uploaded so far. We use this
        to make sure upload data isn't lost or duplicated in the event of a
        network error.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
        '_offset_value',
        '_offset_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 session_id=None,
                 offset=None):
        self._session_id_value = None
        self._session_id_present = False
        self._offset_value = None
        self._offset_present = False
        if session_id is not None:
            self.session_id = session_id
        if offset is not None:
            self.offset = offset

    @property
    def session_id(self):
        """
        The upload session ID (returned by upload_session/start).

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            raise AttributeError("missing required field 'session_id'")

    @session_id.setter
    def session_id(self, val):
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    @property
    def offset(self):
        """
        The amount of data that has been uploaded so far. We use this to make
        sure upload data isn't lost or duplicated in the event of a network
        error.

        :rtype: long
        """
        if self._offset_present:
            return self._offset_value
        else:
            raise AttributeError("missing required field 'offset'")

    @offset.setter
    def offset(self, val):
        val = self._offset_validator.validate(val)
        self._offset_value = val
        self._offset_present = True

    @offset.deleter
    def offset(self):
        self._offset_value = None
        self._offset_present = False

    def __repr__(self):
        return 'UploadSessionCursor(session_id={!r}, offset={!r})'.format(
            self._session_id_value,
            self._offset_value,
        )

UploadSessionCursor_validator = bv.Struct(UploadSessionCursor)

class UploadSessionFinishArg(object):
    """
    :ivar cursor: Contains the upload session ID and the offset.
    :ivar commit: Contains the path and other optional modifiers for the commit.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
        '_commit_value',
        '_commit_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None,
                 commit=None):
        self._cursor_value = None
        self._cursor_present = False
        self._commit_value = None
        self._commit_present = False
        if cursor is not None:
            self.cursor = cursor
        if commit is not None:
            self.commit = commit

    @property
    def cursor(self):
        """
        Contains the upload session ID and the offset.

        :rtype: UploadSessionCursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def commit(self):
        """
        Contains the path and other optional modifiers for the commit.

        :rtype: CommitInfo
        """
        if self._commit_present:
            return self._commit_value
        else:
            raise AttributeError("missing required field 'commit'")

    @commit.setter
    def commit(self, val):
        self._commit_validator.validate_type_only(val)
        self._commit_value = val
        self._commit_present = True

    @commit.deleter
    def commit(self):
        self._commit_value = None
        self._commit_present = False

    def __repr__(self):
        return 'UploadSessionFinishArg(cursor={!r}, commit={!r})'.format(
            self._cursor_value,
            self._commit_value,
        )

UploadSessionFinishArg_validator = bv.Struct(UploadSessionFinishArg)

class UploadSessionFinishBatchArg(object):
    """
    :ivar entries: Commit information for each file in the batch.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        Commit information for each file in the batch.

        :rtype: list of [UploadSessionFinishArg]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'UploadSessionFinishBatchArg(entries={!r})'.format(
            self._entries_value,
        )

UploadSessionFinishBatchArg_validator = bv.Struct(UploadSessionFinishBatchArg)

class UploadSessionFinishBatchJobStatus(async.PollResultBase):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadSessionFinishBatchResult complete: The
        upload_session/finish_batch has finished.
    """

    @classmethod
    def complete(cls, val):
        """
        Create an instance of this class set to the ``complete`` tag with value
        ``val``.

        :param UploadSessionFinishBatchResult val:
        :rtype: UploadSessionFinishBatchJobStatus
        """
        return cls('complete', val)

    def is_complete(self):
        """
        Check if the union tag is ``complete``.

        :rtype: bool
        """
        return self._tag == 'complete'

    def get_complete(self):
        """
        The upload_session/finish_batch has finished.

        Only call this if :meth:`is_complete` is true.

        :rtype: UploadSessionFinishBatchResult
        """
        if not self.is_complete():
            raise AttributeError("tag 'complete' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishBatchJobStatus(%r, %r)' % (self._tag, self._value)

UploadSessionFinishBatchJobStatus_validator = bv.Union(UploadSessionFinishBatchJobStatus)

class UploadSessionFinishBatchResult(object):
    """
    :ivar entries: Commit result for each file in the batch.
    """

    __slots__ = [
        '_entries_value',
        '_entries_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 entries=None):
        self._entries_value = None
        self._entries_present = False
        if entries is not None:
            self.entries = entries

    @property
    def entries(self):
        """
        Commit result for each file in the batch.

        :rtype: list of [UploadSessionFinishBatchResultEntry]
        """
        if self._entries_present:
            return self._entries_value
        else:
            raise AttributeError("missing required field 'entries'")

    @entries.setter
    def entries(self, val):
        val = self._entries_validator.validate(val)
        self._entries_value = val
        self._entries_present = True

    @entries.deleter
    def entries(self):
        self._entries_value = None
        self._entries_present = False

    def __repr__(self):
        return 'UploadSessionFinishBatchResult(entries={!r})'.format(
            self._entries_value,
        )

UploadSessionFinishBatchResult_validator = bv.Struct(UploadSessionFinishBatchResult)

class UploadSessionFinishBatchResultEntry(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = None

    @classmethod
    def success(cls, val):
        """
        Create an instance of this class set to the ``success`` tag with value
        ``val``.

        :param FileMetadata val:
        :rtype: UploadSessionFinishBatchResultEntry
        """
        return cls('success', val)

    @classmethod
    def failure(cls, val):
        """
        Create an instance of this class set to the ``failure`` tag with value
        ``val``.

        :param UploadSessionFinishError val:
        :rtype: UploadSessionFinishBatchResultEntry
        """
        return cls('failure', val)

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_failure(self):
        """
        Check if the union tag is ``failure``.

        :rtype: bool
        """
        return self._tag == 'failure'

    def get_success(self):
        """
        Only call this if :meth:`is_success` is true.

        :rtype: FileMetadata
        """
        if not self.is_success():
            raise AttributeError("tag 'success' not set")
        return self._value

    def get_failure(self):
        """
        Only call this if :meth:`is_failure` is true.

        :rtype: UploadSessionFinishError
        """
        if not self.is_failure():
            raise AttributeError("tag 'failure' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishBatchResultEntry(%r, %r)' % (self._tag, self._value)

UploadSessionFinishBatchResultEntry_validator = bv.Union(UploadSessionFinishBatchResultEntry)

class UploadSessionFinishError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UploadSessionLookupError lookup_failed: The session arguments are
        incorrect; the value explains the reason.
    :ivar WriteError path: Unable to save the uploaded contents to a file.
    :ivar too_many_shared_folder_targets: The batch request commits files into
        too many different shared folders. Please limit your batch request to
        files contained in a single shared folder.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    too_many_shared_folder_targets = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def lookup_failed(cls, val):
        """
        Create an instance of this class set to the ``lookup_failed`` tag with
        value ``val``.

        :param UploadSessionLookupError val:
        :rtype: UploadSessionFinishError
        """
        return cls('lookup_failed', val)

    @classmethod
    def path(cls, val):
        """
        Create an instance of this class set to the ``path`` tag with value
        ``val``.

        :param WriteError val:
        :rtype: UploadSessionFinishError
        """
        return cls('path', val)

    def is_lookup_failed(self):
        """
        Check if the union tag is ``lookup_failed``.

        :rtype: bool
        """
        return self._tag == 'lookup_failed'

    def is_path(self):
        """
        Check if the union tag is ``path``.

        :rtype: bool
        """
        return self._tag == 'path'

    def is_too_many_shared_folder_targets(self):
        """
        Check if the union tag is ``too_many_shared_folder_targets``.

        :rtype: bool
        """
        return self._tag == 'too_many_shared_folder_targets'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_lookup_failed(self):
        """
        The session arguments are incorrect; the value explains the reason.

        Only call this if :meth:`is_lookup_failed` is true.

        :rtype: UploadSessionLookupError
        """
        if not self.is_lookup_failed():
            raise AttributeError("tag 'lookup_failed' not set")
        return self._value

    def get_path(self):
        """
        Unable to save the uploaded contents to a file.

        Only call this if :meth:`is_path` is true.

        :rtype: WriteError
        """
        if not self.is_path():
            raise AttributeError("tag 'path' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionFinishError(%r, %r)' % (self._tag, self._value)

UploadSessionFinishError_validator = bv.Union(UploadSessionFinishError)

class UploadSessionLookupError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: The upload session id was not found.
    :ivar UploadSessionOffsetError incorrect_offset: The specified offset was
        incorrect. See the value for the correct offset. (This error may occur
        when a previous request was received and processed successfully but the
        client did not receive the response, e.g. due to a network error.)
    :ivar closed: You are attempting to append data to an upload session that
        has alread been closed (i.e. committed).
    :ivar not_closed: The session must be closed before calling
        upload_session/finish_batch.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    closed = None
    # Attribute is overwritten below the class definition
    not_closed = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def incorrect_offset(cls, val):
        """
        Create an instance of this class set to the ``incorrect_offset`` tag
        with value ``val``.

        :param UploadSessionOffsetError val:
        :rtype: UploadSessionLookupError
        """
        return cls('incorrect_offset', val)

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_incorrect_offset(self):
        """
        Check if the union tag is ``incorrect_offset``.

        :rtype: bool
        """
        return self._tag == 'incorrect_offset'

    def is_closed(self):
        """
        Check if the union tag is ``closed``.

        :rtype: bool
        """
        return self._tag == 'closed'

    def is_not_closed(self):
        """
        Check if the union tag is ``not_closed``.

        :rtype: bool
        """
        return self._tag == 'not_closed'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_incorrect_offset(self):
        """
        The specified offset was incorrect. See the value for the correct
        offset. (This error may occur when a previous request was received and
        processed successfully but the client did not receive the response, e.g.
        due to a network error.)

        Only call this if :meth:`is_incorrect_offset` is true.

        :rtype: UploadSessionOffsetError
        """
        if not self.is_incorrect_offset():
            raise AttributeError("tag 'incorrect_offset' not set")
        return self._value

    def __repr__(self):
        return 'UploadSessionLookupError(%r, %r)' % (self._tag, self._value)

UploadSessionLookupError_validator = bv.Union(UploadSessionLookupError)

class UploadSessionOffsetError(object):
    """
    :ivar correct_offset: The offset up to which data has been collected.
    """

    __slots__ = [
        '_correct_offset_value',
        '_correct_offset_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 correct_offset=None):
        self._correct_offset_value = None
        self._correct_offset_present = False
        if correct_offset is not None:
            self.correct_offset = correct_offset

    @property
    def correct_offset(self):
        """
        The offset up to which data has been collected.

        :rtype: long
        """
        if self._correct_offset_present:
            return self._correct_offset_value
        else:
            raise AttributeError("missing required field 'correct_offset'")

    @correct_offset.setter
    def correct_offset(self, val):
        val = self._correct_offset_validator.validate(val)
        self._correct_offset_value = val
        self._correct_offset_present = True

    @correct_offset.deleter
    def correct_offset(self):
        self._correct_offset_value = None
        self._correct_offset_present = False

    def __repr__(self):
        return 'UploadSessionOffsetError(correct_offset={!r})'.format(
            self._correct_offset_value,
        )

UploadSessionOffsetError_validator = bv.Struct(UploadSessionOffsetError)

class UploadSessionStartArg(object):
    """
    :ivar close: If true, the current session will be closed, at which point you
        won't be able to call upload_session/append_v2 anymore with the current
        session.
    """

    __slots__ = [
        '_close_value',
        '_close_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 close=None):
        self._close_value = None
        self._close_present = False
        if close is not None:
            self.close = close

    @property
    def close(self):
        """
        If true, the current session will be closed, at which point you won't be
        able to call upload_session/append_v2 anymore with the current session.

        :rtype: bool
        """
        if self._close_present:
            return self._close_value
        else:
            return False

    @close.setter
    def close(self, val):
        val = self._close_validator.validate(val)
        self._close_value = val
        self._close_present = True

    @close.deleter
    def close(self):
        self._close_value = None
        self._close_present = False

    def __repr__(self):
        return 'UploadSessionStartArg(close={!r})'.format(
            self._close_value,
        )

UploadSessionStartArg_validator = bv.Struct(UploadSessionStartArg)

class UploadSessionStartResult(object):
    """
    :ivar session_id: A unique identifier for the upload session. Pass this to
        upload_session/append_v2 and upload_session/finish.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 session_id=None):
        self._session_id_value = None
        self._session_id_present = False
        if session_id is not None:
            self.session_id = session_id

    @property
    def session_id(self):
        """
        A unique identifier for the upload session. Pass this to
        upload_session/append_v2 and upload_session/finish.

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            raise AttributeError("missing required field 'session_id'")

    @session_id.setter
    def session_id(self, val):
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    def __repr__(self):
        return 'UploadSessionStartResult(session_id={!r})'.format(
            self._session_id_value,
        )

UploadSessionStartResult_validator = bv.Struct(UploadSessionStartResult)

class UploadWriteFailed(object):
    """
    :ivar reason: The reason why the file couldn't be saved.
    :ivar upload_session_id: The upload session ID; this may be used to retry
        the commit.
    """

    __slots__ = [
        '_reason_value',
        '_reason_present',
        '_upload_session_id_value',
        '_upload_session_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 reason=None,
                 upload_session_id=None):
        self._reason_value = None
        self._reason_present = False
        self._upload_session_id_value = None
        self._upload_session_id_present = False
        if reason is not None:
            self.reason = reason
        if upload_session_id is not None:
            self.upload_session_id = upload_session_id

    @property
    def reason(self):
        """
        The reason why the file couldn't be saved.

        :rtype: WriteError
        """
        if self._reason_present:
            return self._reason_value
        else:
            raise AttributeError("missing required field 'reason'")

    @reason.setter
    def reason(self, val):
        self._reason_validator.validate_type_only(val)
        self._reason_value = val
        self._reason_present = True

    @reason.deleter
    def reason(self):
        self._reason_value = None
        self._reason_present = False

    @property
    def upload_session_id(self):
        """
        The upload session ID; this may be used to retry the commit.

        :rtype: str
        """
        if self._upload_session_id_present:
            return self._upload_session_id_value
        else:
            raise AttributeError("missing required field 'upload_session_id'")

    @upload_session_id.setter
    def upload_session_id(self, val):
        val = self._upload_session_id_validator.validate(val)
        self._upload_session_id_value = val
        self._upload_session_id_present = True

    @upload_session_id.deleter
    def upload_session_id(self):
        self._upload_session_id_value = None
        self._upload_session_id_present = False

    def __repr__(self):
        return 'UploadWriteFailed(reason={!r}, upload_session_id={!r})'.format(
            self._reason_value,
            self._upload_session_id_value,
        )

UploadWriteFailed_validator = bv.Struct(UploadWriteFailed)

class VideoMetadata(MediaMetadata):
    """
    Metadata for a video.

    :ivar duration: The duration of the video in milliseconds.
    """

    __slots__ = [
        '_duration_value',
        '_duration_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 dimensions=None,
                 location=None,
                 time_taken=None,
                 duration=None):
        super(VideoMetadata, self).__init__(dimensions,
                                            location,
                                            time_taken)
        self._duration_value = None
        self._duration_present = False
        if duration is not None:
            self.duration = duration

    @property
    def duration(self):
        """
        The duration of the video in milliseconds.

        :rtype: long
        """
        if self._duration_present:
            return self._duration_value
        else:
            return None

    @duration.setter
    def duration(self, val):
        if val is None:
            del self.duration
            return
        val = self._duration_validator.validate(val)
        self._duration_value = val
        self._duration_present = True

    @duration.deleter
    def duration(self):
        self._duration_value = None
        self._duration_present = False

    def __repr__(self):
        return 'VideoMetadata(dimensions={!r}, location={!r}, time_taken={!r}, duration={!r})'.format(
            self._dimensions_value,
            self._location_value,
            self._time_taken_value,
            self._duration_value,
        )

VideoMetadata_validator = bv.Struct(VideoMetadata)

class WriteConflictError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar file: There's a file in the way.
    :ivar folder: There's a folder in the way.
    :ivar file_ancestor: There's a file at an ancestor path, so we couldn't
        create the required parent folders.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    file = None
    # Attribute is overwritten below the class definition
    folder = None
    # Attribute is overwritten below the class definition
    file_ancestor = None
    # Attribute is overwritten below the class definition
    other = None

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def is_file_ancestor(self):
        """
        Check if the union tag is ``file_ancestor``.

        :rtype: bool
        """
        return self._tag == 'file_ancestor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'WriteConflictError(%r, %r)' % (self._tag, self._value)

WriteConflictError_validator = bv.Union(WriteConflictError)

class WriteError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar WriteConflictError conflict: Couldn't write to the target path because
        there was something in the way.
    :ivar no_write_permission: The user doesn't have permissions to write to the
        target location.
    :ivar insufficient_space: The user doesn't have enough available space
        (bytes) to write more data.
    :ivar disallowed_name: Dropbox will not save the file or folder because of
        its name.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_write_permission = None
    # Attribute is overwritten below the class definition
    insufficient_space = None
    # Attribute is overwritten below the class definition
    disallowed_name = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def malformed_path(cls, val):
        """
        Create an instance of this class set to the ``malformed_path`` tag with
        value ``val``.

        :param Optional[str] val:
        :rtype: WriteError
        """
        return cls('malformed_path', val)

    @classmethod
    def conflict(cls, val):
        """
        Create an instance of this class set to the ``conflict`` tag with value
        ``val``.

        :param WriteConflictError val:
        :rtype: WriteError
        """
        return cls('conflict', val)

    def is_malformed_path(self):
        """
        Check if the union tag is ``malformed_path``.

        :rtype: bool
        """
        return self._tag == 'malformed_path'

    def is_conflict(self):
        """
        Check if the union tag is ``conflict``.

        :rtype: bool
        """
        return self._tag == 'conflict'

    def is_no_write_permission(self):
        """
        Check if the union tag is ``no_write_permission``.

        :rtype: bool
        """
        return self._tag == 'no_write_permission'

    def is_insufficient_space(self):
        """
        Check if the union tag is ``insufficient_space``.

        :rtype: bool
        """
        return self._tag == 'insufficient_space'

    def is_disallowed_name(self):
        """
        Check if the union tag is ``disallowed_name``.

        :rtype: bool
        """
        return self._tag == 'disallowed_name'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_malformed_path(self):
        """
        Only call this if :meth:`is_malformed_path` is true.

        :rtype: Optional[str]
        """
        if not self.is_malformed_path():
            raise AttributeError("tag 'malformed_path' not set")
        return self._value

    def get_conflict(self):
        """
        Couldn't write to the target path because there was something in the
        way.

        Only call this if :meth:`is_conflict` is true.

        :rtype: WriteConflictError
        """
        if not self.is_conflict():
            raise AttributeError("tag 'conflict' not set")
        return self._value

    def __repr__(self):
        return 'WriteError(%r, %r)' % (self._tag, self._value)

WriteError_validator = bv.Union(WriteError)

class WriteMode(bb.Union):
    """
    Your intent when writing a file to some path. This is used to determine what
    constitutes a conflict and what the autorename strategy is. In some
    situations, the conflict behavior is identical: (a) If the target path
    doesn't contain anything, the file is always written; no conflict. (b) If
    the target path contains a folder, it's always a conflict. (c) If the target
    path contains a file with identical contents, nothing gets written; no
    conflict. The conflict checking differs in the case where there's a file at
    the target path with contents different from the contents you're trying to
    write.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar add: Never overwrite the existing file. The autorename strategy is to
        append a number to the file name. For example, "document.txt" might
        become "document (2).txt".
    :ivar overwrite: Always overwrite the existing file. The autorename strategy
        is the same as it is for ``add``.
    :ivar str update: Overwrite if the given "rev" matches the existing file's
        "rev". The autorename strategy is to append the string "conflicted copy"
        to the file name. For example, "document.txt" might become "document
        (conflicted copy).txt" or "document (Panda's conflicted copy).txt".
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    add = None
    # Attribute is overwritten below the class definition
    overwrite = None

    @classmethod
    def update(cls, val):
        """
        Create an instance of this class set to the ``update`` tag with value
        ``val``.

        :param str val:
        :rtype: WriteMode
        """
        return cls('update', val)

    def is_add(self):
        """
        Check if the union tag is ``add``.

        :rtype: bool
        """
        return self._tag == 'add'

    def is_overwrite(self):
        """
        Check if the union tag is ``overwrite``.

        :rtype: bool
        """
        return self._tag == 'overwrite'

    def is_update(self):
        """
        Check if the union tag is ``update``.

        :rtype: bool
        """
        return self._tag == 'update'

    def get_update(self):
        """
        Overwrite if the given "rev" matches the existing file's "rev". The
        autorename strategy is to append the string "conflicted copy" to the
        file name. For example, "document.txt" might become "document
        (conflicted copy).txt" or "document (Panda's conflicted copy).txt".

        Only call this if :meth:`is_update` is true.

        :rtype: str
        """
        if not self.is_update():
            raise AttributeError("tag 'update' not set")
        return self._value

    def __repr__(self):
        return 'WriteMode(%r, %r)' % (self._tag, self._value)

WriteMode_validator = bv.Union(WriteMode)

Id_validator = bv.String(min_length=1)
ListFolderCursor_validator = bv.String(min_length=1)
MalformedPathError_validator = bv.Nullable(bv.String())
Path_validator = bv.String(pattern=u'/(.|[\\r\\n])*')
PathOrId_validator = bv.String(pattern=u'/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)')
PathR_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)?|(ns:[0-9]+(/.*)?)')
ReadPath_validator = bv.String(pattern=u'(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)')
Rev_validator = bv.String(min_length=9, pattern=u'[0-9a-f]+')
WritePath_validator = bv.String(pattern=u'(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)')
PropertiesError._path_validator = LookupError_validator
PropertiesError._tagmap = {
    'path': PropertiesError._path_validator,
}
PropertiesError._tagmap.update(properties.PropertyTemplateError._tagmap)

InvalidPropertyGroupError._property_field_too_large_validator = bv.Void()
InvalidPropertyGroupError._does_not_fit_template_validator = bv.Void()
InvalidPropertyGroupError._tagmap = {
    'property_field_too_large': InvalidPropertyGroupError._property_field_too_large_validator,
    'does_not_fit_template': InvalidPropertyGroupError._does_not_fit_template_validator,
}
InvalidPropertyGroupError._tagmap.update(PropertiesError._tagmap)

InvalidPropertyGroupError.property_field_too_large = InvalidPropertyGroupError('property_field_too_large')
InvalidPropertyGroupError.does_not_fit_template = InvalidPropertyGroupError('does_not_fit_template')

AddPropertiesError._property_group_already_exists_validator = bv.Void()
AddPropertiesError._tagmap = {
    'property_group_already_exists': AddPropertiesError._property_group_already_exists_validator,
}
AddPropertiesError._tagmap.update(InvalidPropertyGroupError._tagmap)

AddPropertiesError.property_group_already_exists = AddPropertiesError('property_group_already_exists')

GetMetadataArg._path_validator = ReadPath_validator
GetMetadataArg._include_media_info_validator = bv.Boolean()
GetMetadataArg._include_deleted_validator = bv.Boolean()
GetMetadataArg._include_has_explicit_shared_members_validator = bv.Boolean()
GetMetadataArg._all_field_names_ = set([
    'path',
    'include_media_info',
    'include_deleted',
    'include_has_explicit_shared_members',
])
GetMetadataArg._all_fields_ = [
    ('path', GetMetadataArg._path_validator),
    ('include_media_info', GetMetadataArg._include_media_info_validator),
    ('include_deleted', GetMetadataArg._include_deleted_validator),
    ('include_has_explicit_shared_members', GetMetadataArg._include_has_explicit_shared_members_validator),
]

AlphaGetMetadataArg._include_property_templates_validator = bv.Nullable(bv.List(properties.TemplateId_validator))
AlphaGetMetadataArg._all_field_names_ = GetMetadataArg._all_field_names_.union(set(['include_property_templates']))
AlphaGetMetadataArg._all_fields_ = GetMetadataArg._all_fields_ + [('include_property_templates', AlphaGetMetadataArg._include_property_templates_validator)]

GetMetadataError._path_validator = LookupError_validator
GetMetadataError._tagmap = {
    'path': GetMetadataError._path_validator,
}

AlphaGetMetadataError._properties_error_validator = LookUpPropertiesError_validator
AlphaGetMetadataError._tagmap = {
    'properties_error': AlphaGetMetadataError._properties_error_validator,
}
AlphaGetMetadataError._tagmap.update(GetMetadataError._tagmap)

CommitInfo._path_validator = WritePath_validator
CommitInfo._mode_validator = WriteMode_validator
CommitInfo._autorename_validator = bv.Boolean()
CommitInfo._client_modified_validator = bv.Nullable(common.DropboxTimestamp_validator)
CommitInfo._mute_validator = bv.Boolean()
CommitInfo._all_field_names_ = set([
    'path',
    'mode',
    'autorename',
    'client_modified',
    'mute',
])
CommitInfo._all_fields_ = [
    ('path', CommitInfo._path_validator),
    ('mode', CommitInfo._mode_validator),
    ('autorename', CommitInfo._autorename_validator),
    ('client_modified', CommitInfo._client_modified_validator),
    ('mute', CommitInfo._mute_validator),
]

CommitInfoWithProperties._property_groups_validator = bv.Nullable(bv.List(properties.PropertyGroup_validator))
CommitInfoWithProperties._all_field_names_ = CommitInfo._all_field_names_.union(set(['property_groups']))
CommitInfoWithProperties._all_fields_ = CommitInfo._all_fields_ + [('property_groups', CommitInfoWithProperties._property_groups_validator)]

CreateFolderArg._path_validator = WritePath_validator
CreateFolderArg._all_field_names_ = set(['path'])
CreateFolderArg._all_fields_ = [('path', CreateFolderArg._path_validator)]

CreateFolderError._path_validator = WriteError_validator
CreateFolderError._tagmap = {
    'path': CreateFolderError._path_validator,
}

DeleteArg._path_validator = WritePath_validator
DeleteArg._all_field_names_ = set(['path'])
DeleteArg._all_fields_ = [('path', DeleteArg._path_validator)]

DeleteError._path_lookup_validator = LookupError_validator
DeleteError._path_write_validator = WriteError_validator
DeleteError._other_validator = bv.Void()
DeleteError._tagmap = {
    'path_lookup': DeleteError._path_lookup_validator,
    'path_write': DeleteError._path_write_validator,
    'other': DeleteError._other_validator,
}

DeleteError.other = DeleteError('other')

Metadata._name_validator = bv.String()
Metadata._path_lower_validator = bv.Nullable(bv.String())
Metadata._path_display_validator = bv.Nullable(bv.String())
Metadata._parent_shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
Metadata._field_names_ = set([
    'name',
    'path_lower',
    'path_display',
    'parent_shared_folder_id',
])
Metadata._all_field_names_ = Metadata._field_names_
Metadata._fields_ = [
    ('name', Metadata._name_validator),
    ('path_lower', Metadata._path_lower_validator),
    ('path_display', Metadata._path_display_validator),
    ('parent_shared_folder_id', Metadata._parent_shared_folder_id_validator),
]
Metadata._all_fields_ = Metadata._fields_

Metadata._tag_to_subtype_ = {
    (u'file',): FileMetadata_validator,
    (u'folder',): FolderMetadata_validator,
    (u'deleted',): DeletedMetadata_validator,
}
Metadata._pytype_to_tag_and_subtype_ = {
    FileMetadata: ((u'file',), FileMetadata_validator),
    FolderMetadata: ((u'folder',), FolderMetadata_validator),
    DeletedMetadata: ((u'deleted',), DeletedMetadata_validator),
}
Metadata._is_catch_all_ = False

DeletedMetadata._field_names_ = set([])
DeletedMetadata._all_field_names_ = Metadata._all_field_names_.union(DeletedMetadata._field_names_)
DeletedMetadata._fields_ = []
DeletedMetadata._all_fields_ = Metadata._all_fields_ + DeletedMetadata._fields_

Dimensions._height_validator = bv.UInt64()
Dimensions._width_validator = bv.UInt64()
Dimensions._all_field_names_ = set([
    'height',
    'width',
])
Dimensions._all_fields_ = [
    ('height', Dimensions._height_validator),
    ('width', Dimensions._width_validator),
]

DownloadArg._path_validator = ReadPath_validator
DownloadArg._rev_validator = bv.Nullable(Rev_validator)
DownloadArg._all_field_names_ = set([
    'path',
    'rev',
])
DownloadArg._all_fields_ = [
    ('path', DownloadArg._path_validator),
    ('rev', DownloadArg._rev_validator),
]

DownloadError._path_validator = LookupError_validator
DownloadError._other_validator = bv.Void()
DownloadError._tagmap = {
    'path': DownloadError._path_validator,
    'other': DownloadError._other_validator,
}

DownloadError.other = DownloadError('other')

FileMetadata._id_validator = Id_validator
FileMetadata._client_modified_validator = common.DropboxTimestamp_validator
FileMetadata._server_modified_validator = common.DropboxTimestamp_validator
FileMetadata._rev_validator = Rev_validator
FileMetadata._size_validator = bv.UInt64()
FileMetadata._media_info_validator = bv.Nullable(MediaInfo_validator)
FileMetadata._sharing_info_validator = bv.Nullable(FileSharingInfo_validator)
FileMetadata._property_groups_validator = bv.Nullable(bv.List(properties.PropertyGroup_validator))
FileMetadata._has_explicit_shared_members_validator = bv.Nullable(bv.Boolean())
FileMetadata._field_names_ = set([
    'id',
    'client_modified',
    'server_modified',
    'rev',
    'size',
    'media_info',
    'sharing_info',
    'property_groups',
    'has_explicit_shared_members',
])
FileMetadata._all_field_names_ = Metadata._all_field_names_.union(FileMetadata._field_names_)
FileMetadata._fields_ = [
    ('id', FileMetadata._id_validator),
    ('client_modified', FileMetadata._client_modified_validator),
    ('server_modified', FileMetadata._server_modified_validator),
    ('rev', FileMetadata._rev_validator),
    ('size', FileMetadata._size_validator),
    ('media_info', FileMetadata._media_info_validator),
    ('sharing_info', FileMetadata._sharing_info_validator),
    ('property_groups', FileMetadata._property_groups_validator),
    ('has_explicit_shared_members', FileMetadata._has_explicit_shared_members_validator),
]
FileMetadata._all_fields_ = Metadata._all_fields_ + FileMetadata._fields_

SharingInfo._read_only_validator = bv.Boolean()
SharingInfo._all_field_names_ = set(['read_only'])
SharingInfo._all_fields_ = [('read_only', SharingInfo._read_only_validator)]

FileSharingInfo._parent_shared_folder_id_validator = common.SharedFolderId_validator
FileSharingInfo._modified_by_validator = bv.Nullable(users.AccountId_validator)
FileSharingInfo._all_field_names_ = SharingInfo._all_field_names_.union(set([
    'parent_shared_folder_id',
    'modified_by',
]))
FileSharingInfo._all_fields_ = SharingInfo._all_fields_ + [
    ('parent_shared_folder_id', FileSharingInfo._parent_shared_folder_id_validator),
    ('modified_by', FileSharingInfo._modified_by_validator),
]

FolderMetadata._id_validator = Id_validator
FolderMetadata._shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderMetadata._sharing_info_validator = bv.Nullable(FolderSharingInfo_validator)
FolderMetadata._property_groups_validator = bv.Nullable(bv.List(properties.PropertyGroup_validator))
FolderMetadata._field_names_ = set([
    'id',
    'shared_folder_id',
    'sharing_info',
    'property_groups',
])
FolderMetadata._all_field_names_ = Metadata._all_field_names_.union(FolderMetadata._field_names_)
FolderMetadata._fields_ = [
    ('id', FolderMetadata._id_validator),
    ('shared_folder_id', FolderMetadata._shared_folder_id_validator),
    ('sharing_info', FolderMetadata._sharing_info_validator),
    ('property_groups', FolderMetadata._property_groups_validator),
]
FolderMetadata._all_fields_ = Metadata._all_fields_ + FolderMetadata._fields_

FolderSharingInfo._parent_shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderSharingInfo._shared_folder_id_validator = bv.Nullable(common.SharedFolderId_validator)
FolderSharingInfo._all_field_names_ = SharingInfo._all_field_names_.union(set([
    'parent_shared_folder_id',
    'shared_folder_id',
]))
FolderSharingInfo._all_fields_ = SharingInfo._all_fields_ + [
    ('parent_shared_folder_id', FolderSharingInfo._parent_shared_folder_id_validator),
    ('shared_folder_id', FolderSharingInfo._shared_folder_id_validator),
]

GetCopyReferenceArg._path_validator = ReadPath_validator
GetCopyReferenceArg._all_field_names_ = set(['path'])
GetCopyReferenceArg._all_fields_ = [('path', GetCopyReferenceArg._path_validator)]

GetCopyReferenceError._path_validator = LookupError_validator
GetCopyReferenceError._other_validator = bv.Void()
GetCopyReferenceError._tagmap = {
    'path': GetCopyReferenceError._path_validator,
    'other': GetCopyReferenceError._other_validator,
}

GetCopyReferenceError.other = GetCopyReferenceError('other')

GetCopyReferenceResult._metadata_validator = Metadata_validator
GetCopyReferenceResult._copy_reference_validator = bv.String()
GetCopyReferenceResult._expires_validator = common.DropboxTimestamp_validator
GetCopyReferenceResult._all_field_names_ = set([
    'metadata',
    'copy_reference',
    'expires',
])
GetCopyReferenceResult._all_fields_ = [
    ('metadata', GetCopyReferenceResult._metadata_validator),
    ('copy_reference', GetCopyReferenceResult._copy_reference_validator),
    ('expires', GetCopyReferenceResult._expires_validator),
]

GetTemporaryLinkArg._path_validator = ReadPath_validator
GetTemporaryLinkArg._all_field_names_ = set(['path'])
GetTemporaryLinkArg._all_fields_ = [('path', GetTemporaryLinkArg._path_validator)]

GetTemporaryLinkError._path_validator = LookupError_validator
GetTemporaryLinkError._other_validator = bv.Void()
GetTemporaryLinkError._tagmap = {
    'path': GetTemporaryLinkError._path_validator,
    'other': GetTemporaryLinkError._other_validator,
}

GetTemporaryLinkError.other = GetTemporaryLinkError('other')

GetTemporaryLinkResult._metadata_validator = FileMetadata_validator
GetTemporaryLinkResult._link_validator = bv.String()
GetTemporaryLinkResult._all_field_names_ = set([
    'metadata',
    'link',
])
GetTemporaryLinkResult._all_fields_ = [
    ('metadata', GetTemporaryLinkResult._metadata_validator),
    ('link', GetTemporaryLinkResult._link_validator),
]

GpsCoordinates._latitude_validator = bv.Float64()
GpsCoordinates._longitude_validator = bv.Float64()
GpsCoordinates._all_field_names_ = set([
    'latitude',
    'longitude',
])
GpsCoordinates._all_fields_ = [
    ('latitude', GpsCoordinates._latitude_validator),
    ('longitude', GpsCoordinates._longitude_validator),
]

ListFolderArg._path_validator = PathR_validator
ListFolderArg._recursive_validator = bv.Boolean()
ListFolderArg._include_media_info_validator = bv.Boolean()
ListFolderArg._include_deleted_validator = bv.Boolean()
ListFolderArg._include_has_explicit_shared_members_validator = bv.Boolean()
ListFolderArg._all_field_names_ = set([
    'path',
    'recursive',
    'include_media_info',
    'include_deleted',
    'include_has_explicit_shared_members',
])
ListFolderArg._all_fields_ = [
    ('path', ListFolderArg._path_validator),
    ('recursive', ListFolderArg._recursive_validator),
    ('include_media_info', ListFolderArg._include_media_info_validator),
    ('include_deleted', ListFolderArg._include_deleted_validator),
    ('include_has_explicit_shared_members', ListFolderArg._include_has_explicit_shared_members_validator),
]

ListFolderContinueArg._cursor_validator = ListFolderCursor_validator
ListFolderContinueArg._all_field_names_ = set(['cursor'])
ListFolderContinueArg._all_fields_ = [('cursor', ListFolderContinueArg._cursor_validator)]

ListFolderContinueError._path_validator = LookupError_validator
ListFolderContinueError._reset_validator = bv.Void()
ListFolderContinueError._other_validator = bv.Void()
ListFolderContinueError._tagmap = {
    'path': ListFolderContinueError._path_validator,
    'reset': ListFolderContinueError._reset_validator,
    'other': ListFolderContinueError._other_validator,
}

ListFolderContinueError.reset = ListFolderContinueError('reset')
ListFolderContinueError.other = ListFolderContinueError('other')

ListFolderError._path_validator = LookupError_validator
ListFolderError._other_validator = bv.Void()
ListFolderError._tagmap = {
    'path': ListFolderError._path_validator,
    'other': ListFolderError._other_validator,
}

ListFolderError.other = ListFolderError('other')

ListFolderGetLatestCursorResult._cursor_validator = ListFolderCursor_validator
ListFolderGetLatestCursorResult._all_field_names_ = set(['cursor'])
ListFolderGetLatestCursorResult._all_fields_ = [('cursor', ListFolderGetLatestCursorResult._cursor_validator)]

ListFolderLongpollArg._cursor_validator = ListFolderCursor_validator
ListFolderLongpollArg._timeout_validator = bv.UInt64(min_value=30, max_value=480)
ListFolderLongpollArg._all_field_names_ = set([
    'cursor',
    'timeout',
])
ListFolderLongpollArg._all_fields_ = [
    ('cursor', ListFolderLongpollArg._cursor_validator),
    ('timeout', ListFolderLongpollArg._timeout_validator),
]

ListFolderLongpollError._reset_validator = bv.Void()
ListFolderLongpollError._other_validator = bv.Void()
ListFolderLongpollError._tagmap = {
    'reset': ListFolderLongpollError._reset_validator,
    'other': ListFolderLongpollError._other_validator,
}

ListFolderLongpollError.reset = ListFolderLongpollError('reset')
ListFolderLongpollError.other = ListFolderLongpollError('other')

ListFolderLongpollResult._changes_validator = bv.Boolean()
ListFolderLongpollResult._backoff_validator = bv.Nullable(bv.UInt64())
ListFolderLongpollResult._all_field_names_ = set([
    'changes',
    'backoff',
])
ListFolderLongpollResult._all_fields_ = [
    ('changes', ListFolderLongpollResult._changes_validator),
    ('backoff', ListFolderLongpollResult._backoff_validator),
]

ListFolderResult._entries_validator = bv.List(Metadata_validator)
ListFolderResult._cursor_validator = ListFolderCursor_validator
ListFolderResult._has_more_validator = bv.Boolean()
ListFolderResult._all_field_names_ = set([
    'entries',
    'cursor',
    'has_more',
])
ListFolderResult._all_fields_ = [
    ('entries', ListFolderResult._entries_validator),
    ('cursor', ListFolderResult._cursor_validator),
    ('has_more', ListFolderResult._has_more_validator),
]

ListRevisionsArg._path_validator = PathOrId_validator
ListRevisionsArg._limit_validator = bv.UInt64(min_value=1, max_value=100)
ListRevisionsArg._all_field_names_ = set([
    'path',
    'limit',
])
ListRevisionsArg._all_fields_ = [
    ('path', ListRevisionsArg._path_validator),
    ('limit', ListRevisionsArg._limit_validator),
]

ListRevisionsError._path_validator = LookupError_validator
ListRevisionsError._other_validator = bv.Void()
ListRevisionsError._tagmap = {
    'path': ListRevisionsError._path_validator,
    'other': ListRevisionsError._other_validator,
}

ListRevisionsError.other = ListRevisionsError('other')

ListRevisionsResult._is_deleted_validator = bv.Boolean()
ListRevisionsResult._entries_validator = bv.List(FileMetadata_validator)
ListRevisionsResult._all_field_names_ = set([
    'is_deleted',
    'entries',
])
ListRevisionsResult._all_fields_ = [
    ('is_deleted', ListRevisionsResult._is_deleted_validator),
    ('entries', ListRevisionsResult._entries_validator),
]

LookUpPropertiesError._property_group_not_found_validator = bv.Void()
LookUpPropertiesError._tagmap = {
    'property_group_not_found': LookUpPropertiesError._property_group_not_found_validator,
}

LookUpPropertiesError.property_group_not_found = LookUpPropertiesError('property_group_not_found')

LookupError._malformed_path_validator = MalformedPathError_validator
LookupError._not_found_validator = bv.Void()
LookupError._not_file_validator = bv.Void()
LookupError._not_folder_validator = bv.Void()
LookupError._restricted_content_validator = bv.Void()
LookupError._other_validator = bv.Void()
LookupError._tagmap = {
    'malformed_path': LookupError._malformed_path_validator,
    'not_found': LookupError._not_found_validator,
    'not_file': LookupError._not_file_validator,
    'not_folder': LookupError._not_folder_validator,
    'restricted_content': LookupError._restricted_content_validator,
    'other': LookupError._other_validator,
}

LookupError.not_found = LookupError('not_found')
LookupError.not_file = LookupError('not_file')
LookupError.not_folder = LookupError('not_folder')
LookupError.restricted_content = LookupError('restricted_content')
LookupError.other = LookupError('other')

MediaInfo._pending_validator = bv.Void()
MediaInfo._metadata_validator = MediaMetadata_validator
MediaInfo._tagmap = {
    'pending': MediaInfo._pending_validator,
    'metadata': MediaInfo._metadata_validator,
}

MediaInfo.pending = MediaInfo('pending')

MediaMetadata._dimensions_validator = bv.Nullable(Dimensions_validator)
MediaMetadata._location_validator = bv.Nullable(GpsCoordinates_validator)
MediaMetadata._time_taken_validator = bv.Nullable(common.DropboxTimestamp_validator)
MediaMetadata._field_names_ = set([
    'dimensions',
    'location',
    'time_taken',
])
MediaMetadata._all_field_names_ = MediaMetadata._field_names_
MediaMetadata._fields_ = [
    ('dimensions', MediaMetadata._dimensions_validator),
    ('location', MediaMetadata._location_validator),
    ('time_taken', MediaMetadata._time_taken_validator),
]
MediaMetadata._all_fields_ = MediaMetadata._fields_

MediaMetadata._tag_to_subtype_ = {
    (u'photo',): PhotoMetadata_validator,
    (u'video',): VideoMetadata_validator,
}
MediaMetadata._pytype_to_tag_and_subtype_ = {
    PhotoMetadata: ((u'photo',), PhotoMetadata_validator),
    VideoMetadata: ((u'video',), VideoMetadata_validator),
}
MediaMetadata._is_catch_all_ = False

PhotoMetadata._field_names_ = set([])
PhotoMetadata._all_field_names_ = MediaMetadata._all_field_names_.union(PhotoMetadata._field_names_)
PhotoMetadata._fields_ = []
PhotoMetadata._all_fields_ = MediaMetadata._all_fields_ + PhotoMetadata._fields_

PreviewArg._path_validator = ReadPath_validator
PreviewArg._rev_validator = bv.Nullable(Rev_validator)
PreviewArg._all_field_names_ = set([
    'path',
    'rev',
])
PreviewArg._all_fields_ = [
    ('path', PreviewArg._path_validator),
    ('rev', PreviewArg._rev_validator),
]

PreviewError._path_validator = LookupError_validator
PreviewError._in_progress_validator = bv.Void()
PreviewError._unsupported_extension_validator = bv.Void()
PreviewError._unsupported_content_validator = bv.Void()
PreviewError._tagmap = {
    'path': PreviewError._path_validator,
    'in_progress': PreviewError._in_progress_validator,
    'unsupported_extension': PreviewError._unsupported_extension_validator,
    'unsupported_content': PreviewError._unsupported_content_validator,
}

PreviewError.in_progress = PreviewError('in_progress')
PreviewError.unsupported_extension = PreviewError('unsupported_extension')
PreviewError.unsupported_content = PreviewError('unsupported_content')

PropertyGroupUpdate._template_id_validator = properties.TemplateId_validator
PropertyGroupUpdate._add_or_update_fields_validator = bv.Nullable(bv.List(properties.PropertyField_validator))
PropertyGroupUpdate._remove_fields_validator = bv.Nullable(bv.List(bv.String()))
PropertyGroupUpdate._all_field_names_ = set([
    'template_id',
    'add_or_update_fields',
    'remove_fields',
])
PropertyGroupUpdate._all_fields_ = [
    ('template_id', PropertyGroupUpdate._template_id_validator),
    ('add_or_update_fields', PropertyGroupUpdate._add_or_update_fields_validator),
    ('remove_fields', PropertyGroupUpdate._remove_fields_validator),
]

PropertyGroupWithPath._path_validator = PathOrId_validator
PropertyGroupWithPath._property_groups_validator = bv.List(properties.PropertyGroup_validator)
PropertyGroupWithPath._all_field_names_ = set([
    'path',
    'property_groups',
])
PropertyGroupWithPath._all_fields_ = [
    ('path', PropertyGroupWithPath._path_validator),
    ('property_groups', PropertyGroupWithPath._property_groups_validator),
]

RelocationArg._from_path_validator = WritePath_validator
RelocationArg._to_path_validator = WritePath_validator
RelocationArg._all_field_names_ = set([
    'from_path',
    'to_path',
])
RelocationArg._all_fields_ = [
    ('from_path', RelocationArg._from_path_validator),
    ('to_path', RelocationArg._to_path_validator),
]

RelocationError._from_lookup_validator = LookupError_validator
RelocationError._from_write_validator = WriteError_validator
RelocationError._to_validator = WriteError_validator
RelocationError._cant_copy_shared_folder_validator = bv.Void()
RelocationError._cant_nest_shared_folder_validator = bv.Void()
RelocationError._cant_move_folder_into_itself_validator = bv.Void()
RelocationError._too_many_files_validator = bv.Void()
RelocationError._other_validator = bv.Void()
RelocationError._tagmap = {
    'from_lookup': RelocationError._from_lookup_validator,
    'from_write': RelocationError._from_write_validator,
    'to': RelocationError._to_validator,
    'cant_copy_shared_folder': RelocationError._cant_copy_shared_folder_validator,
    'cant_nest_shared_folder': RelocationError._cant_nest_shared_folder_validator,
    'cant_move_folder_into_itself': RelocationError._cant_move_folder_into_itself_validator,
    'too_many_files': RelocationError._too_many_files_validator,
    'other': RelocationError._other_validator,
}

RelocationError.cant_copy_shared_folder = RelocationError('cant_copy_shared_folder')
RelocationError.cant_nest_shared_folder = RelocationError('cant_nest_shared_folder')
RelocationError.cant_move_folder_into_itself = RelocationError('cant_move_folder_into_itself')
RelocationError.too_many_files = RelocationError('too_many_files')
RelocationError.other = RelocationError('other')

RemovePropertiesArg._path_validator = PathOrId_validator
RemovePropertiesArg._property_template_ids_validator = bv.List(properties.TemplateId_validator)
RemovePropertiesArg._all_field_names_ = set([
    'path',
    'property_template_ids',
])
RemovePropertiesArg._all_fields_ = [
    ('path', RemovePropertiesArg._path_validator),
    ('property_template_ids', RemovePropertiesArg._property_template_ids_validator),
]

RemovePropertiesError._property_group_lookup_validator = LookUpPropertiesError_validator
RemovePropertiesError._tagmap = {
    'property_group_lookup': RemovePropertiesError._property_group_lookup_validator,
}
RemovePropertiesError._tagmap.update(PropertiesError._tagmap)

RestoreArg._path_validator = WritePath_validator
RestoreArg._rev_validator = Rev_validator
RestoreArg._all_field_names_ = set([
    'path',
    'rev',
])
RestoreArg._all_fields_ = [
    ('path', RestoreArg._path_validator),
    ('rev', RestoreArg._rev_validator),
]

RestoreError._path_lookup_validator = LookupError_validator
RestoreError._path_write_validator = WriteError_validator
RestoreError._invalid_revision_validator = bv.Void()
RestoreError._other_validator = bv.Void()
RestoreError._tagmap = {
    'path_lookup': RestoreError._path_lookup_validator,
    'path_write': RestoreError._path_write_validator,
    'invalid_revision': RestoreError._invalid_revision_validator,
    'other': RestoreError._other_validator,
}

RestoreError.invalid_revision = RestoreError('invalid_revision')
RestoreError.other = RestoreError('other')

SaveCopyReferenceArg._copy_reference_validator = bv.String()
SaveCopyReferenceArg._path_validator = Path_validator
SaveCopyReferenceArg._all_field_names_ = set([
    'copy_reference',
    'path',
])
SaveCopyReferenceArg._all_fields_ = [
    ('copy_reference', SaveCopyReferenceArg._copy_reference_validator),
    ('path', SaveCopyReferenceArg._path_validator),
]

SaveCopyReferenceError._path_validator = WriteError_validator
SaveCopyReferenceError._invalid_copy_reference_validator = bv.Void()
SaveCopyReferenceError._no_permission_validator = bv.Void()
SaveCopyReferenceError._not_found_validator = bv.Void()
SaveCopyReferenceError._too_many_files_validator = bv.Void()
SaveCopyReferenceError._other_validator = bv.Void()
SaveCopyReferenceError._tagmap = {
    'path': SaveCopyReferenceError._path_validator,
    'invalid_copy_reference': SaveCopyReferenceError._invalid_copy_reference_validator,
    'no_permission': SaveCopyReferenceError._no_permission_validator,
    'not_found': SaveCopyReferenceError._not_found_validator,
    'too_many_files': SaveCopyReferenceError._too_many_files_validator,
    'other': SaveCopyReferenceError._other_validator,
}

SaveCopyReferenceError.invalid_copy_reference = SaveCopyReferenceError('invalid_copy_reference')
SaveCopyReferenceError.no_permission = SaveCopyReferenceError('no_permission')
SaveCopyReferenceError.not_found = SaveCopyReferenceError('not_found')
SaveCopyReferenceError.too_many_files = SaveCopyReferenceError('too_many_files')
SaveCopyReferenceError.other = SaveCopyReferenceError('other')

SaveCopyReferenceResult._metadata_validator = Metadata_validator
SaveCopyReferenceResult._all_field_names_ = set(['metadata'])
SaveCopyReferenceResult._all_fields_ = [('metadata', SaveCopyReferenceResult._metadata_validator)]

SaveUrlArg._path_validator = Path_validator
SaveUrlArg._url_validator = bv.String()
SaveUrlArg._all_field_names_ = set([
    'path',
    'url',
])
SaveUrlArg._all_fields_ = [
    ('path', SaveUrlArg._path_validator),
    ('url', SaveUrlArg._url_validator),
]

SaveUrlError._path_validator = WriteError_validator
SaveUrlError._download_failed_validator = bv.Void()
SaveUrlError._invalid_url_validator = bv.Void()
SaveUrlError._not_found_validator = bv.Void()
SaveUrlError._other_validator = bv.Void()
SaveUrlError._tagmap = {
    'path': SaveUrlError._path_validator,
    'download_failed': SaveUrlError._download_failed_validator,
    'invalid_url': SaveUrlError._invalid_url_validator,
    'not_found': SaveUrlError._not_found_validator,
    'other': SaveUrlError._other_validator,
}

SaveUrlError.download_failed = SaveUrlError('download_failed')
SaveUrlError.invalid_url = SaveUrlError('invalid_url')
SaveUrlError.not_found = SaveUrlError('not_found')
SaveUrlError.other = SaveUrlError('other')

SaveUrlJobStatus._complete_validator = FileMetadata_validator
SaveUrlJobStatus._failed_validator = SaveUrlError_validator
SaveUrlJobStatus._tagmap = {
    'complete': SaveUrlJobStatus._complete_validator,
    'failed': SaveUrlJobStatus._failed_validator,
}
SaveUrlJobStatus._tagmap.update(async.PollResultBase._tagmap)

SaveUrlResult._complete_validator = FileMetadata_validator
SaveUrlResult._tagmap = {
    'complete': SaveUrlResult._complete_validator,
}
SaveUrlResult._tagmap.update(async.LaunchResultBase._tagmap)

SearchArg._path_validator = PathR_validator
SearchArg._query_validator = bv.String()
SearchArg._start_validator = bv.UInt64()
SearchArg._max_results_validator = bv.UInt64(min_value=1, max_value=1000)
SearchArg._mode_validator = SearchMode_validator
SearchArg._all_field_names_ = set([
    'path',
    'query',
    'start',
    'max_results',
    'mode',
])
SearchArg._all_fields_ = [
    ('path', SearchArg._path_validator),
    ('query', SearchArg._query_validator),
    ('start', SearchArg._start_validator),
    ('max_results', SearchArg._max_results_validator),
    ('mode', SearchArg._mode_validator),
]

SearchError._path_validator = LookupError_validator
SearchError._other_validator = bv.Void()
SearchError._tagmap = {
    'path': SearchError._path_validator,
    'other': SearchError._other_validator,
}

SearchError.other = SearchError('other')

SearchMatch._match_type_validator = SearchMatchType_validator
SearchMatch._metadata_validator = Metadata_validator
SearchMatch._all_field_names_ = set([
    'match_type',
    'metadata',
])
SearchMatch._all_fields_ = [
    ('match_type', SearchMatch._match_type_validator),
    ('metadata', SearchMatch._metadata_validator),
]

SearchMatchType._filename_validator = bv.Void()
SearchMatchType._content_validator = bv.Void()
SearchMatchType._both_validator = bv.Void()
SearchMatchType._tagmap = {
    'filename': SearchMatchType._filename_validator,
    'content': SearchMatchType._content_validator,
    'both': SearchMatchType._both_validator,
}

SearchMatchType.filename = SearchMatchType('filename')
SearchMatchType.content = SearchMatchType('content')
SearchMatchType.both = SearchMatchType('both')

SearchMode._filename_validator = bv.Void()
SearchMode._filename_and_content_validator = bv.Void()
SearchMode._deleted_filename_validator = bv.Void()
SearchMode._tagmap = {
    'filename': SearchMode._filename_validator,
    'filename_and_content': SearchMode._filename_and_content_validator,
    'deleted_filename': SearchMode._deleted_filename_validator,
}

SearchMode.filename = SearchMode('filename')
SearchMode.filename_and_content = SearchMode('filename_and_content')
SearchMode.deleted_filename = SearchMode('deleted_filename')

SearchResult._matches_validator = bv.List(SearchMatch_validator)
SearchResult._more_validator = bv.Boolean()
SearchResult._start_validator = bv.UInt64()
SearchResult._all_field_names_ = set([
    'matches',
    'more',
    'start',
])
SearchResult._all_fields_ = [
    ('matches', SearchResult._matches_validator),
    ('more', SearchResult._more_validator),
    ('start', SearchResult._start_validator),
]

ThumbnailArg._path_validator = ReadPath_validator
ThumbnailArg._format_validator = ThumbnailFormat_validator
ThumbnailArg._size_validator = ThumbnailSize_validator
ThumbnailArg._all_field_names_ = set([
    'path',
    'format',
    'size',
])
ThumbnailArg._all_fields_ = [
    ('path', ThumbnailArg._path_validator),
    ('format', ThumbnailArg._format_validator),
    ('size', ThumbnailArg._size_validator),
]

ThumbnailError._path_validator = LookupError_validator
ThumbnailError._unsupported_extension_validator = bv.Void()
ThumbnailError._unsupported_image_validator = bv.Void()
ThumbnailError._conversion_error_validator = bv.Void()
ThumbnailError._tagmap = {
    'path': ThumbnailError._path_validator,
    'unsupported_extension': ThumbnailError._unsupported_extension_validator,
    'unsupported_image': ThumbnailError._unsupported_image_validator,
    'conversion_error': ThumbnailError._conversion_error_validator,
}

ThumbnailError.unsupported_extension = ThumbnailError('unsupported_extension')
ThumbnailError.unsupported_image = ThumbnailError('unsupported_image')
ThumbnailError.conversion_error = ThumbnailError('conversion_error')

ThumbnailFormat._jpeg_validator = bv.Void()
ThumbnailFormat._png_validator = bv.Void()
ThumbnailFormat._tagmap = {
    'jpeg': ThumbnailFormat._jpeg_validator,
    'png': ThumbnailFormat._png_validator,
}

ThumbnailFormat.jpeg = ThumbnailFormat('jpeg')
ThumbnailFormat.png = ThumbnailFormat('png')

ThumbnailSize._w32h32_validator = bv.Void()
ThumbnailSize._w64h64_validator = bv.Void()
ThumbnailSize._w128h128_validator = bv.Void()
ThumbnailSize._w640h480_validator = bv.Void()
ThumbnailSize._w1024h768_validator = bv.Void()
ThumbnailSize._tagmap = {
    'w32h32': ThumbnailSize._w32h32_validator,
    'w64h64': ThumbnailSize._w64h64_validator,
    'w128h128': ThumbnailSize._w128h128_validator,
    'w640h480': ThumbnailSize._w640h480_validator,
    'w1024h768': ThumbnailSize._w1024h768_validator,
}

ThumbnailSize.w32h32 = ThumbnailSize('w32h32')
ThumbnailSize.w64h64 = ThumbnailSize('w64h64')
ThumbnailSize.w128h128 = ThumbnailSize('w128h128')
ThumbnailSize.w640h480 = ThumbnailSize('w640h480')
ThumbnailSize.w1024h768 = ThumbnailSize('w1024h768')

UpdatePropertiesError._property_group_lookup_validator = LookUpPropertiesError_validator
UpdatePropertiesError._tagmap = {
    'property_group_lookup': UpdatePropertiesError._property_group_lookup_validator,
}
UpdatePropertiesError._tagmap.update(InvalidPropertyGroupError._tagmap)

UpdatePropertyGroupArg._path_validator = PathOrId_validator
UpdatePropertyGroupArg._update_property_groups_validator = bv.List(PropertyGroupUpdate_validator)
UpdatePropertyGroupArg._all_field_names_ = set([
    'path',
    'update_property_groups',
])
UpdatePropertyGroupArg._all_fields_ = [
    ('path', UpdatePropertyGroupArg._path_validator),
    ('update_property_groups', UpdatePropertyGroupArg._update_property_groups_validator),
]

UploadError._path_validator = UploadWriteFailed_validator
UploadError._other_validator = bv.Void()
UploadError._tagmap = {
    'path': UploadError._path_validator,
    'other': UploadError._other_validator,
}

UploadError.other = UploadError('other')

UploadErrorWithProperties._properties_error_validator = InvalidPropertyGroupError_validator
UploadErrorWithProperties._tagmap = {
    'properties_error': UploadErrorWithProperties._properties_error_validator,
}
UploadErrorWithProperties._tagmap.update(UploadError._tagmap)

UploadSessionAppendArg._cursor_validator = UploadSessionCursor_validator
UploadSessionAppendArg._close_validator = bv.Boolean()
UploadSessionAppendArg._all_field_names_ = set([
    'cursor',
    'close',
])
UploadSessionAppendArg._all_fields_ = [
    ('cursor', UploadSessionAppendArg._cursor_validator),
    ('close', UploadSessionAppendArg._close_validator),
]

UploadSessionCursor._session_id_validator = bv.String()
UploadSessionCursor._offset_validator = bv.UInt64()
UploadSessionCursor._all_field_names_ = set([
    'session_id',
    'offset',
])
UploadSessionCursor._all_fields_ = [
    ('session_id', UploadSessionCursor._session_id_validator),
    ('offset', UploadSessionCursor._offset_validator),
]

UploadSessionFinishArg._cursor_validator = UploadSessionCursor_validator
UploadSessionFinishArg._commit_validator = CommitInfo_validator
UploadSessionFinishArg._all_field_names_ = set([
    'cursor',
    'commit',
])
UploadSessionFinishArg._all_fields_ = [
    ('cursor', UploadSessionFinishArg._cursor_validator),
    ('commit', UploadSessionFinishArg._commit_validator),
]

UploadSessionFinishBatchArg._entries_validator = bv.List(UploadSessionFinishArg_validator, max_items=1000)
UploadSessionFinishBatchArg._all_field_names_ = set(['entries'])
UploadSessionFinishBatchArg._all_fields_ = [('entries', UploadSessionFinishBatchArg._entries_validator)]

UploadSessionFinishBatchJobStatus._complete_validator = UploadSessionFinishBatchResult_validator
UploadSessionFinishBatchJobStatus._tagmap = {
    'complete': UploadSessionFinishBatchJobStatus._complete_validator,
}
UploadSessionFinishBatchJobStatus._tagmap.update(async.PollResultBase._tagmap)

UploadSessionFinishBatchResult._entries_validator = bv.List(UploadSessionFinishBatchResultEntry_validator)
UploadSessionFinishBatchResult._all_field_names_ = set(['entries'])
UploadSessionFinishBatchResult._all_fields_ = [('entries', UploadSessionFinishBatchResult._entries_validator)]

UploadSessionFinishBatchResultEntry._success_validator = FileMetadata_validator
UploadSessionFinishBatchResultEntry._failure_validator = UploadSessionFinishError_validator
UploadSessionFinishBatchResultEntry._tagmap = {
    'success': UploadSessionFinishBatchResultEntry._success_validator,
    'failure': UploadSessionFinishBatchResultEntry._failure_validator,
}

UploadSessionFinishError._lookup_failed_validator = UploadSessionLookupError_validator
UploadSessionFinishError._path_validator = WriteError_validator
UploadSessionFinishError._too_many_shared_folder_targets_validator = bv.Void()
UploadSessionFinishError._other_validator = bv.Void()
UploadSessionFinishError._tagmap = {
    'lookup_failed': UploadSessionFinishError._lookup_failed_validator,
    'path': UploadSessionFinishError._path_validator,
    'too_many_shared_folder_targets': UploadSessionFinishError._too_many_shared_folder_targets_validator,
    'other': UploadSessionFinishError._other_validator,
}

UploadSessionFinishError.too_many_shared_folder_targets = UploadSessionFinishError('too_many_shared_folder_targets')
UploadSessionFinishError.other = UploadSessionFinishError('other')

UploadSessionLookupError._not_found_validator = bv.Void()
UploadSessionLookupError._incorrect_offset_validator = UploadSessionOffsetError_validator
UploadSessionLookupError._closed_validator = bv.Void()
UploadSessionLookupError._not_closed_validator = bv.Void()
UploadSessionLookupError._other_validator = bv.Void()
UploadSessionLookupError._tagmap = {
    'not_found': UploadSessionLookupError._not_found_validator,
    'incorrect_offset': UploadSessionLookupError._incorrect_offset_validator,
    'closed': UploadSessionLookupError._closed_validator,
    'not_closed': UploadSessionLookupError._not_closed_validator,
    'other': UploadSessionLookupError._other_validator,
}

UploadSessionLookupError.not_found = UploadSessionLookupError('not_found')
UploadSessionLookupError.closed = UploadSessionLookupError('closed')
UploadSessionLookupError.not_closed = UploadSessionLookupError('not_closed')
UploadSessionLookupError.other = UploadSessionLookupError('other')

UploadSessionOffsetError._correct_offset_validator = bv.UInt64()
UploadSessionOffsetError._all_field_names_ = set(['correct_offset'])
UploadSessionOffsetError._all_fields_ = [('correct_offset', UploadSessionOffsetError._correct_offset_validator)]

UploadSessionStartArg._close_validator = bv.Boolean()
UploadSessionStartArg._all_field_names_ = set(['close'])
UploadSessionStartArg._all_fields_ = [('close', UploadSessionStartArg._close_validator)]

UploadSessionStartResult._session_id_validator = bv.String()
UploadSessionStartResult._all_field_names_ = set(['session_id'])
UploadSessionStartResult._all_fields_ = [('session_id', UploadSessionStartResult._session_id_validator)]

UploadWriteFailed._reason_validator = WriteError_validator
UploadWriteFailed._upload_session_id_validator = bv.String()
UploadWriteFailed._all_field_names_ = set([
    'reason',
    'upload_session_id',
])
UploadWriteFailed._all_fields_ = [
    ('reason', UploadWriteFailed._reason_validator),
    ('upload_session_id', UploadWriteFailed._upload_session_id_validator),
]

VideoMetadata._duration_validator = bv.Nullable(bv.UInt64())
VideoMetadata._field_names_ = set(['duration'])
VideoMetadata._all_field_names_ = MediaMetadata._all_field_names_.union(VideoMetadata._field_names_)
VideoMetadata._fields_ = [('duration', VideoMetadata._duration_validator)]
VideoMetadata._all_fields_ = MediaMetadata._all_fields_ + VideoMetadata._fields_

WriteConflictError._file_validator = bv.Void()
WriteConflictError._folder_validator = bv.Void()
WriteConflictError._file_ancestor_validator = bv.Void()
WriteConflictError._other_validator = bv.Void()
WriteConflictError._tagmap = {
    'file': WriteConflictError._file_validator,
    'folder': WriteConflictError._folder_validator,
    'file_ancestor': WriteConflictError._file_ancestor_validator,
    'other': WriteConflictError._other_validator,
}

WriteConflictError.file = WriteConflictError('file')
WriteConflictError.folder = WriteConflictError('folder')
WriteConflictError.file_ancestor = WriteConflictError('file_ancestor')
WriteConflictError.other = WriteConflictError('other')

WriteError._malformed_path_validator = MalformedPathError_validator
WriteError._conflict_validator = WriteConflictError_validator
WriteError._no_write_permission_validator = bv.Void()
WriteError._insufficient_space_validator = bv.Void()
WriteError._disallowed_name_validator = bv.Void()
WriteError._other_validator = bv.Void()
WriteError._tagmap = {
    'malformed_path': WriteError._malformed_path_validator,
    'conflict': WriteError._conflict_validator,
    'no_write_permission': WriteError._no_write_permission_validator,
    'insufficient_space': WriteError._insufficient_space_validator,
    'disallowed_name': WriteError._disallowed_name_validator,
    'other': WriteError._other_validator,
}

WriteError.no_write_permission = WriteError('no_write_permission')
WriteError.insufficient_space = WriteError('insufficient_space')
WriteError.disallowed_name = WriteError('disallowed_name')
WriteError.other = WriteError('other')

WriteMode._add_validator = bv.Void()
WriteMode._overwrite_validator = bv.Void()
WriteMode._update_validator = Rev_validator
WriteMode._tagmap = {
    'add': WriteMode._add_validator,
    'overwrite': WriteMode._overwrite_validator,
    'update': WriteMode._update_validator,
}

WriteMode.add = WriteMode('add')
WriteMode.overwrite = WriteMode('overwrite')

alpha_get_metadata = bb.Route(
    'alpha/get_metadata',
    False,
    AlphaGetMetadataArg_validator,
    Metadata_validator,
    AlphaGetMetadataError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
alpha_upload = bb.Route(
    'alpha/upload',
    False,
    CommitInfoWithProperties_validator,
    FileMetadata_validator,
    UploadErrorWithProperties_validator,
    {'host': u'content',
     'style': u'upload'},
)
copy = bb.Route(
    'copy',
    False,
    RelocationArg_validator,
    Metadata_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_reference_get = bb.Route(
    'copy_reference/get',
    False,
    GetCopyReferenceArg_validator,
    GetCopyReferenceResult_validator,
    GetCopyReferenceError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
copy_reference_save = bb.Route(
    'copy_reference/save',
    False,
    SaveCopyReferenceArg_validator,
    SaveCopyReferenceResult_validator,
    SaveCopyReferenceError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
create_folder = bb.Route(
    'create_folder',
    False,
    CreateFolderArg_validator,
    FolderMetadata_validator,
    CreateFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
delete = bb.Route(
    'delete',
    False,
    DeleteArg_validator,
    Metadata_validator,
    DeleteError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
download = bb.Route(
    'download',
    False,
    DownloadArg_validator,
    FileMetadata_validator,
    DownloadError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_metadata = bb.Route(
    'get_metadata',
    False,
    GetMetadataArg_validator,
    Metadata_validator,
    GetMetadataError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_preview = bb.Route(
    'get_preview',
    False,
    PreviewArg_validator,
    FileMetadata_validator,
    PreviewError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_temporary_link = bb.Route(
    'get_temporary_link',
    False,
    GetTemporaryLinkArg_validator,
    GetTemporaryLinkResult_validator,
    GetTemporaryLinkError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_thumbnail = bb.Route(
    'get_thumbnail',
    False,
    ThumbnailArg_validator,
    FileMetadata_validator,
    ThumbnailError_validator,
    {'host': u'content',
     'style': u'download'},
)
list_folder = bb.Route(
    'list_folder',
    False,
    ListFolderArg_validator,
    ListFolderResult_validator,
    ListFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_continue = bb.Route(
    'list_folder/continue',
    False,
    ListFolderContinueArg_validator,
    ListFolderResult_validator,
    ListFolderContinueError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_get_latest_cursor = bb.Route(
    'list_folder/get_latest_cursor',
    False,
    ListFolderArg_validator,
    ListFolderGetLatestCursorResult_validator,
    ListFolderError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list_folder_longpoll = bb.Route(
    'list_folder/longpoll',
    False,
    ListFolderLongpollArg_validator,
    ListFolderLongpollResult_validator,
    ListFolderLongpollError_validator,
    {'host': u'notify',
     'style': u'rpc'},
)
list_revisions = bb.Route(
    'list_revisions',
    False,
    ListRevisionsArg_validator,
    ListRevisionsResult_validator,
    ListRevisionsError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
move = bb.Route(
    'move',
    False,
    RelocationArg_validator,
    Metadata_validator,
    RelocationError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
permanently_delete = bb.Route(
    'permanently_delete',
    False,
    DeleteArg_validator,
    bv.Void(),
    DeleteError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_add = bb.Route(
    'properties/add',
    False,
    PropertyGroupWithPath_validator,
    bv.Void(),
    AddPropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_overwrite = bb.Route(
    'properties/overwrite',
    False,
    PropertyGroupWithPath_validator,
    bv.Void(),
    InvalidPropertyGroupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_remove = bb.Route(
    'properties/remove',
    False,
    RemovePropertiesArg_validator,
    bv.Void(),
    RemovePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_template_get = bb.Route(
    'properties/template/get',
    False,
    properties.GetPropertyTemplateArg_validator,
    properties.GetPropertyTemplateResult_validator,
    properties.PropertyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_template_list = bb.Route(
    'properties/template/list',
    False,
    bv.Void(),
    properties.ListPropertyTemplateIds_validator,
    properties.PropertyTemplateError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
properties_update = bb.Route(
    'properties/update',
    False,
    UpdatePropertyGroupArg_validator,
    bv.Void(),
    UpdatePropertiesError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
restore = bb.Route(
    'restore',
    False,
    RestoreArg_validator,
    FileMetadata_validator,
    RestoreError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
save_url = bb.Route(
    'save_url',
    False,
    SaveUrlArg_validator,
    SaveUrlResult_validator,
    SaveUrlError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
save_url_check_job_status = bb.Route(
    'save_url/check_job_status',
    False,
    async.PollArg_validator,
    SaveUrlJobStatus_validator,
    async.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
search = bb.Route(
    'search',
    False,
    SearchArg_validator,
    SearchResult_validator,
    SearchError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
upload = bb.Route(
    'upload',
    False,
    CommitInfo_validator,
    FileMetadata_validator,
    UploadError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_append = bb.Route(
    'upload_session/append',
    True,
    UploadSessionCursor_validator,
    bv.Void(),
    UploadSessionLookupError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_append_v2 = bb.Route(
    'upload_session/append_v2',
    False,
    UploadSessionAppendArg_validator,
    bv.Void(),
    UploadSessionLookupError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_finish = bb.Route(
    'upload_session/finish',
    False,
    UploadSessionFinishArg_validator,
    FileMetadata_validator,
    UploadSessionFinishError_validator,
    {'host': u'content',
     'style': u'upload'},
)
upload_session_finish_batch = bb.Route(
    'upload_session/finish_batch',
    False,
    UploadSessionFinishBatchArg_validator,
    async.LaunchEmptyResult_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
upload_session_finish_batch_check = bb.Route(
    'upload_session/finish_batch/check',
    False,
    async.PollArg_validator,
    UploadSessionFinishBatchJobStatus_validator,
    async.PollError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
upload_session_start = bb.Route(
    'upload_session/start',
    False,
    UploadSessionStartArg_validator,
    UploadSessionStartResult_validator,
    bv.Void(),
    {'host': u'content',
     'style': u'upload'},
)

ROUTES = {
    'alpha/get_metadata': alpha_get_metadata,
    'alpha/upload': alpha_upload,
    'copy': copy,
    'copy_reference/get': copy_reference_get,
    'copy_reference/save': copy_reference_save,
    'create_folder': create_folder,
    'delete': delete,
    'download': download,
    'get_metadata': get_metadata,
    'get_preview': get_preview,
    'get_temporary_link': get_temporary_link,
    'get_thumbnail': get_thumbnail,
    'list_folder': list_folder,
    'list_folder/continue': list_folder_continue,
    'list_folder/get_latest_cursor': list_folder_get_latest_cursor,
    'list_folder/longpoll': list_folder_longpoll,
    'list_revisions': list_revisions,
    'move': move,
    'permanently_delete': permanently_delete,
    'properties/add': properties_add,
    'properties/overwrite': properties_overwrite,
    'properties/remove': properties_remove,
    'properties/template/get': properties_template_get,
    'properties/template/list': properties_template_list,
    'properties/update': properties_update,
    'restore': restore,
    'save_url': save_url,
    'save_url/check_job_status': save_url_check_job_status,
    'search': search,
    'upload': upload,
    'upload_session/append': upload_session_append,
    'upload_session/append_v2': upload_session_append_v2,
    'upload_session/finish': upload_session_finish,
    'upload_session/finish_batch': upload_session_finish_batch,
    'upload_session/finish_batch/check': upload_session_finish_batch_check,
    'upload_session/start': upload_session_start,
}

