#! /usr/bin/env python
#
# Python script to open and close a Personal Folder File using pypff
#
# Author:            Joachim Metz
# Creation date:     July 24, 2010
# Modification date: January 14, 2013
#

__author__    = "Joachim Metz"
__version__   = "20130114"
__date__      = "Jan 14, 2013"
__copyright__ = "Copyright (c) 2008-2013, Joachim Metz <joachim.metz@gmail.com>"
__license__   = "GNU LGPL version 3"

import sys
import pypff

# ----------------------------------------------------------------------------
# Main
# ----------------------------------------------------------------------------

print "open_close.py " + __version__ + " (libpff " + pypff.get_version() + ")\n"

if len( sys.argv ) != 2:
	print "Usage: open_close.py filename\n"

	sys.exit( 1 )

file = pypff.new_file();

if file == None:
	print "Missing file object\n"

	sys.exit( 1 )

try:
	file.open(
	 sys.argv[ 1 ] )

except:
	print "Unable to open file\n"
	print sys.exc_info()[ 1 ]

	sys.exit( 1 )

try:
	file.close()
except:
	print "Unable to close file\n"
	print sys.exc_info()[ 1 ]
 
	sys.exit( 1 )

sys.exit( 0 )

