#include "ps_task.h"
#include "psthread.h"

gint ps_sched_leapfrog(ps_task_t *task,gpointer anything)
{
	static gint	i=0;
	ps_task_t	*node;
	gint			retval;

	if(task->next==NULL) return PSTHREAD_ERR;

	node=task->next;
	retval=node->callback(node,node->anything);

	if(retval==PSTHREAD_CONTINUE)
	{
		if(PS_RUNQ(task)->task_count>1)
		{
			ps_task_swap(task,node);
		}
		return retval;
	}

	if(retval==PSTHREAD_GROW)
	{
		if(node->next!=NULL)
		ps_task_swap(node,node->next);
		return retval;
	}

	/*	default behavior for all other return codes
		(currently PSTHREAD_ERR and PSTHREAD_TERMINATE)	*/
	ps_task_unlink(node);
	ps_task_destroy(node);
	PS_RUNQ(task)->task_count--;

	return retval;
}
