#ifndef _PS_TASK_H_
#define _PS_TASK_H_

#include <glib.h>

#include "pseudo.h"

struct _ps_task_s
{
   PSTHREAD		callback;
  	gpointer    anything;
   ps_task_t   *head;
   ps_task_t   *next;
   ps_task_t   *prev;
   gint16      priority;
   guint       flags;
};

#define PS_TASK(x)   ((ps_task_t*)x)

ps_task_t*	ps_task_create(PSTHREAD callback,void *anything);
ps_task_t*	ps_task_fetch(ps_task_t *node,gint offset);
void			ps_task_swap(ps_task_t *node1,ps_task_t *node2);
void			ps_task_append(ps_task_t *task,ps_task_t *node,gint offset);
void			ps_task_prepend(ps_task_t *task,ps_task_t *node,gint offset);
void			ps_task_move(ps_task_t *task,gint offset);
void			ps_task_unlink(ps_task_t *task);
void			ps_task_destroy(ps_task_t *task);

#endif
