/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.jsampler.CC;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.fantasia.FantasiaInstrumentsDbTree;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.std.JSInstrumentsDbColumnPreferencesDlg;
import org.jsampler.view.std.JSInstrumentsDbTable;

public class InstrumentsDbPane
extends JPanel {
    private final FantasiaInstrumentsDbTree instrumentsDbTree;
    private final JSInstrumentsDbTable instrumentsTable;
    private final JSplitPane splitPane;

    public InstrumentsDbPane() {
        this.setLayout(new BorderLayout());
        this.instrumentsDbTree = CC.getInstrumentsDbTreeModel() != null ? new FantasiaInstrumentsDbTree(CC.getInstrumentsDbTreeModel()) : new FantasiaInstrumentsDbTree(new InstrumentsDbTreeModel(true));
        this.instrumentsTable = new JSInstrumentsDbTable(this.instrumentsDbTree, "InstrumentsDbPane.");
        this.instrumentsTable.getModel().setShowDummyColumn(true);
        this.instrumentsTable.loadColumnsVisibleState();
        this.instrumentsTable.loadColumnWidths();
        this.instrumentsTable.loadSortOrder();
        this.instrumentsDbTree.setSelectedDirectory("/");
        JScrollPane jScrollPane = new JScrollPane(this.instrumentsDbTree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        JScrollPane jScrollPane2 = new JScrollPane(this.instrumentsTable);
        jScrollPane2.setPreferredSize(new Dimension(200, 200));
        jScrollPane2.setOpaque(false);
        jScrollPane2.getViewport().setOpaque(false);
        this.splitPane = new JSplitPane(0, true, jScrollPane, jScrollPane2);
        this.splitPane.setResizeWeight(0.4);
        this.add(this.splitPane);
        this.add((Component)new ToolBar(), "North");
        int n = FantasiaPrefs.preferences().getIntProperty("InstrumentsDbPane.splitDividerLocation", 160);
        this.splitPane.setDividerLocation(n);
    }

    protected void savePreferences() {
        this.instrumentsTable.saveColumnsVisibleState();
        this.instrumentsTable.saveColumnWidths();
        int n = this.splitPane.getDividerLocation();
        FantasiaPrefs.preferences().setIntProperty("InstrumentsDbPane.splitDividerLocation", n);
    }

    class PreferencesDlg
    extends JSInstrumentsDbColumnPreferencesDlg {
        PreferencesDlg() {
            super((Frame)CC.getMainFrame(), InstrumentsDbPane.this.instrumentsTable);
        }
    }

    class ToolBar
    extends JToolBar {
        protected final JButton btnGoUp;
        protected final JButton btnGoBack;
        protected final JButton btnGoForward;
        protected final JButton btnReload;
        protected final JButton btnPreferences;

        public ToolBar() {
            super("");
            this.btnGoUp = new ToolbarButton(((InstrumentsDbPane)InstrumentsDbPane.this).instrumentsDbTree.actionGoUp);
            this.btnGoBack = new ToolbarButton(((InstrumentsDbPane)InstrumentsDbPane.this).instrumentsDbTree.actionGoBack);
            this.btnGoForward = new ToolbarButton(((InstrumentsDbPane)InstrumentsDbPane.this).instrumentsDbTree.actionGoForward);
            this.btnReload = new ToolbarButton(((InstrumentsDbPane)InstrumentsDbPane.this).instrumentsTable.reloadAction);
            this.btnPreferences = new ToolbarButton(null);
            this.setFloatable(false);
            this.add(this.btnGoBack);
            this.add(this.btnGoForward);
            this.add(this.btnGoUp);
            ((InstrumentsDbPane)InstrumentsDbPane.this).instrumentsTable.reloadAction.putValue("SmallIcon", Res.iconReload16);
            this.add(this.btnReload);
            this.addSeparator();
            this.btnPreferences.setIcon(Res.iconPreferences16);
            this.add(this.btnPreferences);
            this.btnPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new PreferencesDlg().setVisible(true);
                }
            });
        }
    }
}

