/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.Server;
import org.jsampler.view.std.StdI18n;

public class JSAddServerDlg
extends OkCancelDialog {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSAddServerDlg.lName"));
    private final JLabel lDesc = new JLabel(StdI18n.i18n.getLabel("JSAddServerDlg.lDesc"));
    private final JLabel lAddress = new JLabel(StdI18n.i18n.getLabel("JSAddServerDlg.lAddress"));
    private final JLabel lPort = new JLabel(StdI18n.i18n.getLabel("JSAddServerDlg.lPort"));
    private final JTextField tfName = new JTextField();
    private final JTextField tfDesc = new JTextField();
    private final JTextField tfAddress = new JTextField();
    private final JTextField tfPort = new JTextField();
    private final Handler eventHandler = new Handler();

    public JSAddServerDlg(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSAddServerDlg.title"));
        this.initJSAddServerDlg();
    }

    public JSAddServerDlg(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSAddServerDlg.title"));
        this.initJSAddServerDlg();
    }

    private void initJSAddServerDlg() {
        this.btnOk.setEnabled(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        jPanel.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lDesc, gridBagConstraints);
        jPanel.add(this.lDesc);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lAddress, gridBagConstraints);
        jPanel.add(this.lAddress);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lPort, gridBagConstraints);
        jPanel.add(this.lPort);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        jPanel.add(this.tfName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.tfDesc, gridBagConstraints);
        jPanel.add(this.tfDesc);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.tfAddress, gridBagConstraints);
        jPanel.add(this.tfAddress);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.tfPort, gridBagConstraints);
        jPanel.add(this.tfPort);
        this.setMainPane(jPanel);
        this.setResizable(true);
        int n = this.getPreferredSize().width;
        Dimension dimension = new Dimension(n > 300 ? n : 300, this.getPreferredSize().height);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.tfAddress.getDocument().addDocumentListener(this.getHandler());
        this.tfPort.getDocument().addDocumentListener(this.getHandler());
    }

    @Override
    protected void onOk() {
        int n;
        if (!this.btnOk.isEnabled()) {
            return;
        }
        Server server = new Server();
        server.setName(this.tfName.getText());
        server.setDescription(this.tfDesc.getText());
        server.setAddress(this.tfAddress.getText());
        String string = this.tfPort.getText();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            HF.showErrorMessage(StdI18n.i18n.getError("JSAddServerDlg.invalidPort", string), (Component)this);
            return;
        }
        if (n < 0 || n > 65535) {
            HF.showErrorMessage(StdI18n.i18n.getError("JSAddServerDlg.invalidPort", string), (Component)this);
            return;
        }
        server.setPort(n);
        CC.getServerList().addServer(server);
        this.setVisible(false);
        this.setCancelled(false);
    }

    private void updateState() {
        boolean bl = true;
        if (this.tfName.getText().length() == 0) {
            bl = false;
        }
        if (this.tfAddress.getText().length() == 0) {
            bl = false;
        }
        if (this.tfPort.getText().length() == 0) {
            bl = false;
        }
        this.btnOk.setEnabled(bl);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddServerDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddServerDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddServerDlg.this.updateState();
        }
    }
}

