/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.InformationDialog;
import org.jsampler.CC;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.JSPreviewLostFilesDlg;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;

class JSReplaceLostFilesDlg
extends InformationDialog {
    private final JLabel lFind = new JLabel(StdI18n.i18n.getLabel("JSReplaceLostFilesDlg.lFind"));
    private final JLabel lReplace = new JLabel(StdI18n.i18n.getLabel("JSReplaceLostFilesDlg.lReplace"));
    private final JTextField tfFind = new JTextField();
    private final JTextField tfReplace = new JTextField();
    private final JButton btnBrowse;
    private final JButton btnBrowse2;
    private final JButton btnPreview = new JButton(StdI18n.i18n.getButtonLabel("JSReplaceLostFilesDlg.btnPreview"));
    private final JButton btnReplace = new JButton(StdI18n.i18n.getButtonLabel("JSReplaceLostFilesDlg.btnReplace"));
    private final JButton btnCancel = new JButton(StdI18n.i18n.getButtonLabel("cancel"));
    private final EventHandler eventHandler = new EventHandler();

    JSReplaceLostFilesDlg(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSReplaceLostFilesDlg.title"));
        this.showCloseButton(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Icon icon = CC.getViewConfig().getInstrumentsDbTreeView().getOpenIcon();
        this.btnBrowse = new JButton(icon);
        this.btnBrowse2 = new JButton(icon);
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowse2.setMargin(new Insets(0, 0, 0, 0));
        if (!CC.getCurrentServer().isLocal()) {
            this.btnBrowse.setEnabled(false);
            this.btnBrowse2.setEnabled(false);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lFind, gridBagConstraints);
        jPanel.add(this.lFind);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lReplace, gridBagConstraints);
        jPanel.add(this.lReplace);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.btnBrowse, gridBagConstraints);
        jPanel.add(this.btnBrowse);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.btnBrowse2, gridBagConstraints);
        jPanel.add(this.btnBrowse2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfFind, gridBagConstraints);
        jPanel.add(this.tfFind);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.tfReplace, gridBagConstraints);
        jPanel.add(this.tfReplace);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.btnPreview.setEnabled(false);
        this.btnReplace.setEnabled(false);
        jPanel2.add(this.btnPreview);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.btnReplace);
        jPanel2.add(Box.createGlue());
        jPanel2.add(Box.createRigidArea(new Dimension(17, 0)));
        jPanel2.add(this.btnCancel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.setPreferredSize(new Dimension(360, jPanel.getPreferredSize().height));
        this.setMainPane(jPanel);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JSReplaceLostFilesDlg.this.browse();
                if (string != null) {
                    JSReplaceLostFilesDlg.this.tfFind.setText(string);
                }
            }
        });
        this.btnBrowse2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JSReplaceLostFilesDlg.this.browse();
                if (string != null) {
                    JSReplaceLostFilesDlg.this.tfReplace.setText(string);
                }
            }
        });
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSReplaceLostFilesDlg.this.onPreview();
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSReplaceLostFilesDlg.this.onReplace();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSReplaceLostFilesDlg.this.onCancel();
            }
        });
        this.tfFind.getDocument().addDocumentListener(this.getHandler());
        this.tfReplace.getDocument().addDocumentListener(this.getHandler());
    }

    private void onPreview() {
        String string = this.tfFind.getText();
        String string2 = this.tfReplace.getText();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < CC.getLostFilesModel().getLostFileCount(); ++i) {
            String string3 = CC.getLostFilesModel().getLostFile(i);
            if (!string3.startsWith(string)) continue;
            stringBuffer.append(string3).append(" -> ");
            stringBuffer.append(string2).append(string3.substring(string.length())).append("\n");
        }
        JSPreviewLostFilesDlg jSPreviewLostFilesDlg = new JSPreviewLostFilesDlg((Dialog)this, stringBuffer.toString());
        jSPreviewLostFilesDlg.setVisible(true);
    }

    private void onReplace() {
        String string = this.tfFind.getText();
        String string2 = this.tfReplace.getText();
        for (int i = 0; i < CC.getLostFilesModel().getLostFileCount(); ++i) {
            String string3 = CC.getLostFilesModel().getLostFile(i);
            if (!string3.startsWith(string)) continue;
            String string4 = string2 + string3.substring(string.length());
            InstrumentsDb.SetInstrumentFilePath setInstrumentFilePath = new InstrumentsDb.SetInstrumentFilePath(string3, string4);
            CC.getTaskQueue().add(setInstrumentFilePath);
        }
        CC.getLostFilesModel().update();
        this.onCancel();
    }

    private void updateState() {
        boolean bl = this.tfFind.getText().length() != 0 && this.tfReplace.getText().length() != 0;
        this.btnPreview.setEnabled(bl);
        this.btnReplace.setEnabled(bl);
    }

    private String browse() {
        File file = StdUtils.showOpenDirectoryChooser(this, null);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string.length() < 2) {
            return string;
        }
        char c = File.separatorChar;
        if (string.charAt(string.length() - 1) != c) {
            string = string + c;
        }
        return string;
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements DocumentListener {
        private EventHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSReplaceLostFilesDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSReplaceLostFilesDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSReplaceLostFilesDlg.this.updateState();
        }
    }
}

