/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parser;

public class DbDirectoryInfo {
    private String name = "";
    private String description = "";
    private final Date dateCreated = new EnhancedDate();
    private final Date dateModified = new EnhancedDate();
    private String parentDirectoryPath = null;
    private boolean showAbsolutePath = false;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat dateFormat2 = DateFormat.getInstance();

    public DbDirectoryInfo(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public String getDirectoryPath() {
        if (this.getParentDirectoryPath() == null && this.getName().equals("/")) {
            return "/";
        }
        if (this.getParentDirectoryPath() == null) {
            return null;
        }
        if (this.getParentDirectoryPath().length() == 1) {
            if (!this.getParentDirectoryPath().equals("/")) {
                return null;
            }
            return this.getParentDirectoryPath() + Parser.toEscapedFileName(this.getName());
        }
        return this.getParentDirectoryPath() + "/" + Parser.toEscapedFileName(this.getName());
    }

    public String getParentDirectoryPath() {
        return this.parentDirectoryPath;
    }

    public void setParentDirectoryPath(String string) {
        this.parentDirectoryPath = string;
    }

    public boolean parse(String string) throws LscpException {
        if (string.startsWith("DESCRIPTION: ")) {
            this.description = string.substring("DESCRIPTION: ".length());
            this.description = Parser.toNonEscapedString(this.description);
        } else if (string.startsWith("CREATED: ")) {
            string = string.substring("CREATED: ".length());
            try {
                this.dateCreated.setTime(dateFormat.parse(string).getTime());
            }
            catch (ParseException parseException) {
                throw new LscpException(parseException.getMessage());
            }
        } else if (string.startsWith("MODIFIED: ")) {
            string = string.substring("MODIFIED: ".length());
            try {
                this.dateModified.setTime(dateFormat.parse(string).getTime());
            }
            catch (ParseException parseException) {
                throw new LscpException(parseException.getMessage());
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean getShowAbsolutePath() {
        return this.showAbsolutePath;
    }

    public void setShowAbsolutePath(boolean bl) {
        this.showAbsolutePath = bl;
    }

    public String toString() {
        if (this.getShowAbsolutePath()) {
            return this.getDirectoryPath();
        }
        return this.getName();
    }

    private class EnhancedDate
    extends Date {
        private EnhancedDate() {
        }

        @Override
        public String toString() {
            return dateFormat2.format(this);
        }
    }
}

