/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "general.h"

/* create a allocated string from a const char* */
char * create_string (const char *cstr) {
	char *string = gitm_malloc (strlen(cstr) + 1);
	if (strlen(cstr)) {	
		sprintf (string, "%s", cstr);
	} else
		string[0] = '\0';
	return string;	
}

/* get the file name into the full path name */
char * get_file_name (char *fullpath) {
	int k;
	char *filename = gitm_malloc (strlen (fullpath));
	k = strlen (fullpath);
	while (fullpath[k] != '/')
		k--;
	k++;
	int l = k;
	while (fullpath[k]) {
		filename[k - l] = fullpath[k];
		k++;
	}
	filename[k - l] = '\0';
	
	return filename;
}

/* returns an allocated string (str1 + str2) */
char * gitm_strcat (char *str1, char *str2) {
	char *outstr = gitm_malloc (strlen(str1) + strlen(str2) + 1);
	outstr[0] = '\0';
	strcat (outstr, str1);
	strcat (outstr, str2);
	return outstr;
}

/* returns an allocated string (str1 + str2) and frees str1 */
char * gitm_stradd (char *str1, char *str2) {
	char *outstr = gitm_strcat (str1, str2);
	free (str1);
	return outstr;
}

/* encode the attached file in base64 */
struct loaded_file * encode_file (char *filepath) {
	struct loaded_file * uncoded_file = loadfile (filepath);
	struct loaded_file * coded_file = gitm_malloc (sizeof(struct loaded_file));
	
	size_t len;

	coded_file->data = (char *) base64_encode ((unsigned char *)uncoded_file->data, uncoded_file->size, &len);
	coded_file->size = len;
	
	free(uncoded_file);
	return coded_file;
}

/* convert from UTF-8 to ISO8859-1 */
char * charsetconvert (char *s) {
	iconv_t cd = iconv_open("ISO8859-1","UTF-8");
	char *retval = s;
	if (cd != (iconv_t) (-1)) {
		size_t s_len = strlen(retval);
		char *buf = alloca(4 * 3 * s_len);
		char *ptr = buf;
		size_t ptr_len = 4 * 3 * s_len;
		if ((iconv(cd, &s, &s_len, &ptr, &ptr_len)) != (size_t) (-1)) {
				*ptr = 0;
				retval = buf;
		}
		iconv_close(cd);
	}
	return strdup(retval);
}

/* convert from ISO8859-1 to UTF-8*/
char * charsetconvert_back (char *s) {
	iconv_t cd = iconv_open("UTF-8","ISO8859-1");
	char *retval = s;
	if (cd != (iconv_t) (-1)) {
		size_t s_len = strlen(retval);
		char *buf = alloca(4 * 3 * s_len);
		char *ptr = buf;
		size_t ptr_len = 4 * 3 * s_len;
		if ((iconv(cd, &s, &s_len, &ptr, &ptr_len)) != (size_t) (-1)) {
				*ptr = 0;
				retval = buf;
		}
		iconv_close(cd);
	}
	return strdup(retval);
}

/* returns the size of a combobox element got from history files */
int elt_size (char *start, int max) {
	int len = 0;
	while ((start[len] != '\n') && (len <= max))
		len++;
	return len;
}

/* converts text (\n -> \r\n) ; (\n. -> \n..) */
char * convertion (char *text) {
	int i = 0, j = 0, len = strlen (text);
	char *convd_text = NULL;
	
	while (i <= len) {
		convd_text = gitm_realloc (convd_text, j + 2);
		if (text[i] != '\n')
			convd_text[j] = text[i];
		else {
			convd_text[j] = '\r';
			convd_text[j+1] = '\n';
			j++;
		}
		i++;
		j++;
	}
	
	free(text);
	text = convd_text;
	convd_text = NULL;
	len = strlen (text);

	i = 0;
	j = 0;
	
	while (i <= len) {
		convd_text = gitm_realloc (convd_text, j + 2);
		convd_text[j] = text[i];
		if ((((i > 0) && (text[i-1] == '\n')) || (i == 0)) && (text[i] == '.')) {
			j++;
			convd_text[j] = '.';
		}
		i++;
		j++;
	}
	free(text);
	return convd_text;
}

/* allocate a new pointer and check if it fails or not */
void * gitm_malloc (size_t size) {
	void *ptr = malloc (size);

	if (!ptr) {
		perror ("malloc error");
		exit(errno);
	}
	
	return ptr;
}

/* reallocate a pointer and check if it fails or not */
void * gitm_realloc (void *oldptr, size_t size) {
	void *ptr = realloc (oldptr, size);
	
	if (!ptr) {
		perror ("realloc error");
		exit(errno);
	}
	
	return ptr;
}

/* display an error message and close the thread */
void server_error (char *text) {
	char *errtext = gitm_strcat ("The server returned the following error:\n", text);
	showerror (errtext);
	free(text);
	free(errtext);
	pthread_exit (NULL);
}
