/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "socket.h"

/* main function called to send a mail */
void * sendamail(maildata *mdata) {
	
	int sd;

	char *server = mdata->server;
	char *from = mdata->from;
	char *name = mdata->name;
	char *to = mdata->to;
	char *subject = mdata->subject;
	char *filepath = mdata->filepath;
	char *text = mdata->text;
	
	struct loaded_file * file_content = NULL;
	
	lookup_all_widgets();
	
	text = convertion (text);
	text = charsetconvert (text);
	name = charsetconvert (name);
	subject = charsetconvert (subject);
	
	if (strlen (server)) {
		sd = initconnection (server);
		if (!sd) {
			showerror ("Connection Error !\nGitmail cannot connect to the smtp server\nCheck your internet connection");
			return 0;			
		}
	} else {
		showerror ("No server specified!");
		return 0;
	}
	
	if (sd > 0) {	
		transmitinfo (&sd, from, to);
		transmitdata (&sd, from, name, to, subject, text, filepath, file_content);
		statusbarsettext (NULL);
		close (sd);
	}
	
	progressbarsetfraction(0);
	
	showok ();
	free (mdata);
	
	return 0;
}

/* intialize the connection with the smtp server */
int initconnection (char *server) {
	struct sockaddr_in adsock;
	struct hostent *hptr;
	char *ans_buffer;
	int sd;
	
	printf ("\ngitmail is connecting to : %s\n", server);

	hptr = gethostbyname (server);
	
	if((hptr != NULL) && (hptr->h_addr[0] != '\0')) {
		memcpy ((char *) &adsock.sin_addr, (char *) hptr->h_addr, hptr->h_length);
		adsock.sin_family = hptr->h_addrtype;
		adsock.sin_port = htons (25);
		sd = socket (AF_INET, SOCK_STREAM, 0);
		if (sd)	{
			if(!connect (sd, (struct sockaddr *) &adsock, sizeof (adsock)))
				ans_buffer = getans (sd);
			else
				sd = 0;
		}
	} else sd = 0;
	return sd;
}

/* transmit smtp commands */
int transmitinfo (int *sd, char *from, char *to) {
	char *ans_buffer;
	
	struct sockaddr_in nameaddr;
	uint length = sizeof (nameaddr);
	getsockname(*sd, (struct sockaddr *)&nameaddr, &length);
	
	char *buffer = gitm_malloc (10 + strlen (inet_ntoa (nameaddr.sin_addr)));

	sprintf (buffer, "HELO [%s]\r\n", inet_ntoa (nameaddr.sin_addr));
	
	printf ("%s", buffer);
	write (*sd, buffer, strlen(buffer));
	free (buffer);
	
	ans_buffer = getans (*sd);
	free (ans_buffer);
		
	buffer = gitm_malloc (16 + strlen(from));

	sprintf (buffer, "mail from: <%s>\r\n", from);
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	free (buffer);
	
	ans_buffer = getans (*sd);
	if ((ans_buffer[0] == '4') || (ans_buffer[0] == '5'))
		server_error (ans_buffer);
	free(ans_buffer);
	
	buffer = gitm_malloc (14 + strlen(to));

	sprintf (buffer, "rcpt to: <%s>\r\n", to);
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	free (buffer);
	
	ans_buffer = getans (*sd);	
	if ((ans_buffer[0] == '4') || (ans_buffer[0] == '5'))
		server_error (ans_buffer);
	free(ans_buffer);
	
	return 0;
}

/* transmit the body of the mail */
int transmitdata (int *sd, char *from, char *name, char *to, char *subject, char *text, char *filepath, struct loaded_file * file_content) {
	char *buffer = NULL;
	char *ans_buffer;
	int len, i, j;
	
	buffer = gitm_realloc (buffer, 1024 + strlen (text));
	
	strcpy (buffer, "data\r\n");
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	
	ans_buffer = getans (*sd);	
	if ((ans_buffer[0] == '4') || (ans_buffer[0] == '5'))
		server_error (ans_buffer);
	free(ans_buffer);
		
	if (strlen (filepath))
		text = create_mime_mail (filepath, text);
	else {
		void *oldtext = text;
		text = gitm_strcat ("\r\n", text);
		free (oldtext);
	}
	buffer = gitm_realloc (buffer, strlen (text) + 1000);
	
	sprintf (buffer, "From:%s (%s)\r\nTo:%s\r\nSubject:%s\r\n%s\r\n.\r\n", from, name, to, subject, text);
	
	len = strlen (buffer);
	char *buffer2;
	buffer2 = gitm_malloc (1000);
	
	j = 0;
	
	statusbarsettext ("Sending mail...");
	for (i = 0; i <= len; i++) {
		if ((!(i % 1000)) && i) {
			buffer2[j] = '\0';
			write (*sd, buffer2, strlen (buffer2));
			j = 0;
			progressbarsetfraction (((double) i)/len);
		}
		buffer2[j] = buffer[i];
		j++;
	}
	
	if (j)
		write (*sd, buffer2, strlen (buffer2));
	
	free(buffer2);
	
	ans_buffer = getans (*sd);
	if ((ans_buffer[0] == '4') || (ans_buffer[0] == '5'))
		server_error (ans_buffer);
	free(ans_buffer);
	
	free (buffer);
	free (text);
	
	return 0;
}

/* get answer from server */
char * getans (int sd) {
	char *buffer = gitm_malloc (1024);
	buffer[recv (sd, buffer, 1024, 0)] = '\0';
	printf ("%s", buffer);
	return buffer;
}
