/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.net.URISyntaxException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.rssowl.core.interpreter.INamespaceHandler;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.util.URIUtils;

public class XMLNamespaceHandler
implements INamespaceHandler {
    public void processElement(Element element, IPersistable type) {
    }

    public void processAttribute(Attribute attribute, IPersistable type) {
        if ("lang".equals(attribute.getName()) && type instanceof IFeed) {
            ((IFeed)type).setLanguage(attribute.getValue());
        }
        if ("base".equals(attribute.getName())) {
            URI baseUri = URIUtils.createURI(attribute.getValue());
            if (baseUri != null && type instanceof IFeed) {
                ((IFeed)type).setBase(baseUri);
            } else if (baseUri != null && type instanceof INews) {
                INews news = (INews)type;
                if (news.getBase() != null && news.getBase().isAbsolute() && !baseUri.isAbsolute()) {
                    try {
                        news.setBase(URIUtils.resolve(news.getBase(), baseUri));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        news.setBase(baseUri);
                    }
                } else {
                    news.setBase(baseUri);
                }
            }
        }
    }
}

