/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.ICloud;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ITextInput;
import org.rssowl.core.persist.reference.FeedReference;
import org.rssowl.core.util.ArrayUtils;
import org.rssowl.core.util.MergeUtils;
import org.rssowl.core.util.SyncUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed
extends AbstractEntity
implements IFeed {
    private String fTitle;
    private Date fPublishDate;
    private String fDescription;
    private String fHomepage;
    private String fLanguage;
    private String fCopyright;
    private String fDocs;
    private String fGenerator;
    private Date fLastBuildDate;
    private String fWebmaster;
    private Date fLastModifiedDate;
    private int fTTL;
    private String fFormat;
    private String fBaseUri;
    private transient URI fLink;
    private String fLinkText;
    private IImage fImage;
    private IPerson fAuthor;
    private List<INews> fNews;
    private List<ICategory> fCategories;

    public Feed(URI link) {
        this(null, link);
    }

    public Feed(Long id, URI link) {
        super(id);
        Assert.isNotNull((Object)link, (String)"The type Feed requires a Link that is not NULL");
        this.fLink = link;
        this.fLinkText = link.toString();
        this.fNews = new ArrayList<INews>();
    }

    protected Feed() {
    }

    @Override
    public synchronized void addNews(INews news) {
        Assert.isNotNull((Object)news, (String)"Exception adding NULL as News into Feed");
        Assert.isTrue((boolean)this.fLinkText.equals(news.getFeedLinkAsText()), (String)"The News has a different Feed set!");
        this.fNews.add(news);
    }

    private int findNews(List<INews> newsList, INews news) {
        int i = 0;
        int c = newsList.size();
        while (i < c) {
            if (news.isEquivalent(newsList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public synchronized List<INews> getNews() {
        return new ArrayList<INews>(this.fNews);
    }

    public synchronized int getStickyCount() {
        int count = 0;
        for (INews news : this.fNews) {
            if (!news.isFlagged()) continue;
            ++count;
        }
        return count;
    }

    public synchronized Map<INews.State, Integer> getNewsCount() {
        int[] counts = new int[INews.State.values().length];
        for (INews news : this.fNews) {
            int n = news.getState().ordinal();
            counts[n] = counts[n] + 1;
        }
        EnumMap<INews.State, Integer> stateToCountMap = new EnumMap<INews.State, Integer>(INews.State.class);
        int ordinal = 0;
        int[] nArray = counts;
        int n = counts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            stateToCountMap.put(INews.State.getState(ordinal), count);
            ++ordinal;
            ++n2;
        }
        return stateToCountMap;
    }

    @Override
    public synchronized URI getLink() {
        if (this.fLink == null && this.fLinkText != null) {
            this.fLink = this.createURI(this.fLinkText);
        }
        return this.fLink;
    }

    @Override
    public synchronized String getCopyright() {
        return this.fCopyright;
    }

    @Override
    public synchronized void setCopyright(String copyright) {
        this.fCopyright = copyright;
    }

    @Override
    public synchronized String getDescription() {
        return this.fDescription;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.fDescription = description;
    }

    @Override
    public synchronized URI getDocs() {
        return this.createURI(this.fDocs);
    }

    @Override
    public synchronized void setDocs(URI docs) {
        this.fDocs = this.getURIText(docs);
    }

    @Override
    public synchronized String getFormat() {
        return this.fFormat;
    }

    @Override
    public synchronized void setFormat(String format) {
        this.fFormat = format;
    }

    @Override
    public synchronized String getGenerator() {
        return this.fGenerator;
    }

    @Override
    public synchronized void setGenerator(String generator) {
        this.fGenerator = generator;
    }

    @Override
    public synchronized URI getHomepage() {
        return this.createURI(this.fHomepage);
    }

    @Override
    public synchronized void setHomepage(URI homepage) {
        this.fHomepage = this.getURIText(homepage);
    }

    @Override
    public synchronized String getLanguage() {
        return this.fLanguage;
    }

    @Override
    public synchronized void setLanguage(String language) {
        this.fLanguage = language;
    }

    @Override
    public synchronized Date getLastBuildDate() {
        return this.fLastBuildDate;
    }

    @Override
    public synchronized void setLastBuildDate(Date lastBuildDate) {
        this.fLastBuildDate = lastBuildDate;
    }

    @Override
    public synchronized IPerson getAuthor() {
        return this.fAuthor;
    }

    @Override
    public synchronized void setAuthor(IPerson author) {
        this.fAuthor = author;
    }

    @Override
    public synchronized Date getPublishDate() {
        return this.fPublishDate;
    }

    @Override
    public synchronized void setPublishDate(Date publishDate) {
        this.fPublishDate = publishDate;
    }

    @Override
    public synchronized String getTitle() {
        return this.fTitle;
    }

    @Override
    public synchronized void setTitle(String title) {
        this.fTitle = title;
    }

    @Override
    public synchronized List<INews> getVisibleNews() {
        return this.getNewsByStates(INews.State.getVisible());
    }

    @Override
    public synchronized List<INews> getNewsByStates(Set<INews.State> states) {
        ArrayList<INews> newsList = new ArrayList<INews>();
        for (INews news : this.fNews) {
            if (!states.contains((Object)news.getState())) continue;
            newsList.add(news);
        }
        return newsList;
    }

    @Override
    public synchronized int getTTL() {
        return this.fTTL;
    }

    @Override
    public synchronized void setTTL(int ttl) {
        this.fTTL = ttl;
    }

    @Override
    public synchronized String getWebmaster() {
        return this.fWebmaster;
    }

    @Override
    public synchronized void setWebmaster(String webmaster) {
        this.fWebmaster = webmaster;
    }

    @Override
    public synchronized void setImage(IImage image) {
        this.fImage = image;
    }

    @Override
    public synchronized void addCategory(ICategory category) {
        if (this.fCategories == null) {
            this.fCategories = new ArrayList<ICategory>();
        }
        this.fCategories.add(category);
    }

    @Override
    public synchronized void setLastModifiedDate(Date lastModifiedDate) {
        this.fLastModifiedDate = lastModifiedDate;
    }

    @Override
    public synchronized Date getLastModifiedDate() {
        return this.fLastModifiedDate;
    }

    @Override
    public synchronized void setBase(URI baseUri) {
        this.fBaseUri = this.getURIText(baseUri);
    }

    @Override
    public synchronized URI getBase() {
        return this.createURI(this.fBaseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(IFeed feed) {
        if (this == feed) {
            return true;
        }
        if (!(feed instanceof Feed)) {
            return false;
        }
        IFeed iFeed = feed;
        synchronized (iFeed) {
            Feed f = (Feed)feed;
            return (this.getId() == null ? f.getId() == null : this.getId().equals(f.getId())) && (this.fAuthor == null ? f.fAuthor == null : this.fAuthor.equals(f.fAuthor)) && (this.fCategories == null ? f.fCategories == null : this.fCategories.equals(f.fCategories)) && (this.fCopyright == null ? f.fCopyright == null : this.fCopyright.equals(f.fCopyright)) && (this.fDescription == null ? f.fDescription == null : this.fDescription.equals(f.fDescription)) && (this.getDocs() == null ? f.getDocs() == null : this.getDocs().equals(f.getDocs())) && (this.fFormat == null ? f.fFormat == null : this.fFormat.equals(f.fFormat)) && (this.fGenerator == null ? f.fGenerator == null : this.fGenerator.equals(f.fGenerator)) && (this.getHomepage() == null ? f.getHomepage() == null : this.getHomepage().equals(f.getHomepage())) && (this.getBase() == null ? f.getBase() == null : this.getBase().equals(f.getBase())) && (this.fImage == null ? f.fImage == null : this.fImage.equals(f.fImage)) && (this.fLanguage == null ? f.fLanguage == null : this.fLanguage.equals(f.fLanguage)) && (this.fLastBuildDate == null ? f.fLastBuildDate == null : this.fLastBuildDate.equals(f.fLastBuildDate)) && (this.fLastModifiedDate == null ? f.fLastModifiedDate == null : this.fLastModifiedDate.equals(f.fLastModifiedDate)) && (this.getLink() == null ? f.getLink() == null : this.getLink().toString().equals(f.getLink() != null ? f.getLink().toString() : null)) && (this.fNews == null ? f.fNews == null : new HashSet<INews>(this.fNews).equals(new HashSet<INews>(f.fNews))) && (this.fPublishDate == null ? f.fPublishDate == null : this.fPublishDate.equals(f.fPublishDate)) && (this.fTitle == null ? f.fTitle == null : this.fTitle.equals(f.fTitle)) && this.fTTL == f.fTTL && (this.fWebmaster == null ? f.fWebmaster == null : this.fWebmaster.equals(f.fWebmaster)) && (this.getProperties() == null ? f.getProperties() == null : this.getProperties().equals(f.getProperties()));
        }
    }

    @Override
    public void setRating(String rating) {
    }

    @Override
    public void setTextInput(ITextInput input) {
    }

    @Override
    public void addHourToSkip(int hour) {
    }

    @Override
    public void addDayToSkip(int day) {
    }

    @Override
    public void setCloud(ICloud cloud) {
    }

    @Override
    public ICloud getCloud() {
        return null;
    }

    @Override
    public synchronized IImage getImage() {
        return this.fImage;
    }

    @Override
    public String getRating() {
        return null;
    }

    @Override
    public int[] getDaysToSkip() {
        return null;
    }

    @Override
    public int[] getHoursToSkip() {
        return null;
    }

    @Override
    public synchronized List<ICategory> getCategories() {
        if (this.fCategories == null) {
            return new ArrayList<ICategory>(0);
        }
        return new ArrayList<ICategory>(this.fCategories);
    }

    @Override
    public ITextInput getTextInput() {
        return null;
    }

    @Override
    public void setUpdateBase(Date updateBase) {
    }

    @Override
    public Date getUpdateBase() {
        return null;
    }

    @Override
    public int getUpdateFrequency() {
        return 0;
    }

    @Override
    public void setUpdateFrequency(int updateFrequency) {
    }

    @Override
    public int getUpdatePeriod() {
        return 0;
    }

    @Override
    public void setUpdatePeriod(int updatePeriod) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MergeResult mergeAndCleanUp(IFeed objectToMerge) {
        Assert.isNotNull((Object)objectToMerge);
        if (this == objectToMerge) {
            Assert.isLegal((this != objectToMerge ? 1 : 0) != 0, (String)("Trying to merge the same feed. This is most likely a mistake: " + objectToMerge));
        }
        IFeed iFeed = objectToMerge;
        synchronized (iFeed) {
            return this.merge(objectToMerge, true);
        }
    }

    private MergeResult merge(IFeed objectToMerge, boolean cleanUp) {
        Assert.isLegal((boolean)this.getLink().toString().equals(objectToMerge.getLink().toString()), (String)"Only feeds with the same link can be merged.");
        MergeResult result = new MergeResult();
        boolean updated = this.processListMergeResult(result, this.mergeNews(objectToMerge.getNews(), cleanUp));
        updated |= this.processListMergeResult(result, this.mergeCategories(objectToMerge.getCategories()));
        updated |= this.processListMergeResult(result, this.mergeAuthor(objectToMerge.getAuthor()));
        updated |= this.processListMergeResult(result, this.mergeImage(objectToMerge.getImage()));
        updated |= !this.simpleFieldsEqual(objectToMerge);
        this.setBase(objectToMerge.getBase());
        this.fCopyright = objectToMerge.getCopyright();
        this.fDescription = objectToMerge.getDescription();
        this.setDocs(objectToMerge.getDocs());
        this.fFormat = objectToMerge.getFormat();
        this.fGenerator = objectToMerge.getGenerator();
        this.setHomepage(objectToMerge.getHomepage());
        this.fLanguage = objectToMerge.getLanguage();
        this.fLastBuildDate = objectToMerge.getLastBuildDate();
        this.fLastModifiedDate = objectToMerge.getLastModifiedDate();
        this.fPublishDate = objectToMerge.getPublishDate();
        this.fTitle = objectToMerge.getTitle();
        this.fTTL = objectToMerge.getTTL();
        this.fWebmaster = objectToMerge.getWebmaster();
        ComplexMergeResult<?> propertiesResult = MergeUtils.mergeProperties(this, objectToMerge);
        if (updated || propertiesResult.isStructuralChange()) {
            result.addUpdatedObject(this);
            result.addAll(propertiesResult);
        }
        return result;
    }

    private boolean simpleFieldsEqual(IFeed feed) {
        return MergeUtils.equals(this.getBase(), feed.getBase()) && MergeUtils.equals(this.fCopyright, feed.getCopyright()) && MergeUtils.equals(this.fDescription, feed.getDescription()) && MergeUtils.equals(this.getDocs(), feed.getDocs()) && MergeUtils.equals(this.fFormat, feed.getFormat()) && MergeUtils.equals(this.fGenerator, feed.getGenerator()) && MergeUtils.equals(this.getHomepage(), feed.getHomepage()) && MergeUtils.equals(this.fLanguage, feed.getLanguage()) && MergeUtils.equals(this.fLastBuildDate, feed.getLastBuildDate()) && MergeUtils.equals(this.fLastModifiedDate, feed.getLastModifiedDate()) && MergeUtils.equals(this.fPublishDate, feed.getPublishDate()) && MergeUtils.equals(this.fTitle, feed.getTitle()) && MergeUtils.equals(this.fTTL, feed.getTTL()) && MergeUtils.equals(this.fWebmaster, feed.getWebmaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MergeResult merge(IFeed objectToMerge) {
        Assert.isNotNull((Object)objectToMerge);
        IFeed iFeed = objectToMerge;
        synchronized (iFeed) {
            return this.merge(objectToMerge, false);
        }
    }

    private ComplexMergeResult<IPerson> mergeAuthor(IPerson author) {
        ComplexMergeResult<IPerson> mergeResult = MergeUtils.merge(this.getAuthor(), author);
        this.fAuthor = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<List<ICategory>> mergeCategories(List<ICategory> categories) {
        Comparator<ICategory> comparator = new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                if (o1.getName() == null ? o2.getName() == null : o1.getName().equals(o2.getName())) {
                    return 0;
                }
                return -1;
            }
        };
        ComplexMergeResult<List<ICategory>> mergeResult = MergeUtils.merge(this.fCategories, categories, comparator, null);
        this.fCategories = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<IImage> mergeImage(IImage image) {
        ComplexMergeResult<IImage> mergeResult = MergeUtils.merge(this.getImage(), image);
        this.fImage = mergeResult.getMergedObject();
        return mergeResult;
    }

    private ComplexMergeResult<List<INews>> mergeNews(List<INews> newsList, boolean cleanUp) {
        List<INews> newsListCopy = this.copyWithoutDuplicates(newsList);
        int[] newsToCleanUp = null;
        int newsToCleanUpSize = 0;
        if (cleanUp) {
            newsToCleanUp = new int[this.fNews.size() / 2];
        }
        ComplexMergeResult<List<INews>> mergeResult = ComplexMergeResult.create(newsListCopy);
        if (SyncUtils.isSynchronized(this.fLinkText)) {
            HashMap<String, INews> mapGuidToIncomingNews = new HashMap<String, INews>(newsListCopy.size());
            int i = 0;
            while (i < newsListCopy.size()) {
                INews news = newsListCopy.get(i);
                if (news.getGuid() != null) {
                    mapGuidToIncomingNews.put(news.getGuid().getValue(), news);
                }
                ++i;
            }
            i = this.fNews.size() - 1;
            while (i >= 0) {
                INews incomingNews;
                INews existingNews = this.fNews.get(i);
                INews iNews = incomingNews = existingNews.getGuid() != null ? (INews)mapGuidToIncomingNews.get(existingNews.getGuid().getValue()) : null;
                if (incomingNews != null) {
                    mergeResult.addAll(existingNews.merge(incomingNews));
                    newsListCopy.remove(incomingNews);
                } else if (newsToCleanUp != null && existingNews.getState() == INews.State.DELETED) {
                    newsToCleanUp = ArrayUtils.ensureCapacity(newsToCleanUp, newsToCleanUpSize + 1);
                    newsToCleanUp[newsToCleanUpSize++] = i;
                }
                --i;
            }
        } else {
            int i = this.fNews.size() - 1;
            while (i >= 0) {
                INews existingNews = this.fNews.get(i);
                int existingNewsIndex = this.findNews(newsListCopy, existingNews);
                if (existingNewsIndex > -1) {
                    mergeResult.addAll(existingNews.merge(newsListCopy.get(existingNewsIndex)));
                    newsListCopy.remove(existingNewsIndex);
                } else if (newsToCleanUp != null && existingNews.getState() == INews.State.DELETED) {
                    newsToCleanUp = ArrayUtils.ensureCapacity(newsToCleanUp, newsToCleanUpSize + 1);
                    newsToCleanUp[newsToCleanUpSize++] = i;
                }
                --i;
            }
        }
        if (newsToCleanUp != null && newsToCleanUp.length > 0) {
            int[] tempNewsToCleanUp = new int[newsToCleanUpSize];
            System.arraycopy(newsToCleanUp, 0, tempNewsToCleanUp, 0, newsToCleanUpSize);
            newsToCleanUp = tempNewsToCleanUp;
            mergeResult.setStructuralChange(true);
            if (newsToCleanUpSize > 20 || newsToCleanUpSize > 5 && this.fNews.size() / newsToCleanUpSize < 5) {
                ArrayUtils.reverse(newsToCleanUp, newsToCleanUpSize);
                int i = 0;
                int c = this.fNews.size();
                int newIndex = 0;
                while (i < c) {
                    if (Arrays.binarySearch(newsToCleanUp, i) < 0) {
                        this.fNews.set(newIndex, this.fNews.get(i));
                        ++newIndex;
                    } else {
                        mergeResult.addRemovedObject(this.fNews.get(i));
                    }
                    ++i;
                }
                int newSize = this.fNews.size() - newsToCleanUpSize;
                int i2 = this.fNews.size() - 1;
                while (i2 >= newSize) {
                    this.fNews.remove(i2);
                    --i2;
                }
            } else {
                int i = 0;
                int c = newsToCleanUpSize;
                while (i < c) {
                    INews news = this.fNews.remove(newsToCleanUp[i]);
                    mergeResult.addRemovedObject(news);
                    ++i;
                }
            }
        }
        for (INews news : newsListCopy) {
            news.setParent(this);
            this.fNews.add(news);
            mergeResult.setStructuralChange(true);
            mergeResult.addUpdatedObject(news);
        }
        return mergeResult;
    }

    private List<INews> copyWithoutDuplicates(List<INews> newsList) {
        if (SyncUtils.isSynchronized(this.fLinkText)) {
            return this.copyWithoutDuplicatesSynced(newsList);
        }
        ArrayList<INews> newsListCopy = new ArrayList<INews>(newsList.size());
        for (INews outerNews : newsList) {
            boolean containsNews = false;
            for (INews innerNews : newsListCopy) {
                if (!innerNews.isEquivalent(outerNews)) continue;
                containsNews = true;
                break;
            }
            if (containsNews) continue;
            newsListCopy.add(outerNews);
        }
        return newsListCopy;
    }

    private List<INews> copyWithoutDuplicatesSynced(List<INews> newsList) {
        HashSet<String> guids = new HashSet<String>(newsList.size());
        ArrayList<INews> newsListCopy = new ArrayList<INews>(newsList.size());
        for (INews news : newsList) {
            IGuid guid = news.getGuid();
            if (guid == null || guids.contains(guid.getValue())) continue;
            guids.add(guid.getValue());
            newsListCopy.add(news);
        }
        return newsListCopy;
    }

    @Override
    public synchronized boolean removeNews(INews news) {
        return this.fNews.remove(news);
    }

    @Override
    public FeedReference toReference() {
        return new FeedReference(this.getIdAsPrimitive());
    }

    @Override
    public synchronized String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\n\n\n****************************** Feed ******************************");
        str.append("\nID: ").append(this.getId());
        str.append("\nLink: ").append(this.getLink());
        if (this.getTitle() != null) {
            str.append("\nTitle: ").append(this.getTitle());
        }
        return str.toString();
    }

    public synchronized String toLongString() {
        StringBuilder str = new StringBuilder();
        str.append("\n\n\n****************************** Feed ******************************");
        str.append("\nID: ").append(this.getId());
        str.append("\nFormat: ").append(this.getFormat());
        str.append("\nLink: ").append(this.getLink());
        if (this.getBase() != null) {
            str.append("\nBase URI: ").append(this.getBase());
        }
        if (this.getTitle() != null) {
            str.append("\nTitle: ").append(this.getTitle());
        }
        if (this.getDescription() != null) {
            str.append("\nDescription: ").append(this.getDescription());
        }
        if (this.getHomepage() != null) {
            str.append("\nHomepage: ").append(this.getHomepage());
        }
        if (this.getLanguage() != null) {
            str.append("\nLanguage: ").append(this.getLanguage());
        }
        if (this.getImage() != null) {
            str.append("\nImage: ").append(this.getImage());
        }
        if (this.getCopyright() != null) {
            str.append("\nCopyright: ").append(this.getCopyright());
        }
        if (this.getPublishDate() != null) {
            str.append("\nPublish Date: ").append(DateFormat.getDateTimeInstance().format(this.getPublishDate()));
        }
        if (this.getLastBuildDate() != null) {
            str.append("\nLast Build: ").append(DateFormat.getDateTimeInstance().format(this.getLastBuildDate()));
        }
        if (this.getLastModifiedDate() != null) {
            str.append("\nLast Modified: ").append(DateFormat.getDateTimeInstance().format(this.getLastModifiedDate()));
        }
        str.append("\nCategories: ").append(this.getCategories());
        if (this.getGenerator() != null) {
            str.append("\nGenerator: ").append(this.getGenerator());
        }
        if (this.getTTL() != 0) {
            str.append("\nTTL: ").append(this.getTTL());
        }
        if (this.getDocs() != null) {
            str.append("\nDocs: ").append(this.getDocs());
        }
        if (this.getAuthor() != null) {
            str.append("\nAuthor: ").append(this.getAuthor());
        }
        if (this.getWebmaster() != null) {
            str.append("\nWebmaster: ").append(this.getWebmaster());
        }
        str.append("\nProperties: ").append(this.getProperties());
        str.append("\n\nNews: ").append(this.getNews());
        str.append("\n******************\n");
        return str.toString();
    }
}

