/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.reference.ModelReference;

public final class Preference
extends AbstractEntity
implements IPreference {
    private String fKey;
    private IPreference.Type fType;
    private String[] fValues;
    private transient Object fCachedValues;

    protected Preference() {
    }

    public Preference(String key) {
        Assert.isNotNull((Object)key, (String)"key cannot be null");
        this.fKey = key;
    }

    public final synchronized String getKey() {
        return this.fKey;
    }

    public final synchronized IPreference.Type getType() {
        return this.fType;
    }

    public final synchronized Boolean getBoolean() {
        boolean[] values = this.getBooleans();
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final synchronized boolean[] getBooleans() {
        if (this.fValues == null) {
            return null;
        }
        this.checkType(IPreference.Type.BOOLEAN);
        boolean[] cachedValues = (boolean[])this.fCachedValues;
        if (this.fCachedValues != null) {
            return this.copyOf(cachedValues);
        }
        cachedValues = new boolean[this.fValues.length];
        int index = 0;
        String[] stringArray = this.fValues;
        int n = this.fValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            cachedValues[index++] = Boolean.valueOf(value);
            ++n2;
        }
        this.fCachedValues = cachedValues;
        return this.copyOf(cachedValues);
    }

    private void checkType(IPreference.Type type) {
        if (this.fType != type) {
            Assert.isLegal((this.fType == type ? 1 : 0) != 0, (String)("The type of the Preference is not of the expected type. It should be: " + (Object)((Object)this.fType) + ", but it is: " + (Object)((Object)type)));
        }
    }

    private boolean[] copyOf(boolean[] original) {
        boolean[] copy = new boolean[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    private int[] copyOf(int[] original) {
        int[] copy = new int[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    private long[] copyOf(long[] original) {
        long[] copy = new long[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    private String[] copyOf(String[] original) {
        String[] copy = new String[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    public final synchronized Integer getInteger() {
        int[] values = this.getIntegers();
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final synchronized int[] getIntegers() {
        if (this.fValues == null) {
            return null;
        }
        this.checkType(IPreference.Type.INTEGER);
        int[] cachedValues = (int[])this.fCachedValues;
        if (this.fCachedValues != null) {
            return this.copyOf(cachedValues);
        }
        cachedValues = new int[this.fValues.length];
        int index = 0;
        String[] stringArray = this.fValues;
        int n = this.fValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            cachedValues[index++] = Integer.valueOf(value);
            ++n2;
        }
        this.fCachedValues = cachedValues;
        return this.copyOf(cachedValues);
    }

    public final synchronized Long getLong() {
        long[] values = this.getLongs();
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final synchronized long[] getLongs() {
        if (this.fValues == null) {
            return null;
        }
        this.checkType(IPreference.Type.LONG);
        long[] cachedValues = (long[])this.fCachedValues;
        if (this.fCachedValues != null) {
            return this.copyOf(cachedValues);
        }
        cachedValues = new long[this.fValues.length];
        int index = 0;
        String[] stringArray = this.fValues;
        int n = this.fValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            cachedValues[index++] = Long.valueOf(value);
            ++n2;
        }
        this.fCachedValues = cachedValues;
        return this.copyOf(cachedValues);
    }

    public final synchronized String getString() {
        String[] values = this.getStrings();
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final synchronized String[] getStrings() {
        if (this.fValues == null) {
            return null;
        }
        this.checkType(IPreference.Type.STRING);
        return this.copyOf(this.fValues);
    }

    public final synchronized void putStrings(String ... strings) {
        String[] cachedValues;
        if (strings == null) {
            this.clear();
            return;
        }
        this.fType = IPreference.Type.STRING;
        this.fCachedValues = cachedValues = this.copyOf(strings);
        this.fValues = cachedValues;
    }

    public final synchronized void putLongs(long ... longs) {
        if (longs == null) {
            this.clear();
            return;
        }
        this.fType = IPreference.Type.LONG;
        long[] cachedValues = this.copyOf(longs);
        this.fCachedValues = cachedValues;
        this.fValues = new String[cachedValues.length];
        int index = 0;
        long[] lArray = cachedValues;
        int n = cachedValues.length;
        int n2 = 0;
        while (n2 < n) {
            long cachedValue = lArray[n2];
            this.fValues[index++] = String.valueOf(cachedValue);
            ++n2;
        }
    }

    public final synchronized void putIntegers(int ... integers) {
        if (integers == null) {
            this.clear();
            return;
        }
        this.fType = IPreference.Type.INTEGER;
        int[] cachedValues = this.copyOf(integers);
        this.fCachedValues = cachedValues;
        this.fValues = new String[cachedValues.length];
        int index = 0;
        int[] nArray = cachedValues;
        int n = cachedValues.length;
        int n2 = 0;
        while (n2 < n) {
            int cachedValue = nArray[n2];
            this.fValues[index++] = String.valueOf(cachedValue);
            ++n2;
        }
    }

    public final synchronized void putBooleans(boolean ... booleans) {
        if (booleans == null) {
            this.clear();
            return;
        }
        this.fType = IPreference.Type.BOOLEAN;
        boolean[] cachedValues = this.copyOf(booleans);
        this.fCachedValues = cachedValues;
        this.fValues = new String[cachedValues.length];
        int index = 0;
        boolean[] blArray = cachedValues;
        int n = cachedValues.length;
        int n2 = 0;
        while (n2 < n) {
            boolean cachedValue = blArray[n2];
            this.fValues[index++] = String.valueOf(cachedValue);
            ++n2;
        }
    }

    public final synchronized void clear() {
        this.fValues = null;
        this.fType = null;
        this.fCachedValues = null;
    }

    public ModelReference toReference() {
        throw new UnsupportedOperationException();
    }
}

