/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.internal.persist.SortedLongArrayList;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.reference.NewsReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityIdsByEventType
extends Persistable
implements IPersistable {
    private static final int DEFAULT_CAPACITY = 5;
    private LongArrayList fPersistedEntities;
    private LongArrayList fUpdatedEntities;
    private LongArrayList fRemovedEntities;

    public EntityIdsByEventType() {
    }

    public EntityIdsByEventType(EntityIdsByEventType o) {
        this.fPersistedEntities = new LongArrayList(o.fPersistedEntities);
        this.fUpdatedEntities = new LongArrayList(o.fUpdatedEntities);
        this.fRemovedEntities = new LongArrayList(o.fRemovedEntities);
    }

    public EntityIdsByEventType(boolean sorted) {
        if (sorted) {
            this.fPersistedEntities = new SortedLongArrayList(5);
            this.fUpdatedEntities = new SortedLongArrayList(5);
            this.fRemovedEntities = new SortedLongArrayList(5);
        } else {
            this.fPersistedEntities = new LongArrayList(5);
            this.fUpdatedEntities = new LongArrayList(5);
            this.fRemovedEntities = new LongArrayList(5);
        }
    }

    public synchronized <T extends ModelEvent> void addAllEntities(Collection<T> persistedEntity, Collection<T> updatedEntity, Collection<T> removedEntity) {
        EntityIdsByEventType.addAllEntities(this.fPersistedEntities, persistedEntity);
        EntityIdsByEventType.addAllEntities(this.fUpdatedEntities, updatedEntity);
        EntityIdsByEventType.addAllEntities(this.fRemovedEntities, removedEntity);
    }

    private static void addAllEntities(LongArrayList entityIds, Collection<? extends ModelEvent> events) {
        for (ModelEvent modelEvent : events) {
            entityIds.add(modelEvent.getEntity().getId());
        }
    }

    public synchronized void removeAll(Collection<ModelEvent> persistedEntity, Collection<ModelEvent> updatedEntity, Collection<ModelEvent> removedEntity) {
        EntityIdsByEventType.removeAllEntities(this.fPersistedEntities, persistedEntity);
        EntityIdsByEventType.removeAllEntities(this.fUpdatedEntities, updatedEntity);
        EntityIdsByEventType.removeAllEntities(this.fRemovedEntities, removedEntity);
    }

    private static void removeAllEntities(LongArrayList entityIds, Collection<ModelEvent> events) {
        for (ModelEvent event : events) {
            entityIds.removeByElement(event.getEntity().getId());
        }
    }

    public synchronized List<NewsReference> getPersistedEntityRefs() {
        return EntityIdsByEventType.getEntityIds(this.fPersistedEntities);
    }

    public synchronized List<NewsReference> getUpdatedEntityRefs() {
        return EntityIdsByEventType.getEntityIds(this.fUpdatedEntities);
    }

    public synchronized List<NewsReference> getRemovedEntityRefs() {
        return EntityIdsByEventType.getEntityIds(this.fRemovedEntities);
    }

    private static List<NewsReference> getEntityIds(LongArrayList list) {
        ArrayList<NewsReference> newsRef = new ArrayList<NewsReference>(list.size());
        int i = 0;
        int c = list.size();
        while (i < c) {
            newsRef.add(new NewsReference(list.get(i)));
            ++i;
        }
        return newsRef;
    }

    public synchronized void removeAll(LongArrayList addedEntityIds, LongArrayList updatedEntityIds, LongArrayList removedEntityIds) {
        this.fPersistedEntities.removeAll(addedEntityIds);
        this.fUpdatedEntities.removeAll(updatedEntityIds);
        this.fRemovedEntities.removeAll(removedEntityIds);
    }

    public synchronized void addPersistedEntity(IEntity entity) {
        this.fPersistedEntities.add(entity.getId());
    }

    public synchronized void addUpdatedEntity(IEntity entity) {
        this.fUpdatedEntities.add(entity.getId());
    }

    public synchronized void addRemovedEntity(IEntity entity) {
        this.fRemovedEntities.add(entity.getId());
    }

    public synchronized void addRemovedEntityId(long id) {
        this.fRemovedEntities.add(id);
    }

    public synchronized LongArrayList getRemovedEntityIds() {
        return this.fRemovedEntities;
    }

    public synchronized LongArrayList getPersistedEntityIds() {
        return this.fPersistedEntities;
    }

    public synchronized LongArrayList getUpdatedEntityIds() {
        return this.fUpdatedEntities;
    }

    public synchronized void clear() {
        this.fPersistedEntities.clear();
        this.fUpdatedEntities.clear();
        this.fRemovedEntities.clear();
    }

    public synchronized void compact() {
        this.fPersistedEntities.compact();
        this.fUpdatedEntities.compact();
        this.fRemovedEntities.compact();
    }

    public synchronized int size() {
        int size = this.fPersistedEntities.size() + this.fUpdatedEntities.size() + this.fRemovedEntities.size();
        return size;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fPersistedEntities.hashCode();
        result = 31 * result + this.fRemovedEntities.hashCode();
        result = 31 * result + this.fUpdatedEntities.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityIdsByEventType other = (EntityIdsByEventType)obj;
        return this.fPersistedEntities.equals(other.fPersistedEntities) && this.fRemovedEntities.equals(other.fRemovedEntities) && this.fUpdatedEntities.equals(other.fUpdatedEntities);
    }
}

