/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist.reference;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.service.PersistenceException;

public final class FeedLinkReference {
    private final String fLinkText;

    public FeedLinkReference(URI link) {
        Assert.isNotNull((Object)link, (String)"link");
        this.fLinkText = link.toString();
    }

    public final URI getLink() {
        try {
            return new URI(this.fLinkText);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getLinkAsText() {
        return this.fLinkText;
    }

    public final IFeed resolve() throws PersistenceException {
        return Owl.getPersistenceService().getDAOService().getFeedDAO().load(this.getLink());
    }

    public boolean references(IFeed feed) {
        Assert.isNotNull((Object)feed);
        String entityLinkText = feed.getLink().toString();
        return entityLinkText == null ? false : this.fLinkText.equals(entityLinkText);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FeedLinkReference other = (FeedLinkReference)obj;
        return this.fLinkText.equals(other.fLinkText);
    }

    public int hashCode() {
        return this.fLinkText.hashCode();
    }

    public String toString() {
        String name = super.toString();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1, name.length());
        }
        return String.valueOf(name) + " (Link = " + this.fLinkText + ")";
    }
}

